/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.planviewer.planlist;

import at.grid.cms.element.CmsElement;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsLocation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CreateBuildingPanel
extends JPanel {
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle");
    private String DIALOG_CODE = "createbuilding";
    long buildingId = -1L;
    private JButton btnBuildingDetails;
    private JButton btnCancel;
    private JButton btnSaveAndClsoe;
    private JTextField fieldBuildingTitle;
    private JLabel jLabel1;

    public CreateBuildingPanel() {
        this.initComponents();
    }

    private boolean createBuilding(boolean edit) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        String title = this.fieldBuildingTitle.getText();
        if (!edit && title.isEmpty()) {
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("CreateBuildingPanel.buildingTitleEmpty.text"));
            return false;
        }
        CmsLocation location = (CmsLocation)project.createElement("location");
        location.setAttributeValue("title", title);
        location.setAsBuilding();
        if (edit) {
            new LocationObservationDialog().editLocation((CmsElement)location);
        } else {
            location.save();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype("observation").setId(location.getId()));
        }
        if (location.isSaved()) {
            if (edit && ((title = location.getAttributeValue("title")) == null || title.isEmpty())) {
                location.setAttributeValue("title", this.bundle.getString("CreateBuildingPanel.noTitle.text"));
                location.save();
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype("observation").setId(location.getId()));
            }
            this.buildingId = location.getId();
            project.updateCurrentEvent();
            project.getSelectionManager().setSelectedLocation(location.getId(), true, (Object)this);
            project.createActionLog("building_create", location.getId(), "");
        }
        return true;
    }

    public boolean isBuildingCreated() {
        return this.buildingId >= 0L;
    }

    public long getBuildingId() {
        return this.buildingId;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.fieldBuildingTitle = new JTextField();
        this.btnBuildingDetails = new JButton();
        this.btnSaveAndClsoe = new JButton();
        this.btnCancel = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CreateBuildingPanel.class, (String)"CreateBuildingPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.fieldBuildingTitle.setFont(THEMIS.fontTextfield);
        this.fieldBuildingTitle.setText(NbBundle.getMessage(CreateBuildingPanel.class, (String)"CreateBuildingPanel.fieldBuildingTitle.text"));
        this.fieldBuildingTitle.setMinimumSize(new Dimension(200, 24));
        this.fieldBuildingTitle.setPreferredSize(new Dimension(200, 24));
        this.fieldBuildingTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateBuildingPanel.this.fieldBuildingTitleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fieldBuildingTitle, gridBagConstraints);
        this.btnBuildingDetails.setFont(THEMIS.fontButton);
        this.btnBuildingDetails.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnBuildingDetails, (String)NbBundle.getMessage(CreateBuildingPanel.class, (String)"CreateBuildingPanel.btnBuildingDetails.text"));
        this.btnBuildingDetails.setBorder(new SoftBevelBorder(0));
        this.btnBuildingDetails.setPreferredSize(new Dimension(190, 35));
        this.btnBuildingDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateBuildingPanel.this.btnBuildingDetailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnBuildingDetails, gridBagConstraints);
        this.btnSaveAndClsoe.setFont(THEMIS.fontButton);
        this.btnSaveAndClsoe.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveAndClsoe, (String)NbBundle.getMessage(CreateBuildingPanel.class, (String)"CreateBuildingPanel.btnSaveAndClsoe.text"));
        this.btnSaveAndClsoe.setBorder(new SoftBevelBorder(0));
        this.btnSaveAndClsoe.setPreferredSize(new Dimension(190, 35));
        this.btnSaveAndClsoe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateBuildingPanel.this.btnSaveAndClsoeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSaveAndClsoe, gridBagConstraints);
        this.btnCancel.setFont(THEMIS.fontButton);
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(CreateBuildingPanel.class, (String)"CreateBuildingPanel.btnCancel.text"));
        this.btnCancel.setBorder(new SoftBevelBorder(0));
        this.btnCancel.setPreferredSize(new Dimension(190, 35));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateBuildingPanel.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnCancel, gridBagConstraints);
    }

    private void btnSaveAndClsoeActionPerformed(ActionEvent evt) {
        if (this.createBuilding(false)) {
            this.closeDialog();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void btnBuildingDetailsActionPerformed(ActionEvent evt) {
        this.createBuilding(true);
        this.closeDialog();
    }

    private void fieldBuildingTitleActionPerformed(ActionEvent evt) {
        if (this.createBuilding(false)) {
            this.closeDialog();
        }
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(ThemisApplication.getInstance().getProject().getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, false);
        dlg.setVisible(true);
    }

    private void closeDialog() {
        JDialog parent = (JDialog)this.getRootPane().getParent();
        parent.dispose();
    }
}

