/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.planviewer.planlist;

import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.storage.DataRecord;
import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ThemisActions;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.api.Accordion;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.planviewer.planlist.CreateBuildingPanel;
import at.grid.themis.application.tutorial.Assistant;
import at.grid.themis.application.tutorial.Step;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsPlanCalibration;
import at.grid.themis.ontology.element.CmsPlanfile;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ManagerTopComponent", persistenceType=0)
public final class ManagerTopComponent
extends TopComponent
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle");
    ArrayList<CmsElementSummary> plans = new ArrayList();
    Accordion accordion;
    DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    DefaultMutableTreeNode noBuildingRoot = new DefaultMutableTreeNode();
    DefaultTreeModel treemodel = new DefaultTreeModel(this.root);
    ImageIcon iconPlan = new ImageIcon(ManagerTopComponent.class.getResource("/at/grid/themis/application/media/plan.gif"));
    ImageIcon iconBuilding = new ImageIcon(ManagerTopComponent.class.getResource("/at/grid/themis/application/media/building.gif"));
    int calibPoint = 0;
    double calibPlanX1;
    double calibPlanY1;
    double calibPlanX2;
    double calibPlanY2;
    CmsElementSummary currentBuilding = null;
    CmsElementSummary currentPlan = null;
    CmsElementSummary currentPlanSelection = null;
    CmsPlan plan;
    private boolean fldCalibMethodTrigger = true;
    private ItemListener planVersionChanged;
    private JButton btnAddBuilding;
    private JButton btnAddPlan;
    private JButton btnCalibPlan1;
    private JButton btnCalibPlan2;
    private JButton btnCalibRemove;
    private JButton btnCalibSave;
    private JButton btnCreateNewVersion;
    private JButton btnDeleteVersion;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnUserAction;
    private JPanel calibPanel;
    private JComboBox<String> fldCalibMethod;
    private JTextField fldCalibPlan1;
    private JTextField fldCalibPlan2;
    private JTextField fldCalibPlanTitle;
    private JTextArea fldCalibWorldfile;
    private JTextField fldCalibX1;
    private JTextField fldCalibX2;
    private JTextField fldCalibY1;
    private JTextField fldCalibY2;
    private JComboBox<CmsElementSummary> fldPlanVersions;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JLabel lblNoDelete;
    private JLabel lblPlanversionCalibInfo;
    private JLabel lblPlanversionCalibInfo1;
    private JPanel mainPanel;
    private JPanel panelCalibCoord1;
    private JPanel panelCalibCoord2;
    private JPanel panelCalibMain;
    private JPanel panelCalibPoints;
    private JPanel panelCalibWorldfile;
    private JPanel panelTree;
    private JScrollPane planScrollPanel1;
    private JTree tree;

    public ManagerTopComponent() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + ((Object)((Object)this)).getClass().getName() + " ...");
        THEMIS.getLicense();
        this.initComponents();
        this.setName(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("CTL_ManagerTopComponent"));
        this.setToolTipText(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("HINT_ManagerTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        this.planVersionChanged = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ManagerTopComponent.this.changePlanVersion();
            }
        };
        this.initialiseAccordion();
        this.updateActions();
        this.tree.setCellRenderer(new PlanTreeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRowHeight((int)((double)this.tree.getFont().getSize() * 1.8));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        new DragScrollHandler(this.tree, true, true);
        this.updateActions();
        ThemisDropTargetListener dndListener = new ThemisDropTargetListener(true, false, new String[]{"jpg", "pdf", "jpeg", "png"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
            }

            @Override
            public boolean dropFileAction(List<File> files, DropTargetDropEvent event) {
                ManagerTopComponent.this.addPlan(files);
                return true;
            }
        };
        new DropTarget(this.tree, dndListener);
        ThemisActionProvider.getInstance().register(this);
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + ((Object)((Object)this)).getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void initialiseAccordion() {
        this.mainPanel.removeAll();
        this.accordion = new Accordion();
        this.accordion.addBar(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.accMapView.text"), this.panelTree);
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            this.accordion.addBar(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.accCalibrate.text"), this.calibPanel);
        }
        this.mainPanel.add(this.accordion);
    }

    private void showActionMenu() {
        JMenuItem item;
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        boolean buildingSelected = this.currentBuilding != null;
        boolean planSelected = this.currentPlanSelection != null;
        this.btnEdit.setEnabled(buildingSelected || planSelected);
        this.btnRemove.setEnabled(buildingSelected || planSelected);
        JPopupMenu menu = new JPopupMenu("Optionen");
        if (planSelected && !this.plan.isCalibrated()) {
            List planfiles;
            item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.plan.rotate-right"), Color.WHITE, false, null);
            item.addActionListener(e2 -> this.rotatePlan(90, true));
            menu.add(item);
            item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.plan.rotate-left"), Color.WHITE, false, null);
            item.addActionListener(e2 -> this.rotatePlan(-90, true));
            menu.add(item);
            int numPlanVersions = 1;
            if (this.plan != null && (planfiles = this.plan.getPlanfiles()) != null) {
                numPlanVersions = planfiles.size();
            }
            if (numPlanVersions > 1) {
                item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.plan.rotate-right-without-locs"), Color.WHITE, false, null);
                item.addActionListener(e2 -> this.rotatePlan(90, false));
                menu.add(item);
                item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.plan.rotate-left-without-locs"), Color.WHITE, false, null);
                item.addActionListener(e2 -> this.rotatePlan(-90, false));
                menu.add(item);
            }
        }
        if (planSelected) {
            item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.plan.move-up"), Color.WHITE, false, null);
            item.addActionListener(e2 -> this.updatePlanSort(-1));
            menu.add(item);
            item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.plan.move-down"), Color.WHITE, false, null);
            item.addActionListener(e2 -> this.updatePlanSort(1));
            menu.add(item);
        }
        int c = menu.getComponentCount();
        menu.show(this.btnUserAction, this.btnUserAction.getWidth(), 0);
    }

    public void onAction(ThemisAction action) {
        if (action.getSource() == this) {
            return;
        }
        switch (action.getAction()) {
            case 100: {
                if (((Object)((Object)this)).equals(action.getSource())) break;
                this.loadPlans(action.getId());
                break;
            }
            case 102: {
                if (((Object)((Object)this)).equals(action.getSource())) break;
                this.setTreeSelection(action.getId());
                break;
            }
            case 651: {
                CmsElement ele;
                if (action.getId() <= 0L || !(ele = this.project.loadElement(action.getId(), this.project.getUser())).getElementcode().equals("location") || !((CmsLocation)ele).isBuilding()) break;
                this.loadPlans();
                if (this.plan != null) {
                    this.plan.reload();
                }
                this.updateActions();
                String treeState = this.project.getProjectProperty("system.tree.plan", "");
                THEMIS.applyTreeExpansionState(this.tree, treeState);
                this.applyTreeSelection();
                break;
            }
            case 501: {
                this.loadPlans();
                if (this.plan != null) {
                    this.plan.reload();
                }
                this.updateActions();
                String treeState = this.project.getProjectProperty("system.tree.plan", "");
                THEMIS.applyTreeExpansionState(this.tree, treeState);
                this.applyTreeSelection();
                break;
            }
            case 1101: {
                this.loadPlans();
                this.repaint();
                break;
            }
            case 1100: {
                this.loadPlans();
                String loadedPlan = this.project.getProjectProperty("project.plan.loaded", "noPlan");
                if (!"noPlan".equals(loadedPlan)) {
                    long id = Long.parseLong(loadedPlan);
                    this.project.setCurrentPlanId(Long.parseLong(loadedPlan));
                    this.updateActions();
                    this.setTreeSelection(id);
                } else {
                    this.updateActions();
                }
                String treeState = this.project.getProjectProperty("system.tree.plan", "");
                THEMIS.applyTreeExpansionState(this.tree, treeState);
                break;
            }
            case 702: 
            case 2000: {
                this.loadPlans();
                break;
            }
            case 1201: {
                if (this.calibPoint <= 0) break;
                SimpleGeometry geom = (SimpleGeometry)action.getReference();
                if (geom != null && geom.getPoint() != null) {
                    String coord = Util.round((double)geom.getPoint().getX(), (int)2) + " / " + Util.round((double)geom.getPoint().getY(), (int)2);
                    if (this.calibPoint == 1) {
                        this.calibPlanX1 = geom.getPoint().getX();
                        this.calibPlanY1 = geom.getPoint().getY();
                        this.fldCalibPlan1.setText(coord);
                    } else if (this.calibPoint == 2) {
                        this.calibPlanX2 = geom.getPoint().getX();
                        this.calibPlanY2 = geom.getPoint().getY();
                        this.fldCalibPlan2.setText(coord);
                    }
                    this.updateCalibPoints(true);
                } else {
                    this.updateCalibrationPanel();
                }
                this.calibPoint = 0;
                this.updateCalibrationSaveButton();
                break;
            }
            case 1300: {
                this.updateActions();
                break;
            }
            default: {
                if (!action.dealsWith("plan")) break;
                long idSel = -1L;
                if (this.currentPlanSelection != null) {
                    idSel = this.currentPlanSelection.getId();
                }
                this.loadPlans();
                if (this.plan != null) {
                    this.plan.reload();
                }
                this.updateActions();
                String treeState = this.project.getProjectProperty("system.tree.plan", "");
                THEMIS.applyTreeExpansionState(this.tree, treeState);
                if (idSel <= 0L) break;
                this.setTreeSelection(idSel);
            }
        }
    }

    private void updatePlan() {
        long planid = -1L;
        if (this.currentPlan != null) {
            planid = this.currentPlan.getId();
        }
        if (planid > 0L) {
            if (this.plan == null || this.plan.getId() != planid) {
                this.plan = (CmsPlan)this.project.loadElement(planid, this.project.getUser());
            }
        } else {
            this.plan = null;
        }
    }

    private void loadPlans() {
        this.loadPlans(-1L);
    }

    public void reloadPlans(long id) {
        this.loadPlans(id);
    }

    private void loadPlans(long id) {
        if (this.project != null && this.project.isOpen()) {
            DefaultMutableTreeNode nobuilding;
            DefaultMutableTreeNode selectedNode = null;
            ArrayList plans = this.project.getPlans();
            ArrayList buildings = this.project.getBuildings();
            this.root.removeAllChildren();
            String rootName = this.project.getProjectElement().getTitle();
            if (rootName == null || "".equals(rootName)) {
                rootName = this.project.getProjectFolder().getName();
            }
            this.root.setUserObject(rootName);
            ArrayList<Long> ids = new ArrayList<Long>();
            if (this.allowBuildings()) {
                for (CmsElementSummary ele : buildings) {
                    DefaultMutableTreeNode building = new DefaultMutableTreeNode(ele);
                    this.root.add(building);
                    if (ele.getId() == id) {
                        selectedNode = building;
                    }
                    ArrayList buildingPlans = this.project.getPlansForBuilding(ele.getId());
                    for (CmsElementSummary buildingPlan : buildingPlans) {
                        DefaultMutableTreeNode plannode = new DefaultMutableTreeNode(buildingPlan);
                        building.add(plannode);
                        if (ele.getId() == id) {
                            selectedNode = plannode;
                        }
                        ids.add(buildingPlan.getId());
                    }
                }
            }
            this.noBuildingRoot = nobuilding = new DefaultMutableTreeNode(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.withoutBuilding.text"));
            if (this.allowBuildings()) {
                this.root.add(nobuilding);
            } else {
                this.noBuildingRoot = this.root;
            }
            ArrayList plansWithoutBuilding = this.project.getPlansForBuilding(-1L);
            for (CmsElementSummary ele : plans) {
                if (ids.contains(ele.getId())) continue;
                DefaultMutableTreeNode plannode = new DefaultMutableTreeNode(ele);
                this.noBuildingRoot.add(plannode);
                if (ele.getId() != id) continue;
                selectedNode = plannode;
            }
            if (this.noBuildingRoot.isLeaf()) {
                this.noBuildingRoot.removeFromParent();
            }
            this.treemodel.reload();
            if (selectedNode != null) {
                this.tree.setSelectionPath(new TreePath(selectedNode.getPath()));
            }
        } else {
            this.root.removeAllChildren();
            this.root.setUserObject(this.project.getResourceText("plantree.noproject", this.app.getLocale()));
            this.treemodel.reload();
        }
        String treeState = this.project.getProjectProperty("system.tree.plan", "");
        THEMIS.applyTreeExpansionState(this.tree, treeState);
    }

    private void setTreeSelection(long idPlan) {
        DefaultMutableTreeNode selNode = this.getTreeSelectionNode();
        Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object o = node.getUserObject();
            if (!(o instanceof CmsElementSummary) || ((CmsElementSummary)o).getId() != idPlan) continue;
            if (node != selNode) {
                this.tree.setSelectionPath(new TreePath(node.getPath()));
            }
            return;
        }
    }

    public DefaultMutableTreeNode getTreeSelectionNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            return node;
        }
        return null;
    }

    private void applyTreeSelection() {
        DefaultMutableTreeNode node = this.getTreeSelectionNode();
        if (node != null) {
            boolean isPlan = false;
            Object sel = node.getUserObject();
            if (node == this.root) {
                this.currentBuilding = null;
                this.currentPlanSelection = null;
            } else if (sel instanceof String) {
                this.currentBuilding = null;
                this.currentPlanSelection = null;
            } else if ("location".equals(((CmsElementSummary)sel).getElementcode())) {
                this.currentBuilding = (CmsElementSummary)sel;
                this.currentPlanSelection = null;
            } else {
                this.currentPlanSelection = this.currentPlan = (CmsElementSummary)sel;
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                if (parent != null && parent.getUserObject() instanceof CmsElementSummary) {
                    this.currentBuilding = (CmsElementSummary)parent.getUserObject();
                }
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(this.currentPlanSelection.getId()).from((Object)this, "plan selected in planlist"));
                isPlan = true;
            }
            this.updatePlan();
            this.updateActions();
        }
    }

    private void updateActions() {
        this.btnAddBuilding.setEnabled(false);
        this.btnAddPlan.setEnabled(false);
        if (!this.project.isOpen()) {
            return;
        }
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        boolean enabledPro = !ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL);
        boolean isPlan = this.currentPlanSelection != null;
        this.btnAddBuilding.setEnabled(enabledPro);
        this.btnAddPlan.setEnabled(true);
        if (isPlan) {
            List planfiles;
            boolean numPlanVersions = true;
            if (this.plan != null && (planfiles = this.plan.getPlanfiles()) != null) {
                int n = planfiles.size();
            }
        }
        this.updateCalibrationPanel();
    }

    private void updatePlanSort(int step) {
        boolean isPlan;
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        boolean bl = isPlan = this.currentPlanSelection != null;
        if (!isPlan) {
            return;
        }
        DefaultMutableTreeNode node = this.getTreeSelectionNode();
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        int idx = parent.getIndex(node);
        int idxNew = idx + step;
        if (idxNew >= 0 && idxNew < parent.getChildCount()) {
            Object obj1 = ((DefaultMutableTreeNode)parent.getChildAt(idx)).getUserObject();
            Object obj2 = ((DefaultMutableTreeNode)parent.getChildAt(idxNew)).getUserObject();
            ((DefaultMutableTreeNode)parent.getChildAt(idx)).setUserObject(obj2);
            ((DefaultMutableTreeNode)parent.getChildAt(idxNew)).setUserObject(obj1);
            for (int ii = 0; ii < parent.getChildCount(); ++ii) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)parent.getChildAt(ii);
                CmsElementSummary ele = (CmsElementSummary)n.getUserObject();
                this.project.getDatastorage().executeUpdate("UPDATE tdtaElePlan SET sort=" + ii + " WHERE idelement=" + ele.getId(), true);
                this.project.getDatastorage().setElementLastEdit(ele.getId(), this.project.getUser());
            }
            this.treemodel.nodeChanged(parent.getChildAt(idx));
            this.treemodel.nodeChanged(parent.getChildAt(idxNew));
            TreeNode selNode = parent.getChildAt(idxNew);
            Object[] selPath = ((DefaultMutableTreeNode)selNode).getPath();
            this.tree.setSelectionPath(new TreePath(selPath));
            ThemisApplication.getInstance().getProject().createActionLog("plan_sort", this.currentPlanSelection.getId(), "direction: " + (step < 0 ? "up" : "down"));
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SORT_CHANGED);
        }
    }

    private void rotatePlan(int angle, boolean withLocations) {
        boolean isPlan;
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        boolean bl = isPlan = this.currentPlanSelection != null;
        if (!isPlan) {
            return;
        }
        DefaultMutableTreeNode node = this.getTreeSelectionNode();
        if (node == null) {
            return;
        }
        if (this.plan != null) {
            long currentPlanfile = this.plan.getCurrentPlanfileId();
            ArrayList<CmsPlanfile> planfiles = new ArrayList<CmsPlanfile>();
            if (withLocations) {
                for (CmsElementSummary pf : this.plan.getPlanfiles()) {
                    planfiles.add((CmsPlanfile)pf.getElement());
                }
            } else {
                planfiles.add(this.plan.getCurrentPlanfileElement());
            }
            if (planfiles.size() > 0) {
                ThemisTaskWithDialog.createTaskWithCounter("Der Plan wird rotiert ...", ph -> {
                    int counter = 0;
                    int maxcounter = planfiles.size();
                    ph.switchToDeterminate(maxcounter);
                    Notification notify = THEMIS.notify(1, this.project.getResourceText("plan.rotate.title"), this.project.getResourceText("plan.rotate.msg"));
                    ph.setDisplayName(this.project.getResourceText("plan.rotate-progress.title"));
                    try {
                        int curHeight = 0;
                        int curWidth = 0;
                        for (CmsPlanfile planfile : planfiles) {
                            ph.progress(this.project.getResourceText("plan.rotate-progress.msg") + " (" + counter + "/" + maxcounter + ")", counter++);
                            File imagefile = planfile.getUploadAttribute("image").getFirstUploadItemFile();
                            BufferedImage imageOrig = ImageIO.read(imagefile);
                            int height = imageOrig.getHeight();
                            int width = imageOrig.getWidth();
                            BufferedImage image = new BufferedImage(height, width, imageOrig.getType());
                            AffineTransform at = new AffineTransform();
                            at.translate(height / 2, width / 2);
                            at.rotate(Math.toRadians(angle));
                            at.translate(-width / 2, -height / 2);
                            Graphics2D g2 = image.createGraphics();
                            g2.drawImage(imageOrig, at, (ImageObserver)((Object)this));
                            g2.dispose();
                            ImageIO.write((RenderedImage)image, "jpg", imagefile);
                            planfile.getIntegerAttribute("imagewidth").setValue(height);
                            planfile.getIntegerAttribute("imageheight").setValue(width);
                            int oldangle = planfile.getIntegerAttribute("angle").getIntValue();
                            planfile.getIntegerAttribute("angle").setValue(oldangle + angle % 360);
                            planfile.save();
                            if (planfile.getId() != currentPlanfile) continue;
                            curHeight = height;
                            curWidth = width;
                        }
                        if (withLocations) {
                            this.plan.reloadLocations();
                            List locationIds = this.plan.getRelationAttribute("locations").getElementIds();
                            List recs = this.project.getDatastorage().executeQuery("SELECT idelement,position,labelposition FROM tdtaEleLocation WHERE idelement IN " + Util.toSqlString((Iterable)locationIds), true).getResult();
                            for (DataRecord rec : recs) {
                                double oldy;
                                double oldx;
                                long id = rec.getLong("idelement");
                                String pos = rec.getString("position");
                                SimpleGeometry geom = SimpleGeometry.fromWKT((String)pos);
                                for (Point p : geom.getPoints()) {
                                    oldx = p.getX();
                                    oldy = p.getY();
                                    if (angle == 90) {
                                        p.setX((double)curHeight - oldy);
                                        p.setY(oldx);
                                        continue;
                                    }
                                    p.setX(oldy);
                                    p.setY((double)curWidth - oldx);
                                }
                                pos = geom.toWKT();
                                this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocation SET position=" + Util.toSqlString((String)pos) + " WHERE idelement=" + id, true);
                                pos = rec.getString("labelposition");
                                if (pos == null || "".equals(pos)) continue;
                                geom = SimpleGeometry.fromWKT((String)pos);
                                for (Point p : geom.getPoints()) {
                                    oldx = p.getX();
                                    oldy = p.getY();
                                    if (angle == 90) {
                                        p.setX((double)curHeight - oldy);
                                        p.setY(oldx);
                                        continue;
                                    }
                                    p.setX(oldy);
                                    p.setY((double)curWidth - oldx);
                                }
                                pos = geom.toWKT();
                                this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocation SET labelposition=" + Util.toSqlString((String)pos) + " WHERE idelement=" + id, true);
                            }
                        }
                        this.project.getDatastorage().setElementLastEdit(this.plan.getId(), this.project.getUser());
                        ThemisApplication.getInstance().getProject().createActionLog("plan_rotate", this.plan.getId(), "angle: " + angle);
                        Object[] selPath = node.getPath();
                        this.tree.setSelectionPath(new TreePath(selPath));
                        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SAVED.setId(this.plan.getId()).setSource((Object)this));
                        ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(this.plan.getId()));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    notify.clear();
                });
            }
        }
    }

    private void editPlan() {
        CmsLocation loc;
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.currentPlanSelection != null && this.currentPlanSelection.getId() > -1L) {
            ThemisActions.editPlan((CmsPlan)this.currentPlanSelection.getElement());
        } else if (this.currentBuilding != null && (loc = (CmsLocation)this.currentBuilding.getElement()) != null) {
            new LocationObservationDialog().editLocation((CmsElement)loc);
            ThemisApplication.getInstance().getProject().createActionLog("building_create", loc.getId(), "");
        }
    }

    private void deletePlan() {
        boolean remove;
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.currentPlanSelection != null) {
            String test = this.currentPlanSelection.getTitle();
            boolean remove2 = Dialogs.getInstance().showConfirmDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.deleteMap.text"), test), ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.deleteMapShort.text"));
            if (remove2) {
                this.currentPlanSelection.getElement(this.project.getUser()).moveToTrash();
                ThemisApplication.getInstance().getProject().createActionLog("plan_delete", this.currentPlanSelection.getId(), "");
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_DELETED.setId(this.currentPlanSelection.getId()));
            }
        } else if (this.currentBuilding != null && (remove = Dialogs.getInstance().showConfirmDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.deleteBuilding.text"), this.currentBuilding.getTitle()), ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.deleteBuildingShort.text")))) {
            if (!this.project.getPlansForBuilding(this.currentBuilding.getId()).isEmpty()) {
                Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.stillMapsProvidedForBuilding.text"));
                return;
            }
            this.currentBuilding.getElement(this.project.getUser()).moveToTrash();
            this.loadPlans();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_DELETED.setId(this.currentBuilding.getId()));
        }
    }

    private void updateCalibrationPanel() {
        this.updateCalibrationPanel(true, -1);
    }

    private void updateCalibrationPanel(boolean trigger, int calibMethod) {
        long idCalibPlan;
        this.updatePlan();
        boolean enabledPro = !ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL);
        this.btnCalibPlan1.setEnabled(enabledPro);
        this.btnCalibPlan1.setEnabled(enabledPro);
        this.btnCalibRemove.setEnabled(enabledPro);
        this.btnCalibSave.setEnabled(enabledPro);
        this.btnCreateNewVersion.setEnabled(enabledPro);
        this.btnDeleteVersion.setEnabled(enabledPro);
        if (this.currentPlan == null || this.currentPlan.getId() < 0L) {
            this.fldCalibPlanTitle.setText("");
            this.calibPanel.setVisible(false);
            return;
        }
        if (this.plan.getCurrentPlanfileElement() == null) {
            return;
        }
        this.calibPanel.setVisible(true);
        this.fldPlanVersions.removeItemListener(this.planVersionChanged);
        ((DefaultComboBoxModel)this.fldPlanVersions.getModel()).removeAllElements();
        List planfiles = this.plan.getPlanfiles();
        for (CmsElementSummary planfile : planfiles) {
            ((DefaultComboBoxModel)this.fldPlanVersions.getModel()).addElement(planfile);
            if (planfile.getId() != this.plan.getCurrentPlanfileId()) continue;
            this.fldPlanVersions.setSelectedItem(planfile);
        }
        this.fldPlanVersions.addItemListener(this.planVersionChanged);
        boolean isPlanCalibrated = this.plan.isCalibrated();
        boolean isPlanVersionCalibrated = this.plan.getCurrentPlanfileElement().isCalibrated();
        boolean isCalibrationBase = this.plan.isCurrentPlanfileCalibrationBase();
        boolean allowDelete = enabledPro && this.plan.getPlanfiles().size() > 1 && (!isPlanCalibrated || !isCalibrationBase);
        this.btnDeleteVersion.setEnabled(allowDelete);
        this.lblNoDelete.setVisible(false);
        if (isCalibrationBase) {
            this.lblNoDelete.setVisible(true);
        }
        this.fldCalibPlan1.setText("");
        this.fldCalibPlan2.setText("");
        this.fldCalibX1.setText("");
        this.fldCalibY1.setText("");
        this.fldCalibX2.setText("");
        this.fldCalibY2.setText("");
        this.panelCalibPoints.setVisible(false);
        this.panelCalibCoord1.setVisible(false);
        this.panelCalibCoord2.setVisible(false);
        this.panelCalibWorldfile.setVisible(false);
        this.btnCalibSave.setVisible(false);
        this.btnCalibRemove.setVisible(false);
        this.fldCalibMethod.setEnabled(true);
        this.fldCalibPlanTitle.setText(this.plan.getTitle());
        CmsPlanCalibration calib = this.plan.getCurrentPlanfileElement().getCalibration();
        if (calibMethod < 0) {
            calibMethod = this.plan.getCalibMethod();
        }
        if ((idCalibPlan = this.plan.getCalibPlanfileId()) > 0L && !this.plan.getRelationAttribute("planfiles").contains(idCalibPlan) && calib == null) {
            this.repairCalib();
            return;
        }
        this.fldCalibMethodTrigger = false;
        this.fldCalibMethod.setSelectedIndex(calibMethod);
        this.fldCalibMethodTrigger = true;
        switch (calibMethod) {
            case 0: {
                break;
            }
            case 3: {
                this.panelCalibWorldfile.setVisible(true);
                this.fldCalibWorldfile.setText(calib == null ? "" : calib.getWorldfile());
                this.btnCalibSave.setVisible(true);
                break;
            }
            case 1: {
                this.panelCalibPoints.setVisible(true);
                this.fldCalibPlan1.setText(calib == null ? "" : calib.getPlan1String());
                this.fldCalibPlan2.setText(calib == null ? "" : calib.getPlan2String());
                try {
                    this.calibPlanX1 = calib.getPlanX1();
                    this.calibPlanY1 = calib.getPlanY1();
                    this.calibPlanX2 = calib.getPlanX2();
                    this.calibPlanY2 = calib.getPlanY2();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.btnCalibSave.setVisible(true);
                break;
            }
            case 2: {
                this.panelCalibCoord1.setVisible(true);
                this.panelCalibCoord2.setVisible(true);
                this.fldCalibX1.setText(calib == null ? "" : Double.toString(Util.round((double)calib.getGeoX1(), (int)1)));
                this.fldCalibY1.setText(calib == null ? "" : Double.toString(Util.round((double)calib.getGeoY1(), (int)1)));
                this.fldCalibX2.setText(calib == null ? "" : Double.toString(Util.round((double)calib.getGeoX2(), (int)1)));
                this.fldCalibY2.setText(calib == null ? "" : Double.toString(Util.round((double)calib.getGeoY2(), (int)1)));
                this.panelCalibPoints.setVisible(true);
                this.fldCalibPlan1.setText(calib == null ? "" : calib.getPlan1String());
                this.fldCalibPlan2.setText(calib == null ? "" : calib.getPlan2String());
                this.btnCalibSave.setVisible(true);
                break;
            }
        }
        if (isPlanCalibrated) {
            this.fldCalibMethod.setEnabled(false);
            if (isCalibrationBase) {
                this.panelCalibPoints.setEnabled(false);
                this.panelCalibCoord1.setEnabled(false);
                this.panelCalibCoord2.setEnabled(false);
                this.panelCalibWorldfile.setEnabled(false);
                this.btnCalibSave.setVisible(false);
                this.btnCalibRemove.setVisible(true);
            } else {
                this.panelCalibPoints.setEnabled(true);
                this.panelCalibCoord1.setEnabled(true);
                this.panelCalibCoord2.setEnabled(true);
                this.panelCalibWorldfile.setEnabled(true);
                this.btnCalibSave.setVisible(true);
                this.btnCalibRemove.setVisible(false);
            }
            this.lblPlanversionCalibInfo.setVisible(!isPlanVersionCalibrated);
        } else {
            this.fldCalibMethod.setEnabled(true);
            this.lblPlanversionCalibInfo.setVisible(false);
        }
        this.updateCalibrationSaveButton();
    }

    private void repairCalib() {
        if (this.plan == null) {
            return;
        }
        long idCalibPlan = this.plan.getCalibPlanfileId();
        if (idCalibPlan > 0L && !this.plan.getRelationAttribute("planfiles").contains(idCalibPlan)) {
            this.plan.removeCalibration();
            this.plan.save();
        }
        CmsPlanfile calibPlanfileElement = this.plan.getCalibPlanfileElement();
        CmsPlanfile currentPlanfileElement = this.plan.getCurrentPlanfileElement();
        if (calibPlanfileElement == null || currentPlanfileElement == null) {
            return;
        }
        CmsPlanCalibration calibration = calibPlanfileElement.getCalibration();
        CmsPlanCalibration calibrationNew = currentPlanfileElement.getCalibration();
        if (calibrationNew == null) {
            currentPlanfileElement.setCalibration(calibration);
            currentPlanfileElement.save();
            this.updateCalibrationPanel();
        }
    }

    private void deleteCurrentPlanVersion() {
        if (this.plan == null || this.plan.getPlanfiles().size() < 2 || ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        if (!Dialogs.getInstance().showConfirmDialog("dialog.deletePlanVersion.text", "dialog.deletePlanVersion.title")) {
            return;
        }
        this.plan.deleteCurrentPlanfile();
        this.plan.save();
        this.updatePlan();
        this.updateCalibrationPanel(false, -1);
        this.changePlanVersion();
    }

    private void changePlanVersion() {
        this.updatePlan();
        if (this.plan != null) {
            CmsElementSummary v = (CmsElementSummary)this.fldPlanVersions.getSelectedItem();
            if (v != null) {
                this.plan.reload();
                this.plan.setCurrentPlanfile(v.getId());
                this.plan.save();
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(this.plan.getId()).from((Object)this, "new plan version selected"));
            }
            this.updateCalibrationPanel(false, -1);
        }
    }

    private void updateCalibrationSaveButton() {
        switch (this.fldCalibMethod.getSelectedIndex()) {
            case 0: {
                break;
            }
            case 3: {
                this.btnCalibSave.setEnabled(!"".equals(this.fldCalibWorldfile.getText()));
                break;
            }
            case 1: {
                this.btnCalibSave.setEnabled(!"".equals(this.fldCalibPlan1.getText()) && !"".equals(this.fldCalibPlan2.getText()));
                break;
            }
            case 2: {
                this.btnCalibSave.setEnabled(!"".equals(this.fldCalibPlan1.getText()) && !"".equals(this.fldCalibPlan2.getText()) && !"".equals(this.fldCalibX1.getText()) && !"".equals(this.fldCalibY1.getText()) && !"".equals(this.fldCalibX2.getText()) && !"".equals(this.fldCalibY2.getText()));
                break;
            }
            default: {
                this.btnCalibSave.setEnabled(false);
            }
        }
    }

    private void savePlanCalibration() {
        this.updatePlan();
        if (this.plan == null) {
            this.app.getDialog().showWarningDialog("NO_PLAN");
            return;
        }
        this.plan.reload();
        int calibMethod = this.fldCalibMethod.getSelectedIndex();
        String calibMethodText = "";
        switch (calibMethod) {
            case 1: {
                calibMethodText = "using POINTS";
                this.plan.updateCalibration(1, this.calibPlanX1, this.calibPlanY1, this.calibPlanX2, this.calibPlanY2, 0.0, 0.0, 100.0, 100.0);
                break;
            }
            case 2: {
                calibMethodText = "using COORDINATES";
                this.plan.updateCalibration(2, this.calibPlanX1, this.calibPlanY1, this.calibPlanX2, this.calibPlanY2, Double.parseDouble(this.fldCalibX1.getText()), Double.parseDouble(this.fldCalibY1.getText()), Double.parseDouble(this.fldCalibX2.getText()), Double.parseDouble(this.fldCalibY2.getText()));
                break;
            }
            case 3: {
                calibMethodText = "using WORLDFILE";
                this.plan.updateCalibration(this.fldCalibWorldfile.getText());
            }
        }
        this.plan.save();
        ThemisApplication.getInstance().getProject().createActionLog("plan_calibrated", this.plan.getId(), "Method: " + calibMethodText);
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SAVED.setId(this.plan.getId()));
        this.updateCalibrationPanel();
    }

    private void removePlanCalibration() {
        long planid = this.project.getCurrentPlanId();
        if (planid > 0L) {
            if (this.plan == null || this.plan.getId() != planid) {
                this.plan = (CmsPlan)this.project.loadElement(planid, this.project.getUser());
            } else {
                this.plan.reload();
            }
        } else {
            this.plan = null;
        }
        if (this.plan == null) {
            this.app.getDialog().showWarningDialog("NO_PLAN");
            return;
        }
        this.plan.removeCalibration();
        this.plan.save();
        ThemisApplication.getInstance().getProject().createActionLog("plan_calibrationremoved", this.plan.getId(), "");
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SAVED.setId(this.plan.getId()));
        this.updateCalibrationPanel();
    }

    private void initComponents() {
        this.panelTree = new JPanel();
        this.jPanel1 = new JPanel();
        this.planScrollPanel1 = new JScrollPane();
        this.tree = new JTree();
        this.jPanel7 = new JPanel();
        this.btnAddPlan = new JButton();
        this.btnAddBuilding = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.btnUserAction = new JButton();
        this.calibPanel = new JPanel();
        this.panelCalibMain = new JPanel();
        this.jLabel3 = new JLabel();
        this.fldCalibMethod = new JComboBox();
        this.lblNoDelete = new JLabel();
        this.panelCalibPoints = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.fldCalibPlan1 = new JTextField();
        this.panelCalibCoord1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.fldCalibX1 = new JTextField();
        this.jLabel6 = new JLabel();
        this.fldCalibY1 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.fldCalibPlan2 = new JTextField();
        this.panelCalibCoord2 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.fldCalibX2 = new JTextField();
        this.jLabel11 = new JLabel();
        this.fldCalibY2 = new JTextField();
        this.btnCalibPlan1 = new JButton();
        this.btnCalibPlan2 = new JButton();
        this.jButton1 = new JButton();
        this.panelCalibWorldfile = new JPanel();
        this.jLabel12 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldCalibWorldfile = new JTextArea();
        this.jLabel13 = new JLabel();
        this.fldCalibPlanTitle = new JTextField();
        this.btnCalibSave = new JButton();
        this.btnCalibRemove = new JButton();
        this.jLabel14 = new JLabel();
        this.fldPlanVersions = new JComboBox();
        this.btnDeleteVersion = new JButton();
        this.btnCreateNewVersion = new JButton();
        this.lblPlanversionCalibInfo = new JLabel();
        this.lblPlanversionCalibInfo1 = new JLabel();
        this.mainPanel = new JPanel();
        this.jPanel1.setLayout(new GridBagLayout());
        this.planScrollPanel1.setMinimumSize(new Dimension(5, 20));
        this.tree.setFont(THEMIS.fontList);
        this.tree.setModel(this.treemodel);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
                ManagerTopComponent.this.treeTreeCollapsed(evt);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
                ManagerTopComponent.this.treeTreeExpanded(evt);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ManagerTopComponent.this.treeMouseClicked(evt);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                ManagerTopComponent.this.treeValueChanged(evt);
            }
        });
        this.planScrollPanel1.setViewportView(this.tree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.planScrollPanel1, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.btnAddPlan.setFont(THEMIS.fontButton);
        this.btnAddPlan.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/plan_add24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddPlan, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnAddPlan.text"));
        this.btnAddPlan.setToolTipText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnAddPlan.toolTipText"));
        this.btnAddPlan.setBorder(new SoftBevelBorder(0));
        this.btnAddPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnAddPlanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.btnAddPlan, gridBagConstraints);
        this.btnAddBuilding.setFont(THEMIS.fontButton);
        this.btnAddBuilding.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/building_add24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddBuilding, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnAddBuilding.text"));
        this.btnAddBuilding.setToolTipText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnAddBuilding.toolTipText"));
        this.btnAddBuilding.setBorder(new SoftBevelBorder(0));
        this.btnAddBuilding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnAddBuildingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.btnAddBuilding, gridBagConstraints);
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnEdit.text"));
        this.btnEdit.setToolTipText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnEdit.toolTipText"));
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.setMaximumSize(null);
        this.btnEdit.setMinimumSize(null);
        this.btnEdit.setPreferredSize(null);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.btnEdit, gridBagConstraints);
        this.btnRemove.setFont(THEMIS.fontButton);
        this.btnRemove.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnRemove.toolTipText"));
        this.btnRemove.setBorder(new SoftBevelBorder(0));
        this.btnRemove.setMaximumSize(null);
        this.btnRemove.setMinimumSize(null);
        this.btnRemove.setPreferredSize(null);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.btnRemove, gridBagConstraints);
        this.btnUserAction.setFont(THEMIS.fontButton);
        this.btnUserAction.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/menu_options24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUserAction, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnUserAction.text"));
        this.btnUserAction.setToolTipText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnUserAction.toolTipText"));
        this.btnUserAction.setBorder(new SoftBevelBorder(0));
        this.btnUserAction.setDisabledIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/menu_options_disabled24.gif")));
        this.btnUserAction.setMaximumSize(null);
        this.btnUserAction.setMinimumSize(null);
        this.btnUserAction.setPreferredSize(null);
        this.btnUserAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnUserActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.btnUserAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jPanel7, gridBagConstraints);
        GroupLayout panelTreeLayout = new GroupLayout(this.panelTree);
        this.panelTree.setLayout(panelTreeLayout);
        panelTreeLayout.setHorizontalGroup(panelTreeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, 479, Short.MAX_VALUE));
        panelTreeLayout.setVerticalGroup(panelTreeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 549, Short.MAX_VALUE));
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel3.text"));
        this.fldCalibMethod.setFont(THEMIS.fontLabel);
        this.fldCalibMethod.setModel(new DefaultComboBoxModel<String>(new String[]{this.project.getResourceText("calib.method.none"), this.project.getResourceText("calib.method.points"), this.project.getResourceText("calib.method.coordinates"), this.project.getResourceText("calib.method.worldfile")}));
        this.fldCalibMethod.setMinimumSize(new Dimension(5, 30));
        this.fldCalibMethod.setPreferredSize(new Dimension(180, 30));
        this.fldCalibMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ManagerTopComponent.this.fldCalibMethodItemStateChanged(evt);
            }
        });
        this.lblNoDelete.setFont(THEMIS.fontLabel);
        this.lblNoDelete.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.lblNoDelete, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.lblNoDelete.text"));
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel1.text"));
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel2.text"));
        this.fldCalibPlan1.setEditable(false);
        this.fldCalibPlan1.setFont(THEMIS.fontTextfield);
        this.fldCalibPlan1.setText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.fldCalibPlan1.text"));
        this.fldCalibPlan1.setMinimumSize(new Dimension(5, 24));
        this.fldCalibPlan1.setPreferredSize(new Dimension(285, 30));
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel4.text"));
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel5.text"));
        this.fldCalibX1.setFont(THEMIS.fontTextfield);
        this.fldCalibX1.setText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.fldCalibX1.text"));
        this.fldCalibX1.setMinimumSize(new Dimension(5, 24));
        this.fldCalibX1.setPreferredSize(new Dimension(285, 30));
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel6.text"));
        this.fldCalibY1.setFont(THEMIS.fontTextfield);
        this.fldCalibY1.setText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.fldCalibY1.text"));
        this.fldCalibY1.setMinimumSize(new Dimension(5, 24));
        this.fldCalibY1.setPreferredSize(new Dimension(285, 30));
        GroupLayout panelCalibCoord1Layout = new GroupLayout(this.panelCalibCoord1);
        this.panelCalibCoord1.setLayout(panelCalibCoord1Layout);
        panelCalibCoord1Layout.setHorizontalGroup(panelCalibCoord1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCalibCoord1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelCalibCoord1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 56, Short.MAX_VALUE).addGroup(panelCalibCoord1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fldCalibX1, -1, -1, Short.MAX_VALUE).addComponent(this.fldCalibY1, -1, -1, Short.MAX_VALUE))));
        panelCalibCoord1Layout.setVerticalGroup(panelCalibCoord1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCalibCoord1Layout.createSequentialGroup().addGroup(panelCalibCoord1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.fldCalibX1, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCalibCoord1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.fldCalibY1, -2, 30, -2))));
        this.jLabel7.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel7.text"));
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel8.text"));
        this.fldCalibPlan2.setEditable(false);
        this.fldCalibPlan2.setFont(THEMIS.fontTextfield);
        this.fldCalibPlan2.setText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.fldCalibPlan2.text"));
        this.fldCalibPlan2.setMinimumSize(new Dimension(5, 24));
        this.fldCalibPlan2.setPreferredSize(new Dimension(285, 30));
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel9.text"));
        this.jLabel10.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel10.text"));
        this.fldCalibX2.setFont(THEMIS.fontTextfield);
        this.fldCalibX2.setText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.fldCalibX2.text"));
        this.fldCalibX2.setMinimumSize(new Dimension(5, 24));
        this.fldCalibX2.setPreferredSize(new Dimension(285, 30));
        this.jLabel11.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel11.text"));
        this.fldCalibY2.setFont(THEMIS.fontTextfield);
        this.fldCalibY2.setText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.fldCalibY2.text"));
        this.fldCalibY2.setMinimumSize(new Dimension(5, 24));
        this.fldCalibY2.setPreferredSize(new Dimension(285, 30));
        GroupLayout panelCalibCoord2Layout = new GroupLayout(this.panelCalibCoord2);
        this.panelCalibCoord2.setLayout(panelCalibCoord2Layout);
        panelCalibCoord2Layout.setHorizontalGroup(panelCalibCoord2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCalibCoord2Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelCalibCoord2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCalibCoord2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldCalibX2, -1, -1, Short.MAX_VALUE).addComponent(this.fldCalibY2, -1, -1, Short.MAX_VALUE))));
        panelCalibCoord2Layout.setVerticalGroup(panelCalibCoord2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCalibCoord2Layout.createSequentialGroup().addGroup(panelCalibCoord2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.fldCalibX2, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCalibCoord2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.fldCalibY2, -2, 30, -2))));
        this.btnCalibPlan1.setFont(THEMIS.fontButton);
        this.btnCalibPlan1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/plan.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCalibPlan1, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnCalibPlan1.text"));
        this.btnCalibPlan1.setMinimumSize(new Dimension(5, 32));
        this.btnCalibPlan1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnCalibPlan1ActionPerformed(evt);
            }
        });
        this.btnCalibPlan2.setFont(THEMIS.fontButton);
        this.btnCalibPlan2.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/plan.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCalibPlan2, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnCalibPlan2.text"));
        this.btnCalibPlan2.setToolTipText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnCalibPlan2.toolTipText"));
        this.btnCalibPlan2.setMinimumSize(new Dimension(5, 32));
        this.btnCalibPlan2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnCalibPlan2ActionPerformed(evt);
            }
        });
        this.jButton1.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jButton1.text"));
        this.jButton1.setMinimumSize(new Dimension(10, 32));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout panelCalibPointsLayout = new GroupLayout(this.panelCalibPoints);
        this.panelCalibPoints.setLayout(panelCalibPointsLayout);
        panelCalibPointsLayout.setHorizontalGroup(panelCalibPointsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelCalibCoord1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelCalibPointsLayout.createSequentialGroup().addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldCalibPlan1, -2, -1, -2)).addGroup(panelCalibPointsLayout.createSequentialGroup().addComponent(this.jLabel7).addGap(158, 158, 158).addComponent(this.btnCalibPlan2, -1, -1, Short.MAX_VALUE)).addGroup(panelCalibPointsLayout.createSequentialGroup().addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldCalibPlan2, -2, -1, -2)).addComponent(this.panelCalibCoord2, -1, -1, Short.MAX_VALUE).addGroup(panelCalibPointsLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(158, 158, 158).addComponent(this.btnCalibPlan1, -1, -1, Short.MAX_VALUE)).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE));
        panelCalibPointsLayout.setVerticalGroup(panelCalibPointsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCalibPointsLayout.createSequentialGroup().addGroup(panelCalibPointsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.btnCalibPlan1, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCalibPointsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fldCalibPlan1, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelCalibCoord1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelCalibPointsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.btnCalibPlan2, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCalibPointsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.fldCalibPlan2, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelCalibCoord2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1, -2, 30, -2).addGap(9, 9, 9)));
        this.jLabel12.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel12.text"));
        this.jScrollPane1.setMinimumSize(new Dimension(10, 20));
        this.fldCalibWorldfile.setColumns(20);
        this.fldCalibWorldfile.setFont(THEMIS.fontTextfield);
        this.fldCalibWorldfile.setRows(5);
        this.fldCalibWorldfile.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                ManagerTopComponent.this.fldCalibWorldfileInputMethodTextChanged(evt);
            }

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }
        });
        this.fldCalibWorldfile.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ManagerTopComponent.this.fldCalibWorldfileKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.fldCalibWorldfile);
        GroupLayout panelCalibWorldfileLayout = new GroupLayout(this.panelCalibWorldfile);
        this.panelCalibWorldfile.setLayout(panelCalibWorldfileLayout);
        panelCalibWorldfileLayout.setHorizontalGroup(panelCalibWorldfileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCalibWorldfileLayout.createSequentialGroup().addComponent(this.jLabel12).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, -1, Short.MAX_VALUE));
        panelCalibWorldfileLayout.setVerticalGroup(panelCalibWorldfileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCalibWorldfileLayout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 132, Short.MAX_VALUE)));
        this.jLabel13.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel13.text"));
        this.fldCalibPlanTitle.setEditable(false);
        this.fldCalibPlanTitle.setFont(THEMIS.fontTextfield);
        this.fldCalibPlanTitle.setText(NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.fldCalibPlanTitle.text"));
        this.fldCalibPlanTitle.setMinimumSize(new Dimension(5, 24));
        this.btnCalibSave.setFont(THEMIS.fontButton);
        this.btnCalibSave.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCalibSave, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnCalibSave.text"));
        this.btnCalibSave.setBorder(new SoftBevelBorder(0));
        this.btnCalibSave.setMinimumSize(new Dimension(5, 30));
        this.btnCalibSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnCalibSaveActionPerformed(evt);
            }
        });
        this.btnCalibRemove.setFont(THEMIS.fontButton);
        this.btnCalibRemove.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCalibRemove, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnCalibRemove.text"));
        this.btnCalibRemove.setBorder(new SoftBevelBorder(0));
        this.btnCalibRemove.setMinimumSize(new Dimension(5, 30));
        this.btnCalibRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnCalibRemoveActionPerformed(evt);
            }
        });
        this.jLabel14.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.jLabel14.text"));
        this.fldPlanVersions.setFont(THEMIS.fontTextfield);
        this.fldPlanVersions.setModel(new DefaultComboBoxModel());
        this.fldPlanVersions.setMinimumSize(new Dimension(5, 26));
        this.btnDeleteVersion.setFont(THEMIS.fontButton);
        this.btnDeleteVersion.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteVersion, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnDeleteVersion.text"));
        this.btnDeleteVersion.setMinimumSize(new Dimension(10, 40));
        this.btnDeleteVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnDeleteVersionActionPerformed(evt);
            }
        });
        this.btnCreateNewVersion.setFont(THEMIS.fontButton);
        this.btnCreateNewVersion.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateNewVersion, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.btnCreateNewVersion.text"));
        this.btnCreateNewVersion.setMinimumSize(new Dimension(10, 40));
        this.btnCreateNewVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerTopComponent.this.btnCreateNewVersionActionPerformed(evt);
            }
        });
        this.lblPlanversionCalibInfo.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblPlanversionCalibInfo, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.lblPlanversionCalibInfo.text"));
        this.lblPlanversionCalibInfo1.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblPlanversionCalibInfo1, (String)NbBundle.getMessage(ManagerTopComponent.class, (String)"ManagerTopComponent.lblPlanversionCalibInfo1.text"));
        GroupLayout panelCalibMainLayout = new GroupLayout(this.panelCalibMain);
        this.panelCalibMain.setLayout(panelCalibMainLayout);
        panelCalibMainLayout.setHorizontalGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCalibMainLayout.createSequentialGroup().addContainerGap().addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelCalibWorldfile, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.panelCalibPoints, -1, -1, Short.MAX_VALUE).addGroup(panelCalibMainLayout.createSequentialGroup().addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldCalibPlanTitle, -1, -1, Short.MAX_VALUE).addComponent(this.fldPlanVersions, 0, -1, Short.MAX_VALUE))).addGroup(panelCalibMainLayout.createSequentialGroup().addComponent(this.btnCalibSave, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCalibRemove, -1, -1, Short.MAX_VALUE)).addGroup(panelCalibMainLayout.createSequentialGroup().addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCalibMainLayout.createSequentialGroup().addComponent(this.jLabel13, -2, 180, -2).addGap(14, 14, 14)).addGroup(panelCalibMainLayout.createSequentialGroup().addComponent(this.btnDeleteVersion, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnCreateNewVersion, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.fldCalibMethod, 0, -1, Short.MAX_VALUE))).addGroup(panelCalibMainLayout.createSequentialGroup().addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPlanversionCalibInfo).addComponent(this.lblNoDelete, -2, 348, -2).addComponent(this.lblPlanversionCalibInfo1)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        panelCalibMainLayout.setVerticalGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCalibMainLayout.createSequentialGroup().addContainerGap().addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.fldCalibPlanTitle, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.fldPlanVersions, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCreateNewVersion, -2, -1, -2).addComponent(this.btnDeleteVersion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNoDelete, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblPlanversionCalibInfo1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.fldCalibMethod, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPlanversionCalibInfo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelCalibPoints, -2, -1, -2).addGap(0, 0, 0).addComponent(this.panelCalibWorldfile, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCalibMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCalibRemove, -2, 35, -2).addComponent(this.btnCalibSave, -2, 35, -2)).addGap(74, 74, 74)));
        GroupLayout calibPanelLayout = new GroupLayout(this.calibPanel);
        this.calibPanel.setLayout(calibPanelLayout);
        calibPanelLayout.setHorizontalGroup(calibPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelCalibMain, -1, -1, Short.MAX_VALUE));
        calibPanelLayout.setVerticalGroup(calibPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelCalibMain, -1, -1, Short.MAX_VALUE));
        this.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
        this.setMinimumSize(new Dimension(10, 0));
        this.setName("");
        this.setPreferredSize(new Dimension(300, 598));
        this.mainPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
    }

    private void addPlan(List<File> files) {
        ArrayList plans;
        CmsPlan p;
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionLimitedForBSbuch((ThemisApplication)this.app, (this.project.getPlans().size() >= 15 ? 1 : 0) != 0, (String)"license.too-many-plans")) {
            return;
        }
        DefaultMutableTreeNode node = this.getTreeSelectionNode();
        if (this.currentBuilding == null) {
            p = this.project.createPlan(-1L);
            node = this.noBuildingRoot;
        } else {
            p = this.project.createPlan(this.currentBuilding.getId());
            if (this.currentPlanSelection != null) {
                node = node == null ? this.noBuildingRoot : (DefaultMutableTreeNode)node.getParent();
            }
        }
        Object newNode = null;
        if (p != null) {
            int countPlan = 0;
            countPlan = files == null ? ThemisActions.editPlan(p, false) : (files.size() == 1 ? ThemisActions.editPlan(p, files.get(0), false) : ThemisActions.editPlan(p, files));
            if (countPlan > 1) {
                this.loadPlans();
            } else if (p.isSaved()) {
                this.tree.setExpandsSelectedPaths(true);
                this.treemodel.reload();
                this.app.setPlanLongside(Long.toString(p.getPlanLongside()));
                this.project.createActionLog("plan_create", p.getId(), "");
            }
        }
        String treeState = this.project.getProjectProperty("system.tree.plan", "");
        THEMIS.applyTreeExpansionState(this.tree, treeState);
        if (node != null) {
            this.tree.setSelectionPath(new TreePath(node.getPath()));
        }
        if ((plans = this.project.getPlans()) != null && plans.size() > 0 && Assistant.getInstance().isShowTHEMISAssistant()) {
            Assistant.getInstance().setNextStep(Step.CREATE_LOCATION);
            Assistant.getInstance().showNextStep();
            ViewHelper.showLocationlist();
        }
    }

    private void btnAddPlanActionPerformed(ActionEvent evt) {
        this.addPlan(null);
    }

    private void btnAddBuildingActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        CreateBuildingPanel panel = new CreateBuildingPanel();
        panel.showDialog();
        if (panel.isBuildingCreated()) {
            this.reloadPlans(panel.getBuildingId());
        }
    }

    private void treeValueChanged(TreeSelectionEvent evt) {
        this.applyTreeSelection();
    }

    private void btnCalibPlan1ActionPerformed(ActionEvent evt) {
        this.calibPoint = 1;
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.CREATE_POINT_IN_PLAN_START.setReference((Object)this));
    }

    private void btnCalibPlan2ActionPerformed(ActionEvent evt) {
        this.calibPoint = 2;
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.CREATE_POINT_IN_PLAN_START.setReference((Object)this));
    }

    private void btnCalibSaveActionPerformed(ActionEvent evt) {
        this.savePlanCalibration();
        ThemisApplication.getInstance().getFilter().resetSearchResult();
    }

    private void btnCalibRemoveActionPerformed(ActionEvent evt) {
        this.removePlanCalibration();
        ThemisApplication.getInstance().getFilter().resetSearchResult();
    }

    private void treeTreeCollapsed(TreeExpansionEvent evt) {
        if (this.project.isOpen() && this.project != null) {
            this.project.setProjectProperty("system.tree.plan", THEMIS.getTreeExpansionState(this.tree));
        }
    }

    private void treeTreeExpanded(TreeExpansionEvent evt) {
        if (this.project.isOpen() && this.project != null) {
            this.project.setProjectProperty("system.tree.plan", THEMIS.getTreeExpansionState(this.tree));
        }
    }

    private void btnCreateNewVersionActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.updatePlan();
        if (this.plan != null) {
            ThemisActions.editPlan(this.plan, true);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.updateCalibPoints(false);
    }

    private void updateCalibPoints(boolean forceShow) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(this.calibPlanX1, this.calibPlanY1));
        points.add(new Point(this.calibPlanX2, this.calibPlanY2));
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.ACTION_SHOW_CALIBPOINT.setReference(points).setFlag(forceShow ? Boolean.valueOf(true) : null), true);
    }

    private void fldCalibMethodItemStateChanged(ItemEvent evt) {
        if (this.fldCalibMethodTrigger) {
            this.updateCalibrationPanel(false, this.fldCalibMethod.getSelectedIndex());
        }
    }

    private void fldCalibWorldfileInputMethodTextChanged(InputMethodEvent evt) {
        this.updateCalibrationSaveButton();
    }

    private void fldCalibWorldfileKeyReleased(KeyEvent evt) {
        this.updateCalibrationSaveButton();
    }

    private void btnDeleteVersionActionPerformed(ActionEvent evt) {
        this.deleteCurrentPlanVersion();
    }

    private void treeMouseClicked(MouseEvent evt) {
        int count = evt.getClickCount();
        if (count == 2) {
            this.editPlan();
        }
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.editPlan();
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.deletePlan();
    }

    private void btnUserActionActionPerformed(ActionEvent evt) {
        this.showActionMenu();
    }

    public void componentOpened() {
        if (this.app.getProject() != null && this.app.getProject().isOpen()) {
            this.loadPlans();
            this.updateActions();
        }
        this.initialiseAccordion();
        if (this.currentPlan != null) {
            this.setTreeSelection(this.currentPlan.getId());
        }
    }

    public void componentClosed() {
    }

    public void componentHidden() {
    }

    public void componentShowing() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private boolean allowBuildings() {
        return ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL);
    }

    class PlanTreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof CmsElementSummary) {
                CmsElementSummary ele = (CmsElementSummary)node.getUserObject();
                if ("plan".equals(ele.getElementcode())) {
                    this.setIcon(ManagerTopComponent.this.iconPlan);
                    this.setToolTipText(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.isMap.text"));
                } else {
                    this.setIcon(ManagerTopComponent.this.iconBuilding);
                    this.setToolTipText(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.isBuilding.text"));
                }
            } else if (node != ManagerTopComponent.this.root) {
                this.setIcon(ManagerTopComponent.this.iconBuilding);
                this.setToolTipText(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.noBuildingDefined.text"));
            }
            return this;
        }
    }
}

