/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.planviewer.planlist;

import at.grid.cms.element.CmsElementSummary;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.config.ProjectSettingsPanel;
import at.grid.themis.application.planviewer.planlist.BuildingPanel;
import at.grid.themis.application.planviewer.planlist.CreateBuildingPanel;
import at.grid.themis.application.planviewer.planlist.PlanPanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PlanListPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    DragScrollHandler dsh;
    private JButton btnAddBuilding;
    private JButton btnAddPlan;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnUserAction;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JLabel locListSettings;
    private JPanel panelPlanList;

    public PlanListPanel() {
        this.initComponents();
        this.dsh = new DragScrollHandler(this.panelPlanList, false, true);
    }

    private boolean isBuildingsAllowed() {
        return ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL);
    }

    private void showActionMenu() {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        boolean enabledPro = ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL);
        JPopupMenu menu = new JPopupMenu("Optionen");
    }

    public void populate() {
        if (this.project != null && this.project.isOpen()) {
            ArrayList plans = this.project.getPlans();
            ArrayList buildings = this.project.getBuildings();
            ArrayList<Long> ids = new ArrayList<Long>();
            if (this.isBuildingsAllowed()) {
                for (CmsElementSummary ele : buildings) {
                    BuildingPanel p = new BuildingPanel(ele);
                    this.panelPlanList.add(p);
                    this.dsh.addDragComponent(p);
                    ArrayList buildingPlans = this.project.getPlansForBuilding(ele.getId());
                    for (CmsElementSummary buildingPlan : buildingPlans) {
                        PlanPanel p2 = new PlanPanel(buildingPlan);
                        this.panelPlanList.add(p2);
                        this.dsh.addDragComponent(p2);
                        ids.add(buildingPlan.getId());
                    }
                }
            }
            ArrayList plansWithoutBuilding = this.project.getPlansForBuilding(-1L);
            int idx = 0;
            for (CmsElementSummary ele : plans) {
                if (ids.contains(ele.getId())) continue;
                PlanPanel p2 = new PlanPanel(ele);
                this.panelPlanList.add((Component)p2, idx);
                ++idx;
                this.dsh.addDragComponent(p2);
            }
        }
    }

    private void editPlan() {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
    }

    private void deletePlan() {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
    }

    private void rotatePlan(int angle, boolean withLocations) {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.locListSettings = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.panelPlanList = new JPanel();
        this.jPanel7 = new JPanel();
        this.btnAddPlan = new JButton();
        this.btnAddBuilding = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.btnUserAction = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.locListSettings.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_settings.gif")));
        Mnemonics.setLocalizedText((JLabel)this.locListSettings, (String)NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.locListSettings.text"));
        this.locListSettings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PlanListPanel.this.locListSettingsMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.locListSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.panelPlanList.setLayout(new BoxLayout(this.panelPlanList, 3));
        this.jScrollPane1.setViewportView(this.panelPlanList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.btnAddPlan.setFont(THEMIS.fontButton);
        this.btnAddPlan.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/plan_add24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddPlan, (String)NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.btnAddPlan.text"));
        this.btnAddPlan.setToolTipText(NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.btnAddPlan.toolTipText"));
        this.btnAddPlan.setBorder(new SoftBevelBorder(0));
        this.btnAddPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanListPanel.this.btnAddPlanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.btnAddPlan, gridBagConstraints);
        this.btnAddBuilding.setFont(THEMIS.fontButton);
        this.btnAddBuilding.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/building_add24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddBuilding, (String)NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.btnAddBuilding.text"));
        this.btnAddBuilding.setToolTipText(NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.btnAddBuilding.toolTipText"));
        this.btnAddBuilding.setBorder(new SoftBevelBorder(0));
        this.btnAddBuilding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanListPanel.this.btnAddBuildingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.btnAddBuilding, gridBagConstraints);
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.btnEdit.text"));
        this.btnEdit.setToolTipText(NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.btnEdit.toolTipText"));
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.setMaximumSize(null);
        this.btnEdit.setMinimumSize(null);
        this.btnEdit.setPreferredSize(null);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanListPanel.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.btnEdit, gridBagConstraints);
        this.btnRemove.setFont(THEMIS.fontButton);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.btnRemove.toolTipText"));
        this.btnRemove.setBorder(new SoftBevelBorder(0));
        this.btnRemove.setMaximumSize(null);
        this.btnRemove.setMinimumSize(null);
        this.btnRemove.setPreferredSize(null);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanListPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.btnRemove, gridBagConstraints);
        this.btnUserAction.setFont(THEMIS.fontButton);
        this.btnUserAction.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/menu_options24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUserAction, (String)NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.btnUserAction.text"));
        this.btnUserAction.setToolTipText(NbBundle.getMessage(PlanListPanel.class, (String)"PlanListPanel.btnUserAction.toolTipText"));
        this.btnUserAction.setBorder(new SoftBevelBorder(0));
        this.btnUserAction.setDisabledIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/menu_options_disabled24.gif")));
        this.btnUserAction.setMaximumSize(null);
        this.btnUserAction.setMinimumSize(null);
        this.btnUserAction.setPreferredSize(null);
        this.btnUserAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanListPanel.this.btnUserActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.btnUserAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jPanel7, gridBagConstraints);
    }

    private void locListSettingsMouseClicked(MouseEvent evt) {
        if (!this.project.isOpen() || ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        ProjectSettingsPanel panel = new ProjectSettingsPanel();
        panel.showTopic("PageLocList");
        panel.showDialog();
        this.populate();
    }

    private void btnAddPlanActionPerformed(ActionEvent evt) {
    }

    private void btnAddBuildingActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        CreateBuildingPanel panel = new CreateBuildingPanel();
        panel.showDialog();
        if (panel.isBuildingCreated()) {
            this.populate();
        }
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.editPlan();
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.deletePlan();
    }

    private void btnUserActionActionPerformed(ActionEvent evt) {
        this.showActionMenu();
    }
}

