/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.planviewer.planlist;

import at.grid.cms.element.CmsElementSummary;
import at.grid.gui.Point;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ThemisActions;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PlanPanel
extends JPanel {
    CmsElementSummary planSummary;
    CmsPlan plan;
    boolean calibVisible = false;
    int calibPoint;
    double calibPlanX1;
    double calibPlanY1;
    double calibPlanX2;
    double calibPlanY2;
    private ItemListener planVersionChanged;
    private JButton btnCalibPlan1;
    private JButton btnCalibPlan2;
    private JButton btnCalibRemove;
    private JButton btnCalibSave;
    private JButton btnCreateNewVersion;
    private JButton btnDeleteVersion;
    private JButton btnShowHidePoints;
    private JButton btnToggleCalib;
    private JTextField fldCalibPlan1;
    private JTextField fldCalibPlan2;
    private JComboBox<CmsElementSummary> fldPlanVersions;
    private JCheckBox jCheckBox1;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblPlanTitle;
    private JPanel panelCalib;

    public PlanPanel(CmsElementSummary p) {
        this.initComponents();
        this.planSummary = p;
        this.planVersionChanged = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PlanPanel.this.changePlanVersion();
            }
        };
        this.populate();
    }

    private CmsPlan getPlan() {
        if (this.plan == null) {
            this.plan = (CmsPlan)this.planSummary.getElement();
        }
        return this.plan;
    }

    public void populate() {
        this.lblPlanTitle.setText(this.planSummary.getTitle());
        this.panelCalib.setVisible(this.calibVisible);
        if (this.calibVisible) {
            this.getPlan();
            this.fldPlanVersions.removeItemListener(this.planVersionChanged);
            ((DefaultComboBoxModel)this.fldPlanVersions.getModel()).removeAllElements();
            List planfiles = this.plan.getPlanfiles();
            for (CmsElementSummary planfile : planfiles) {
                ((DefaultComboBoxModel)this.fldPlanVersions.getModel()).addElement(planfile);
                if (planfile.getId() != this.plan.getCurrentPlanfileId()) continue;
                this.fldPlanVersions.setSelectedItem(planfile);
            }
            this.fldPlanVersions.addItemListener(this.planVersionChanged);
            boolean isPlanCalibrated = this.plan.isCalibrated();
            boolean isPlanVersionCalibrated = this.plan.getCurrentPlanfileElement().isCalibrated();
            boolean bl = this.plan.isCurrentPlanfileCalibrationBase();
        }
    }

    private void deleteCurrentPlanVersion() {
        if (this.plan == null || this.plan.getPlanfiles().size() < 2 || ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        if (!Dialogs.getInstance().showConfirmDialog("dialog.deletePlanVersion.text", "dialog.deletePlanVersion.title")) {
            return;
        }
        this.plan.deleteCurrentPlanfile();
        this.plan.save();
        this.changePlanVersion();
    }

    private void changePlanVersion() {
        if (this.plan != null) {
            CmsElementSummary v = (CmsElementSummary)this.fldPlanVersions.getSelectedItem();
            if (v != null) {
                this.plan.reload();
                this.plan.setCurrentPlanfile(v.getId());
                this.plan.save();
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(this.plan.getId()).from((Object)this, "new plan selected"));
            }
            this.populate();
        }
    }

    private void updateCalibrationSaveButton() {
        this.btnCalibSave.setEnabled(!"".equals(this.fldCalibPlan1.getText()) && !"".equals(this.fldCalibPlan2.getText()));
    }

    private void savePlanCalibration() {
        if (this.plan == null) {
            ThemisApplication.getInstance().getDialog().showWarningDialog("NO_PLAN");
            return;
        }
        this.plan.reload();
        String calibMethodText = "";
        this.plan.updateCalibration(1, this.calibPlanX1, this.calibPlanY1, this.calibPlanX2, this.calibPlanY2, 0.0, 0.0, 100.0, 100.0);
        this.plan.save();
        ThemisApplication.getInstance().getProject().createActionLog("plan_calibrated", this.plan.getId(), "Method: " + calibMethodText);
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SAVED.setId(this.plan.getId()));
        this.populate();
    }

    private void removePlanCalibration() {
        this.getPlan();
        this.plan.reload();
        this.plan.removeCalibration();
        this.plan.save();
        ThemisApplication.getInstance().getProject().createActionLog("plan_calibrationremoved", this.plan.getId(), "");
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SAVED.setId(this.plan.getId()));
        this.populate();
    }

    private void updateCalibPoints(boolean forceShow) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(this.calibPlanX1, this.calibPlanY1));
        points.add(new Point(this.calibPlanX2, this.calibPlanY2));
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.ACTION_SHOW_CALIBPOINT.setReference(points).setFlag(forceShow ? Boolean.valueOf(true) : null), true);
    }

    private void initComponents() {
        this.jCheckBox1 = new JCheckBox();
        this.lblPlanTitle = new JLabel();
        this.btnToggleCalib = new JButton();
        this.panelCalib = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel14 = new JLabel();
        this.fldPlanVersions = new JComboBox();
        this.btnDeleteVersion = new JButton();
        this.btnCreateNewVersion = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldCalibPlan1 = new JTextField();
        this.btnCalibPlan1 = new JButton();
        this.jLabel7 = new JLabel();
        this.fldCalibPlan2 = new JTextField();
        this.btnCalibPlan2 = new JButton();
        this.jPanel3 = new JPanel();
        this.btnShowHidePoints = new JButton();
        this.btnCalibSave = new JButton();
        this.btnCalibRemove = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.jCheckBox1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jCheckBox1, gridBagConstraints);
        this.lblPlanTitle.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblPlanTitle, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.lblPlanTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblPlanTitle, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnToggleCalib, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnToggleCalib.text"));
        this.btnToggleCalib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnToggleCalibActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnToggleCalib, gridBagConstraints);
        this.panelCalib.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel14.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.jLabel14.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel14, gridBagConstraints);
        this.fldPlanVersions.setFont(THEMIS.fontTextfield);
        this.fldPlanVersions.setModel(new DefaultComboBoxModel());
        this.fldPlanVersions.setMinimumSize(new Dimension(5, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add(this.fldPlanVersions, gridBagConstraints);
        this.btnDeleteVersion.setFont(THEMIS.fontButton);
        this.btnDeleteVersion.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteVersion, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnDeleteVersion.text"));
        this.btnDeleteVersion.setMinimumSize(new Dimension(10, 40));
        this.btnDeleteVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnDeleteVersionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnDeleteVersion, gridBagConstraints);
        this.btnCreateNewVersion.setFont(THEMIS.fontButton);
        this.btnCreateNewVersion.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateNewVersion, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnCreateNewVersion.text"));
        this.btnCreateNewVersion.setMinimumSize(new Dimension(10, 40));
        this.btnCreateNewVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnCreateNewVersionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnCreateNewVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelCalib.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.fldCalibPlan1.setEditable(false);
        this.fldCalibPlan1.setFont(THEMIS.fontTextfield);
        this.fldCalibPlan1.setText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.fldCalibPlan1.text"));
        this.fldCalibPlan1.setMinimumSize(new Dimension(5, 24));
        this.fldCalibPlan1.setPreferredSize(new Dimension(285, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldCalibPlan1, gridBagConstraints);
        this.btnCalibPlan1.setFont(THEMIS.fontButton);
        this.btnCalibPlan1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/locateInPlan24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCalibPlan1, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnCalibPlan1.text"));
        this.btnCalibPlan1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnCalibPlan1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnCalibPlan1, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.fldCalibPlan2.setEditable(false);
        this.fldCalibPlan2.setFont(THEMIS.fontTextfield);
        this.fldCalibPlan2.setText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.fldCalibPlan2.text"));
        this.fldCalibPlan2.setMinimumSize(new Dimension(5, 24));
        this.fldCalibPlan2.setPreferredSize(new Dimension(285, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldCalibPlan2, gridBagConstraints);
        this.btnCalibPlan2.setFont(THEMIS.fontButton);
        this.btnCalibPlan2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/locateInPlan24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCalibPlan2, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnCalibPlan2.text"));
        this.btnCalibPlan2.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnCalibPlan2.toolTipText"));
        this.btnCalibPlan2.setMinimumSize(new Dimension(5, 32));
        this.btnCalibPlan2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnCalibPlan2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnCalibPlan2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelCalib.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.btnShowHidePoints.setFont(THEMIS.fontButton);
        this.btnShowHidePoints.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/createPoint24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowHidePoints, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnShowHidePoints.text"));
        this.btnShowHidePoints.setMinimumSize(new Dimension(10, 32));
        this.btnShowHidePoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnShowHidePointsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnShowHidePoints, gridBagConstraints);
        this.btnCalibSave.setFont(THEMIS.fontButton);
        this.btnCalibSave.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCalibSave, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnCalibSave.text"));
        this.btnCalibSave.setBorder(new SoftBevelBorder(0));
        this.btnCalibSave.setMinimumSize(new Dimension(5, 30));
        this.btnCalibSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnCalibSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnCalibSave, gridBagConstraints);
        this.btnCalibRemove.setFont(THEMIS.fontButton);
        this.btnCalibRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCalibRemove, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnCalibRemove.text"));
        this.btnCalibRemove.setBorder(new SoftBevelBorder(0));
        this.btnCalibRemove.setMinimumSize(new Dimension(5, 30));
        this.btnCalibRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnCalibRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnCalibRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelCalib.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.panelCalib, gridBagConstraints);
    }

    private void btnDeleteVersionActionPerformed(ActionEvent evt) {
        this.deleteCurrentPlanVersion();
    }

    private void btnCreateNewVersionActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)ThemisApplication.getInstance())) {
            return;
        }
        if (this.plan != null) {
            ThemisActions.editPlan(this.plan, true);
        }
    }

    private void btnCalibPlan1ActionPerformed(ActionEvent evt) {
        this.calibPoint = 1;
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.CREATE_POINT_IN_PLAN_START.setReference((Object)this));
    }

    private void btnCalibPlan2ActionPerformed(ActionEvent evt) {
        this.calibPoint = 2;
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.CREATE_POINT_IN_PLAN_START.setReference((Object)this));
    }

    private void btnCalibSaveActionPerformed(ActionEvent evt) {
        this.savePlanCalibration();
        ThemisApplication.getInstance().getFilter().resetSearchResult();
    }

    private void btnCalibRemoveActionPerformed(ActionEvent evt) {
        this.removePlanCalibration();
        ThemisApplication.getInstance().getFilter().resetSearchResult();
    }

    private void btnShowHidePointsActionPerformed(ActionEvent evt) {
        this.updateCalibPoints(false);
    }

    private void btnToggleCalibActionPerformed(ActionEvent evt) {
        this.calibVisible = !this.calibVisible;
        this.populate();
    }
}

