/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.project;

import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.javafx.ThemisTaskResult;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import at.grid.util.XML;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.SoftBevelBorder;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ExportThemisFilePanel
extends ThemisPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    private JButton btnChooseFile;
    private JButton btnDialogCancel;
    private JButton btnDialogExport;
    private JButton btnDialogExportShow;
    private JToggleButton btnDocumentsAll;
    private JToggleButton btnDocumentsNone;
    private JToggleButton btnDocumentsRelevant;
    private JToggleButton btnExportEvent;
    private JToggleButton btnExportFilter;
    private JToggleButton btnExportNodata;
    private JToggleButton btnExportProject;
    private JToggleButton btnExportSelect;
    private JToggleButton btnFotoAll;
    private JToggleButton btnFotoNone;
    private JToggleButton btnFotoRecent;
    private JToggleButton btnPlanAll;
    private JToggleButton btnPlanBuilding;
    private JToggleButton btnPlanNone;
    private JToggleButton btnPlanRelevant;
    private JToggleButton btnTargetCloud;
    private JToggleButton btnTargetEmail;
    private JToggleButton btnTargetFile;
    private JToggleButton btnTemplateAll;
    private JToggleButton btnTemplateNone;
    private JToggleButton btnTemplateRelevant;
    private JCheckBox chkAsTemplate;
    private JCheckBox chkExportFileWithDate;
    private JTextField fldCloud;
    private JTextField fldEmail;
    private JComboBox<CmsBasicElement> fldEvent;
    private JTextField fldExportFile;
    private JTextField fldFolder;
    private JPasswordField fldPassword;
    private ButtonGroup grpContent;
    private ButtonGroup grpDocuments;
    private ButtonGroup grpFoto;
    private ButtonGroup grpPlan;
    private ButtonGroup grpVorlagen;
    private ButtonGroup grpZiel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JLabel lblCount;
    private JLabel lblObs;
    private JLabel lblPassword;
    private JPanel panelAddon;
    private JPanel panelCount;
    private JPanel panelData;
    private JPanel panelDialogButtons;
    private JPanel panelTargetCards;
    private JPanel panelTargetCloud;
    private JPanel panelTargetEmail;
    private JPanel panelTargetFile;
    private JPanel panelZiel;

    public ExportThemisFilePanel() {
        this.initComponents();
        THEMIS.setCheckboxIcon(this.chkAsTemplate);
        this.btnTemplateRelevant.setVisible(false);
        this.btnFotoRecent.setVisible(false);
        this.populate();
        this.btnDialogExport.requestFocus();
        this.btnDialogExportShow.setVisible(false);
    }

    @Override
    public void populate(ProgressHandler ph) {
        DefaultComboBoxModel modelEvent = (DefaultComboBoxModel)this.fldEvent.getModel();
        modelEvent.removeAllElements();
        if (this.project.getSelectionManager().getCurrentEventId() > 0L) {
            modelEvent.addElement(new CmsBasicElement(-1L, this.project.getResourceText("core.text.currentevent")));
        }
        ArrayList events = this.project.getEvents();
        for (CmsElementSummary event : events) {
            modelEvent.addElement(event.toBasicElement());
        }
        if (!events.isEmpty()) {
            this.fldEvent.setSelectedIndex(0);
        } else {
            this.btnExportEvent.setEnabled(false);
        }
        this.fromXml(this.app.getSettings().getExportThemis());
        this.btnDialogExport.requestFocus();
    }

    @Override
    public void apply() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String createFilename() {
        String dt = "_" + Util.formatDate((Date)new Date(), (String)Util.DATE_ISO, (TimeZone)this.project.getTimeZone());
        boolean withDate = this.chkExportFileWithDate.isSelected();
        String fn = this.fldExportFile.getText();
        if (fn.equals("")) {
            fn = this.project.getProjectFolder().getName();
        }
        fn = fn.replaceAll(dt, "").replaceAll(".themis", "") + (withDate ? dt : "") + ".themis";
        return fn;
    }

    private void updateCount() {
        this.btnPlanBuilding.setVisible(false);
        if (this.btnExportEvent.isSelected()) {
            CmsBasicElement ele = (CmsBasicElement)this.fldEvent.getSelectedItem();
            if (ele == null) {
                return;
            }
            CmsEvent ev = null;
            ev = ele.getId() == -1L ? this.project.getCurrentEvent() : (CmsEvent)this.project.loadElement(ele.getId(), this.project.getUser());
            if (ev != null) {
                this.lblCount.setText(Integer.toString(ev.getRelationAttribute("histories").size()));
            } else {
                this.lblCount.setText("-");
            }
            if (this.btnPlanBuilding.isSelected()) {
                this.btnPlanAll.setSelected(true);
            }
        } else if (this.btnExportFilter.isSelected()) {
            this.lblCount.setText(Integer.toString(ThemisApplication.getInstance().getFilter().getFilteredObservations().size()));
            this.btnPlanBuilding.setVisible(!ThemisApplication.getInstance().getFilter().getLocBuildingId().isEmpty());
            if (this.btnPlanBuilding.isSelected() && !this.btnPlanBuilding.isVisible()) {
                this.btnPlanAll.setSelected(true);
            }
        } else if (this.btnExportProject.isSelected()) {
            this.lblCount.setText(Integer.toString(this.project.getObservationCount()));
            this.btnPlanBuilding.setVisible(!ThemisApplication.getInstance().getFilter().getLocBuildingId().isEmpty());
            if (this.btnPlanBuilding.isSelected() && !this.btnPlanBuilding.isVisible()) {
                this.btnPlanAll.setSelected(true);
            }
        } else if (this.btnExportSelect.isSelected()) {
            this.lblCount.setText(Integer.toString(this.project.getSelectionManager().getSelectedObservationIds().size()));
            if (this.btnPlanBuilding.isSelected()) {
                this.btnPlanAll.setSelected(true);
            }
        } else if (this.btnExportNodata.isSelected()) {
            this.lblCount.setText("0");
            this.btnPlanBuilding.setVisible(!ThemisApplication.getInstance().getFilter().getLocBuildingId().isEmpty());
            if (this.btnPlanBuilding.isSelected() && !this.btnPlanBuilding.isVisible()) {
                this.btnPlanAll.setSelected(true);
            }
        } else {
            this.lblCount.setText("-");
        }
        this.lblCount.revalidate();
        this.lblCount.repaint();
    }

    public void fromXml(Element xml) {
        String target;
        String documentoption;
        String templateoption;
        String planoption;
        String imageoption;
        String content;
        switch (content = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/content", (String)"event")) {
            case "event": {
                if (this.fldEvent.getItemCount() == 0) {
                    this.btnExportEvent.setEnabled(false);
                    this.btnExportFilter.setSelected(true);
                    this.fldEvent.setEnabled(false);
                    break;
                }
                long id = Util.parseLong((String)XML.getXPathAttributeValue((Element)xml, (String)"/themis/project/export/themis/content/@id", (String)"-1"), (long)-1L);
                this.btnExportEvent.setSelected(true);
                DefaultComboBoxModel modelEvent = (DefaultComboBoxModel)this.fldEvent.getModel();
                if (modelEvent.getSize() > 0) {
                    int sel = 0;
                    for (int ii = 0; ii < modelEvent.getSize(); ++ii) {
                        if (((CmsBasicElement)modelEvent.getElementAt(ii)).getId() != id) continue;
                        sel = ii;
                    }
                    this.fldEvent.setSelectedIndex(sel);
                }
                this.fldEvent.setEnabled(true);
                break;
            }
            case "filter": {
                this.btnExportFilter.setSelected(true);
                this.fldEvent.setEnabled(false);
                break;
            }
            case "project": {
                this.btnExportProject.setSelected(true);
                this.fldEvent.setEnabled(false);
                this.btnFotoAll.setSelected(true);
                this.btnPlanAll.setSelected(true);
                this.btnTemplateAll.setSelected(true);
                this.btnDocumentsAll.setSelected(true);
                break;
            }
            case "selection": {
                this.btnExportSelect.setSelected(true);
                this.fldEvent.setEnabled(false);
                break;
            }
            case "none": {
                this.btnExportNodata.setSelected(true);
                this.fldEvent.setEnabled(false);
            }
        }
        switch (imageoption = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/images", (String)"none")) {
            case "none": {
                this.btnFotoNone.setSelected(true);
                break;
            }
            case "recent": {
                this.btnFotoRecent.setSelected(true);
                break;
            }
            case "all": {
                this.btnFotoAll.setSelected(true);
            }
        }
        switch (planoption = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/plans", (String)"all")) {
            case "none": {
                this.btnPlanNone.setSelected(true);
                break;
            }
            case "relevant": {
                this.btnPlanRelevant.setSelected(true);
                break;
            }
            case "all": {
                this.btnPlanAll.setSelected(true);
            }
        }
        switch (templateoption = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/templates", (String)"all")) {
            case "none": {
                this.btnTemplateNone.setSelected(true);
                break;
            }
            case "relevant": {
                this.btnTemplateRelevant.setSelected(true);
                break;
            }
            case "all": {
                this.btnTemplateAll.setSelected(true);
            }
        }
        switch (documentoption = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/documents", (String)"all")) {
            case "none": {
                this.btnDocumentsNone.setSelected(true);
                break;
            }
            case "relevant": {
                this.btnDocumentsRelevant.setSelected(true);
                break;
            }
            case "all": {
                this.btnDocumentsAll.setSelected(true);
            }
        }
        switch (target = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/target/mode", (String)"file")) {
            case "file": {
                this.btnTargetFile.setSelected(true);
                break;
            }
            case "cloud": {
                this.btnTargetCloud.setSelected(true);
                break;
            }
            case "email": {
                this.btnTargetEmail.setSelected(true);
            }
        }
        String fn = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/target/file");
        if (fn != null) {
            File f = new File(fn);
            this.fldFolder.setText(f.getParentFile().getAbsolutePath());
            this.fldExportFile.setText(this.createFilename());
        } else {
            this.fldFolder.setText(this.app.getSettings().getFolderThemisIO().getValueAsPath(true));
            this.fldExportFile.setText(this.createFilename());
        }
        String url = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/target/url");
        this.fldCloud.setText(url == null ? "" : url);
        String email = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/target/email");
        this.fldEmail.setText(email == null ? "" : email);
        this.updateCount();
    }

    public Element toXml() {
        Element themis = new Element("themis");
        Element content = new Element("content");
        if (this.btnExportEvent.isSelected()) {
            content.setText("event");
            content.setAttribute("id", Long.toString(((CmsBasicElement)this.fldEvent.getSelectedItem()).getId()));
        } else if (this.btnExportFilter.isSelected()) {
            content.setText("filter");
        } else if (this.btnExportProject.isSelected()) {
            content.setText("project");
        } else if (this.btnExportSelect.isSelected()) {
            content.setText("selection");
        } else if (this.btnExportNodata.isSelected()) {
            content.setText("none");
        }
        themis.addContent((Content)content);
        Element imageoption = new Element("images");
        if (this.btnFotoNone.isSelected()) {
            imageoption.setText("none");
        } else if (this.btnFotoRecent.isSelected()) {
            imageoption.setText("recent");
        } else if (this.btnFotoAll.isSelected()) {
            imageoption.setText("all");
        }
        themis.addContent((Content)imageoption);
        Element planoption = new Element("plans");
        if (this.btnPlanNone.isSelected()) {
            planoption.setText("none");
        } else if (this.btnPlanRelevant.isSelected()) {
            planoption.setText("relevant");
        } else if (this.btnPlanAll.isSelected()) {
            planoption.setText("all");
        }
        themis.addContent((Content)planoption);
        Element templateoption = new Element("templates");
        if (this.btnTemplateNone.isSelected()) {
            templateoption.setText("none");
        } else if (this.btnTemplateRelevant.isSelected()) {
            templateoption.setText("relevant");
        } else if (this.btnTemplateAll.isSelected()) {
            templateoption.setText("all");
        }
        themis.addContent((Content)templateoption);
        Element documentsoption = new Element("documents");
        if (this.btnDocumentsNone.isSelected()) {
            documentsoption.setText("none");
        } else if (this.btnDocumentsRelevant.isSelected()) {
            documentsoption.setText("relevant");
        } else if (this.btnDocumentsAll.isSelected()) {
            documentsoption.setText("all");
        }
        themis.addContent((Content)documentsoption);
        Element target = new Element("target");
        if (this.btnTargetFile.isSelected()) {
            target.addContent((Content)new Element("mode").setText("file"));
        } else if (this.btnTargetEmail.isSelected()) {
            target.addContent((Content)new Element("mode").setText("email"));
        } else if (this.btnTargetCloud.isSelected()) {
            target.addContent((Content)new Element("mode").setText("cloud"));
        }
        File f = this.getFile();
        target.addContent((Content)new Element("file").setText(f.getAbsolutePath()));
        target.addContent((Content)new Element("email").setText(this.fldEmail.getText()));
        target.addContent((Content)new Element("url").setText(this.fldCloud.getText()));
        themis.addContent((Content)target);
        String s = Util.toXml((Element)themis);
        return themis;
    }

    public File getFile() {
        File fld = new File(this.fldFolder.getText());
        fld.mkdirs();
        String fn = this.fldExportFile.getText();
        if ("".equals(fn)) {
            fn = this.createFilename();
        }
        if (!fn.toLowerCase().endsWith(".themis")) {
            fn = fn + ".themis";
        }
        if (!this.btnTargetFile.isSelected()) {
            return new File(this.project.getTempfileLocation(), fn);
        }
        return new File(fld, fn);
    }

    private boolean export() {
        File exportFile = this.getFile();
        if (exportFile == null) {
            Dialogs.getInstance().showErrorDialog("error.no-file-selected");
            return false;
        }
        if (this.btnTargetFile.isSelected() && exportFile.isFile() && !this.app.getDialog().showConfirmDialog("ask.overwrite-file", "", (Object[])new String[]{exportFile.getName()})) {
            return false;
        }
        if (exportFile.exists()) {
            exportFile.delete();
        }
        ThemisTaskResult result = new ThemisTaskResult();
        ThemisTaskWithDialog.createTaskWithCounter("task.export-themis", ph -> {
            try {
                ThemisFile tf;
                if (this.btnExportProject.isSelected()) {
                    tf = this.project.getProjectAsThemisFile();
                } else {
                    tf = new ThemisFile(ph);
                    if (this.chkAsTemplate.isSelected()) {
                        tf.setAsProjectTemplate();
                    } else {
                        if (!this.btnFotoNone.isSelected()) {
                            tf.setWithAllImages();
                        }
                        if (!this.btnTemplateNone.isSelected()) {
                            tf.setWithTemplates();
                        } else {
                            tf.setWithoutTemplates();
                        }
                        if (this.btnDocumentsRelevant.isSelected()) {
                            tf.setWithRelevantDocuments();
                        } else if (this.btnDocumentsAll.isSelected()) {
                            tf.setWithDocuments();
                        } else {
                            tf.setWithoutDocuments();
                        }
                        if (this.btnPlanRelevant.isSelected()) {
                            tf.setWithPlansForLocations();
                        } else if (this.btnPlanAll.isSelected()) {
                            tf.setWithPlans();
                        }
                    }
                }
                if (this.btnExportEvent.isSelected()) {
                    long eventId = ((CmsBasicElement)this.fldEvent.getSelectedItem()).getId();
                    if (eventId == -1L) {
                        eventId = this.project.getSelectionManager().getCurrentEventId();
                    }
                    if (eventId < 0L) {
                        Dialogs.getInstance().showErrorDialog("error.no-event-selected");
                        result.setOk(false);
                        return;
                    }
                    tf.setEvent(eventId);
                    tf.setContentType(ThemisFile.ContentType.EVENT);
                } else if (this.btnExportFilter.isSelected()) {
                    tf.addContent(this.app.getFilter().getFilteredLocationIds());
                    tf.addContent(this.app.getFilter().getFilteredObservationIds());
                } else if (this.btnExportSelect.isSelected()) {
                    tf.addContent(this.project.getSelectionManager().getSelectedObservationIds());
                }
                tf.saveToFile(exportFile, true);
                if (!exportFile.isFile()) {
                    Dialogs.getInstance().showErrorDialog("error.cannot-create-themisfile");
                    result.setOk(false);
                    return;
                }
                result.setOk(true);
                if (this.btnTargetEmail.isSelected()) {
                    THEMIS.prepareEmail(null, "THEMIS " + this.project.getProjectElement().getTitle(), "", false, exportFile);
                } else if (this.btnTargetCloud.isSelected()) {
                    if (this.fldCloud.getText().equals("")) {
                        Dialogs.getInstance().showErrorDialog("error.no-url");
                        result.setOk(false);
                        return;
                    }
                    String pwd = String.valueOf(this.fldPassword.getPassword());
                    if ("".equals(pwd)) {
                        pwd = null;
                    }
                    THEMIS.uploadFileToNextcloud(this.fldCloud.getText(), pwd, exportFile);
                } else {
                    THEMIS.showFileResultDialog(exportFile, false);
                }
            }
            catch (IOException ex) {
                this.app.getDialog().showErrorDialog("error.file-cannot-be-created", (Exception)ex);
                ex.printStackTrace();
                result.setOk(false);
            }
        });
        return result.isOk();
    }

    private void initComponents() {
        this.grpPlan = new ButtonGroup();
        this.grpFoto = new ButtonGroup();
        this.grpContent = new ButtonGroup();
        this.grpVorlagen = new ButtonGroup();
        this.grpZiel = new ButtonGroup();
        this.grpDocuments = new ButtonGroup();
        this.panelData = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel5 = new JPanel();
        this.btnExportEvent = new JToggleButton();
        this.btnExportFilter = new JToggleButton();
        this.btnExportSelect = new JToggleButton();
        this.btnExportProject = new JToggleButton();
        this.btnExportNodata = new JToggleButton();
        this.jLabel4 = new JLabel();
        this.fldEvent = new JComboBox();
        this.jLabel12 = new JLabel();
        this.chkAsTemplate = new JCheckBox();
        this.panelCount = new JPanel();
        this.jLabel15 = new JLabel();
        this.lblCount = new JLabel();
        this.lblObs = new JLabel();
        this.panelAddon = new JPanel();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel6 = new JLabel();
        this.btnFotoNone = new JToggleButton();
        this.btnFotoRecent = new JToggleButton();
        this.btnFotoAll = new JToggleButton();
        this.jLabel7 = new JLabel();
        this.btnPlanNone = new JToggleButton();
        this.btnPlanRelevant = new JToggleButton();
        this.btnPlanBuilding = new JToggleButton();
        this.btnPlanAll = new JToggleButton();
        this.jLabel8 = new JLabel();
        this.btnTemplateNone = new JToggleButton();
        this.btnTemplateRelevant = new JToggleButton();
        this.btnTemplateAll = new JToggleButton();
        this.jLabel14 = new JLabel();
        this.btnDocumentsNone = new JToggleButton();
        this.btnDocumentsRelevant = new JToggleButton();
        this.btnDocumentsAll = new JToggleButton();
        this.jLabel10 = new JLabel();
        this.panelZiel = new JPanel();
        this.jLabel9 = new JLabel();
        this.jPanel6 = new JPanel();
        this.btnTargetFile = new JToggleButton();
        this.btnTargetCloud = new JToggleButton();
        this.btnTargetEmail = new JToggleButton();
        this.panelTargetCards = new JPanel();
        this.panelTargetEmail = new JPanel();
        this.jLabel13 = new JLabel();
        this.fldEmail = new JTextField();
        this.panelTargetFile = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldFolder = new JTextField();
        this.btnChooseFile = new JButton();
        this.panelTargetCloud = new JPanel();
        this.jLabel11 = new JLabel();
        this.fldCloud = new JTextField();
        this.lblPassword = new JLabel();
        this.fldPassword = new JPasswordField();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.fldExportFile = new JTextField();
        this.chkExportFileWithDate = new JCheckBox();
        this.panelDialogButtons = new JPanel();
        this.btnDialogCancel = new JButton();
        this.btnDialogExport = new JButton();
        this.btnDialogExportShow = new JButton();
        this.setMinimumSize(new Dimension(660, 560));
        this.setPreferredSize(new Dimension(660, 560));
        this.setLayout(new GridBagLayout());
        this.panelData.setLayout(new GridBagLayout());
        this.jLabel3.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel3.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jLabel3, gridBagConstraints);
        this.jPanel5.setMinimumSize(new Dimension(200, 30));
        this.jPanel5.setPreferredSize(new Dimension(500, 30));
        this.jPanel5.setLayout(new GridLayout(1, 0, 10, 5));
        this.grpContent.add(this.btnExportEvent);
        this.btnExportEvent.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportEvent, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnExportEvent.text"));
        this.btnExportEvent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportThemisFilePanel.this.btnExportEventItemStateChanged(evt);
            }
        });
        this.jPanel5.add(this.btnExportEvent);
        this.grpContent.add(this.btnExportFilter);
        this.btnExportFilter.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportFilter, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnExportFilter.text"));
        this.btnExportFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportThemisFilePanel.this.btnExportFilterItemStateChanged(evt);
            }
        });
        this.btnExportFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportThemisFilePanel.this.btnExportFilterActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.btnExportFilter);
        this.grpContent.add(this.btnExportSelect);
        this.btnExportSelect.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportSelect, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnExportSelect.text"));
        this.btnExportSelect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportThemisFilePanel.this.btnExportSelectItemStateChanged(evt);
            }
        });
        this.jPanel5.add(this.btnExportSelect);
        this.grpContent.add(this.btnExportProject);
        this.btnExportProject.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportProject, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnExportProject.text"));
        this.btnExportProject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportThemisFilePanel.this.btnExportProjectItemStateChanged(evt);
            }
        });
        this.jPanel5.add(this.btnExportProject);
        this.grpContent.add(this.btnExportNodata);
        this.btnExportNodata.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportNodata, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnExportNodata.text"));
        this.btnExportNodata.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportThemisFilePanel.this.btnExportNodataItemStateChanged(evt);
            }
        });
        this.btnExportNodata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportThemisFilePanel.this.btnExportNodataActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.btnExportNodata);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jPanel5, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jLabel4, gridBagConstraints);
        this.fldEvent.setFont(THEMIS.fontList);
        this.fldEvent.setModel(new DefaultComboBoxModel());
        this.fldEvent.setPreferredSize(new Dimension(28, 30));
        this.fldEvent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportThemisFilePanel.this.fldEventItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add(this.fldEvent, gridBagConstraints);
        this.jLabel12.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel12.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jLabel12, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkAsTemplate, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.chkAsTemplate.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.chkAsTemplate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelData, gridBagConstraints);
        this.panelCount.setLayout(new GridBagLayout());
        this.jLabel15.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel15.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelCount.add((Component)this.jLabel15, gridBagConstraints);
        this.lblCount.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblCount, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.lblCount.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelCount.add((Component)this.lblCount, gridBagConstraints);
        this.lblObs.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObs, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.lblObs.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelCount.add((Component)this.lblObs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.panelCount, gridBagConstraints);
        this.panelAddon.setLayout(new GridBagLayout());
        this.jLabel5.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAddon.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jLabel6, gridBagConstraints);
        this.grpFoto.add(this.btnFotoNone);
        this.btnFotoNone.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnFotoNone, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnFotoNone.text"));
        this.btnFotoNone.setMinimumSize(new Dimension(60, 30));
        this.btnFotoNone.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnFotoNone, gridBagConstraints);
        this.grpFoto.add(this.btnFotoRecent);
        this.btnFotoRecent.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnFotoRecent, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnFotoRecent.text"));
        this.btnFotoRecent.setMinimumSize(new Dimension(60, 30));
        this.btnFotoRecent.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnFotoRecent, gridBagConstraints);
        this.grpFoto.add(this.btnFotoAll);
        this.btnFotoAll.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnFotoAll, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnFotoAll.text"));
        this.btnFotoAll.setMinimumSize(new Dimension(60, 30));
        this.btnFotoAll.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnFotoAll, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jLabel7, gridBagConstraints);
        this.grpPlan.add(this.btnPlanNone);
        this.btnPlanNone.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnPlanNone, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnPlanNone.text"));
        this.btnPlanNone.setMinimumSize(new Dimension(60, 30));
        this.btnPlanNone.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnPlanNone, gridBagConstraints);
        this.grpPlan.add(this.btnPlanRelevant);
        this.btnPlanRelevant.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnPlanRelevant, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnPlanRelevant.text"));
        this.btnPlanRelevant.setMinimumSize(new Dimension(60, 30));
        this.btnPlanRelevant.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnPlanRelevant, gridBagConstraints);
        this.grpPlan.add(this.btnPlanBuilding);
        this.btnPlanBuilding.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnPlanBuilding, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnPlanBuilding.text"));
        this.btnPlanBuilding.setMinimumSize(new Dimension(60, 30));
        this.btnPlanBuilding.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnPlanBuilding, gridBagConstraints);
        this.grpPlan.add(this.btnPlanAll);
        this.btnPlanAll.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnPlanAll, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnPlanAll.text"));
        this.btnPlanAll.setMinimumSize(new Dimension(60, 30));
        this.btnPlanAll.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnPlanAll, gridBagConstraints);
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jLabel8, gridBagConstraints);
        this.grpVorlagen.add(this.btnTemplateNone);
        this.btnTemplateNone.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTemplateNone, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnTemplateNone.text"));
        this.btnTemplateNone.setMinimumSize(new Dimension(60, 30));
        this.btnTemplateNone.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnTemplateNone, gridBagConstraints);
        this.grpVorlagen.add(this.btnTemplateRelevant);
        this.btnTemplateRelevant.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTemplateRelevant, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnTemplateRelevant.text"));
        this.btnTemplateRelevant.setMinimumSize(new Dimension(60, 30));
        this.btnTemplateRelevant.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnTemplateRelevant, gridBagConstraints);
        this.grpVorlagen.add(this.btnTemplateAll);
        this.btnTemplateAll.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTemplateAll, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnTemplateAll.text"));
        this.btnTemplateAll.setMinimumSize(new Dimension(60, 30));
        this.btnTemplateAll.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnTemplateAll, gridBagConstraints);
        this.jLabel14.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel14.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jLabel14, gridBagConstraints);
        this.grpDocuments.add(this.btnDocumentsNone);
        this.btnDocumentsNone.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDocumentsNone, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnDocumentsNone.text"));
        this.btnDocumentsNone.setMinimumSize(new Dimension(60, 30));
        this.btnDocumentsNone.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnDocumentsNone, gridBagConstraints);
        this.grpDocuments.add(this.btnDocumentsRelevant);
        this.btnDocumentsRelevant.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDocumentsRelevant, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnDocumentsRelevant.text"));
        this.btnDocumentsRelevant.setMinimumSize(new Dimension(60, 30));
        this.btnDocumentsRelevant.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnDocumentsRelevant, gridBagConstraints);
        this.grpDocuments.add(this.btnDocumentsAll);
        this.btnDocumentsAll.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDocumentsAll, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnDocumentsAll.text"));
        this.btnDocumentsAll.setMinimumSize(new Dimension(60, 30));
        this.btnDocumentsAll.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnDocumentsAll, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelAddon.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelAddon, gridBagConstraints);
        this.panelZiel.setLayout(new GridBagLayout());
        this.jLabel9.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 387;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelZiel.add((Component)this.jLabel9, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(200, 30));
        this.jPanel6.setPreferredSize(new Dimension(500, 30));
        this.jPanel6.setLayout(new GridLayout(1, 0, 10, 5));
        this.grpZiel.add(this.btnTargetFile);
        this.btnTargetFile.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTargetFile, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnTargetFile.text"));
        this.btnTargetFile.setMinimumSize(new Dimension(60, 30));
        this.btnTargetFile.setPreferredSize(new Dimension(60, 30));
        this.btnTargetFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportThemisFilePanel.this.btnTargetFileItemStateChanged(evt);
            }
        });
        this.btnTargetFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportThemisFilePanel.this.btnTargetFileActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.btnTargetFile);
        this.grpZiel.add(this.btnTargetCloud);
        this.btnTargetCloud.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTargetCloud, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnTargetCloud.text"));
        this.btnTargetCloud.setMinimumSize(new Dimension(60, 30));
        this.btnTargetCloud.setPreferredSize(new Dimension(60, 30));
        this.btnTargetCloud.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportThemisFilePanel.this.btnTargetCloudItemStateChanged(evt);
            }
        });
        this.jPanel6.add(this.btnTargetCloud);
        this.grpZiel.add(this.btnTargetEmail);
        this.btnTargetEmail.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTargetEmail, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnTargetEmail.text"));
        this.btnTargetEmail.setMinimumSize(new Dimension(60, 30));
        this.btnTargetEmail.setPreferredSize(new Dimension(60, 30));
        this.btnTargetEmail.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportThemisFilePanel.this.btnTargetEmailItemStateChanged(evt);
            }
        });
        this.jPanel6.add(this.btnTargetEmail);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelZiel.add((Component)this.jPanel6, gridBagConstraints);
        this.panelTargetCards.setLayout(new CardLayout());
        this.panelTargetEmail.setLayout(new GridBagLayout());
        this.jLabel13.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel13.text"));
        this.jLabel13.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTargetEmail.add((Component)this.jLabel13, gridBagConstraints);
        this.fldEmail.setFont(THEMIS.fontTextfield);
        this.fldEmail.setText(NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.fldEmail.text"));
        this.fldEmail.setPreferredSize(new Dimension(6, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTargetEmail.add((Component)this.fldEmail, gridBagConstraints);
        this.panelTargetCards.add((Component)this.panelTargetEmail, "cardTargetEmail");
        this.panelTargetFile.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel2.text"));
        this.jLabel2.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTargetFile.add((Component)this.jLabel2, gridBagConstraints);
        this.fldFolder.setEditable(false);
        this.fldFolder.setFont(THEMIS.fontTextfield);
        this.fldFolder.setText(NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.fldFolder.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTargetFile.add((Component)this.fldFolder, gridBagConstraints);
        this.btnChooseFile.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnChooseFile, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnChooseFile.text"));
        this.btnChooseFile.setBorder(new SoftBevelBorder(0));
        this.btnChooseFile.setPreferredSize(new Dimension(73, 30));
        this.btnChooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportThemisFilePanel.this.btnChooseFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTargetFile.add((Component)this.btnChooseFile, gridBagConstraints);
        this.panelTargetCards.add((Component)this.panelTargetFile, "cardTargetFile");
        this.panelTargetCloud.setLayout(new GridBagLayout());
        this.jLabel11.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel11.text"));
        this.jLabel11.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTargetCloud.add((Component)this.jLabel11, gridBagConstraints);
        this.fldCloud.setFont(THEMIS.fontTextfield);
        this.fldCloud.setText(NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.fldCloud.text"));
        this.fldCloud.setPreferredSize(new Dimension(6, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTargetCloud.add((Component)this.fldCloud, gridBagConstraints);
        this.lblPassword.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblPassword, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.lblPassword.text"));
        this.lblPassword.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTargetCloud.add((Component)this.lblPassword, gridBagConstraints);
        this.fldPassword.setText(NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.fldPassword.text"));
        this.fldPassword.setMinimumSize(new Dimension(200, 30));
        this.fldPassword.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTargetCloud.add((Component)this.fldPassword, gridBagConstraints);
        this.panelTargetCards.add((Component)this.panelTargetCloud, "cardTargetCloud");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelZiel.add((Component)this.panelTargetCards, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.jLabel1.text"));
        this.jLabel1.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.fldExportFile.setFont(THEMIS.fontTextfield);
        this.fldExportFile.setText(NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.fldExportFile.text"));
        this.fldExportFile.setMinimumSize(new Dimension(100, 30));
        this.fldExportFile.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldExportFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkExportFileWithDate, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.chkExportFileWithDate.text"));
        this.chkExportFileWithDate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExportThemisFilePanel.this.chkExportFileWithDateMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.chkExportFileWithDate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelZiel.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelZiel, gridBagConstraints);
        this.panelDialogButtons.setLayout(new GridBagLayout());
        this.btnDialogCancel.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDialogCancel, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnDialogCancel.text"));
        this.btnDialogCancel.setMinimumSize(new Dimension(150, 30));
        this.btnDialogCancel.setPreferredSize(new Dimension(150, 30));
        this.btnDialogCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportThemisFilePanel.this.btnDialogCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDialogButtons.add((Component)this.btnDialogCancel, gridBagConstraints);
        this.btnDialogExport.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDialogExport, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnDialogExport.text"));
        this.btnDialogExport.setMinimumSize(new Dimension(150, 30));
        this.btnDialogExport.setPreferredSize(new Dimension(150, 30));
        this.btnDialogExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportThemisFilePanel.this.btnDialogExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDialogButtons.add((Component)this.btnDialogExport, gridBagConstraints);
        this.btnDialogExportShow.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDialogExportShow, (String)NbBundle.getMessage(ExportThemisFilePanel.class, (String)"ExportThemisFilePanel.btnDialogExportShow.text"));
        this.btnDialogExportShow.setMinimumSize(new Dimension(190, 30));
        this.btnDialogExportShow.setPreferredSize(new Dimension(190, 30));
        this.btnDialogExportShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportThemisFilePanel.this.btnDialogExportShowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDialogButtons.add((Component)this.btnDialogExportShow, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelDialogButtons, gridBagConstraints);
    }

    private void btnChooseFileActionPerformed(ActionEvent evt) {
        File thf = this.getFile();
        File f = new ThemisFileDialog(this.project.getResourceText("file.choose.title"), thf == null ? null : thf.getParentFile()).getSelectedFile();
        if (f != null) {
            this.fldFolder.setText(f.getAbsolutePath());
        }
        this.updateCount();
    }

    private void btnExportEventItemStateChanged(ItemEvent evt) {
        this.fldEvent.setEnabled(this.btnExportEvent.isSelected());
        this.updateCount();
    }

    private void btnTargetFileItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            ((CardLayout)this.panelTargetCards.getLayout()).show(this.panelTargetCards, "cardTargetFile");
            this.btnDialogExportShow.setEnabled(true);
            this.lblPassword.setVisible(false);
            this.fldPassword.setVisible(false);
        }
    }

    private void btnTargetCloudItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            ((CardLayout)this.panelTargetCards.getLayout()).show(this.panelTargetCards, "cardTargetCloud");
            this.btnDialogExportShow.setEnabled(true);
            this.lblPassword.setVisible(true);
            this.fldPassword.setVisible(true);
        }
    }

    private void btnTargetEmailItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            ((CardLayout)this.panelTargetCards.getLayout()).show(this.panelTargetCards, "cardTargetEmail");
            this.btnDialogExportShow.setEnabled(false);
            this.lblPassword.setVisible(false);
            this.fldPassword.setVisible(false);
        }
    }

    private void btnDialogExportActionPerformed(ActionEvent evt) {
        if (this.export()) {
            this.app.getSettings().setExportThemis(this.toXml());
            this.closeDialog();
        }
    }

    private void btnDialogCancelActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void btnExportSelectItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.updateCount();
        }
    }

    private void btnExportNodataItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.updateCount();
        }
    }

    private void fldEventItemStateChanged(ItemEvent evt) {
        this.updateCount();
    }

    private void btnExportFilterItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.updateCount();
        }
    }

    private void btnDialogExportShowActionPerformed(ActionEvent evt) {
        if (this.export()) {
            this.app.getSettings().setExportThemis(this.toXml());
            try {
                if (this.btnTargetFile.isSelected()) {
                    Desktop.getDesktop().open(this.getFile().getParentFile());
                } else if (this.btnTargetCloud.isSelected() && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URI(this.fldCloud.getText()));
                }
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.closeDialog();
        }
    }

    private void btnExportFilterActionPerformed(ActionEvent evt) {
    }

    private void btnExportNodataActionPerformed(ActionEvent evt) {
    }

    private void btnExportProjectItemStateChanged(ItemEvent evt) {
        this.chkAsTemplate.setEnabled(!this.btnExportProject.isSelected());
        this.btnFotoNone.setEnabled(!this.btnExportProject.isSelected());
        this.btnFotoRecent.setEnabled(!this.btnExportProject.isSelected());
        this.btnFotoAll.setEnabled(!this.btnExportProject.isSelected());
        this.btnPlanNone.setEnabled(!this.btnExportProject.isSelected());
        this.btnPlanRelevant.setEnabled(!this.btnExportProject.isSelected());
        this.btnPlanBuilding.setEnabled(!this.btnExportProject.isSelected());
        this.btnPlanAll.setEnabled(!this.btnExportProject.isSelected());
        this.btnTemplateNone.setEnabled(!this.btnExportProject.isSelected());
        this.btnTemplateRelevant.setEnabled(!this.btnExportProject.isSelected());
        this.btnTemplateAll.setEnabled(!this.btnExportProject.isSelected());
        this.btnDocumentsNone.setEnabled(!this.btnExportProject.isSelected());
        this.btnDocumentsRelevant.setEnabled(!this.btnExportProject.isSelected());
        this.btnDocumentsAll.setEnabled(!this.btnExportProject.isSelected());
        if (this.btnExportProject.isSelected()) {
            this.chkAsTemplate.setSelected(false);
            this.btnFotoAll.setSelected(true);
            this.btnPlanAll.setSelected(true);
            this.btnTemplateAll.setSelected(true);
            this.btnDocumentsAll.setSelected(true);
        }
        if (evt.getStateChange() == 1) {
            this.updateCount();
        }
    }

    private void btnTargetFileActionPerformed(ActionEvent evt) {
    }

    private void chkExportFileWithDateMouseClicked(MouseEvent evt) {
        this.fldExportFile.setText(this.createFilename());
    }

    @Override
    public String getDialogCode() {
        return "exportthemis";
    }

    @Override
    public Dimension getPanelSize() {
        return new Dimension(900, 690);
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(900, 690);
    }
}

