/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.project;

import at.grid.gui.Dialogs;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.application.util.WebDavFileList;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import at.grid.util.XML;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ImportThemisFilePanel
extends JPanel {
    private String DIALOG_CODE = "importthemisfile";
    public static final int DIALOG_WIDTH = 500;
    public static final int DIALOG_HEIGHT = 580;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    File importFolder = null;
    File importFile;
    ThemisFolder projectRoot = null;
    Element xml = null;
    boolean fileIsTemplate = false;
    private JButton btnCancel;
    private JButton btnChooseFile;
    private JButton btnCloud;
    private JButton btnImport;
    private JToggleButton btnTargetCloud;
    private JToggleButton btnTargetFile;
    private ButtonGroup buttonGroup1;
    private JCheckBox chkIgnoreEvent;
    private JTextField fldCloud;
    private JTextField fldCountLocation;
    private JTextField fldCountObservation;
    private JTextField fldCountPlan;
    private JTextField fldCountTemplate;
    private JTextField fldImportFile;
    private JPasswordField fldPassword;
    private JTextField fldWithEvent;
    private JLabel jLabel10;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel lblAuswahl;
    private JLabel lblAuswahl1;
    private JLabel lblCreateEvent;
    private JLabel lblPassword;
    private JPanel panelButtons;
    private JPanel panelCards;
    private JPanel panelContent;
    private JPanel panelFile;
    private JPanel panelSelect;
    private JPanel panelUrl;

    public ImportThemisFilePanel(File importFile) {
        this.initComponents();
        this.panelContent.setEnabled(false);
        this.lblCreateEvent.setVisible(false);
        new DropTarget(this.fldImportFile, new ThemisDropTargetListener(false, false, new String[]{"themis"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ImportThemisFilePanel.this.catchDroppedFile(f);
            }
        });
        this.fromXml(this.app.getSettings().getExportThemis());
        if (importFile != null) {
            this.setImportFile(importFile, true);
            this.btnTargetFile.setSelected(true);
        }
    }

    public boolean isFileTemplate() {
        return this.fileIsTemplate;
    }

    public void setProjectRoot(ThemisFolder f) {
        this.projectRoot = f;
    }

    public void fromXml(Element xml) {
        String url;
        String target;
        this.xml = xml;
        String s = Util.toXml((Element)xml);
        switch (target = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/target/mode", (String)"file")) {
            case "email": 
            case "file": {
                this.btnTargetFile.setSelected(true);
                break;
            }
            case "cloud": {
                this.btnTargetCloud.setSelected(true);
            }
        }
        String fn = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/target/file");
        if (fn != null) {
            File f = new File(fn);
            this.importFolder = f.getParentFile();
            this.fldImportFile.setText("");
        }
        this.fldCloud.setText((url = XML.getXPathElementText((Element)xml, (String)"/themis/project/export/themis/target/url")) == null ? "" : url);
    }

    public Element toXml() {
        this.xml = new Element("themis");
        Element target = this.xml.getChild("target");
        if (target == null) {
            target = new Element("target");
            this.xml.addContent((Content)target);
        }
        target.removeChild("mode");
        Element mode = new Element("mode");
        if (this.btnTargetFile.isSelected()) {
            mode.setText("file");
        } else if (this.btnTargetCloud.isSelected()) {
            mode.setText("cloud");
        }
        target.addContent((Content)mode);
        File f = new File(this.fldImportFile.getText());
        Element file = new Element("file");
        target.removeChild("file");
        file.setText(f.getAbsolutePath());
        target.addContent((Content)file);
        Element url = new Element("url");
        url.setText(this.fldCloud.getText());
        target.addContent((Content)url);
        String s = Util.toXml((Element)this.xml);
        return this.xml;
    }

    public File getImportFile() {
        return this.importFile;
    }

    protected void catchDroppedFile(File f) {
        File target = new File(this.project.getTempfileLocation(), f.getName());
        try {
            Util.copy((File)f, (File)target);
            this.setImportFile(target, true);
        }
        catch (IOException ex) {
            Dialogs.showErrorDialog((String)"error.file-drop-error", (Exception)ex);
        }
    }

    protected void setImportFile(File f, boolean updateDisplay) {
        if (f != null && f.isFile()) {
            if (updateDisplay) {
                this.fldImportFile.setText(f.getName());
            }
            this.importFile = f;
            this.app.getSettings().getFolderThemisIO().setValue(f.getParentFile());
            ThemisFile tf = new ThemisFile().analyseThemisFile(f);
            boolean withEvent = tf.hasEvent();
            this.fldCountObservation.setText(Integer.toString(tf.getCountObservation()));
            this.fldCountLocation.setText(Integer.toString(tf.getCountLocation()));
            this.fldCountTemplate.setText(Integer.toString(tf.getCountTemplate()));
            this.fldCountPlan.setText(Integer.toString(tf.getCountPlan()));
            this.fldWithEvent.setText(withEvent ? "Ja" : "-");
            this.chkIgnoreEvent.setVisible(withEvent);
            this.fileIsTemplate = tf.isProjectTemplate();
            this.panelContent.setEnabled(true);
            this.lblCreateEvent.setVisible(!withEvent);
        } else {
            this.fldImportFile.setText("");
            this.importFile = null;
        }
    }

    private boolean runImport() {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return false;
        }
        if (this.importFile == null) {
            this.app.getDialog().showErrorDialog("Keine Datei geladen");
            return false;
        }
        if (this.importFile.exists()) {
            ThemisApplication.getInstance().getSettings().getFolderThemisIO().setValue(this.importFile.getParentFile());
            boolean useFileUUID = !this.isFileTemplate();
            boolean applySettings = false;
            if (this.project == null || !this.project.isOpen()) {
                // empty if block
            }
            if (this.project.isOpen()) {
                String result = (String)BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

                    public String run(ProgressHandle ph) {
                        Notification notify = THEMIS.notify(1, "THEMIS Import", "Daten werden importiert");
                        ThemisProgressHandler tph = new ThemisProgressHandler(ph);
                        try {
                            ThemisFile tf = new ThemisFile().setContentType(ThemisFile.ContentType.CONTENT).setProgressHandler((ProgressHandler)tph);
                            String importresult = tf.loadFromFile(ImportThemisFilePanel.this.importFile, true).getError();
                            if (importresult != null) {
                                Dialogs.showErrorDialog((String)importresult);
                                return importresult;
                            }
                            ThemisActionProvider.getInstance().invokeAction(ThemisAction.FILTER_CHANGED.from((Object)this, "after import of *.themis"));
                            ThemisActionProvider.getInstance().invokeAction(ThemisAction.EVENT_SAVED.from((Object)this, "after import of *.themis"));
                            ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SAVED.from((Object)this, "after import of *.themis"));
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (JDOMException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        tph.done();
                        notify.clear();
                        return null;
                    }
                }, (String)"Datei wird importiert ...", (boolean)true);
                return true;
            }
        } else {
            this.app.getDialog().showErrorDialog("error.zip.file-not-found");
            return false;
        }
        return false;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.panelSelect = new JPanel();
        this.btnTargetFile = new JToggleButton();
        this.btnTargetCloud = new JToggleButton();
        this.panelCards = new JPanel();
        this.panelUrl = new JPanel();
        this.lblAuswahl1 = new JLabel();
        this.fldCloud = new JTextField();
        this.btnCloud = new JButton();
        this.lblPassword = new JLabel();
        this.fldPassword = new JPasswordField();
        this.panelFile = new JPanel();
        this.lblAuswahl = new JLabel();
        this.fldImportFile = new JTextField();
        this.btnChooseFile = new JButton();
        this.lblCreateEvent = new JLabel();
        this.panelContent = new JPanel();
        this.jLabel3 = new JLabel();
        this.fldWithEvent = new JTextField();
        this.jLabel7 = new JLabel();
        this.chkIgnoreEvent = new JCheckBox();
        this.fldCountLocation = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldCountObservation = new JTextField();
        this.jLabel4 = new JLabel();
        this.fldCountTemplate = new JTextField();
        this.jLabel9 = new JLabel();
        this.fldCountPlan = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel8 = new JLabel();
        this.panelButtons = new JPanel();
        this.btnImport = new JButton();
        this.btnCancel = new JButton();
        this.setLayout(new GridBagLayout());
        this.panelSelect.setPreferredSize(new Dimension(500, 30));
        this.panelSelect.setLayout(new GridLayout(1, 0, 10, 5));
        this.buttonGroup1.add(this.btnTargetFile);
        this.btnTargetFile.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTargetFile, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.btnTargetFile.text"));
        this.btnTargetFile.setMinimumSize(new Dimension(60, 30));
        this.btnTargetFile.setPreferredSize(new Dimension(60, 30));
        this.btnTargetFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImportThemisFilePanel.this.btnTargetFileItemStateChanged(evt);
            }
        });
        this.btnTargetFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportThemisFilePanel.this.btnTargetFileActionPerformed(evt);
            }
        });
        this.panelSelect.add(this.btnTargetFile);
        this.buttonGroup1.add(this.btnTargetCloud);
        this.btnTargetCloud.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTargetCloud, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.btnTargetCloud.text"));
        this.btnTargetCloud.setMinimumSize(new Dimension(60, 30));
        this.btnTargetCloud.setPreferredSize(new Dimension(60, 30));
        this.btnTargetCloud.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImportThemisFilePanel.this.btnTargetCloudItemStateChanged(evt);
            }
        });
        this.panelSelect.add(this.btnTargetCloud);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelSelect, gridBagConstraints);
        this.panelCards.setLayout(new CardLayout());
        this.panelUrl.setLayout(new GridBagLayout());
        this.lblAuswahl1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblAuswahl1, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.lblAuswahl1.text"));
        this.lblAuswahl1.setMinimumSize(new Dimension(80, 30));
        this.lblAuswahl1.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUrl.add((Component)this.lblAuswahl1, gridBagConstraints);
        this.fldCloud.setFont(THEMIS.fontTextfield);
        this.fldCloud.setText(NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.fldCloud.text"));
        this.fldCloud.setPreferredSize(new Dimension(6, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUrl.add((Component)this.fldCloud, gridBagConstraints);
        this.btnCloud.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCloud, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.btnCloud.text"));
        this.btnCloud.setBorder(new SoftBevelBorder(0));
        this.btnCloud.setPreferredSize(new Dimension(73, 30));
        this.btnCloud.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportThemisFilePanel.this.btnCloudActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUrl.add((Component)this.btnCloud, gridBagConstraints);
        this.lblPassword.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblPassword, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.lblPassword.text"));
        this.lblPassword.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUrl.add((Component)this.lblPassword, gridBagConstraints);
        this.fldPassword.setText(NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.fldPassword.text"));
        this.fldPassword.setMinimumSize(new Dimension(200, 30));
        this.fldPassword.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUrl.add((Component)this.fldPassword, gridBagConstraints);
        this.panelCards.add((Component)this.panelUrl, "cardCloud");
        this.panelFile.setLayout(new GridBagLayout());
        this.lblAuswahl.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblAuswahl, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.lblAuswahl.text"));
        this.lblAuswahl.setMinimumSize(new Dimension(80, 30));
        this.lblAuswahl.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.lblAuswahl, gridBagConstraints);
        this.fldImportFile.setFont(THEMIS.fontTextfield);
        this.fldImportFile.setText(NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.fldImportFile.text"));
        this.fldImportFile.setPreferredSize(new Dimension(6, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.fldImportFile, gridBagConstraints);
        this.btnChooseFile.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnChooseFile, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.btnChooseFile.text"));
        this.btnChooseFile.setBorder(new SoftBevelBorder(0));
        this.btnChooseFile.setPreferredSize(new Dimension(73, 30));
        this.btnChooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportThemisFilePanel.this.btnChooseFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.btnChooseFile, gridBagConstraints);
        this.panelCards.add((Component)this.panelFile, "cardFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelCards, gridBagConstraints);
        this.lblCreateEvent.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblCreateEvent, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.lblCreateEvent.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.lblCreateEvent, gridBagConstraints);
        this.panelContent.setLayout(new GridBagLayout());
        this.jLabel3.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.jLabel3, gridBagConstraints);
        this.fldWithEvent.setEditable(false);
        this.fldWithEvent.setFont(THEMIS.fontTextfield);
        this.fldWithEvent.setHorizontalAlignment(0);
        this.fldWithEvent.setText(NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.fldWithEvent.text"));
        this.fldWithEvent.setMinimumSize(new Dimension(80, 30));
        this.fldWithEvent.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.fldWithEvent, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.jLabel7, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkIgnoreEvent, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.chkIgnoreEvent.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.add((Component)this.chkIgnoreEvent, gridBagConstraints);
        this.fldCountLocation.setEditable(false);
        this.fldCountLocation.setFont(THEMIS.fontTextfield);
        this.fldCountLocation.setHorizontalAlignment(0);
        this.fldCountLocation.setText(NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.fldCountLocation.text"));
        this.fldCountLocation.setMinimumSize(new Dimension(80, 30));
        this.fldCountLocation.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.fldCountLocation, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.jLabel5, gridBagConstraints);
        this.fldCountObservation.setEditable(false);
        this.fldCountObservation.setFont(THEMIS.fontTextfield);
        this.fldCountObservation.setHorizontalAlignment(0);
        this.fldCountObservation.setText(NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.fldCountObservation.text"));
        this.fldCountObservation.setMinimumSize(new Dimension(80, 30));
        this.fldCountObservation.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.fldCountObservation, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.jLabel4, gridBagConstraints);
        this.fldCountTemplate.setEditable(false);
        this.fldCountTemplate.setFont(THEMIS.fontTextfield);
        this.fldCountTemplate.setHorizontalAlignment(0);
        this.fldCountTemplate.setText(NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.fldCountTemplate.text"));
        this.fldCountTemplate.setMinimumSize(new Dimension(80, 30));
        this.fldCountTemplate.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.fldCountTemplate, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.jLabel9, gridBagConstraints);
        this.fldCountPlan.setEditable(false);
        this.fldCountPlan.setFont(THEMIS.fontTextfield);
        this.fldCountPlan.setHorizontalAlignment(0);
        this.fldCountPlan.setText(NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.fldCountPlan.text"));
        this.fldCountPlan.setMinimumSize(new Dimension(80, 30));
        this.fldCountPlan.setPreferredSize(new Dimension(80, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.fldCountPlan, gridBagConstraints);
        this.jLabel10.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContent.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelContent, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnImport.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnImport, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.btnImport.text"));
        this.btnImport.setMinimumSize(new Dimension(130, 30));
        this.btnImport.setPreferredSize(new Dimension(130, 30));
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportThemisFilePanel.this.btnImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnImport, gridBagConstraints);
        this.btnCancel.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(ImportThemisFilePanel.class, (String)"ImportThemisFilePanel.btnCancel.text"));
        this.btnCancel.setMinimumSize(new Dimension(130, 30));
        this.btnCancel.setPreferredSize(new Dimension(130, 30));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportThemisFilePanel.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void btnChooseFileActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.project.getResourceText("file.choose.title"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getSettings().getFolderThemisIO().getValue(true), null, THEMIS.getThemisFileFilter(), null, false).getSelectedFile();
        if (f != null) {
            this.setImportFile(f, true);
        }
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        if (this.runImport()) {
            this.app.getSettings().setExportThemis(this.toXml());
            this.closeDialog(evt);
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeDialog(evt);
    }

    private void btnTargetFileItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            ((CardLayout)this.panelCards.getLayout()).show(this.panelCards, "cardFile");
            this.lblPassword.setVisible(false);
            this.fldPassword.setVisible(false);
        }
    }

    private void btnTargetCloudItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            ((CardLayout)this.panelCards.getLayout()).show(this.panelCards, "cardCloud");
            this.lblPassword.setVisible(true);
            this.fldPassword.setVisible(true);
        }
    }

    private void btnTargetFileActionPerformed(ActionEvent evt) {
        this.lblAuswahl.setText("Datei");
    }

    private void btnCloudActionPerformed(ActionEvent evt) {
        File f = null;
        if (this.fldCloud.getText().toLowerCase().startsWith("http")) {
            WebDavFileList panel;
            String pwd = String.valueOf(this.fldPassword.getPassword());
            if ("".equals(pwd)) {
                pwd = null;
            }
            if (!(panel = new WebDavFileList(this.fldCloud.getText(), pwd)).hasError()) {
                panel.showDialog();
                f = panel.getTargetfile();
            }
        } else {
            Dialogs.showErrorDialog((String)"Keine korrekte URL eingegeben");
        }
        if (f != null) {
            this.setImportFile(f, false);
        }
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(this.project.getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, true);
        THEMIS.setAssistantMoveListener(dlg);
        THEMIS.applyWindowSizeAndLocation(this.DIALOG_CODE, dlg, 500, 580);
        dlg.setVisible(true);
    }

    private void closeDialog(ActionEvent evt) {
        JComponent c = (JComponent)evt.getSource();
        Window w = SwingUtilities.getWindowAncestor(c);
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, w);
        w.dispose();
    }
}

