/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.project;

import at.grid.themis.application.CreateProjectPanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.application.project.CopyProjectPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ActionProvider;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.JavaFxUtilities;
import at.grid.themis.ontology.javafx.project.CreateProjectWizard;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FileUtils;
import org.jdom.JDOMException;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.awt.Notification;
import org.openide.util.Exceptions;

public class ProjectHelper {
    private static FileSystemView fsv = FileSystemView.getFileSystemView();
    private static boolean closeProject = true;
    private static boolean otherProjectOpened = false;

    public static List<ThemisFolder> checkProjectUUID(UUID projectUUID) {
        ArrayList<ThemisFolder> uuidProjects = new ArrayList<ThemisFolder>();
        if (projectUUID != null) {
            File rootFolder = ThemisApplication.getInstance().getSettings().getFolderProjectRoot().getValue(true);
            List<ThemisFolder> projects = THEMIS.findThemisProjects(rootFolder);
            for (ThemisFolder project : projects) {
                project.loadProperties();
                Properties props = project.getProperties();
                String uuidString = props.getProperty("project.uuid", null);
                if (uuidString == null || !UUID.fromString(uuidString).equals(projectUUID)) continue;
                uuidProjects.add(project);
            }
        }
        return uuidProjects;
    }

    public static void createProject(ThemisFolder folder, File rootFolder, CreateProjectPanel panel) {
        final ThemisApplication app = ThemisApplication.getInstance();
        if (!app.getLicense().hasLicense()) {
            app.getDialog().showWarningDialog(app.getProject().getResourceText("license.no-license", app.getLocale()));
            return;
        }
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)app)) {
            return;
        }
        if (app.isProjectOpen()) {
            otherProjectOpened = true;
            if (!ProjectHelper.closeProject(THEMIS.getCloseProjectFeedback(new Closing().withoutTrigger()))) {
                return;
            }
        }
        JavaFxUtilities.ensureInitialized();
        final JavaFxSwingDialog dlg = new JavaFxSwingDialog("create-project-wizard", 800, 380).setParentFrame(THEMIS.getMainWindow());
        CreateProjectWizard wizard = new CreateProjectWizard(folder == null ? null : folder.getProjectFolder()){

            protected void onCancel(ActionEvent e) {
                dlg.close();
            }

            protected void onSubmit(ActionEvent e) {
                ThemisFolder folder = this.getProjectFolder();
                if (folder != null) {
                    dlg.close();
                    app.getActionProvider().setActive(false);
                    SwingUtilities.invokeLater(() -> ThemisTaskWithDialog.createTaskWithCounter("task.create-project-file", ph -> {
                        String result = app.getProject().createProject(folder, ph);
                        if (result != null) {
                            app.getDialog().showErrorDialog(result);
                            ViewHelper.showStartScreen();
                            return;
                        }
                        result = this.applyConfiguration(ph);
                        if (result != null) {
                            app.getDialog().showWarningDialog(result);
                        }
                        app.getActionProvider().setActive(true);
                        SwingUtilities.invokeLater(() -> {
                            ViewHelper.showOpenProject();
                            app.getActionProvider().invokeAction(ThemisAction.PROJECT_OPENED);
                            ViewHelper.showPlan();
                            long id = this.getFirstPlanId();
                            if (id > 0L) {
                                app.getActionProvider().invokeAction(ThemisAction.PLAN_SAVED.setId(id));
                            }
                        });
                    }));
                }
            }
        };
        wizard.setFxPanel(dlg.getFxPanel());
        dlg.setContent((Node)wizard);
        dlg.show();
    }

    public static ArrayList<String> createAndUpdateProject(File projectFolder, Properties props, ProgressHandler ph) {
        if (props == null) {
            props = new Properties();
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean networkDrive = ThemisUtil.isOnNetworkDrive((File)projectFolder);
        ThemisProject project = ThemisApplication.getInstance().createProject(projectFolder, null, false, networkDrive, ph);
        if (!project.isOpen()) {
            return null;
        }
        String projectLogo = ThemisApplication.getInstance().getConfiguration("system.project.logo", null);
        if (props.getProperty("projectlogo") == null && projectLogo != null) {
            props.setProperty("projectlogo", projectLogo);
        }
        result.addAll(ProjectHelper.updateProject(project, props));
        ThemisUtil.setProjectIcon((File)projectFolder);
        return result;
    }

    public static ArrayList<String> updateProject(ThemisProject project, Properties props) {
        ArrayList<String> result = new ArrayList<String>();
        CmsProject projectEle = project.getProjectElement();
        projectEle.setAttributeValue("projecttitle", props.getProperty("projecttitle"));
        projectEle.setAttributeValue("projectnumber", props.getProperty("projectnumber"));
        projectEle.setAttributeValue("customer", props.getProperty("customer"));
        projectEle.setAttributeValue("info", props.getProperty("info"));
        projectEle.setAttributeValue("projectlocation", props.getProperty("projectlocation"));
        String projectLogo = props.getProperty("projectlogo");
        if (projectLogo != null && !projectLogo.isEmpty()) {
            File projectLogoFile = new File(projectLogo);
            if (projectLogoFile.exists()) {
                projectEle.getUploadAttribute("projectlogo").addUpload(projectLogoFile);
            } else {
                result.add("Die Datei f\u00fcr das Projektlogo existiert nicht '" + projectLogo + "'");
            }
        }
        String projectImage = props.getProperty("projectimage");
        if (projectImage != null && !projectImage.isEmpty()) {
            File projectImageFile = new File(projectImage);
            if (projectImageFile.exists()) {
                projectEle.getUploadAttribute("projectimage").addUpload(projectImageFile);
            } else {
                result.add("Die Datei f\u00fcr das Projektfoto existiert nicht '" + projectImage + "'");
            }
        }
        if (props.getProperty("uuid") != null) {
            projectEle.setUUID(props.getProperty("uuid"));
        }
        File templateFile = null;
        String fn = props.getProperty("projecttemplate");
        if (fn != null && !"".equals(fn)) {
            templateFile = new File(fn);
            if (!templateFile.isFile()) {
                result.add("Projektvorlage '" + templateFile.getAbsolutePath() + "' existiert nicht");
            } else if (templateFile.getName().toLowerCase().endsWith(".themis")) {
                try {
                    ThemisFile tf = new ThemisFile().setContentType(ThemisFile.ContentType.TEMPLATE);
                    String importresult = tf.loadFromFile(templateFile, true).getError();
                    if (importresult != null) {
                        result.add(importresult);
                    }
                }
                catch (IOException iOException) {
                }
                catch (JDOMException jDOMException) {}
            } else {
                ThemisApplication.getInstance().getSettings().setTemplateUseTexts(true);
                ThemisApplication.getInstance().getSettings().setTemplateUseLists(true);
                ThemisApplication.getInstance().getSettings().setTemplateUseIcons(true);
                ThemisApplication.getInstance().getSettings().setTemplateUseSettings(true);
                ThemisApplication.getInstance().getSettings().setTemplateUseContacts(true);
                ThemisApplication.getInstance().getSettings().setTemplateUseDocuments(true);
                if (!project.getTemplateManger().loadTemplate(templateFile)) {
                    result.add("Fehler beim Laden der Projektvorlage '" + templateFile.getAbsolutePath() + "'");
                }
            }
        }
        projectEle.save();
        return result;
    }

    public static void openProject(ThemisFolder themis) {
        ProjectHelper.openProject(themis, true, null);
    }

    public static void openProject(final ThemisFolder themis, boolean force, final File themisFile) {
        if (themis.isThemisFile()) {
            return;
        }
        final ThemisApplication app = ThemisApplication.getInstance();
        final boolean isNetworkDrive = ThemisUtil.isOnNetworkDrive((ThemisFolder)themis);
        boolean isSimpleEditor = "yes".equals(ThemisApplication.getInstance().getConfiguration("interface.simple-editor", "no"));
        isSimpleEditor = false;
        if (isSimpleEditor) {
            ThemisActionProvider.getInstance().setTarget(ActionProvider.Target.EDITOR);
        } else {
            ThemisActionProvider.getInstance().setTarget(ActionProvider.Target.GUI);
        }
        if (themis == null) {
            return;
        }
        if (!themis.isProject()) {
            return;
        }
        if (app.isProjectOpen()) {
            otherProjectOpened = true;
            if (!ProjectHelper.closeProject(new Closing().withoutTrigger())) {
                return;
            }
        }
        if (closeProject && themis != null && themis.isProject()) {
            app.getSettings().getFolderOpenProject().setValue(themis.getProjectFolder().getParentFile());
            final ThemisProgressHandler p = new ThemisProgressHandler(app.getProject().getResourceText("app.core.text.openproject", app.getLocale()), 11);
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    Notification notify = THEMIS.notify(1, app.getProject().getResourceText("app.core.text.loadproject", app.getLocale()), MessageFormat.format(app.getProject().getResourceText("ExplorerTopComponent.openProjectBubble.text"), themis.getProjectFolder().getName()));
                    p.switchToDeterminate(11);
                    app.getProject().getLogger().fine("saving project icon ...");
                    ThemisUtil.setProjectIcon((File)themis.getProjectFolder());
                    app.loadProject(themis, false, true, isNetworkDrive, (ProgressHandler)p, themisFile);
                    File rootFolder = app.getSettings().getFolderProjectRoot().getValue(true);
                    if (rootFolder == null) {
                        app.getSettings().getFolderProjectRoot().setValue(themis.getProjectFolder().getParentFile());
                        ThemisActionProvider.getInstance().invokeAction(ThemisAction.ROOT_FOLDER_CHANGED);
                    }
                    SwingUtilities.invokeLater(() -> ViewHelper.showEventList());
                    ThemisActionProvider.getInstance().invokeAction(ThemisAction.PROJECT_OPENED);
                    notify.clear();
                    p.done();
                }
            };
            BaseProgressUtils.showProgressDialogAndRun((Runnable)runner, (ProgressHandle)p.getProgressHandle(), (boolean)true);
        }
    }

    public static boolean closeProject(Closing c) {
        return ProjectHelper.closeProject(c, null);
    }

    public static boolean closeProject(Closing c, ProgressHandler ph) {
        if (ThemisApplication.getInstance().getProject().isThemisFileDirectAccess() && c.withSave) {
            File f;
            File f0 = ThemisApplication.getInstance().getProject().getThemisFileDirectAccess();
            String fn = Util.getFileNameWithoutExtension((File)f0);
            CmsEvent ev = ThemisApplication.getInstance().getProject().getSelectionManager().getCurrentEvent();
            if (ev == null) {
                fn = fn + "_" + Util.formatDate((Date)new Date(), (String)Util.DATE_ISO, (TimeZone)ThemisApplication.getInstance().getTimeZone()) + ".themis";
            }
            if ((f = new ThemisFileDialog("*.themis Datei speichern", ThemisFileDialog.DIALOGTYPE.SAVE, ThemisApplication.getInstance().getProject().getThemisFileDirectAccess().getParentFile(), new File(f0.getParentFile(), fn), THEMIS.getThemisFileFilter(), "themis", false).getSelectedFile()) == null) {
                return false;
            }
            ThemisApplication.getInstance().getProject().setThemisFileDirectAccess(f);
        }
        return ThemisApplication.getInstance().getProject().close(c, ph);
    }

    public static void copyProject(ThemisFolder themis) {
        ProjectHelper.copyOrRenmaeProject(themis, false);
    }

    public static void renameProject(ThemisFolder themis) {
        ProjectHelper.copyOrRenmaeProject(themis, true);
    }

    private static void copyOrRenmaeProject(final ThemisFolder themis, boolean rename) {
        ThemisApplication app = ThemisApplication.getInstance();
        if (!themis.isProject()) {
            app.getDialog().showInfoDialog("project.no-project-selected");
            return;
        }
        boolean oldProjectWasOpen = false;
        File currentProjectFile = app.getProject().getProjectFolder();
        if (app.getProject().isOpen() && app.getProject().getProjectFolder().equals(themis.getProjectFolder())) {
            if (!app.getDialog().showConfirmDialog("project.project-open-close")) {
                return;
            }
            oldProjectWasOpen = true;
            if (!ProjectHelper.closeProject(THEMIS.getCloseProjectFeedback(new Closing().withoutExport().withoutTrigger()))) {
                return;
            }
        }
        String dlgTitle = rename ? app.getProject().getResourceText("project.rename") : app.getProject().getResourceText("project.copy");
        CopyProjectPanel panel = new CopyProjectPanel(themis.getProjectFolder().getParentFile(), themis.getProjectFolder().getName(), rename);
        if (Dialogs.getInstance().showDialog(panel, dlgTitle, new String[]{app.getProject().getResourceText("core.text.cancel"), app.getProject().getResourceText("core.text.ok")}) == 1) {
            final File newProjectFile = new File(panel.getFolder(), panel.getNewName());
            if (newProjectFile.exists()) {
                app.getDialog().showErrorDialog("error.project-already-exists");
                return;
            }
            if (rename) {
                File origFile = themis.getProjectFolder();
                boolean ok = themis.getProjectFolder().renameTo(newProjectFile);
                app.updateRecentProjectList(origFile, newProjectFile);
                return;
            }
            BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        FileUtils.copyDirectory((File)themis.getProjectFolder(), (File)newProjectFile);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }, (String)app.getProject().getResourceText("progress.saving-project"));
            ThemisUtil.setProjectIcon((File)newProjectFile);
            Util.delete((File)new File(newProjectFile, "db/themis.lock.db"));
            Util.delete((File)new File(newProjectFile, "db/themis.lock"));
            File db = new File(newProjectFile, "db/themis.h2.db");
            File dbOrig = new File(newProjectFile, "db/themis.h2.db_orig");
            if (!db.isFile()) {
                if (dbOrig.isFile()) {
                    dbOrig.renameTo(db);
                } else {
                    ArrayList files = themis.getDatabaseBackupFileList();
                    if (files != null && !files.isEmpty()) {
                        File dbBak = (File)files.get(files.size() - 1);
                        try {
                            Util.copy((File)dbBak, (File)db);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            } else if (dbOrig.isFile()) {
                dbOrig.delete();
            }
            app.getProject().open(newProjectFile, null, null, false, false, false, false, false, null);
            app.getProject().getProjectElement().createNewUUID();
            ProjectHelper.closeProject(new Closing().withoutExport().withoutTrigger().withoutAsking());
            if (oldProjectWasOpen) {
                ProjectHelper.openProject(themis);
            }
        }
    }

    public static void moveProjects(final ArrayList<ThemisFolder> projects) {
        if (projects == null || projects.isEmpty()) {
            return;
        }
        final ArrayList<String> errors = new ArrayList<String>();
        final File f = new ThemisFileDialog(ThemisApplication.getInstance().getProject().getResourceText("dialog.select-folder.title"), ThemisFileDialog.DIALOGTYPE.DIRECTORY, projects.get(0).getProjectFolder().getParentFile(), null, null, null, false).getSelectedFile();
        if (f != null) {
            BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    ThemisApplication app = ThemisApplication.getInstance();
                    for (ThemisFolder project : projects) {
                        File targetFile = new File(f, project.getFolderName());
                        if (targetFile.exists()) {
                            errors.add(project.getFolderName() + " - Ein gleichnamiges Verzeichnis existiert bereits");
                            continue;
                        }
                        if (project.getProjectLock().isLocked()) {
                            errors.add(project.getFolderName() + " - Projekt ist in Verwendung");
                            continue;
                        }
                        try {
                            Util.copy((File)project.getProjectFolder(), (File)targetFile);
                        }
                        catch (IOException ex) {
                            app.getProject().getLogger().severe("error-moving-project (" + ex.getMessage() + ")");
                            errors.add(project.getFolderName() + "(" + ex.getMessage() + ")");
                            continue;
                        }
                        if (!targetFile.isDirectory()) {
                            errors.add(project.getFolderName() + " - Fehler beim Verschieben");
                            continue;
                        }
                        Util.delete((File)project.getProjectFolder());
                        app.updateRecentProjectList(project.getProjectFolder(), targetFile);
                    }
                }
            }, (String)"Projekte werden verschoben");
            if (!errors.isEmpty()) {
                ProjectHelper.displayErrors("Folgende Projekte k\u00f6nnen nicht verschoben werden:", errors);
            }
        }
    }

    public static ArrayList<String> deleteProjects(ArrayList<ThemisFolder> projects) {
        ArrayList<String> result = new ArrayList<String>();
        if (projects == null || projects.isEmpty()) {
            return result;
        }
        ArrayList<String> errors = new ArrayList<String>();
        String msg = projects.size() == 1 ? "Geben Sie 'l\u00f6schen' ein, um das Projekt endg\u00fcltig zu l\u00f6schen. ACHTUNG: Das Projekt kann nicht wiederhergestellt werden!" : "Geben Sie 'l\u00f6schen' ein, um die Projekte endg\u00fcltig zu l\u00f6schen. ACHTUNG: Die Projekte k\u00f6nnen nicht wiederhergestellt werden!";
        String r = ThemisApplication.getInstance().getDialog().showInputDialog(msg, "Projekt l\u00f6schen");
        if ("l\u00f6schen".equalsIgnoreCase(r)) {
            for (ThemisFolder project : projects) {
                if (project.getProjectLock().isLocked()) {
                    errors.add(project.getFolderName() + " (in Verwendung)");
                    continue;
                }
                boolean success = Util.delete((File)project.getProjectFolder());
                if (!success) {
                    errors.add(project.getFolderName());
                    continue;
                }
                result.add(project.getUUID());
            }
        }
        if (!errors.isEmpty()) {
            ProjectHelper.displayErrors("Folgende Projekte k\u00f6nnen nicht gel\u00f6scht werden:", errors);
        }
        return result;
    }

    public static void displayErrors(String msg, ArrayList<String> errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(msg).append("<br/>");
        for (String error : errors) {
            sb.append("<li>").append(error).append("</li>");
        }
        ThemisApplication.getInstance().getDialog().showErrorDialog(sb.toString());
    }
}

