/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.project;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.project.ProjectHelper;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ProjectListPanel
extends JPanel {
    ArrayList<ThemisFolder> projects = new ArrayList();
    JPanel panel;
    DragScrollHandler dragHandler;
    ArrayList<ThemisFolder> selection = new ArrayList();
    Dimension dimImage = new Dimension(100, 50);
    ImageIcon defaultProjectImage;
    ImageIcon openProjectIcon;
    ImageIcon editProjectIcon;
    private JPanel headerPanel;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;

    public ProjectListPanel() {
        this(null, null);
    }

    public ProjectListPanel(JPanel p, DragScrollHandler dragHandler) {
        this.defaultProjectImage = new ImageIcon(Util.resizeImage((URL)this.getClass().getResource("/at/grid/themis/application/media/projectImage.gif"), (int)this.dimImage.width, (int)this.dimImage.height, (int)2));
        this.openProjectIcon = new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_openProject24.gif"));
        this.editProjectIcon = new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif"));
        this.initComponents();
        this.panel = p == null ? this.mainPanel : p;
        this.dragHandler = dragHandler;
    }

    public void addProject(ThemisFolder tf) {
        this.projects.add(tf);
    }

    public void clear() {
        this.projects.clear();
        this.selection.clear();
        this.populateList();
    }

    public ArrayList<ThemisFolder> getSelection() {
        return this.selection;
    }

    public void selectAll() {
        this.selection.clear();
        this.selection.addAll(this.projects);
        this.populateList();
    }

    public void clearSelection() {
        this.selection.clear();
        this.populateList();
    }

    public int populateList() {
        this.panel.removeAll();
        int counter = 0;
        this.panel.setLayout(new GridBagLayout());
        this.addProjectToList(this.headerPanel, 0, null);
        for (int ii = 0; ii < this.projects.size(); ++ii) {
            this.addProjectToList(this.panel, ii, this.projects.get(ii));
            ++counter;
        }
        GridBagConstraints gbc = this.createGridBagConstraints(this.projects.size(), 0, 1, 1, 1, 10, 0.0);
        gbc.weighty = 1.0;
        this.panel.add((Component)new JLabel(), gbc);
        this.panel.revalidate();
        this.panel.repaint();
        return counter;
    }

    private Component addMouseListenerForSelection(Component c, final JCheckBox chk, final ThemisFolder tf) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ViewHelper.showOpenProject();
                    ProjectHelper.openProject(tf);
                } else if (e.isControlDown() || e.isShiftDown()) {
                    chk.setSelected(!chk.isSelected());
                } else {
                    ProjectListPanel.this.selection.clear();
                    chk.setSelected(true);
                    ProjectListPanel.this.populateList();
                }
            }
        });
        return c;
    }

    private void addProjectToList(JPanel p, int row, final ThemisFolder tf) {
        Properties props = null;
        if (tf != null) {
            props = tf.loadProperties();
        }
        Font fontTitle = THEMIS.fontLabelBigBold;
        Font fontText = THEMIS.fontLabel;
        Font fontInfo = THEMIS.fontLabelSmall;
        int col = 0;
        GridBagConstraints gbc = this.createGridBagConstraints(row, col++, 0.0);
        if (tf != null) {
            JCheckBox chk = new JCheckBox();
            chk.setOpaque(false);
            THEMIS.setCheckboxIcon(chk);
            chk.setSelected(tf != null && this.selection.contains(tf));
            chk.addItemListener(e -> {
                boolean state = chk.isSelected();
                if (!state) {
                    this.selection.remove(tf);
                } else if (!this.selection.contains(tf)) {
                    this.selection.add(tf);
                }
            });
            p.add((Component)chk, gbc);
        }
        gbc = this.createGridBagConstraints(row, col++, 0.0);
        String content = tf == null ? "Projekttitel" : tf.getProjectTitle();
        JTextField titleTextField = this.createTextField(content, 350, 30, fontTitle);
        titleTextField.setCursor(Cursor.getPredefinedCursor(12));
        p.add((Component)titleTextField, gbc);
        if (tf != null) {
            titleTextField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ViewHelper.showOpenProject();
                    ProjectHelper.openProject(tf, true, null);
                }
            });
        }
        gbc = this.createGridBagConstraints(row, col++, 0.0);
        content = tf == null ? "Dateiname" : tf.getFolderName();
        p.add((Component)this.createTextField(content, 250, 30, fontText), gbc);
        gbc = this.createGridBagConstraints(row, col++, 0.0);
        content = tf == null ? "Letzter Zugriff" : (props == null ? "" : props.getProperty("access.last", "-").split(" ")[0] + " (" + props.getProperty("access.last-user", "-") + ")");
        p.add((Component)this.createTextField(content, 120, 30, fontText), gbc);
        gbc = this.createGridBagConstraints(row, col++, 0.0);
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 10);
        content = tf == null ? "Letzer Anwender" : (props == null ? "" : props.getProperty("last.event", "-"));
        p.add((Component)this.createTextField(content, 200, 30, fontText), gbc);
    }

    private void addProjectToList2(int row, final ThemisFolder tf) {
        File dataFolder;
        File imgFile;
        Properties props = tf.loadProperties();
        File projectFolder = tf.getProjectFolder();
        Font fontTitle = THEMIS.fontLabelBigBold;
        Font fontText = THEMIS.fontLabel;
        Font fontInfo = THEMIS.fontLabelSmall;
        GridBagConstraints gbc = this.createGridBagConstraints(row, 0, 0, 1, 3, 10, 0.0);
        gbc.insets.top = 20;
        JCheckBox chk = new JCheckBox();
        chk.setOpaque(false);
        THEMIS.setCheckboxIcon(chk);
        chk.setSelected(this.selection.contains(tf));
        chk.addItemListener(e -> {
            boolean state = chk.isSelected();
            if (!state) {
                this.selection.remove(tf);
            } else if (!this.selection.contains(tf)) {
                this.selection.add(tf);
            }
        });
        this.panel.add((Component)chk, gbc);
        gbc = this.createGridBagConstraints(row, 1, 0, 1, 3, 10, 0.0);
        gbc.insets.top = 20;
        JLabel lblFoto = new JLabel();
        String projectImage = tf.getProjectImageName();
        ImageIcon icon = null;
        if (projectImage != null && !projectImage.isEmpty() && (imgFile = new File(dataFolder = new File(projectFolder, "data/project"), projectImage)).exists()) {
            BufferedImage img = null;
            try {
                img = ImageHelper.loadImage((File)imgFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (img != null) {
                icon = new ImageIcon(Util.resizeImage((BufferedImage)img, (int)this.dimImage.width, (int)this.dimImage.height, (int)2));
            }
        }
        if (icon == null) {
            icon = this.defaultProjectImage;
        }
        lblFoto.setIcon(icon);
        this.panel.add(this.addMouseListenerForSelection(lblFoto, chk, tf), gbc);
        gbc = this.createGridBagConstraints(row, 3, 0, 2, 1, 0, 1.0);
        gbc.insets = new Insets(10, 0, 0, 10);
        String content = tf.getProjectTitle();
        JTextField titleTextField = this.createTextField(content, 380, 30, fontTitle);
        titleTextField.setCursor(Cursor.getPredefinedCursor(12));
        this.panel.add((Component)titleTextField, gbc);
        titleTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ViewHelper.showOpenProject();
                ProjectHelper.openProject(tf, true, null);
            }
        });
        gbc = this.createGridBagConstraints(row, 3, 1, 2, 1, 0, 1.0);
        gbc.insets = new Insets(0, 0, 0, 10);
        content = tf.getProjectFolder().getAbsolutePath();
        this.panel.add((Component)this.createTextField(content, 380, 20, fontInfo), gbc);
        gbc = this.createGridBagConstraints(row, 3, 2, 1, 1, 0, 0.0);
        content = props == null ? "-" : props.getProperty("access.last", "-").split(" ")[0] + " (" + props.getProperty("access.last-user", "-") + ")";
        this.panel.add((Component)this.createTextField("erstellt: " + content, 190, 20, fontText), gbc);
        gbc = this.createGridBagConstraints(row, 4, 2, 1, 1, 0, 0.0);
        gbc.insets = new Insets(0, 0, 0, 10);
        content = props == null ? "-" : props.getProperty("last.event", "-");
        this.panel.add((Component)this.createTextField("Ereignis: " + content, 190, 20, fontText), gbc);
    }

    private JTextField createTextField(String t, int w, int h, Font f) {
        JTextField txt = new JTextField(t);
        txt.setFont(f);
        txt.setEditable(false);
        txt.setPreferredSize(new Dimension(w, h));
        txt.setMinimumSize(new Dimension(w, h));
        txt.setForeground(Color.BLACK);
        txt.setBackground(Color.WHITE);
        txt.setBorder(null);
        this.dragHandler.addDragComponent(txt);
        return txt;
    }

    private GridBagConstraints createGridBagConstraints(int row, int x, int y, double weightx) {
        return this.createGridBagConstraints(row, x, y, 1, 1, 0, weightx);
    }

    private GridBagConstraints createGridBagConstraints(int row, int col, double weightx) {
        return this.createGridBagConstraints(row, col, 0, 1, 1, 0, weightx);
    }

    private GridBagConstraints createGridBagConstraints(int row, int x, int y, int w, int h, int inset, double weightx) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(inset, inset, inset, inset);
        gbc.ipadx = 5;
        gbc.anchor = 18;
        gbc.weightx = weightx;
        gbc.weighty = 0.0;
        gbc.gridheight = h;
        gbc.gridwidth = w;
        gbc.fill = 2;
        gbc.gridx = x;
        gbc.gridy = row * 3 + y;
        return gbc;
    }

    private void initComponents() {
        this.headerPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.headerPanel.setLayout(new GridBagLayout());
        this.add((Component)this.headerPanel, "North");
        this.mainPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.mainPanel);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

