/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.project;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ProjectListTableModel
extends AbstractTableModel {
    private final JTable tbl;
    private final ArrayList<ThemisFolder> folders = new ArrayList();
    private final ArrayList<ThemisFolder> selected = new ArrayList();
    private final ArrayList<ThemisFolder.Column> columns = new ArrayList();
    private int currentSort = -1;
    private boolean ascending = true;

    public ProjectListTableModel(JTable t) {
        this.tbl = t;
    }

    public void clear() {
        this.folders.clear();
        this.selected.clear();
    }

    public void clearColumns() {
        this.columns.clear();
    }

    public void addColumn(ThemisFolder.Column c) {
        this.columns.add(c);
        TableColumnModel columnModel = this.tbl.getColumnModel();
        TableColumn tblcol = new TableColumn(this.columns.size());
        tblcol.setIdentifier(c);
        columnModel.addColumn(tblcol);
    }

    public void setTableColumnWidth() {
        if (this.columns.isEmpty()) {
            return;
        }
        this.tbl.setAutoResizeMode(3);
        TableColumnModel columnModel = this.tbl.getColumnModel();
        for (int ii = 0; ii < this.columns.size(); ++ii) {
            int w = this.columns.get(ii).getWidth();
            columnModel.getColumn(ii).setWidth(w);
            columnModel.getColumn(ii).setPreferredWidth(w);
        }
    }

    public void addThemisFolder(ThemisFolder tf) {
        this.folders.add(tf);
        tf.loadProperties();
    }

    public void addThemisFile(File f) {
        this.folders.add(new ThemisFolder(f));
    }

    public void setSort(int idx) {
        if (idx >= 0 && idx < this.getColumnCount()) {
            if (idx == this.currentSort) {
                this.ascending = !this.ascending;
            }
            ThemisFolder.Column sortCriteria = this.columns.get(idx);
            Collections.sort(this.folders, (a, b) -> {
                if (sortCriteria == null) {
                    return a.getProjectFolder().compareTo(b.getProjectFolder()) * (this.ascending ? 1 : -1);
                }
                switch (sortCriteria) {
                    case TITLE: {
                        return a.getProjectTitle().compareTo(b.getProjectTitle()) * (this.ascending ? 1 : -1);
                    }
                    case LASTACCESS: {
                        String dt1s = a.loadProperties().getProperty("access.last", "").split(" ")[0];
                        String dt2s = b.loadProperties().getProperty("access.last", "").split(" ")[0];
                        Date dt1 = Util.parseDate((String)dt1s, (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null);
                        Date dt2 = Util.parseDate((String)dt2s, (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null);
                        if (dt1 == null) {
                            return (dt2 == null ? 0 : -1) * (this.ascending ? 1 : -1);
                        }
                        if (dt2 == null) {
                            return 1 * (this.ascending ? 1 : -1);
                        }
                        return dt1.compareTo(dt2) * (this.ascending ? 1 : -1);
                    }
                    case LASTUSER: {
                        return a.loadProperties().getProperty("access.last-user", "").compareTo(b.loadProperties().getProperty("access.last-user", "")) * (this.ascending ? 1 : -1);
                    }
                    case DEFECTS: {
                        String o1 = a.loadProperties().getProperty("count.opentasks");
                        Integer open1 = Util.parseInt((String)o1, (int)0);
                        String o2 = b.loadProperties().getProperty("count.opentasks");
                        Integer open2 = Util.parseInt((String)o2, (int)0);
                        return open1.compareTo(open2) * (this.ascending ? 1 : -1);
                    }
                    case NEXTDATE: {
                        String d1s = a.loadProperties().getProperty("next.duedate", "").split(" ")[0];
                        String d2s = b.loadProperties().getProperty("next.duedate", "").split(" ")[0];
                        Date d1 = Util.parseDate((String)d1s, (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null);
                        Date d2 = Util.parseDate((String)d2s, (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null);
                        if (d1 == null) {
                            return (d2 == null ? 0 : -1) * (this.ascending ? 1 : -1);
                        }
                        if (d2 == null) {
                            return 1 * (this.ascending ? 1 : -1);
                        }
                        return d1.compareTo(d2) * (this.ascending ? 1 : -1);
                    }
                }
                return a.getProjectFolder().compareTo(b.getProjectFolder()) * (this.ascending ? 1 : -1);
            });
            this.currentSort = idx;
        }
    }

    public ThemisFolder getThemisFolder(int idx) {
        if (idx >= 0 && idx < this.folders.size()) {
            return this.folders.get(idx);
        }
        return null;
    }

    public void updateSelection(ThemisFolder folder, boolean multiple) {
        if (multiple) {
            if (this.selected.contains(folder)) {
                this.selected.remove(folder);
            } else {
                this.selected.add(folder);
            }
        } else if (this.selected.size() > 1) {
            this.selected.clear();
            this.selected.add(folder);
        } else if (this.selected.contains(folder)) {
            this.selected.remove(folder);
        } else {
            this.selected.clear();
            this.selected.add(folder);
        }
        this.tbl.getSelectionModel().clearSelection();
        for (ThemisFolder f : this.selected) {
            int index = this.folders.indexOf(f);
            this.tbl.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    public void clearSelection() {
        this.selected.clear();
        this.tbl.getSelectionModel().clearSelection();
    }

    public void selectAll() {
        this.selected.clear();
        this.selected.addAll(this.folders);
        this.tbl.getSelectionModel().clearSelection();
        this.tbl.getSelectionModel().addSelectionInterval(0, this.selected.size());
    }

    public ArrayList<ThemisFolder> getSelection() {
        return this.selected;
    }

    public int getCurrentSort() {
        return this.currentSort;
    }

    public boolean isAscendingSort() {
        return this.ascending;
    }

    @Override
    public int getRowCount() {
        return this.folders.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex >= this.columns.size() || rowIndex >= this.folders.size()) {
            return "";
        }
        ThemisFolder tf = this.folders.get(rowIndex);
        Properties prop = tf.getProperties();
        ThemisFolder.Column col = this.columns.get(columnIndex);
        switch (col) {
            case SELECT: {
                return this.selected.contains(tf);
            }
            case TITLE: {
                return tf.isProject() ? tf.getProjectTitle() : (tf.isThemisFile() ? "*.themis Datei" : "");
            }
            case FILENAME: {
                return tf.getFolderName();
            }
            case DEFECTS: {
                return prop == null ? null : prop.getProperty("count.opentasks");
            }
            case NEXTDATE: {
                if (prop.getProperty("next.duedate") == null) {
                    return "?";
                }
                return prop == null ? null : Util.parseDate((String)prop.getProperty("next.duedate", "").split(" ")[0], (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null);
            }
            case LASTACCESS: {
                return prop == null ? null : Util.parseDate((String)prop.getProperty("access.last", "").split(" ")[0], (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null);
            }
            case LASTUSER: {
                return prop == null ? "" : prop.getProperty("access.last-user", "");
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= this.columns.size()) {
            return String.class;
        }
        switch (this.columns.get(columnIndex)) {
            case SELECT: {
                return Boolean.class;
            }
            case LASTACCESS: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.columns.get(col).getTitle();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

