/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.project;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.project.ProjectListDetailHandler;
import at.grid.themis.application.project.ProjectListTableModel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColors;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisLock;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class ProjectListTablePanel
extends JPanel {
    private final ProjectListDetailHandler detailHandler;
    private ProjectListTableModel tablemodel;
    private JScrollPane jScrollPane1;
    private JTable table;

    public ProjectListTablePanel(ProjectListDetailHandler handler) {
        MouseListener[] listeners;
        this.detailHandler = handler;
        this.initComponents();
        Font f = THEMIS.fontLabelBig;
        LocalCellRenderer renderer = new LocalCellRenderer();
        this.table.setShowGrid(false);
        this.table.setFont(f);
        this.table.setRowHeight(f.getSize() * 2);
        this.table.setAutoCreateRowSorter(true);
        this.table.setRowSelectionAllowed(false);
        this.table.getTableHeader().setOpaque(false);
        this.table.getTableHeader().setBackground(Color.darkGray);
        this.table.getTableHeader().setForeground(Color.white);
        this.table.setDefaultRenderer(Object.class, renderer);
        this.table.setDefaultRenderer(String.class, renderer);
        this.table.setDefaultRenderer(Date.class, renderer);
        JTableHeader header = this.table.getTableHeader();
        for (MouseListener ml : listeners = header.getMouseListeners()) {
            header.removeMouseListener(ml);
        }
        header.addMouseListener(new LocalTableColumnHeaderListener());
        header.setDefaultRenderer(new LocalHeaderRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
                JTable table = (JTable)me.getSource();
                Point p = me.getPoint();
                int row = table.rowAtPoint(p);
                int col = table.columnAtPoint(p);
                ThemisFolder tf = ProjectListTablePanel.this.tablemodel.getThemisFolder(row);
                if (tf != null) {
                    if (col != 0 && me.getClickCount() == 2) {
                        boolean projectLocked = tf.getProjectLock().isLocked();
                        boolean lockOnSameComputer = tf.getProjectLock().isUsedOnSameComputerAndUser();
                        if (projectLocked && !lockOnSameComputer) {
                            String lockComputer;
                            ThemisLock projectLock = tf.getProjectLock();
                            String lockUsername = projectLock.getUserName();
                            if (lockUsername == null) {
                                lockUsername = "keine Angabe";
                            }
                            if ((lockComputer = projectLock.getUserComputer()) == null) {
                                lockComputer = "keine Angabe";
                            }
                            ThemisApplication.getInstance().getDialog().showOpenLockedProjectDialog(lockUsername, projectLock.getLockTimeAsString(), lockComputer);
                            return;
                        }
                        if (ProjectListTablePanel.this.detailHandler != null) {
                            ProjectListTablePanel.this.detailHandler.openProject(tf);
                        }
                    } else {
                        ProjectListTablePanel.this.tablemodel.updateSelection(tf, col == 0);
                        if (ProjectListTablePanel.this.detailHandler != null) {
                            ArrayList<ThemisFolder> selected = ProjectListTablePanel.this.getSelection();
                            ProjectListTablePanel.this.detailHandler.showProjectDetails((ThemisFolder)(selected.contains(tf) ? tf : (selected.isEmpty() ? null : selected.get(0))));
                            ProjectListTablePanel.this.detailHandler.updateProjectSelection(selected);
                        }
                    }
                }
            }
        });
        this.tablemodel = new ProjectListTableModel(this.table);
        this.tablemodel.addColumn(ThemisFolder.Column.SELECT);
        this.tablemodel.addColumn(ThemisFolder.Column.TITLE);
        this.tablemodel.addColumn(ThemisFolder.Column.FILENAME);
        this.tablemodel.addColumn(ThemisFolder.Column.DEFECTS);
        this.tablemodel.addColumn(ThemisFolder.Column.NEXTDATE);
        this.tablemodel.addColumn(ThemisFolder.Column.LASTACCESS);
        this.tablemodel.addColumn(ThemisFolder.Column.LASTUSER);
        this.tablemodel.setTableColumnWidth();
        this.table.revalidate();
        this.table.repaint();
        this.setSort(1);
    }

    public void addProject(ThemisFolder tf) {
        this.tablemodel.addThemisFolder(tf);
    }

    public void addThemisFile(File f) {
        this.tablemodel.addThemisFile(f);
    }

    public void clear() {
        this.tablemodel.clear();
    }

    public ArrayList<ThemisFolder> getSelection() {
        return this.tablemodel.getSelection();
    }

    public void selectAll() {
        this.tablemodel.selectAll();
        if (this.detailHandler != null) {
            ArrayList<ThemisFolder> selected = this.getSelection();
            this.detailHandler.showProjectDetails(selected.isEmpty() ? null : selected.get(0));
            this.detailHandler.updateProjectSelection(selected);
        }
    }

    public void clearSelection() {
        this.tablemodel.clearSelection();
        if (this.detailHandler != null) {
            ArrayList<ThemisFolder> selected = this.getSelection();
            this.detailHandler.showProjectDetails(selected.isEmpty() ? null : selected.get(0));
            this.detailHandler.updateProjectSelection(selected);
        }
    }

    private void setSort(int idx) {
        this.tablemodel.setSort(idx);
        this.populateList();
    }

    public void populateList() {
        this.table.clearSelection();
        this.table.setModel(this.tablemodel);
        this.tablemodel.setTableColumnWidth();
        this.table.revalidate();
        this.table.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setOpaque(false);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.table);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private class LocalHeaderRenderer
    extends DefaultTableCellRenderer {
        private LocalHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c == null) {
                return c;
            }
            if (c instanceof JLabel) {
                ((JLabel)c).setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
                TableModel m = table.getModel();
                if (m instanceof ProjectListTableModel) {
                    ProjectListTableModel model = (ProjectListTableModel)m;
                    int sortColumn = model.getCurrentSort();
                    if (column == sortColumn) {
                        ((JLabel)c).setFont(THEMIS.fontLabelBold);
                    } else {
                        ((JLabel)c).setFont(THEMIS.fontLabel);
                    }
                }
            }
            c.setBackground(ThemisColors.black);
            c.setForeground(ThemisColors.white);
            return c;
        }
    }

    private class LocalCellRenderer
    extends DefaultTableCellRenderer {
        private LocalCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ThemisFolder tf;
            Component c;
            SimpleDateFormat f = new SimpleDateFormat("dd.MM.yyyy");
            if (value instanceof Date) {
                value = f.format(value);
            }
            if ((c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) == null) {
                return c;
            }
            if (c instanceof JLabel) {
                ((JLabel)c).setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            }
            Color bg = ThemisColors.white;
            TableModel m = table.getModel();
            if (m instanceof ProjectListTableModel && (tf = ((ProjectListTableModel)m).getThemisFolder(row)) != null) {
                if (((ProjectListTableModel)m).getSelection().contains(tf)) {
                    bg = ThemisColors.lightgray;
                } else if (tf.getProjectLock().isLocked()) {
                    bg = tf.getProjectLock().isUsedOnSameComputerAndUser() ? ThemisColors.lightyellow : ThemisColors.lightred;
                }
            }
            c.setBackground(bg);
            c.setForeground(Color.BLACK);
            return c;
        }
    }

    private class LocalTableColumnHeaderListener
    extends MouseAdapter {
        private LocalTableColumnHeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int colidx = ProjectListTablePanel.this.table.columnAtPoint(evt.getPoint());
            if (colidx == 0) {
                if (!ProjectListTablePanel.this.getSelection().isEmpty()) {
                    ProjectListTablePanel.this.clearSelection();
                } else {
                    ProjectListTablePanel.this.selectAll();
                }
            } else {
                ProjectListTablePanel.this.setSort(colidx);
            }
        }
    }
}

