/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.project;

import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.application.project.SynchronisationConflictPanel;
import at.grid.themis.application.project.SynchronisationPanel;
import at.grid.themis.application.project.ViewHelper;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.project.ProjectManageWizard;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.sync.SynchronisationConflict;
import at.grid.themis.ontology.sync.SynchronisationManager;
import at.grid.themis.ontology.sync.SynchronisationTask;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javafx.scene.Node;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ProjectTopComponent", persistenceType=0)
public final class ProjectTopComponent
extends TopComponent
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisProject master = new ThemisProject(this.app);
    File masterFolder = null;
    File currentFoto = null;
    File currentLogo = null;
    SynchronisationManager syncmanager = null;
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/project/Bundle");
    private JButton btnLicenseUpgrade;
    private JButton btnMasterProject;
    private JButton btnOpenFolder;
    private JButton btnOpenFolder1;
    private JButton btnRemoveFoto;
    private JButton btnRemoveLogo;
    private JButton btnSaveProject;
    private JButton btnSelectFotoFile;
    private JButton btnSelectLogoFile;
    private JButton btnSyncAnalyse;
    private JButton btnSyncConflicts;
    private JButton btnSyncDetails;
    private JButton btnSyncExecute;
    private JButton btnUpdateProjectStats;
    private JTextField fldCountHistory1;
    private JTextField fldCountHistory2;
    private JTextField fldCountLocation1;
    private JTextField fldCountLocation2;
    private JTextField fldCountObservation1;
    private JTextField fldCountObservation2;
    private JComboBox<String> fldEvent;
    private JTextField fldLastAccess1;
    private JTextField fldLastAccess2;
    private JTextArea fldLicenseUpgrade;
    private JTextField fldMasterProject;
    private JTextArea fldProjectClient;
    private JTextArea fldProjectInfo;
    private JTextArea fldProjectLocation;
    private JTextField fldProjectName;
    private JTextField fldProjectNumber;
    private JTextField fldProjectPath;
    private JTextArea fldProjectStat;
    private JTextField fldProjectTitle;
    private JTextArea fldSyncResults;
    private JPanel infoPanel;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelFoto;
    private JLabel jLabelLogo;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JLabel labelLocation;
    private JLabel lblFotoDisplay;
    private JLabel lblLogoDisplay;
    private JPanel mainPanel;
    private JPanel mediaPanel;
    private JPanel panelLicenseUpgrade;
    private JPanel statisticPanel;
    private JPanel syncPanel;

    public ProjectTopComponent() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + ((Object)((Object)this)).getClass().getName() + " ...");
        THEMIS.getLicense();
        this.initComponents();
        this.setName(ResourceBundle.getBundle("at/grid/themis/application/project/Bundle").getString("CTL_ProjectTopComponent"));
        this.setToolTipText(ResourceBundle.getBundle("at/grid/themis/application/project/Bundle").getString("HINT_ProjectTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.dragging_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.undocking_disabled", Boolean.TRUE);
        THEMIS.removeUsualTabBehavior(this.fldProjectLocation);
        THEMIS.removeUsualTabBehavior(this.fldProjectInfo);
        THEMIS.removeUsualTabBehavior(this.fldProjectClient);
        this.populate();
        this.btnSyncAnalyse.setOpaque(true);
        this.btnSyncConflicts.setOpaque(true);
        this.btnSyncExecute.setOpaque(true);
        new DropTarget(this.lblFotoDisplay, new ThemisDropTargetListener(false, false){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent evt) {
                ProjectTopComponent.this.currentFoto = f;
                ProjectTopComponent.this.saveMedia(ProjectTopComponent.this.lblFotoDisplay, "projectimage", ProjectTopComponent.this.currentFoto);
            }
        });
        new DropTarget(this.lblLogoDisplay, new ThemisDropTargetListener(false, false){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent evt) {
                ProjectTopComponent.this.currentLogo = f;
                ProjectTopComponent.this.saveMedia(ProjectTopComponent.this.lblLogoDisplay, "projectlogo", ProjectTopComponent.this.currentLogo);
            }
        });
        ThemisActionProvider.getInstance().register(this);
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + ((Object)((Object)this)).getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(ThemisAction action) {
        if (action.is(ThemisAction.PROJECT_OPENED)) {
            this.populate();
        } else if (action.is(ThemisAction.PROJECT_CLOSED)) {
            if (this.master != null && this.master.isOpen()) {
                this.master.close(new Closing().withoutExport().withoutTrigger(), null);
            }
            this.populate();
            this.populateSync(false);
        }
    }

    private void populate() {
        if (this.project.isOpen()) {
            CmsProject p = this.project.getProjectElement();
            this.fldProjectTitle.setText(p.getAttributeValue("projecttitle"));
            this.fldProjectClient.setText(p.getAttributeValue("customer"));
            this.fldProjectNumber.setText(p.getAttributeValue("projectnumber"));
            this.fldProjectLocation.setText(p.getAttributeValue("projectlocation"));
            this.fldProjectPath.setText(this.project.getProjectFolder().getParent());
            this.fldProjectName.setText(this.project.getProjectFolder().getName());
            this.fldProjectInfo.setText(p.getAttributeValue("info"));
            this.populateMedia(p);
            this.updateProjectStats();
            Date dt = this.project.getLastAccessDate();
            this.fldLastAccess1.setText(dt == null ? "" : Util.formatDate((Date)dt, (String)Util.DATETIME_READ, (TimeZone)this.project.getTimeZone()));
            this.fldCountLocation1.setText(Integer.toString(this.project.getLocationCount()));
            this.fldCountObservation1.setText(Integer.toString(this.project.getObservationCount()));
            this.fldCountHistory1.setText(Integer.toString(this.project.getHistoryCount()));
            ((DefaultComboBoxModel)this.fldEvent.getModel()).removeAllElements();
            ArrayList events = this.project.getEvents();
            for (CmsElementSummary event : events) {
                ((DefaultComboBoxModel)this.fldEvent.getModel()).addElement(event);
            }
        } else {
            this.fldProjectClient.setText("");
            this.fldProjectInfo.setText("");
            this.fldProjectNumber.setText("");
            this.fldProjectLocation.setText("");
            this.fldProjectTitle.setText("");
            this.fldProjectStat.setText("");
            this.fldLastAccess1.setText("");
            this.fldCountLocation1.setText("");
            this.fldCountObservation1.setText("");
            this.fldCountHistory1.setText("");
            this.clearMedia();
            this.panelLicenseUpgrade.setVisible(false);
        }
        boolean projectOpen = this.project.isOpen();
        boolean insufficientLicense = ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE);
        this.fldProjectClient.setEnabled(projectOpen && !insufficientLicense);
        this.fldProjectInfo.setEnabled(projectOpen && !insufficientLicense);
        this.fldProjectNumber.setEnabled(projectOpen && !insufficientLicense);
        this.fldProjectTitle.setEnabled(projectOpen && !insufficientLicense);
        this.btnSaveProject.setEnabled(projectOpen && !insufficientLicense);
        this.fldProjectLocation.setEnabled(projectOpen && !insufficientLicense);
        this.btnSelectFotoFile.setEnabled(projectOpen && !insufficientLicense);
        this.btnSelectLogoFile.setEnabled(projectOpen && !insufficientLicense);
        this.btnRemoveFoto.setEnabled(projectOpen && !insufficientLicense);
        this.btnRemoveLogo.setEnabled(projectOpen && !insufficientLicense);
    }

    private void updateProjectStats() {
        StringBuilder sb = new StringBuilder();
        Properties stats = this.project.getProjectStatistics();
        if (stats != null) {
            ArrayList<String> keyList = new ArrayList<String>(stats.stringPropertyNames());
            Collections.sort(keyList);
            for (String kk : keyList) {
                if (kk.toLowerCase().startsWith("project.")) continue;
                sb.append(this.project.getResourceText("projectstat." + kk) + ": " + stats.getProperty(kk) + "\n");
            }
        }
        this.fldProjectStat.setText(sb.toString());
    }

    private void populateMedia(CmsProject projectEle) {
        List itemsFoto = projectEle.getUploadAttribute("projectimage").getUploadItems();
        UploadItem foto = null;
        if (!itemsFoto.isEmpty()) {
            foto = (UploadItem)itemsFoto.get(itemsFoto.size() - 1);
        }
        if (foto != null) {
            this.currentFoto = foto.getFile();
            this.lblFotoDisplay.addComponentListener(new ComponentAdapter(){
                private int lastWidth = 0;

                @Override
                public void componentResized(ComponentEvent ce) {
                    int newWidth = ProjectTopComponent.this.lblFotoDisplay.getWidth();
                    if (ProjectTopComponent.this.currentFoto != null && this.lastWidth == 0) {
                        this.lastWidth = newWidth;
                        ViewHelper.updateImage(ProjectTopComponent.this.lblFotoDisplay, ProjectTopComponent.this.currentFoto, -1, -1, ProjectTopComponent.this.project);
                    }
                }
            });
            ViewHelper.updateImage(this.lblFotoDisplay, this.currentFoto, -1, -1, this.project);
        } else {
            this.clearFoto();
        }
        List itemsLogo = projectEle.getUploadAttribute("projectlogo").getUploadItems();
        UploadItem logo = null;
        if (!itemsLogo.isEmpty()) {
            logo = (UploadItem)itemsLogo.get(itemsLogo.size() - 1);
        }
        if (logo != null) {
            this.currentLogo = logo.getFile();
            this.lblLogoDisplay.addComponentListener(new ComponentAdapter(){
                private int lastWidth = 0;

                @Override
                public void componentResized(ComponentEvent ce) {
                    int newWidth = ProjectTopComponent.this.lblLogoDisplay.getWidth();
                    if (ProjectTopComponent.this.currentLogo != null && this.lastWidth == 0) {
                        this.lastWidth = newWidth;
                        ViewHelper.updateImage(ProjectTopComponent.this.lblLogoDisplay, ProjectTopComponent.this.currentLogo, -1, -1, ProjectTopComponent.this.project);
                    }
                }
            });
            ViewHelper.updateImage(this.lblLogoDisplay, this.currentLogo, -1, -1, this.project);
        } else {
            this.clearLogo();
        }
    }

    private void clearFoto() {
        this.currentFoto = null;
        this.lblFotoDisplay.setIcon(null);
        this.lblFotoDisplay.setText(ResourceBundle.getBundle("at/grid/themis/application/project/Bundle").getString("ProjectTopComponent.lblFotoDisplay.text"));
    }

    private void clearLogo() {
        this.currentLogo = null;
        this.lblLogoDisplay.setIcon(null);
        this.lblLogoDisplay.setText(ResourceBundle.getBundle("at/grid/themis/application/project/Bundle").getString("ProjectTopComponent.lblLogoDisplay.text"));
    }

    private void clearMedia() {
        this.clearFoto();
        this.clearLogo();
    }

    private void populateSync(boolean allowSync) {
        if (this.master == null || !this.master.isOpen()) {
            this.fldMasterProject.setText("");
            this.btnMasterProject.setEnabled(true);
            this.fldSyncResults.setText("");
            this.fldCountHistory2.setText("");
            this.fldCountLocation2.setText("");
            this.fldCountObservation2.setText("");
            this.fldLastAccess2.setText("");
            this.btnSyncAnalyse.setEnabled(false);
            this.btnSyncAnalyse.setBackground(Color.lightGray);
            this.btnSyncDetails.setEnabled(false);
            this.btnSyncConflicts.setEnabled(false);
            this.btnSyncConflicts.setBackground(Color.lightGray);
            this.btnSyncExecute.setEnabled(false);
            this.btnSyncExecute.setBackground(Color.lightGray);
        } else {
            Date dt = this.master.getLastAccessDate();
            this.fldLastAccess2.setText(dt == null ? "" : Util.formatDate((Date)dt, (String)Util.DATETIME_READ, (TimeZone)this.master.getTimeZone()));
            this.fldCountLocation2.setText(Integer.toString(this.master.getLocationCount()));
            this.fldCountObservation2.setText(Integer.toString(this.master.getObservationCount()));
            this.fldCountHistory2.setText(Integer.toString(this.master.getHistoryCount()));
            this.fldMasterProject.setText(this.master.getProjectFolder().getAbsolutePath());
            this.btnMasterProject.setEnabled(false);
            this.btnSyncDetails.setEnabled(false);
            this.btnSyncConflicts.setEnabled(false);
            this.btnSyncConflicts.setBackground(Color.lightGray);
            this.btnSyncExecute.setEnabled(false);
            this.btnSyncExecute.setBackground(Color.lightGray);
            if (allowSync) {
                this.btnSyncAnalyse.setEnabled(true);
                this.btnSyncAnalyse.setBackground(Color.GREEN);
            } else {
                this.btnSyncAnalyse.setEnabled(false);
                this.btnSyncAnalyse.setBackground(Color.red);
            }
        }
    }

    private void applyProjectInfo() {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen()) {
            CmsProject p = this.project.getProjectElement();
            p.setAttributeValue("projecttitle", this.fldProjectTitle.getText());
            p.setAttributeValue("customer", this.fldProjectClient.getText());
            p.setAttributeValue("projectnumber", this.fldProjectNumber.getText());
            p.setAttributeValue("projectlocation", this.fldProjectLocation.getText());
            p.setAttributeValue("info", this.fldProjectInfo.getText());
            p.save();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.PROJECT_DETAILS_CHANGED);
            Dialogs.getInstance().showInfoDialog("project.info-saved");
        }
    }

    private void selectMaster() {
        File f = new ThemisFileDialog(this.project.getResourceText("sync.dialog.select-master-project"), ThemisFileDialog.DIALOGTYPE.DIRECTORY, this.app.getSettings().getFolderOpenProject().getValue(true), null, null, null, false).getSelectedFile();
        if (ThemisProject.isProjectFolder((File)f)) {
            this.master.open(f, null, null, false, false, false, null);
            boolean doTransfer = this.master.getProjectElement().isSameElement((CmsElement)this.project.getProjectElement());
            if (!doTransfer) {
                doTransfer = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/project/Bundle").getString("ProjectTopComponent.notSameResource.text"));
            }
            if (doTransfer) {
                this.masterFolder = f;
                this.populateSync(doTransfer);
            }
        } else {
            Dialogs.getInstance().showErrorDialog("sync.error.folder-not-a-directory");
        }
    }

    private void initComponents() {
        this.syncPanel = new JPanel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.fldLastAccess1 = new JTextField();
        this.jLabel17 = new JLabel();
        this.fldCountLocation1 = new JTextField();
        this.jLabel18 = new JLabel();
        this.fldCountObservation1 = new JTextField();
        this.fldCountObservation2 = new JTextField();
        this.fldCountLocation2 = new JTextField();
        this.fldLastAccess2 = new JTextField();
        this.jLabel22 = new JLabel();
        this.btnSyncAnalyse = new JButton();
        this.btnMasterProject = new JButton();
        this.jLabel23 = new JLabel();
        this.fldCountHistory1 = new JTextField();
        this.fldCountHistory2 = new JTextField();
        this.fldEvent = new JComboBox();
        this.fldMasterProject = new JTextField();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldSyncResults = new JTextArea();
        this.btnSyncExecute = new JButton();
        this.btnSyncConflicts = new JButton();
        this.btnSyncDetails = new JButton();
        this.jButton1 = new JButton();
        this.statisticPanel = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.fldProjectStat = new JTextArea();
        this.jLabel11 = new JLabel();
        this.btnUpdateProjectStats = new JButton();
        this.mediaPanel = new JPanel();
        this.panelLicenseUpgrade = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.fldLicenseUpgrade = new JTextArea();
        this.btnLicenseUpgrade = new JButton();
        this.mainPanel = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.infoPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel9 = new JLabel();
        this.fldProjectNumber = new JTextField();
        this.fldProjectTitle = new JTextField();
        this.labelLocation = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.fldProjectLocation = new JTextArea();
        this.jLabel14 = new JLabel();
        this.fldProjectPath = new JTextField();
        this.jLabel19 = new JLabel();
        this.fldProjectName = new JTextField();
        this.jLabel8 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.fldProjectClient = new JTextArea();
        this.jLabel10 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.fldProjectInfo = new JTextArea();
        this.jLabelFoto = new JLabel();
        this.lblFotoDisplay = new JLabel();
        this.btnSelectFotoFile = new JButton();
        this.btnRemoveFoto = new JButton();
        this.jLabelLogo = new JLabel();
        this.lblLogoDisplay = new JLabel();
        this.btnSelectLogoFile = new JButton();
        this.btnRemoveLogo = new JButton();
        this.btnSaveProject = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.btnOpenFolder = new JButton();
        this.btnOpenFolder1 = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel15.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel15.text"));
        this.jLabel16.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel16, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel16.text"));
        this.fldLastAccess1.setFont(THEMIS.fontTextfield);
        this.fldLastAccess1.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldLastAccess1.text"));
        this.fldLastAccess1.setEnabled(false);
        this.fldLastAccess1.setMinimumSize(new Dimension(5, 30));
        this.fldLastAccess1.setPreferredSize(new Dimension(120, 30));
        this.jLabel17.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel17, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel17.text"));
        this.fldCountLocation1.setFont(THEMIS.fontTextfield);
        this.fldCountLocation1.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldCountLocation1.text"));
        this.fldCountLocation1.setEnabled(false);
        this.fldCountLocation1.setMinimumSize(new Dimension(5, 30));
        this.fldCountLocation1.setPreferredSize(new Dimension(120, 30));
        this.jLabel18.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel18, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel18.text"));
        this.fldCountObservation1.setFont(THEMIS.fontTextfield);
        this.fldCountObservation1.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldCountObservation1.text"));
        this.fldCountObservation1.setEnabled(false);
        this.fldCountObservation1.setMinimumSize(new Dimension(5, 30));
        this.fldCountObservation1.setPreferredSize(new Dimension(120, 30));
        this.fldCountObservation2.setFont(THEMIS.fontTextfield);
        this.fldCountObservation2.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldCountObservation2.text"));
        this.fldCountObservation2.setEnabled(false);
        this.fldCountObservation2.setMinimumSize(new Dimension(5, 30));
        this.fldCountObservation2.setPreferredSize(new Dimension(120, 30));
        this.fldCountLocation2.setFont(THEMIS.fontTextfield);
        this.fldCountLocation2.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldCountLocation2.text"));
        this.fldCountLocation2.setEnabled(false);
        this.fldCountLocation2.setMinimumSize(new Dimension(5, 30));
        this.fldCountLocation2.setPreferredSize(new Dimension(120, 30));
        this.fldLastAccess2.setFont(THEMIS.fontTextfield);
        this.fldLastAccess2.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldLastAccess2.text"));
        this.fldLastAccess2.setEnabled(false);
        this.fldLastAccess2.setMinimumSize(new Dimension(5, 30));
        this.fldLastAccess2.setPreferredSize(new Dimension(120, 30));
        this.jLabel22.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel22, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel22.text"));
        this.btnSyncAnalyse.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSyncAnalyse, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnSyncAnalyse.text"));
        this.btnSyncAnalyse.setBorder(new SoftBevelBorder(0));
        this.btnSyncAnalyse.setMinimumSize(new Dimension(3, 22));
        this.btnSyncAnalyse.setPreferredSize(new Dimension(120, 35));
        this.btnSyncAnalyse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnSyncAnalyseActionPerformed(evt);
            }
        });
        this.btnMasterProject.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnMasterProject, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnMasterProject.text"));
        this.btnMasterProject.setBorder(new SoftBevelBorder(0));
        this.btnMasterProject.setMinimumSize(new Dimension(5, 22));
        this.btnMasterProject.setPreferredSize(new Dimension(190, 30));
        this.btnMasterProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnMasterProjectActionPerformed(evt);
            }
        });
        this.jLabel23.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel23, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel23.text"));
        this.fldCountHistory1.setFont(THEMIS.fontTextfield);
        this.fldCountHistory1.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldCountHistory1.text"));
        this.fldCountHistory1.setEnabled(false);
        this.fldCountHistory1.setMinimumSize(new Dimension(5, 30));
        this.fldCountHistory1.setPreferredSize(new Dimension(120, 30));
        this.fldCountHistory2.setFont(THEMIS.fontTextfield);
        this.fldCountHistory2.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldCountHistory2.text"));
        this.fldCountHistory2.setEnabled(false);
        this.fldCountHistory2.setMinimumSize(new Dimension(5, 30));
        this.fldCountHistory2.setPreferredSize(new Dimension(120, 30));
        this.fldEvent.setFont(THEMIS.fontList);
        this.fldEvent.setModel(new DefaultComboBoxModel());
        this.fldEvent.setMinimumSize(new Dimension(5, 26));
        this.fldMasterProject.setEditable(false);
        this.fldMasterProject.setFont(THEMIS.fontTextfield);
        this.fldMasterProject.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldMasterProject.text"));
        this.fldMasterProject.setPreferredSize(new Dimension(6, 30));
        this.jLabel26.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel26, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel26.text"));
        this.jLabel27.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel27, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel27.text"));
        this.jLabel28.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel28, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel28.text"));
        this.jScrollPane1.setMinimumSize(new Dimension(10, 20));
        this.fldSyncResults.setColumns(20);
        this.fldSyncResults.setFont(THEMIS.fontTextfieldFixed);
        this.fldSyncResults.setRows(5);
        this.fldSyncResults.setMinimumSize(new Dimension(5, 16));
        this.jScrollPane1.setViewportView(this.fldSyncResults);
        this.btnSyncExecute.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSyncExecute, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnSyncExecute.text"));
        this.btnSyncExecute.setBorder(new SoftBevelBorder(0));
        this.btnSyncExecute.setMinimumSize(new Dimension(3, 22));
        this.btnSyncExecute.setPreferredSize(new Dimension(120, 35));
        this.btnSyncExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnSyncExecuteActionPerformed(evt);
            }
        });
        this.btnSyncConflicts.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSyncConflicts, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnSyncConflicts.text"));
        this.btnSyncConflicts.setBorder(new SoftBevelBorder(0));
        this.btnSyncConflicts.setMinimumSize(new Dimension(3, 22));
        this.btnSyncConflicts.setPreferredSize(new Dimension(120, 35));
        this.btnSyncConflicts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnSyncConflictsActionPerformed(evt);
            }
        });
        this.btnSyncDetails.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSyncDetails, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnSyncDetails.text"));
        this.btnSyncDetails.setBorder(new SoftBevelBorder(0));
        this.btnSyncDetails.setMinimumSize(new Dimension(5, 22));
        this.btnSyncDetails.setPreferredSize(new Dimension(120, 35));
        this.btnSyncDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnSyncDetailsActionPerformed(evt);
            }
        });
        this.jButton1.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jButton1.text"));
        this.jButton1.setBorder(new SoftBevelBorder(0));
        this.jButton1.setMinimumSize(new Dimension(5, 22));
        this.jButton1.setPreferredSize(new Dimension(190, 30));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout syncPanelLayout = new GroupLayout(this.syncPanel);
        this.syncPanel.setLayout(syncPanelLayout);
        syncPanelLayout.setHorizontalGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(syncPanelLayout.createSequentialGroup().addContainerGap().addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel28, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel27, -1, -1, Short.MAX_VALUE).addComponent(this.fldEvent, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, syncPanelLayout.createSequentialGroup().addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel23, -2, 1, Short.MAX_VALUE).addComponent(this.jLabel18, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel16, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel17, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel22, -1, -1, Short.MAX_VALUE).addComponent(this.fldCountLocation1, -1, -1, Short.MAX_VALUE).addComponent(this.fldCountObservation1, -1, -1, Short.MAX_VALUE).addComponent(this.fldCountHistory1, -1, -1, Short.MAX_VALUE).addComponent(this.fldLastAccess1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fldCountObservation2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.fldCountLocation2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.fldCountHistory2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel26, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.fldLastAccess2, -1, -1, Short.MAX_VALUE)).addGap(1, 1, 1)).addGroup(GroupLayout.Alignment.TRAILING, syncPanelLayout.createSequentialGroup().addComponent(this.btnSyncAnalyse, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSyncConflicts, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSyncExecute, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, syncPanelLayout.createSequentialGroup().addGap(254, 254, 254).addComponent(this.btnSyncDetails, -1, -1, Short.MAX_VALUE)).addGroup(syncPanelLayout.createSequentialGroup().addComponent(this.btnMasterProject, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, syncPanelLayout.createSequentialGroup().addComponent(this.jLabel15, -2, 119, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldMasterProject, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        syncPanelLayout.setVerticalGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(syncPanelLayout.createSequentialGroup().addContainerGap().addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.fldMasterProject, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, 33, Short.MAX_VALUE).addComponent(this.btnMasterProject, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel22).addComponent(this.jLabel26)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldLastAccess1, GroupLayout.Alignment.TRAILING, -2, 30, -2).addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16, -2, 30, -2).addComponent(this.fldLastAccess2, -2, 30, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17, -2, 30, -2).addComponent(this.fldCountLocation1, -2, 30, -2).addComponent(this.fldCountLocation2, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18, -2, 30, -2).addComponent(this.fldCountObservation1, -2, 30, -2).addComponent(this.fldCountObservation2, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel23, -2, 30, -2).addComponent(this.fldCountHistory1, -2, 30, -2).addComponent(this.fldCountHistory2, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel27).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldEvent, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(syncPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSyncAnalyse, -2, -1, -2).addComponent(this.btnSyncExecute, -2, -1, -2).addComponent(this.btnSyncConflicts, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel28).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 262, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSyncDetails, -2, -1, -2).addGap(6, 6, 6)));
        this.jScrollPane6.setMinimumSize(new Dimension(10, 20));
        this.fldProjectStat.setColumns(20);
        this.fldProjectStat.setFont(THEMIS.fontTextfield);
        this.fldProjectStat.setLineWrap(true);
        this.fldProjectStat.setRows(3);
        this.fldProjectStat.setWrapStyleWord(true);
        this.fldProjectStat.setMinimumSize(new Dimension(10, 16));
        this.jScrollPane6.setViewportView(this.fldProjectStat);
        this.jLabel11.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel11.text"));
        this.btnUpdateProjectStats.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpdateProjectStats, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnUpdateProjectStats.text"));
        this.btnUpdateProjectStats.setMinimumSize(new Dimension(10, 32));
        this.btnUpdateProjectStats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnUpdateProjectStatsActionPerformed(evt);
            }
        });
        GroupLayout statisticPanelLayout = new GroupLayout(this.statisticPanel);
        this.statisticPanel.setLayout(statisticPanelLayout);
        statisticPanelLayout.setHorizontalGroup(statisticPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statisticPanelLayout.createSequentialGroup().addContainerGap().addGroup(statisticPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane6, -1, 361, Short.MAX_VALUE).addGroup(statisticPanelLayout.createSequentialGroup().addComponent(this.jLabel11).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.btnUpdateProjectStats, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        statisticPanelLayout.setVerticalGroup(statisticPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statisticPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane6, -1, 192, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUpdateProjectStats, -2, -1, -2).addContainerGap()));
        this.mediaPanel.setLayout(new GridBagLayout());
        this.fldLicenseUpgrade.setEditable(false);
        this.fldLicenseUpgrade.setColumns(20);
        this.fldLicenseUpgrade.setFont(THEMIS.fontTextfield);
        this.fldLicenseUpgrade.setLineWrap(true);
        this.fldLicenseUpgrade.setRows(5);
        this.fldLicenseUpgrade.setWrapStyleWord(true);
        this.fldLicenseUpgrade.setMinimumSize(new Dimension(5, 16));
        this.jScrollPane2.setViewportView(this.fldLicenseUpgrade);
        this.btnLicenseUpgrade.setFont(THEMIS.fontButton);
        this.btnLicenseUpgrade.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLicenseUpgrade, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnLicenseUpgrade.text"));
        this.btnLicenseUpgrade.setMinimumSize(new Dimension(10, 40));
        this.btnLicenseUpgrade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnLicenseUpgradeActionPerformed(evt);
            }
        });
        GroupLayout panelLicenseUpgradeLayout = new GroupLayout(this.panelLicenseUpgrade);
        this.panelLicenseUpgrade.setLayout(panelLicenseUpgradeLayout);
        panelLicenseUpgradeLayout.setHorizontalGroup(panelLicenseUpgradeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.btnLicenseUpgrade, -1, -1, Short.MAX_VALUE));
        panelLicenseUpgradeLayout.setVerticalGroup(panelLicenseUpgradeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLicenseUpgradeLayout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLicenseUpgrade, -2, 35, -2).addGap(0, 19, Short.MAX_VALUE)));
        this.mediaPanel.add((Component)this.panelLicenseUpgrade, new GridBagConstraints());
        this.setPreferredSize(new Dimension(411, 462));
        this.mainPanel.setMinimumSize(new Dimension(10, 0));
        this.mainPanel.setPreferredSize(new Dimension(200, 0));
        this.mainPanel.setLayout(new BorderLayout());
        this.jScrollPane7.getVerticalScrollBar().setUnitIncrement(16);
        this.infoPanel.setMinimumSize(new Dimension(100, 100));
        this.infoPanel.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel1.text"));
        this.jLabel1.setMinimumSize(new Dimension(70, 20));
        this.jLabel1.setPreferredSize(new Dimension(70, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel9.text"));
        this.jLabel9.setMinimumSize(new Dimension(70, 20));
        this.jLabel9.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jLabel9, gridBagConstraints);
        this.fldProjectNumber.setColumns(15);
        this.fldProjectNumber.setFont(THEMIS.fontTextfield);
        this.fldProjectNumber.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldProjectNumber.text"));
        this.fldProjectNumber.setMinimumSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.fldProjectNumber, gridBagConstraints);
        this.fldProjectTitle.setColumns(15);
        this.fldProjectTitle.setFont(THEMIS.fontTextfield);
        this.fldProjectTitle.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldProjectTitle.text"));
        this.fldProjectTitle.setMinimumSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.fldProjectTitle, gridBagConstraints);
        this.labelLocation.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.labelLocation.text"));
        this.labelLocation.setMinimumSize(new Dimension(70, 20));
        this.labelLocation.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.labelLocation, gridBagConstraints);
        this.jScrollPane5.setMinimumSize(new Dimension(50, 80));
        this.jScrollPane5.setPreferredSize(new Dimension(50, 80));
        this.fldProjectLocation.setColumns(20);
        this.fldProjectLocation.setFont(THEMIS.fontTextfield);
        this.fldProjectLocation.setLineWrap(true);
        this.fldProjectLocation.setRows(3);
        this.fldProjectLocation.setWrapStyleWord(true);
        this.jScrollPane5.setViewportView(this.fldProjectLocation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jScrollPane5, gridBagConstraints);
        this.jLabel14.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel14.text"));
        this.jLabel14.setMaximumSize(new Dimension(40, 20));
        this.jLabel14.setMinimumSize(new Dimension(70, 20));
        this.jLabel14.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jLabel14, gridBagConstraints);
        this.fldProjectPath.setColumns(15);
        this.fldProjectPath.setFont(THEMIS.fontTextfield);
        this.fldProjectPath.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldProjectPath.text"));
        this.fldProjectPath.setEnabled(false);
        this.fldProjectPath.setMaximumSize(new Dimension(200, 24));
        this.fldProjectPath.setMinimumSize(new Dimension(100, 24));
        this.fldProjectPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.fldProjectPathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.fldProjectPath, gridBagConstraints);
        this.jLabel19.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel19, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel19.text"));
        this.jLabel19.setMaximumSize(new Dimension(29, 20));
        this.jLabel19.setMinimumSize(new Dimension(70, 20));
        this.jLabel19.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jLabel19, gridBagConstraints);
        this.fldProjectName.setColumns(15);
        this.fldProjectName.setFont(THEMIS.fontTextfield);
        this.fldProjectName.setText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.fldProjectName.text"));
        this.fldProjectName.setEnabled(false);
        this.fldProjectName.setMinimumSize(new Dimension(100, 24));
        this.fldProjectName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.fldProjectNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.fldProjectName, gridBagConstraints);
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel8.text"));
        this.jLabel8.setMinimumSize(new Dimension(70, 20));
        this.jLabel8.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.jScrollPane4.setMinimumSize(new Dimension(100, 80));
        this.jScrollPane4.setPreferredSize(new Dimension(100, 80));
        this.fldProjectClient.setColumns(20);
        this.fldProjectClient.setFont(THEMIS.fontTextfield);
        this.fldProjectClient.setLineWrap(true);
        this.fldProjectClient.setRows(3);
        this.fldProjectClient.setWrapStyleWord(true);
        this.jScrollPane4.setViewportView(this.fldProjectClient);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jLabel10.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel10.text"));
        this.jLabel10.setMinimumSize(new Dimension(70, 20));
        this.jLabel10.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jLabel10, gridBagConstraints);
        this.jScrollPane3.setMinimumSize(new Dimension(100, 80));
        this.jScrollPane3.setPreferredSize(new Dimension(100, 80));
        this.fldProjectInfo.setColumns(20);
        this.fldProjectInfo.setFont(THEMIS.fontTextfield);
        this.fldProjectInfo.setLineWrap(true);
        this.fldProjectInfo.setRows(3);
        this.fldProjectInfo.setWrapStyleWord(true);
        this.jScrollPane3.setViewportView(this.fldProjectInfo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jLabelFoto.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabelFoto, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabelFoto.text"));
        this.jLabelFoto.setToolTipText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabelFoto.toolTipText"));
        this.jLabelFoto.setMinimumSize(new Dimension(70, 20));
        this.jLabelFoto.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jLabelFoto, gridBagConstraints);
        this.lblFotoDisplay.setFont(THEMIS.fontLabel);
        this.lblFotoDisplay.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblFotoDisplay, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.lblFotoDisplay.text"));
        this.lblFotoDisplay.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.lblFotoDisplay.setMaximumSize(new Dimension(200, 150));
        this.lblFotoDisplay.setMinimumSize(new Dimension(200, 150));
        this.lblFotoDisplay.setPreferredSize(new Dimension(200, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.lblFotoDisplay, gridBagConstraints);
        this.btnSelectFotoFile.setFont(THEMIS.fontButton);
        this.btnSelectFotoFile.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFotoFile, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnSelectFotoFile.text"));
        this.btnSelectFotoFile.setToolTipText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnSelectFotoFile.toolTipText"));
        this.btnSelectFotoFile.setBorder(new SoftBevelBorder(0));
        this.btnSelectFotoFile.setMargin(new Insets(6, 14, 14, 14));
        this.btnSelectFotoFile.setMaximumSize(new Dimension(35, 35));
        this.btnSelectFotoFile.setMinimumSize(new Dimension(35, 35));
        this.btnSelectFotoFile.setPreferredSize(new Dimension(35, 35));
        this.btnSelectFotoFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnSelectFotoFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.btnSelectFotoFile, gridBagConstraints);
        this.btnRemoveFoto.setFont(THEMIS.fontButton);
        this.btnRemoveFoto.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveFoto, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnRemoveFoto.text"));
        this.btnRemoveFoto.setToolTipText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnRemoveFoto.toolTipText"));
        this.btnRemoveFoto.setBorder(new SoftBevelBorder(0));
        this.btnRemoveFoto.setMargin(new Insets(12, 12, 12, 12));
        this.btnRemoveFoto.setMaximumSize(new Dimension(35, 35));
        this.btnRemoveFoto.setMinimumSize(new Dimension(35, 35));
        this.btnRemoveFoto.setPreferredSize(new Dimension(35, 35));
        this.btnRemoveFoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnRemoveFotoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.btnRemoveFoto, gridBagConstraints);
        this.jLabelLogo.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabelLogo, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabelLogo.text"));
        this.jLabelLogo.setToolTipText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabelLogo.toolTipText"));
        this.jLabelLogo.setMinimumSize(new Dimension(70, 20));
        this.jLabelLogo.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.jLabelLogo, gridBagConstraints);
        this.lblLogoDisplay.setFont(THEMIS.fontLabel);
        this.lblLogoDisplay.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblLogoDisplay, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.lblLogoDisplay.text"));
        this.lblLogoDisplay.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.lblLogoDisplay.setMaximumSize(new Dimension(200, 150));
        this.lblLogoDisplay.setMinimumSize(new Dimension(200, 150));
        this.lblLogoDisplay.setPreferredSize(new Dimension(200, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 15, 5);
        this.infoPanel.add((Component)this.lblLogoDisplay, gridBagConstraints);
        this.btnSelectLogoFile.setFont(THEMIS.fontButton);
        this.btnSelectLogoFile.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectLogoFile, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnSelectLogoFile.text"));
        this.btnSelectLogoFile.setToolTipText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnSelectLogoFile.toolTipText"));
        this.btnSelectLogoFile.setBorder(new SoftBevelBorder(0));
        this.btnSelectLogoFile.setMargin(new Insets(6, 14, 14, 14));
        this.btnSelectLogoFile.setMaximumSize(new Dimension(35, 35));
        this.btnSelectLogoFile.setMinimumSize(new Dimension(35, 35));
        this.btnSelectLogoFile.setPreferredSize(new Dimension(35, 35));
        this.btnSelectLogoFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnSelectLogoFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.btnSelectLogoFile, gridBagConstraints);
        this.btnRemoveLogo.setFont(THEMIS.fontButton);
        this.btnRemoveLogo.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveLogo, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnRemoveLogo.text"));
        this.btnRemoveLogo.setToolTipText(NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnRemoveLogo.toolTipText"));
        this.btnRemoveLogo.setBorder(new SoftBevelBorder(0));
        this.btnRemoveLogo.setMargin(new Insets(12, 12, 12, 12));
        this.btnRemoveLogo.setMaximumSize(new Dimension(35, 35));
        this.btnRemoveLogo.setMinimumSize(new Dimension(35, 35));
        this.btnRemoveLogo.setPreferredSize(new Dimension(35, 35));
        this.btnRemoveLogo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnRemoveLogoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.infoPanel.add((Component)this.btnRemoveLogo, gridBagConstraints);
        this.btnSaveProject.setFont(THEMIS.fontButton);
        this.btnSaveProject.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveProject, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnSaveProject.text"));
        this.btnSaveProject.setBorder(new SoftBevelBorder(0));
        this.btnSaveProject.setMaximumSize(new Dimension(92, 40));
        this.btnSaveProject.setMinimumSize(new Dimension(10, 40));
        this.btnSaveProject.setPreferredSize(new Dimension(92, 40));
        this.btnSaveProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnSaveProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 15, 5);
        this.infoPanel.add((Component)this.btnSaveProject, gridBagConstraints);
        this.jPanel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        this.jPanel1.setMinimumSize(new Dimension(100, 40));
        this.jPanel1.setPreferredSize(new Dimension(233, 40));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel2.text"));
        this.jLabel2.setMaximumSize(new Dimension(9999, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 24;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.btnOpenFolder.setFont(THEMIS.fontButton);
        this.btnOpenFolder.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_openProject24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenFolder, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnOpenFolder.text"));
        this.btnOpenFolder.setBorder(new SoftBevelBorder(0));
        this.btnOpenFolder.setMaximumSize(new Dimension(100, 40));
        this.btnOpenFolder.setMinimumSize(new Dimension(100, 40));
        this.btnOpenFolder.setPreferredSize(new Dimension(100, 40));
        this.btnOpenFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnOpenFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this.btnOpenFolder, gridBagConstraints);
        this.btnOpenFolder1.setFont(THEMIS.fontButton);
        this.btnOpenFolder1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_releaseInfo.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenFolder1, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.btnOpenFolder1.text"));
        this.btnOpenFolder1.setBorder(new SoftBevelBorder(0));
        this.btnOpenFolder1.setMaximumSize(new Dimension(100, 40));
        this.btnOpenFolder1.setMinimumSize(null);
        this.btnOpenFolder1.setPreferredSize(null);
        this.btnOpenFolder1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectTopComponent.this.btnOpenFolder1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this.btnOpenFolder1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.infoPanel.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ProjectTopComponent.class, (String)"ProjectTopComponent.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.infoPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.jScrollPane7.setViewportView(this.infoPanel);
        this.mainPanel.add((Component)this.jScrollPane7, "Center");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, 423, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, 595, Short.MAX_VALUE));
    }

    private void btnSaveProjectActionPerformed(ActionEvent evt) {
        this.applyProjectInfo();
    }

    private void btnMasterProjectActionPerformed(ActionEvent evt) {
        this.selectMaster();
    }

    private void btnSyncAnalyseActionPerformed(ActionEvent evt) {
        if (this.masterFolder != null) {
            this.master.open(this.masterFolder, null, null, false, false, false, null);
            long idEvent = ((CmsElementSummary)this.fldEvent.getSelectedItem()).getId();
            CmsEvent currentEvent = this.project.getCurrentEvent();
            this.syncmanager = new SynchronisationManager(this.project, this.master, idEvent);
            String result = this.syncmanager.analyse(false);
            this.fldSyncResults.setText(result);
            this.btnSyncDetails.setEnabled(true);
            if (this.syncmanager.getConflictTasks().size() > 0) {
                this.btnSyncConflicts.setEnabled(true);
                this.btnSyncConflicts.setBackground(Color.RED);
                this.btnSyncExecute.setEnabled(false);
                this.btnSyncExecute.setBackground(Color.lightGray);
            } else {
                this.btnSyncConflicts.setEnabled(false);
                this.btnSyncConflicts.setBackground(Color.lightGray);
                this.btnSyncExecute.setEnabled(true);
                this.btnSyncExecute.setBackground(Color.GREEN);
            }
        } else {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/project/Bundle").getString("ProjectTopComponent.masterUndefined.text"));
        }
    }

    private void fldProjectPathActionPerformed(ActionEvent evt) {
    }

    private void btnSyncExecuteActionPerformed(ActionEvent evt) {
        ThemisProgressHandler p = new ThemisProgressHandler("Ereignis \u00fcbertragen");
        this.syncmanager.execute((ProgressHandler)p);
        p.doneWithConfirm("FERTIG");
        this.master.close(new Closing().withoutExport().withoutTrigger(), null);
        this.populateSync(false);
    }

    private void btnSyncConflictsActionPerformed(ActionEvent evt) {
        if (this.syncmanager != null && this.master != null && this.master.isOpen()) {
            SynchronisationConflictPanel dlg = new SynchronisationConflictPanel(this.project, this.master, this.syncmanager);
            Dialogs.getInstance().showOkDialog(dlg, "Konflikte");
            ArrayList conflicts = this.syncmanager.getConflictTasks();
            boolean solved = true;
            for (SynchronisationTask t : conflicts) {
                solved = solved && ((SynchronisationConflict)t).isSolved();
            }
            if (solved) {
                this.btnSyncConflicts.setEnabled(false);
                this.btnSyncConflicts.setBackground(Color.lightGray);
                this.btnSyncExecute.setEnabled(true);
                this.btnSyncExecute.setBackground(Color.GREEN);
                String result = this.syncmanager.getResult();
                this.fldSyncResults.setText(result);
            }
        }
    }

    private void btnSyncDetailsActionPerformed(ActionEvent evt) {
        if (this.syncmanager != null) {
            SynchronisationPanel dlg = new SynchronisationPanel(this.project, this.master, this.syncmanager);
            Dialogs.getInstance().showOkDialog(dlg, "Sync");
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.master != null) {
            this.master.close(new Closing().withoutExport().withoutTrigger(), null);
            this.populateSync(false);
        }
    }

    private void btnLicenseUpgradeActionPerformed(ActionEvent evt) {
        if (Dialogs.getInstance().showConfirmDialog("license.upgrade-confirm")) {
            // empty if block
        }
    }

    private void btnUpdateProjectStatsActionPerformed(ActionEvent evt) {
        this.updateProjectStats();
    }

    private File selectMedia() {
        if (this.project.isOpen()) {
            try {
                File f = new ThemisFileDialog(this.bundle.getString("DIALOG_TITLE_FILECHOOSER"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getCurrentFolder(), null, THEMIS.getImageFilter(), null, false).getSelectedFile();
                return f;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void saveMedia(JLabel imageDisplay, String uploadAttribute, File imageFile) {
        if (this.project.isOpen()) {
            try {
                CmsProject projectEle = this.project.getProjectElement();
                if (imageFile != null) {
                    ViewHelper.updateImage(imageDisplay, imageFile, -1, -1, this.project);
                    if (imageDisplay.getIcon() == null) {
                        Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/project/Bundle").getString("WARNING_FOTO_REQUIREMENT"));
                        return;
                    }
                    projectEle.getUploadAttribute(uploadAttribute).addUpload(imageFile);
                } else {
                    projectEle.getUploadAttribute(uploadAttribute).clear();
                }
                projectEle.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void btnSelectFotoFileActionPerformed(ActionEvent evt) {
        this.currentFoto = this.selectMedia();
        this.saveMedia(this.lblFotoDisplay, "projectimage", this.currentFoto);
    }

    private void btnRemoveFotoActionPerformed(ActionEvent evt) {
        if (this.project.isOpen() && Dialogs.getInstance().showConfirmDialog("dialog.confirm-delete")) {
            this.project.getProjectElement().getUploadAttribute("projectimage").clear();
            this.project.getProjectElement().save();
            this.clearFoto();
        }
    }

    private void btnSelectLogoFileActionPerformed(ActionEvent evt) {
        this.currentLogo = this.selectMedia();
        this.saveMedia(this.lblLogoDisplay, "projectlogo", this.currentLogo);
    }

    private void btnRemoveLogoActionPerformed(ActionEvent evt) {
        if (this.project.isOpen() && Dialogs.getInstance().showConfirmDialog("dialog.confirm-delete")) {
            this.project.getProjectElement().getUploadAttribute("projectlogo").clear();
            this.project.getProjectElement().save();
            this.clearLogo();
        }
    }

    private void fldProjectNameActionPerformed(ActionEvent evt) {
    }

    private void btnOpenFolderActionPerformed(ActionEvent evt) {
        if (this.project.isOpen()) {
            try {
                Desktop.getDesktop().open(this.project.getProjectFolder().getParentFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void btnOpenFolder1ActionPerformed(ActionEvent evt) {
        final JavaFxSwingDialog dlg = new JavaFxSwingDialog("projectmanagement", 800, 700).setParentFrame(THEMIS.getMainWindow());
        ProjectManageWizard pmw = new ProjectManageWizard(){

            protected void onCancel(javafx.event.ActionEvent e) {
                this.apply();
                dlg.close();
            }
        };
        dlg.setContent((Node)pmw);
        dlg.show();
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PROJECT_DETAILS_CHANGED);
    }

    public void componentOpened() {
        this.populate();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

