/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.project;

import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.sync.SynchronisationConflict;
import at.grid.themis.ontology.sync.SynchronisationManager;
import at.grid.themis.ontology.sync.SynchronisationTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SynchronisationPanel
extends JPanel {
    ThemisProject copy;
    ThemisProject master;
    SynchronisationManager syncmanager;
    ArrayList<SynchronisationTask> tasks = new ArrayList();
    ArrayList<SynchronisationTask> postTasks = new ArrayList();
    ArrayList<SynchronisationTask> conflicts = new ArrayList();
    int idxConflict = -1;
    HashMap<String, String[]> conflictDetails = new HashMap();
    String completeResult;
    private JButton btnNextKonflikt;
    private JButton btnPreviousKonflikt;
    private JButton btnUseKopie;
    private JButton btnUseMaster;
    private JTextArea fldText;
    private JTextArea fldValueKopie;
    private JTextArea fldValueMaster;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JTable jTable1;
    private JLabel lblConflict;
    private JList<String> lstAttribute;
    private JList<String> lstStage;
    private JTabbedPane tableTask;

    public SynchronisationPanel(ThemisProject c, ThemisProject m, SynchronisationManager syncmanager) {
        this.copy = c;
        this.master = m;
        this.syncmanager = syncmanager;
        this.initComponents();
        this.completeResult = this.syncmanager.getResult();
        this.setText(this.completeResult);
        this.lstStage.setSelectedIndex(0);
    }

    private void updateResult() {
        int idx = this.lstStage.getSelectedIndex();
        switch (idx) {
            case 0: {
                StringBuilder sb = new StringBuilder();
                this.setText(sb.toString());
                break;
            }
            case 1: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getKeytableTasks()));
                break;
            }
            case 2: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getElementTasks("plan")));
                break;
            }
            case 3: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getElementTasks("event")));
                break;
            }
            case 4: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getElementTasks("company")));
                break;
            }
            case 5: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getElementTasks("info")));
                break;
            }
            case 6: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getElementTasks("locationtemplate")));
                break;
            }
            case 7: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getElementTasks("observationtemplate")));
                break;
            }
            case 8: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getElementTasks("measuretemplate")));
                break;
            }
            case 9: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getElementTasks("location")));
                break;
            }
            case 10: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getElementTasks("observation")));
                break;
            }
            case 11: {
                this.setText(this.syncmanager.getResultDetails(this.syncmanager.getConflictTasks()));
                break;
            }
            default: {
                this.setText("");
            }
        }
    }

    private void initComponents() {
        this.tableTask = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.fldText = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblConflict = new JLabel();
        this.btnNextKonflikt = new JButton();
        this.btnPreviousKonflikt = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.lstAttribute = new JList();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.fldValueKopie = new JTextArea();
        this.jLabel5 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.fldValueMaster = new JTextArea();
        this.btnUseKopie = new JButton();
        this.btnUseMaster = new JButton();
        this.jScrollPane6 = new JScrollPane();
        this.lstStage = new JList();
        this.setLayout(new BorderLayout(10, 10));
        this.fldText.setColumns(20);
        this.fldText.setFont(THEMIS.fontList);
        this.fldText.setRows(5);
        this.jScrollPane1.setViewportView(this.fldText);
        this.tableTask.addTab(NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.jScrollPane1.TabConstraints.tabTitle"), this.jScrollPane1);
        this.jTable1.setModel(new SyncTableModel());
        this.jScrollPane3.setViewportView(this.jTable1);
        this.tableTask.addTab(NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.jScrollPane3.TabConstraints.tabTitle"), this.jScrollPane3);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblConflict, (String)NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.lblConflict.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNextKonflikt, (String)NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.btnNextKonflikt.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPreviousKonflikt, (String)NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.btnPreviousKonflikt.text"));
        this.lstAttribute.setModel(new DefaultListModel());
        this.lstAttribute.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SynchronisationPanel.this.lstAttributeValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.lstAttribute);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.jLabel4.text"));
        this.fldValueKopie.setColumns(20);
        this.fldValueKopie.setRows(5);
        this.jScrollPane4.setViewportView(this.fldValueKopie);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.jLabel5.text"));
        this.fldValueMaster.setColumns(20);
        this.fldValueMaster.setRows(5);
        this.jScrollPane5.setViewportView(this.fldValueMaster);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUseKopie, (String)NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.btnUseKopie.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUseMaster, (String)NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.btnUseMaster.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.lblConflict).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnPreviousKonflikt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnNextKonflikt)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jScrollPane4, -2, -1, -2).addComponent(this.btnUseKopie, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jScrollPane5, -2, -1, -2).addComponent(this.btnUseMaster)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lblConflict).addComponent(this.btnNextKonflikt).addComponent(this.btnPreviousKonflikt)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnUseKopie).addComponent(this.btnUseMaster))).addComponent(this.jScrollPane2)).addContainerGap(150, Short.MAX_VALUE)));
        this.tableTask.addTab(NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.jPanel1.TabConstraints.tabTitle"), this.jPanel1);
        this.add((Component)this.tableTask, "Center");
        this.lstStage.setFont(THEMIS.fontList);
        this.lstStage.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Zusammenfassung", "Auswahlfelder", "Pl\u00e4ne", "Ereignisse", "Kontakte", "Dokumente", "Gegenstand-Vorlagen", "Beobachtungs-Vorlagen", "Ma\u00dfnahme-Vorlagen", "Gegenst\u00e4nde", "Beobachtungen", "KONFLIKTE"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstStage.setToolTipText(NbBundle.getMessage(SynchronisationPanel.class, (String)"SynchronisationPanel.lstStage.toolTipText"));
        this.lstStage.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SynchronisationPanel.this.lstStageValueChanged(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.lstStage);
        this.add((Component)this.jScrollPane6, "West");
    }

    private void lstAttributeValueChanged(ListSelectionEvent evt) {
        String attCode = this.lstAttribute.getSelectedValue();
        if (this.conflictDetails.containsKey(attCode)) {
            this.fldValueKopie.setText(this.conflictDetails.get(attCode)[0]);
            this.fldValueMaster.setText(this.conflictDetails.get(attCode)[1]);
        } else {
            this.fldValueKopie.setText("");
            this.fldValueMaster.setText("");
        }
    }

    private void lstStageValueChanged(ListSelectionEvent evt) {
        this.updateResult();
    }

    public void setText(String result) {
        this.fldText.setText(result);
    }

    public void setSynchronisationTasks(ArrayList<SynchronisationTask> tasks) {
        this.tasks = tasks;
        this.conflicts.clear();
        this.postTasks.clear();
        ((SyncTableModel)this.jTable1.getModel()).setTasks(tasks);
        for (SynchronisationTask t : tasks) {
            if (t instanceof SynchronisationConflict) {
                this.conflicts.add(t);
            }
            this.postTasks.addAll(t.getPostSynchronisationTasks());
        }
        if (this.conflicts.size() > 0) {
            this.idxConflict = 0;
            this.displayConflict(0);
        }
    }

    public void displayConflict(int idx) {
        SynchronisationTask t = this.conflicts.get(idx);
        this.lblConflict.setText(idx + 1 + ResourceBundle.getBundle("at/grid/themis/application/project/Bundle").getString("SynchronisationPanel.of.text") + this.conflicts.size());
        CmsElement eleC = this.copy.loadElement(t.getIdWork(), this.copy.getUser());
        CmsElement eleM = this.master.loadElement(t.getIdMaster(), this.master.getUser());
        this.conflictDetails.clear();
        for (CmsAttribute att : eleC.getAttributes()) {
            String valueM;
            String valueC = att.getValue();
            if (valueC.equals(valueM = eleM.getAttribute(att.getCode()).getValue())) continue;
            ((DefaultListModel)this.lstAttribute.getModel()).addElement(att.getCode());
            this.conflictDetails.put(att.getCode(), new String[]{valueC, valueM});
        }
    }

    class SyncTableModel
    extends AbstractTableModel {
        ArrayList<SynchronisationTask> tasks = new ArrayList();
        String[] columns = new String[]{"Kategorie", "Code", "Titel", "ID alt", "ID neu", "Aktion"};

        SyncTableModel() {
        }

        public void setTasks(ArrayList<SynchronisationTask> tasks) {
            this.tasks.clear();
            this.tasks.addAll(tasks);
        }

        @Override
        public int getRowCount() {
            return this.tasks.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || rowIndex >= this.getRowCount() || columnIndex < 0 || columnIndex >= this.getColumnCount()) {
                return null;
            }
            SynchronisationTask task = this.tasks.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return task.getCategory();
                }
                case 1: {
                    return task.getCode();
                }
                case 2: {
                    return task.getTitle();
                }
                case 3: {
                    return task.getIdWork();
                }
                case 4: {
                    return task.getIdMaster();
                }
                case 5: {
                    return task.getAction();
                }
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

