/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.project;

import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisProject;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ViewHelper {
    public static void updateImage(JLabel lbl, File imagefile, int size, ThemisProject project) {
        ViewHelper.updateImage(lbl, imagefile, size, 0, project);
    }

    public static void updateImage(JLabel lbl, File imagefile, int width, int height, ThemisProject project) {
        try {
            if (imagefile != null && imagefile.exists() && imagefile.isFile()) {
                BufferedImage bi;
                BufferedImage img = ImageHelper.loadImage((File)imagefile);
                if (img == null) {
                    Dialogs.getInstance().showErrorDialog(project.getResourceText("error.image-file-access") + ": " + imagefile.getAbsolutePath());
                    return;
                }
                if (width == -1 && height == -1) {
                    float lblRatio;
                    float ratio = (float)img.getWidth() / (float)img.getHeight();
                    if (ratio < (lblRatio = (float)lbl.getWidth() / (float)lbl.getHeight())) {
                        height = lbl.getHeight();
                    } else {
                        width = lbl.getWidth();
                    }
                }
                if ((bi = Util.resizeImage((BufferedImage)img, (int)width, (int)height, (int)2)) != null) {
                    lbl.setIcon(new ImageIcon(bi));
                }
            }
        }
        catch (IIOException ex) {
            Dialogs.getInstance().showErrorDialog(project.getResourceText("error.image-file-type") + ": " + imagefile.getAbsolutePath());
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog(project.getResourceText("error.image-file-access") + ": " + imagefile.getAbsolutePath());
        }
        lbl.setText("");
    }
}

