/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.report;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.gui.ImagePanel;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.report.doc.WordReportGenerator;
import at.grid.themis.application.report.xls.ExportXlsReport2;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.SimpleActionWithReturn;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.PdfContent;
import at.grid.themis.ontology.report.PdfContentAnnualOverview;
import at.grid.themis.ontology.report.PdfContentContactList;
import at.grid.themis.ontology.report.PdfContentDocumentList;
import at.grid.themis.ontology.report.PdfContentEventList;
import at.grid.themis.ontology.report.PdfContentHeading1;
import at.grid.themis.ontology.report.PdfContentPagebreak;
import at.grid.themis.ontology.report.PdfContentParagraph;
import at.grid.themis.ontology.report.PdfContentSignature;
import at.grid.themis.ontology.report.PdfContentStandardTable;
import at.grid.themis.ontology.report.PdfContentStandardTableOpen;
import at.grid.themis.ontology.report.PdfContentTable;
import at.grid.themis.ontology.report.PdfContentTitlepage;
import at.grid.themis.ontology.report.PlanCreator1;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.themis.ontology.report.pdf.PdfLayoutExporter;
import at.grid.themis.ontology.report.pdf.PdfSummaryExporter;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.openide.util.Exceptions;

public class Exporter {
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/report/Bundle");
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project;
    ArrayList<File> files = new ArrayList();
    private CmsReport rep;
    ArrayList<Long> documentIds = new ArrayList();
    ArrayList<Long> locationIds = new ArrayList();
    HashMap<Long, Integer> imageIds = new HashMap();

    public Exporter(ThemisProject project, CmsReport rep) {
        this.project = project;
        this.rep = rep;
    }

    private void exportExcel(ProgressHandler ph, int phFrom, int phTo) {
        File f = this.rep.getTemplateFile();
        if (f == null || !f.getName().contains(".xls")) {
            Dialogs.getInstance().showErrorDialog("error.template-xls");
            return;
        }
        ExportXlsReport2 xls = new ExportXlsReport2(this.rep);
        xls.export(this.rep.getDestinationFile(), this.rep, ph, phFrom, phTo);
        this.documentIds.addAll(xls.getDocumentIds());
        this.locationIds.addAll(xls.getLocationIds());
        this.imageIds.putAll(xls.getImageIds());
    }

    private void exportSimplePdfSummary(ProgressHandler ph, int phFrom, int phTo) {
        PdfSummaryExporter pdfsummary = new PdfSummaryExporter(this.rep);
        ThemisActionProvider.getInstance().setActive(false);
        File currentProjectFolder = this.project.getProjectFolder();
        CmsUser currentProjectUser = this.project.getUser();
        if (this.project.isOpen() && !this.project.close(THEMIS.getCloseProjectFeedback(new Closing().withoutExport().withoutTrigger()), ph)) {
            return;
        }
        ThemisFilter flt = new ThemisFilter(this.app);
        flt.setFilter(this.app.getFilter());
        for (ThemisFolder themis : this.rep.projects) {
            this.project.open(themis.getProjectFolder(), null, null, false, false, false, null);
            this.app.getFilter().setFilter(flt);
            ArrayList ids = pdfsummary.addObservationsFromFilter();
            this.project.close(new Closing().withoutExport().withoutTrigger(), ph);
        }
        if (currentProjectFolder != null) {
            this.project.open(currentProjectFolder, null, null, false, false, false, null);
        }
        pdfsummary.exportToPdf(this.rep.getDestinationFile(), this.rep, currentProjectUser, ph, 0, 100);
        ThemisActionProvider.getInstance().setActive(true);
        this.project.close(new Closing().withoutExport(), ph);
    }

    private void exportFreePdf(ProgressHandler ph, int phFrom, int phTo) {
        PdfLayoutExporter pdf = new PdfLayoutExporter(this.rep);
        pdf.exportToPdf(this.rep.getDestinationFile(), this.rep, this.project.getUser(), ph, phFrom, phTo);
        this.documentIds.addAll(pdf.getDocumentIds());
        this.locationIds.addAll(pdf.getLocationIds());
        this.imageIds.putAll(pdf.getImageIds());
    }

    private void exportExtendedPdf(ProgressHandler ph, int phFrom, int phTo) {
        this.rep.templatePdfLayout.clear();
        this.rep.templatePdfLayout.add(new PdfContentTitlepage());
        this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Begehungen / Termine"));
        this.rep.templatePdfLayout.add(new PdfContentParagraph().setText("Periode: " + this.rep.getPeriodAsString()));
        this.rep.templatePdfLayout.add(new PdfContentEventList());
        this.rep.templatePdfLayout.add(new PdfContentPagebreak());
        this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Jahres\u00fcbersicht"));
        this.rep.templatePdfLayout.add(new PdfContentAnnualOverview());
        this.rep.templatePdfLayout.add(new PdfContentPagebreak());
        this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Kontrollen und Feststellungen"));
        this.rep.templatePdfLayout.add(new PdfContentStandardTable());
        this.rep.templatePdfLayout.add(new PdfContentPagebreak());
        this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Offene Punkte aus fr\u00fcheren Perioden"));
        this.rep.templatePdfLayout.add(new PdfContentStandardTableOpen());
        this.rep.templatePdfLayout.add(new PdfContentPagebreak());
        this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Kontaktliste"));
        this.rep.templatePdfLayout.add(new PdfContentContactList());
        this.rep.templatePdfLayout.add(new PdfContentPagebreak());
        this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Dokumente"));
        this.rep.templatePdfLayout.add(new PdfContentDocumentList());
        this.rep.templatePdfLayout.add(new PdfContentPagebreak());
        if (this.rep.hasSignature()) {
            this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Unterschriften"));
            this.rep.templatePdfLayout.add(new PdfContentParagraph().setText("Dieser Bericht wurde in bestem Wissen und Gewissen angefertigt und wird als vollst\u00e4ndig best\u00e4tigt."));
            this.rep.templatePdfLayout.add(new PdfContentSignature());
        }
        PdfLayoutExporter pdf = new PdfLayoutExporter(this.rep);
        pdf.exportToPdf(this.rep.getDestinationFile(), this.rep, this.project.getUser(), ph, phFrom, phTo);
        this.documentIds.addAll(pdf.getDocumentIds());
        this.locationIds.addAll(pdf.getLocationIds());
        this.imageIds.putAll(pdf.getImageIds());
    }

    private void exportSimplePdf(ProgressHandler ph, int phFrom, int phTo) {
        this.rep.templatePdfLayout.clear();
        this.rep.templatePdfLayout.add(new PdfContentTitlepage());
        this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Feststellungen"));
        this.rep.templatePdfLayout.add(new PdfContentStandardTable());
        this.rep.templatePdfLayout.add(new PdfContentPagebreak());
        if (this.rep.hasSignature()) {
            this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Unterschriften"));
            this.rep.templatePdfLayout.add(new PdfContentParagraph().setText("Dieser Bericht wurde in bestem Wissen und Gewissen angefertigt und wird als vollst\u00e4ndig best\u00e4tigt."));
            this.rep.templatePdfLayout.add(new PdfContentSignature());
        }
        PdfLayoutExporter pdf = new PdfLayoutExporter(this.rep);
        pdf.exportToPdf(this.rep.getDestinationFile(), this.rep, this.project.getUser(), ph, phFrom, phTo);
        this.documentIds.addAll(pdf.getDocumentIds());
        this.locationIds.addAll(pdf.getLocationIds());
        this.imageIds.putAll(pdf.getImageIds());
    }

    private void createReportWithoutSave(ProgressHandler ph, int phFrom, int phTo) {
        this.rep.templatePdfLayout.clear();
        this.rep.templatePdfLayout.add(new PdfContentStandardTable());
        PdfLayoutExporter pdf = new PdfLayoutExporter(this.rep);
        pdf.exportToPdf(null, this.rep, this.project.getUser(), ph, phFrom, phTo);
        this.documentIds.addAll(pdf.getDocumentIds());
        this.locationIds.addAll(pdf.getLocationIds());
        this.imageIds.putAll(pdf.getImageIds());
    }

    private void exportSimplePdf2(ProgressHandler ph, int phFrom, int phTo) {
        this.rep.templatePdfLayout.clear();
        this.rep.templatePdfLayout.add(new PdfContentTitlepage());
        this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Feststellungen"));
        this.rep.templatePdfLayout.add(new PdfContentStandardTable());
        this.rep.templatePdfLayout.add(new PdfContentPagebreak());
        if (this.rep.event != null) {
            this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Offene Punkte aus fr\u00fcheren Begehungen"));
            this.rep.templatePdfLayout.add(new PdfContentStandardTableOpen());
            this.rep.templatePdfLayout.add(new PdfContentPagebreak());
        }
        if (this.rep.hasSignature()) {
            this.rep.templatePdfLayout.add(new PdfContentHeading1().setText("Unterschriften"));
            this.rep.templatePdfLayout.add(new PdfContentParagraph().setText("Dieser Bericht wurde in bestem Wissen und Gewissen angefertigt und wird als vollst\u00e4ndig best\u00e4tigt."));
            this.rep.templatePdfLayout.add(new PdfContentSignature());
        }
        PdfLayoutExporter pdf = new PdfLayoutExporter(this.rep);
        pdf.exportToPdf(this.rep.getDestinationFile(), this.rep, this.project.getUser(), ph, phFrom, phTo);
        this.documentIds.addAll(pdf.getDocumentIds());
        this.locationIds.addAll(pdf.getLocationIds());
        this.imageIds.putAll(pdf.getImageIds());
    }

    private void exportWord(ProgressHandler ph, int phFrom, int phTo) {
        File f = this.rep.getTemplateFile();
        if (f == null || !f.getName().endsWith(".docx")) {
            Dialogs.getInstance().showErrorDialog("error.template-doc");
            return;
        }
        try {
            WordReportGenerator doc = new WordReportGenerator(this.rep);
            doc.createReport(this.rep.getDestinationFile(), ph, phFrom, phTo);
            this.documentIds.addAll(doc.getDocumentIds());
            this.locationIds.addAll(doc.getLocationIds());
            this.imageIds.putAll(doc.getImageIds());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void exportPlans(ProgressHandler ph, int phFrom, int phTo) {
        ArrayList buildings = this.project.getBuildings();
        ArrayList<Long> planids = new ArrayList<Long>();
        for (Object building : buildings) {
            ArrayList plans = this.project.getPlansForBuilding(building.getId());
            for (CmsElementSummary plan : plans) {
                planids.add(plan.getId());
            }
        }
        ArrayList plans = this.project.getPlans();
        for (CmsElementSummary plan : plans) {
            if (planids.contains(plan.getId())) continue;
            planids.add(plan.getId());
        }
        if (ph.isCancelled()) {
            return;
        }
        int countTotal = planids.size();
        if (countTotal == 0) {
            return;
        }
        double progressStep = (phTo - phFrom) / countTotal;
        double progressSum = phFrom;
        float trans = this.rep.getTransparency();
        int countMissingImages = 0;
        ImagePanel img = ImagePanel.getInstance((Logger)ThemisApplication.getInstance().getProject().getLogger());
        img.setIconMinimumSize(15);
        img.setDisplayScale(0.25);
        PDDocument document = null;
        File pdffile = new File(this.rep.getExportFolder(), this.rep.getFilename() + "_plan.pdf");
        int fontSize = ThemisUtil.validateInteger((String)this.project.getProjectProperty("font.size", ThemisApplication.getInstance().getConfiguration("font.size", "14")), (int)14, (boolean)true, (String)"", (boolean)false);
        ThemisFilter f = new ThemisFilter(this.app, false);
        f.setLocationIds(this.locationIds, (Object)this);
        List recs = f.getFilteredLocations();
        ArrayList selLocIds = this.project.getSelectionManager().getSelectedLocationIds();
        this.project.getSelectionManager().clearSelection(false, (Object)this);
        int countPlan = 0;
        Iterator iterator = planids.iterator();
        while (iterator.hasNext()) {
            block31: {
                long planId = (Long)iterator.next();
                ph.progress("Pl\u00e4ne pr\u00fcfen (" + ++countPlan + "/" + planids.size() + ")", (int)progressSum);
                progressSum += progressStep;
                try {
                    File imagefile;
                    img.clearBackgroundImage();
                    img.removeGeometries();
                    CmsPlan plan = (CmsPlan)this.project.loadElement(planId, this.project.getUser());
                    boolean mapHasLocation = plan.containsLocation(this.locationIds);
                    if (!mapHasLocation && !this.rep.exportEmptyPlans) break block31;
                    ph.progress("Plane '" + plan.getTitle() + "' wird exportiert", (int)progressSum);
                    File planfile = new File(this.rep.getExportFolder(), this.rep.getFilename() + "_" + plan.getFilename() + ".jpg");
                    if (this.rep.exportPlanFormat == CmsReport.PlanFormat.MULTIPLEPDF) {
                        pdffile = new File(this.rep.getExportFolder(), this.rep.getFilename() + "_" + plan.getFilename() + ".pdf");
                    }
                    if ((imagefile = plan.getPlanFile()) == null) break block31;
                    if (imagefile == null || !imagefile.isFile()) {
                        ThemisLogger.logger.info("The image file '" + imagefile.getAbsolutePath() + "' does not exist");
                        if (countMissingImages == 0) {
                            Dialogs.getInstance().showErrorDialog(MessageFormat.format(this.bundle.getString("Exporter1.imageFileNotExists.text"), imagefile.getAbsolutePath()));
                        } else if (countMissingImages == 1) {
                            Dialogs.getInstance().showErrorDialog(MessageFormat.format(this.bundle.getString("Exporter1.imageFileNotExistsMany.text"), imagefile.getAbsolutePath()));
                        }
                        ++countMissingImages;
                        break block31;
                    }
                    img.setBackgroundImage(imagefile);
                    img.setBackgroundTransparency(trans);
                    int totalsize = img.getImageWidth() + img.getImageHeight();
                    img.setScaleIcons(true);
                    int calcObjects = 0;
                    calcObjects = PlanCreator1.loadGeometries((ThemisApplication)this.app, (ImagePanel)img, (CmsPlan)plan, (ThemisProject)this.project, (float)1.0f, this.locationIds, (boolean)false, (List)recs);
                    this.project.getLogger().fine("Exporting Plan " + plan.getTitle() + " with " + calcObjects + " locations");
                    if (calcObjects > 0 || this.rep.exportEmptyPlans) {
                        String stamp = plan.getTitle() + " (" + Util.formatDate((Date)new Date(), (String)Util.DATETIME_READ, (TimeZone)this.app.getTimeZone());
                        if (this.rep.event != null) {
                            stamp = stamp + " - " + this.rep.event.getTitle();
                        }
                        stamp = stamp + ")";
                        if (this.rep.planStampPosition == 1) {
                            img.addText(stamp, 50, 100, 100);
                        } else if (this.rep.planStampPosition == 2) {
                            img.addText(stamp, 50, 100, img.getImageHeight() - 50);
                        }
                        if (this.rep.exportPlanFormat == CmsReport.PlanFormat.JPG) {
                            ImageIO.write((RenderedImage)img.getAsBufferedImage(), "jpg", planfile);
                        } else {
                            if (document == null || this.rep.exportPlanFormat == CmsReport.PlanFormat.MULTIPLEPDF) {
                                document = new PDDocument();
                            }
                            BufferedImage plan_bi = img.getAsBufferedImage(Math.max(1000, img.getImageWidth()), true);
                            float width = plan_bi.getWidth();
                            float height = plan_bi.getHeight();
                            float paperWidth = (float)(72 * plan.getPaperWidth()) / 25.4f;
                            float paperHeight = (float)(72 * plan.getPaperHeight()) / 25.4f;
                            float h = PDRectangle.A3.getHeight();
                            float w = PDRectangle.A3.getWidth();
                            PDPage page = new PDPage(new PDRectangle(paperWidth, paperHeight));
                            document.addPage(page);
                            int dpi = (int)((double)width / ((double)paperWidth / 2.54));
                            PDImageXObject pdfimage = JPEGFactory.createFromImage((PDDocument)document, (BufferedImage)plan_bi, (float)this.rep.getPdfCompressionValue(), (int)300);
                            PDPageContentStream contentStream = new PDPageContentStream(document, page);
                            contentStream.drawImage(pdfimage, 0.0f, 0.0f, paperWidth, paperHeight);
                            contentStream.close();
                            if (this.rep.exportPlanFormat == CmsReport.PlanFormat.MULTIPLEPDF) {
                                try {
                                    document.save(pdffile);
                                }
                                catch (Exception ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                try {
                                    document.close();
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        }
                    }
                    this.files.add(planfile);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (!ph.isCancelled()) continue;
            return;
        }
        if (this.rep.exportPlanFormat == CmsReport.PlanFormat.SINGLEPDF && document != null) {
            try {
                document.save(pdffile);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                document.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.project.getSelectionManager().setSelectedLocations((List)selLocIds, false, (Object)this);
    }

    private void exportDocuments(ProgressHandler ph, int phFrom, int phTo) {
        int countTotal = this.documentIds.size();
        if (countTotal == 0) {
            return;
        }
        double progressStep = (phTo - phFrom) / countTotal;
        double progressCurrent = phFrom;
        File targetFolder = new File(this.rep.getExportFolder(), "dokumente");
        targetFolder.mkdirs();
        for (long infoId : this.documentIds) {
            progressCurrent += progressStep;
            if (ph != null) {
                ph.progress("Dokumente speichern", (int)progressCurrent);
            }
            CmsInfo info = (CmsInfo)this.project.loadElement(infoId, this.project.getUser());
            UploadAttribute att = info.getUploadAttribute("files");
            for (UploadItem item : att.getUploadItems()) {
                File targetFile = new File(targetFolder, item.getName());
                this.files.add(targetFile);
                try {
                    Util.copy((File)item.getFile(), (File)targetFile);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void exportImages(CmsReport.ImageExport exportType, ProgressHandler ph, int phFrom, int phTo) {
        int countTotal = this.imageIds.size();
        if (countTotal == 0) {
            return;
        }
        double progressStep = (phTo - phFrom) / countTotal;
        double progressCurrent = phFrom;
        String foldername = Util.getFileNameWithoutExtension((File)this.rep.getDestinationFile()) + "_fotos";
        File targetFolder = new File(this.rep.getExportFolder(), foldername);
        targetFolder.mkdirs();
        for (Long uploadId : this.imageIds.keySet()) {
            try {
                String fn;
                progressCurrent += progressStep;
                if (ph != null) {
                    ph.progress("Bilder speichern", (int)progressCurrent - 1);
                }
                Integer number = this.imageIds.get(uploadId);
                UploadItem item = new UploadItem((CmsApplication)this.project, uploadId.longValue());
                if (item == null || item.getFile() == null || !item.getFile().exists()) continue;
                switch (exportType) {
                    case FILENAME: {
                        fn = item.getFilename();
                        break;
                    }
                    default: {
                        fn = Integer.toString(number) + "_" + item.getName();
                    }
                }
                File targetFile = new File(targetFolder, fn);
                this.files.add(targetFile);
                ArrayList drawings = ThemisApplication.getInstance().getProject().getDrawings(item.getId());
                if (drawings.isEmpty()) {
                    Util.copy((File)item.getFile(), (File)targetFile);
                    continue;
                }
                BufferedImage img = THEMIS.createImage((ArrayList<SimpleGeometry>)drawings, item.getFile(), -1);
                ImageIO.write((RenderedImage)img, "jpg", targetFile);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public String run(ProgressHandler ph) {
        SimpleActionWithReturn cancelAction = () -> {
            Util.delete((File)this.rep.getDestinationFile());
            for (File f : this.files) {
                Util.delete((File)f);
            }
            return true;
        };
        if (this.rep.getDestinationFile() == null) {
            return "ERROR, NO FILE";
        }
        ph.progress("Das Protokoll wird erstellt ...");
        int progressCount = 100;
        if (this.rep.exportPlans && !this.rep.summaryReport && this.project.getPlans().size() > 0) {
            progressCount += 100;
        }
        if (this.rep.includeDocuments) {
            progressCount += 50;
        }
        if (this.rep.includeImages != CmsReport.ImageExport.NO) {
            progressCount += 50;
        }
        ph.switchToDeterminate(progressCount);
        if (this.rep.exportOnlyPlans) {
            this.createReportWithoutSave(ph, 0, 99);
        } else {
            switch (this.rep.exportFormat) {
                case EXCEL: {
                    if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
                        return "INSUFFICIENT LICENSE ERROR";
                    }
                    this.exportExcel(ph, 0, 99);
                    break;
                }
                case PDF_EXTENDED: {
                    if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
                        return "INSUFFICIENT LICENSE ERROR";
                    }
                    this.exportExtendedPdf(ph, 0, 99);
                    break;
                }
                case PDF_FREE: {
                    if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
                        return "INSUFFICIENT LICENSE ERROR";
                    }
                    this.exportFreePdf(ph, 0, 99);
                    break;
                }
                case PDF_STANDARD: {
                    if (this.rep.summaryReport) {
                        this.exportSimplePdfSummary(ph, 0, 99);
                        break;
                    }
                    this.exportSimplePdf(ph, 0, 99);
                    break;
                }
                case PDF_STANDARD_OPEN: {
                    this.exportSimplePdf2(ph, 0, 99);
                    break;
                }
                case WORD: {
                    if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
                        return "INSUFFICIENT LICENSE ERROR";
                    }
                    this.exportWord(ph, 0, 99);
                }
            }
        }
        int progressFrom = 99;
        if (!ph.isCancelled() && (this.rep.exportOnlyPlans || this.rep.exportPlans) && this.project.getPlans().size() > 0) {
            this.exportPlans(ph, progressFrom + 1, progressFrom + 100);
            progressFrom += 100;
        }
        if (!ph.isCancelled() && !this.rep.exportOnlyPlans && this.rep.includeDocuments) {
            this.exportDocuments(ph, progressFrom + 1, progressFrom + 50);
            progressFrom += 50;
        }
        if (!ph.isCancelled() && !this.rep.exportOnlyPlans && this.rep.includeImages != CmsReport.ImageExport.NO) {
            this.exportImages(this.rep.includeImages, ph, progressFrom + 1, progressFrom + 50);
        }
        if (ph.isCancelled()) {
            cancelAction.execute();
        }
        return null;
    }

    void setReportSpecification(CmsReport rep) {
        this.rep = rep;
    }

    public static void saveReportLayouts(ArrayList<Long> ids, File f) {
        ThemisProject p = ThemisApplication.getInstance().getProject();
        if (ids == null || ids.isEmpty() || f == null) {
            return;
        }
        if (!ThemisApplication.getInstance().getProject().isOpen()) {
            return;
        }
        ThemisFile tf = new ThemisFile().setAsSpecific();
        tf.addContent(ids);
        ArrayList tableIds = new ArrayList();
        ArrayList<String> tableNames = new ArrayList<String>();
        block9: for (Long id : ids) {
            if (id == null || id <= 0L) continue;
            CmsReport rep = (CmsReport)p.loadElement(id.longValue(), p.getUser());
            switch (rep.exportFormat) {
                case EXCEL: 
                case PDF_EXTENDED: 
                case PDF_STANDARD: 
                case PDF_STANDARD_OPEN: {
                    break;
                }
                case PDF_FREE: {
                    for (PdfContent c : rep.templatePdfLayout) {
                        if (!(c instanceof PdfContentTable)) continue;
                        tableNames.add(((PdfContentTable)c).getLayoutName());
                    }
                    continue block9;
                }
                case WORD: {
                    try {
                        WordReportGenerator doc = new WordReportGenerator(rep);
                        doc.analyseReportTemplate();
                        tableNames.addAll(doc.getTableNames());
                        break;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        for (String tableName : tableNames) {
            ReportTableLayout rtl = p.getReportTableLayout(tableName);
            tf.addContent(rtl.getId());
        }
        try {
            tf.saveToFile(f, false);
            THEMIS.showFileResultDialog(f, false);
        }
        catch (IOException ex) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("Kann nicht gespeichert werden");
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

