/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.report;

import at.grid.cms.content.UploadItem;
import at.grid.gui.ImagePanel;
import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.util.ImageHelper;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.RefPtgBase;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.HeaderFooter;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PlaceholderLocation {
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public Workbook wb;
    public int sheet = 0;
    private int row = 0;
    public int rowmin = 0;
    public int rowmax = 0;
    public int rowdelta = 1;
    public int sheetRow = -1;
    public int col = 0;
    public HeaderFooter headerfooter = null;
    public int side;
    public CellStyle style = null;
    float rowheight = 0.0f;
    public String placeholder = "";
    public String content = null;
    public boolean contentChanged = false;
    public File imageFile = null;
    public int imageWidth = 0;
    public Hyperlink link = null;
    public BufferedImage image = null;
    public double imageScale = 4.0;
    public ArrayList<SimpleGeometry> drawings = new ArrayList();
    private HashMap<Cell, BufferedImage> postPopulate = new HashMap();
    private HashMap<Cell, File> postPopulateFiles = new HashMap();
    private HashMap<Cell, List<SimpleGeometry>> postPopulateDrawings = new HashMap();
    public boolean retainRowHeight = false;
    CellRangeAddress mergedRegion = null;
    boolean mergedRegionSet = false;
    int headingRows = 0;
    boolean formula = false;

    public PlaceholderLocation(PlaceholderLocation pl) {
        this.sheet = pl.sheet;
        this.row = pl.row;
        this.col = pl.col;
        this.style = pl.style;
        this.placeholder = pl.placeholder;
        this.rowheight = pl.rowheight;
        this.wb = pl.wb;
        this.formula = pl.formula;
    }

    public PlaceholderLocation(Workbook wb, HeaderFooter headerfooter, int side, String content) {
        this.wb = wb;
        this.headerfooter = headerfooter;
        this.side = side;
        this.placeholder = content;
    }

    public PlaceholderLocation(Workbook wb, int s, int r, int c, CellStyle style, String content) {
        Cell wbCell;
        Row wbRow;
        this.wb = wb;
        this.sheet = s;
        this.row = r;
        this.col = c;
        this.style = style;
        this.placeholder = content;
        Sheet wbSheet = wb.getSheetAt(s);
        if (wbSheet != null && (wbRow = wbSheet.getRow(r)) != null && (wbCell = wbRow.getCell(c)) != null && wbCell.getCellType().equals((Object)CellType.FORMULA)) {
            this.formula = true;
        }
    }

    public boolean isFormula() {
        return this.formula;
    }

    public PlaceholderLocation maintainRowHeight() {
        this.rowheight = this.wb.getSheetAt(this.sheet).getRow(this.row).getHeightInPoints();
        return this;
    }

    public boolean hasImage() {
        return this.image != null || this.imageFile != null;
    }

    public boolean hasHistory() {
        for (String ph : this.getPlaceholders()) {
            if (!ph.toLowerCase().startsWith("obs.history")) continue;
            return true;
        }
        return false;
    }

    public boolean hasImagePlaceholder() {
        for (String ph : this.getPlaceholders()) {
            if (!ph.toLowerCase().startsWith("obs.image")) continue;
            return true;
        }
        return false;
    }

    public boolean hasImageRepeatPlaceholder() {
        for (String ph : this.getPlaceholders()) {
            if (!ph.toLowerCase().startsWith("obs.image-")) continue;
            return true;
        }
        return false;
    }

    public boolean repeatForEachObservation() {
        return this.hasPlaceholder("#!#obs.repeat#!#");
    }

    public void ignoreMergedRegions() {
        this.mergedRegionSet = true;
    }

    public static void shiftPlaceholderDown(ArrayList<PlaceholderLocation> phs, int sheet, int row) {
        for (PlaceholderLocation ph : phs) {
            if (ph.sheet != sheet || ph.row < row) continue;
            ++ph.row;
        }
    }

    public static void copyCell(Sheet wbSheet, int col, int row0, int currentRow) {
        PlaceholderLocation.copyStyle(wbSheet, col, row0, currentRow);
        Row row = wbSheet.getRow(row0);
        Cell cell = row.getCell(col);
    }

    public static void copyRow(XSSFWorkbook workbook, XSSFSheet worksheet, int sourceRowNum, int destinationRowNum) {
        int i;
        XSSFRow newRow = worksheet.getRow(destinationRowNum);
        XSSFRow sourceRow = worksheet.getRow(sourceRowNum);
        if (newRow == null) {
            newRow = worksheet.createRow(destinationRowNum);
        }
        if (sourceRow == null) {
            ThemisApplication.getInstance().getProject().getLogger().severe("Error while copying row in XLSX report: row is null");
            return;
        }
        block8: for (i = 0; i < sourceRow.getLastCellNum(); ++i) {
            XSSFCell oldCell = sourceRow.getCell(i);
            XSSFCell newCell = newRow.createCell(i);
            if (oldCell == null) {
                newCell = null;
                continue;
            }
            newCell.setCellStyle((CellStyle)oldCell.getCellStyle());
            if (oldCell.getCellComment() != null) {
                newCell.setCellComment((Comment)oldCell.getCellComment());
            }
            if (oldCell.getHyperlink() != null) {
                newCell.setHyperlink((Hyperlink)oldCell.getHyperlink());
            }
            if (!oldCell.getCellType().equals((Object)CellType.FORMULA)) {
                newCell.setCellType(oldCell.getCellType());
            }
            switch (oldCell.getCellType()) {
                case BLANK: {
                    newCell.setCellValue(oldCell.getStringCellValue());
                    continue block8;
                }
                case BOOLEAN: {
                    newCell.setCellValue(oldCell.getBooleanCellValue());
                    continue block8;
                }
                case ERROR: {
                    newCell.setCellErrorValue(oldCell.getErrorCellValue());
                    continue block8;
                }
                case FORMULA: {
                    PlaceholderLocation.copyFormula((Sheet)worksheet, (Cell)oldCell, (Cell)newCell);
                    continue block8;
                }
                case NUMERIC: {
                    newCell.setCellValue(oldCell.getNumericCellValue());
                    continue block8;
                }
                case STRING: {
                    newCell.setCellValue((RichTextString)oldCell.getRichStringCellValue());
                }
            }
        }
        for (i = 0; i < worksheet.getNumMergedRegions(); ++i) {
            CellRangeAddress cellRangeAddress = worksheet.getMergedRegion(i);
            if (cellRangeAddress.getFirstRow() != sourceRow.getRowNum()) continue;
            CellRangeAddress newCellRangeAddress = new CellRangeAddress(newRow.getRowNum(), newRow.getRowNum() + (cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow()), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn());
            worksheet.addMergedRegion(newCellRangeAddress);
        }
    }

    public static void copyFormula(Sheet sheet, Cell org, Cell dest) {
        Ptg[] ptgs;
        if (org == null || dest == null || sheet == null || org.getCellType() != CellType.FORMULA) {
            return;
        }
        if (org.isPartOfArrayFormulaGroup()) {
            return;
        }
        String formula = org.getCellFormula();
        int shiftRows = dest.getRowIndex() - org.getRowIndex();
        int shiftCols = dest.getColumnIndex() - org.getColumnIndex();
        XSSFEvaluationWorkbook workbookWrapper = XSSFEvaluationWorkbook.create((XSSFWorkbook)((XSSFWorkbook)sheet.getWorkbook()));
        for (Ptg ptg : ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)workbookWrapper, (FormulaType)FormulaType.CELL, (int)sheet.getWorkbook().getSheetIndex(sheet))) {
            RefPtgBase ref;
            if (ptg instanceof RefPtgBase) {
                ref = (RefPtgBase)ptg;
                if (ref.isColRelative()) {
                    ref.setColumn(ref.getColumn() + shiftCols);
                }
                if (!ref.isRowRelative()) continue;
                ref.setRow(ref.getRow() + shiftRows);
                continue;
            }
            if (!(ptg instanceof AreaPtg)) continue;
            ref = (AreaPtg)ptg;
            if (ref.isFirstColRelative()) {
                ref.setFirstColumn(ref.getFirstColumn() + shiftCols);
            }
            if (ref.isLastColRelative()) {
                ref.setLastColumn(ref.getLastColumn() + shiftCols);
            }
            if (ref.isFirstRowRelative()) {
                ref.setFirstRow(ref.getFirstRow() + shiftRows);
            }
            if (!ref.isLastRowRelative()) continue;
            ref.setLastRow(ref.getLastRow() + shiftRows);
        }
        formula = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)workbookWrapper, (Ptg[])ptgs);
        dest.setCellFormula(formula);
    }

    public static void copyStyle(Sheet wbSheet, int col, int row0, int currentRow) {
        Cell cell;
        if (row0 == currentRow) {
            return;
        }
        Row row = wbSheet.getRow(row0);
        if (row == null) {
            row = wbSheet.createRow(row0);
        }
        if ((cell = row.getCell(col)) == null) {
            cell = row.createCell(col);
        }
        CellStyle style = cell.getCellStyle();
        row = wbSheet.getRow(currentRow);
        if (row == null) {
            row = wbSheet.createRow(currentRow);
        }
        if ((cell = row.getCell(col)) == null) {
            cell = row.createCell(col);
        }
        cell.setCellStyle(style);
    }

    public void setMergedRegion(CellRangeAddress mergedRegion) {
        this.mergedRegion = mergedRegion;
    }

    public boolean hasPlaceholder(String key) {
        return this.placeholder.contains(key);
    }

    public String getPlaceholderText() {
        return this.placeholder;
    }

    public void replacePlaceholder(String oldKey, String newKey) {
        this.placeholder = Placeholder.replacePlaceholder((String)this.placeholder, (String)oldKey, (String)(newKey == null ? oldKey : newKey));
    }

    public void resetContent() {
        this.content = null;
        this.contentChanged = false;
        this.imageFile = null;
        this.imageScale = 4.0;
        this.link = null;
    }

    public boolean setContent(String key, String value) {
        if (value == null) {
            value = "";
        }
        this.content = this.content == null ? this.placeholder.replace(key.toLowerCase(), value) : this.content.replace(key.toLowerCase(), value);
        boolean containsKey = this.placeholder.contains(key.toLowerCase());
        this.contentChanged = this.contentChanged || containsKey;
        return containsKey;
    }

    public void setContent(String newContent) {
        this.content = newContent;
        this.contentChanged = this.contentChanged || !this.placeholder.equals(newContent);
    }

    public boolean setContent(String key, File f) {
        if (f == null || !f.isFile()) {
            return false;
        }
        if (this.placeholder.contains(key.toLowerCase())) {
            this.imageFile = f;
            this.drawings = null;
            return true;
        }
        return false;
    }

    public boolean setContent(String key, File f, int width) {
        boolean result = this.setContent(key.toLowerCase(), f);
        if (result) {
            this.imageWidth = width;
        }
        return result;
    }

    public boolean setContent(String key, BufferedImage img) {
        if (img == null) {
            this.image = null;
            return false;
        }
        if (this.placeholder.contains(key.toLowerCase())) {
            this.image = img;
            return true;
        }
        return false;
    }

    public boolean setContent(String key, UploadItem item, ArrayList<SimpleGeometry> drawings, int width) {
        boolean result = this.setContent(key.toLowerCase(), item, drawings);
        if (result) {
            this.imageWidth = width;
        }
        return result;
    }

    public boolean setContent(String key, UploadItem item, ArrayList<SimpleGeometry> drawings) {
        return this.setContent(key, item, drawings, false);
    }

    public boolean setContent(String key, UploadItem item, ArrayList<SimpleGeometry> drawings, boolean retainRowHeight) {
        if (item == null) {
            return false;
        }
        if (this.placeholder.contains(key.toLowerCase())) {
            this.retainRowHeight = retainRowHeight;
            this.imageFile = item.getFile();
            this.drawings = drawings;
            return true;
        }
        return false;
    }

    public ArrayList<String> getPlaceholders() {
        return Placeholder.getPlaceholders((String)this.placeholder);
    }

    public void setHyperlink(Hyperlink link) {
        this.link = link;
    }

    public boolean hasContentChanged() {
        return this.contentChanged;
    }

    public void setImageScale(double imageScale) {
        this.imageScale = imageScale;
    }

    public int getSheet() {
        return this.sheet;
    }

    public String toString() {
        return "Sheet " + this.sheet + ", " + this.row + " / " + this.col + ": " + this.placeholder;
    }

    public String toCellAddress(Workbook wb) {
        return "'" + wb.getSheetName(this.sheet) + "'!" + CellReference.convertNumToColString((int)this.col) + (this.row + 1);
    }

    public String getContent() {
        return this.content == null ? "" : this.content;
    }

    private void removeUnusedPlaceholders() {
        while (this.content != null && this.content.contains("#!#")) {
            int firstIndex = this.content.indexOf("#!#");
            int lastIndex = this.content.indexOf("#!#", firstIndex + 1);
            if (lastIndex < 0) {
                lastIndex = firstIndex + 3;
            }
            if (lastIndex < this.content.length()) {
                this.content = this.content.substring(0, firstIndex) + this.content.substring(lastIndex + 3);
                continue;
            }
            this.content = this.content.substring(0, firstIndex);
        }
    }

    public void writeToCell(Workbook wb) {
        this.writeToCell(wb, 0);
    }

    public void writeToCell(Workbook wb, int row) {
        this.removeUnusedPlaceholders();
        if (this.headerfooter != null) {
            switch (this.side) {
                case 1: {
                    this.headerfooter.setLeft(this.getContent());
                    break;
                }
                case 3: {
                    this.headerfooter.setRight(this.getContent());
                    break;
                }
                case 2: {
                    this.headerfooter.setCenter(this.getContent());
                }
            }
            return;
        }
        this.getCell(wb, row);
        int calculatedSheetRow = this.getSheetRow(row);
        ThemisApplication.getInstance().getProject().getLogger().fine("Placeholder for item #" + row + " is written to row " + calculatedSheetRow);
        if (!this.mergedRegionSet && this.mergedRegion != null) {
            Sheet wbSheet = wb.getSheetAt(this.sheet);
            int rowDiff = calculatedSheetRow - this.mergedRegion.getFirstRow();
            if (rowDiff > 0) {
                wbSheet.addMergedRegion(new CellRangeAddress(this.mergedRegion.getFirstRow() + rowDiff, this.mergedRegion.getLastRow() + rowDiff, this.mergedRegion.getFirstColumn(), this.mergedRegion.getLastColumn()));
            }
        }
        if (this.rowheight > 0.0f) {
            Row row1 = wb.getSheetAt(this.sheet).getRow(calculatedSheetRow);
            row1.setHeightInPoints(this.rowheight);
        }
        if (this.imageFile != null) {
            this.writeToCell(wb, this.imageFile, row);
        } else if (this.image != null) {
            this.writeToCell(wb, this.image, row);
        } else if (this.link != null) {
            this.writeToCell(wb, this.link, this.getContent(), row);
        } else {
            this.writeToCell(wb, this.getContent(), row);
        }
    }

    public void clearCell(Workbook wb, int row) {
        this.writeToCell(wb, row);
    }

    public void writeToCell(Workbook wb, String value, int rowcount) {
        Cell cell = this.getCell(wb, rowcount);
        if (Util.isDouble((String)value)) {
            cell.setCellValue(Double.parseDouble(value));
        } else if (Util.isDate((String)value)) {
            cell.setCellValue(Util.parseDate((String)value, (TimeZone)TimeZone.getDefault()));
        } else {
            cell.setCellValue(value);
        }
    }

    private void writeToCell(Workbook wb, Hyperlink link, String value, int rowcount) {
        this.getCell(wb, rowcount).setHyperlink(link);
        this.getCell(wb, rowcount).setCellValue(value);
    }

    private void writeToCell(Workbook wb, File f, int rowcount) {
        if (!f.exists() || !f.isFile()) {
            ThemisLogger.logger.warning("Image file '" + f.getAbsolutePath() + "' does not exist!");
            return;
        }
        Cell cell = this.getCell(wb, rowcount);
        this.postPopulateFiles.put(cell, f);
        this.postPopulateDrawings.put(cell, this.drawings);
    }

    private void writeToCell(Workbook wb, BufferedImage bi, int rowcount) {
        Cell cell = this.getCell(wb, rowcount);
        this.postPopulate.put(cell, this.createBufferedImageForCell(cell, bi));
    }

    private BufferedImage createBufferedImageForCell(Cell cell, File f) {
        return this.createBufferedImageForCell(cell, f, false);
    }

    private BufferedImage createBufferedImageForCell(Cell cell, File f, boolean withTransparency) {
        try {
            return this.createBufferedImageForCell(cell, ImageHelper.loadImage((File)f), withTransparency);
        }
        catch (Exception ex) {
            ThemisApplication.getInstance().getProject().getLogger().severe("Bild kann nicht geladen werden: " + f.getName() + " (" + ex.getMessage() + ")");
            return null;
        }
    }

    private BufferedImage createBufferedImageForCell(Cell cell, BufferedImage bi) {
        return this.createBufferedImageForCell(cell, bi, false);
    }

    private BufferedImage createBufferedImageForCell(Cell cell, BufferedImage bi, boolean withTransparency) {
        int cellwidth = (int)((double)cell.getSheet().getColumnWidth(this.col) / 36.45);
        if (this.mergedRegion != null) {
            int deltacol = this.mergedRegion.getLastColumn() - this.mergedRegion.getFirstColumn();
            for (int ii = 1; ii <= deltacol; ++ii) {
                cellwidth = (int)((double)cellwidth + (double)cell.getSheet().getColumnWidth(this.col + ii) / 36.45);
            }
        }
        if (this.imageWidth > 0) {
            cellwidth = this.imageWidth;
        }
        int cellheight = (int)((double)this.rowheight * 1.3);
        float heightInPoints2 = cell.getRow().getHeightInPoints();
        short rowHeight = cell.getRow().getHeight();
        int scaledWidth = (int)((double)cellwidth * this.imageScale);
        int scaledHeight = (int)((double)cellheight * this.imageScale);
        BufferedImage img = Util.resizeImage((BufferedImage)bi, (int)scaledWidth, (int)scaledHeight, (int)(withTransparency ? 2 : 1));
        if (img == null) {
            return null;
        }
        List<SimpleGeometry> drawings = this.postPopulateDrawings.get(cell);
        if (drawings != null) {
            ImagePanel panel = new ImagePanel(ThemisApplication.getInstance().getProject().getLogger());
            panel.setBackgroundImage(img);
            if (bi.getWidth() != 0 && !drawings.isEmpty()) {
                double factor = (double)img.getWidth() / (double)bi.getWidth();
                for (SimpleGeometry geometry : drawings) {
                    for (int ii = 0; ii < geometry.size(); ++ii) {
                        Point p = (Point)geometry.getPoints().get(ii);
                    }
                    geometry.getDisplay().setLinewidth(8);
                    panel.addGeometry(geometry.scale(factor));
                }
            }
            return panel.getAsBufferedImage();
        }
        return img;
    }

    public Cell getCell(Workbook wb, int rowcount) {
        Cell cell;
        int sheetrow;
        Sheet wbSheet = wb.getSheetAt(this.sheet);
        Row row = wbSheet.getRow(sheetrow = this.getSheetRow(rowcount));
        if (row == null) {
            row = wbSheet.createRow(sheetrow);
        }
        if ((cell = row.getCell(this.col)) == null) {
            cell = row.createCell(this.col);
        }
        if (this.style != null) {
            cell.setCellStyle(this.style);
        }
        return cell;
    }

    public void setSheetRow(int r) {
        this.sheetRow = r;
    }

    public int getSheetRow(int r) {
        return this.sheetRow >= 0 ? this.sheetRow : this.headingRows + this.rowmin + this.rowdelta * r + (this.row - this.rowmin);
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public int getRelativeRow() {
        return this.row - this.rowmin;
    }

    public CellRangeAddress getMergedRegion() {
        return this.mergedRegion;
    }

    public void setRowData(int min, int max) {
        this.rowmin = min;
        this.rowmax = max;
        this.rowdelta = max - min + 1;
    }

    public void writePageBreak(int rowcount) {
        Sheet wbSheet = this.wb.getSheetAt(this.sheet);
        int sheetrow = this.getSheetRow(rowcount);
        wbSheet.setRowBreak(sheetrow);
    }

    public void resetPostPopulateTargets() {
        this.postPopulate.clear();
        this.postPopulateDrawings.clear();
        this.postPopulateFiles.clear();
    }

    public boolean hasPostPopulateTargets() {
        return !this.postPopulate.isEmpty() || !this.postPopulateFiles.isEmpty();
    }

    public int numPostPopulateTargets() {
        return this.postPopulate.size() + this.postPopulateFiles.size();
    }

    public void postPopulateImages() {
        this.postPopulateImages(null, -1, -1);
    }

    public void postPopulateImages(ProgressHandler progress, int start, int max) {
        BufferedImage img;
        progress = null;
        for (Cell cell : this.postPopulate.keySet()) {
            img = this.postPopulate.get(cell);
            this.postPopulateImage(cell, img);
            if (progress == null) continue;
            progress.progress(MessageFormat.format(ThemisApplication.getInstance().getProject().getResourceText("progress.inserting.images"), start++, max), start + 52 + (int)(44.0f * (float)start / (float)max));
        }
        for (Cell cell : this.postPopulateFiles.keySet()) {
            File file = this.postPopulateFiles.get(cell);
            boolean withTransparency = false;
            if (file != null && file.getName().toLowerCase().endsWith("png")) {
                withTransparency = true;
            }
            img = this.createBufferedImageForCell(cell, file, withTransparency);
            this.postPopulateImage(cell, img, withTransparency);
            if (progress == null) continue;
            progress.progress(MessageFormat.format(ThemisApplication.getInstance().getProject().getResourceText("progress.inserting.images"), start++, max), start + 52 + (int)(44.0f * (float)start / (float)max));
        }
    }

    private void postPopulateImage(Cell cell, BufferedImage img) {
        this.postPopulateImage(cell, img, false);
    }

    private void postPopulateImage(Cell cell, BufferedImage img, boolean withTransparency) {
        int rownum = cell.getRow().getRowNum();
        try {
            int height = img.getHeight();
            int spacing = 0;
            float heightInPoints = cell.getRow().getHeightInPoints();
            short rowheight = cell.getRow().getHeight();
            float requiredHeight = (float)(spacing + 1) + (float)height * 0.75f / (float)this.imageScale;
            if (!this.retainRowHeight && requiredHeight > heightInPoints) {
                cell.getRow().setHeightInPoints(requiredHeight);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, withTransparency ? "PNG" : "JPG", baos);
            baos.flush();
            int pictureIdx = this.wb.addPicture(baos.toByteArray(), withTransparency ? 6 : 5);
            baos.close();
            CreationHelper helper = this.wb.getCreationHelper();
            Drawing drawing = cell.getSheet().createDrawingPatriarch();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex());
            anchor.setRow1(cell.getRowIndex());
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
            Picture pict = drawing.createPicture(anchor, pictureIdx);
            Dimension dim = pict.getImageDimension();
            pict.resize();
            pict.resize(1.0 / this.imageScale);
            Dimension dim2 = pict.getImageDimension();
            boolean bl = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setHeadingRows(int rows) {
        this.headingRows = rows;
    }
}

