/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.report;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.config.ReportLayoutWizardIntervace;
import at.grid.themis.application.report.PageFormatPanel;
import at.grid.themis.application.report.layout.LayoutTableEditor2;
import at.grid.themis.application.ui.ConfigurationTopic;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.ui.WizardTopiCellRenderer;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.ThemisTextEditor2;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.AttributeSqlPair;
import at.grid.themis.ontology.report.PdfContent;
import at.grid.themis.ontology.report.PdfContentAnnualOverview;
import at.grid.themis.ontology.report.PdfContentContactList;
import at.grid.themis.ontology.report.PdfContentDocumentList;
import at.grid.themis.ontology.report.PdfContentEventList;
import at.grid.themis.ontology.report.PdfContentForm;
import at.grid.themis.ontology.report.PdfContentHeaderProject;
import at.grid.themis.ontology.report.PdfContentHeaderReport;
import at.grid.themis.ontology.report.PdfContentHeading1;
import at.grid.themis.ontology.report.PdfContentHeading2;
import at.grid.themis.ontology.report.PdfContentPagebreak;
import at.grid.themis.ontology.report.PdfContentParagraph;
import at.grid.themis.ontology.report.PdfContentPicture;
import at.grid.themis.ontology.report.PdfContentSignature;
import at.grid.themis.ontology.report.PdfContentStandardTable;
import at.grid.themis.ontology.report.PdfContentTable;
import at.grid.themis.ontology.report.PdfContentTitle;
import at.grid.themis.ontology.report.PdfContentTitlepage;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.scene.Node;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReportLayoutEditorPanel
extends ThemisPanel
implements ReportLayoutWizardIntervace {
    private final AttributeSqlPair[] sortOptions = new AttributeSqlPair[3];
    private AttributeSqlPair NONE_SORT = new AttributeSqlPair("-", null);
    private CmsReport rep = null;
    private PdfContent currentPdfContent;
    private boolean ignorePdfContentUpdate;
    ReportLayoutWizardIntervace wizard = null;
    private JButton bntSetSort1;
    private JButton btnAddTableLayout;
    private JButton btnAddTableLayout1;
    private JButton btnClose;
    private JButton btnCopyTableLayout;
    private JButton btnDeleteTableLayout;
    private JButton btnDeleteTableLayout1;
    private JButton btnEditTableLayout;
    private JButton btnEditTemplateFile;
    private JButton btnExport2;
    private JButton btnFormatExcel;
    private JButton btnFormatPDF;
    private JButton btnFormatWord;
    private JButton btnLoad;
    private JButton btnNext;
    private JButton btnPageFormat;
    private JButton btnPdfContentMoveDown;
    private JButton btnPdfContentMoveUp;
    private JButton btnPrevious;
    private JButton btnSave;
    private JButton btnSelectTemplate;
    private JButton btnSetSort2;
    private JButton btnSetSort3;
    private JButton btnShowEditor;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JPanel cardContent;
    private JPanel cardFormat;
    private JPanel cardPlan;
    private JCheckBox chkEventInfo;
    private JCheckBox chkExportDocuments;
    private JCheckBox chkExportPhoto;
    private JCheckBox chkExportPlan;
    private JCheckBox chkExportPlanEmpty;
    private JCheckBox chkLocationWithoutObservation;
    private JCheckBox chkProjectImage;
    private JCheckBox chkProjectInfo;
    private JCheckBox chkReportHead;
    private JCheckBox chkShowDateInPhoto;
    private JCheckBox chkSnippetWithLabel;
    private JCheckBox chkWithHistories;
    private JComboBox<String> fldExportPdfLayout;
    private JComboBox<String> fldExportPhotos;
    private JTextField fldHeading;
    private JComboBox fldHyperlink;
    private JTextField fldIconSize;
    private JComboBox fldInfoStamp;
    private JTextField fldInfoStampContent;
    private JTextField fldLayoutTitle;
    private JEditorPane fldParagraph;
    private JComboBox fldPdfCompression;
    private JComboBox<PdfContent> fldPdfContents;
    private JComboBox<CmsBasicElement> fldPdfFormulare;
    private JComboBox<ReportTableLayout> fldPdfLayoutTable;
    private JComboBox<CmsReport.ListPagebreak> fldPdfTablePagebreak;
    private JTextField fldPictureWidth;
    private JTextField fldSnippetSize;
    private JComboBox<AttributeSqlPair> fldSort;
    private JTextField fldTemplateFile;
    private JComboBox fldTransparency;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton9;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel4;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel52;
    private JLabel jLabel53;
    private JLabel jLabel54;
    private JLabel jLabel55;
    private JLabel jLabel56;
    private JLabel jLabel57;
    private JLabel jLabel59;
    private JLabel jLabel62;
    private JLabel jLabel63;
    private JLabel jLabel64;
    private JLabel jLabel65;
    private JLabel jLabel68;
    private JLabel jLabel7;
    private JLabel jLabel87;
    private JLabel jLabel88;
    private JLabel jLabel89;
    private JLabel jLabel90;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane10;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane7;
    private JLabel lblContentRemain;
    private JLabel lblEmpty;
    private JLabel lblEmpty1;
    private JLabel lblFormatRemain;
    private JLabel lblHyperlink;
    private JLabel lblPanelHeadingTitle;
    private JLabel lblPanelHeadingTitle1;
    private JLabel lblPanelHeadingTitle2;
    private JLabel lblPanelHeadingTitle3;
    private JLabel lblPanelHeadingTitle4;
    private JLabel lblPanelTablePagebreak;
    private JLabel lblPictureWidth;
    private JLabel lblPlanRemain;
    private JLabel lblSortOption1;
    private JLabel lblSortOption2;
    private JLabel lblSortOption3;
    private JList listTopic;
    private JList<PdfContent> lstPdfContent;
    private JList<AttributeSqlPair> lstSortOptions2;
    private JList<ReportTableLayout> lstTableLayout;
    private JPanel panelButtons;
    private JPanel panelButtons1;
    private JPanel panelContentDefinition1;
    private JPanel panelControlButtons;
    private JPanel panelEditPdfContent;
    private JPanel panelEditor;
    private JScrollPane panelEditorScroll;
    private JPanel panelFormatPdfContent;
    private JPanel panelFormatPdfType;
    private JPanel panelFormatTemplateFile;
    private JPanel panelPdfContent;
    private JPanel panelPdfForm;
    private JPanel panelPdfHeading;
    private JPanel panelPdfPageFormat;
    private JPanel panelPdfParagraph;
    private JPanel panelPdfPicture;
    private JPanel panelPdfTable;
    private JPanel panelPdfTitlepage;
    private JPanel panelReportTables;
    private JPanel panelSort;
    private JPanel panelTitel;
    private JRadioButton radPlanJpg;
    private JRadioButton radPlanMulbiplePdf;
    private JRadioButton radPlanSinglePdf;
    private JScrollPane scrollPane;
    private JSlider sliderIconSize;
    private JSlider sliderSnippetSize;
    public static String DIALOG_CODE = "reportwizard";
    public static final int DIALOG_WIDTH = 1170;
    public static final int DIALOG_HEIGHT = 770;

    public ReportLayoutEditorPanel(CmsReport r, ReportLayoutWizardIntervace wizard) {
        this.initComponents();
        this.rep = r == null ? new CmsReport() : r;
        this.wizard = wizard;
        this.setUIupdating(true);
        DefaultListModel topicModel = (DefaultListModel)this.listTopic.getModel();
        if (this.app.isUserAdministrator()) {
            topicModel.addElement(new ConfigurationTopic("PageFormat", "cardFormat", "  " + this.project.getResourceText("dialog.report.wizard.other")));
            topicModel.addElement(new ConfigurationTopic("PageContent", "cardContent", "  " + this.project.getResourceText("dialog.report.wizard.content")));
            topicModel.addElement(new ConfigurationTopic("PagePlan", "cardPlan", "  " + this.project.getResourceText("dialog.report.wizard.plan")));
        }
        this.listTopic.setSelectedIndex(0);
        for (PdfContent c : new PdfContent[]{new PdfContentTitlepage(), new PdfContentTitle(), new PdfContentPicture(), new PdfContentHeaderReport(), new PdfContentHeaderProject(), new PdfContentHeading1(), new PdfContentHeading2(), new PdfContentParagraph(), new PdfContentTable(), new PdfContentStandardTable(), new PdfContentAnnualOverview(), new PdfContentEventList(), new PdfContentContactList(), new PdfContentDocumentList(), new PdfContentForm(), new PdfContentPagebreak(), new PdfContentSignature()}) {
            this.fldPdfContents.addItem(c);
        }
        ((DefaultComboBoxModel)this.fldPdfTablePagebreak.getModel()).addElement(CmsReport.ListPagebreak.ZERO);
        ((DefaultComboBoxModel)this.fldPdfTablePagebreak.getModel()).addElement(CmsReport.ListPagebreak.ONE);
        ((DefaultComboBoxModel)this.fldPdfTablePagebreak.getModel()).addElement(CmsReport.ListPagebreak.TWO);
        ((DefaultComboBoxModel)this.fldPdfTablePagebreak.getModel()).addElement(CmsReport.ListPagebreak.THREE);
        THEMIS.setCheckboxIcon(this.chkWithHistories, this.chkSnippetWithLabel, this.chkExportPlan, this.chkExportPlanEmpty, this.chkLocationWithoutObservation, this.chkExportDocuments, this.chkExportPhoto, this.chkShowDateInPhoto);
        this.loadDropDownList((DefaultComboBoxModel)this.fldTransparency.getModel(), NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportWizard.dropDownTransparency.text"));
        this.loadDropDownList((DefaultComboBoxModel)this.fldInfoStamp.getModel(), NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportWizard.dropDownInfoStamp.text"));
        this.loadDropDownList((DefaultComboBoxModel)this.fldPdfCompression.getModel(), NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportWizard.dropDownPdfQuality.text"));
        this.loadDropDownList((DefaultComboBoxModel)this.fldExportPhotos.getModel(), NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportWizard.dropDownPhotos.text"));
        this.loadDropDownList((DefaultComboBoxModel)this.fldHyperlink.getModel(), NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportWizard.dropDownDocument.text"));
        this.loadSortOptions();
        this.sortOptions[0] = this.NONE_SORT;
        this.sortOptions[1] = this.NONE_SORT;
        this.sortOptions[2] = this.NONE_SORT;
        this.loadFormulare();
        this.listTopic.setCellRenderer(new WizardTopiCellRenderer());
        this.btnSave.setVisible(this.app.getLicense().isInternalLicense());
        this.fldInfoStampContent.setVisible(false);
        this.lblEmpty1.setVisible(false);
        this.fldHyperlink.setVisible(false);
        this.lblHyperlink.setVisible(false);
        this.btnShowEditor.setVisible(false);
        new DropTarget(this.fldTemplateFile, new ThemisDropTargetListener(false, false, new String[]{"xlsx", "xls", "xlsm", "doc", "docx"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ReportLayoutEditorPanel.this.setTemplateFile(f);
            }
        });
        new DropTarget(this.lstTableLayout, new ThemisDropTargetListener(false, false, new String[]{"layout"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ReportTableLayout.loadLayout((File)f);
                ReportLayoutEditorPanel.this.populateTableLayoutList();
            }
        });
        this.setUIupdating(false);
    }

    private void setContentTypeFormat(JButton button, boolean selected) {
        if (selected) {
            button.setBackground(THEMIS.lightblue);
            button.setForeground(THEMIS.red);
            button.setFont(THEMIS.fontLabelBold);
        } else {
            button.setBackground(THEMIS.lightgray);
            button.setForeground(THEMIS.black);
            button.setFont(THEMIS.fontButton);
        }
    }

    private void setFormat(CmsReport.ReportFormat f) {
        if (f == null) {
            f = CmsReport.ReportFormat.PDF_STANDARD;
        }
        this.rep.exportFormat = f;
        this.setContentTypeFormat(this.btnFormatExcel, false);
        this.setContentTypeFormat(this.btnFormatPDF, false);
        this.setContentTypeFormat(this.btnFormatWord, false);
        switch (f) {
            case PDF_STANDARD_OPEN: {
                this.fldExportPdfLayout.setSelectedIndex(1);
                break;
            }
            case PDF_EXTENDED: {
                this.fldExportPdfLayout.setSelectedIndex(2);
                break;
            }
            case PDF_FREE: {
                this.fldExportPdfLayout.setSelectedIndex(3);
                break;
            }
            case PDF_STANDARD: {
                this.fldExportPdfLayout.setSelectedIndex(0);
            }
        }
        block6 : switch (f) {
            case EXCEL: {
                this.setContentTypeFormat(this.btnFormatExcel, true);
                this.panelFormatTemplateFile.setVisible(true);
                this.panelPdfPageFormat.setVisible(false);
                this.panelFormatPdfContent.setVisible(false);
                this.panelFormatPdfType.setVisible(false);
                this.panelReportTables.setVisible(false);
                this.lblFormatRemain.setVisible(true);
                break;
            }
            case WORD: {
                this.setContentTypeFormat(this.btnFormatWord, true);
                this.panelFormatTemplateFile.setVisible(true);
                this.panelPdfPageFormat.setVisible(false);
                this.panelFormatPdfContent.setVisible(false);
                this.panelFormatPdfType.setVisible(false);
                this.panelReportTables.setVisible(true);
                this.lblFormatRemain.setVisible(true);
                break;
            }
            case PDF_STANDARD_OPEN: 
            case PDF_EXTENDED: 
            case PDF_FREE: 
            case PDF_STANDARD: {
                this.setContentTypeFormat(this.btnFormatPDF, true);
                this.panelFormatTemplateFile.setVisible(false);
                this.panelPdfPageFormat.setVisible(true);
                this.panelFormatPdfContent.setVisible(false);
                this.panelFormatPdfType.setVisible(true);
                this.panelReportTables.setVisible(false);
                this.lblFormatRemain.setVisible(true);
                switch (f) {
                    case PDF_FREE: {
                        this.panelFormatPdfContent.setVisible(true);
                        this.panelReportTables.setVisible(true);
                        this.lblFormatRemain.setVisible(false);
                        break block6;
                    }
                }
                this.lblFormatRemain.setVisible(true);
            }
        }
    }

    private void setPdfFormat(int idx) {
        switch (this.fldExportPdfLayout.getSelectedIndex()) {
            case 1: {
                this.setFormat(CmsReport.ReportFormat.PDF_STANDARD_OPEN);
                break;
            }
            case 2: {
                this.setFormat(CmsReport.ReportFormat.PDF_EXTENDED);
                break;
            }
            case 3: {
                this.setFormat(CmsReport.ReportFormat.PDF_FREE);
                break;
            }
            default: {
                this.setFormat(CmsReport.ReportFormat.PDF_STANDARD);
            }
        }
    }

    private void loadFormulare() {
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "form");
        s.setSort("el.title");
        ArrayList recs = s.search().getResultAsBasicElements();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.fldPdfFormulare.getModel();
        model.removeAllElements();
        for (CmsBasicElement be : recs) {
            model.addElement(be);
        }
    }

    private void loadSortOptions() {
        ArrayList pairs = AttributeSqlPair.getPairsWithSqlSort((ThemisApplication)this.app);
        for (AttributeSqlPair p : pairs) {
            if (p.getCode().equalsIgnoreCase("repeatcount") || p.getCode().equalsIgnoreCase("repeatsort")) continue;
            if ("locnumber".equals(p.getSql()) && this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed()) {
                p.setLabel("G.Nr+Pr\u00e4fix");
                AttributeSqlPair p2 = new AttributeSqlPair("G.Nr", "number");
                ((DefaultListModel)this.lstSortOptions2.getModel()).addElement(p2);
            }
            ((DefaultListModel)this.lstSortOptions2.getModel()).addElement(p);
        }
        boolean useLocationPrefix = this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useLocationSuffix = this.app.getSettings().getLocationAttribute("suffix").isUsed();
        String numberSort = (useLocationPrefix ? "ele.prenumber," : "") + "ele.number" + (useLocationSuffix ? ",ele.postnumber" : "");
        String observationSort = ",observation.number,observation.idelement";
        this.fldSort.addItem(new AttributeSqlPair("Geb\u00e4ude,Plan,Nummer", "building.title,plan.sort," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Geb\u00e4ude,Plan,Gegenstand", "building.title,plan.sort,ele.titel," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Nummer (Gegenstand und Beobachtung)", numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Termin,Nummer", "observation.duedate," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Gruppe,Gegenstand", "locationgroup,ele.titel," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Gegenstand", "ele.titel," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Kontakt,Nummer", "contact.name," + numberSort + observationSort));
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            this.fldSort.addItem(new AttributeSqlPair("<Spezielle Sortierung>", null));
        }
    }

    private void showSortOptions() {
        this.lblSortOption1.setText(this.sortOptions[0].toString());
        this.lblSortOption2.setText(this.sortOptions[1].toString());
        this.lblSortOption3.setText(this.sortOptions[2].toString());
    }

    private void setSort(int order, AttributeSqlPair option) {
        for (int ii = 0; ii < 3; ++ii) {
            if (ii == order) {
                if (option == null) {
                    option = this.NONE_SORT;
                }
                this.sortOptions[ii] = option;
                continue;
            }
            if (this.sortOptions[ii] != option) continue;
            this.sortOptions[ii] = this.NONE_SORT;
        }
    }

    private void setPlanOptionsEnabledOrDisabled() {
        boolean exportPlan = this.chkExportPlan.isSelected();
        this.radPlanJpg.setEnabled(exportPlan);
        this.radPlanSinglePdf.setEnabled(exportPlan);
        this.radPlanMulbiplePdf.setEnabled(exportPlan);
        this.chkExportPlanEmpty.setEnabled(exportPlan);
        this.fldInfoStamp.setEnabled(exportPlan);
        this.fldInfoStampContent.setEnabled(exportPlan);
        this.fldTransparency.setEnabled(exportPlan);
        this.fldPdfCompression.setEnabled(exportPlan);
    }

    private void loadDropDownList(DefaultComboBoxModel<String> model, String records) {
        String[] recordArray;
        for (String record : recordArray = records.split(",")) {
            model.addElement(record);
        }
    }

    private void setTemplateFile(File f) {
        try {
            if (f != null) {
                String nameTemplateFile = f.getName().toLowerCase();
                boolean filetypeOk = false;
                switch (this.rep.exportFormat) {
                    case EXCEL: {
                        filetypeOk = nameTemplateFile.endsWith(".xls") || nameTemplateFile.endsWith(".xlsx") || nameTemplateFile.endsWith(".xlsm");
                        break;
                    }
                    case WORD: {
                        boolean bl = filetypeOk = nameTemplateFile.endsWith(".doc") || nameTemplateFile.endsWith(".docx");
                    }
                }
                if (filetypeOk) {
                    this.rep.setTemplateFile(f);
                    this.fldTemplateFile.setText(nameTemplateFile);
                    this.rep.save();
                } else {
                    Dialogs.getInstance().showWarningDialog(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportWizard.validTemplateFile.text"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void populate(ProgressHandler ph) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        this.fldLayoutTitle.setText(this.rep.getLayoutName());
        this.setSortLabel(0, this.lblSortOption1, this.rep.sort1);
        this.setSortLabel(1, this.lblSortOption2, this.rep.sort2);
        this.setSortLabel(2, this.lblSortOption3, this.rep.sort3);
        DefaultComboBoxModel sortModel = (DefaultComboBoxModel)this.fldSort.getModel();
        int selIdx = 2;
        if (!this.rep.hasSort()) {
            selIdx = 2;
        } else if (this.rep.sort == null || "".equals(this.rep.sort)) {
            selIdx = sortModel.getSize() - 1;
        } else {
            for (int ii = 0; ii < sortModel.getSize(); ++ii) {
                AttributeSqlPair o = (AttributeSqlPair)sortModel.getElementAt(ii);
                if (!this.rep.sort.equals(o.getSql())) continue;
                selIdx = ii;
                break;
            }
        }
        this.fldSort.setSelectedIndex(selIdx);
        this.showSortOptions();
        File f = this.rep.getTemplateFile();
        this.fldTemplateFile.setText(f == null ? "" : this.rep.getTemplateFilename());
        ((DefaultListModel)this.lstPdfContent.getModel()).clear();
        for (PdfContent rtl : this.rep.templatePdfLayout) {
            ((DefaultListModel)this.lstPdfContent.getModel()).addElement(rtl);
        }
        this.chkWithHistories.setSelected(this.rep.exportWithHistories);
        this.chkLocationWithoutObservation.setSelected(this.rep.exportLocationsWithoutObservations);
        if (this.rep.exportImages != null) {
            switch (this.rep.exportImages) {
                case ALL: {
                    this.fldExportPhotos.setSelectedIndex(1);
                    break;
                }
                case EVENT: {
                    this.fldExportPhotos.setSelectedIndex(0);
                    break;
                }
                case LAST: {
                    this.fldExportPhotos.setSelectedIndex(2);
                    break;
                }
                default: {
                    this.fldExportPhotos.setSelectedIndex(1);
                }
            }
        }
        this.chkExportPlan.setSelected(this.rep.exportPlans);
        if (this.rep.exportPlanFormat != null) {
            switch (this.rep.exportPlanFormat) {
                case JPG: {
                    this.radPlanJpg.setSelected(true);
                    break;
                }
                case SINGLEPDF: {
                    this.radPlanSinglePdf.setSelected(true);
                    break;
                }
                case MULTIPLEPDF: {
                    this.radPlanMulbiplePdf.setSelected(true);
                }
            }
        }
        this.chkExportPlanEmpty.setSelected(this.rep.exportEmptyPlans);
        this.fldInfoStamp.setSelectedIndex(this.rep.planStampPosition);
        this.fldPdfCompression.setSelectedIndex(this.rep.pdfCompression);
        this.fldTransparency.setSelectedIndex(this.rep.planTransparency);
        this.setPlanOptionsEnabledOrDisabled();
        this.setSnippetSize(this.rep.planSnippetSizeMM);
        this.sliderIconSize.setValue(this.rep.planIconSize);
        this.chkSnippetWithLabel.setSelected(this.rep.planSnippetLabel);
        this.fldHyperlink.setSelectedIndex(this.rep.hyperlinkOnFile ? 0 : 1);
        this.chkExportDocuments.setSelected(this.rep.includeDocuments);
        this.chkExportPhoto.setSelected(this.rep.includeImages != CmsReport.ImageExport.NO);
        this.chkShowDateInPhoto.setSelected(this.rep.showDateInImage);
        this.populateTableLayoutList();
        this.setFormat(this.rep.exportFormat);
        this.revalidate();
    }

    public void populateTableLayoutList() {
        ((DefaultComboBoxModel)this.fldPdfLayoutTable.getModel()).removeAllElements();
        DefaultListModel modelLayout = (DefaultListModel)this.lstTableLayout.getModel();
        modelLayout.clear();
        for (ReportTableLayout rtl : this.project.getReportTableLayouts()) {
            int idx = -1;
            for (int ii = 0; ii < modelLayout.getSize(); ++ii) {
                if (!((ReportTableLayout)modelLayout.get(ii)).getName().equals(rtl.getName())) continue;
                idx = ii;
                break;
            }
            if (idx >= 0) {
                modelLayout.remove(idx);
                modelLayout.add(idx, rtl);
            } else {
                ((DefaultListModel)this.lstTableLayout.getModel()).addElement(rtl);
            }
            ((DefaultComboBoxModel)this.fldPdfLayoutTable.getModel()).addElement(rtl);
        }
        this.lstTableLayout.revalidate();
        this.lstTableLayout.repaint();
    }

    @Override
    public void populateReportLayoutList() {
        ReportTableLayout sel = (ReportTableLayout)this.fldPdfLayoutTable.getSelectedItem();
        ((DefaultComboBoxModel)this.fldPdfLayoutTable.getModel()).removeAllElements();
        for (int ii = 0; ii < this.lstTableLayout.getModel().getSize(); ++ii) {
            ReportTableLayout rtl = this.lstTableLayout.getModel().getElementAt(ii);
            ((DefaultComboBoxModel)this.fldPdfLayoutTable.getModel()).addElement(rtl);
        }
        this.fldPdfLayoutTable.setSelectedItem(sel);
    }

    private void setSortLabel(int idx, JLabel lbl, String sql) {
        if ("".equals(sql)) {
            sql = null;
        }
        DefaultListModel model = (DefaultListModel)this.lstSortOptions2.getModel();
        for (int ii = 0; ii < model.getSize(); ++ii) {
            if (!((AttributeSqlPair)model.get(ii)).equals(sql)) continue;
            this.sortOptions[idx] = (AttributeSqlPair)model.get(ii);
            lbl.setText(((AttributeSqlPair)model.get(ii)).toString());
            break;
        }
    }

    public boolean verifyBeforeApply() {
        File f = this.rep.getTemplateFile();
        String fn = f == null ? "" : f.getName().toLowerCase();
        boolean filetypeOk = true;
        switch (this.rep.exportFormat) {
            case EXCEL: {
                filetypeOk = fn.endsWith(".xls") || fn.endsWith(".xlsx") || fn.endsWith(".xlsm");
                break;
            }
            case WORD: {
                boolean bl = filetypeOk = fn.endsWith(".doc") || fn.endsWith(".docx");
            }
        }
        if (!filetypeOk) {
            Dialogs.getInstance().showErrorDialog(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportWizard.validTemplateFile.text"));
            return false;
        }
        return true;
    }

    @Override
    public void apply() {
        this.updateReport();
        this.rep.save();
        ArrayList tableIdsInDatabase = this.project.getReportTableLayoutIds();
        DefaultListModel modelTableLayout = (DefaultListModel)this.lstTableLayout.getModel();
        for (int ii = 0; ii < modelTableLayout.size(); ++ii) {
            ((ReportTableLayout)modelTableLayout.get(ii)).save();
            tableIdsInDatabase.remove(((ReportTableLayout)modelTableLayout.get(ii)).getId());
        }
        Iterator iterator = tableIdsInDatabase.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsElement.remove((CmsApplication)this.project, (long)id, (CmsUser)this.project.getUser());
        }
        if (this.wizard != null) {
            this.wizard.populateReportLayoutList();
        }
    }

    public void updateReport() {
        this.rep.setLayoutName(this.fldLayoutTitle.getText());
        AttributeSqlPair sort = (AttributeSqlPair)this.fldSort.getSelectedItem();
        if (sort == null) {
            this.rep.sort = null;
        } else if (sort.isNone()) {
            this.rep.sort = null;
            this.rep.sort1 = this.sortOptions[0].getSql();
            this.rep.sort2 = this.sortOptions[1].getSql();
            this.rep.sort3 = this.sortOptions[2].getSql();
        } else {
            this.rep.sort = this.getSort();
            this.rep.sort1 = null;
            this.rep.sort2 = null;
            this.rep.sort3 = null;
        }
        this.rep.templatePdfLayout.clear();
        DefaultListModel modelPdfContent = (DefaultListModel)this.lstPdfContent.getModel();
        for (int ii = 0; ii < modelPdfContent.size(); ++ii) {
            PdfContent pdfContent = (PdfContent)modelPdfContent.get(ii);
            this.rep.templatePdfLayout.add(pdfContent);
        }
        this.rep.exportWithHistories = this.chkWithHistories.isSelected();
        this.rep.exportLocationsWithoutObservations = this.chkLocationWithoutObservation.isSelected();
        switch (this.fldExportPhotos.getSelectedIndex()) {
            case 1: {
                this.rep.exportImages = CmsReport.ImageIntegration.ALL;
                break;
            }
            case 0: {
                this.rep.exportImages = CmsReport.ImageIntegration.EVENT;
                break;
            }
            case 2: {
                this.rep.exportImages = CmsReport.ImageIntegration.LAST;
                break;
            }
            default: {
                CmsReport.ImageIntegration imageIntegration = this.rep.exportImages = this.rep.event == null ? CmsReport.ImageIntegration.ALL : CmsReport.ImageIntegration.EVENT;
            }
        }
        if (this.rep.summaryReport) {
            this.rep.exportImages = CmsReport.ImageIntegration.ALL;
        }
        this.rep.exportPlans = this.chkExportPlan.isSelected();
        this.rep.exportPlanFormat = this.radPlanMulbiplePdf.isSelected() ? CmsReport.PlanFormat.MULTIPLEPDF : (this.radPlanJpg.isSelected() ? CmsReport.PlanFormat.JPG : CmsReport.PlanFormat.SINGLEPDF);
        this.rep.exportEmptyPlans = this.chkExportPlanEmpty.isSelected();
        this.rep.planStampPosition = this.fldInfoStamp.getSelectedIndex();
        this.rep.pdfCompression = this.fldPdfCompression.getSelectedIndex();
        this.rep.planTransparency = this.fldTransparency.getSelectedIndex();
        if (this.rep.summaryReport) {
            this.rep.exportPlans = false;
        }
        this.rep.planSnippetSizeMM = Util.parseInt((String)this.fldSnippetSize.getText(), (int)40);
        this.rep.planIconSize = Util.parseInt((String)this.fldIconSize.getText(), (int)10);
        this.rep.planSnippetLabel = this.chkSnippetWithLabel.isSelected();
        this.rep.hyperlinkOnFile = this.fldHyperlink.getSelectedIndex() == 0;
        this.rep.includeDocuments = this.chkExportDocuments.isSelected();
        this.rep.includeImages = this.chkExportPhoto.isSelected() ? CmsReport.ImageExport.NUMBER : CmsReport.ImageExport.NO;
        this.rep.showDateInImage = this.chkShowDateInPhoto.isSelected();
    }

    private void showWizardPage() {
        ConfigurationTopic topic = (ConfigurationTopic)this.listTopic.getSelectedValue();
        if (topic == null) {
            this.listTopic.setSelectedIndex(0);
            return;
        }
        if (!topic.isSelectable()) {
            int idx = this.listTopic.getSelectedIndex() + 1;
            if (idx > this.listTopic.getMaxSelectionIndex()) {
                idx = 0;
            }
            this.listTopic.setSelectedIndex(idx);
            return;
        }
        if (topic.isLazyLoading()) {
            topic.getPanel().populate();
            topic.setLazyLoading(false);
        }
        if (topic.hasPanel()) {
            this.panelEditorScroll.setViewportView(topic.getPanel());
        } else {
            this.panelEditorScroll.setViewportView(this.panelEditor);
            CardLayout cd = (CardLayout)this.panelEditor.getLayout();
            cd.show(this.panelEditor, topic.getPanelName());
        }
    }

    private void updateCurrentPdfContent() {
        if (this.currentPdfContent != null) {
            if (this.currentPdfContent instanceof PdfContentHeading1) {
                ((PdfContentParagraph)this.currentPdfContent).setText(this.fldHeading.getText());
            } else if (this.currentPdfContent instanceof PdfContentHeading2) {
                ((PdfContentParagraph)this.currentPdfContent).setText(this.fldHeading.getText());
            } else if (this.currentPdfContent instanceof PdfContentPicture) {
                ((PdfContentPicture)this.currentPdfContent).setWidth(this.fldPictureWidth.getText());
            } else if (this.currentPdfContent instanceof PdfContentParagraph) {
                ((PdfContentParagraph)this.currentPdfContent).setText(this.fldParagraph.getText());
            } else if (this.currentPdfContent instanceof PdfContentTitlepage) {
                ((PdfContentTitlepage)this.currentPdfContent).withProjectDetails = this.chkProjectInfo.isSelected();
                ((PdfContentTitlepage)this.currentPdfContent).withEventDetails = this.chkEventInfo.isSelected();
                ((PdfContentTitlepage)this.currentPdfContent).withImage = this.chkProjectImage.isSelected();
                ((PdfContentTitlepage)this.currentPdfContent).withReportHeader = this.chkReportHead.isSelected();
            } else if (this.currentPdfContent instanceof PdfContentTable) {
                ReportTableLayout selected = (ReportTableLayout)this.fldPdfLayoutTable.getSelectedItem();
                ((PdfContentTable)this.currentPdfContent).setLayoutName(selected != null ? selected.getName() : "");
                ((PdfContentTable)this.currentPdfContent).setPagebreak((CmsReport.ListPagebreak)this.fldPdfTablePagebreak.getSelectedItem());
            } else if (this.currentPdfContent instanceof PdfContentForm) {
                CmsBasicElement be = (CmsBasicElement)this.fldPdfFormulare.getSelectedItem();
                ((PdfContentForm)this.currentPdfContent).setForm(be == null ? -1L : be.getId());
            }
        }
    }

    private void addReportTableLayout(ReportTableLayout rtl) {
        ((DefaultListModel)this.lstTableLayout.getModel()).addElement(rtl);
        this.updateSettings();
    }

    private void editSelected() {
        ReportTableLayout rtl = this.lstTableLayout.getSelectedValue();
        if (rtl == null) {
            return;
        }
        ArrayList layoutNames = this.project.getReportTableNames();
        layoutNames.remove(rtl.getName());
        LayoutTableEditor2 panelTable = new LayoutTableEditor2(rtl);
        panelTable.setForbiddenNames(layoutNames);
        panelTable.showDialog();
        if (panelTable.doSave()) {
            rtl.save();
            this.lstTableLayout.repaint();
            this.updateSettings();
        }
    }

    private void saveLayout(List<ReportTableLayout> items) {
        if (this.lstTableLayout.getModel().getSize() == 0) {
            Dialogs.getInstance().showWarningDialog("warning.export-no-layouts");
            return;
        }
        File f = new ThemisFileDialog(this.project.getResourceText("dialog.save-report-layout"), ThemisFileDialog.DIALOGTYPE.SAVE, this.app.getPathTemplateLocationObservation(), null, THEMIS.getLayoutFilter(), "layout", false).getSelectedFile();
        if (f != null && !f.isDirectory()) {
            long idFilter;
            f = new File(f.getParentFile(), Util.getFileNameWithoutExtension((File)f) + ".layout");
            f.delete();
            Document doc = new Document();
            String xml = Util.toXml((Element)this.rep.getReportAsXml());
            String xml2 = items.get(0).getXmlAsString();
            ArrayList<Long> filterIds = new ArrayList<Long>();
            Element root = new Element("layout");
            Element tables = new Element("tables");
            root.addContent((Content)tables);
            for (ReportTableLayout reportTableLayout : items) {
                tables.addContent(reportTableLayout.getXml().detach());
                idFilter = reportTableLayout.getFilterId();
                if (filterIds.contains(idFilter)) continue;
                filterIds.add(idFilter);
            }
            Element filterElement = new Element("filters");
            Iterator iterator = filterIds.iterator();
            while (iterator.hasNext()) {
                idFilter = (Long)iterator.next();
                CmsElement filter = this.project.loadElement(idFilter, this.project.getUser());
                if (filter == null) continue;
                filterElement.addContent((Content)filter.toJDOMElement());
            }
            if (!filterIds.isEmpty()) {
                root.addContent((Content)filterElement);
            }
            doc.addContent((Content)root);
            OutputStreamWriter outputStreamWriter = null;
            try {
                OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
                XMLOutputter output = new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8").setTextMode(Format.TextMode.PRESERVE));
                output.output(doc, (Writer)outputStreamWriter2);
                outputStreamWriter2.close();
                THEMIS.notify(1, this.project.getResourceText("notify.export-layout-saved-title"), this.project.getResourceText("notify.export-layout-saved-text"));
            }
            catch (IOException ex) {
                Dialogs.getInstance().showErrorDialog(this.project.getResourceText("error.image-file-write") + ": " + ex.getMessage());
                Exceptions.printStackTrace((Throwable)ex);
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (IOException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
            if (f.isFile()) {
                THEMIS.showFileResultDialog(f, false);
            }
        }
    }

    private void updateSettings() {
        DefaultListModel model = (DefaultListModel)this.lstTableLayout.getModel();
        for (int ii = 0; ii < model.size(); ++ii) {
            ((ReportTableLayout)model.elementAt(ii)).save();
        }
    }

    private ReportTableLayout getTableLayoutByName(String n) {
        for (int ii = 0; ii < this.lstTableLayout.getModel().getSize(); ++ii) {
            ReportTableLayout rtl = this.lstTableLayout.getModel().getElementAt(ii);
            if (n == null || !n.equals(rtl.getName())) continue;
            return rtl;
        }
        return null;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.panelPdfParagraph = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldParagraph = new JEditorPane();
        this.btnShowEditor = new JButton();
        this.panelPdfHeading = new JPanel();
        this.lblPanelHeadingTitle = new JLabel();
        this.fldHeading = new JTextField();
        this.jLabel27 = new JLabel();
        this.panelPdfTitlepage = new JPanel();
        this.jLabel25 = new JLabel();
        this.chkReportHead = new JCheckBox();
        this.chkProjectInfo = new JCheckBox();
        this.chkEventInfo = new JCheckBox();
        this.chkProjectImage = new JCheckBox();
        this.jLabel51 = new JLabel();
        this.panelPdfTable = new JPanel();
        this.lblPanelHeadingTitle1 = new JLabel();
        this.lblPanelHeadingTitle2 = new JLabel();
        this.fldPdfLayoutTable = new JComboBox();
        this.lblPanelTablePagebreak = new JLabel();
        this.fldPdfTablePagebreak = new JComboBox();
        this.jLabel50 = new JLabel();
        this.panelPdfPicture = new JPanel();
        this.lblPictureWidth = new JLabel();
        this.fldPictureWidth = new JTextField();
        this.jLabel62 = new JLabel();
        this.panelPdfForm = new JPanel();
        this.lblPanelHeadingTitle3 = new JLabel();
        this.lblPanelHeadingTitle4 = new JLabel();
        this.fldPdfFormulare = new JComboBox();
        this.jLabel59 = new JLabel();
        this.panelTitel = new JPanel();
        this.jLabel21 = new JLabel();
        this.fldLayoutTitle = new JTextField();
        this.jScrollPane3 = new JScrollPane();
        this.listTopic = new JList();
        this.panelEditorScroll = new JScrollPane();
        this.panelEditor = new JPanel();
        this.cardFormat = new JPanel();
        this.jLabel36 = new JLabel();
        this.panelContentDefinition1 = new JPanel();
        this.btnFormatExcel = new JButton();
        this.btnFormatWord = new JButton();
        this.btnFormatPDF = new JButton();
        this.jLabel13 = new JLabel();
        this.panelFormatPdfType = new JPanel();
        this.jLabel14 = new JLabel();
        this.fldExportPdfLayout = new JComboBox();
        this.panelFormatTemplateFile = new JPanel();
        this.jLabel7 = new JLabel();
        this.fldTemplateFile = new JTextField();
        this.btnSelectTemplate = new JButton();
        this.btnEditTemplateFile = new JButton();
        this.panelPdfPageFormat = new JPanel();
        this.jLabel63 = new JLabel();
        this.btnPageFormat = new JButton();
        this.panelReportTables = new JPanel();
        this.jLabel65 = new JLabel();
        this.scrollPane = new JScrollPane();
        this.lstTableLayout = new JList();
        this.jLabel87 = new JLabel();
        this.panelControlButtons = new JPanel();
        this.btnAddTableLayout = new JButton();
        this.btnEditTableLayout = new JButton();
        this.btnCopyTableLayout = new JButton();
        this.btnDeleteTableLayout = new JButton();
        this.btnLoad = new JButton();
        this.btnSave = new JButton();
        this.panelFormatPdfContent = new JPanel();
        this.jLabel45 = new JLabel();
        this.jPanel6 = new JPanel();
        this.fldPdfContents = new JComboBox();
        this.btnAddTableLayout1 = new JButton();
        this.jLabel46 = new JLabel();
        this.jScrollPane10 = new JScrollPane();
        this.lstPdfContent = new JList();
        this.panelPdfContent = new JPanel();
        this.btnPdfContentMoveUp = new JButton();
        this.btnPdfContentMoveDown = new JButton();
        this.btnDeleteTableLayout1 = new JButton();
        this.panelEditPdfContent = new JPanel();
        this.lblFormatRemain = new JLabel();
        this.cardContent = new JPanel();
        this.jLabel38 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel32 = new JLabel();
        this.jLabel88 = new JLabel();
        this.chkLocationWithoutObservation = new JCheckBox();
        this.jLabel35 = new JLabel();
        this.jLabel89 = new JLabel();
        this.chkWithHistories = new JCheckBox();
        this.jLabel37 = new JLabel();
        this.jLabel68 = new JLabel();
        this.jLabel90 = new JLabel();
        this.fldSort = new JComboBox();
        this.panelSort = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.lstSortOptions2 = new JList();
        this.bntSetSort1 = new JButton();
        this.btnSetSort2 = new JButton();
        this.btnSetSort3 = new JButton();
        this.lblSortOption1 = new JLabel();
        this.lblSortOption2 = new JLabel();
        this.lblSortOption3 = new JLabel();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jButton11 = new JButton();
        this.jLabel41 = new JLabel();
        this.jLabel42 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel30 = new JLabel();
        this.fldExportPhotos = new JComboBox();
        this.jLabel31 = new JLabel();
        this.chkExportPhoto = new JCheckBox();
        this.jLabel64 = new JLabel();
        this.chkShowDateInPhoto = new JCheckBox();
        this.jLabel24 = new JLabel();
        this.jLabel26 = new JLabel();
        this.chkExportDocuments = new JCheckBox();
        this.lblHyperlink = new JLabel();
        this.fldHyperlink = new JComboBox();
        this.lblContentRemain = new JLabel();
        this.cardPlan = new JPanel();
        this.jLabel17 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel53 = new JLabel();
        this.chkExportPlan = new JCheckBox();
        this.lblEmpty = new JLabel();
        this.radPlanSinglePdf = new JRadioButton();
        this.radPlanMulbiplePdf = new JRadioButton();
        this.radPlanJpg = new JRadioButton();
        this.jLabel54 = new JLabel();
        this.jLabel56 = new JLabel();
        this.chkExportPlanEmpty = new JCheckBox();
        this.jLabel18 = new JLabel();
        this.fldInfoStamp = new JComboBox();
        this.lblEmpty1 = new JLabel();
        this.fldInfoStampContent = new JTextField();
        this.jLabel11 = new JLabel();
        this.fldTransparency = new JComboBox();
        this.fldPdfCompression = new JComboBox();
        this.jLabel20 = new JLabel();
        this.jLabel55 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jPanel1 = new JPanel();
        this.sliderSnippetSize = new JSlider();
        this.fldSnippetSize = new JTextField();
        this.jLabel48 = new JLabel();
        this.jLabel57 = new JLabel();
        this.chkSnippetWithLabel = new JCheckBox();
        this.jLabel49 = new JLabel();
        this.jPanel2 = new JPanel();
        this.sliderIconSize = new JSlider();
        this.fldIconSize = new JTextField();
        this.jLabel52 = new JLabel();
        this.lblPlanRemain = new JLabel();
        this.panelButtons1 = new JPanel();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.panelButtons = new JPanel();
        this.btnExport2 = new JButton();
        this.btnClose = new JButton();
        this.panelPdfParagraph.setLayout(new GridBagLayout());
        this.jLabel4.setFont(THEMIS.fontLabelBold);
        this.jLabel4.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel4.text_1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfParagraph.add((Component)this.jLabel4, gridBagConstraints);
        this.fldParagraph.setBorder(null);
        this.fldParagraph.setContentType("text/txt");
        this.jScrollPane1.setViewportView(this.fldParagraph);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfParagraph.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnShowEditor.setFont(THEMIS.fontButton);
        this.btnShowEditor.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit-24.gif")));
        this.btnShowEditor.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnShowEditor.text"));
        this.btnShowEditor.setBorder(new SoftBevelBorder(0));
        this.btnShowEditor.setMinimumSize(null);
        this.btnShowEditor.setPreferredSize(null);
        this.btnShowEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnShowEditorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelPdfParagraph.add((Component)this.btnShowEditor, gridBagConstraints);
        this.panelPdfHeading.setLayout(new GridBagLayout());
        this.lblPanelHeadingTitle.setFont(THEMIS.fontLabelBold);
        this.lblPanelHeadingTitle.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblPanelHeadingTitle.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfHeading.add((Component)this.lblPanelHeadingTitle, gridBagConstraints);
        this.fldHeading.setFont(THEMIS.fontTextfield);
        this.fldHeading.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.fldHeading.text_1"));
        this.fldHeading.setPreferredSize(new Dimension(60, 30));
        this.fldHeading.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReportLayoutEditorPanel.this.fldHeadingFocusLost(evt);
            }
        });
        this.fldHeading.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.fldHeadingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfHeading.add((Component)this.fldHeading, gridBagConstraints);
        this.jLabel27.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel27.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.panelPdfHeading.add((Component)this.jLabel27, gridBagConstraints);
        this.panelPdfTitlepage.setLayout(new GridBagLayout());
        this.jLabel25.setFont(THEMIS.fontLabelBold);
        this.jLabel25.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel25.text_1_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfTitlepage.add((Component)this.jLabel25, gridBagConstraints);
        this.chkReportHead.setFont(THEMIS.fontLabel);
        this.chkReportHead.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkReportHead.text_1"));
        this.chkReportHead.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportLayoutEditorPanel.this.chkReportHeadItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfTitlepage.add((Component)this.chkReportHead, gridBagConstraints);
        this.chkProjectInfo.setFont(THEMIS.fontLabel);
        this.chkProjectInfo.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkProjectInfo.text_1"));
        this.chkProjectInfo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportLayoutEditorPanel.this.chkProjectInfoItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfTitlepage.add((Component)this.chkProjectInfo, gridBagConstraints);
        this.chkEventInfo.setFont(THEMIS.fontLabel);
        this.chkEventInfo.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkEventInfo.text_1"));
        this.chkEventInfo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportLayoutEditorPanel.this.chkEventInfoItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfTitlepage.add((Component)this.chkEventInfo, gridBagConstraints);
        this.chkProjectImage.setFont(THEMIS.fontLabel);
        this.chkProjectImage.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkProjectImage.text_1"));
        this.chkProjectImage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportLayoutEditorPanel.this.chkProjectImageItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfTitlepage.add((Component)this.chkProjectImage, gridBagConstraints);
        this.jLabel51.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel51.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panelPdfTitlepage.add((Component)this.jLabel51, gridBagConstraints);
        this.panelPdfTable.setLayout(new GridBagLayout());
        this.lblPanelHeadingTitle1.setFont(THEMIS.fontLabelBold);
        this.lblPanelHeadingTitle1.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblPanelHeadingTitle1.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfTable.add((Component)this.lblPanelHeadingTitle1, gridBagConstraints);
        this.lblPanelHeadingTitle2.setFont(THEMIS.fontLabel);
        this.lblPanelHeadingTitle2.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblPanelHeadingTitle2.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfTable.add((Component)this.lblPanelHeadingTitle2, gridBagConstraints);
        this.fldPdfLayoutTable.setFont(THEMIS.fontList);
        this.fldPdfLayoutTable.setModel(new DefaultComboBoxModel());
        this.fldPdfLayoutTable.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfTable.add(this.fldPdfLayoutTable, gridBagConstraints);
        this.lblPanelTablePagebreak.setFont(THEMIS.fontLabel);
        this.lblPanelTablePagebreak.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblPanelTablePagebreak.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfTable.add((Component)this.lblPanelTablePagebreak, gridBagConstraints);
        this.fldPdfTablePagebreak.setFont(THEMIS.fontList);
        this.fldPdfTablePagebreak.setModel(new DefaultComboBoxModel());
        this.fldPdfTablePagebreak.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfTable.add(this.fldPdfTablePagebreak, gridBagConstraints);
        this.jLabel50.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel50.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panelPdfTable.add((Component)this.jLabel50, gridBagConstraints);
        this.panelPdfPicture.setLayout(new GridBagLayout());
        this.lblPictureWidth.setFont(THEMIS.fontLabelBold);
        this.lblPictureWidth.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblPictureWidth.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfPicture.add((Component)this.lblPictureWidth, gridBagConstraints);
        this.fldPictureWidth.setFont(THEMIS.fontTextfield);
        this.fldPictureWidth.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.fldPictureWidth.text_1"));
        this.fldPictureWidth.setPreferredSize(new Dimension(60, 30));
        this.fldPictureWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReportLayoutEditorPanel.this.fldPictureWidthFocusLost(evt);
            }
        });
        this.fldPictureWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.fldPictureWidthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfPicture.add((Component)this.fldPictureWidth, gridBagConstraints);
        this.jLabel62.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel62.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.panelPdfPicture.add((Component)this.jLabel62, gridBagConstraints);
        this.panelPdfForm.setLayout(new GridBagLayout());
        this.lblPanelHeadingTitle3.setFont(THEMIS.fontLabelBold);
        this.lblPanelHeadingTitle3.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblPanelHeadingTitle3.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfForm.add((Component)this.lblPanelHeadingTitle3, gridBagConstraints);
        this.lblPanelHeadingTitle4.setFont(THEMIS.fontLabel);
        this.lblPanelHeadingTitle4.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblPanelHeadingTitle4.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfForm.add((Component)this.lblPanelHeadingTitle4, gridBagConstraints);
        this.fldPdfFormulare.setFont(THEMIS.fontList);
        this.fldPdfFormulare.setModel(new DefaultComboBoxModel());
        this.fldPdfFormulare.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfForm.add(this.fldPdfFormulare, gridBagConstraints);
        this.jLabel59.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel59.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panelPdfForm.add((Component)this.jLabel59, gridBagConstraints);
        this.setMinimumSize(new Dimension(900, 600));
        this.setPreferredSize(new Dimension(900, 600));
        this.setLayout(new GridBagLayout());
        this.panelTitel.setBackground(new Color(204, 204, 204));
        this.panelTitel.setLayout(new GridBagLayout());
        this.jLabel21.setFont(THEMIS.fontLabelBigBold);
        this.jLabel21.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel21.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.panelTitel.add((Component)this.jLabel21, gridBagConstraints);
        this.fldLayoutTitle.setFont(THEMIS.fontLabelBig);
        this.fldLayoutTitle.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.fldLayoutTitle.text"));
        this.fldLayoutTitle.setMinimumSize(null);
        this.fldLayoutTitle.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.panelTitel.add((Component)this.fldLayoutTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.panelTitel, gridBagConstraints);
        this.jScrollPane3.setHorizontalScrollBar(null);
        this.jScrollPane3.setMaximumSize(null);
        this.jScrollPane3.setMinimumSize(new Dimension(250, 150));
        this.jScrollPane3.setPreferredSize(new Dimension(250, 150));
        this.listTopic.setFont(THEMIS.fontList);
        this.listTopic.setModel(new DefaultListModel());
        this.listTopic.setSelectionMode(0);
        this.listTopic.setPreferredSize(new Dimension(250, 150));
        this.listTopic.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ReportLayoutEditorPanel.this.listTopicKeyReleased(evt);
            }
        });
        this.listTopic.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ReportLayoutEditorPanel.this.listTopicValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.listTopic);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jScrollPane3, gridBagConstraints);
        this.panelEditorScroll.setMinimumSize(null);
        this.panelEditor.setRequestFocusEnabled(false);
        this.panelEditor.setLayout(new CardLayout());
        this.cardFormat.setLayout(new GridBagLayout());
        this.jLabel36.setFont(THEMIS.fontHeading);
        this.jLabel36.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel36.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.cardFormat.add((Component)this.jLabel36, gridBagConstraints);
        this.panelContentDefinition1.setLayout(new GridBagLayout());
        this.btnFormatExcel.setFont(THEMIS.fontButton);
        this.btnFormatExcel.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnFormatExcel.text_1"));
        this.btnFormatExcel.setBorder(new SoftBevelBorder(0));
        this.btnFormatExcel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnFormatExcelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContentDefinition1.add((Component)this.btnFormatExcel, gridBagConstraints);
        this.btnFormatWord.setFont(THEMIS.fontButton);
        this.btnFormatWord.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnFormatWord.text_1"));
        this.btnFormatWord.setBorder(new SoftBevelBorder(0));
        this.btnFormatWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnFormatWordActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContentDefinition1.add((Component)this.btnFormatWord, gridBagConstraints);
        this.btnFormatPDF.setFont(THEMIS.fontButton);
        this.btnFormatPDF.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnFormatPDF.text_1"));
        this.btnFormatPDF.setBorder(new SoftBevelBorder(0));
        this.btnFormatPDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnFormatPDFActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContentDefinition1.add((Component)this.btnFormatPDF, gridBagConstraints);
        this.jLabel13.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel13.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContentDefinition1.add((Component)this.jLabel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.cardFormat.add((Component)this.panelContentDefinition1, gridBagConstraints);
        this.panelFormatPdfType.setName("");
        this.panelFormatPdfType.setLayout(new GridBagLayout());
        this.jLabel14.setFont(THEMIS.fontLabel);
        this.jLabel14.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel14.text"));
        this.jLabel14.setMinimumSize(new Dimension(110, 20));
        this.jLabel14.setPreferredSize(new Dimension(110, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFormatPdfType.add((Component)this.jLabel14, gridBagConstraints);
        this.fldExportPdfLayout.setFont(THEMIS.fontList);
        this.fldExportPdfLayout.setModel(new DefaultComboBoxModel<String>(new String[]{"Standard-Tabelle", "Standard-Tabelle + offen", "Gesamtdokument", "Freies Layout"}));
        this.fldExportPdfLayout.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportLayoutEditorPanel.this.fldExportPdfLayoutItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panelFormatPdfType.add(this.fldExportPdfLayout, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.cardFormat.add((Component)this.panelFormatPdfType, gridBagConstraints);
        this.panelFormatTemplateFile.setLayout(new GridBagLayout());
        this.jLabel7.setFont(THEMIS.fontLabel);
        this.jLabel7.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel7.text_1"));
        this.jLabel7.setPreferredSize(new Dimension(110, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFormatTemplateFile.add((Component)this.jLabel7, gridBagConstraints);
        this.fldTemplateFile.setEditable(false);
        this.fldTemplateFile.setFont(THEMIS.fontTextfield);
        this.fldTemplateFile.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.fldTemplateFile.text"));
        this.fldTemplateFile.setMinimumSize(new Dimension(100, 30));
        this.fldTemplateFile.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFormatTemplateFile.add((Component)this.fldTemplateFile, gridBagConstraints);
        this.btnSelectTemplate.setFont(THEMIS.fontButton);
        this.btnSelectTemplate.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/openFile_24.gif")));
        this.btnSelectTemplate.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnSelectTemplate.text_1"));
        this.btnSelectTemplate.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnSelectTemplate.toolTipText"));
        this.btnSelectTemplate.setBorder(new SoftBevelBorder(0));
        this.btnSelectTemplate.setMinimumSize(new Dimension(50, 30));
        this.btnSelectTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnSelectTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panelFormatTemplateFile.add((Component)this.btnSelectTemplate, gridBagConstraints);
        this.btnEditTemplateFile.setFont(THEMIS.fontButton);
        this.btnEditTemplateFile.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit-24.gif")));
        this.btnEditTemplateFile.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnEditTemplateFile.text"));
        this.btnEditTemplateFile.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnEditTemplateFile.toolTipText"));
        this.btnEditTemplateFile.setBorder(new SoftBevelBorder(0));
        this.btnEditTemplateFile.setMaximumSize(new Dimension(100, 40));
        this.btnEditTemplateFile.setMinimumSize(new Dimension(60, 35));
        this.btnEditTemplateFile.setPreferredSize(new Dimension(60, 35));
        this.btnEditTemplateFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnEditTemplateFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFormatTemplateFile.add((Component)this.btnEditTemplateFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.cardFormat.add((Component)this.panelFormatTemplateFile, gridBagConstraints);
        this.panelPdfPageFormat.setLayout(new GridBagLayout());
        this.jLabel63.setFont(THEMIS.fontLabel);
        this.jLabel63.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel63.text"));
        this.jLabel63.setMinimumSize(new Dimension(110, 30));
        this.jLabel63.setPreferredSize(new Dimension(110, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfPageFormat.add((Component)this.jLabel63, gridBagConstraints);
        this.btnPageFormat.setFont(THEMIS.fontButton);
        this.btnPageFormat.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnPageFormat.text_1"));
        this.btnPageFormat.setBorder(new SoftBevelBorder(0));
        this.btnPageFormat.setMaximumSize(null);
        this.btnPageFormat.setMinimumSize(null);
        this.btnPageFormat.setPreferredSize(null);
        this.btnPageFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnPageFormatActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfPageFormat.add((Component)this.btnPageFormat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.cardFormat.add((Component)this.panelPdfPageFormat, gridBagConstraints);
        this.panelReportTables.setLayout(new GridBagLayout());
        this.jLabel65.setFont(THEMIS.fontLabel);
        this.jLabel65.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel65.text"));
        this.jLabel65.setMinimumSize(new Dimension(110, 30));
        this.jLabel65.setPreferredSize(new Dimension(110, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelReportTables.add((Component)this.jLabel65, gridBagConstraints);
        this.scrollPane.setMinimumSize(null);
        this.lstTableLayout.setFont(THEMIS.fontList);
        this.lstTableLayout.setModel(new DefaultListModel());
        this.lstTableLayout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ReportLayoutEditorPanel.this.lstTableLayoutMouseClicked(evt);
            }
        });
        this.scrollPane.setViewportView(this.lstTableLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelReportTables.add((Component)this.scrollPane, gridBagConstraints);
        this.jLabel87.setFont(THEMIS.fontLabel);
        this.jLabel87.setForeground(new Color(102, 102, 102));
        this.jLabel87.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel87.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelReportTables.add((Component)this.jLabel87, gridBagConstraints);
        this.panelControlButtons.setLayout(new GridBagLayout());
        this.btnAddTableLayout.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        this.btnAddTableLayout.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnAddTableLayout.text_1"));
        this.btnAddTableLayout.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnAddTableLayout.toolTipText"));
        this.btnAddTableLayout.setBorder(new SoftBevelBorder(0));
        this.btnAddTableLayout.setMargin(null);
        this.btnAddTableLayout.setMaximumSize(null);
        this.btnAddTableLayout.setMinimumSize(null);
        this.btnAddTableLayout.setPreferredSize(null);
        this.btnAddTableLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnAddTableLayoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnAddTableLayout, gridBagConstraints);
        this.btnEditTableLayout.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit-24.gif")));
        this.btnEditTableLayout.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnEditTableLayout.text_1"));
        this.btnEditTableLayout.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnEditTableLayout.toolTipText"));
        this.btnEditTableLayout.setBorder(new SoftBevelBorder(0));
        this.btnEditTableLayout.setMaximumSize(null);
        this.btnEditTableLayout.setMinimumSize(null);
        this.btnEditTableLayout.setPreferredSize(null);
        this.btnEditTableLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnEditTableLayoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnEditTableLayout, gridBagConstraints);
        this.btnCopyTableLayout.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        this.btnCopyTableLayout.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnCopyTableLayout.text"));
        this.btnCopyTableLayout.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnCopyTableLayout.toolTipText"));
        this.btnCopyTableLayout.setBorder(new SoftBevelBorder(0));
        this.btnCopyTableLayout.setMaximumSize(null);
        this.btnCopyTableLayout.setMinimumSize(null);
        this.btnCopyTableLayout.setPreferredSize(null);
        this.btnCopyTableLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnCopyTableLayoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnCopyTableLayout, gridBagConstraints);
        this.btnDeleteTableLayout.setFont(THEMIS.fontButton);
        this.btnDeleteTableLayout.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        this.btnDeleteTableLayout.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnDeleteTableLayout.text_1"));
        this.btnDeleteTableLayout.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnDeleteTableLayout.toolTipText"));
        this.btnDeleteTableLayout.setBorder(new SoftBevelBorder(0));
        this.btnDeleteTableLayout.setMaximumSize(null);
        this.btnDeleteTableLayout.setMinimumSize(null);
        this.btnDeleteTableLayout.setPreferredSize(null);
        this.btnDeleteTableLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnDeleteTableLayoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnDeleteTableLayout, gridBagConstraints);
        this.btnLoad.setFont(THEMIS.fontButton);
        this.btnLoad.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/openFile_24.gif")));
        this.btnLoad.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnLoad.text"));
        this.btnLoad.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnLoad.toolTipText"));
        this.btnLoad.setBorder(new SoftBevelBorder(0));
        this.btnLoad.setMaximumSize(null);
        this.btnLoad.setMinimumSize(null);
        this.btnLoad.setPreferredSize(null);
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnLoadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnLoad, gridBagConstraints);
        this.btnSave.setFont(THEMIS.fontButton);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/saveProtocol24.gif")));
        this.btnSave.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnSave.text_1"));
        this.btnSave.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnSave.toolTipText"));
        this.btnSave.setBorder(new SoftBevelBorder(0));
        this.btnSave.setMaximumSize(null);
        this.btnSave.setMinimumSize(null);
        this.btnSave.setPreferredSize(null);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnSave, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.panelReportTables.add((Component)this.panelControlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.cardFormat.add((Component)this.panelReportTables, gridBagConstraints);
        this.panelFormatPdfContent.setLayout(new GridBagLayout());
        this.jLabel45.setFont(THEMIS.fontLabel);
        this.jLabel45.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel45.text_1"));
        this.jLabel45.setVerticalAlignment(1);
        this.jLabel45.setMaximumSize(null);
        this.jLabel45.setMinimumSize(new Dimension(110, 30));
        this.jLabel45.setPreferredSize(new Dimension(110, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFormatPdfContent.add((Component)this.jLabel45, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.fldPdfContents.setFont(THEMIS.fontList);
        this.fldPdfContents.setModel(new DefaultComboBoxModel());
        this.fldPdfContents.setMaximumSize(null);
        this.fldPdfContents.setMinimumSize(null);
        this.fldPdfContents.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add(this.fldPdfContents, gridBagConstraints);
        this.btnAddTableLayout1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add24.gif")));
        this.btnAddTableLayout1.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnAddTableLayout1.text_1"));
        this.btnAddTableLayout1.setMaximumSize(null);
        this.btnAddTableLayout1.setMinimumSize(null);
        this.btnAddTableLayout1.setPreferredSize(null);
        this.btnAddTableLayout1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnAddTableLayout1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnAddTableLayout1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.panelFormatPdfContent.add((Component)this.jPanel6, gridBagConstraints);
        this.jLabel46.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel46.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.panelFormatPdfContent.add((Component)this.jLabel46, gridBagConstraints);
        this.jScrollPane10.setMaximumSize(null);
        this.jScrollPane10.setMinimumSize(new Dimension(300, 100));
        this.jScrollPane10.setPreferredSize(new Dimension(300, 100));
        this.lstPdfContent.setFont(THEMIS.fontList);
        this.lstPdfContent.setModel(new DefaultListModel());
        this.lstPdfContent.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ReportLayoutEditorPanel.this.lstPdfContentValueChanged(evt);
            }
        });
        this.jScrollPane10.setViewportView(this.lstPdfContent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFormatPdfContent.add((Component)this.jScrollPane10, gridBagConstraints);
        this.panelPdfContent.setLayout(new GridBagLayout());
        this.btnPdfContentMoveUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        this.btnPdfContentMoveUp.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnPdfContentMoveUp.text_1"));
        this.btnPdfContentMoveUp.setBorder(new SoftBevelBorder(0));
        this.btnPdfContentMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnPdfContentMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfContent.add((Component)this.btnPdfContentMoveUp, gridBagConstraints);
        this.btnPdfContentMoveDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        this.btnPdfContentMoveDown.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnPdfContentMoveDown.text_1"));
        this.btnPdfContentMoveDown.setBorder(new SoftBevelBorder(0));
        this.btnPdfContentMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnPdfContentMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfContent.add((Component)this.btnPdfContentMoveDown, gridBagConstraints);
        this.btnDeleteTableLayout1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        this.btnDeleteTableLayout1.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnDeleteTableLayout1.text_1"));
        this.btnDeleteTableLayout1.setBorder(new SoftBevelBorder(0));
        this.btnDeleteTableLayout1.setMinimumSize(null);
        this.btnDeleteTableLayout1.setPreferredSize(null);
        this.btnDeleteTableLayout1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnDeleteTableLayout1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPdfContent.add((Component)this.btnDeleteTableLayout1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        this.panelFormatPdfContent.add((Component)this.panelPdfContent, gridBagConstraints);
        this.panelEditPdfContent.setBackground(new Color(250, 250, 250));
        this.panelEditPdfContent.setMinimumSize(new Dimension(300, 100));
        this.panelEditPdfContent.setPreferredSize(new Dimension(300, 100));
        this.panelEditPdfContent.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFormatPdfContent.add((Component)this.panelEditPdfContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.cardFormat.add((Component)this.panelFormatPdfContent, gridBagConstraints);
        this.lblFormatRemain.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblFormatRemain.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.cardFormat.add((Component)this.lblFormatRemain, gridBagConstraints);
        this.panelEditor.add((Component)this.cardFormat, "cardFormat");
        this.cardContent.setLayout(new GridBagLayout());
        this.jLabel38.setFont(THEMIS.fontHeading);
        this.jLabel38.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel38.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel38, gridBagConstraints);
        this.jLabel23.setFont(THEMIS.fontSubheading);
        this.jLabel23.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel23.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel32.setFont(THEMIS.fontLabel);
        this.jLabel32.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel32.text_1"));
        this.jLabel32.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel32.toolTipText_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel32, gridBagConstraints);
        this.jLabel88.setFont(THEMIS.fontLabelSmall);
        this.jLabel88.setForeground(new Color(102, 102, 102));
        this.jLabel88.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel88.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel88, gridBagConstraints);
        this.chkLocationWithoutObservation.setFont(THEMIS.fontLabel);
        this.chkLocationWithoutObservation.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkLocationWithoutObservation.text_1"));
        this.chkLocationWithoutObservation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportLayoutEditorPanel.this.chkLocationWithoutObservationItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.cardContent.add((Component)this.chkLocationWithoutObservation, gridBagConstraints);
        this.jLabel35.setFont(THEMIS.fontLabel);
        this.jLabel35.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel35.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel35, gridBagConstraints);
        this.jLabel89.setFont(THEMIS.fontLabelSmall);
        this.jLabel89.setForeground(new Color(102, 102, 102));
        this.jLabel89.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel89.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel89, gridBagConstraints);
        this.chkWithHistories.setFont(THEMIS.fontLabel);
        this.chkWithHistories.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkWithHistories.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.cardContent.add((Component)this.chkWithHistories, gridBagConstraints);
        this.jLabel37.setFont(THEMIS.fontSubheading);
        this.jLabel37.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel37.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel37, gridBagConstraints);
        this.jLabel68.setFont(THEMIS.fontLabel);
        this.jLabel68.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel68.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel68, gridBagConstraints);
        this.jLabel90.setFont(THEMIS.fontLabelSmall);
        this.jLabel90.setForeground(new Color(102, 102, 102));
        this.jLabel90.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel90.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel90, gridBagConstraints);
        this.fldSort.setFont(THEMIS.fontList);
        this.fldSort.setModel(new DefaultComboBoxModel());
        this.fldSort.setMinimumSize(null);
        this.fldSort.setPreferredSize(null);
        this.fldSort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportLayoutEditorPanel.this.fldSortItemStateChanged(evt);
            }
        });
        this.fldSort.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ReportLayoutEditorPanel.this.fldSortPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add(this.fldSort, gridBagConstraints);
        this.panelSort.setLayout(new GridBagLayout());
        this.jScrollPane7.setMinimumSize(new Dimension(150, 80));
        this.jScrollPane7.setPreferredSize(new Dimension(150, 80));
        this.lstSortOptions2.setModel(new DefaultListModel());
        this.jScrollPane7.setViewportView(this.lstSortOptions2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSort.add((Component)this.jScrollPane7, gridBagConstraints);
        this.bntSetSort1.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.bntSetSort1.text_1"));
        this.bntSetSort1.setPreferredSize(new Dimension(60, 30));
        this.bntSetSort1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.bntSetSort1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSort.add((Component)this.bntSetSort1, gridBagConstraints);
        this.btnSetSort2.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnSetSort2.text_1"));
        this.btnSetSort2.setPreferredSize(new Dimension(60, 30));
        this.btnSetSort2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnSetSort2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSort.add((Component)this.btnSetSort2, gridBagConstraints);
        this.btnSetSort3.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnSetSort3.text_1"));
        this.btnSetSort3.setPreferredSize(new Dimension(60, 30));
        this.btnSetSort3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnSetSort3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSort.add((Component)this.btnSetSort3, gridBagConstraints);
        this.lblSortOption1.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblSortOption1.text_1"));
        this.lblSortOption1.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSort.add((Component)this.lblSortOption1, gridBagConstraints);
        this.lblSortOption2.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblSortOption2.text_1"));
        this.lblSortOption2.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSort.add((Component)this.lblSortOption2, gridBagConstraints);
        this.lblSortOption3.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblSortOption3.text_1"));
        this.lblSortOption3.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSort.add((Component)this.lblSortOption3, gridBagConstraints);
        this.jButton9.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove.gif")));
        this.jButton9.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportWizard.jButton10.text"));
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.jButton9ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSort.add((Component)this.jButton9, gridBagConstraints);
        this.jButton10.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove.gif")));
        this.jButton10.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jButton10.text_1"));
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.jButton10ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSort.add((Component)this.jButton10, gridBagConstraints);
        this.jButton11.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove.gif")));
        this.jButton11.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportWizard.jButton10.text"));
        this.jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.jButton11ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSort.add((Component)this.jButton11, gridBagConstraints);
        this.jLabel41.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel41.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.panelSort.add((Component)this.jLabel41, gridBagConstraints);
        this.jLabel42.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel42.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panelSort.add((Component)this.jLabel42, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.cardContent.add((Component)this.panelSort, gridBagConstraints);
        this.jLabel22.setFont(THEMIS.fontSubheading);
        this.jLabel22.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel22.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel30.setFont(THEMIS.fontLabel);
        this.jLabel30.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel30.text_1"));
        this.jLabel30.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel30.toolTipText_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel30, gridBagConstraints);
        this.fldExportPhotos.setFont(THEMIS.fontList);
        this.fldExportPhotos.setModel(new DefaultComboBoxModel());
        this.fldExportPhotos.setMinimumSize(null);
        this.fldExportPhotos.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add(this.fldExportPhotos, gridBagConstraints);
        this.jLabel31.setFont(THEMIS.fontLabel);
        this.jLabel31.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel31.text_1"));
        this.jLabel31.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel31.toolTipText_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel31, gridBagConstraints);
        this.chkExportPhoto.setFont(THEMIS.fontLabel);
        this.chkExportPhoto.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkExportPhoto.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.chkExportPhoto, gridBagConstraints);
        this.jLabel64.setFont(THEMIS.fontLabel);
        this.jLabel64.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel64.text"));
        this.jLabel64.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel64.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel64, gridBagConstraints);
        this.chkShowDateInPhoto.setFont(THEMIS.fontLabel);
        this.chkShowDateInPhoto.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkShowDateInPhoto.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.chkShowDateInPhoto, gridBagConstraints);
        this.jLabel24.setFont(THEMIS.fontSubheading);
        this.jLabel24.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel24.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel26.setFont(THEMIS.fontLabel);
        this.jLabel26.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel26.text_1"));
        this.jLabel26.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel26.toolTipText_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.jLabel26, gridBagConstraints);
        this.chkExportDocuments.setFont(THEMIS.fontLabel);
        this.chkExportDocuments.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkExportDocuments.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.chkExportDocuments, gridBagConstraints);
        this.lblHyperlink.setFont(THEMIS.fontLabel);
        this.lblHyperlink.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblHyperlink.text_1"));
        this.lblHyperlink.setPreferredSize(new Dimension(200, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.lblHyperlink, gridBagConstraints);
        this.fldHyperlink.setFont(THEMIS.fontList);
        this.fldHyperlink.setModel(new DefaultComboBoxModel());
        this.fldHyperlink.setMinimumSize(null);
        this.fldHyperlink.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardContent.add((Component)this.fldHyperlink, gridBagConstraints);
        this.lblContentRemain.setFont(THEMIS.fontHeading);
        this.lblContentRemain.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblContentRemain.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.cardContent.add((Component)this.lblContentRemain, gridBagConstraints);
        this.panelEditor.add((Component)this.cardContent, "cardContent");
        this.cardPlan.setLayout(new GridBagLayout());
        this.jLabel17.setFont(THEMIS.fontHeading);
        this.jLabel17.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel17.text_1"));
        this.jLabel17.setMinimumSize(null);
        this.jLabel17.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel17, gridBagConstraints);
        this.jLabel16.setFont(THEMIS.fontSubheading);
        this.jLabel16.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel16.text_1"));
        this.jLabel16.setMinimumSize(null);
        this.jLabel16.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel53.setFont(THEMIS.fontLabel);
        this.jLabel53.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel53.text_1"));
        this.jLabel53.setMinimumSize(null);
        this.jLabel53.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel53, gridBagConstraints);
        this.chkExportPlan.setFont(THEMIS.fontLabel);
        this.chkExportPlan.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkExportPlan.text_1"));
        this.chkExportPlan.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkExportPlan.toolTipText_1"));
        this.chkExportPlan.setMinimumSize(null);
        this.chkExportPlan.setPreferredSize(null);
        this.chkExportPlan.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportLayoutEditorPanel.this.chkExportPlanItemStateChanged(evt);
            }
        });
        this.chkExportPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.chkExportPlanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.chkExportPlan, gridBagConstraints);
        this.lblEmpty.setFont(THEMIS.fontLabel);
        this.lblEmpty.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblEmpty.text_1"));
        this.lblEmpty.setMinimumSize(null);
        this.lblEmpty.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.lblEmpty, gridBagConstraints);
        this.buttonGroup1.add(this.radPlanSinglePdf);
        this.radPlanSinglePdf.setFont(THEMIS.fontLabel);
        this.radPlanSinglePdf.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.radPlanSinglePdf.text_1"));
        this.radPlanSinglePdf.setEnabled(false);
        this.radPlanSinglePdf.setMinimumSize(null);
        this.radPlanSinglePdf.setPreferredSize(null);
        this.radPlanSinglePdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.radPlanSinglePdfActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.radPlanSinglePdf, gridBagConstraints);
        this.buttonGroup1.add(this.radPlanMulbiplePdf);
        this.radPlanMulbiplePdf.setFont(THEMIS.fontLabel);
        this.radPlanMulbiplePdf.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.radPlanMulbiplePdf.text_1"));
        this.radPlanMulbiplePdf.setEnabled(false);
        this.radPlanMulbiplePdf.setMinimumSize(null);
        this.radPlanMulbiplePdf.setPreferredSize(null);
        this.radPlanMulbiplePdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.radPlanMulbiplePdfActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.radPlanMulbiplePdf, gridBagConstraints);
        this.buttonGroup1.add(this.radPlanJpg);
        this.radPlanJpg.setFont(THEMIS.fontLabel);
        this.radPlanJpg.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.radPlanJpg.text_1"));
        this.radPlanJpg.setEnabled(false);
        this.radPlanJpg.setMinimumSize(null);
        this.radPlanJpg.setPreferredSize(null);
        this.radPlanJpg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.radPlanJpgActionPerformed(evt);
            }
        });
        this.radPlanJpg.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReportLayoutEditorPanel.this.radPlanJpgPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.radPlanJpg, gridBagConstraints);
        this.jLabel54.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel54.text"));
        this.jLabel54.setMinimumSize(null);
        this.jLabel54.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.cardPlan.add((Component)this.jLabel54, gridBagConstraints);
        this.jLabel56.setFont(THEMIS.fontLabel);
        this.jLabel56.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel56.text_1"));
        this.jLabel56.setMinimumSize(null);
        this.jLabel56.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel56, gridBagConstraints);
        this.chkExportPlanEmpty.setFont(THEMIS.fontLabel);
        this.chkExportPlanEmpty.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkExportPlanEmpty.text_1"));
        this.chkExportPlanEmpty.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkExportPlanEmpty.toolTipText_1"));
        this.chkExportPlanEmpty.setMinimumSize(null);
        this.chkExportPlanEmpty.setPreferredSize(null);
        this.chkExportPlanEmpty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.chkExportPlanEmptyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.chkExportPlanEmpty, gridBagConstraints);
        this.jLabel18.setFont(THEMIS.fontLabel);
        this.jLabel18.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel18.text_1"));
        this.jLabel18.setMinimumSize(null);
        this.jLabel18.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel18, gridBagConstraints);
        this.fldInfoStamp.setFont(THEMIS.fontList);
        this.fldInfoStamp.setModel(new DefaultComboBoxModel());
        this.fldInfoStamp.setMinimumSize(null);
        this.fldInfoStamp.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.fldInfoStamp, gridBagConstraints);
        this.lblEmpty1.setFont(THEMIS.fontLabel);
        this.lblEmpty1.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblEmpty1.text_1"));
        this.lblEmpty1.setMinimumSize(null);
        this.lblEmpty1.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.lblEmpty1, gridBagConstraints);
        this.fldInfoStampContent.setFont(THEMIS.fontTextfield);
        this.fldInfoStampContent.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.fldInfoStampContent.text_1"));
        this.fldInfoStampContent.setMinimumSize(null);
        this.fldInfoStampContent.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.fldInfoStampContent, gridBagConstraints);
        this.jLabel11.setFont(THEMIS.fontLabel);
        this.jLabel11.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel11.text_1"));
        this.jLabel11.setMinimumSize(null);
        this.jLabel11.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel11, gridBagConstraints);
        this.fldTransparency.setFont(THEMIS.fontList);
        this.fldTransparency.setModel(new DefaultComboBoxModel());
        this.fldTransparency.setMinimumSize(null);
        this.fldTransparency.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.fldTransparency, gridBagConstraints);
        this.fldPdfCompression.setFont(THEMIS.fontList);
        this.fldPdfCompression.setModel(new DefaultComboBoxModel());
        this.fldPdfCompression.setMinimumSize(null);
        this.fldPdfCompression.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.fldPdfCompression, gridBagConstraints);
        this.jLabel20.setFont(THEMIS.fontLabel);
        this.jLabel20.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel20.text_1"));
        this.jLabel20.setMinimumSize(null);
        this.jLabel20.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel55.setFont(THEMIS.fontSubheading);
        this.jLabel55.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel55.text_1"));
        this.jLabel55.setMinimumSize(null);
        this.jLabel55.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel55, gridBagConstraints);
        this.jLabel19.setFont(THEMIS.fontLabel);
        this.jLabel19.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel19.text_1"));
        this.jLabel19.setMinimumSize(null);
        this.jLabel19.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel19, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.sliderSnippetSize.setMajorTickSpacing(10);
        this.sliderSnippetSize.setMaximum(250);
        this.sliderSnippetSize.setMinimum(10);
        this.sliderSnippetSize.setMinorTickSpacing(1);
        this.sliderSnippetSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReportLayoutEditorPanel.this.sliderSnippetSizeStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.sliderSnippetSize, gridBagConstraints);
        this.fldSnippetSize.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.fldSnippetSize.text_1"));
        this.fldSnippetSize.setMinimumSize(new Dimension(50, 30));
        this.fldSnippetSize.setPreferredSize(new Dimension(50, 30));
        this.fldSnippetSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReportLayoutEditorPanel.this.fldSnippetSizeFocusLost(evt);
            }
        });
        this.fldSnippetSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.fldSnippetSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldSnippetSize, gridBagConstraints);
        this.jLabel48.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel48.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel48, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.cardPlan.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel57.setFont(THEMIS.fontLabel);
        this.jLabel57.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel57.text_1"));
        this.jLabel57.setMinimumSize(null);
        this.jLabel57.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel57, gridBagConstraints);
        this.chkSnippetWithLabel.setFont(THEMIS.fontLabel);
        this.chkSnippetWithLabel.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkSnippetWithLabel.text_1"));
        this.chkSnippetWithLabel.setToolTipText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.chkSnippetWithLabel.toolTipText_1"));
        this.chkSnippetWithLabel.setHorizontalAlignment(2);
        this.chkSnippetWithLabel.setMinimumSize(null);
        this.chkSnippetWithLabel.setPreferredSize(null);
        this.chkSnippetWithLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.chkSnippetWithLabelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.chkSnippetWithLabel, gridBagConstraints);
        this.jLabel49.setFont(THEMIS.fontLabel);
        this.jLabel49.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel49.text_1"));
        this.jLabel49.setMinimumSize(null);
        this.jLabel49.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cardPlan.add((Component)this.jLabel49, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.sliderIconSize.setMajorTickSpacing(5);
        this.sliderIconSize.setMaximum(95);
        this.sliderIconSize.setMinimum(5);
        this.sliderIconSize.setMinorTickSpacing(1);
        this.sliderIconSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReportLayoutEditorPanel.this.sliderIconSizeStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.sliderIconSize, gridBagConstraints);
        this.fldIconSize.setEditable(false);
        this.fldIconSize.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.fldIconSize.text_1"));
        this.fldIconSize.setMinimumSize(new Dimension(50, 30));
        this.fldIconSize.setPreferredSize(new Dimension(50, 30));
        this.fldIconSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReportLayoutEditorPanel.this.fldIconSizeFocusLost(evt);
            }
        });
        this.fldIconSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.fldIconSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldIconSize, gridBagConstraints);
        this.jLabel52.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.jLabel52.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel52, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.cardPlan.add((Component)this.jPanel2, gridBagConstraints);
        this.lblPlanRemain.setFont(THEMIS.fontHeading);
        this.lblPlanRemain.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.lblPlanRemain.text_1"));
        this.lblPlanRemain.setMinimumSize(null);
        this.lblPlanRemain.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.cardPlan.add((Component)this.lblPlanRemain, gridBagConstraints);
        this.panelEditor.add((Component)this.cardPlan, "cardPlan");
        this.panelEditorScroll.setViewportView(this.panelEditor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelEditorScroll, gridBagConstraints);
        this.panelButtons1.setMinimumSize(new Dimension(100, 50));
        this.panelButtons1.setLayout(new GridBagLayout());
        this.btnPrevious.setFont(THEMIS.fontButton);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft32.gif")));
        this.btnPrevious.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnPrevious.text"));
        this.btnPrevious.setBorder(new SoftBevelBorder(0));
        this.btnPrevious.setMinimumSize(new Dimension(100, 30));
        this.btnPrevious.setPreferredSize(new Dimension(100, 30));
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnPreviousActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelButtons1.add((Component)this.btnPrevious, gridBagConstraints);
        this.btnNext.setFont(THEMIS.fontButton);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight32.gif")));
        this.btnNext.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnNext.text"));
        this.btnNext.setBorder(new SoftBevelBorder(0));
        this.btnNext.setHorizontalTextPosition(10);
        this.btnNext.setMinimumSize(new Dimension(100, 30));
        this.btnNext.setPreferredSize(new Dimension(100, 30));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelButtons1.add((Component)this.btnNext, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons1, gridBagConstraints);
        this.panelButtons.setMinimumSize(new Dimension(100, 50));
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnExport2.setFont(THEMIS.fontButton);
        this.btnExport2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/saveProtocol24.gif")));
        this.btnExport2.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnExport2.text"));
        this.btnExport2.setBorder(new SoftBevelBorder(0));
        this.btnExport2.setMinimumSize(new Dimension(150, 40));
        this.btnExport2.setPreferredSize(new Dimension(100, 30));
        this.btnExport2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnExport2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnExport2, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontButton);
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        this.btnClose.setText(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportLayoutEditorPanel.btnClose.text"));
        this.btnClose.setBorder(new SoftBevelBorder(0));
        this.btnClose.setMinimumSize(new Dimension(150, 40));
        this.btnClose.setPreferredSize(new Dimension(100, 30));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutEditorPanel.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void chkExportPlanActionPerformed(ActionEvent evt) {
        this.setPlanOptionsEnabledOrDisabled();
    }

    private void listTopicValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.showWizardPage();
        }
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        int idx = this.listTopic.getSelectedIndex();
        if (idx > 0) {
            this.listTopic.setSelectedIndex(idx - 1);
        }
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        int idx = this.listTopic.getSelectedIndex();
        if (idx < this.listTopic.getModel().getSize() - 1) {
            this.listTopic.setSelectedIndex(idx + 1);
        }
    }

    private void btnSelectTemplateActionPerformed(ActionEvent evt) {
        File origFolder = this.rep.getTemplateFileFromSource();
        FileFilter filefilter = null;
        switch (this.rep.exportFormat) {
            case EXCEL: {
                filefilter = THEMIS.getReportExcelFilter();
                break;
            }
            case WORD: {
                filefilter = THEMIS.getReportWordFilter();
                break;
            }
            default: {
                filefilter = THEMIS.getFileFilter();
            }
        }
        File f = new ThemisFileDialog(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"ReportWizard.templateReport.text"), ThemisFileDialog.DIALOGTYPE.OPEN, origFolder, origFolder, filefilter, null, false).getSelectedFile();
        if (f != null) {
            if (!f.isFile() || f.isDirectory()) {
                Dialogs.getInstance().showWarningDialog(NbBundle.getMessage(ReportLayoutEditorPanel.class, (String)"MESSAGE_TEMPLATE_NOT_A_FILE"));
                return;
            }
            this.setTemplateFile(f);
        }
    }

    private void chkExportPlanEmptyActionPerformed(ActionEvent evt) {
    }

    private void chkSnippetWithLabelActionPerformed(ActionEvent evt) {
    }

    private void radPlanJpgPropertyChange(PropertyChangeEvent evt) {
        this.fldPdfCompression.setEnabled(!this.radPlanJpg.isSelected());
    }

    private void chkExportPlanItemStateChanged(ItemEvent evt) {
        this.showExportAssistantStep();
    }

    private void radPlanSinglePdfActionPerformed(ActionEvent evt) {
        this.showExportAssistantStep();
    }

    private void radPlanMulbiplePdfActionPerformed(ActionEvent evt) {
        this.showExportAssistantStep();
    }

    private void radPlanJpgActionPerformed(ActionEvent evt) {
        this.showExportAssistantStep();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.updateCurrentPdfContent();
        this.closeDialog();
    }

    private void bntSetSort1ActionPerformed(ActionEvent evt) {
        AttributeSqlPair sel = this.lstSortOptions2.getSelectedValue();
        this.setSort(0, sel);
        this.showSortOptions();
    }

    private void btnSetSort2ActionPerformed(ActionEvent evt) {
        AttributeSqlPair sel = this.lstSortOptions2.getSelectedValue();
        this.setSort(1, sel);
        this.showSortOptions();
    }

    private void btnSetSort3ActionPerformed(ActionEvent evt) {
        AttributeSqlPair sel = this.lstSortOptions2.getSelectedValue();
        this.setSort(2, sel);
        this.showSortOptions();
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.sortOptions[0] = this.NONE_SORT;
        this.showSortOptions();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        this.sortOptions[1] = this.NONE_SORT;
        this.showSortOptions();
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        this.sortOptions[2] = this.NONE_SORT;
        this.showSortOptions();
    }

    private void btnFormatExcelActionPerformed(ActionEvent evt) {
        this.setFormat(CmsReport.ReportFormat.EXCEL);
    }

    private void btnFormatWordActionPerformed(ActionEvent evt) {
        this.setFormat(CmsReport.ReportFormat.WORD);
    }

    private void btnFormatPDFActionPerformed(ActionEvent evt) {
        this.setPdfFormat(this.fldExportPdfLayout.getSelectedIndex());
    }

    private void fldSortItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && !this.isUIupdating()) {
            AttributeSqlPair sort = (AttributeSqlPair)this.fldSort.getSelectedItem();
            if (sort == null) {
                this.panelSort.setVisible(false);
                this.rep.sort = null;
            } else if (sort.isNone()) {
                this.panelSort.setVisible(true);
                this.rep.sort = null;
                this.rep.sort1 = this.lblSortOption1.getText();
                this.rep.sort2 = this.lblSortOption2.getText();
                this.rep.sort3 = this.lblSortOption3.getText();
            } else {
                this.panelSort.setVisible(false);
                this.rep.sort = sort.getSql();
                this.rep.sort1 = null;
                this.rep.sort2 = null;
                this.rep.sort3 = null;
            }
        }
    }

    private void fldSortPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
    }

    private void btnAddTableLayout1ActionPerformed(ActionEvent evt) {
        PdfContent sel = (PdfContent)this.fldPdfContents.getSelectedItem();
        if (sel != null) {
            PdfContent copy = sel.getNewInstance();
            ((DefaultListModel)this.lstPdfContent.getModel()).addElement(copy);
            this.lstPdfContent.setSelectedValue(copy, true);
        }
    }

    private void btnDeleteTableLayout1ActionPerformed(ActionEvent evt) {
        for (PdfContent c : this.lstPdfContent.getSelectedValuesList()) {
            ((DefaultListModel)this.lstPdfContent.getModel()).removeElement(c);
        }
    }

    private void btnPdfContentMoveUpActionPerformed(ActionEvent evt) {
        int idx = this.lstPdfContent.getSelectedIndex();
        if (idx > 0) {
            PdfContent sel = (PdfContent)((DefaultListModel)this.lstPdfContent.getModel()).getElementAt(idx);
            ((DefaultListModel)this.lstPdfContent.getModel()).remove(idx);
            ((DefaultListModel)this.lstPdfContent.getModel()).add(idx - 1, sel);
            this.lstPdfContent.setSelectedValue(sel, true);
        }
    }

    private void btnPdfContentMoveDownActionPerformed(ActionEvent evt) {
        int idx = this.lstPdfContent.getSelectedIndex();
        DefaultListModel model = (DefaultListModel)this.lstPdfContent.getModel();
        if (idx >= 0 && idx < model.size() - 1) {
            PdfContent sel = (PdfContent)model.getElementAt(idx);
            ((DefaultListModel)this.lstPdfContent.getModel()).remove(idx);
            ((DefaultListModel)this.lstPdfContent.getModel()).add(idx + 1, sel);
            this.lstPdfContent.setSelectedValue(sel, true);
        }
    }

    private void lstPdfContentValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.ignorePdfContentUpdate = true;
        this.updateCurrentPdfContent();
        this.currentPdfContent = this.lstPdfContent.getSelectedValue();
        this.panelEditPdfContent.removeAll();
        if (this.currentPdfContent != null) {
            if (this.currentPdfContent instanceof PdfContentHeading1) {
                this.panelEditPdfContent.add((Component)this.panelPdfHeading, "Center");
                this.fldHeading.setText(((PdfContentHeading1)this.currentPdfContent).getText());
            } else if (this.currentPdfContent instanceof PdfContentHeading2) {
                this.panelEditPdfContent.add((Component)this.panelPdfHeading, "Center");
                this.fldHeading.setText(((PdfContentHeading2)this.currentPdfContent).getText());
            } else if (this.currentPdfContent instanceof PdfContentParagraph) {
                this.panelEditPdfContent.add((Component)this.panelPdfParagraph, "Center");
                this.fldParagraph.setText(((PdfContentParagraph)this.currentPdfContent).getText());
            } else if (this.currentPdfContent instanceof PdfContentTable) {
                this.populateReportLayoutList();
                this.panelEditPdfContent.add((Component)this.panelPdfTable, "Center");
                ReportTableLayout rtl = this.getTableLayoutByName(((PdfContentTable)this.currentPdfContent).getLayoutName());
                if (rtl != null) {
                    this.fldPdfLayoutTable.setSelectedItem(rtl);
                }
                this.fldPdfTablePagebreak.setSelectedItem(((PdfContentTable)this.currentPdfContent).getPagebreak());
            } else if (this.currentPdfContent instanceof PdfContentForm) {
                this.panelEditPdfContent.add((Component)this.panelPdfForm, "Center");
                for (int ii = 0; ii < this.fldPdfFormulare.getItemCount(); ++ii) {
                    if (this.fldPdfFormulare.getItemAt(ii).getId() != ((PdfContentForm)this.currentPdfContent).getFormId()) continue;
                    this.fldPdfFormulare.setSelectedIndex(ii);
                    break;
                }
            } else if (this.currentPdfContent instanceof PdfContentPicture) {
                this.panelEditPdfContent.add((Component)this.panelPdfPicture, "Center");
                this.fldPictureWidth.setText(((PdfContentPicture)this.currentPdfContent).getWidthAsString());
            }
        }
        this.panelEditPdfContent.revalidate();
        this.panelEditPdfContent.repaint();
        this.ignorePdfContentUpdate = false;
    }

    private void btnExport2ActionPerformed(ActionEvent evt) {
        if (this.verifyBeforeApply()) {
            this.updateCurrentPdfContent();
            this.apply();
            this.closeDialog();
        }
    }

    private void fldHeadingFocusLost(FocusEvent evt) {
        if (this.ignorePdfContentUpdate) {
            return;
        }
        this.updatePdfParagraph(this.fldHeading.getText());
    }

    private void fldHeadingActionPerformed(ActionEvent evt) {
        if (this.ignorePdfContentUpdate) {
            return;
        }
        this.updatePdfParagraph(this.fldHeading.getText());
    }

    private void chkReportHeadItemStateChanged(ItemEvent evt) {
        if (this.ignorePdfContentUpdate) {
            return;
        }
        if (this.currentPdfContent instanceof PdfContentTitlepage) {
            ((PdfContentTitlepage)this.currentPdfContent).withReportHeader = this.chkReportHead.isSelected();
        }
    }

    private void chkProjectInfoItemStateChanged(ItemEvent evt) {
        if (this.ignorePdfContentUpdate) {
            return;
        }
        if (this.currentPdfContent instanceof PdfContentTitlepage) {
            ((PdfContentTitlepage)this.currentPdfContent).withProjectDetails = this.chkProjectInfo.isSelected();
        }
    }

    private void chkEventInfoItemStateChanged(ItemEvent evt) {
        if (this.ignorePdfContentUpdate) {
            return;
        }
        if (this.currentPdfContent instanceof PdfContentTitlepage) {
            ((PdfContentTitlepage)this.currentPdfContent).withEventDetails = this.chkEventInfo.isSelected();
        }
    }

    private void chkProjectImageItemStateChanged(ItemEvent evt) {
        if (this.ignorePdfContentUpdate) {
            return;
        }
        if (this.currentPdfContent instanceof PdfContentTitlepage) {
            ((PdfContentTitlepage)this.currentPdfContent).withImage = this.chkProjectImage.isSelected();
        }
    }

    private void fldExportPdfLayoutItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setPdfFormat(this.fldExportPdfLayout.getSelectedIndex());
        }
    }

    private void chkLocationWithoutObservationItemStateChanged(ItemEvent evt) {
    }

    private void btnPageFormatActionPerformed(ActionEvent evt) {
        PageFormatPanel panel = new PageFormatPanel(this.rep.pageFormat);
        panel.populate();
        panel.showDialog();
        this.rep.pageFormat.fromXml(panel.getPageFormat().toXml());
    }

    private void listTopicKeyReleased(KeyEvent evt) {
    }

    private void sliderSnippetSizeStateChanged(ChangeEvent evt) {
        this.fldSnippetSize.setText(Integer.toString(this.sliderSnippetSize.getValue()));
    }

    private void fldSnippetSizeFocusLost(FocusEvent evt) {
        int v = Util.parseInt((String)this.fldSnippetSize.getText(), (int)this.sliderSnippetSize.getValue());
        this.setSnippetSize(v);
    }

    private void fldSnippetSizeActionPerformed(ActionEvent evt) {
        int v = Util.parseInt((String)this.fldSnippetSize.getText(), (int)this.sliderSnippetSize.getValue());
        this.setSnippetSize(v);
    }

    private void sliderIconSizeStateChanged(ChangeEvent evt) {
        this.fldIconSize.setText(Integer.toString(this.sliderIconSize.getValue()));
    }

    private void fldIconSizeFocusLost(FocusEvent evt) {
    }

    private void fldIconSizeActionPerformed(ActionEvent evt) {
    }

    private void fldPictureWidthFocusLost(FocusEvent evt) {
    }

    private void fldPictureWidthActionPerformed(ActionEvent evt) {
    }

    private void btnShowEditorActionPerformed(ActionEvent evt) {
        String txt = this.fldParagraph.getText();
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("texteditor", 800, 600);
        ThemisTextEditor2 fx2 = new ThemisTextEditor2();
        fx2.setText(txt);
        dlg.setContent((Node)fx2);
        dlg.show();
        String txt2 = fx2.getText();
        this.fldParagraph.setText(txt2);
    }

    private void btnEditTemplateFileActionPerformed(ActionEvent evt) {
        try {
            File f = this.rep.getTemplateFile();
            if (f == null) {
                Dialogs.getInstance().showWarningDialog("Es ist keine Vorlage ausgew\u00e4hlt!");
            } else if (f.isFile()) {
                Dialogs.getInstance().showWarningDialog("Wichtig: Damit \u00c4nderungen \u00fcbernommen werden, muss die Datei unter gleichem Namen gespeichert werden!");
                Desktop.getDesktop().open(f);
            } else {
                Dialogs.getInstance().showWarningDialog("Die Vorlagen-Datei ist nicht verf\u00fcgbar: " + f.getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void lstTableLayoutMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.editSelected();
        }
    }

    private void btnAddTableLayoutActionPerformed(ActionEvent evt) {
        String layoutName = this.project.getNewReportTableName("Tabellen-Layout");
        ArrayList layoutNames = this.project.getReportTableNames();
        layoutNames.remove(layoutName);
        LayoutTableEditor2 panelTable = new LayoutTableEditor2(layoutName);
        panelTable.setForbiddenNames(layoutNames);
        panelTable.showDialog();
        if (panelTable.doSave()) {
            ReportTableLayout rtl = panelTable.getTableLayout();
            rtl.save();
            ((DefaultListModel)this.lstTableLayout.getModel()).addElement(rtl);
            this.updateSettings();
            if (this.wizard != null) {
                this.wizard.populateReportLayoutList();
            }
            this.populateReportLayoutList();
        }
    }

    private void btnEditTableLayoutActionPerformed(ActionEvent evt) {
        this.editSelected();
        this.populateReportLayoutList();
    }

    private void btnCopyTableLayoutActionPerformed(ActionEvent evt) {
        ReportTableLayout rtl = this.lstTableLayout.getSelectedValue();
        if (rtl == null) {
            return;
        }
        ReportTableLayout rtlNew = (ReportTableLayout)this.project.createElement("reporttable");
        rtlNew.fromXML(rtl.getXml());
        rtlNew.setName(this.project.getNewReportTableName(rtl.getName()));
        rtlNew.save();
        this.addReportTableLayout(rtlNew);
        this.populateReportLayoutList();
    }

    private void btnDeleteTableLayoutActionPerformed(ActionEvent evt) {
        if (this.lstTableLayout.getSelectedValue() == null) {
            return;
        }
        if (Dialogs.getInstance().showConfirmDialog("dialog.delete-reporttablelayout.message", "dialog.delete-reporttablelayout.title")) {
            for (ReportTableLayout rtl : this.lstTableLayout.getSelectedValuesList()) {
                ((DefaultListModel)this.lstTableLayout.getModel()).removeElement(rtl);
            }
            this.updateSettings();
            this.populateReportLayoutList();
            if (this.wizard != null) {
                this.wizard.populateReportLayoutList();
            }
        }
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        List<ReportTableLayout> items = this.lstTableLayout.getSelectedValuesList();
        if (items.isEmpty()) {
            this.app.getDialog().showErrorDialog("Es ist keine Tabelle ausgew\u00e4hlt.");
            return;
        }
        this.saveLayout(items);
    }

    private void btnLoadActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.project.getResourceText("dialog.load-report-layout"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getPathTemplateLocationObservation(), null, THEMIS.getLayoutFilter(), null, false).getSelectedFile();
        if (f != null) {
            ReportTableLayout.loadLayout((File)f);
            this.populateTableLayoutList();
        }
    }

    private void showExportAssistantStep() {
    }

    public String getSort() {
        AttributeSqlPair sort = (AttributeSqlPair)this.fldSort.getSelectedItem();
        if (sort == null || sort.isNone()) {
            ArrayList<String> sortItems = new ArrayList<String>();
            for (int ii = 0; ii < 3; ++ii) {
                if (this.sortOptions[ii].isNone()) continue;
                sortItems.add(this.sortOptions[ii].getSql());
            }
            sortItems.add("observation.number,observation.idelement");
            return String.join((CharSequence)",", sortItems);
        }
        return sort.getSql();
    }

    private void updatePdfParagraph(String t) {
        if (this.currentPdfContent instanceof PdfContentParagraph) {
            ((PdfContentParagraph)this.currentPdfContent).setText(t);
        }
    }

    private void setSnippetSize(int v) {
        if (v > this.sliderSnippetSize.getMaximum()) {
            this.sliderSnippetSize.setValue(this.sliderSnippetSize.getMaximum());
        } else if (v < this.sliderSnippetSize.getMinimum()) {
            this.sliderSnippetSize.setValue(this.sliderSnippetSize.getMinimum());
        } else {
            this.sliderSnippetSize.setValue(v);
        }
        this.fldSnippetSize.setText(Integer.toString(this.sliderSnippetSize.getValue()));
    }

    @Override
    public String getDialogCode() {
        return "reportwizard";
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(1200, 770);
    }
}

