/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.report;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.config.ProjectSettingsPanel;
import at.grid.themis.application.report.Exporter;
import at.grid.themis.application.report.ReportLayoutEditorPanel;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.ThemisTaskWithFxDialog;
import at.grid.themis.ontology.javafx.demo.SelectDemoReportTemplateFxPanel;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.themis.ontology.template.TemplateDescription;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.JDOMException;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReportLayoutManagerPanel
extends ThemisPanel {
    private final ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/report/Bundle");
    private final ProjectSettingsPanel wizard;
    private JButton btnAdd;
    private JButton btnCopy;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnRemovePlansnippets;
    private JButton btnSelectAction;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel7;
    private JLabel jLabel90;
    private JPanel jPanel1;
    private JScrollPane jScrollPane3;
    private JList lstLayouts;
    private JPanel panelButton;
    private JPanel panelPlansnippet;

    public ReportLayoutManagerPanel(ProjectSettingsPanel wizard) {
        this.initComponents();
        this.wizard = wizard;
        this.lstLayouts.setCellRenderer(new SimpleTextRenderer());
        new DropTarget(this.lstLayouts, new ThemisDropTargetListener(false, false, new String[]{"themis"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ReportLayoutManagerPanel.this.loadTemplate(f);
            }
        });
        this.populate();
    }

    @Override
    public void populate(ProgressHandler ph) {
        ArrayList templates = this.project.getReportTemplates();
        List selIds = this.getSelection().stream().map(e -> e.getId()).collect(Collectors.toList());
        this.getModel().clear();
        int index = 0;
        for (CmsBasicElement template : templates) {
            this.getModel().addElement(template);
            if (selIds.contains(template.getId())) {
                this.lstLayouts.addSelectionInterval(index, index);
            }
            ++index;
        }
        this.updateSelection();
    }

    @Override
    public void apply() {
    }

    public DefaultListModel<CmsBasicElement> getModel() {
        return (DefaultListModel)this.lstLayouts.getModel();
    }

    public List<CmsBasicElement> getSelection() {
        ArrayList eles = this.lstLayouts.getSelectedValuesList();
        return eles == null ? new ArrayList() : eles;
    }

    private void updateSelection() {
        List<CmsBasicElement> eles = this.getSelection();
        this.btnCopy.setEnabled(eles.size() == 1);
        this.btnEdit.setEnabled(eles.size() == 1);
        this.btnRemove.setEnabled(!eles.isEmpty());
    }

    private void removeSelection() {
        List<CmsBasicElement> selected = this.getSelection();
        if (selected.isEmpty()) {
            return;
        }
        boolean remove = false;
        if (selected.size() == 1) {
            remove = this.app.getDialog().showConfirmDialog(this.bundle.getString("ReportLayoutManagerPanel.deleteLayout.text"), this.bundle.getString("ReportLayoutManagerPanel.deleteLayout.title"));
        } else if (selected.size() > 1) {
            remove = this.app.getDialog().showConfirmDialog(this.bundle.getString("ReportLayoutManagerPanel.deleteLayoutPlural.text"), this.bundle.getString("ReportLayoutManagerPanel.deleteLayout.title"));
        }
        if (!remove) {
            return;
        }
        for (CmsBasicElement e : selected) {
            if (e.getId() <= 0L) continue;
            CmsElement.moveToTrash((CmsApplication)this.project, (long)e.getId(), (CmsUser)this.project.getUser());
        }
        this.populate();
    }

    private void editLayout(CmsReport rep) {
        try {
            new ReportLayoutEditorPanel(rep, this.wizard).showDialog();
            this.populate();
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("EventReportAction.errorFileExists.text");
        }
    }

    private void loadDemoLayouts() {
        DemoPackManager demo = DemoPackManager.getInstance();
        if (demo.isNewVersionAvailable()) {
            if (this.app.getDialog().showConfirmDialog("Es stehen neue Vorlagen zum Download zur Verf\u00fcgung. Sollen diese heruntergeladen werden?")) {
                ThemisTaskWithDialog.createTaskWithCancel("Vorlagen werden heruntergeladen", arg_0 -> ((DemoPackManager)demo).downloadTemplates(arg_0));
            } else {
                demo.setIgnoreNewVersion();
            }
        }
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("load-demo", 700, 600);
        SelectDemoReportTemplateFxPanel panel = new SelectDemoReportTemplateFxPanel().populate();
        JavaFxDialog fx = new JavaFxDialog((Node)panel);
        fx.addSaveButton("Laden").setOnAction(ev -> {
            panel.apply();
            List selected = panel.getSelected();
            ThemisTaskWithFxDialog.createTask((String)"Vorlagen werden geladen", (boolean)true, (boolean)true, ph -> {
                for (TemplateDescription template : selected) {
                    File file = template.getFile();
                    if (file.isFile() && file.getName().toLowerCase().endsWith(".themis")) {
                        try {
                            ThemisFile tf = new ThemisFile();
                            tf.setAsReportTemplate();
                            tf.loadFromFile(file, false);
                        }
                        catch (IOException | JDOMException ex) {
                            ex.printStackTrace();
                        }
                    }
                    ph.increaseProgress(1);
                    if (!ph.isCancelled()) continue;
                    break;
                }
                dlg.close();
                SwingUtilities.invokeLater(() -> this.populate());
            });
        });
        fx.addCancelButton("Abbrechen");
        dlg.setContent((Node)fx);
        dlg.show();
    }

    public void saveTemplate() {
        List<CmsBasicElement> selected = this.getSelection();
        if (selected.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (CmsBasicElement item : selected) {
            if (item.getId() <= 0L) continue;
            ids.add(item.getId());
        }
        File f = new ThemisFileDialog(this.app.getProject().getResourceText("file.save.title"), ThemisFileDialog.DIALOGTYPE.SAVE, ThemisApplication.getInstance().getSettings().getFolderReportTemplate().getValue(true), null, THEMIS.getThemisFileFilter(), null, false).getSelectedFile();
        if (f != null) {
            this.app.getSettings().getFolderReportTemplate().setValue(f.getParentFile());
            Exporter.saveReportLayouts(ids, f);
        }
    }

    public void loadTemplate(File f) {
        if (f == null) {
            f = new ThemisFileDialog(this.app.getProject().getResourceText("file.load.title"), ThemisFileDialog.DIALOGTYPE.OPEN, ThemisApplication.getInstance().getSettings().getFolderReportTemplate().getValue(true), null, THEMIS.getThemisFileFilter(), null, false).getSelectedFile();
        }
        if (f != null) {
            this.app.getSettings().getFolderReportTemplate().setValue(f.getParentFile());
            ThemisFile tf = new ThemisFile();
            tf.setAsReportTemplate();
            try {
                tf.loadFromFile(f, false);
                this.populate();
            }
            catch (IOException | JDOMException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.lstLayouts = new JList();
        this.panelButton = new JPanel();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnCopy = new JButton();
        this.btnRemove = new JButton();
        this.btnSelectAction = new JButton();
        this.jLabel7 = new JLabel();
        this.panelPlansnippet = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel90 = new JLabel();
        this.btnRemovePlansnippets = new JButton();
        this.setMinimumSize(new Dimension(300, 200));
        this.setPreferredSize(new Dimension(300, 200));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane3.setMinimumSize(null);
        this.lstLayouts.setFont(THEMIS.fontList);
        this.lstLayouts.setModel(new DefaultListModel());
        this.lstLayouts.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ReportLayoutManagerPanel.this.lstLayoutsMouseClicked(evt);
            }
        });
        this.lstLayouts.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ReportLayoutManagerPanel.this.lstLayoutsValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.lstLayouts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jScrollPane3, gridBagConstraints);
        this.panelButton.setLayout(new GridBagLayout());
        this.btnAdd.setFont(THEMIS.fontButton);
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnAdd.text"));
        this.btnAdd.setToolTipText(NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnAdd.toolTipText"));
        this.btnAdd.setBorder(new SoftBevelBorder(0));
        this.btnAdd.setMaximumSize(null);
        this.btnAdd.setMinimumSize(null);
        this.btnAdd.setPreferredSize(null);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutManagerPanel.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButton.add((Component)this.btnAdd, gridBagConstraints);
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnEdit.text"));
        this.btnEdit.setToolTipText(NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnEdit.toolTipText"));
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.setMaximumSize(null);
        this.btnEdit.setMinimumSize(null);
        this.btnEdit.setPreferredSize(null);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutManagerPanel.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButton.add((Component)this.btnEdit, gridBagConstraints);
        this.btnCopy.setFont(THEMIS.fontButton);
        this.btnCopy.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopy, (String)NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnCopy.text"));
        this.btnCopy.setToolTipText(NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnCopy.toolTipText"));
        this.btnCopy.setBorder(new SoftBevelBorder(0));
        this.btnCopy.setMaximumSize(null);
        this.btnCopy.setMinimumSize(null);
        this.btnCopy.setPreferredSize(null);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutManagerPanel.this.btnCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButton.add((Component)this.btnCopy, gridBagConstraints);
        this.btnRemove.setFont(THEMIS.fontButton);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnRemove.toolTipText"));
        this.btnRemove.setBorder(new SoftBevelBorder(0));
        this.btnRemove.setMaximumSize(null);
        this.btnRemove.setMinimumSize(null);
        this.btnRemove.setPreferredSize(null);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutManagerPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButton.add((Component)this.btnRemove, gridBagConstraints);
        this.btnSelectAction.setFont(new Font("Tahoma", 1, 11));
        this.btnSelectAction.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/menu_options24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectAction, (String)NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnSelectAction.text"));
        this.btnSelectAction.setToolTipText(NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnSelectAction.toolTipText"));
        this.btnSelectAction.setDisabledIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/menu_options_disabled24.gif")));
        this.btnSelectAction.setHorizontalTextPosition(10);
        this.btnSelectAction.setMinimumSize(null);
        this.btnSelectAction.setPreferredSize(null);
        this.btnSelectAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutManagerPanel.this.btnSelectActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.panelButton.add((Component)this.btnSelectAction, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panelButton.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.panelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.panelPlansnippet.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPlansnippet.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel90.setFont(THEMIS.fontLabel);
        this.jLabel90.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel90, (String)NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.jLabel90.text"));
        this.jLabel90.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPlansnippet.add((Component)this.jLabel90, gridBagConstraints);
        this.btnRemovePlansnippets.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemovePlansnippets, (String)NbBundle.getMessage(ReportLayoutManagerPanel.class, (String)"ReportLayoutManagerPanel.btnRemovePlansnippets.text"));
        this.btnRemovePlansnippets.setBorder(new SoftBevelBorder(0));
        this.btnRemovePlansnippets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportLayoutManagerPanel.this.btnRemovePlansnippetsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPlansnippet.add((Component)this.btnRemovePlansnippets, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.panelPlansnippet, gridBagConstraints);
    }

    private void lstLayoutsMouseClicked(MouseEvent evt) {
        List<CmsBasicElement> selected;
        if (evt.getClickCount() > 1 && !(selected = this.getSelection()).isEmpty()) {
            long eleId = selected.get(0).getId();
            CmsReport e = (CmsReport)this.project.loadElement(eleId, this.project.getUser());
            this.editLayout(e);
        }
    }

    private void lstLayoutsValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.updateSelection();
        }
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        List<CmsBasicElement> selected = this.getSelection();
        if (!selected.isEmpty()) {
            long eleId = selected.get(0).getId();
            CmsReport e = (CmsReport)this.project.loadElement(eleId, this.project.getUser());
            this.editLayout(e);
        }
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        List<CmsBasicElement> selected = this.getSelection();
        if (!selected.isEmpty()) {
            long eleId = selected.get(0).getId();
            CmsReport e = (CmsReport)this.project.loadElement(eleId, this.project.getUser());
            e = (CmsReport)e.copy();
            e.setLayoutName(e.getLayoutName() + " (Kopie)");
            e.applyXml();
            this.editLayout(e);
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.removeSelection();
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        CmsReport c = (CmsReport)this.project.createElement("report");
        c.setLayoutName("Protokollvorlage " + (this.lstLayouts.getModel().getSize() + 1));
        this.editLayout(c);
    }

    private void btnRemovePlansnippetsActionPerformed(ActionEvent evt) {
        ThemisTaskWithDialog.createTask("Bestehende Planausschnitte zur\u00fccksetzen", ph -> Util.deleteContent((File)ThemisApplication.getInstance().getProject().getPlansnippetLocation()));
    }

    private void btnSelectActionActionPerformed(ActionEvent evt) {
        JPopupMenu menu = new JPopupMenu(this.project.getResourceText("menu.reporttemplates.options"));
        JMenuItem item = THEMIS.createMenuItem(this.project.getResourceText("menu.reporttemplates.load"), Color.WHITE, false, null);
        item.addActionListener(e -> this.loadTemplate(null));
        menu.add(item);
        if (!this.lstLayouts.getSelectedValuesList().isEmpty()) {
            item = THEMIS.createMenuItem(this.project.getResourceText("menu.reporttemplates.save"), Color.WHITE, false, null);
            item.addActionListener(e -> this.saveTemplate());
            menu.add(item);
        }
        menu.add(THEMIS.createSeparator(Color.WHITE));
        item = THEMIS.createMenuItem(this.project.getResourceText("menu.reporttemplates.loaddemo"), Color.WHITE, false, null);
        item.addActionListener(e -> this.loadDemoLayouts());
        menu.add(item);
        menu.show(this.btnSelectAction, this.btnSelectAction.getWidth(), 0);
    }

    @Override
    public String getDialogCode() {
        return "reportlayoutmanager";
    }

    @Override
    public Dimension getPanelSize() {
        return new Dimension(320, 535);
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(250, 300);
    }
}

