/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.report;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.report.Exporter;
import at.grid.themis.application.report.ReportLayoutEditorPanel;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class ReportPanel
extends ThemisPanel {
    CmsReport rep = null;
    private ThemisFilter filter;
    private int countSelected = 0;
    private List<ThemisFolder> projects = null;
    private JButton btnAddDate;
    private JButton btnClose;
    private JButton btnEditLayouts;
    private JButton btnExport2;
    private JButton btnExport3;
    private JButton btnSelectFolder;
    private JButton btnSetContentEvent;
    private JButton btnSetContentFilter;
    private JButton btnSetContentPeriod;
    private JButton btnSetContentSelection;
    private JButton btnSignature1;
    private JCheckBox chkCreateFolder;
    private JComboBox fldEvent;
    private JTextField fldEventDatum;
    private JTextField fldExportFolder;
    private JTextField fldExportName;
    private JComboBox fldFilter;
    private JTextArea fldKenntnis;
    private JTextField fldNummer;
    private JComboBox<String> fldPeriod;
    private JTextField fldPeriodYear;
    private JComboBox<CmsBasicElement> fldReportLayout;
    private JTextField fldTitel;
    private JTextField fldVerfasser;
    private JTextField fldVersion;
    private JTextArea fldVerteiler;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel34;
    private JLabel jLabel47;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel72;
    private JLabel jLabel73;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel90;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblContentDefinition;
    private JLabel lblEvent;
    private JLabel lblFilter;
    private JLabel lblPeriod;
    private JLabel lblProtokollKopf;
    private JLabel lblReportLayout;
    private JLabel lblReportlayoutHeading;
    private JPanel panelButtons;
    private JPanel panelContactsKenntnis;
    private JPanel panelContactsVerteiler;
    private JPanel panelContentDefinition;
    private JPanel panelPeriod;
    private JPanel panelProtokollKopf;
    private JPanel panelReportHeader;
    private JPanel panelReportLayout;
    private JPanel panelSignatures;

    public ReportPanel() {
        this((List<ThemisFolder>)null);
    }

    public ReportPanel(List<ThemisFolder> projects) {
        this.initComponents();
        this.countSelected = this.project.getSelectionManager().getSelectedObservationIds().size();
        if (this.countSelected == 0) {
            this.btnSetContentSelection.setEnabled(false);
        }
        this.filter = new ThemisFilter(this.app, false, false);
        this.filter.setFilter(this.app.getFilter());
        if (projects != null) {
            this.setContentType(CmsReport.Content.FILTER);
            this.lblReportLayout.setVisible(false);
            this.lblReportlayoutHeading.setVisible(false);
        }
        THEMIS.removeUsualTabBehavior(this.fldVerteiler);
        THEMIS.removeUsualTabBehavior(this.fldKenntnis);
        this.fldEvent.setRenderer(new SimpleTextRenderer());
        this.fldFilter.setRenderer(new SimpleTextRenderer());
        THEMIS.setCheckboxIcon(this.chkCreateFolder);
        if (!this.app.isUserAdministrator()) {
            this.btnEditLayouts.setEnabled(false);
        }
        this.btnExport3.setVisible(false);
        if (!this.app.getLicense().hasLicenseFull()) {
            long repId;
            this.panelReportLayout.setVisible(false);
            this.lblReportLayout.setVisible(false);
            this.rep = this.app.getLicense().hasLicenseApp() ? ((repId = this.app.getSettings().getLastReportLayoutId()) < 0L ? (CmsReport)this.project.createElement("report") : (CmsReport)this.project.loadElement(repId, this.project.getUser())) : (CmsReport)this.project.createElement("report");
        }
    }

    @Override
    public void populate(ProgressHandler ph) {
        int selIdx;
        this.setUIupdating(true);
        if (this.rep == null) {
            long lastUsedLayout = this.app.getSettings().getLastReportLayoutId();
            this.rep = this.loadReportSpecification(lastUsedLayout);
        }
        this.setUIupdating(false);
        this.loadReportLayouts();
        this.loadEvents();
        this.loadFilters();
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "company");
        s.addSelectMeta();
        s.setSort(this.project.getDefaultElement("company").getAttribute("name"));
        s.search().getResultAsElementSummary();
        this.panelContactsKenntnis.add((Component)THEMIS.getContactListWithAddOption(s.search().getResultAsElementSummary(), this.fldKenntnis, true, false), "Center");
        this.panelContactsVerteiler.add((Component)THEMIS.getContactListWithAddOption(s.search().getResultAsElementSummary(), this.fldVerteiler, true, false), "Center");
        this.setUIupdating(true);
        for (int ii = 0; ii < this.fldReportLayout.getItemCount(); ++ii) {
            if (this.rep.getId() != ((CmsBasicElement)this.fldReportLayout.getModel().getElementAt(ii)).getId()) continue;
            this.fldReportLayout.setSelectedIndex(ii);
            break;
        }
        this.setUIupdating(false);
        this.fldTitel.setText(this.rep.protTitel);
        this.fldNummer.setText(this.rep.protNummer);
        this.fldVerfasser.setText(this.rep.protVerfasser);
        this.fldVersion.setText(this.rep.protVersion);
        this.fldVerteiler.setText(this.rep.protVerteiler);
        this.fldKenntnis.setText(this.rep.protKenntnis);
        this.fldEventDatum.setText(this.rep.protDatum);
        this.fldExportFolder.setText(this.app.getSettings().getFolderReportOutput().getValueAsPath(false));
        this.fldExportName.setText(this.rep.exportFilename);
        this.chkCreateFolder.setSelected(this.app.getSettings().getReportOutputWithSubfolder());
        if (this.rep.hasNewTemplateVersion() && this.app.getDialog().showConfirmDialog("Die Protokollvorlage wurde ver\u00e4ndert - soll die im Projekt gespeicherte Vorlage ersetzt werden?")) {
            this.rep.updateTemplateFile();
        }
        this.btnEditLayouts.setEnabled((selIdx = this.fldReportLayout.getSelectedIndex()) >= 0);
        this.revalidate();
    }

    @Override
    public void apply() {
        this.rep.protTitel = this.fldTitel.getText();
        this.rep.protNummer = this.fldNummer.getText();
        this.rep.protKenntnis = this.fldKenntnis.getText();
        this.rep.protVerfasser = this.fldVerfasser.getText();
        this.rep.protVersion = this.fldVersion.getText();
        this.rep.protVerteiler = this.fldVerteiler.getText();
        this.rep.protDatum = this.fldEventDatum.getText();
        this.rep.event = this.getEvent();
        this.rep.filter = this.getFilter();
        this.rep.setPeriod((String)this.fldPeriod.getSelectedItem(), this.fldPeriodYear.getText());
        this.app.getSettings().getFolderReportOutput().setValue(this.fldExportFolder.getText());
        this.app.getSettings().setReportOutputWithSubfolder(this.chkCreateFolder.isSelected());
        this.rep.exportFolder = new File(this.fldExportFolder.getText());
        this.rep.exportFilename = this.fldExportName.getText();
        this.rep.exportCreateSubfolder = this.chkCreateFolder.isSelected();
        if (this.app.getLicense().hasLicense()) {
            this.app.getSettings().setLastReportLayoutId(this.rep.getId());
            this.saveReportLayout();
        }
    }

    private void setContentType(CmsReport.Content content) {
        if (content == CmsReport.Content.SELECTION && this.project.getSelectionManager().getSelectedObservationIds().size() == 0) {
            content = CmsReport.Content.FILTER;
        }
        this.rep.contentType = content;
        boolean hideDone = this.app.getSettings().getDisplayHideDoneTask() == 2;
        this.setContentTypeFormat(this.btnSetContentFilter, false);
        this.setContentTypeFormat(this.btnSetContentEvent, false);
        this.setContentTypeFormat(this.btnSetContentSelection, false);
        this.setContentTypeFormat(this.btnSetContentPeriod, false);
        this.lblFilter.setVisible(false);
        this.fldFilter.setVisible(false);
        this.lblEvent.setVisible(false);
        this.fldEvent.setVisible(false);
        this.lblPeriod.setVisible(false);
        this.panelPeriod.setVisible(false);
        this.setEventDetails(null);
        switch (this.rep.contentType) {
            case FILTER: {
                this.setContentTypeFormat(this.btnSetContentFilter, true);
                this.lblFilter.setVisible(true);
                this.fldFilter.setVisible(true);
                break;
            }
            case EVENT: {
                this.setContentTypeFormat(this.btnSetContentEvent, true);
                this.lblEvent.setVisible(true);
                this.fldEvent.setVisible(true);
                this.setEventDetails((CmsBasicElement)this.fldEvent.getSelectedItem());
                break;
            }
            case SELECTION: {
                this.setContentTypeFormat(this.btnSetContentSelection, true);
                break;
            }
            case PERIOD: {
                this.setContentTypeFormat(this.btnSetContentPeriod, true);
                this.lblPeriod.setVisible(true);
                this.panelPeriod.setVisible(true);
            }
        }
        this.updateElementCount();
    }

    private void updateElementCount() {
        String count = "";
        this.filter.setEmptyLocation(this.rep.exportLocationsWithoutObservations);
        switch (this.rep.contentType) {
            case FILTER: {
                CmsBasicElement selFilter = (CmsBasicElement)this.fldFilter.getSelectedItem();
                if (selFilter != null) {
                    switch ((int)selFilter.getId()) {
                        case -1: {
                            this.filter.setFilter(this.app.getFilter());
                            break;
                        }
                        case -2: {
                            this.filter.setMangelFilter();
                            break;
                        }
                        case -3: {
                            this.filter.setDuedateFilter();
                            break;
                        }
                        case -9: {
                            this.filter.clearAll(false, (Object)this);
                            break;
                        }
                        default: {
                            String filtername = selFilter.getTitle();
                            this.filter.loadFilter(this.project.getFilterByName(filtername));
                        }
                    }
                }
                count = " (" + Integer.toString(this.filter.getFilteredObservations().size()) + " Eintr\u00e4ge)";
                this.lblContentDefinition.setText(this.btnSetContentFilter.getText() + count);
                break;
            }
            case EVENT: {
                CmsBasicElement selEvent = (CmsBasicElement)this.fldEvent.getSelectedItem();
                if (selEvent != null) {
                    CmsEvent ev = (CmsEvent)this.project.loadElement(selEvent.getId(), this.project.getUser());
                    count = " (" + Integer.toString(ev.getRelationAttribute("histories").size()) + " Beobachtungen)";
                }
                this.lblContentDefinition.setText(this.btnSetContentEvent.getText() + count);
                break;
            }
            case SELECTION: {
                count = " (" + Integer.toString(this.countSelected) + " Beobachtungen)";
                this.lblContentDefinition.setText(this.btnSetContentSelection.getText() + count);
                break;
            }
            case PERIOD: {
                this.lblContentDefinition.setText(this.btnSetContentPeriod.getText());
            }
        }
    }

    private void setContentTypeFormat(JButton button, boolean selected) {
        if (selected) {
            button.setBackground(THEMIS.lightblue);
            button.setForeground(THEMIS.red);
            button.setFont(THEMIS.fontLabelBold);
        } else {
            button.setBackground(THEMIS.lightgray);
            button.setForeground(THEMIS.black);
            button.setFont(THEMIS.fontButton);
        }
    }

    private void loadReportLayouts() {
        this.setUIupdating(true);
        CmsBasicElement sel = null;
        ArrayList templates = this.project.getReportTemplates();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.fldReportLayout.getModel();
        model.removeAllElements();
        for (CmsBasicElement template : templates) {
            if (template == null) continue;
            model.addElement(template);
            if (this.rep == null || template.getId() != this.rep.getId()) continue;
            sel = template;
        }
        if (sel == null && templates.size() > 0) {
            this.loadReportSpecification(((CmsBasicElement)templates.get(0)).getId());
        }
        this.setUIupdating(false);
    }

    public CmsReport loadReportSpecification(long id) {
        if (id > 0L && (this.rep == null || this.rep.getId() != id)) {
            this.loadReportSpecificationWithoutCheck(id);
        }
        if (id <= 0L || this.rep == null) {
            ArrayList reportTemplates = this.project.getReportTemplates();
            if (reportTemplates.isEmpty()) {
                this.rep = new CmsReport();
            } else {
                this.loadReportSpecificationWithoutCheck(((CmsBasicElement)reportTemplates.get(0)).getId());
                if (this.rep == null) {
                    this.rep = new CmsReport();
                }
            }
        }
        return this.rep;
    }

    private CmsReport loadReportSpecificationWithoutCheck(long id) {
        CmsElement e = this.project.loadElement(id, this.project.getUser());
        if (e != null && e instanceof CmsReport) {
            this.app.getSettings().setLastReportLayoutId(e.getId());
            this.rep = (CmsReport)e;
            return this.rep;
        }
        this.rep = null;
        return null;
    }

    public CmsReport getSelectedReportLayout() {
        CmsBasicElement sel = (CmsBasicElement)this.fldReportLayout.getSelectedItem();
        long selId = sel == null ? -1L : sel.getId();
        return this.loadReportSpecification(selId);
    }

    private void loadEvents() {
        if (!this.project.isOpen() || this.rep.summaryReport) {
            return;
        }
        this.setUIupdating(true);
        ArrayList events = this.project.getEvents();
        DefaultComboBoxModel modelEvent = (DefaultComboBoxModel)this.fldEvent.getModel();
        modelEvent.removeAllElements();
        CmsEvent currentEvent = this.app.getProject().getSelectionManager().getCurrentEvent();
        if (currentEvent != null) {
            modelEvent.addElement(new CmsBasicElement(currentEvent.getId(), NbBundle.getMessage(ReportPanel.class, (String)"ReportWizard.currentEvent.text") + " " + currentEvent.getTitle()));
        }
        for (int ii = 0; ii < events.size(); ++ii) {
            modelEvent.addElement(((CmsElementSummary)events.get(ii)).toBasicElement());
        }
        this.setUIupdating(false);
    }

    private void loadFilters() {
        if (!this.project.isOpen() || this.rep.summaryReport) {
            return;
        }
        this.setUIupdating(true);
        ArrayList filters = this.project.getFilters();
        DefaultComboBoxModel modelFilter = (DefaultComboBoxModel)this.fldFilter.getModel();
        modelFilter.removeAllElements();
        modelFilter.addElement(new CmsBasicElement(-9L, "kein Filter (alle Eintr\u00e4ge)"));
        modelFilter.addElement(new CmsBasicElement(-1L, "aktueller Filter"));
        modelFilter.addElement(new CmsBasicElement(-2L, "Offene M\u00e4ngel"));
        modelFilter.addElement(new CmsBasicElement(-3L, "Anstehende Termine"));
        for (int ii = 0; ii < filters.size(); ++ii) {
            modelFilter.addElement(filters.get(ii));
        }
        this.fldFilter.setSelectedIndex(1);
        this.setUIupdating(false);
    }

    private void setEventDetails(CmsBasicElement sel) {
        if (sel != null && "".equals(this.fldEventDatum.getText())) {
            CmsEvent ev = (CmsEvent)this.project.loadElement(sel.getId(), this.project.getUser());
            this.fldEventDatum.setText(ev.getAttributeValue("date"));
        }
    }

    public CmsEvent getEvent() {
        CmsBasicElement sel = (CmsBasicElement)this.fldEvent.getSelectedItem();
        if (this.rep.contentType == CmsReport.Content.EVENT && sel != null && sel.getId() >= 0L) {
            return (CmsEvent)this.project.loadElement(sel.getId(), this.project.getUser());
        }
        if (this.fldEvent.getSelectedIndex() == 0 && this.filter.getEventId().getList().size() == 1) {
            return (CmsEvent)this.project.loadElement(this.filter.getEventId().getFirstItem(), this.project.getUser());
        }
        return null;
    }

    public ThemisFilter getFilter() {
        return this.filter;
    }

    private void saveReportLayout() {
        if (this.rep == null) {
            return;
        }
        if (this.rep.getId() < 0L) {
            this.app.getSettings().setDefaultReportLayout((Element)this.rep.getReportAsXml().detach());
        } else {
            this.rep.save();
        }
    }

    public boolean exportReport() {
        this.apply();
        File destfile = this.rep.getDestinationFile();
        if (destfile == null) {
            Dialogs.getInstance().showWarningDialog(NbBundle.getMessage(ReportPanel.class, (String)"ReportWizard.defineNameExportFile.text"));
            return false;
        }
        File folder = destfile.getParentFile();
        try {
            folder.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!folder.isDirectory()) {
            Dialogs.getInstance().showErrorDialog("error.export-folder-error");
            return false;
        }
        if ((this.rep.exportFormat == CmsReport.ReportFormat.EXCEL || this.rep.exportFormat == CmsReport.ReportFormat.WORD) && this.rep.getTemplateFile() == null) {
            Dialogs.getInstance().showWarningDialog(NbBundle.getMessage(ReportPanel.class, (String)"ReportWizard.reportTemplateUnavailable.text"));
            return false;
        }
        this.saveReportLayout();
        Exporter exporter = new Exporter(this.project, this.rep);
        File destinationFile = this.rep.getDestinationFile();
        if (!this.rep.exportOnlyPlans) {
            if (destinationFile.exists() && !Dialogs.getInstance().showConfirmDialog(NbBundle.getMessage(ReportPanel.class, (String)"ReportWizard.overwriteFile.text"))) {
                return false;
            }
            if (destinationFile.exists()) {
                try {
                    destinationFile.delete();
                }
                catch (Exception e) {
                    this.project.getLogger().fine("cannot delete existing report: " + e.getMessage());
                }
                if (destinationFile.exists()) {
                    Dialogs.getInstance().showErrorDialog("error.fileCannotBeDeleted");
                    return false;
                }
            }
        }
        ThemisTaskWithDialog.createTaskWithCounterAndCancel("Das Protokoll wird erzeugt ...", ph -> {
            try {
                String exportResult = exporter.run(ph);
                if (ph.isCancelled()) {
                    return;
                }
                if (exportResult != null) {
                    THEMIS.notify(3, "Protokoll erstellen", "Das Protokoll konnte nicht erstellt werden (Fehlercode '" + exportResult + "')");
                } else if (destinationFile.isFile()) {
                    THEMIS.showFileResultDialog(destinationFile);
                } else if (this.rep.exportOnlyPlans) {
                    THEMIS.notify(1, "Protokoll erstellen", "Es wurden nur Pl\u00e4ne exportiert");
                    THEMIS.showFileResultDialog(destinationFile, false);
                }
            }
            catch (Exception e) {
                Dialogs.getInstance().showErrorDialog(e.getMessage(), e);
                e.printStackTrace();
            }
        });
        return true;
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.panelReportHeader = new JPanel();
        this.panelProtokollKopf = new JPanel();
        this.lblReportlayoutHeading = new JLabel();
        this.lblReportLayout = new JLabel();
        this.panelReportLayout = new JPanel();
        this.fldReportLayout = new JComboBox();
        this.btnEditLayouts = new JButton();
        this.jLabel34 = new JLabel();
        this.panelContentDefinition = new JPanel();
        this.btnSetContentFilter = new JButton();
        this.btnSetContentEvent = new JButton();
        this.btnSetContentPeriod = new JButton();
        this.btnSetContentSelection = new JButton();
        this.lblEvent = new JLabel();
        this.fldEvent = new JComboBox();
        this.lblFilter = new JLabel();
        this.fldFilter = new JComboBox();
        this.lblContentDefinition = new JLabel();
        this.lblPeriod = new JLabel();
        this.panelPeriod = new JPanel();
        this.fldPeriod = new JComboBox();
        this.jLabel73 = new JLabel();
        this.fldPeriodYear = new JTextField();
        this.jLabel90 = new JLabel();
        this.lblProtokollKopf = new JLabel();
        this.jLabel29 = new JLabel();
        this.fldTitel = new JTextField();
        this.jLabel1 = new JLabel();
        this.fldNummer = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldVersion = new JTextField();
        this.jLabel2 = new JLabel();
        this.fldVerfasser = new JTextField();
        this.jLabel47 = new JLabel();
        this.fldEventDatum = new JTextField();
        this.btnAddDate = new JButton();
        this.jLabel3 = new JLabel();
        this.panelContactsVerteiler = new JPanel();
        this.jLabel6 = new JLabel();
        this.panelContactsKenntnis = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.fldVerteiler = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.fldKenntnis = new JTextArea();
        this.jLabel72 = new JLabel();
        this.jLabel10 = new JLabel();
        this.panelSignatures = new JPanel();
        this.btnSignature1 = new JButton();
        this.jLabel8 = new JLabel();
        this.jPanel2 = new JPanel();
        this.fldExportFolder = new JTextField();
        this.btnSelectFolder = new JButton();
        this.jLabel9 = new JLabel();
        this.jPanel3 = new JPanel();
        this.fldExportName = new JTextField();
        this.jLabel12 = new JLabel();
        this.jPanel4 = new JPanel();
        this.chkCreateFolder = new JCheckBox();
        this.panelButtons = new JPanel();
        this.btnExport3 = new JButton();
        this.btnExport2 = new JButton();
        this.btnClose = new JButton();
        this.setMinimumSize(new Dimension(900, 600));
        this.setPreferredSize(new Dimension(900, 600));
        this.setLayout(new GridBagLayout());
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.panelReportHeader.setPreferredSize(new Dimension(840, 600));
        this.panelReportHeader.setLayout(new GridBagLayout());
        this.panelProtokollKopf.setLayout(new GridBagLayout());
        this.lblReportlayoutHeading.setFont(THEMIS.fontSubheading);
        this.lblReportlayoutHeading.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.lblReportlayoutHeading.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.lblReportlayoutHeading, gridBagConstraints);
        this.lblReportLayout.setFont(THEMIS.fontLabel);
        this.lblReportLayout.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.lblReportLayout.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.lblReportLayout, gridBagConstraints);
        this.panelReportLayout.setLayout(new GridBagLayout());
        this.fldReportLayout.setFont(THEMIS.fontList);
        this.fldReportLayout.setModel(new DefaultComboBoxModel());
        this.fldReportLayout.setMinimumSize(new Dimension(100, 30));
        this.fldReportLayout.setPreferredSize(new Dimension(100, 30));
        this.fldReportLayout.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportPanel.this.fldReportLayoutItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelReportLayout.add(this.fldReportLayout, gridBagConstraints);
        this.btnEditLayouts.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_editObs24.gif")));
        this.btnEditLayouts.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnEditLayouts.text"));
        this.btnEditLayouts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnEditLayoutsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelReportLayout.add((Component)this.btnEditLayouts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelProtokollKopf.add((Component)this.panelReportLayout, gridBagConstraints);
        this.jLabel34.setFont(THEMIS.fontSubheading);
        this.jLabel34.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel34.text"));
        this.jLabel34.setMinimumSize(null);
        this.jLabel34.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel34, gridBagConstraints);
        this.panelContentDefinition.setLayout(new GridBagLayout());
        this.btnSetContentFilter.setFont(THEMIS.fontButton);
        this.btnSetContentFilter.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnSetContentFilter.text"));
        this.btnSetContentFilter.setPreferredSize(new Dimension(100, 30));
        this.btnSetContentFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnSetContentFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContentDefinition.add((Component)this.btnSetContentFilter, gridBagConstraints);
        this.btnSetContentEvent.setFont(THEMIS.fontButton);
        this.btnSetContentEvent.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnSetContentEvent.text"));
        this.btnSetContentEvent.setPreferredSize(new Dimension(100, 30));
        this.btnSetContentEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnSetContentEventActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContentDefinition.add((Component)this.btnSetContentEvent, gridBagConstraints);
        this.btnSetContentPeriod.setFont(THEMIS.fontButton);
        this.btnSetContentPeriod.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnSetContentPeriod.text"));
        this.btnSetContentPeriod.setPreferredSize(new Dimension(100, 30));
        this.btnSetContentPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnSetContentPeriodActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContentDefinition.add((Component)this.btnSetContentPeriod, gridBagConstraints);
        this.btnSetContentSelection.setFont(THEMIS.fontButton);
        this.btnSetContentSelection.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnSetContentSelection.text"));
        this.btnSetContentSelection.setPreferredSize(new Dimension(100, 30));
        this.btnSetContentSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnSetContentSelectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelContentDefinition.add((Component)this.btnSetContentSelection, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelProtokollKopf.add((Component)this.panelContentDefinition, gridBagConstraints);
        this.lblEvent.setFont(THEMIS.fontLabel);
        this.lblEvent.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.lblEvent.text"));
        this.lblEvent.setMinimumSize(null);
        this.lblEvent.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.lblEvent, gridBagConstraints);
        this.fldEvent.setFont(THEMIS.fontList);
        this.fldEvent.setModel(new DefaultComboBoxModel());
        this.fldEvent.setMinimumSize(new Dimension(100, 30));
        this.fldEvent.setPreferredSize(new Dimension(100, 30));
        this.fldEvent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportPanel.this.fldEventItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.fldEvent, gridBagConstraints);
        this.lblFilter.setFont(THEMIS.fontLabel);
        this.lblFilter.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.lblFilter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.lblFilter, gridBagConstraints);
        this.fldFilter.setFont(THEMIS.fontList);
        this.fldFilter.setModel(new DefaultComboBoxModel());
        this.fldFilter.setMinimumSize(new Dimension(100, 30));
        this.fldFilter.setPreferredSize(new Dimension(100, 30));
        this.fldFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ReportPanel.this.fldFilterItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.fldFilter, gridBagConstraints);
        this.lblContentDefinition.setFont(THEMIS.fontLabelBold);
        this.lblContentDefinition.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.lblContentDefinition.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panelProtokollKopf.add((Component)this.lblContentDefinition, gridBagConstraints);
        this.lblPeriod.setFont(THEMIS.fontLabel);
        this.lblPeriod.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.lblPeriod.text"));
        this.lblPeriod.setMinimumSize(null);
        this.lblPeriod.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.lblPeriod, gridBagConstraints);
        this.panelPeriod.setLayout(new GridBagLayout());
        this.fldPeriod.setFont(THEMIS.fontList);
        this.fldPeriod.setModel(new DefaultComboBoxModel<String>(new String[]{"Jahr", "Q1", "Q2", "Q3", "Q4", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPeriod.add(this.fldPeriod, gridBagConstraints);
        this.jLabel73.setFont(THEMIS.fontLabel);
        this.jLabel73.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel73.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPeriod.add((Component)this.jLabel73, gridBagConstraints);
        this.fldPeriodYear.setFont(THEMIS.fontTextfield);
        this.fldPeriodYear.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.fldPeriodYear.text"));
        this.fldPeriodYear.setMinimumSize(new Dimension(100, 30));
        this.fldPeriodYear.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPeriod.add((Component)this.fldPeriodYear, gridBagConstraints);
        this.jLabel90.setFont(THEMIS.fontLabel);
        this.jLabel90.setForeground(new Color(102, 102, 102));
        this.jLabel90.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel90.text"));
        this.jLabel90.setMaximumSize(null);
        this.jLabel90.setPreferredSize(new Dimension(100, 35));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelPeriod.add((Component)this.jLabel90, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panelProtokollKopf.add((Component)this.panelPeriod, gridBagConstraints);
        this.lblProtokollKopf.setFont(THEMIS.fontSubheading);
        this.lblProtokollKopf.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.lblProtokollKopf.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.lblProtokollKopf, gridBagConstraints);
        this.jLabel29.setFont(THEMIS.fontLabel);
        this.jLabel29.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel29.text"));
        this.jLabel29.setVerticalAlignment(1);
        this.jLabel29.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel29, gridBagConstraints);
        this.fldTitel.setFont(THEMIS.fontTextfield);
        this.fldTitel.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.fldTitel.text"));
        this.fldTitel.setMaximumSize(null);
        this.fldTitel.setMinimumSize(null);
        this.fldTitel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.fldTitel, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabel);
        this.jLabel1.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel1.text"));
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel1.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel1, gridBagConstraints);
        this.fldNummer.setFont(THEMIS.fontTextfield);
        this.fldNummer.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.fldNummer.text"));
        this.fldNummer.setMaximumSize(null);
        this.fldNummer.setMinimumSize(null);
        this.fldNummer.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.fldNummer, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabel);
        this.jLabel5.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel5.text"));
        this.jLabel5.setVerticalAlignment(1);
        this.jLabel5.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel5, gridBagConstraints);
        this.fldVersion.setFont(THEMIS.fontTextfield);
        this.fldVersion.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.fldVersion.text"));
        this.fldVersion.setMaximumSize(null);
        this.fldVersion.setMinimumSize(null);
        this.fldVersion.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.fldVersion, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabel);
        this.jLabel2.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel2.text"));
        this.jLabel2.setVerticalAlignment(1);
        this.jLabel2.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel2, gridBagConstraints);
        this.fldVerfasser.setFont(THEMIS.fontTextfield);
        this.fldVerfasser.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.fldVerfasser.text"));
        this.fldVerfasser.setMaximumSize(null);
        this.fldVerfasser.setMinimumSize(null);
        this.fldVerfasser.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.fldVerfasser, gridBagConstraints);
        this.jLabel47.setFont(THEMIS.fontLabel);
        this.jLabel47.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel47.text"));
        this.jLabel47.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel47, gridBagConstraints);
        this.fldEventDatum.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.fldEventDatum.text"));
        this.fldEventDatum.setMaximumSize(null);
        this.fldEventDatum.setMinimumSize(null);
        this.fldEventDatum.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.fldEventDatum, gridBagConstraints);
        this.btnAddDate.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/calendar.gif")));
        this.btnAddDate.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnAddDate.text"));
        this.btnAddDate.setBorder(new SoftBevelBorder(0));
        this.btnAddDate.setMinimumSize(new Dimension(30, 30));
        this.btnAddDate.setPreferredSize(new Dimension(30, 30));
        this.btnAddDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnAddDateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.panelProtokollKopf.add((Component)this.btnAddDate, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        this.jLabel3.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel3.text"));
        this.jLabel3.setVerticalAlignment(1);
        this.jLabel3.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel3, gridBagConstraints);
        this.panelContactsVerteiler.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panelProtokollKopf.add((Component)this.panelContactsVerteiler, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        this.jLabel6.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel6.text"));
        this.jLabel6.setVerticalAlignment(1);
        this.jLabel6.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel6, gridBagConstraints);
        this.panelContactsKenntnis.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.panelProtokollKopf.add((Component)this.panelContactsKenntnis, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(200, 150));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 150));
        this.fldVerteiler.setColumns(20);
        this.fldVerteiler.setFont(THEMIS.fontTextfield);
        this.fldVerteiler.setLineWrap(true);
        this.fldVerteiler.setRows(5);
        this.fldVerteiler.setWrapStyleWord(true);
        this.fldVerteiler.setMinimumSize(new Dimension(200, 22));
        this.fldVerteiler.setPreferredSize(null);
        this.jScrollPane1.setViewportView(this.fldVerteiler);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(200, 150));
        this.jScrollPane2.setPreferredSize(new Dimension(200, 150));
        this.jScrollPane2.setRequestFocusEnabled(false);
        this.fldKenntnis.setColumns(20);
        this.fldKenntnis.setFont(THEMIS.fontTextfield);
        this.fldKenntnis.setLineWrap(true);
        this.fldKenntnis.setRows(5);
        this.fldKenntnis.setWrapStyleWord(true);
        this.fldKenntnis.setMinimumSize(new Dimension(200, 22));
        this.fldKenntnis.setPreferredSize(null);
        this.jScrollPane2.setViewportView(this.fldKenntnis);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabel72.setFont(THEMIS.fontSubheading);
        this.jLabel72.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel72.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel72, gridBagConstraints);
        this.jLabel10.setFont(THEMIS.fontLabel);
        this.jLabel10.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel10.text"));
        this.jLabel10.setMinimumSize(null);
        this.jLabel10.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel10, gridBagConstraints);
        this.panelSignatures.setLayout(new GridBagLayout());
        this.btnSignature1.setFont(THEMIS.fontButton);
        this.btnSignature1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/signature32.gif")));
        this.btnSignature1.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnSignature1.text"));
        this.btnSignature1.setBorder(new SoftBevelBorder(0));
        this.btnSignature1.setPreferredSize(new Dimension(250, 40));
        this.btnSignature1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnSignature1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSignatures.add((Component)this.btnSignature1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelProtokollKopf.add((Component)this.panelSignatures, gridBagConstraints);
        this.jLabel8.setFont(THEMIS.fontLabel);
        this.jLabel8.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel8.text"));
        this.jLabel8.setMinimumSize(null);
        this.jLabel8.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel8, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.fldExportFolder.setEditable(false);
        this.fldExportFolder.setFont(THEMIS.fontTextfield);
        this.fldExportFolder.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.fldExportFolder.text"));
        this.fldExportFolder.setMinimumSize(new Dimension(100, 30));
        this.fldExportFolder.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldExportFolder, gridBagConstraints);
        this.btnSelectFolder.setFont(THEMIS.fontButton);
        this.btnSelectFolder.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnSelectFolder.text"));
        this.btnSelectFolder.setBorder(new SoftBevelBorder(0));
        this.btnSelectFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnSelectFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnSelectFolder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelProtokollKopf.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        this.jLabel9.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel9.text"));
        this.jLabel9.setMinimumSize(null);
        this.jLabel9.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProtokollKopf.add((Component)this.jLabel9, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.fldExportName.setFont(THEMIS.fontTextfield);
        this.fldExportName.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.fldExportName.text"));
        this.fldExportName.setToolTipText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.fldExportName.toolTipText"));
        this.fldExportName.setMaximumSize(null);
        this.fldExportName.setMinimumSize(null);
        this.fldExportName.setPreferredSize(null);
        this.fldExportName.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                ReportPanel.this.fldExportNameInputMethodTextChanged(evt);
            }
        });
        this.fldExportName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.fldExportNameActionPerformed(evt);
            }
        });
        this.fldExportName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ReportPanel.this.fldExportNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.fldExportName, gridBagConstraints);
        this.jLabel12.setFont(THEMIS.fontLabel);
        this.jLabel12.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel12.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jLabel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelProtokollKopf.add((Component)this.jPanel3, gridBagConstraints);
        this.chkCreateFolder.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.chkCreateFolder.text"));
        this.jPanel4.add(this.chkCreateFolder);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelProtokollKopf.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelReportHeader.add((Component)this.panelProtokollKopf, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.panelReportHeader);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane3, gridBagConstraints);
        this.panelButtons.setMinimumSize(new Dimension(100, 50));
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnExport3.setFont(THEMIS.fontButton);
        this.btnExport3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/saveProtocol24.gif")));
        this.btnExport3.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnExport3.text"));
        this.btnExport3.setBorder(new SoftBevelBorder(0));
        this.btnExport3.setMinimumSize(new Dimension(150, 40));
        this.btnExport3.setPreferredSize(new Dimension(200, 30));
        this.btnExport3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnExport3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnExport3, gridBagConstraints);
        this.btnExport2.setFont(THEMIS.fontButton);
        this.btnExport2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/saveProtocol24.gif")));
        this.btnExport2.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnExport2.text"));
        this.btnExport2.setBorder(new SoftBevelBorder(0));
        this.btnExport2.setMinimumSize(new Dimension(150, 40));
        this.btnExport2.setPreferredSize(new Dimension(100, 30));
        this.btnExport2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnExport2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnExport2, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontButton);
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        this.btnClose.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.btnClose.text"));
        this.btnClose.setBorder(new SoftBevelBorder(0));
        this.btnClose.setMinimumSize(new Dimension(150, 40));
        this.btnClose.setPreferredSize(new Dimension(100, 30));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void btnSelectFolderActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.project.getResourceText("dialog.select-folder.title"), ThemisFileDialog.DIALOGTYPE.DIRECTORY, this.rep.exportFolder, null, null, null, false).getSelectedFile();
        if (f != null) {
            this.fldExportFolder.setText(f.getAbsolutePath());
            this.rep.exportFolder = f;
        }
    }

    private void fldExportNameActionPerformed(ActionEvent evt) {
        this.exportReport();
    }

    private void btnSignature1ActionPerformed(ActionEvent evt) {
        this.rep.signatures = THEMIS.getSignatures(this.rep.signatures);
    }

    private void fldExportNameInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void fldExportNameKeyReleased(KeyEvent evt) {
    }

    private void fldEventItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setContentType(this.rep.contentType);
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.apply();
        this.closeDialog();
    }

    private void btnSetContentFilterActionPerformed(ActionEvent evt) {
        this.setContentType(CmsReport.Content.FILTER);
    }

    private void btnSetContentSelectionActionPerformed(ActionEvent evt) {
        this.setContentType(CmsReport.Content.SELECTION);
    }

    private void btnSetContentEventActionPerformed(ActionEvent evt) {
        this.setContentType(CmsReport.Content.EVENT);
    }

    private void btnExport3ActionPerformed(ActionEvent evt) {
    }

    private void btnExport2ActionPerformed(ActionEvent evt) {
        this.exportReport();
    }

    private void fldReportLayoutItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.rep != null && !this.isUIupdating()) {
            this.apply();
            this.rep = this.getSelectedReportLayout();
            this.populate();
        }
    }

    private void btnEditLayoutsActionPerformed(ActionEvent evt) {
        this.apply();
        CmsBasicElement sel = (CmsBasicElement)this.fldReportLayout.getSelectedItem();
        long selId = sel == null ? -1L : sel.getId();
        CmsReport e = (CmsReport)this.project.loadElement(selId, this.project.getUser());
        if (e != null) {
            ReportLayoutEditorPanel panel = new ReportLayoutEditorPanel(e, null);
            try {
                panel.showDialog();
                this.populate(null);
                if (e.isSaved()) {
                    this.rep = e;
                    this.populate();
                }
            }
            catch (Exception ex) {
                this.app.getDialog().showErrorDialog("EventReportAction.errorFileExists.text");
            }
        }
    }

    private void btnSetContentPeriodActionPerformed(ActionEvent evt) {
        this.setContentType(CmsReport.Content.PERIOD);
    }

    private void fldFilterItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setContentType(this.rep.contentType);
        }
    }

    private void btnAddDateActionPerformed(ActionEvent evt) {
        String dt = Util.formatDate((Date)new Date(), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()) + " ";
        this.fldEventDatum.setText(dt);
    }

    private void showExportAssistantStep() {
    }

    @Override
    public String getDialogCode() {
        return "reportpanel";
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(870, 600);
    }

    @Override
    public Dimension getPanelSize() {
        return new Dimension(870, 790);
    }
}

