/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.report;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.config.ReportLayoutWizardIntervace;
import at.grid.themis.application.report.layout.LayoutTableEditor2;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.util.ProgressHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.SoftBevelBorder;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReportTableLayoutManagerPanel
extends ThemisPanel {
    ReportLayoutWizardIntervace wizard = null;
    private JButton btnAddTableLayout;
    private JButton btnCopyTableLayout;
    private JButton btnDeleteTableLayout;
    private JButton btnEditTableLayout;
    private JButton btnLoad;
    private JButton btnSave;
    private JButton jButton1;
    private JLabel jLabel7;
    private JLabel lblHeader;
    private JList<ReportTableLayout> lstTableLayout;
    private JPanel panelButton;
    private JPanel panelControlButtons;
    private JScrollPane scrollPane;

    public ReportTableLayoutManagerPanel(ReportLayoutWizardIntervace wizard) {
        this.initComponents();
        this.btnLoad.setVisible(false);
        this.btnSave.setVisible(false);
        this.lstTableLayout.setCellRenderer(new SimpleTextRenderer());
        this.wizard = wizard;
        if (this.wizard != null) {
            this.panelButton.setVisible(false);
        } else {
            this.populate();
        }
        new DropTarget(this.lstTableLayout, new ThemisDropTargetListener(false, false, new String[]{"layout"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ReportTableLayoutManagerPanel.this.app.setPathTemplateLocationObservation(f.getParentFile());
                ReportTableLayoutManagerPanel.this.loadTableLayout(f);
            }
        });
    }

    @Override
    public void populate(ProgressHandler ph) {
        DefaultListModel modelLayout = (DefaultListModel)this.lstTableLayout.getModel();
        modelLayout.clear();
        for (ReportTableLayout rtl : this.project.getReportTableLayouts()) {
            int idx = -1;
            for (int ii = 0; ii < modelLayout.getSize(); ++ii) {
                if (!((ReportTableLayout)modelLayout.get(ii)).getName().equals(rtl.getName())) continue;
                idx = ii;
                break;
            }
            if (idx >= 0) {
                modelLayout.remove(idx);
                modelLayout.add(idx, rtl);
                continue;
            }
            this.addReportTableLayout(rtl);
        }
    }

    @Override
    public void apply() {
        DefaultListModel modelTableLayout = (DefaultListModel)this.lstTableLayout.getModel();
        for (int ii = 0; ii < modelTableLayout.size(); ++ii) {
            ((ReportTableLayout)modelTableLayout.get(ii)).save();
        }
    }

    private void addReportTableLayout(ReportTableLayout rtl) {
        ((DefaultListModel)this.lstTableLayout.getModel()).addElement(rtl);
        this.updateSettings();
    }

    private void editSelected() {
        ReportTableLayout rtl = this.lstTableLayout.getSelectedValue();
        if (rtl == null) {
            return;
        }
        ArrayList layoutNames = this.project.getReportTableNames();
        layoutNames.remove(rtl.getName());
        LayoutTableEditor2 panelTable = new LayoutTableEditor2(rtl);
        panelTable.setForbiddenNames(layoutNames);
        panelTable.showDialog();
        if (panelTable.doSave()) {
            rtl.save();
            this.lstTableLayout.repaint();
            this.updateSettings();
            if (this.wizard != null) {
                this.wizard.populateReportLayoutList();
            }
        }
    }

    private void updateSettings() {
        DefaultListModel model = (DefaultListModel)this.lstTableLayout.getModel();
        for (int ii = 0; ii < model.size(); ++ii) {
            ((ReportTableLayout)model.elementAt(ii)).save();
        }
    }

    private void loadTableLayout(File f) {
        if (f == null) {
            f = new ThemisFileDialog(this.project.getResourceText("dialog.load-report-layout"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getPathTemplateLocationObservation(), null, THEMIS.getLayoutFilter(), "layout", false).getSelectedFile();
        }
        if (f != null) {
            this.app.setPathTemplateLocationObservation(f.getParentFile());
            try {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(f);
                Element layout = (Element)doc.getRootElement().detach();
                ReportTableLayout newLayout = (ReportTableLayout)this.project.createElement("reporttable");
                if (layout.getChild("tables") != null) {
                    newLayout.fromXML(layout.getChild("tables").getChild("layout"));
                } else {
                    newLayout.fromXML(layout);
                }
                newLayout.setName(this.project.getNewReportTableName(newLayout.getName()));
                newLayout.save();
                this.populate(null);
                if (this.wizard != null) {
                    this.wizard.populateReportLayoutList();
                }
            }
            catch (JDOMException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void initComponents() {
        this.lblHeader = new JLabel();
        this.scrollPane = new JScrollPane();
        this.lstTableLayout = new JList();
        this.panelControlButtons = new JPanel();
        this.btnAddTableLayout = new JButton();
        this.btnEditTableLayout = new JButton();
        this.btnCopyTableLayout = new JButton();
        this.btnDeleteTableLayout = new JButton();
        this.jLabel7 = new JLabel();
        this.btnSave = new JButton();
        this.btnLoad = new JButton();
        this.panelButton = new JPanel();
        this.jButton1 = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblHeader.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblHeader, (String)NbBundle.getMessage(ReportTableLayoutManagerPanel.class, (String)"ReportTableLayoutManagerPanel.lblHeader.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblHeader, gridBagConstraints);
        this.scrollPane.setMinimumSize(new Dimension(230, 160));
        this.scrollPane.setPreferredSize(new Dimension(230, 160));
        this.lstTableLayout.setFont(THEMIS.fontList);
        this.lstTableLayout.setModel(new DefaultListModel());
        this.lstTableLayout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ReportTableLayoutManagerPanel.this.lstTableLayoutMouseClicked(evt);
            }
        });
        this.scrollPane.setViewportView(this.lstTableLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.panelControlButtons.setLayout(new GridBagLayout());
        this.btnAddTableLayout.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddTableLayout, (String)NbBundle.getMessage(ReportTableLayoutManagerPanel.class, (String)"ReportTableLayoutManagerPanel.btnAddTableLayout.text"));
        this.btnAddTableLayout.setMaximumSize(null);
        this.btnAddTableLayout.setMinimumSize(null);
        this.btnAddTableLayout.setPreferredSize(null);
        this.btnAddTableLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportTableLayoutManagerPanel.this.btnAddTableLayoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnAddTableLayout, gridBagConstraints);
        this.btnEditTableLayout.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit-24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEditTableLayout, (String)NbBundle.getMessage(ReportTableLayoutManagerPanel.class, (String)"ReportTableLayoutManagerPanel.btnEditTableLayout.text"));
        this.btnEditTableLayout.setMaximumSize(null);
        this.btnEditTableLayout.setMinimumSize(null);
        this.btnEditTableLayout.setPreferredSize(null);
        this.btnEditTableLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportTableLayoutManagerPanel.this.btnEditTableLayoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnEditTableLayout, gridBagConstraints);
        this.btnCopyTableLayout.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopyTableLayout, (String)NbBundle.getMessage(ReportTableLayoutManagerPanel.class, (String)"ReportTableLayoutManagerPanel.btnCopyTableLayout.text"));
        this.btnCopyTableLayout.setMaximumSize(null);
        this.btnCopyTableLayout.setMinimumSize(null);
        this.btnCopyTableLayout.setPreferredSize(null);
        this.btnCopyTableLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportTableLayoutManagerPanel.this.btnCopyTableLayoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnCopyTableLayout, gridBagConstraints);
        this.btnDeleteTableLayout.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteTableLayout, (String)NbBundle.getMessage(ReportTableLayoutManagerPanel.class, (String)"ReportTableLayoutManagerPanel.btnDeleteTableLayout.text"));
        this.btnDeleteTableLayout.setMaximumSize(null);
        this.btnDeleteTableLayout.setMinimumSize(null);
        this.btnDeleteTableLayout.setPreferredSize(null);
        this.btnDeleteTableLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportTableLayoutManagerPanel.this.btnDeleteTableLayoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnDeleteTableLayout, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ReportTableLayoutManagerPanel.class, (String)"ReportTableLayoutManagerPanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panelControlButtons.add((Component)this.jLabel7, gridBagConstraints);
        this.btnSave.setFont(THEMIS.fontButton);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/saveProtocol24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSave, (String)NbBundle.getMessage(ReportTableLayoutManagerPanel.class, (String)"ReportTableLayoutManagerPanel.btnSave.text"));
        this.btnSave.setBorder(new SoftBevelBorder(0));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportTableLayoutManagerPanel.this.btnSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnSave, gridBagConstraints);
        this.btnLoad.setFont(THEMIS.fontButton);
        this.btnLoad.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/openFile_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLoad, (String)NbBundle.getMessage(ReportTableLayoutManagerPanel.class, (String)"ReportTableLayoutManagerPanel.btnLoad.text"));
        this.btnLoad.setBorder(new SoftBevelBorder(0));
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportTableLayoutManagerPanel.this.btnLoadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelControlButtons.add((Component)this.btnLoad, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.panelControlButtons, gridBagConstraints);
        this.panelButton.setLayout(new GridBagLayout());
        this.jButton1.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ReportTableLayoutManagerPanel.class, (String)"ReportTableLayoutManagerPanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportTableLayoutManagerPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        this.panelButton.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButton, gridBagConstraints);
    }

    private void btnDeleteTableLayoutActionPerformed(ActionEvent evt) {
        if (this.lstTableLayout.getSelectedValue() == null) {
            return;
        }
        if (Dialogs.getInstance().showConfirmDialog("dialog.delete-reporttablelayout.message", "dialog.delete-reporttablelayout.title")) {
            for (ReportTableLayout rtl : this.lstTableLayout.getSelectedValuesList()) {
                ((DefaultListModel)this.lstTableLayout.getModel()).removeElement(rtl);
            }
            this.updateSettings();
            if (this.wizard != null) {
                this.wizard.populateReportLayoutList();
            }
        }
    }

    private void btnCopyTableLayoutActionPerformed(ActionEvent evt) {
        ReportTableLayout rtl = this.lstTableLayout.getSelectedValue();
        if (rtl == null) {
            return;
        }
        ReportTableLayout rtlNew = (ReportTableLayout)this.project.createElement("reporttable");
        rtlNew.setName(this.project.getNewReportTableName(rtlNew.getName()));
        rtlNew.fromXML(rtl.getXml());
        rtlNew.save();
        this.addReportTableLayout(rtlNew);
        if (this.wizard != null) {
            this.wizard.populateReportLayoutList();
        }
    }

    private void btnEditTableLayoutActionPerformed(ActionEvent evt) {
        this.editSelected();
    }

    private void btnAddTableLayoutActionPerformed(ActionEvent evt) {
        LayoutTableEditor2 panelTable = new LayoutTableEditor2("Neues Layout");
        panelTable.showDialog();
        if (panelTable.doSave()) {
            ReportTableLayout rtl = panelTable.getTableLayout();
            rtl.save();
            ((DefaultListModel)this.lstTableLayout.getModel()).addElement(rtl);
            this.updateSettings();
            if (this.wizard != null) {
                this.wizard.populateReportLayoutList();
            }
        }
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
    }

    private void btnLoadActionPerformed(ActionEvent evt) {
        File fld = this.app.getSettings().getFolderReportTemplate().getValue(true);
        List<File> files = new ThemisFileDialog("Protokollvorlagen laden", ThemisFileDialog.DIALOGTYPE.OPEN, ThemisApplication.getInstance().getSettings().getFolderReportTemplate().getValue(true), null, THEMIS.getThemisFileFilter(), null, true).getSelectedFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            this.app.getSettings().getFolderReportTemplate().setValue(f.getParentFile());
            ThemisFile tf = new ThemisFile().setContentType(ThemisFile.ContentType.REPORTTEMPLATE);
            try {
                tf.loadFromFile(f, false);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (JDOMException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.populate();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void lstTableLayoutMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.editSelected();
        }
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(600, 500);
    }
}

