/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.report.doc;

import at.grid.cms.CmsApplication;
import at.grid.cms.content.UploadItem;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.report.LayoutCell;
import at.grid.themis.ontology.report.LayoutRow;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.ReportGenerator;
import at.grid.themis.ontology.signature.ThemisSignature;
import at.grid.util.Dimension;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.LineSpacingRule;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.openide.util.Exceptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabStop;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabs;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblLayoutType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHeightRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTabJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblLayoutType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class WordReportGenerator
extends ReportGenerator {
    public final ParagraphFormat FORMAT_HEADING = new ParagraphFormat(14, true, true, 300);
    public final ParagraphFormat FORMAT_HEADING2 = new ParagraphFormat(12, true, false, 200);
    public final ParagraphFormat FORMAT_TEXT = new ParagraphFormat(10, false, false, 100);
    public final ParagraphFormat FORMAT_SMALLTEXT = new ParagraphFormat(8, false, false, 100);
    public final ParagraphFormat FORMAT_SMALLTEXT_BOLD = new ParagraphFormat(8, true, false, 100);
    public final ParagraphFormat FORMAT_BOLD = new ParagraphFormat(10, true, false, 100);
    public static String FORMAT_FONT = "Tahoma";
    HashMap<String, String> tableFonts = new HashMap();
    XWPFDocument document;
    boolean firstTableRow = true;
    int tableHeaderRows = 0;
    XWPFParagraph specificContentPara = null;
    protected XWPFParagraph currentParagraph = null;
    HashMap<String, XWPFParagraph> contentTables = new HashMap();
    HashMap<String, XWPFRun> contentSpecial = new HashMap();
    protected XWPFParagraph imagelistParagraph = null;
    protected XWPFParagraph signatureParagraph = null;
    protected float imagelistImagesize = -1.0f;
    int imagelistCountPerPage = 0;
    public static Placeholder placeholder;
    protected XWPFTable table = null;
    protected XWPFTableRow tableRow = null;
    protected XWPFTableCell tableCell = null;
    protected float[] colWidthsCm;
    protected int tableCellPos = 0;

    public WordReportGenerator(CmsReport rep) throws FileNotFoundException, IOException {
        super(rep);
        placeholder = new Placeholder(rep);
        File f = rep.getTemplateFile();
        if (f != null && f.isFile()) {
            FileInputStream is = new FileInputStream(f);
            this.document = new XWPFDocument((InputStream)is);
            is.close();
        } else {
            this.document = new XWPFDocument();
        }
    }

    public void analyseReportTemplate() {
        for (XWPFParagraph para : this.document.getParagraphs()) {
            this.updateParagraph(para);
        }
    }

    public Set<String> getTableNames() {
        return this.contentTables.keySet();
    }

    public void createReport(File destinationFile, ProgressHandler progressHandle, int phFrom, int phTo) throws IOException {
        String text;
        this.progress = progressHandle;
        this.progressFrom = phFrom;
        this.progressTo = phTo;
        if (this.progress != null) {
            this.progress.setDisplayName("Bericht wird erzeugt");
        }
        this.progressCurrent = this.progressFrom;
        if (placeholder == null) {
            placeholder = new Placeholder(this.rep);
        } else {
            placeholder.setReportSpecification(this.rep);
        }
        placeholder.clearSpecialPlaceholder();
        ThemisFilter filter = new ThemisFilter(this.app);
        filter.setFilter(this.app.getFilter());
        filter.setTriggerEnabled(false);
        for (XWPFParagraph para : this.document.getParagraphs()) {
            this.updateParagraph(para);
        }
        for (XWPFTable table : this.document.getTables()) {
            for (XWPFTableRow rw : table.getRows()) {
                for (XWPFTableCell cell : rw.getTableCells()) {
                    for (XWPFParagraph para2 : cell.getParagraphs()) {
                        this.updateParagraph(para2);
                    }
                }
            }
        }
        for (XWPFFooter footer : this.document.getFooterList()) {
            for (XWPFParagraph paraFooter : footer.getParagraphs()) {
                text = paraFooter.getText();
                this.updateParagraph(paraFooter);
            }
        }
        for (XWPFHeader header : this.document.getHeaderList()) {
            for (XWPFParagraph paraHeader : header.getParagraphs()) {
                text = paraHeader.getText();
                this.updateParagraph(paraHeader);
            }
        }
        for (String tablename : this.contentTables.keySet()) {
            if (!this.project.hasReportTableLayout(tablename)) {
                this.app.getDialog().showErrorDialog("<html>Die in der Vorlage geforderte Tabelle '" + tablename + "' ist im Projekt nicht definiert. Pr\u00fcfen Sie die verf\u00fcgbaren Tabellen in den Projekteinstellungen.</html>");
                continue;
            }
            FORMAT_FONT = this.tableFonts.get(tablename);
            this.currentParagraph = this.contentTables.get(tablename);
            this.currentParagraph.removeRun(0);
            this.createTable(tablename);
        }
        if (this.signatureParagraph != null) {
            this.addSignatures(this.signatureParagraph);
        }
        this.addSpecialContents();
        if (this.imagelistParagraph != null) {
            this.currentParagraph = this.imagelistParagraph;
            this.currentParagraph.removeRun(0);
            HashMap imageIds = this.ph.getImageIds();
            Map imageIdsSorted = WordReportGenerator.sortByValue(imageIds);
            int count = 0;
            for (Long uploadId : imageIdsSorted.keySet()) {
                Integer number = (Integer)imageIds.get(uploadId);
                UploadItem item = new UploadItem((CmsApplication)this.project, uploadId.longValue());
                File imageFile = item.getFile();
                XWPFRun run = this.currentParagraph.createRun();
                this.addImageToRun(run, this.project.getDrawings(uploadId.longValue()), imageFile, ReportGenerator.cmToPixel((float)this.imagelistImagesize), item.getProperty("date", null));
                run.addCarriageReturn();
                run = this.currentParagraph.createRun();
                run.setText("Bild #" + number);
                if (this.imagelistCountPerPage > 0 && ++count % this.imagelistCountPerPage == 0) {
                    this.createNextParagraph();
                    this.addPagebreak();
                    continue;
                }
                this.createNextParagraph();
            }
        }
        if (this.specificContentPara != null) {
            this.specificContentPara.removeRun(0);
            this.addSpecificContent(destinationFile, filter, this.getSort());
        }
        this.writeToFile(destinationFile);
        filter.clearAll();
        filter.setTriggerEnabled(true);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        list.sort(Map.Entry.comparingByValue());
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void addSpecificContent(File destinationFile, ThemisFilter filter, String sort) {
    }

    public XWPFParagraph addParagraph(String text, ParagraphFormat format) {
        XWPFParagraph newP;
        if (this.specificContentPara == null) {
            newP = this.document.createParagraph();
        } else {
            XmlCursor cursor = this.specificContentPara.getCTP().newCursor();
            newP = this.document.insertNewParagraph(cursor);
        }
        this.setParagraphContent(newP, text, format);
        return newP;
    }

    public XWPFParagraph addParagraph(String text, String format) {
        XWPFParagraph newP;
        if (this.specificContentPara == null) {
            newP = this.document.createParagraph();
        } else {
            XmlCursor cursor = this.specificContentPara.getCTP().newCursor();
            newP = this.document.insertNewParagraph(cursor);
        }
        if (format != null) {
            newP.setStyle(format);
        }
        this.setParagraphContent(newP, text);
        return newP;
    }

    public void setParagraphContent(XWPFParagraph p, String text) {
        if (text != null) {
            String[] tabs = text.split("\t");
            this.addParagraphLines(p, tabs[0]);
            for (int ii = 1; ii < tabs.length; ++ii) {
                p.createRun().addTab();
                this.addParagraphLines(p, tabs[ii]);
            }
        }
    }

    private void addParagraphLines(XWPFParagraph p, String text) {
        if (text != null) {
            String[] lines = text.split("\n");
            this.addRunWithOptionalBackground(p, lines[0]);
            for (int ii = 1; ii < lines.length; ++ii) {
                p.createRun().addBreak();
                this.addRunWithOptionalBackground(p, lines[ii]);
            }
        }
    }

    private void addParagraphLines(XWPFParagraph p, String text, ParagraphFormat format) {
        if (text != null) {
            this.setParagraphFormat(p, format);
            String[] lines = text.split("\n");
            if (lines.length == 0) {
                lines = new String[]{text};
            }
            this.addRun(p, lines[0], format);
            for (int ii = 1; ii < lines.length; ++ii) {
                p.createRun().addBreak();
                this.addRun(p, lines[ii], format);
            }
        }
    }

    public void addRunWithOptionalBackground(XWPFParagraph p, String text) {
        if (text == null) {
            return;
        }
        String[] runs = text.split("###");
        boolean yellow = false;
        for (String r : runs) {
            if (yellow) {
                this.addRun(p, r, "FFFF00");
            } else {
                this.addRun(p, r);
            }
            yellow = !yellow;
        }
    }

    public XWPFRun addRun(XWPFParagraph p, String txt, String color) {
        XWPFRun run = p.createRun();
        run.setText(txt);
        if (color != null) {
            CTShd cTShd = run.getCTR().addNewRPr().addNewShd();
            cTShd.setVal(STShd.CLEAR);
            cTShd.setColor((Object)"auto");
            cTShd.setFill((Object)color);
        }
        return run;
    }

    public void addParagraph() {
        this.addParagraph(null);
    }

    protected void addParagraph(String text) {
        this.addParagraph(text, this.FORMAT_TEXT);
    }

    public void setParagraphContent(XWPFParagraph p, String text, ParagraphFormat format) {
        this.setParagraphFormat(p, format);
        if (text != null) {
            String[] tabs = text.split("\t");
            this.addParagraphLines(p, tabs[0], format);
            for (int ii = 1; ii < tabs.length; ++ii) {
                p.createRun().addTab();
                this.addParagraphLines(p, tabs[ii], format);
            }
        }
    }

    public void writeToFile(File f) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(f);
        this.document.write((OutputStream)out);
        out.close();
    }

    public String loadImages(XWPFRun run) {
        String text = run.getText(0);
        ArrayList placeholders = Placeholder.getPlaceholders((String)text);
        for (String ph : placeholders) {
            UploadItem item;
            File f;
            ArrayList uploads = placeholder.getPlaceholderUploads(ph, null, null, null);
            if (uploads == null || uploads.isEmpty() || (f = (item = (UploadItem)uploads.get(0)).getFile()) == null || !f.isFile()) continue;
            try {
                float imgSizeCm = Placeholder.getPlaceholderValue((String)ph, (float)8.0f);
                Dimension imageSize = Util.getImageSize((File)f);
                if (imageSize == null) continue;
                float imgSizeX = (int)(imgSizeCm * 360000.0f);
                float imgSizeY = (float)imageSize.height * imgSizeX / (float)imageSize.width;
                FileInputStream is = new FileInputStream(f);
                run.addPicture((InputStream)is, 5, f.getName(), (int)imgSizeX, (int)imgSizeY);
                is.close();
            }
            catch (FileNotFoundException ex) {
                this.project.getLogger().severe("Error while adding image to document: " + ex.getMessage());
            }
            catch (InvalidFormatException ex) {
                this.project.getLogger().severe("Error while adding image to document: " + ex.getMessage());
            }
            catch (IOException ex) {
                this.project.getLogger().severe("Error while adding image to document: " + ex.getMessage());
            }
        }
        return text;
    }

    protected float getPageWidth() {
        CTPageSz pageSize;
        CTSectPr sectPr = this.document.getDocument().getBody().getSectPr();
        if (sectPr == null) {
            sectPr = this.document.getDocument().getBody().addNewSectPr();
        }
        if ((pageSize = sectPr.getPgSz()) == null) {
            pageSize = sectPr.addNewPgSz();
        }
        float widthCm = WordReportGenerator.unitsToCm((BigInteger)pageSize.getW());
        float marginLeft = 2.5f;
        float marginRight = 2.5f;
        CTPageMar pgMar = sectPr.getPgMar();
        if (pgMar == null) {
            pgMar = sectPr.addNewPgMar();
        }
        marginLeft = WordReportGenerator.unitsToCm((BigInteger)pgMar.getLeft());
        marginRight = WordReportGenerator.unitsToCm((BigInteger)pgMar.getRight());
        return widthCm - marginLeft - marginRight;
    }

    public void setTab(XWPFParagraph p, BigInteger pos) {
        CTTabs oTabs;
        CTP oCTP = p.getCTP();
        CTPPr oPPr = oCTP.getPPr();
        if (oPPr == null) {
            oPPr = oCTP.addNewPPr();
        }
        if ((oTabs = oPPr.getTabs()) == null) {
            oTabs = oPPr.addNewTabs();
        }
        CTTabStop oTabStop = oTabs.addNewTab();
        oTabStop.setVal(STTabJc.LEFT);
        oTabStop.setPos(pos);
    }

    private void setParagraphFormat(XWPFParagraph p, ParagraphFormat format) {
        p.setSpacingAfter(format.spacing);
        p.setSpacingBefore(format.spacing);
        p.setSpacingLineRule(LineSpacingRule.EXACT);
    }

    public void setSingleLineSpacing(XWPFParagraph para) {
        CTPPr ppr = para.getCTP().getPPr();
        if (ppr == null) {
            ppr = para.getCTP().addNewPPr();
        }
        CTSpacing spacing = ppr.isSetSpacing() ? ppr.getSpacing() : ppr.addNewSpacing();
        spacing.setAfter(BigInteger.valueOf(0L));
        spacing.setBefore(BigInteger.valueOf(0L));
        spacing.setLineRule(STLineSpacingRule.AUTO);
        spacing.setLine(BigInteger.valueOf(240L));
    }

    public XWPFRun addRun(XWPFParagraph p, String text) {
        return this.addRun(p, text, this.FORMAT_TEXT);
    }

    public XWPFRun addRun(XWPFParagraph p, String text, ParagraphFormat format) {
        XWPFRun r = p.createRun();
        r.setFontFamily(FORMAT_FONT);
        r.setFontSize(format.fontsize);
        r.setBold(format.bold);
        r.setUnderline(format.underline ? UnderlinePatterns.SINGLE : UnderlinePatterns.NONE);
        r.setText(text);
        return r;
    }

    public void addTable() {
        if (this.table != null) {
            XmlCursor cursor = this.table.getCTTbl().newCursor();
            cursor.toEndToken();
            while (cursor.toNextToken() != XmlCursor.TokenType.START) {
            }
            this.currentParagraph = this.document.insertNewParagraph(cursor);
        }
        this.selectNextParagraph();
    }

    protected void addPagebreak() {
        XWPFParagraph p = this.currentParagraph;
        if (p == null) {
            p = this.document.createParagraph();
            p.setPageBreak(true);
        } else {
            this.currentParagraph.setPageBreak(true);
            this.createNextParagraph();
        }
    }

    private void selectNextParagraph() {
        if (this.currentParagraph != null) {
            List paragraphs = this.document.getParagraphs();
            for (int ii = 0; ii < paragraphs.size(); ++ii) {
                if (!((XWPFParagraph)paragraphs.get(ii)).equals(this.currentParagraph) || ii >= paragraphs.size() - 1) continue;
                this.currentParagraph = (XWPFParagraph)paragraphs.get(ii + 1);
                return;
            }
            this.currentParagraph = this.document.createParagraph();
        }
    }

    private void createNextParagraph() {
        if (this.currentParagraph != null) {
            XmlCursor cursor = this.currentParagraph.getCTP().newCursor();
            cursor.toEndToken();
            while (cursor.toNextToken() != XmlCursor.TokenType.START) {
            }
            this.currentParagraph = this.document.insertNewParagraph(cursor);
        }
    }

    protected boolean hasTable() {
        return this.table != null;
    }

    protected void createTable(float[] colWidthCm, int noOfHeaderRows) {
        CTTblLayoutType tblLayout;
        this.colWidthsCm = colWidthCm;
        if (this.currentParagraph == null) {
            this.table = this.document.createTable(0, 0);
        } else {
            XmlCursor cursor = this.currentParagraph.getCTP().newCursor();
            this.table = this.document.insertNewTbl(cursor);
        }
        if (this.table == null) {
            this.app.getDialog().showErrorDialog("Fehler: Die Tabelle kann nicht erstellt werden.");
            return;
        }
        float w = this.getPageWidth();
        CTTblPr tblPr = this.table.getCTTbl().getTblPr();
        if (tblPr == null) {
            tblPr = this.table.getCTTbl().addNewTblPr();
        }
        if ((tblLayout = this.table.getCTTbl().getTblPr().getTblLayout()) == null) {
            tblLayout = this.table.getCTTbl().getTblPr().addNewTblLayout();
        }
        tblLayout.setType(STTblLayoutType.FIXED);
        CTTblWidth tblW = tblPr.getTblW();
        if (tblW == null) {
            tblW = tblPr.addNewTblW();
        }
        tblW.setType(STTblWidth.DXA);
        tblW.setW(ReportGenerator.cmToUnits((double)w));
        this.table.setCellMargins(0, 100, 0, 100);
        CTTblGrid tblGrid = this.table.getCTTbl().getTblGrid();
        if (tblGrid == null) {
            tblGrid = this.table.getCTTbl().addNewTblGrid();
        }
        int tblGridSize = tblGrid.getGridColList().size();
        for (int ii = 0; ii < colWidthCm.length; ++ii) {
            CTTblGridCol tblGridCol = ii < tblGridSize ? tblGrid.getGridColArray(ii) : tblGrid.addNewGridCol();
            tblGridCol.setW(ReportGenerator.cmToUnits((double)colWidthCm[ii]));
        }
        this.firstTableRow = true;
        this.tableHeaderRows = noOfHeaderRows;
        this.tableRow = this.table.getRow(0);
        if (noOfHeaderRows > 0) {
            this.tableRow.setRepeatHeader(true);
        }
    }

    private void createCell(double rowheightCM) {
        if (this.tableRow == null) {
            this.tableRow = this.table.createRow();
            if (rowheightCM >= 0.0) {
                this.setTableRowHeight(this.tableRow, rowheightCM, true);
            }
        }
        if (this.table.getNumberOfRows() <= this.tableHeaderRows) {
            this.tableRow.setRepeatHeader(true);
        }
        this.tableCell = this.tableRow.getCell(this.tableCellPos);
        if (this.tableCell == null) {
            this.tableCell = this.tableRow.createCell();
        }
        int paragraphs = this.tableCell.getParagraphs().size();
        for (int ii = 0; ii < paragraphs; ++ii) {
            this.tableCell.removeParagraph(0);
        }
        ++this.tableCellPos;
    }

    protected void createCell(LayoutCell l, Color cBG) {
        LayoutRow r = l.getRow();
        int rowheight = -1;
        if (r != null) {
            rowheight = r.getHeight();
        }
        this.createCell((double)rowheight / 10.0);
        if (l != null) {
            CTTcBorders bb;
            CTTc ctTc = this.tableCell.getCTTc();
            CTTcPr tcPr = ctTc.getTcPr();
            if (tcPr == null) {
                tcPr = ctTc.addNewTcPr();
            }
            if ((bb = tcPr.getTcBorders()) == null) {
                bb = tcPr.addNewTcBorders();
            }
            STBorder.Enum bordersetting = l.hasBorder() ? STBorder.SINGLE : STBorder.NIL;
            CTBorder b = bb.getBottom();
            if (b == null) {
                b = bb.addNewBottom();
            }
            b.setVal(bordersetting);
            b = bb.getRight();
            if (b == null) {
                b = bb.addNewRight();
            }
            b.setVal(bordersetting);
            b = bb.getLeft();
            if (b == null) {
                b = bb.addNewLeft();
            }
            b.setVal(bordersetting);
            b = bb.getTop();
            if (b == null) {
                b = bb.addNewTop();
            }
            b.setVal(bordersetting);
            if (cBG != null) {
                String hex = Integer.toHexString(cBG.getRGB()).substring(2);
                CTShd shd = tcPr.getShd();
                if (shd == null) {
                    shd = tcPr.addNewShd();
                }
                shd.setFill((Object)hex);
            }
        }
    }

    protected void createCell(String c, LayoutCell l, Color cBG) {
        this.createCell(l, cBG);
        ParagraphFormat fmt = this.FORMAT_SMALLTEXT;
        XWPFParagraph p = this.tableCell.addParagraph();
        if (l != null) {
            fmt = new ParagraphFormat(l.getFontSize(), l.isFontBold(), l.isFontUnderlined(), 100);
            switch (l.getAlign()) {
                case CENTER: {
                    p.setAlignment(ParagraphAlignment.CENTER);
                    break;
                }
                case RIGHT: {
                    p.setAlignment(ParagraphAlignment.RIGHT);
                }
            }
        }
        this.addParagraphLines(p, c, fmt);
    }

    protected void createImageCell(LayoutCell cell, ArrayList<SimpleGeometry> drawings, File imageFile, float imageWidth, String text) {
        this.createCell(cell, null);
        XWPFParagraph p = this.tableCell.addParagraph();
        this.setParagraphFormat(p, this.FORMAT_SMALLTEXT);
        XWPFRun run = p.createRun();
        if (imageFile != null) {
            this.addImageToRun(run, drawings, imageFile, ReportGenerator.cmToPixel((float)imageWidth), text);
        }
    }

    protected void createMultipleImageCell(LayoutCell l, ArrayList<ReportGenerator.ImageSpecification> imageUploadItems, float imageWidth, float cellWidth) {
        this.createCell(l, null);
        XWPFParagraph p = this.tableCell.addParagraph();
        this.setParagraphFormat(p, this.FORMAT_SMALLTEXT);
        XWPFRun run = p.createRun();
        boolean first = true;
        for (ReportGenerator.ImageSpecification spec : imageUploadItems) {
            if (spec.item == null) continue;
            File imageFile = spec.item.getFile();
            if (!first) {
                p.createRun().setText("  ");
                run = p.createRun();
            }
            first = false;
            if (imageFile == null) continue;
            this.addImageToRun(run, this.project.getDrawings(spec.item.getId()), imageFile, ReportGenerator.cmToPixel((float)imageWidth), spec.item.getProperty("date", null));
        }
    }

    private void setTableRowHeight(XWPFTableRow row, double hCM, boolean exact) {
        int h = ReportGenerator.cmToUnits((double)hCM).intValue();
        row.setHeight(h);
        if (exact) {
            row.getCtRow().getTrPr().getTrHeightArray(0).setHRule(STHeightRule.EXACT);
        }
    }

    private void addImageToRun(XWPFRun run, ArrayList<SimpleGeometry> drawings, File imageFile, float pixelLongSide, String text) {
        try {
            if (drawings == null) {
                drawings = new ArrayList();
            }
            int imagePixel = pixelLongSide > 0.0f ? (int)(300.0f * pixelLongSide / 72.0f) : 0;
            BufferedImage bi = this.getImageWithDrawings(imageFile, drawings, imagePixel, text);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "jpeg", os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            run.addPicture((InputStream)is, 5, imageFile.getName(), Units.toEMU((double)bi.getWidth()) * 72 / 300, Units.toEMU((double)bi.getHeight()) * 72 / 300);
            ((InputStream)is).close();
            os.close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvalidFormatException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void setCellColSpan(int cols) {
        if (this.tableCell != null && cols > 1) {
            this.tableCell.getCTTc().addNewTcPr();
            CTTcPr tcPr = this.tableCell.getCTTc().getTcPr();
            tcPr.addNewGridSpan().setVal(BigInteger.valueOf(cols));
        }
    }

    protected void setCellBackground(Color c) {
    }

    protected void addCellToTable() {
    }

    protected void completeTableRow() {
        if (this.tableRow != null) {
            int countCells = this.tableRow.getTableCells().size();
            for (int cellpos = countCells - 1; cellpos >= this.tableCellPos; --cellpos) {
                CTTc ctTc;
                XWPFTableCell cell = this.tableRow.getCell(cellpos);
                if (cell != null && (ctTc = cell.getCTTc()) != null) {
                    ctTc.newCursor().removeXml();
                }
                this.tableRow.removeCell(cellpos);
            }
        }
        this.firstTableRow = false;
        this.tableRow = null;
        this.tableCellPos = 0;
        this.tableHeaderRows = 0;
    }

    public XWPFTableRow addTableRow(XWPFTable t, int columnCount, int rowheight) {
        int countCells;
        XWPFTableRow row;
        XWPFTableRow xWPFTableRow = row = this.firstTableRow ? t.getRow(0) : t.createRow();
        if (rowheight >= 0) {
            int h = ReportGenerator.cmToUnits((double)((double)rowheight / 10.0)).intValue();
            row.setHeight(h);
            row.getCtRow().getTrPr().getTrHeightArray(0).setHRule(STHeightRule.EXACT);
        }
        for (int ii = countCells = row.getTableCells().size(); ii < columnCount; ++ii) {
            row.addNewTableCell();
        }
        this.firstTableRow = false;
        return row;
    }

    public XWPFTableRow addTableRow(XWPFTable t, float[] columnWidth, int rowheight) {
        int countCells;
        int ii;
        XWPFTableRow row;
        XWPFTableRow xWPFTableRow = row = this.firstTableRow ? t.getRow(0) : t.createRow();
        if (rowheight >= 0) {
            int h = ReportGenerator.cmToUnits((double)((double)rowheight / 10.0)).intValue();
            row.setHeight(h);
            row.getCtRow().getTrPr().getTrHeightArray(0).setHRule(STHeightRule.EXACT);
        }
        for (ii = countCells = row.getTableCells().size(); ii < columnWidth.length; ++ii) {
            row.addNewTableCell();
        }
        for (ii = 0; ii < columnWidth.length; ++ii) {
            XWPFTableCell cell = row.getCell(ii);
            CTTblWidth cellWidth = cell.getCTTc().addNewTcPr().addNewTcW();
            BigInteger width = BigInteger.valueOf((int)(WordReportGenerator.cmToUnits((double)16.0).doubleValue() * (double)columnWidth[ii] / 100.0));
            cellWidth.setW(width);
        }
        this.firstTableRow = false;
        return row;
    }

    public XWPFParagraph setTableCellContent(XWPFTableRow row, int col, String text) {
        return this.setTableCellContent(row, col, text, this.FORMAT_TEXT);
    }

    public XWPFParagraph setTableCellContent(XWPFTableRow row, int col, String text, ParagraphFormat format) {
        if (col < row.getTableCells().size()) {
            row.getCell(col).removeParagraph(0);
            XWPFParagraph p = row.getCell(col).addParagraph();
            if ("".equals(text)) {
                text = "-";
            }
            this.setParagraphContent(p, text, format);
            return p;
        }
        return null;
    }

    public XWPFParagraph addTableCellContent(XWPFTableRow row, int col, String text, ParagraphFormat format) {
        if (col < row.getTableCells().size()) {
            XWPFParagraph p = row.getCell(col).addParagraph();
            this.setParagraphContent(p, text, format);
            return p;
        }
        return null;
    }

    public void setTableCellParagraph(XWPFTableRow row, int col, XWPFParagraph p) {
        if (col < row.getTableCells().size()) {
            row.getCell(col).removeParagraph(0);
            row.getCell(col).setParagraph(p);
        }
    }

    public void addTableCellParagraph(XWPFTableRow row, int col, XWPFParagraph p) {
        if (col < row.getTableCells().size()) {
            row.getCell(col).addParagraph(p);
        }
    }

    public XWPFParagraph setTableCellParagraph(XWPFTableRow row, int col, String text, int format) {
        if (col < row.getTableCells().size()) {
            row.getCell(col).removeParagraph(0);
            XWPFParagraph p = row.getCell(col).addParagraph();
            return p;
        }
        return null;
    }

    public XWPFParagraph addTableCellParagraph(XWPFTableRow row, int col, String text, ParagraphFormat format) {
        if (col < row.getTableCells().size()) {
            return row.getCell(col).addParagraph();
        }
        return null;
    }

    public void setTableRowContent(XWPFTableRow row, String[] content, ParagraphFormat format) {
        for (int ii = 0; ii < content.length; ++ii) {
            this.setTableCellContent(row, ii, content[ii], format);
        }
    }

    private void updateParagraph(XWPFParagraph para) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Integer> sbIndex = new ArrayList<Integer>();
        List runs = para.getRuns();
        int lastIndex = 0;
        for (XWPFRun run : runs) {
            String ss = run.getText(0);
            if (ss != null) {
                sb.append(ss);
                lastIndex = sb.lastIndexOf(ss);
                sbIndex.add(lastIndex);
                continue;
            }
            sbIndex.add(lastIndex);
        }
        ArrayList phs = Placeholder.getPlaceholders((String)sb.toString());
        for (int ii = phs.size() - 1; ii >= 0; --ii) {
            String ph = "#!#" + (String)phs.get(ii) + "#!#";
            int idx1 = sb.toString().lastIndexOf(ph);
            int idx2 = idx1 + ph.length();
            int runIdx1 = 0;
            int runIdx2 = 0;
            int lastSbIndex = -1;
            for (int jj = 0; jj < sbIndex.size(); ++jj) {
                boolean sameSbIndex;
                boolean bl = sameSbIndex = (Integer)sbIndex.get(jj) == lastSbIndex;
                if ((Integer)sbIndex.get(jj) <= idx1 && !sameSbIndex) {
                    runIdx1 = jj;
                }
                if ((Integer)sbIndex.get(jj) < idx2 && !sameSbIndex) {
                    runIdx2 = jj;
                }
                lastSbIndex = (Integer)sbIndex.get(jj);
            }
            String run1Text = null;
            XWPFRun run1 = null;
            int run1TextIndex = 0;
            while (run1Text == null && runIdx1 < runs.size()) {
                run1 = (XWPFRun)runs.get(runIdx1);
                run1Text = run1.getText(0);
                run1TextIndex = idx1 - (Integer)sbIndex.get(runIdx1);
                if (run1Text != null) continue;
                ++runIdx1;
                ++runIdx2;
            }
            run1.setText(run1Text.substring(0, run1TextIndex) + ph, 0);
            String run1TextAfter = run1.getText(0);
            for (int jj = runIdx1 + 1; jj < runIdx2; ++jj) {
                ((XWPFRun)runs.get(jj)).setText("", 0);
            }
            if (runIdx2 <= runIdx1 || runIdx2 >= runs.size()) continue;
            XWPFRun run2 = (XWPFRun)runs.get(runIdx2);
            String run2Text = run2.getText(0);
            String run2TextSub = run2Text.substring(idx2 - (Integer)sbIndex.get(runIdx2));
            run2.setText(run2TextSub, 0);
        }
        if (!phs.isEmpty()) {
            for (XWPFRun run : para.getRuns()) {
                String t = run.getText(0);
                if (t == null) continue;
                if (t.toLowerCase().startsWith("#!#tabelle.")) {
                    String fontFamily = run.getFontFamily();
                    String tablename = t.substring(3, t.indexOf("#!#", 4));
                    String[] split = tablename.split("\\.");
                    if (split.length == 2) {
                        this.contentTables.put(split[1], para);
                        this.tableFonts.put(split[1], fontFamily);
                    }
                } else if (t.toLowerCase().startsWith("#!#bilderliste")) {
                    this.imagelistParagraph = para;
                    int idx2 = t.indexOf(";");
                    int idx1 = t.indexOf("-");
                    String countString = "0";
                    if (idx1 > 0) {
                        countString = t.substring(idx1 + 1, idx2);
                    }
                    this.imagelistCountPerPage = Util.parseInt((String)countString, (int)0);
                    String sizeString = t.substring(idx2 + 1).split("#")[0];
                    this.imagelistImagesize = Util.parseFloat((String)sizeString, (float)12.0f);
                }
                if ("#!#liste1#!#".equalsIgnoreCase(t)) {
                    this.contentSpecial.put(t, run);
                    this.specificContentPara = para;
                    run.setText("", 0);
                }
                if ("#!#signature#!#".equalsIgnoreCase(t) || "#!#unterschriften#!#".equalsIgnoreCase(t)) {
                    this.contentSpecial.put(t, run);
                    run.setText("", 0);
                    this.signatureParagraph = para;
                }
                if (t.toLowerCase().contains("#!#param.sort")) {
                    ArrayList placeholders = Placeholder.getPlaceholders((String)t);
                    for (String ph : placeholders) {
                        if (!ph.startsWith("param.sort")) continue;
                        t = t.replaceAll("#!#" + ph + "#!#", "");
                        String[] split = ph.split("=");
                        if (split.length <= 1) continue;
                        this.setSpecialSort(Placeholder.getSortString((String)split[1], (Properties)placeholder.getMapping(), null));
                    }
                }
                this.loadImages(run);
                String replaceText = this.ph.apply(t, null, null, null, null);
                if (replaceText != null) {
                    String[] lines = replaceText.split("\n");
                    run.setText(lines[0], 0);
                    for (int i = 1; i < lines.length; ++i) {
                        run.addBreak();
                        run.setText(lines[i]);
                    }
                    continue;
                }
                run.setText(null, 0);
            }
        }
    }

    protected void addSignatures(XWPFParagraph para) {
        for (int ii = 0; ii < this.rep.signatures.size(); ++ii) {
            ThemisSignature sig1 = (ThemisSignature)this.rep.signatures.get(ii);
            XWPFRun run = para.createRun();
            if (sig1.getSignatureFile() != null && sig1.getSignatureFile().exists()) {
                this.addImageToRun(run, null, sig1.getSignatureFile(), ReportGenerator.cmToPixel((float)5.0f), null);
            } else {
                run.addCarriageReturn();
                run.addCarriageReturn();
            }
            run.addCarriageReturn();
            run = para.createRun();
            StringBuilder sb = new StringBuilder();
            sb.append(sig1.getName());
            if (sig1.hasFunction()) {
                sb.append(" (").append(sig1.getFunction()).append(")");
            }
            run.setText(sb.toString());
            run.addCarriageReturn();
            run.addCarriageReturn();
        }
    }

    protected void addSignatures2(XWPFParagraph para) {
        float pageWidth = this.getPageWidth();
        float[] widths = new float[]{pageWidth * 0.4f, pageWidth * 0.2f, pageWidth * 0.4f};
        this.createTable(widths, 0);
        this.createCell(-1.0);
        XWPFParagraph p = this.tableCell.addParagraph();
        this.addParagraphLines(p, "Datum: " + Util.formatDate((Date)new Date(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone()));
        this.createCell(-1.0);
        this.createCell(-1.0);
        this.completeTableRow();
        int sigRows = (this.rep.signatures.size() + 1) / 2;
        for (int ii = 0; ii < sigRows; ++ii) {
            ThemisSignature sig1 = (ThemisSignature)this.rep.signatures.get(ii * 2);
            ThemisSignature sig2 = null;
            if (this.rep.signatures.size() > ii * 2 + 1) {
                sig2 = (ThemisSignature)this.rep.signatures.get(ii * 2 + 1);
            }
            this.createImageCell(null, null, sig1.getSignatureFile(), 7.0f, null);
            this.createCell(-1.0);
            if (sig2 != null) {
                this.createImageCell(null, null, sig2.getSignatureFile(), 7.0f, null);
            } else {
                this.createCell(-1.0);
            }
            this.completeTableRow();
            StringBuilder sb = new StringBuilder();
            sb.append(sig1.getName());
            if (sig1.hasFunction()) {
                sb.append(" (").append(sig1.getFunction()).append(")");
            }
            this.createCell(-1.0);
            p = this.tableCell.addParagraph();
            this.addParagraphLines(p, sb.toString());
            this.createCell(-1.0);
            if (sig2 != null) {
                sb = new StringBuilder();
                sb.append(sig2.getName());
                if (sig2.hasFunction()) {
                    sb.append(" (").append(sig2.getFunction()).append(")");
                }
                this.createCell(-1.0);
                p = this.tableCell.addParagraph();
                this.addParagraphLines(p, sb.toString());
            } else {
                this.createCell(-1.0);
            }
            this.completeTableRow();
        }
    }

    private void addSignatureToRun(XWPFRun run, int idx, boolean withName) {
        if (this.rep.signatures.size() > idx) {
            ThemisSignature sig = (ThemisSignature)this.rep.signatures.get(idx);
            if (sig.getSignatureFile() != null && sig.getSignatureFile().exists()) {
                this.addImageToRun(run, null, sig.getSignatureFile(), ReportGenerator.cmToPixel((float)5.0f), null);
            }
            if (withName) {
                run.addCarriageReturn();
                StringBuilder sb = new StringBuilder();
                sb.append(sig.getName());
                if (sig.hasFunction()) {
                    sb.append(" (").append(sig.getFunction()).append(")");
                }
                run.setText(sb.toString());
            }
        }
    }

    private void addSpecialContents() {
        this.contentSpecial.forEach((ph, run) -> {
            switch (ph.toLowerCase()) {
                case "#!#unterschriften#!#": 
                case "#!#signatures#!#": {
                    break;
                }
                case "#!#unterschrift1#!#": 
                case "#!#signature1#!#": {
                    this.addSignatureToRun((XWPFRun)run, 0, false);
                    break;
                }
                case "#!#unterschrift2#!#": 
                case "#!#signature2#!#": {
                    this.addSignatureToRun((XWPFRun)run, 1, false);
                }
            }
        });
    }

    class TableLayout {
        String name;
        XWPFParagraph para;

        public TableLayout(String n, XWPFParagraph p) {
            this.name = n;
            this.para = p;
        }
    }

    class ParagraphFormat {
        boolean bold = false;
        boolean underline = false;
        int fontsize = 11;
        int spacing = 100;

        public ParagraphFormat(int fontsize, boolean bold, boolean underline, int spacing) {
            this.fontsize = fontsize;
            this.bold = bold;
            this.underline = underline;
            this.spacing = spacing;
        }
    }
}

