/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.report.layout;

import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.report.AttributeSqlPair;
import at.grid.themis.ontology.report.LayoutCell;
import at.grid.themis.ontology.report.LayoutRow;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.PlaceholderReference;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jdom.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LayoutTableEditor
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ReportTableLayout layout;
    ArrayList<Element> layoutUndo = new ArrayList();
    GridBagConstraints gbc;
    int currentCol = -1;
    LayoutCell currentCell = null;
    JEditorPane currentEditor = null;
    HashMap<LayoutCell, JEditorPane> editorPanes = new HashMap();
    boolean save = false;
    private boolean flagUpdating;
    ArrayList<String> forbiddenNames = new ArrayList();
    private Element copyCellFormat;
    boolean focusOnGrouping = false;
    private JButton btnAddColLeft;
    private JButton btnAddColRight;
    private JButton btnAddPlaceholder;
    private JButton btnAddRowAbove;
    private JButton btnAddRowBelow;
    private JToggleButton btnAlignCenter;
    private JToggleButton btnAlignLeft;
    private JToggleButton btnAlignRight;
    private JToggleButton btnCellFontBold;
    private JToggleButton btnCellFontItlaic;
    private JToggleButton btnCellFontUnderline;
    private JButton btnCellFormatCopy;
    private JButton btnCellFormatPaste;
    private JButton btnCellFormatToRow;
    private JButton btnCellFormatToTable;
    private JButton btnClose;
    private JButton btnCloseSave;
    private JButton btnDelCol;
    private JButton btnDelRow;
    private JButton btnMoveRowDown;
    private JButton btnMoveRowUp;
    private JButton btnSetBorder1;
    private JButton btnSetHeadlines;
    private JButton btnSetHeadlines1;
    private JButton btnSetNoBorder1;
    private JButton btnSetNoHeadlines;
    private JButton btnSetNoHeadlines1;
    private JButton btnSpanCell;
    private JButton btnUndo;
    private JButton btnUnspanCell;
    private ButtonGroup buttonGroupAlign;
    private ButtonGroup buttonGroupRow;
    private JCheckBox chkHideSameContent;
    private JComboBox<String> fldCellBorder;
    private JComboBox<String> fldCellBorderWidth;
    private JComboBox<String> fldCellFont;
    private JTextField fldCellFontColor;
    private JComboBox<String> fldCellFontSize;
    private JComboBox<ColorOption> fldColor;
    private JTextField fldColorChooser;
    private JTextField fldColorChooserForeground;
    private JComboBox<CmsBasicElement> fldFilter;
    private JTextField fldGroupAttribute2;
    private JComboBox<String> fldGroupNew;
    private JTextField fldGroupRows;
    private JTextField fldHeadlines;
    private JTextField fldName;
    private JTextField fldPlaceholderFilter;
    private JTextField fldRowHeight;
    private JComboBox<AttributeSqlPair> fldSort;
    private JButton jButton6;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JLabel lblEmpty;
    private JLabel lblGruppierung;
    private JLabel lblProperties1;
    private JList<PlaceholderReference> lstPlaceholder;
    private JPanel panelBottom;
    private JPanel panelButtons;
    private JPanel panelFilter;
    private JPanel panelKopfzeile;
    private JPanel panelRight;
    private JPanel panelTable;
    private JScrollPane scrollPlaceholder;
    private String DIALOG_CODE = "tablelayout";
    public static final int DIALOG_WIDTH = 1100;
    public static final int DIALOG_HEIGHT = 900;

    public LayoutTableEditor() {
        this(ThemisApplication.getInstance().getProject().getNewReportTableName("Neues Layout"));
    }

    public LayoutTableEditor(String name) {
        this.layout = (ReportTableLayout)this.app.getProject().createElement("reporttable");
        this.layout.clear();
        this.layout.setName(name);
        this.initialise();
    }

    public LayoutTableEditor(ReportTableLayout rtl) {
        this.layout = rtl;
        this.initialise();
    }

    private void initialise() {
        this.initComponents();
        this.fldCellBorder.setVisible(false);
        this.fldCellFontColor.setVisible(false);
        this.chkHideSameContent.setVisible(false);
        this.updatePlaceholderList();
        ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.none")));
        ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.static"), Integer.valueOf(this.fldColorChooser.getBackground().getRGB())));
        ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.status"), this.app.getSettings().getObservationAttribute("done")));
        ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.urgency"), this.app.getSettings().getObservationAttribute("duedate")));
        ThemisSettings settings = this.app.getSettings();
        for (ThemisAttribute ta : settings.getObservationAttributesUsed()) {
            if (ta.getTypeId() != ThemisAttribute.Type.LIST || ta.getId().equals("documents")) continue;
            ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption("B." + ta.getLabel(), ta));
        }
        for (ThemisAttribute ta : settings.getLocationAttributesUsed()) {
            if (ta.getTypeId() != ThemisAttribute.Type.LIST || ta.getId().equals("documents")) continue;
            ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption("G." + ta.getLabel(), ta));
        }
        String grouping = this.layout.getGroupPlaceholder();
        this.fldGroupAttribute2.setText(grouping);
        this.fldGroupRows.setText(this.layout.getGroupRowsAsString());
        if (this.layout.getGroupPagebreak()) {
            this.fldGroupNew.setSelectedIndex(2);
        } else if (this.layout.getGroupNewTable()) {
            this.fldGroupNew.setSelectedIndex(1);
        } else {
            this.fldGroupNew.setSelectedIndex(0);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ArrayList<String> fontfamilies = new ArrayList<String>();
        for (Font f : ge.getAllFonts()) {
            if (!f.canDisplay('\u00e4') || fontfamilies.contains(f.getFamily())) continue;
            fontfamilies.add(f.getFamily());
        }
        for (String f : fontfamilies) {
            ((DefaultComboBoxModel)this.fldCellFont.getModel()).addElement(f);
        }
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("6");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("8");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("10");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("11");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("12");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("14");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("16");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("18");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("22");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("26");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("32");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("40");
        ((DefaultComboBoxModel)this.fldCellBorder.getModel()).addElement("oben");
        ((DefaultComboBoxModel)this.fldCellBorder.getModel()).addElement("rechts");
        ((DefaultComboBoxModel)this.fldCellBorder.getModel()).addElement("unten");
        ((DefaultComboBoxModel)this.fldCellBorder.getModel()).addElement("links");
        ((DefaultComboBoxModel)this.fldCellBorderWidth.getModel()).addElement("0");
        ((DefaultComboBoxModel)this.fldCellBorderWidth.getModel()).addElement("1");
        ((DefaultComboBoxModel)this.fldCellBorderWidth.getModel()).addElement("2");
        ((DefaultComboBoxModel)this.fldCellBorderWidth.getModel()).addElement("3");
        ((DefaultComboBoxModel)this.fldCellBorderWidth.getModel()).addElement("4");
        boolean useLocationPrefix = this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useLocationSuffix = this.app.getSettings().getLocationAttribute("suffix").isUsed();
        String numberSort = (useLocationPrefix ? "ele.prenumber," : "") + "ele.number" + (useLocationSuffix ? ",ele.postnumber" : "");
        String observationSort = ",observation.number,observation.idelement";
        AttributeSqlPair selSort = this.layout.getSort();
        this.fldSort.addItem(new AttributeSqlPair("-", null));
        this.fldSort.addItem(new AttributeSqlPair("Geb\u00e4ude,Plan,Nummer", "building.title,plan.sort," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Nummer (Gegenstand und Beobachtung)", numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Termin,Nummer", "observation.duedate," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Gruppe,Gegenstand", "locationgroupsort,ele.titel," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Gegenstand", "ele.titel," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Kontakt,Nummer", "contact.name," + numberSort + observationSort));
        if (selSort != null) {
            int selIdx = -1;
            for (int ii = 0; ii < this.fldSort.getItemCount(); ++ii) {
                if (!selSort.equals(this.fldSort.getItemAt(ii).getSql())) continue;
                selIdx = ii;
                break;
            }
            this.fldSort.setSelectedIndex(selIdx);
        }
        long idFilter = this.layout.getFilterId();
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.fldFilter.getModel();
        m.removeAllElements();
        m.addElement(new CmsBasicElement(-1L, "-"));
        CmsBasicElement sel = null;
        for (CmsBasicElement be : this.app.getProject().getFilters()) {
            m.addElement(be);
            if (be.getId() != idFilter) continue;
            sel = be;
        }
        if (sel != null) {
            this.fldFilter.setSelectedItem(sel);
        }
        this.populateTable();
        this.fldCellFont.setVisible(false);
        this.btnCellFontItlaic.setVisible(false);
    }

    public void setForbiddenNames(ArrayList<String> names) {
        this.forbiddenNames.addAll(names);
    }

    public ReportTableLayout getTableLayout() {
        return this.layout;
    }

    public void setCurrentCell(LayoutCell cell) {
        ColorOption co;
        this.currentCell = cell;
        for (int rr = 0; rr < this.layout.getNumberOfRows(); ++rr) {
            LayoutRow row = this.layout.getRow(rr);
            for (LayoutCell c : row.getCells()) {
                JEditorPane editor = this.editorPanes.get(c);
                if (c == this.currentCell) {
                    editor.setBackground(THEMIS.lightyellow);
                    continue;
                }
                if (rr < this.layout.getHeaderRowCount()) {
                    editor.setBackground(THEMIS.lightblue);
                    continue;
                }
                editor.setBackground(Color.WHITE);
            }
        }
        LayoutRow row = cell.getRow();
        int rowheight = row.getHeight();
        this.fldRowHeight.setText(rowheight >= 0 ? Integer.toString(rowheight) : "");
        this.flagUpdating = true;
        this.fldCellBorderWidth.setSelectedItem(cell == null ? "0" : Integer.toString((int)cell.getBorder()));
        LayoutCell.Align a = cell == null ? LayoutCell.Align.LEFT : cell.getAlign();
        switch (a) {
            case LEFT: {
                this.btnAlignLeft.setSelected(true);
                break;
            }
            case CENTER: {
                this.btnAlignCenter.setSelected(true);
                break;
            }
            case RIGHT: {
                this.btnAlignRight.setSelected(true);
                break;
            }
            default: {
                this.btnAlignLeft.setSelected(true);
            }
        }
        ColorOption colorOption = co = cell == null ? null : cell.getBackground();
        if (co == null) {
            this.fldColor.setSelectedIndex(0);
        } else {
            if (co.getMethod() == ColorOption.Method.STATIC) {
                this.fldColorChooser.setVisible(true);
                this.fldColorChooserForeground.setVisible(true);
                Integer c = co.getStaticColor();
                this.fldColorChooser.setBackground(c == null ? Color.WHITE : new Color(c));
            } else {
                this.fldColorChooser.setVisible(false);
                this.fldColorChooserForeground.setVisible(false);
            }
            this.jPanel1.revalidate();
            for (int ii = 0; ii < this.fldColor.getItemCount(); ++ii) {
                if (this.fldColor.getItemAt(ii).getMethod() != co.getMethod()) continue;
                if (co.getMethod() == ColorOption.Method.ATTRIBUTE) {
                    if (!co.getAttribute().equals((Object)this.fldColor.getItemAt(ii).getAttribute())) continue;
                    this.fldColor.setSelectedIndex(ii);
                    this.fldColorChooser.setEnabled(ii == 1);
                    break;
                }
                this.fldColor.setSelectedIndex(ii);
                this.fldColorChooser.setEnabled(ii == 1);
                break;
            }
        }
        this.fldCellFont.setSelectedItem(cell == null ? "Arial" : cell.getFontFamily());
        this.fldCellFontSize.setSelectedItem(cell == null ? "12" : Integer.toString(cell.getFontSize()));
        this.btnCellFontBold.setSelected(cell == null ? false : cell.isFontBold());
        this.btnCellFontUnderline.setSelected(cell == null ? false : cell.isFontUnderlined());
        this.btnCellFontItlaic.setSelected(cell == null ? false : cell.isFontItalic());
        this.flagUpdating = false;
    }

    private void populateTable() {
        this.panelTable.removeAll();
        int tableRows = 0;
        this.fldName.setText(this.layout.getName());
        this.fldHeadlines.setText(Integer.toString(this.layout.getHeaderRowCount()));
        int cc = 0;
        while (cc < this.layout.getNumberOfCols()) {
            final int ccFinal = cc;
            int width = this.layout.getCol(cc);
            this.gbc = new GridBagConstraints();
            this.gbc.gridx = cc++;
            this.gbc.gridy = 0;
            this.gbc.weightx = width;
            this.gbc.fill = 2;
            this.gbc.insets = new Insets(2, 2, 2, 2);
            final JTextField fld = this.createTextField();
            fld.setText(Integer.toString(width));
            fld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LayoutTableEditor.this.layout.setColWidth(ccFinal, Integer.parseInt(fld.getText()));
                    LayoutTableEditor.this.populateTable();
                }
            });
            fld.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    LayoutTableEditor.this.layout.setColWidth(ccFinal, Integer.parseInt(fld.getText()));
                    LayoutTableEditor.this.populateTable();
                }
            });
            this.panelTable.add((Component)fld, this.gbc);
        }
        ++tableRows;
        for (int rr = 0; rr < this.layout.getNumberOfRows(); ++rr) {
            LayoutRow row = this.layout.getRow(rr);
            for (final LayoutCell cell : row.getCells()) {
                JTextPane cellEditor = (JTextPane)this.editorPanes.get(cell);
                final JTextPane editor = cellEditor == null ? new JTextPane() : cellEditor;
                StyledDocument style = editor.getStyledDocument();
                SimpleAttributeSet align = new SimpleAttributeSet();
                int a = 0;
                switch (cell.getAlign()) {
                    case RIGHT: {
                        a = 2;
                        break;
                    }
                    case CENTER: {
                        a = 1;
                    }
                }
                StyleConstants.setAlignment(align, a);
                float indentLeftRight = 3.0f;
                float indentTopBottom = 1.0f;
                StyleConstants.setLeftIndent(align, indentLeftRight);
                StyleConstants.setRightIndent(align, indentLeftRight);
                StyleConstants.setSpaceAbove(align, indentTopBottom);
                StyleConstants.setSpaceBelow(align, indentTopBottom);
                StyleConstants.setFontFamily(align, cell.getFontFamily());
                StyleConstants.setFontSize(align, Math.round((float)cell.getFontSize() * 1.2f));
                StyleConstants.setBold(align, cell.isFontBold());
                StyleConstants.setUnderline(align, cell.isFontUnderlined());
                StyleConstants.setItalic(align, cell.isFontItalic());
                style.setParagraphAttributes(0, style.getLength(), align, false);
                if (cell == this.currentCell) {
                    editor.setBackground(THEMIS.lightyellow);
                } else if (rr < this.layout.getHeaderRowCount()) {
                    editor.setBackground(THEMIS.lightblue);
                } else {
                    editor.setBackground(Color.WHITE);
                }
                editor.setText(cell.getContent());
                editor.setMargin(new Insets(10, 10, 10, 10));
                this.editorPanes.put(cell, editor);
                editor.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent evt) {
                        cell.setContent(editor.getText());
                    }
                });
                editor.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent evt) {
                        if (cell != LayoutTableEditor.this.currentCell) {
                            LayoutTableEditor.this.setCurrentCell(cell);
                            LayoutTableEditor.this.setCurrentEditor(editor);
                            editor.requestFocusInWindow();
                        }
                    }
                });
                if (cell.hasBorder()) {
                    editor.setBorder(BorderFactory.createLineBorder(Color.BLACK, (int)cell.getBorder()));
                } else {
                    editor.setBorder(BorderFactory.createEmptyBorder());
                }
                JScrollPane scroll = new JScrollPane();
                scroll.setViewportView(editor);
                if (cell.hasBorder()) {
                    editor.setBorder(BorderFactory.createLineBorder(Color.BLACK, (int)cell.getBorder()));
                    scroll.setBorder(BorderFactory.createLineBorder(Color.BLACK, (int)cell.getBorder()));
                } else {
                    editor.setBorder(BorderFactory.createEmptyBorder());
                    scroll.setBorder(BorderFactory.createEmptyBorder());
                }
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = row.getColForCell(cell);
                this.gbc.gridy = tableRows;
                this.gbc.fill = 1;
                this.gbc.gridwidth = cell.getSpan();
                scroll.setPreferredSize(new Dimension(10, 100));
                this.panelTable.add((Component)scroll, this.gbc);
            }
            ++tableRows;
        }
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = tableRows;
        this.gbc.gridwidth = 0;
        this.gbc.fill = 1;
        this.gbc.weighty = 1.0;
        this.panelTable.add((Component)new JLabel(""), this.gbc);
        this.panelTable.revalidate();
        this.panelTable.repaint();
    }

    private JTextField createTextField() {
        JTextField fld = new JTextField();
        fld.setHorizontalAlignment(0);
        fld.setText("");
        fld.setCursor(new Cursor(2));
        fld.setPreferredSize(new Dimension(100, 25));
        return fld;
    }

    private void setCurrentEditor(JEditorPane e) {
        this.currentEditor = e;
    }

    private void setFocusOnGrouping(boolean flg) {
        this.focusOnGrouping = flg;
    }

    private void addPlaceholder() {
        PlaceholderReference phr = this.lstPlaceholder.getSelectedValue();
        String ph = null;
        if (phr != null) {
            ph = phr.getPlaceholderText();
        }
        if (this.focusOnGrouping) {
            this.fldGroupAttribute2.setText(this.fldGroupAttribute2.getText() + ph);
            return;
        }
        if (this.currentEditor != null && this.currentCell != null && ph != null) {
            Document document = this.currentEditor.getDocument();
            int cursor = this.currentEditor.getCaretPosition();
            try {
                document.insertString(cursor, "#!#" + ph + "#!#", null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            String txt = this.currentEditor.getText();
            this.currentCell.setContent(txt);
            this.currentEditor.revalidate();
            this.populateTable();
        }
    }

    private void updatePlaceholderList() {
        ArrayList<String> placeholders = new ArrayList<String>();
        Properties placeholderMapping = new Properties();
        try {
            placeholderMapping = Placeholder.loadMapping((String)"placeholder_mapping.properties");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        placeholders.addAll(placeholderMapping.stringPropertyNames());
        Collections.sort(placeholders);
        String filter = this.fldPlaceholderFilter.getText();
        boolean exactStart = false;
        ((DefaultListModel)this.lstPlaceholder.getModel()).removeAllElements();
        block15: for (String k : placeholders) {
            String v = placeholderMapping.getProperty(k);
            switch (v.toLowerCase()) {
                case "obs.observation-risk": 
                case "obs.rowheight": 
                case "obs.repeat": 
                case "obs.image-number": 
                case "obs.image-info": 
                case "obs.image-comment": 
                case "obs.location-plansnippet-per-location": 
                case "rep.event-signature": {
                    continue block15;
                }
            }
            if (v == null || v.indexOf("dummy") >= 0 || v.startsWith("obs.head1") || v.startsWith("obs.foot1") || v.startsWith("obs.pagebreak") || v.startsWith("rep.report-signature") || v.startsWith("doc.") || !"".equals(filter) && ((exactStart ? "#" : "") + k).indexOf((exactStart ? "#" : "") + filter) < 0) continue;
            ((DefaultListModel)this.lstPlaceholder.getModel()).addElement(new PlaceholderReference(k, v));
        }
        this.lstPlaceholder.revalidate();
    }

    private void setCellBorder(boolean set) {
        if (this.currentCell == null) {
            return;
        }
        int border = 0;
        if (set) {
            border = Integer.parseInt((String)this.fldCellBorderWidth.getSelectedItem());
        }
        this.currentCell.setBorder((float)border);
        this.populateTable();
    }

    public boolean doSave() {
        return this.save;
    }

    private void updateColor() {
        ColorOption co = (ColorOption)this.fldColor.getSelectedItem();
        switch (co.getMethod()) {
            case NOCOLOR: 
            case ATTRIBUTE: 
            case STATUS: {
                this.fldColorChooser.setVisible(false);
                this.fldColorChooserForeground.setVisible(false);
                break;
            }
            case STATIC: {
                co.setColor(Integer.valueOf(this.fldColorChooser.getBackground().getRGB()));
                co.setForegroundColor(Integer.valueOf(this.fldColorChooserForeground.getBackground().getRGB()));
            }
            default: {
                this.fldColorChooser.setVisible(true);
                this.fldColorChooserForeground.setVisible(true);
            }
        }
        this.jPanel1.revalidate();
        if (this.currentCell == null) {
            return;
        }
        this.currentCell.setBackground(co);
    }

    private void chooseColor() {
        if (this.currentCell != null) {
            Color c = JColorChooser.showDialog(this, "dialog.colorchooser.title", null);
            if (c != null) {
                this.fldColorChooser.setBackground(c);
                this.updateColor();
            }
        } else {
            Dialogs.getInstance().showWarningDialog("dialog.no-selection-in-table");
        }
    }

    private void chooseForegroundColor() {
        if (this.currentCell != null) {
            Color c = JColorChooser.showDialog(this, "dialog.colorchooser.title", null);
            if (c != null) {
                this.fldColorChooserForeground.setBackground(c);
                this.updateColor();
            }
        } else {
            Dialogs.getInstance().showWarningDialog("dialog.no-selection-in-table");
        }
    }

    private void applyGroupRows() {
        this.layout.setGroupRows(this.fldGroupRows.getText().trim());
    }

    private void storeLayout() {
        this.layoutUndo.add(this.layout.getXml());
        if (this.layoutUndo.size() > 20) {
            this.layoutUndo.remove(0);
        }
    }

    private void undoLayout() {
        if (this.layoutUndo.size() > 0) {
            this.layout.fromXML(this.layoutUndo.get(this.layoutUndo.size() - 1));
            this.layoutUndo.remove(this.layoutUndo.size() - 1);
        }
        this.populateTable();
    }

    private void applyHeadlines() {
        int h = Util.parseInt((String)this.fldHeadlines.getText(), (int)0);
        this.layout.setHeaderRowCount(h);
        this.populateTable();
    }

    private void initComponents() {
        this.buttonGroupRow = new ButtonGroup();
        this.buttonGroupAlign = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.panelTable = new JPanel();
        this.panelRight = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldName = new JTextField();
        this.lblProperties1 = new JLabel();
        this.btnUndo = new JButton();
        this.jLabel8 = new JLabel();
        this.btnAddRowAbove = new JButton();
        this.btnAddRowBelow = new JButton();
        this.btnMoveRowUp = new JButton();
        this.btnMoveRowDown = new JButton();
        this.btnDelRow = new JButton();
        this.jLabel21 = new JLabel();
        this.jPanel6 = new JPanel();
        this.fldRowHeight = new JTextField();
        this.jLabel22 = new JLabel();
        this.btnSetHeadlines1 = new JButton();
        this.btnSetNoHeadlines1 = new JButton();
        this.jLabel11 = new JLabel();
        this.btnAddColLeft = new JButton();
        this.btnAddColRight = new JButton();
        this.btnDelCol = new JButton();
        this.jLabel12 = new JLabel();
        this.btnSpanCell = new JButton();
        this.btnUnspanCell = new JButton();
        this.jLabel13 = new JLabel();
        this.jLabel4 = new JLabel();
        this.panelKopfzeile = new JPanel();
        this.fldHeadlines = new JTextField();
        this.btnSetHeadlines = new JButton();
        this.btnSetNoHeadlines = new JButton();
        this.jLabel16 = new JLabel();
        this.lblGruppierung = new JLabel();
        this.jLabel9 = new JLabel();
        this.fldGroupAttribute2 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jPanel2 = new JPanel();
        this.fldGroupRows = new JTextField();
        this.btnSetBorder1 = new JButton();
        this.btnSetNoBorder1 = new JButton();
        this.jLabel17 = new JLabel();
        this.jLabel10 = new JLabel();
        this.fldGroupNew = new JComboBox();
        this.jLabel1 = new JLabel();
        this.panelFilter = new JPanel();
        this.fldPlaceholderFilter = new JTextField();
        this.jButton6 = new JButton();
        this.scrollPlaceholder = new JScrollPane();
        this.lstPlaceholder = new JList();
        this.btnAddPlaceholder = new JButton();
        this.jLabel19 = new JLabel();
        this.fldFilter = new JComboBox();
        this.jLabel20 = new JLabel();
        this.fldSort = new JComboBox();
        this.jLabel5 = new JLabel();
        this.panelBottom = new JPanel();
        this.jLabel18 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.fldCellBorderWidth = new JComboBox();
        this.fldCellBorder = new JComboBox();
        this.btnCellFormatToRow = new JButton();
        this.jLabel14 = new JLabel();
        this.jPanel5 = new JPanel();
        this.fldCellFont = new JComboBox();
        this.fldCellFontSize = new JComboBox();
        this.fldCellFontColor = new JTextField();
        this.btnCellFontBold = new JToggleButton();
        this.btnCellFontUnderline = new JToggleButton();
        this.btnCellFontItlaic = new JToggleButton();
        this.btnCellFormatToTable = new JButton();
        this.jLabel6 = new JLabel();
        this.jPanel1 = new JPanel();
        this.fldColor = new JComboBox();
        this.fldColorChooser = new JTextField();
        this.fldColorChooserForeground = new JTextField();
        this.btnCellFormatCopy = new JButton();
        this.btnCellFormatPaste = new JButton();
        this.jLabel15 = new JLabel();
        this.jPanel4 = new JPanel();
        this.btnAlignLeft = new JToggleButton();
        this.btnAlignCenter = new JToggleButton();
        this.btnAlignRight = new JToggleButton();
        this.chkHideSameContent = new JCheckBox();
        this.lblEmpty = new JLabel();
        this.panelButtons = new JPanel();
        this.btnClose = new JButton();
        this.btnCloseSave = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 500));
        this.panelTable.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.panelTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.panelRight.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel2, gridBagConstraints);
        this.fldName.setFont(THEMIS.fontTextfield);
        this.fldName.setText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.fldName.text"));
        this.fldName.setPreferredSize(new Dimension(40, 30));
        this.fldName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutTableEditor.this.fldNameFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelRight.add((Component)this.fldName, gridBagConstraints);
        this.lblProperties1.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblProperties1, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.lblProperties1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.panelRight.add((Component)this.lblProperties1, gridBagConstraints);
        this.btnUndo.setFont(THEMIS.fontButton);
        this.btnUndo.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/undo-4-24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUndo, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnUndo.text"));
        this.btnUndo.setPreferredSize(new Dimension(50, 30));
        this.btnUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnUndoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnUndo, gridBagConstraints);
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel8, gridBagConstraints);
        this.btnAddRowAbove.setFont(THEMIS.fontButton);
        this.btnAddRowAbove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zeile-oben-einfuegen32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddRowAbove, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddCol.text"));
        this.btnAddRowAbove.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddRowAbove.toolTipText"));
        this.btnAddRowAbove.setPreferredSize(new Dimension(50, 30));
        this.btnAddRowAbove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnAddRowAboveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnAddRowAbove, gridBagConstraints);
        this.btnAddRowBelow.setFont(THEMIS.fontButton);
        this.btnAddRowBelow.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zeile-unten-einfuegen32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddRowBelow, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddRowBelow.text"));
        this.btnAddRowBelow.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddRowBelow.toolTipText"));
        this.btnAddRowBelow.setPreferredSize(new Dimension(50, 30));
        this.btnAddRowBelow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnAddRowBelowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnAddRowBelow, gridBagConstraints);
        this.btnMoveRowUp.setFont(THEMIS.fontButton);
        this.btnMoveRowUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zeile-nach-oben-schieben32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMoveRowUp, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnMoveRowUp.text"));
        this.btnMoveRowUp.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnMoveRowUp.toolTipText"));
        this.btnMoveRowUp.setPreferredSize(new Dimension(50, 30));
        this.btnMoveRowUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnMoveRowUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnMoveRowUp, gridBagConstraints);
        this.btnMoveRowDown.setFont(THEMIS.fontButton);
        this.btnMoveRowDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zeile-nach-unten-schieben32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMoveRowDown, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnMoveRowDown.text"));
        this.btnMoveRowDown.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnMoveRowDown.toolTipText"));
        this.btnMoveRowDown.setPreferredSize(new Dimension(50, 30));
        this.btnMoveRowDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnMoveRowDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnMoveRowDown, gridBagConstraints);
        this.btnDelRow.setFont(THEMIS.fontButton);
        this.btnDelRow.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDelRow, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddCol.text"));
        this.btnDelRow.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnDelRow.toolTipText"));
        this.btnDelRow.setPreferredSize(new Dimension(50, 30));
        this.btnDelRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnDelRowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnDelRow, gridBagConstraints);
        this.jLabel21.setFont(THEMIS.fontLabel);
        this.jLabel21.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel21, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel21.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel21, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.fldRowHeight.setFont(THEMIS.fontTextfield);
        this.fldRowHeight.setText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.fldRowHeight.text"));
        this.fldRowHeight.setMinimumSize(new Dimension(40, 25));
        this.fldRowHeight.setPreferredSize(new Dimension(60, 25));
        this.fldRowHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutTableEditor.this.fldRowHeightFocusLost(evt);
            }
        });
        this.fldRowHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.fldRowHeightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.fldRowHeight, gridBagConstraints);
        this.jLabel22.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel22, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel22.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.jLabel22, gridBagConstraints);
        this.btnSetHeadlines1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetHeadlines1, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnSetHeadlines1.text"));
        this.btnSetHeadlines1.setMinimumSize(new Dimension(30, 25));
        this.btnSetHeadlines1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnSetHeadlines1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.btnSetHeadlines1, gridBagConstraints);
        this.btnSetNoHeadlines1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetNoHeadlines1, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnSetNoHeadlines1.text"));
        this.btnSetNoHeadlines1.setMinimumSize(new Dimension(30, 25));
        this.btnSetNoHeadlines1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnSetNoHeadlines1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.btnSetNoHeadlines1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jPanel6, gridBagConstraints);
        this.jLabel11.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel11.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel11, gridBagConstraints);
        this.btnAddColLeft.setFont(THEMIS.fontButton);
        this.btnAddColLeft.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/spalte-einfuegen-links32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddColLeft, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddColLeft.text"));
        this.btnAddColLeft.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddColLeft.toolTipText"));
        this.btnAddColLeft.setPreferredSize(new Dimension(50, 30));
        this.btnAddColLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnAddColLeftActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnAddColLeft, gridBagConstraints);
        this.btnAddColRight.setFont(THEMIS.fontButton);
        this.btnAddColRight.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/spalte-einfuegen-rechts32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddColRight, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddColRight.text"));
        this.btnAddColRight.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddColRight.toolTipText"));
        this.btnAddColRight.setPreferredSize(new Dimension(50, 30));
        this.btnAddColRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnAddColRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnAddColRight, gridBagConstraints);
        this.btnDelCol.setFont(THEMIS.fontButton);
        this.btnDelCol.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDelCol, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddCol.text"));
        this.btnDelCol.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnDelCol.toolTipText"));
        this.btnDelCol.setPreferredSize(new Dimension(50, 30));
        this.btnDelCol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnDelColActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnDelCol, gridBagConstraints);
        this.jLabel12.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel12.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel12, gridBagConstraints);
        this.btnSpanCell.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zellen-verbinden32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSpanCell, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnSpanCell.text"));
        this.btnSpanCell.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnSpanCell.toolTipText"));
        this.btnSpanCell.setMinimumSize(new Dimension(50, 30));
        this.btnSpanCell.setPreferredSize(new Dimension(50, 30));
        this.btnSpanCell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnSpanCellActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnSpanCell, gridBagConstraints);
        this.btnUnspanCell.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zellen-trennen32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUnspanCell, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnUnspanCell.text"));
        this.btnUnspanCell.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnUnspanCell.toolTipText"));
        this.btnUnspanCell.setMinimumSize(new Dimension(50, 30));
        this.btnUnspanCell.setPreferredSize(new Dimension(50, 30));
        this.btnUnspanCell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnUnspanCellActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.btnUnspanCell, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel13.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel4, gridBagConstraints);
        this.panelKopfzeile.setLayout(new GridBagLayout());
        this.fldHeadlines.setFont(THEMIS.fontTextfield);
        this.fldHeadlines.setText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.fldHeadlines.text"));
        this.fldHeadlines.setMinimumSize(new Dimension(40, 25));
        this.fldHeadlines.setPreferredSize(new Dimension(60, 25));
        this.fldHeadlines.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutTableEditor.this.fldHeadlinesFocusLost(evt);
            }
        });
        this.fldHeadlines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.fldHeadlinesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelKopfzeile.add((Component)this.fldHeadlines, gridBagConstraints);
        this.btnSetHeadlines.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetHeadlines, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnSetHeadlines.text"));
        this.btnSetHeadlines.setMinimumSize(new Dimension(30, 25));
        this.btnSetHeadlines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnSetHeadlinesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelKopfzeile.add((Component)this.btnSetHeadlines, gridBagConstraints);
        this.btnSetNoHeadlines.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetNoHeadlines, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnSetNoHeadlines.text"));
        this.btnSetNoHeadlines.setMinimumSize(new Dimension(30, 25));
        this.btnSetNoHeadlines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnSetNoHeadlinesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelKopfzeile.add((Component)this.btnSetNoHeadlines, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel16, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel16.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panelKopfzeile.add((Component)this.jLabel16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.panelKopfzeile, gridBagConstraints);
        this.lblGruppierung.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblGruppierung, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.lblGruppierung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.panelRight.add((Component)this.lblGruppierung, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel9, gridBagConstraints);
        this.fldGroupAttribute2.setText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.fldGroupAttribute2.text"));
        this.fldGroupAttribute2.setMinimumSize(new Dimension(100, 25));
        this.fldGroupAttribute2.setPreferredSize(new Dimension(100, 25));
        this.fldGroupAttribute2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LayoutTableEditor.this.fldGroupAttribute2FocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutTableEditor.this.fldGroupAttribute2FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.fldGroupAttribute2, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel7, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.fldGroupRows.setFont(THEMIS.fontTextfield);
        this.fldGroupRows.setText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.fldGroupRows.text"));
        this.fldGroupRows.setMinimumSize(new Dimension(40, 25));
        this.fldGroupRows.setPreferredSize(new Dimension(60, 25));
        this.fldGroupRows.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutTableEditor.this.fldGroupRowsFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.fldGroupRows, gridBagConstraints);
        this.btnSetBorder1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetBorder1, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnSetBorder1.text"));
        this.btnSetBorder1.setMinimumSize(new Dimension(30, 25));
        this.btnSetBorder1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnSetBorder1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnSetBorder1, gridBagConstraints);
        this.btnSetNoBorder1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetNoBorder1, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnSetNoBorder1.text"));
        this.btnSetNoBorder1.setMinimumSize(new Dimension(30, 25));
        this.btnSetNoBorder1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnSetNoBorder1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnSetNoBorder1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel17, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel17.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel2.add((Component)this.jLabel17, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel10.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel10, gridBagConstraints);
        this.fldGroupNew.setFont(THEMIS.fontList);
        this.fldGroupNew.setModel(new DefaultComboBoxModel<String>(new String[]{"nichts", "Neue Tabelle", "Seitenwechsel"}));
        this.fldGroupNew.setMinimumSize(new Dimension(100, 25));
        this.fldGroupNew.setPreferredSize(new Dimension(100, 25));
        this.fldGroupNew.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor.this.fldGroupNewItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add(this.fldGroupNew, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel1, gridBagConstraints);
        this.panelFilter.setLayout(new GridBagLayout());
        this.fldPlaceholderFilter.setText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.fldPlaceholderFilter.text"));
        this.fldPlaceholderFilter.setPreferredSize(new Dimension(40, 30));
        this.fldPlaceholderFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.fldPlaceholderFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panelFilter.add((Component)this.fldPlaceholderFilter, gridBagConstraints);
        this.jButton6.setFont(THEMIS.fontButton);
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jButton6.text"));
        this.jButton6.setPreferredSize(new Dimension(50, 30));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.jButton6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.panelFilter.add((Component)this.jButton6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.panelFilter, gridBagConstraints);
        this.lstPlaceholder.setModel(new DefaultListModel());
        this.lstPlaceholder.setPreferredSize(null);
        this.lstPlaceholder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LayoutTableEditor.this.lstPlaceholderMouseClicked(evt);
            }
        });
        this.scrollPlaceholder.setViewportView(this.lstPlaceholder);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelRight.add((Component)this.scrollPlaceholder, gridBagConstraints);
        this.btnAddPlaceholder.setFont(THEMIS.fontButton);
        this.btnAddPlaceholder.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddPlaceholder, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAddPlaceholder.text"));
        this.btnAddPlaceholder.setPreferredSize(new Dimension(50, 30));
        this.btnAddPlaceholder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnAddPlaceholderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelRight.add((Component)this.btnAddPlaceholder, gridBagConstraints);
        this.jLabel19.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel19, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel19.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel19, gridBagConstraints);
        this.fldFilter.setFont(THEMIS.fontList);
        this.fldFilter.setModel(new DefaultComboBoxModel());
        this.fldFilter.setMinimumSize(new Dimension(100, 25));
        this.fldFilter.setPreferredSize(new Dimension(100, 25));
        this.fldFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor.this.fldFilterItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add(this.fldFilter, gridBagConstraints);
        this.jLabel20.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel20, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel20.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel20, gridBagConstraints);
        this.fldSort.setFont(THEMIS.fontList);
        this.fldSort.setModel(new DefaultComboBoxModel());
        this.fldSort.setMinimumSize(new Dimension(100, 25));
        this.fldSort.setPreferredSize(new Dimension(100, 25));
        this.fldSort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor.this.fldSortItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add(this.fldSort, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.panelRight.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelRight, gridBagConstraints);
        this.panelBottom.setLayout(new GridBagLayout());
        this.jLabel18.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel18, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel18.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.panelBottom.add((Component)this.jLabel18, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 5);
        this.panelBottom.add((Component)this.jLabel3, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.fldCellBorderWidth.setFont(THEMIS.fontList);
        this.fldCellBorderWidth.setModel(new DefaultComboBoxModel());
        this.fldCellBorderWidth.setMinimumSize(new Dimension(60, 25));
        this.fldCellBorderWidth.setPreferredSize(new Dimension(60, 25));
        this.fldCellBorderWidth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor.this.fldCellBorderWidthItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel3.add(this.fldCellBorderWidth, gridBagConstraints);
        this.fldCellBorder.setFont(THEMIS.fontList);
        this.fldCellBorder.setModel(new DefaultComboBoxModel());
        this.fldCellBorder.setMinimumSize(new Dimension(100, 25));
        this.fldCellBorder.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel3.add(this.fldCellBorder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelBottom.add((Component)this.jPanel3, gridBagConstraints);
        this.btnCellFormatToRow.setFont(THEMIS.fontButton);
        this.btnCellFormatToRow.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/apply-cell-format-row32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFormatToRow, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFormatToRow.text"));
        this.btnCellFormatToRow.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFormatToRow.toolTipText"));
        this.btnCellFormatToRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnCellFormatToRowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.panelBottom.add((Component)this.btnCellFormatToRow, gridBagConstraints);
        this.jLabel14.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel14.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 5);
        this.panelBottom.add((Component)this.jLabel14, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.fldCellFont.setFont(THEMIS.fontList);
        this.fldCellFont.setModel(new DefaultComboBoxModel());
        this.fldCellFont.setMinimumSize(new Dimension(100, 25));
        this.fldCellFont.setPreferredSize(null);
        this.fldCellFont.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor.this.fldCellFontItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel5.add(this.fldCellFont, gridBagConstraints);
        this.fldCellFontSize.setFont(THEMIS.fontList);
        this.fldCellFontSize.setModel(new DefaultComboBoxModel());
        this.fldCellFontSize.setMinimumSize(new Dimension(60, 25));
        this.fldCellFontSize.setPreferredSize(new Dimension(60, 25));
        this.fldCellFontSize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor.this.fldCellFontSizeItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel5.add(this.fldCellFontSize, gridBagConstraints);
        this.fldCellFontColor.setBackground(new Color(4, 30, 100));
        this.fldCellFontColor.setText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.fldCellFontColor.text"));
        this.fldCellFontColor.setEnabled(false);
        this.fldCellFontColor.setMinimumSize(new Dimension(50, 25));
        this.fldCellFontColor.setPreferredSize(new Dimension(50, 25));
        this.fldCellFontColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LayoutTableEditor.this.fldCellFontColorMouseClicked(evt);
            }
        });
        this.fldCellFontColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.fldCellFontColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel5.add((Component)this.fldCellFontColor, gridBagConstraints);
        this.btnCellFontBold.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFontBold, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFontBold.text"));
        this.btnCellFontBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnCellFontBoldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 15, 2, 5);
        this.jPanel5.add((Component)this.btnCellFontBold, gridBagConstraints);
        this.btnCellFontUnderline.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFontUnderline, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFontUnderline.text"));
        this.btnCellFontUnderline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnCellFontUnderlineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel5.add((Component)this.btnCellFontUnderline, gridBagConstraints);
        this.btnCellFontItlaic.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFontItlaic, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFontItlaic.text"));
        this.btnCellFontItlaic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnCellFontItlaicActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel5.add((Component)this.btnCellFontItlaic, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelBottom.add((Component)this.jPanel5, gridBagConstraints);
        this.btnCellFormatToTable.setFont(THEMIS.fontButton);
        this.btnCellFormatToTable.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/apply-cell-format-table32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFormatToTable, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFormatToTable.text"));
        this.btnCellFormatToTable.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFormatToTable.toolTipText"));
        this.btnCellFormatToTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnCellFormatToTableActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.panelBottom.add((Component)this.btnCellFormatToTable, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 5);
        this.panelBottom.add((Component)this.jLabel6, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.fldColor.setFont(THEMIS.fontList);
        this.fldColor.setModel(new DefaultComboBoxModel());
        this.fldColor.setMinimumSize(new Dimension(100, 25));
        this.fldColor.setPreferredSize(new Dimension(100, 25));
        this.fldColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor.this.fldColorItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel1.add(this.fldColor, gridBagConstraints);
        this.fldColorChooser.setBackground(new Color(4, 30, 100));
        this.fldColorChooser.setText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.fldColorChooser.text"));
        this.fldColorChooser.setCursor(new Cursor(0));
        this.fldColorChooser.setEnabled(false);
        this.fldColorChooser.setMinimumSize(new Dimension(50, 25));
        this.fldColorChooser.setPreferredSize(new Dimension(50, 25));
        this.fldColorChooser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LayoutTableEditor.this.fldColorChooserMouseClicked(evt);
            }
        });
        this.fldColorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.fldColorChooserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel1.add((Component)this.fldColorChooser, gridBagConstraints);
        this.fldColorChooserForeground.setBackground(new Color(4, 30, 100));
        this.fldColorChooserForeground.setText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.fldColorChooserForeground.text"));
        this.fldColorChooserForeground.setCursor(new Cursor(0));
        this.fldColorChooserForeground.setEnabled(false);
        this.fldColorChooserForeground.setMinimumSize(new Dimension(50, 25));
        this.fldColorChooserForeground.setPreferredSize(new Dimension(50, 25));
        this.fldColorChooserForeground.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LayoutTableEditor.this.fldColorChooserForegroundMouseClicked(evt);
            }
        });
        this.fldColorChooserForeground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.fldColorChooserForegroundActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel1.add((Component)this.fldColorChooserForeground, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelBottom.add((Component)this.jPanel1, gridBagConstraints);
        this.btnCellFormatCopy.setFont(THEMIS.fontButton);
        this.btnCellFormatCopy.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copyFormat32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFormatCopy, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFormatCopy.text"));
        this.btnCellFormatCopy.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFormatCopy.toolTipText"));
        this.btnCellFormatCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnCellFormatCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.panelBottom.add((Component)this.btnCellFormatCopy, gridBagConstraints);
        this.btnCellFormatPaste.setFont(THEMIS.fontButton);
        this.btnCellFormatPaste.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/pasteFormat32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFormatPaste, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFormatPaste.text"));
        this.btnCellFormatPaste.setToolTipText(NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCellFormatPaste.toolTipText"));
        this.btnCellFormatPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnCellFormatPasteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.panelBottom.add((Component)this.btnCellFormatPaste, gridBagConstraints);
        this.jLabel15.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.jLabel15.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 5);
        this.panelBottom.add((Component)this.jLabel15, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.buttonGroupAlign.add(this.btnAlignLeft);
        this.btnAlignLeft.setFont(THEMIS.fontLabelBold);
        this.btnAlignLeft.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/align_left.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAlignLeft, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAlignLeft.text"));
        this.btnAlignLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnAlignLeftActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel4.add((Component)this.btnAlignLeft, gridBagConstraints);
        this.buttonGroupAlign.add(this.btnAlignCenter);
        this.btnAlignCenter.setFont(THEMIS.fontLabelBold);
        this.btnAlignCenter.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/align_center.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAlignCenter, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAlignCenter.text"));
        this.btnAlignCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnAlignCenterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel4.add((Component)this.btnAlignCenter, gridBagConstraints);
        this.buttonGroupAlign.add(this.btnAlignRight);
        this.btnAlignRight.setFont(THEMIS.fontLabelBold);
        this.btnAlignRight.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/align_right.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAlignRight, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnAlignRight.text"));
        this.btnAlignRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnAlignRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel4.add((Component)this.btnAlignRight, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkHideSameContent, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.chkHideSameContent.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel4.add((Component)this.chkHideSameContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelBottom.add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.lblEmpty.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelBottom.add((Component)this.lblEmpty, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.panelBottom, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnClose.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnClose.text"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnClose, gridBagConstraints);
        this.btnCloseSave.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCloseSave, (String)NbBundle.getMessage(LayoutTableEditor.class, (String)"LayoutTableEditor.btnCloseSave.text"));
        this.btnCloseSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor.this.btnCloseSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnCloseSave, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void btnAddRowAboveActionPerformed(ActionEvent evt) {
        this.storeLayout();
        int idx = 0;
        if (this.currentCell != null) {
            int n = idx = this.currentCell == null ? -1 : this.currentCell.getRow().getRowIndex();
        }
        if (idx < 0) {
            this.layout.addRow();
        } else {
            this.layout.addRow(idx);
        }
        this.populateTable();
    }

    private void btnAddColLeftActionPerformed(ActionEvent evt) {
        int idx;
        this.storeLayout();
        int n = idx = this.currentCell == null ? -1 : this.currentCell.getColumnIndex();
        if (idx < 0) {
            this.layout.addColumn(1);
        } else {
            this.layout.addColumn(idx, 1);
        }
        this.populateTable();
    }

    private void btnAddPlaceholderActionPerformed(ActionEvent evt) {
        this.storeLayout();
        this.addPlaceholder();
    }

    private void btnDelRowActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.storeLayout();
            this.layout.delRow(this.currentCell.getRow());
            this.populateTable();
        }
    }

    private void btnDelColActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.storeLayout();
            int col = this.currentCell.getColumnIndex();
            this.layout.removeColumn(col);
            this.populateTable();
        }
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.updatePlaceholderList();
    }

    private void lstPlaceholderMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.addPlaceholder();
        }
    }

    private void btnSpanCellActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.storeLayout();
            this.currentCell.span();
            this.populateTable();
        }
    }

    private void btnUnspanCellActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.storeLayout();
            this.currentCell.unspan();
            this.populateTable();
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void fldNameFocusLost(FocusEvent evt) {
        this.layout.setName(this.fldName.getText());
    }

    private void btnCloseSaveActionPerformed(ActionEvent evt) {
        if ("".equals(this.fldName.getText())) {
            Dialogs.getInstance().showErrorDialog("error.layouttableeditor.nameRequired");
        } else if (this.forbiddenNames.contains(this.fldName.getText())) {
            Dialogs.getInstance().showErrorDialog("error.layouttableeditor.nameInUse");
        } else {
            this.save = true;
            this.closeDialog();
        }
    }

    private void btnSetHeadlinesActionPerformed(ActionEvent evt) {
        this.applyHeadlines();
    }

    private void fldPlaceholderFilterActionPerformed(ActionEvent evt) {
        this.updatePlaceholderList();
    }

    private void btnSetNoHeadlinesActionPerformed(ActionEvent evt) {
        this.fldHeadlines.setText("");
        this.layout.setHeaderRowCount(0);
    }

    private void fldColorItemStateChanged(ItemEvent evt) {
        if (!this.flagUpdating && evt.getStateChange() == 1) {
            this.updateColor();
        }
    }

    private void fldColorChooserMouseClicked(MouseEvent evt) {
        this.chooseColor();
    }

    private void fldColorChooserActionPerformed(ActionEvent evt) {
        this.chooseColor();
    }

    private void fldColorChooserForegroundMouseClicked(MouseEvent evt) {
        this.chooseForegroundColor();
    }

    private void fldColorChooserForegroundActionPerformed(ActionEvent evt) {
        this.chooseForegroundColor();
    }

    private void fldHeadlinesActionPerformed(ActionEvent evt) {
        int h = Util.parseInt((String)this.fldHeadlines.getText(), (int)0);
        this.layout.setHeaderRowCount(h);
        this.populateTable();
    }

    private void btnSetBorder1ActionPerformed(ActionEvent evt) {
        this.applyGroupRows();
    }

    private void btnSetNoBorder1ActionPerformed(ActionEvent evt) {
        this.fldGroupRows.setText("");
    }

    private void btnAddRowBelowActionPerformed(ActionEvent evt) {
        this.storeLayout();
        int idx = this.layout.getNumberOfRows() - 1;
        if (this.currentCell != null) {
            idx = this.currentCell.getRow().getRowIndex();
        }
        if (idx < 0) {
            this.layout.addRow();
        } else if (idx >= this.layout.getNumberOfRows() - 1) {
            this.layout.addRow();
        } else {
            this.layout.addRow(idx + 1);
        }
        this.populateTable();
    }

    private void btnMoveRowUpActionPerformed(ActionEvent evt) {
        this.storeLayout();
        LayoutRow row = this.currentCell.getRow();
        int idx = this.layout.getRows().indexOf(row);
        if (idx > 0) {
            Collections.swap(this.layout.getRows(), idx, idx - 1);
        }
        this.populateTable();
    }

    private void btnMoveRowDownActionPerformed(ActionEvent evt) {
        this.storeLayout();
        LayoutRow row = this.currentCell.getRow();
        int idx = this.layout.getRows().indexOf(row);
        if (idx < this.layout.getRows().size() - 1) {
            Collections.swap(this.layout.getRows(), idx, idx + 1);
        }
        this.populateTable();
    }

    private void btnAddColRightActionPerformed(ActionEvent evt) {
        int idx;
        this.storeLayout();
        int n = idx = this.currentCell == null ? -1 : this.currentCell.getColumnIndex();
        if (idx < 0) {
            this.layout.addColumn(1);
        } else if (idx >= this.layout.getNumberOfCols() - 1) {
            this.layout.addColumn(1);
        } else {
            this.layout.addColumn(idx + 1, 1);
        }
        this.populateTable();
    }

    private void fldCellFontColorMouseClicked(MouseEvent evt) {
    }

    private void fldCellFontColorActionPerformed(ActionEvent evt) {
    }

    private void fldCellBorderWidthItemStateChanged(ItemEvent evt) {
        if (this.currentCell != null) {
            this.setCellBorder(this.fldCellBorderWidth.getSelectedIndex() > 0);
            this.populateTable();
        }
    }

    private void fldCellFontSizeItemStateChanged(ItemEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.setFontSize(Util.parseInt((String)((String)this.fldCellFontSize.getSelectedItem()), (int)12));
            this.populateTable();
        }
    }

    private void fldCellFontItemStateChanged(ItemEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.setFontFamily((String)this.fldCellFont.getSelectedItem());
            this.populateTable();
        }
    }

    private void btnCellFontBoldActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.setFontBold(!this.currentCell.isFontBold());
            this.btnCellFontBold.setSelected(this.currentCell.isFontBold());
            this.populateTable();
        }
    }

    private void btnCellFontUnderlineActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.setFontUnderlined(!this.currentCell.isFontUnderlined());
            this.btnCellFontUnderline.setSelected(this.currentCell.isFontUnderlined());
            this.populateTable();
        }
    }

    private void btnCellFontItlaicActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.setFontItalic(!this.currentCell.isFontItalic());
            this.btnCellFontItlaic.setSelected(this.currentCell.isFontItalic());
            this.populateTable();
        }
    }

    private void btnCellFormatCopyActionPerformed(ActionEvent evt) {
        this.copyCellFormat = null;
        if (this.currentCell != null) {
            this.copyCellFormat = this.currentCell.getAsElement();
        }
    }

    private void btnCellFormatPasteActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && this.copyCellFormat != null) {
            this.storeLayout();
            this.currentCell.setFromElement(this.copyCellFormat, true);
            this.populateTable();
        }
    }

    private void btnCellFormatToRowActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && !this.flagUpdating) {
            this.storeLayout();
            Element f = this.currentCell.getAsElement();
            for (LayoutCell c : this.currentCell.getRow().getCells()) {
                c.setFromElement(f, true);
            }
            this.populateTable();
        }
    }

    private void btnCellFormatToTableActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && !this.flagUpdating) {
            this.storeLayout();
            Element f = this.currentCell.getAsElement();
            ArrayList<LayoutCell> cells = new ArrayList<LayoutCell>();
            for (LayoutRow r : this.layout.getRows()) {
                for (LayoutCell c : r.getCells()) {
                    cells.add(c);
                }
            }
            for (LayoutCell c : cells) {
                c.setFromElement(f, true);
            }
            this.populateTable();
        }
    }

    private void btnUndoActionPerformed(ActionEvent evt) {
        this.undoLayout();
    }

    private void fldFilterItemStateChanged(ItemEvent evt) {
        CmsBasicElement be = (CmsBasicElement)this.fldFilter.getSelectedItem();
        if (be != null && be.getId() > 0L) {
            this.layout.setFilter(be.getTitle());
        } else {
            this.layout.setFilter(null);
        }
    }

    private void fldSortItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.layout.setSort((AttributeSqlPair)this.fldSort.getSelectedItem());
        }
    }

    private void btnAlignLeftActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && !this.flagUpdating) {
            this.storeLayout();
            this.currentCell.setAlign(LayoutCell.Align.LEFT);
            this.populateTable();
        }
    }

    private void btnAlignCenterActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && !this.flagUpdating) {
            this.storeLayout();
            this.currentCell.setAlign(LayoutCell.Align.CENTER);
            this.populateTable();
        }
    }

    private void btnAlignRightActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && !this.flagUpdating) {
            this.storeLayout();
            this.currentCell.setAlign(LayoutCell.Align.RIGHT);
            this.populateTable();
        }
    }

    private void fldGroupNewItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            switch (this.fldGroupNew.getSelectedIndex()) {
                case 0: {
                    this.layout.setGroupNewTable(false);
                    this.layout.setGroupPagebreak(false);
                    break;
                }
                case 1: {
                    this.layout.setGroupNewTable(true);
                    this.layout.setGroupPagebreak(false);
                    break;
                }
                case 2: {
                    this.layout.setGroupNewTable(true);
                    this.layout.setGroupPagebreak(true);
                }
            }
        }
    }

    private void fldHeadlinesFocusLost(FocusEvent evt) {
        this.applyHeadlines();
    }

    private void fldGroupRowsFocusLost(FocusEvent evt) {
        this.applyGroupRows();
    }

    private void fldRowHeightFocusLost(FocusEvent evt) {
    }

    private void fldRowHeightActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.getRow().setHeight(Util.parseInt((String)this.fldRowHeight.getText(), (int)-1));
        }
    }

    private void btnSetHeadlines1ActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.getRow().setHeight(Util.parseInt((String)this.fldRowHeight.getText(), (int)-1));
        }
    }

    private void btnSetNoHeadlines1ActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.getRow().setHeight(-1);
            this.fldRowHeight.setText("");
        }
    }

    private void fldGroupAttribute2FocusLost(FocusEvent evt) {
        this.layout.setGroupPlaceholder(this.fldGroupAttribute2.getText());
        this.setFocusOnGrouping(false);
    }

    private void fldGroupAttribute2FocusGained(FocusEvent evt) {
        this.setFocusOnGrouping(true);
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(ThemisApplication.getInstance().getProject().getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, true);
        THEMIS.setAssistantMoveListener(dlg);
        THEMIS.applyWindowSizeAndLocation(this.DIALOG_CODE, dlg, 1100, 900);
        dlg.setVisible(true);
    }

    private void closeDialog() {
        this.layout.setName(this.fldName.getText());
        JDialog parent = (JDialog)this.getRootPane().getParent();
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, parent);
        parent.dispose();
    }
}

