/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.report.layout;

import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.report.AttributeSqlPair;
import at.grid.themis.ontology.report.LayoutCell;
import at.grid.themis.ontology.report.LayoutRow;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.PlaceholderReference;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jdom.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LayoutTableEditor2
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ReportTableLayout layout;
    ArrayList<Element> layoutUndo = new ArrayList();
    GridBagConstraints gbc;
    int currentCol = -1;
    LayoutCell currentCell = null;
    JEditorPane currentEditor = null;
    HashMap<LayoutCell, JEditorPane> editorPanes = new HashMap();
    boolean save = false;
    private boolean flagUpdating;
    ArrayList<String> forbiddenNames = new ArrayList();
    private Element copyCellFormat;
    boolean focusOnGrouping = false;
    private JButton btnAddColLeft;
    private JButton btnAddColRight;
    private JButton btnAddPlaceholder;
    private JButton btnAddRowAbove;
    private JButton btnAddRowBelow;
    private JToggleButton btnAlignCenter;
    private JToggleButton btnAlignLeft;
    private JToggleButton btnAlignRight;
    private JToggleButton btnCellFontBold;
    private JToggleButton btnCellFontItlaic;
    private JToggleButton btnCellFontUnderline;
    private JButton btnCellFormatCopy;
    private JButton btnCellFormatPaste;
    private JButton btnCellFormatToRow;
    private JButton btnCellFormatToTable;
    private JButton btnClose;
    private JButton btnCloseSave;
    private JButton btnDelCol;
    private JButton btnDelRow;
    private JButton btnMoveRowDown;
    private JButton btnMoveRowUp;
    private JButton btnSpanCell;
    private JButton btnUndo;
    private JButton btnUnspanCell;
    private ButtonGroup buttonGroupAlign;
    private ButtonGroup buttonGroupRow;
    private JLabel empty;
    private JLabel empty1;
    private JComboBox<String> fldCellBorderWidth;
    private JComboBox<String> fldCellFontSize;
    private JComboBox<ColorOption> fldColor;
    private JTextField fldColorChooser;
    private JTextField fldColorChooserForeground;
    private JComboBox<CmsBasicElement> fldFilter;
    private JTextField fldGroupAttribute;
    private JComboBox<String> fldGroupNew;
    private JTextField fldGroupRows;
    private JTextField fldHeadlines;
    private JTextField fldName;
    private JTextField fldPlaceholderFilter;
    private JTextField fldRowHeight;
    private JComboBox<AttributeSqlPair> fldSort;
    private JButton jButton6;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel2;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JLabel lblGruppierung;
    private JList<PlaceholderReference> lstPlaceholder;
    private JPanel panel1oben;
    private JPanel panel2oben;
    private JPanel panel3oben;
    private JPanel panelButtons;
    private JPanel panelCellButtons;
    private JPanel panelCellText;
    private JPanel panelColButtons;
    private JPanel panelColText;
    private JPanel panelFilter;
    private JPanel panelFormatCell;
    private JPanel panelRight;
    private JPanel panelRowButtons;
    private JPanel panelRowText;
    private JPanel panelTable;
    private JScrollPane scrollPlaceholder;
    private String DIALOG_CODE = "tablelayout";
    public static final int DIALOG_WIDTH = 1100;
    public static final int DIALOG_HEIGHT = 900;

    public LayoutTableEditor2() {
        this(ThemisApplication.getInstance().getProject().getNewReportTableName("Neues Layout"));
    }

    public LayoutTableEditor2(String name) {
        this.layout = (ReportTableLayout)this.app.getProject().createElement("reporttable");
        this.layout.clear();
        this.layout.setName(name);
        this.initialise();
    }

    public LayoutTableEditor2(ReportTableLayout rtl) {
        this.layout = rtl;
        this.initialise();
    }

    private void initialise() {
        this.initComponents();
        this.updatePlaceholderList();
        ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.none")));
        ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.static"), Integer.valueOf(this.fldColorChooser.getBackground().getRGB())));
        ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.status"), this.app.getSettings().getObservationAttribute("done")));
        ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.urgency"), this.app.getSettings().getObservationAttribute("duedate")));
        ThemisSettings settings = this.app.getSettings();
        for (ThemisAttribute ta : settings.getObservationAttributesUsed()) {
            if (ta.getTypeId() != ThemisAttribute.Type.LIST || ta.getId().equals("documents")) continue;
            ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption("B." + ta.getLabel(), ta));
        }
        for (ThemisAttribute ta : settings.getLocationAttributesUsed()) {
            if (ta.getTypeId() != ThemisAttribute.Type.LIST || ta.getId().equals("documents")) continue;
            ((DefaultComboBoxModel)this.fldColor.getModel()).addElement(new ColorOption("G." + ta.getLabel(), ta));
        }
        String grouping = this.layout.getGroupPlaceholder();
        this.fldGroupAttribute.setText(grouping);
        this.fldGroupRows.setText(this.layout.getGroupRowsAsString());
        if (this.layout.getGroupPagebreak()) {
            this.fldGroupNew.setSelectedIndex(2);
        } else if (this.layout.getGroupNewTable()) {
            this.fldGroupNew.setSelectedIndex(1);
        } else {
            this.fldGroupNew.setSelectedIndex(0);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ArrayList<String> fontfamilies = new ArrayList<String>();
        for (Font f : ge.getAllFonts()) {
            if (!f.canDisplay('\u00e4') || fontfamilies.contains(f.getFamily())) continue;
            fontfamilies.add(f.getFamily());
        }
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("6");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("8");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("10");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("11");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("12");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("14");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("16");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("18");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("22");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("26");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("32");
        ((DefaultComboBoxModel)this.fldCellFontSize.getModel()).addElement("40");
        ((DefaultComboBoxModel)this.fldCellBorderWidth.getModel()).addElement("0");
        ((DefaultComboBoxModel)this.fldCellBorderWidth.getModel()).addElement("1");
        ((DefaultComboBoxModel)this.fldCellBorderWidth.getModel()).addElement("2");
        ((DefaultComboBoxModel)this.fldCellBorderWidth.getModel()).addElement("3");
        ((DefaultComboBoxModel)this.fldCellBorderWidth.getModel()).addElement("4");
        boolean useLocationPrefix = this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useLocationSuffix = this.app.getSettings().getLocationAttribute("suffix").isUsed();
        String numberSort = (useLocationPrefix ? "ele.prenumber," : "") + "ele.number" + (useLocationSuffix ? ",ele.postnumber" : "");
        String observationSort = ",observation.number,observation.idelement";
        AttributeSqlPair selSort = this.layout.getSort();
        this.fldSort.addItem(new AttributeSqlPair("-", null));
        this.fldSort.addItem(new AttributeSqlPair("Geb\u00e4ude,Plan,Nummer", "building.title,plan.sort," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Nummer (Gegenstand und Beobachtung)", numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Termin,Nummer", "observation.duedate," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Gruppe,Gegenstand", "locationgroupsort,ele.titel," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Gegenstand", "ele.titel," + numberSort + observationSort));
        this.fldSort.addItem(new AttributeSqlPair("Kontakt,Nummer", "contact.name," + numberSort + observationSort));
        if (selSort != null) {
            int selIdx = -1;
            for (int ii = 0; ii < this.fldSort.getItemCount(); ++ii) {
                if (!selSort.equals(this.fldSort.getItemAt(ii).getSql())) continue;
                selIdx = ii;
                break;
            }
            this.fldSort.setSelectedIndex(selIdx);
        }
        long idFilter = this.layout.getFilterId();
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.fldFilter.getModel();
        m.removeAllElements();
        m.addElement(new CmsBasicElement(-1L, "-"));
        CmsBasicElement sel = null;
        for (CmsBasicElement be : this.app.getProject().getFilters()) {
            m.addElement(be);
            if (be.getId() != idFilter) continue;
            sel = be;
        }
        if (sel != null) {
            this.fldFilter.setSelectedItem(sel);
        }
        this.populateTable();
        this.btnCellFontItlaic.setVisible(false);
    }

    public void setForbiddenNames(ArrayList<String> names) {
        this.forbiddenNames.addAll(names);
    }

    public ReportTableLayout getTableLayout() {
        return this.layout;
    }

    public void setCurrentCell(LayoutCell cell) {
        ColorOption co;
        this.currentCell = cell;
        for (int rr = 0; rr < this.layout.getNumberOfRows(); ++rr) {
            LayoutRow row = this.layout.getRow(rr);
            for (LayoutCell c : row.getCells()) {
                JEditorPane editor = this.editorPanes.get(c);
                if (c == this.currentCell) {
                    editor.setBackground(THEMIS.lightyellow);
                    continue;
                }
                if (rr < this.layout.getHeaderRowCount()) {
                    editor.setBackground(THEMIS.lightblue);
                    continue;
                }
                editor.setBackground(Color.WHITE);
            }
        }
        LayoutRow row = cell.getRow();
        int rowheight = row.getHeight();
        this.fldRowHeight.setText(rowheight >= 0 ? Integer.toString(rowheight) : "");
        this.flagUpdating = true;
        this.fldCellBorderWidth.setSelectedItem(cell == null ? "0" : Integer.toString((int)cell.getBorder()));
        LayoutCell.Align a = cell == null ? LayoutCell.Align.LEFT : cell.getAlign();
        switch (a) {
            case LEFT: {
                this.btnAlignLeft.setSelected(true);
                break;
            }
            case CENTER: {
                this.btnAlignCenter.setSelected(true);
                break;
            }
            case RIGHT: {
                this.btnAlignRight.setSelected(true);
                break;
            }
            default: {
                this.btnAlignLeft.setSelected(true);
            }
        }
        ColorOption colorOption = co = cell == null ? null : cell.getBackground();
        if (co == null) {
            this.fldColor.setSelectedIndex(0);
        } else {
            if (co.getMethod() == ColorOption.Method.STATIC) {
                this.fldColorChooser.setEnabled(true);
                this.fldColorChooserForeground.setVisible(true);
                Integer c = co.getStaticColor();
                this.fldColorChooser.setBackground(c == null ? Color.WHITE : new Color(c));
            } else {
                this.fldColorChooser.setEnabled(false);
                this.fldColorChooserForeground.setVisible(false);
            }
            for (int ii = 0; ii < this.fldColor.getItemCount(); ++ii) {
                if (this.fldColor.getItemAt(ii).getMethod() != co.getMethod()) continue;
                if (co.getMethod() == ColorOption.Method.ATTRIBUTE) {
                    if (!co.getAttribute().equals((Object)this.fldColor.getItemAt(ii).getAttribute())) continue;
                    this.fldColor.setSelectedIndex(ii);
                    this.fldColorChooser.setEnabled(ii == 1);
                    break;
                }
                this.fldColor.setSelectedIndex(ii);
                this.fldColorChooser.setEnabled(ii == 1);
                break;
            }
        }
        this.fldCellFontSize.setSelectedItem(cell == null ? "12" : Integer.toString(cell.getFontSize()));
        this.btnCellFontBold.setSelected(cell == null ? false : cell.isFontBold());
        this.btnCellFontUnderline.setSelected(cell == null ? false : cell.isFontUnderlined());
        this.btnCellFontItlaic.setSelected(cell == null ? false : cell.isFontItalic());
        this.flagUpdating = false;
    }

    private void populateTable() {
        this.panelTable.removeAll();
        int tableRows = 0;
        this.fldName.setText(this.layout.getName());
        this.fldHeadlines.setText(Integer.toString(this.layout.getHeaderRowCount()));
        int cc = 0;
        while (cc < this.layout.getNumberOfCols()) {
            final int ccFinal = cc;
            int width = this.layout.getCol(cc);
            this.gbc = new GridBagConstraints();
            this.gbc.gridx = cc++;
            this.gbc.gridy = 0;
            this.gbc.weightx = width;
            this.gbc.fill = 2;
            this.gbc.insets = new Insets(2, 2, 2, 2);
            final JTextField fld = this.createTextField();
            fld.setText(Integer.toString(width));
            fld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LayoutTableEditor2.this.layout.setColWidth(ccFinal, Integer.parseInt(fld.getText()));
                    LayoutTableEditor2.this.populateTable();
                }
            });
            fld.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    LayoutTableEditor2.this.layout.setColWidth(ccFinal, Integer.parseInt(fld.getText()));
                    LayoutTableEditor2.this.populateTable();
                }
            });
            this.panelTable.add((Component)fld, this.gbc);
        }
        ++tableRows;
        for (int rr = 0; rr < this.layout.getNumberOfRows(); ++rr) {
            LayoutRow row = this.layout.getRow(rr);
            for (final LayoutCell cell : row.getCells()) {
                JTextPane cellEditor = (JTextPane)this.editorPanes.get(cell);
                final JTextPane editor = cellEditor == null ? new JTextPane() : cellEditor;
                StyledDocument style = editor.getStyledDocument();
                SimpleAttributeSet align = new SimpleAttributeSet();
                int a = 0;
                switch (cell.getAlign()) {
                    case RIGHT: {
                        a = 2;
                        break;
                    }
                    case CENTER: {
                        a = 1;
                    }
                }
                StyleConstants.setAlignment(align, a);
                float indentLeftRight = 3.0f;
                float indentTopBottom = 1.0f;
                StyleConstants.setLeftIndent(align, indentLeftRight);
                StyleConstants.setRightIndent(align, indentLeftRight);
                StyleConstants.setSpaceAbove(align, indentTopBottom);
                StyleConstants.setSpaceBelow(align, indentTopBottom);
                StyleConstants.setFontFamily(align, cell.getFontFamily());
                StyleConstants.setFontSize(align, Math.round((float)cell.getFontSize() * 1.2f));
                StyleConstants.setBold(align, cell.isFontBold());
                StyleConstants.setUnderline(align, cell.isFontUnderlined());
                StyleConstants.setItalic(align, cell.isFontItalic());
                style.setParagraphAttributes(0, style.getLength(), align, false);
                if (cell == this.currentCell) {
                    editor.setBackground(THEMIS.lightyellow);
                } else if (rr < this.layout.getHeaderRowCount()) {
                    editor.setBackground(THEMIS.lightblue);
                } else {
                    editor.setBackground(Color.WHITE);
                }
                editor.setText(cell.getContent());
                editor.setMargin(new Insets(10, 10, 10, 10));
                this.editorPanes.put(cell, editor);
                editor.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent evt) {
                        cell.setContent(editor.getText());
                    }
                });
                editor.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent evt) {
                        if (cell != LayoutTableEditor2.this.currentCell) {
                            LayoutTableEditor2.this.setCurrentCell(cell);
                            LayoutTableEditor2.this.setCurrentEditor(editor);
                            editor.requestFocusInWindow();
                        }
                    }
                });
                if (cell.hasBorder()) {
                    editor.setBorder(BorderFactory.createLineBorder(Color.BLACK, (int)cell.getBorder()));
                } else {
                    editor.setBorder(BorderFactory.createEmptyBorder());
                }
                JScrollPane scroll = new JScrollPane();
                scroll.setViewportView(editor);
                if (cell.hasBorder()) {
                    editor.setBorder(BorderFactory.createLineBorder(Color.BLACK, (int)cell.getBorder()));
                    scroll.setBorder(BorderFactory.createLineBorder(Color.BLACK, (int)cell.getBorder()));
                } else {
                    editor.setBorder(BorderFactory.createEmptyBorder());
                    scroll.setBorder(BorderFactory.createEmptyBorder());
                }
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = row.getColForCell(cell);
                this.gbc.gridy = tableRows;
                this.gbc.fill = 1;
                this.gbc.gridwidth = cell.getSpan();
                scroll.setPreferredSize(new Dimension(10, 100));
                this.panelTable.add((Component)scroll, this.gbc);
            }
            ++tableRows;
        }
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = tableRows;
        this.gbc.gridwidth = 0;
        this.gbc.fill = 1;
        this.gbc.weighty = 1.0;
        this.panelTable.add((Component)new JLabel(""), this.gbc);
        this.panelTable.revalidate();
        this.panelTable.repaint();
    }

    private JTextField createTextField() {
        JTextField fld = new JTextField();
        fld.setHorizontalAlignment(0);
        fld.setText("");
        fld.setCursor(new Cursor(2));
        fld.setPreferredSize(new Dimension(100, 25));
        return fld;
    }

    private void setCurrentEditor(JEditorPane e) {
        this.currentEditor = e;
        this.focusOnGrouping = false;
    }

    private void setFocusOnGrouping() {
        this.focusOnGrouping = true;
        this.currentEditor = null;
    }

    private void addPlaceholder() {
        PlaceholderReference phr = this.lstPlaceholder.getSelectedValue();
        if (phr == null) {
            return;
        }
        String ph = phr.getPlaceholderText();
        if (ph == null) {
            return;
        }
        if (this.focusOnGrouping) {
            if (!ph.startsWith("#!#")) {
                ph = "#!#" + ph;
            }
            if (!ph.endsWith("#!#")) {
                ph = ph + "#!#";
            }
            this.fldGroupAttribute.setText(this.fldGroupAttribute.getText() + ph);
            this.layout.setGroupPlaceholder(this.fldGroupAttribute.getText());
            return;
        }
        if (this.currentEditor != null && this.currentCell != null) {
            Document document = this.currentEditor.getDocument();
            int cursor = this.currentEditor.getCaretPosition();
            try {
                document.insertString(cursor, "#!#" + ph + "#!#", null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            String txt = this.currentEditor.getText();
            this.currentCell.setContent(txt);
            this.currentEditor.revalidate();
            this.populateTable();
        }
    }

    private void updatePlaceholderList() {
        ArrayList<String> placeholders = new ArrayList<String>();
        Properties placeholderMapping = new Properties();
        try {
            placeholderMapping = Placeholder.loadMapping((String)"placeholder_mapping.properties");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        placeholders.addAll(placeholderMapping.stringPropertyNames());
        Collections.sort(placeholders);
        String filter = this.fldPlaceholderFilter.getText();
        boolean exactStart = false;
        ((DefaultListModel)this.lstPlaceholder.getModel()).removeAllElements();
        block15: for (String k : placeholders) {
            String v = placeholderMapping.getProperty(k);
            switch (v.toLowerCase()) {
                case "obs.observation-risk": 
                case "obs.rowheight": 
                case "obs.repeat": 
                case "obs.image-number": 
                case "obs.image-info": 
                case "obs.image-comment": 
                case "obs.location-plansnippet-per-location": 
                case "rep.event-signature": {
                    continue block15;
                }
            }
            if (v == null || v.indexOf("dummy") >= 0 || v.startsWith("obs.head1") || v.startsWith("obs.foot1") || v.startsWith("obs.pagebreak") || v.startsWith("rep.report-signature") || v.startsWith("doc.") || !"".equals(filter) && ((exactStart ? "#" : "") + k).indexOf((exactStart ? "#" : "") + filter) < 0) continue;
            ((DefaultListModel)this.lstPlaceholder.getModel()).addElement(new PlaceholderReference(k, v));
        }
        this.lstPlaceholder.revalidate();
    }

    private void setCellBorder(boolean set) {
        if (this.currentCell == null) {
            return;
        }
        int border = 0;
        if (set) {
            border = Integer.parseInt((String)this.fldCellBorderWidth.getSelectedItem());
        }
        this.currentCell.setBorder((float)border);
        this.populateTable();
    }

    public boolean doSave() {
        return this.save;
    }

    private void updateColor() {
        ColorOption co = (ColorOption)this.fldColor.getSelectedItem();
        switch (co.getMethod()) {
            case NOCOLOR: 
            case ATTRIBUTE: 
            case STATUS: {
                this.fldColorChooser.setEnabled(false);
                this.fldColorChooserForeground.setVisible(false);
                break;
            }
            case STATIC: {
                co.setColor(Integer.valueOf(this.fldColorChooser.getBackground().getRGB()));
                co.setForegroundColor(Integer.valueOf(this.fldColorChooserForeground.getBackground().getRGB()));
            }
            default: {
                this.fldColorChooser.setEnabled(true);
                this.fldColorChooserForeground.setVisible(true);
            }
        }
        if (this.currentCell == null) {
            return;
        }
        this.currentCell.setBackground(co);
    }

    private void chooseColor() {
        if (this.currentCell != null) {
            Color c = JColorChooser.showDialog(this, "dialog.colorchooser.title", null);
            if (c != null) {
                this.fldColorChooser.setBackground(c);
                this.updateColor();
            }
        } else {
            Dialogs.getInstance().showWarningDialog("dialog.no-selection-in-table");
        }
    }

    private void chooseForegroundColor() {
        if (this.currentCell != null) {
            Color c = JColorChooser.showDialog(this, "dialog.colorchooser.title", null);
            if (c != null) {
                this.fldColorChooserForeground.setBackground(c);
                this.updateColor();
            }
        } else {
            Dialogs.getInstance().showWarningDialog("dialog.no-selection-in-table");
        }
    }

    private void applyGroupRows() {
        this.layout.setGroupRows(this.fldGroupRows.getText().trim());
    }

    private void storeLayout() {
        this.layoutUndo.add(this.layout.getXml());
        if (this.layoutUndo.size() > 20) {
            this.layoutUndo.remove(0);
        }
    }

    private void undoLayout() {
        if (this.layoutUndo.size() > 0) {
            this.layout.fromXML(this.layoutUndo.get(this.layoutUndo.size() - 1));
            this.layoutUndo.remove(this.layoutUndo.size() - 1);
        }
        this.populateTable();
    }

    private void applyHeadlines() {
        int h = Util.parseInt((String)this.fldHeadlines.getText(), (int)0);
        this.layout.setHeaderRowCount(h);
        this.populateTable();
    }

    private void initComponents() {
        this.buttonGroupRow = new ButtonGroup();
        this.buttonGroupAlign = new ButtonGroup();
        this.jPanel7 = new JPanel();
        this.panelRowButtons = new JPanel();
        this.btnAddRowAbove = new JButton();
        this.btnAddRowBelow = new JButton();
        this.btnMoveRowUp = new JButton();
        this.btnMoveRowDown = new JButton();
        this.btnDelRow = new JButton();
        this.jPanel9 = new JPanel();
        this.jLabel21 = new JLabel();
        this.fldRowHeight = new JTextField();
        this.jLabel22 = new JLabel();
        this.jLabel4 = new JLabel();
        this.fldHeadlines = new JTextField();
        this.panelColButtons = new JPanel();
        this.btnAddColLeft = new JButton();
        this.btnAddColRight = new JButton();
        this.btnDelCol = new JButton();
        this.btnSpanCell = new JButton();
        this.btnUnspanCell = new JButton();
        this.panelCellButtons = new JPanel();
        this.btnUndo = new JButton();
        this.empty = new JLabel();
        this.panelRowText = new JPanel();
        this.jLabel25 = new JLabel();
        this.panelColText = new JPanel();
        this.jLabel23 = new JLabel();
        this.panelCellText = new JPanel();
        this.jLabel26 = new JLabel();
        this.jPanel8 = new JPanel();
        this.jPanel12 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.panelTable = new JPanel();
        this.panelFormatCell = new JPanel();
        this.panel1oben = new JPanel();
        this.fldCellFontSize = new JComboBox();
        this.btnCellFontBold = new JToggleButton();
        this.btnCellFontUnderline = new JToggleButton();
        this.btnCellFontItlaic = new JToggleButton();
        this.btnAlignLeft = new JToggleButton();
        this.btnAlignCenter = new JToggleButton();
        this.btnAlignRight = new JToggleButton();
        this.jPanel11 = new JPanel();
        this.panel2oben = new JPanel();
        this.fldCellBorderWidth = new JComboBox();
        this.fldColor = new JComboBox();
        this.fldColorChooser = new JTextField();
        this.fldColorChooserForeground = new JTextField();
        this.panel3oben = new JPanel();
        this.btnCellFormatToRow = new JButton();
        this.btnCellFormatToTable = new JButton();
        this.btnCellFormatCopy = new JButton();
        this.btnCellFormatPaste = new JButton();
        this.empty1 = new JLabel();
        this.panelRight = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldName = new JTextField();
        this.jLabel19 = new JLabel();
        this.fldFilter = new JComboBox();
        this.jLabel20 = new JLabel();
        this.fldSort = new JComboBox();
        this.jPanel2 = new JPanel();
        this.lblGruppierung = new JLabel();
        this.jLabel9 = new JLabel();
        this.fldGroupAttribute = new JTextField();
        this.jLabel7 = new JLabel();
        this.fldGroupRows = new JTextField();
        this.jLabel10 = new JLabel();
        this.fldGroupNew = new JComboBox();
        this.jPanel10 = new JPanel();
        this.jLabel1 = new JLabel();
        this.panelFilter = new JPanel();
        this.fldPlaceholderFilter = new JTextField();
        this.jButton6 = new JButton();
        this.scrollPlaceholder = new JScrollPane();
        this.lstPlaceholder = new JList();
        this.btnAddPlaceholder = new JButton();
        this.jLabel5 = new JLabel();
        this.panelButtons = new JPanel();
        this.btnCloseSave = new JButton();
        this.btnClose = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel7.setLayout(new GridBagLayout());
        this.panelRowButtons.setLayout(new GridBagLayout());
        this.btnAddRowAbove.setFont(THEMIS.fontButton);
        this.btnAddRowAbove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zeile-oben-einfuegen32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddRowAbove, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor.btnAddCol.text"));
        this.btnAddRowAbove.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAddRowAbove.toolTipText"));
        this.btnAddRowAbove.setPreferredSize(new Dimension(50, 30));
        this.btnAddRowAbove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnAddRowAboveActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelRowButtons.add((Component)this.btnAddRowAbove, gridBagConstraints);
        this.btnAddRowBelow.setFont(THEMIS.fontButton);
        this.btnAddRowBelow.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zeile-unten-einfuegen32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddRowBelow, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAddRowBelow.text"));
        this.btnAddRowBelow.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAddRowBelow.toolTipText"));
        this.btnAddRowBelow.setPreferredSize(new Dimension(50, 30));
        this.btnAddRowBelow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnAddRowBelowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelRowButtons.add((Component)this.btnAddRowBelow, gridBagConstraints);
        this.btnMoveRowUp.setFont(THEMIS.fontButton);
        this.btnMoveRowUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zeile-nach-oben-schieben32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMoveRowUp, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnMoveRowUp.text"));
        this.btnMoveRowUp.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnMoveRowUp.toolTipText"));
        this.btnMoveRowUp.setPreferredSize(new Dimension(50, 30));
        this.btnMoveRowUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnMoveRowUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelRowButtons.add((Component)this.btnMoveRowUp, gridBagConstraints);
        this.btnMoveRowDown.setFont(THEMIS.fontButton);
        this.btnMoveRowDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zeile-nach-unten-schieben32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMoveRowDown, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnMoveRowDown.text"));
        this.btnMoveRowDown.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnMoveRowDown.toolTipText"));
        this.btnMoveRowDown.setPreferredSize(new Dimension(50, 30));
        this.btnMoveRowDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnMoveRowDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelRowButtons.add((Component)this.btnMoveRowDown, gridBagConstraints);
        this.btnDelRow.setFont(THEMIS.fontButton);
        this.btnDelRow.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDelRow, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor.btnAddCol.text"));
        this.btnDelRow.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnDelRow.toolTipText"));
        this.btnDelRow.setPreferredSize(new Dimension(50, 30));
        this.btnDelRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnDelRowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelRowButtons.add((Component)this.btnDelRow, gridBagConstraints);
        this.jPanel9.setLayout(new GridBagLayout());
        this.jLabel21.setFont(THEMIS.fontLabel);
        this.jLabel21.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel21, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel21.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel9.add((Component)this.jLabel21, gridBagConstraints);
        this.fldRowHeight.setFont(THEMIS.fontTextfield);
        this.fldRowHeight.setText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.fldRowHeight.text"));
        this.fldRowHeight.setMinimumSize(new Dimension(40, 25));
        this.fldRowHeight.setPreferredSize(new Dimension(60, 25));
        this.fldRowHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutTableEditor2.this.fldRowHeightFocusLost(evt);
            }
        });
        this.fldRowHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.fldRowHeightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel9.add((Component)this.fldRowHeight, gridBagConstraints);
        this.jLabel22.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel22, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel22.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel9.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel9.add((Component)this.jLabel4, gridBagConstraints);
        this.fldHeadlines.setFont(THEMIS.fontTextfield);
        this.fldHeadlines.setText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.fldHeadlines.text"));
        this.fldHeadlines.setMinimumSize(new Dimension(40, 25));
        this.fldHeadlines.setPreferredSize(new Dimension(60, 25));
        this.fldHeadlines.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutTableEditor2.this.fldHeadlinesFocusLost(evt);
            }
        });
        this.fldHeadlines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.fldHeadlinesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel9.add((Component)this.fldHeadlines, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelRowButtons.add((Component)this.jPanel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.jPanel7.add((Component)this.panelRowButtons, gridBagConstraints);
        this.panelColButtons.setLayout(new GridBagLayout());
        this.btnAddColLeft.setFont(THEMIS.fontButton);
        this.btnAddColLeft.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/spalte-einfuegen-links32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddColLeft, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAddColLeft.text"));
        this.btnAddColLeft.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAddColLeft.toolTipText"));
        this.btnAddColLeft.setHorizontalTextPosition(0);
        this.btnAddColLeft.setPreferredSize(new Dimension(50, 30));
        this.btnAddColLeft.setVerticalTextPosition(3);
        this.btnAddColLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnAddColLeftActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelColButtons.add((Component)this.btnAddColLeft, gridBagConstraints);
        this.btnAddColRight.setFont(THEMIS.fontButton);
        this.btnAddColRight.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/spalte-einfuegen-rechts32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddColRight, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAddColRight.text"));
        this.btnAddColRight.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAddColRight.toolTipText"));
        this.btnAddColRight.setPreferredSize(new Dimension(50, 30));
        this.btnAddColRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnAddColRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelColButtons.add((Component)this.btnAddColRight, gridBagConstraints);
        this.btnDelCol.setFont(THEMIS.fontButton);
        this.btnDelCol.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDelCol, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor.btnAddCol.text"));
        this.btnDelCol.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnDelCol.toolTipText"));
        this.btnDelCol.setPreferredSize(new Dimension(50, 30));
        this.btnDelCol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnDelColActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelColButtons.add((Component)this.btnDelCol, gridBagConstraints);
        this.btnSpanCell.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zellen-verbinden32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSpanCell, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnSpanCell.text"));
        this.btnSpanCell.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnSpanCell.toolTipText"));
        this.btnSpanCell.setHorizontalTextPosition(0);
        this.btnSpanCell.setMinimumSize(new Dimension(50, 30));
        this.btnSpanCell.setPreferredSize(new Dimension(50, 30));
        this.btnSpanCell.setVerticalTextPosition(3);
        this.btnSpanCell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnSpanCellActionPerformed(evt);
            }
        });
        this.panelColButtons.add((Component)this.btnSpanCell, new GridBagConstraints());
        this.btnUnspanCell.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zellen-trennen32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUnspanCell, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnUnspanCell.text"));
        this.btnUnspanCell.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnUnspanCell.toolTipText"));
        this.btnUnspanCell.setHorizontalTextPosition(0);
        this.btnUnspanCell.setMinimumSize(new Dimension(50, 30));
        this.btnUnspanCell.setPreferredSize(new Dimension(50, 30));
        this.btnUnspanCell.setVerticalTextPosition(3);
        this.btnUnspanCell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnUnspanCellActionPerformed(evt);
            }
        });
        this.panelColButtons.add((Component)this.btnUnspanCell, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.jPanel7.add((Component)this.panelColButtons, gridBagConstraints);
        this.panelCellButtons.setLayout(new GridBagLayout());
        this.btnUndo.setFont(THEMIS.fontButton);
        this.btnUndo.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/undo-4-32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUndo, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnUndo.text"));
        this.btnUndo.setMinimumSize(null);
        this.btnUndo.setPreferredSize(null);
        this.btnUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnUndoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.weighty = 1.0;
        this.panelCellButtons.add((Component)this.btnUndo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.jPanel7.add((Component)this.panelCellButtons, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.empty, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.empty.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel7.add((Component)this.empty, gridBagConstraints);
        this.panelRowText.setBorder(BorderFactory.createEtchedBorder());
        this.panelRowText.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel25, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel25.text"));
        this.panelRowText.add((Component)this.jLabel25, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanel7.add((Component)this.panelRowText, gridBagConstraints);
        this.panelColText.setBorder(BorderFactory.createEtchedBorder());
        this.panelColText.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel23, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel23.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.panelColText.add((Component)this.jLabel23, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.panelColText, gridBagConstraints);
        this.panelCellText.setBorder(BorderFactory.createEtchedBorder());
        this.panelCellText.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel26, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel26.text"));
        this.panelCellText.add((Component)this.jLabel26, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel7.add((Component)this.panelCellText, gridBagConstraints);
        this.jPanel7.add((Component)this.jPanel8, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel12.setLayout(new BorderLayout());
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 500));
        this.panelTable.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.panelTable);
        this.jPanel12.add((Component)this.jScrollPane1, "Center");
        this.panelFormatCell.setLayout(new GridBagLayout());
        this.panel1oben.setLayout(new GridBagLayout());
        this.fldCellFontSize.setFont(THEMIS.fontList);
        this.fldCellFontSize.setModel(new DefaultComboBoxModel());
        this.fldCellFontSize.setMinimumSize(null);
        this.fldCellFontSize.setPreferredSize(null);
        this.fldCellFontSize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor2.this.fldCellFontSizeItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel1oben.add(this.fldCellFontSize, gridBagConstraints);
        this.btnCellFontBold.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFontBold, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFontBold.text"));
        this.btnCellFontBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnCellFontBoldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel1oben.add((Component)this.btnCellFontBold, gridBagConstraints);
        this.btnCellFontUnderline.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFontUnderline, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFontUnderline.text"));
        this.btnCellFontUnderline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnCellFontUnderlineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel1oben.add((Component)this.btnCellFontUnderline, gridBagConstraints);
        this.btnCellFontItlaic.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFontItlaic, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFontItlaic.text"));
        this.btnCellFontItlaic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnCellFontItlaicActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel1oben.add((Component)this.btnCellFontItlaic, gridBagConstraints);
        this.buttonGroupAlign.add(this.btnAlignLeft);
        this.btnAlignLeft.setFont(THEMIS.fontLabelBold);
        this.btnAlignLeft.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/align_left.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAlignLeft, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAlignLeft.text"));
        this.btnAlignLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnAlignLeftActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel1oben.add((Component)this.btnAlignLeft, gridBagConstraints);
        this.buttonGroupAlign.add(this.btnAlignCenter);
        this.btnAlignCenter.setFont(THEMIS.fontLabelBold);
        this.btnAlignCenter.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/align_center.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAlignCenter, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAlignCenter.text"));
        this.btnAlignCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnAlignCenterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel1oben.add((Component)this.btnAlignCenter, gridBagConstraints);
        this.buttonGroupAlign.add(this.btnAlignRight);
        this.btnAlignRight.setFont(THEMIS.fontLabelBold);
        this.btnAlignRight.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/align_right.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAlignRight, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAlignRight.text"));
        this.btnAlignRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnAlignRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel1oben.add((Component)this.btnAlignRight, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panel1oben.add((Component)this.jPanel11, gridBagConstraints);
        this.panelFormatCell.add((Component)this.panel1oben, new GridBagConstraints());
        this.panel2oben.setLayout(new GridBagLayout());
        this.fldCellBorderWidth.setFont(THEMIS.fontList);
        this.fldCellBorderWidth.setModel(new DefaultComboBoxModel());
        this.fldCellBorderWidth.setMinimumSize(null);
        this.fldCellBorderWidth.setPreferredSize(null);
        this.fldCellBorderWidth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor2.this.fldCellBorderWidthItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel2oben.add(this.fldCellBorderWidth, gridBagConstraints);
        this.fldColor.setFont(THEMIS.fontList);
        this.fldColor.setModel(new DefaultComboBoxModel());
        this.fldColor.setMinimumSize(null);
        this.fldColor.setPreferredSize(null);
        this.fldColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor2.this.fldColorItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel2oben.add(this.fldColor, gridBagConstraints);
        this.fldColorChooser.setBackground(new Color(4, 30, 100));
        this.fldColorChooser.setText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.fldColorChooser.text"));
        this.fldColorChooser.setCursor(new Cursor(0));
        this.fldColorChooser.setEnabled(false);
        this.fldColorChooser.setMinimumSize(new Dimension(50, 25));
        this.fldColorChooser.setPreferredSize(new Dimension(50, 25));
        this.fldColorChooser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LayoutTableEditor2.this.fldColorChooserMouseClicked(evt);
            }
        });
        this.fldColorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.fldColorChooserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel2oben.add((Component)this.fldColorChooser, gridBagConstraints);
        this.fldColorChooserForeground.setBackground(new Color(4, 30, 100));
        this.fldColorChooserForeground.setText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.fldColorChooserForeground.text"));
        this.fldColorChooserForeground.setCursor(new Cursor(0));
        this.fldColorChooserForeground.setEnabled(false);
        this.fldColorChooserForeground.setMinimumSize(new Dimension(50, 25));
        this.fldColorChooserForeground.setPreferredSize(new Dimension(50, 25));
        this.fldColorChooserForeground.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LayoutTableEditor2.this.fldColorChooserForegroundMouseClicked(evt);
            }
        });
        this.fldColorChooserForeground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.fldColorChooserForegroundActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel2oben.add((Component)this.fldColorChooserForeground, gridBagConstraints);
        this.panelFormatCell.add((Component)this.panel2oben, new GridBagConstraints());
        this.panel3oben.setLayout(new GridBagLayout());
        this.btnCellFormatToRow.setFont(THEMIS.fontButton);
        this.btnCellFormatToRow.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/apply-cell-format-row32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFormatToRow, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFormatToRow.text"));
        this.btnCellFormatToRow.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFormatToRow.toolTipText"));
        this.btnCellFormatToRow.setMinimumSize(null);
        this.btnCellFormatToRow.setPreferredSize(null);
        this.btnCellFormatToRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnCellFormatToRowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel3oben.add((Component)this.btnCellFormatToRow, gridBagConstraints);
        this.btnCellFormatToTable.setFont(THEMIS.fontButton);
        this.btnCellFormatToTable.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/apply-cell-format-table32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFormatToTable, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFormatToTable.text"));
        this.btnCellFormatToTable.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFormatToTable.toolTipText"));
        this.btnCellFormatToTable.setMinimumSize(null);
        this.btnCellFormatToTable.setPreferredSize(null);
        this.btnCellFormatToTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnCellFormatToTableActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel3oben.add((Component)this.btnCellFormatToTable, gridBagConstraints);
        this.btnCellFormatCopy.setFont(THEMIS.fontButton);
        this.btnCellFormatCopy.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copyFormat32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFormatCopy, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFormatCopy.text"));
        this.btnCellFormatCopy.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFormatCopy.toolTipText"));
        this.btnCellFormatCopy.setMinimumSize(null);
        this.btnCellFormatCopy.setPreferredSize(null);
        this.btnCellFormatCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnCellFormatCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel3oben.add((Component)this.btnCellFormatCopy, gridBagConstraints);
        this.btnCellFormatPaste.setFont(THEMIS.fontButton);
        this.btnCellFormatPaste.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/pasteFormat32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCellFormatPaste, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFormatPaste.text"));
        this.btnCellFormatPaste.setToolTipText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCellFormatPaste.toolTipText"));
        this.btnCellFormatPaste.setMinimumSize(null);
        this.btnCellFormatPaste.setPreferredSize(null);
        this.btnCellFormatPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnCellFormatPasteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panel3oben.add((Component)this.btnCellFormatPaste, gridBagConstraints);
        this.panelFormatCell.add((Component)this.panel3oben, new GridBagConstraints());
        Mnemonics.setLocalizedText((JLabel)this.empty1, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.empty1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panelFormatCell.add((Component)this.empty1, gridBagConstraints);
        this.jPanel12.add((Component)this.panelFormatCell, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel12, gridBagConstraints);
        this.panelRight.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel2, gridBagConstraints);
        this.fldName.setFont(THEMIS.fontTextfield);
        this.fldName.setText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.fldName.text"));
        this.fldName.setMinimumSize(null);
        this.fldName.setPreferredSize(null);
        this.fldName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutTableEditor2.this.fldNameFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelRight.add((Component)this.fldName, gridBagConstraints);
        this.jLabel19.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel19, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel19.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel19, gridBagConstraints);
        this.fldFilter.setFont(THEMIS.fontList);
        this.fldFilter.setModel(new DefaultComboBoxModel());
        this.fldFilter.setMinimumSize(null);
        this.fldFilter.setPreferredSize(null);
        this.fldFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor2.this.fldFilterItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelRight.add(this.fldFilter, gridBagConstraints);
        this.jLabel20.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel20, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel20.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRight.add((Component)this.jLabel20, gridBagConstraints);
        this.fldSort.setFont(THEMIS.fontList);
        this.fldSort.setModel(new DefaultComboBoxModel());
        this.fldSort.setMinimumSize(null);
        this.fldSort.setPreferredSize(null);
        this.fldSort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor2.this.fldSortItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelRight.add(this.fldSort, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblGruppierung.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblGruppierung, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.lblGruppierung.text"));
        this.lblGruppierung.setMinimumSize(null);
        this.lblGruppierung.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblGruppierung, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel9, gridBagConstraints);
        this.fldGroupAttribute.setText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.fldGroupAttribute.text"));
        this.fldGroupAttribute.setMinimumSize(null);
        this.fldGroupAttribute.setPreferredSize(null);
        this.fldGroupAttribute.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LayoutTableEditor2.this.fldGroupAttributeFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutTableEditor2.this.fldGroupAttributeFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel2.add((Component)this.fldGroupAttribute, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.fldGroupRows.setFont(THEMIS.fontTextfield);
        this.fldGroupRows.setText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.fldGroupRows.text"));
        this.fldGroupRows.setMinimumSize(null);
        this.fldGroupRows.setPreferredSize(null);
        this.fldGroupRows.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutTableEditor2.this.fldGroupRowsFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel2.add((Component)this.fldGroupRows, gridBagConstraints);
        this.jLabel10.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel10, gridBagConstraints);
        this.fldGroupNew.setFont(THEMIS.fontList);
        this.fldGroupNew.setModel(new DefaultComboBoxModel<String>(new String[]{"nichts", "Neue Tabelle", "Seitenwechsel"}));
        this.fldGroupNew.setMinimumSize(null);
        this.fldGroupNew.setPreferredSize(null);
        this.fldGroupNew.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutTableEditor2.this.fldGroupNewItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add(this.fldGroupNew, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelRight.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel10.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.jPanel10.add((Component)this.jLabel1, gridBagConstraints);
        this.panelFilter.setLayout(new GridBagLayout());
        this.fldPlaceholderFilter.setText(NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.fldPlaceholderFilter.text"));
        this.fldPlaceholderFilter.setMinimumSize(null);
        this.fldPlaceholderFilter.setPreferredSize(null);
        this.fldPlaceholderFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.fldPlaceholderFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panelFilter.add((Component)this.fldPlaceholderFilter, gridBagConstraints);
        this.jButton6.setFont(THEMIS.fontButton);
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_viewFilter24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jButton6.text"));
        this.jButton6.setMinimumSize(null);
        this.jButton6.setPreferredSize(null);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.jButton6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        this.panelFilter.add((Component)this.jButton6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel10.add((Component)this.panelFilter, gridBagConstraints);
        this.lstPlaceholder.setModel(new DefaultListModel());
        this.lstPlaceholder.setPreferredSize(null);
        this.lstPlaceholder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LayoutTableEditor2.this.lstPlaceholderMouseClicked(evt);
            }
        });
        this.scrollPlaceholder.setViewportView(this.lstPlaceholder);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel10.add((Component)this.scrollPlaceholder, gridBagConstraints);
        this.btnAddPlaceholder.setFont(THEMIS.fontButton);
        this.btnAddPlaceholder.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddPlaceholder, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnAddPlaceholder.text"));
        this.btnAddPlaceholder.setPreferredSize(new Dimension(50, 30));
        this.btnAddPlaceholder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnAddPlaceholderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel10.add((Component)this.btnAddPlaceholder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelRight.add((Component)this.jPanel10, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.panelRight.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.panelRight, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnCloseSave.setFont(THEMIS.fontButton);
        this.btnCloseSave.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/save24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCloseSave, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnCloseSave.text"));
        this.btnCloseSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnCloseSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnCloseSave, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontButton);
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(LayoutTableEditor2.class, (String)"LayoutTableEditor2.btnClose.text"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutTableEditor2.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnClose, gridBagConstraints);
        this.add((Component)this.panelButtons, new GridBagConstraints());
    }

    private void btnAddRowAboveActionPerformed(ActionEvent evt) {
        this.storeLayout();
        int idx = 0;
        if (this.currentCell != null) {
            int n = idx = this.currentCell == null ? -1 : this.currentCell.getRow().getRowIndex();
        }
        if (idx < 0) {
            this.layout.addRow();
        } else {
            this.layout.addRow(idx);
        }
        this.populateTable();
    }

    private void btnAddColLeftActionPerformed(ActionEvent evt) {
        int idx;
        this.storeLayout();
        int n = idx = this.currentCell == null ? -1 : this.currentCell.getColumnIndex();
        if (idx < 0) {
            this.layout.addColumn(1);
        } else {
            this.layout.addColumn(idx, 1);
        }
        this.populateTable();
    }

    private void btnAddPlaceholderActionPerformed(ActionEvent evt) {
        this.storeLayout();
        this.addPlaceholder();
    }

    private void btnDelRowActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.storeLayout();
            this.layout.delRow(this.currentCell.getRow());
            this.populateTable();
        }
    }

    private void btnDelColActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.storeLayout();
            int col = this.currentCell.getColumnIndex();
            this.layout.removeColumn(col);
            this.populateTable();
        }
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.updatePlaceholderList();
    }

    private void lstPlaceholderMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.addPlaceholder();
        }
    }

    private void btnSpanCellActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.storeLayout();
            this.currentCell.span();
            this.populateTable();
        }
    }

    private void btnUnspanCellActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.storeLayout();
            this.currentCell.unspan();
            this.populateTable();
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void fldNameFocusLost(FocusEvent evt) {
        this.layout.setName(this.fldName.getText().trim());
    }

    private void btnCloseSaveActionPerformed(ActionEvent evt) {
        if ("".equals(this.fldName.getText().trim())) {
            Dialogs.getInstance().showErrorDialog("error.layouttableeditor.nameRequired");
        } else if (this.forbiddenNames.contains(this.fldName.getText().trim())) {
            Dialogs.getInstance().showErrorDialog("error.layouttableeditor.nameInUse");
        } else {
            this.save = true;
            this.closeDialog();
        }
    }

    private void fldPlaceholderFilterActionPerformed(ActionEvent evt) {
        this.updatePlaceholderList();
    }

    private void fldColorItemStateChanged(ItemEvent evt) {
        if (!this.flagUpdating && evt.getStateChange() == 1) {
            this.updateColor();
        }
    }

    private void fldColorChooserMouseClicked(MouseEvent evt) {
        this.chooseColor();
    }

    private void fldColorChooserActionPerformed(ActionEvent evt) {
        this.chooseColor();
    }

    private void fldColorChooserForegroundMouseClicked(MouseEvent evt) {
        this.chooseForegroundColor();
    }

    private void fldColorChooserForegroundActionPerformed(ActionEvent evt) {
        this.chooseForegroundColor();
    }

    private void fldHeadlinesActionPerformed(ActionEvent evt) {
        int h = Util.parseInt((String)this.fldHeadlines.getText(), (int)0);
        this.layout.setHeaderRowCount(h);
        this.populateTable();
    }

    private void btnAddRowBelowActionPerformed(ActionEvent evt) {
        this.storeLayout();
        int idx = this.layout.getNumberOfRows() - 1;
        if (this.currentCell != null) {
            idx = this.currentCell.getRow().getRowIndex();
        }
        if (idx < 0) {
            this.layout.addRow();
        } else if (idx >= this.layout.getNumberOfRows() - 1) {
            this.layout.addRow();
        } else {
            this.layout.addRow(idx + 1);
        }
        this.populateTable();
    }

    private void btnMoveRowUpActionPerformed(ActionEvent evt) {
        this.storeLayout();
        LayoutRow row = this.currentCell.getRow();
        int idx = this.layout.getRows().indexOf(row);
        if (idx > 0) {
            Collections.swap(this.layout.getRows(), idx, idx - 1);
        }
        this.populateTable();
    }

    private void btnMoveRowDownActionPerformed(ActionEvent evt) {
        this.storeLayout();
        LayoutRow row = this.currentCell.getRow();
        int idx = this.layout.getRows().indexOf(row);
        if (idx < this.layout.getRows().size() - 1) {
            Collections.swap(this.layout.getRows(), idx, idx + 1);
        }
        this.populateTable();
    }

    private void btnAddColRightActionPerformed(ActionEvent evt) {
        int idx;
        this.storeLayout();
        int n = idx = this.currentCell == null ? -1 : this.currentCell.getColumnIndex();
        if (idx < 0) {
            this.layout.addColumn(1);
        } else if (idx >= this.layout.getNumberOfCols() - 1) {
            this.layout.addColumn(1);
        } else {
            this.layout.addColumn(idx + 1, 1);
        }
        this.populateTable();
    }

    private void fldCellBorderWidthItemStateChanged(ItemEvent evt) {
        if (this.currentCell != null) {
            this.setCellBorder(this.fldCellBorderWidth.getSelectedIndex() > 0);
            this.populateTable();
        }
    }

    private void fldCellFontSizeItemStateChanged(ItemEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.setFontSize(Util.parseInt((String)((String)this.fldCellFontSize.getSelectedItem()), (int)12));
            this.populateTable();
        }
    }

    private void btnCellFontBoldActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.setFontBold(!this.currentCell.isFontBold());
            this.btnCellFontBold.setSelected(this.currentCell.isFontBold());
            this.populateTable();
        }
    }

    private void btnCellFontUnderlineActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.setFontUnderlined(!this.currentCell.isFontUnderlined());
            this.btnCellFontUnderline.setSelected(this.currentCell.isFontUnderlined());
            this.populateTable();
        }
    }

    private void btnCellFontItlaicActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.setFontItalic(!this.currentCell.isFontItalic());
            this.btnCellFontItlaic.setSelected(this.currentCell.isFontItalic());
            this.populateTable();
        }
    }

    private void btnCellFormatCopyActionPerformed(ActionEvent evt) {
        this.copyCellFormat = null;
        if (this.currentCell != null) {
            this.copyCellFormat = this.currentCell.getAsElement();
        }
    }

    private void btnCellFormatPasteActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && this.copyCellFormat != null) {
            this.storeLayout();
            this.currentCell.setFromElement(this.copyCellFormat, true);
            this.populateTable();
        }
    }

    private void btnCellFormatToRowActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && !this.flagUpdating) {
            this.storeLayout();
            Element f = this.currentCell.getAsElement();
            for (LayoutCell c : this.currentCell.getRow().getCells()) {
                c.setFromElement(f, true);
            }
            this.populateTable();
        }
    }

    private void btnCellFormatToTableActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && !this.flagUpdating) {
            this.storeLayout();
            Element f = this.currentCell.getAsElement();
            ArrayList<LayoutCell> cells = new ArrayList<LayoutCell>();
            for (LayoutRow r : this.layout.getRows()) {
                for (LayoutCell c : r.getCells()) {
                    cells.add(c);
                }
            }
            for (LayoutCell c : cells) {
                c.setFromElement(f, true);
            }
            this.populateTable();
        }
    }

    private void btnUndoActionPerformed(ActionEvent evt) {
        this.undoLayout();
    }

    private void fldFilterItemStateChanged(ItemEvent evt) {
        CmsBasicElement be = (CmsBasicElement)this.fldFilter.getSelectedItem();
        if (be != null && be.getId() > 0L) {
            this.layout.setFilter(be.getTitle());
        } else {
            this.layout.setFilter(null);
        }
    }

    private void fldSortItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.layout.setSort((AttributeSqlPair)this.fldSort.getSelectedItem());
        }
    }

    private void btnAlignLeftActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && !this.flagUpdating) {
            this.storeLayout();
            this.currentCell.setAlign(LayoutCell.Align.LEFT);
            this.populateTable();
        }
    }

    private void btnAlignCenterActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && !this.flagUpdating) {
            this.storeLayout();
            this.currentCell.setAlign(LayoutCell.Align.CENTER);
            this.populateTable();
        }
    }

    private void btnAlignRightActionPerformed(ActionEvent evt) {
        if (this.currentCell != null && !this.flagUpdating) {
            this.storeLayout();
            this.currentCell.setAlign(LayoutCell.Align.RIGHT);
            this.populateTable();
        }
    }

    private void fldGroupNewItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            switch (this.fldGroupNew.getSelectedIndex()) {
                case 0: {
                    this.layout.setGroupNewTable(false);
                    this.layout.setGroupPagebreak(false);
                    break;
                }
                case 1: {
                    this.layout.setGroupNewTable(true);
                    this.layout.setGroupPagebreak(false);
                    break;
                }
                case 2: {
                    this.layout.setGroupNewTable(true);
                    this.layout.setGroupPagebreak(true);
                }
            }
        }
    }

    private void fldHeadlinesFocusLost(FocusEvent evt) {
        this.applyHeadlines();
    }

    private void fldGroupRowsFocusLost(FocusEvent evt) {
        this.applyGroupRows();
    }

    private void fldRowHeightFocusLost(FocusEvent evt) {
    }

    private void fldRowHeightActionPerformed(ActionEvent evt) {
        if (this.currentCell != null) {
            this.currentCell.getRow().setHeight(Util.parseInt((String)this.fldRowHeight.getText(), (int)-1));
        }
    }

    private void fldGroupAttributeFocusLost(FocusEvent evt) {
        this.layout.setGroupPlaceholder(this.fldGroupAttribute.getText());
    }

    private void fldGroupAttributeFocusGained(FocusEvent evt) {
        this.setFocusOnGrouping();
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(ThemisApplication.getInstance().getProject().getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, true);
        THEMIS.setAssistantMoveListener(dlg);
        THEMIS.applyWindowSizeAndLocation(this.DIALOG_CODE, dlg, 1100, 900);
        dlg.setVisible(true);
    }

    private void closeDialog() {
        this.layout.setName(this.fldName.getText().trim());
        JDialog parent = (JDialog)this.getRootPane().getParent();
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, parent);
        parent.dispose();
    }
}

