/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.report.xls;

import at.grid.cms.attribute.BooleanAttribute;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.storage.DataRecord;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.report.PlaceholderLocation;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsCompany;
import at.grid.themis.ontology.element.CmsFilter;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsIcon;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.report.ExportUtil;
import at.grid.themis.ontology.report.LayoutCell;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.PlanSnippetGenerator;
import at.grid.themis.ontology.report.ReportGenerator;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.themis.ontology.signature.ThemisSignature;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.HeaderFooter;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportXlsReport2
extends ReportGenerator {
    public static final int SECTION_HEADER = 1;
    public static final int SECTION_ITEMS = 2;
    public static final int SECTION_FOOTER = 3;
    XSSFWorkbook wb = new XSSFWorkbook();
    CreationHelper createHelper;
    Properties placeholder_mapping;
    ArrayList<PlaceholderLocation> placeholdersREP = new ArrayList();
    ArrayList<PlaceholderLocation> placeholdersLOC = new ArrayList();
    ArrayList<PlaceholderLocation> placeholdersOBS = new ArrayList();
    ArrayList<PlaceholderLocation> placeholdersOBSheading1 = new ArrayList();
    ArrayList<PlaceholderLocation> placeholdersOBSheading2 = new ArrayList();
    ArrayList<PlaceholderLocation> placeholdersDOC = new ArrayList();
    ArrayList<PlaceholderLocation> placeholdersPG = new ArrayList();
    ArrayList<PlaceholderLocation> placeholdersAGG = new ArrayList();
    HashMap<Integer, HashMap<String, String>> parametermap = new HashMap();
    String obsHeading1Attribute = null;
    private List<DataRecord> records = new ArrayList<DataRecord>();
    private HashMap<Long, String> documentAddress = new HashMap();
    int imageCounter = 1;
    private HashMap<Long, ArrayList<Long>> locationDocuments = new HashMap();
    private HashMap<Long, ArrayList<Long>> observationDocuments = new HashMap();
    ArrayList<Long> observationIds = new ArrayList();
    ArrayList<Long> elementIds = new ArrayList();
    private HashMap<Long, CmsElement> observations = new HashMap();
    private HashMap<Long, CmsElement> locations = new HashMap();
    private HashMap<Long, CmsElement> contacts = new HashMap();
    private HashMap<Long, CmsElement> iconItems = new HashMap();
    private HashMap<String, HashMap<String, String>> aggregation = new HashMap();
    ProgressHandler progress = null;
    protected double progressStep = 0.0;
    protected double progressCurrent = 0.0;
    protected double progressFrom = 0.0;
    protected double progressTo = 100.0;
    private File exportFile;
    ThemisSettings settings = ThemisApplication.getInstance().getSettings();

    public ExportXlsReport2(CmsReport rep) {
        super(rep);
        this.placeholder_mapping = this.ph.getMapping();
        if (this.ph.getException() != null || this.ph.getExceptionMsg() != null) {
            Dialogs.getInstance().showErrorDialog(this.ph.getExceptionMsg(), this.ph.getException());
        }
    }

    public ArrayList<Long> getObservationIds() {
        return this.observationIds;
    }

    public void export(File exportFile, CmsReport rep, ProgressHandler ph, int phFrom, int phTo) {
        try {
            this.progress = ph;
            this.progressFrom = phFrom;
            this.progressTo = phTo;
            this.exportFile = exportFile;
            ThemisProject project = ThemisApplication.getInstance().getProject();
            FileInputStream is = null;
            File f = rep.getTemplateFile();
            switch (rep.exportFormat) {
                case EXCEL: {
                    if (f == null || !f.isFile()) {
                        Dialogs.getInstance().showErrorDialog("error.report-template-not-a-file");
                        return;
                    }
                    is = new FileInputStream(f);
                    break;
                }
                default: {
                    Dialogs.getInstance().showErrorDialog("error.report-template-not-a-file");
                    return;
                }
            }
            boolean readResult = this.readTemplateFile(is);
            Util.closeStream((Closeable)is);
            if (!readResult) {
                return;
            }
            if (this.progress.isCancelled()) {
                return;
            }
            this.progress.progress(project.getResourceText("progress.loading.template"));
            ArrayList documentSheets = new ArrayList();
            this.documentIds = new ArrayList();
            this.locationIds.clear();
            for (int sheetNo = 0; sheetNo < this.wb.getNumberOfSheets(); ++sheetNo) {
                this.progress.progress(project.getResourceText("progress.loading.data"));
                ArrayList<Long> locationIdsOnSheet = this.readData(sheetNo);
                for (long id : locationIdsOnSheet) {
                    if (this.locationIds.contains(id)) continue;
                    this.locationIds.add(id);
                }
                HashMap<String, String> parameters = this.getParameters(sheetNo);
                int recSize = this.records.size();
                this.progressStep = recSize > 0 ? (this.progressTo - this.progressFrom) / (double)(recSize * this.wb.getNumberOfSheets()) : 1.0;
                if (this.planSnippetsIncludedInSheet(sheetNo)) {
                    this.progress.progress(project.getResourceText("progress.loading.snippets"));
                    this.loadPlanSnippets(rep, locationIdsOnSheet);
                }
                if (this.progress.isCancelled()) {
                    return;
                }
                ArrayList<PlaceholderLocation> placeholdersREPsheet = this.getPlaceholdersREP(sheetNo);
                this.progress.progress(project.getResourceText("progress.loading.placeholders"));
                this.populateReportDetails(placeholdersREPsheet);
                if (this.progress.isCancelled()) {
                    return;
                }
                int itemCounter = this.populateObservationDetails(sheetNo);
                if (this.progress.isCancelled()) {
                    return;
                }
                if (this.getPlaceholdersDOC(sheetNo).size() > 0) {
                    if (itemCounter > 0) {
                        Dialogs.getInstance().showErrorDialog("error.report-documents-not-allowed", this.wb.getSheetName(sheetNo));
                    } else {
                        this.populateDocuments(sheetNo);
                    }
                }
                if (this.progress.isCancelled()) {
                    return;
                }
                this.progress.progress(project.getResourceText("progress.inserting.stats"));
                this.populateStatistics(sheetNo);
                this.populatePlaceholdersAfterObservationList(placeholdersREPsheet, itemCounter);
                if (!this.progress.isCancelled()) continue;
                return;
            }
            this.wb.setForceFormulaRecalculation(true);
            this.progress.progress(project.getResourceText("progress.writing.file"));
            this.writeToFile(exportFile);
        }
        catch (Exception e) {
            Dialogs.getInstance().showErrorDialog("Error: " + e.getMessage(), e);
            e.printStackTrace();
        }
    }

    private boolean readTemplateFile(InputStream fis) {
        try {
            ZipSecureFile.setMinInflateRatio((double)0.001);
            this.wb = (XSSFWorkbook)WorkbookFactory.create((InputStream)fis);
            this.createHelper = this.wb.getCreationHelper();
            int noOfSheets = this.wb.getNumberOfSheets();
            for (int sheetNo = 0; sheetNo < noOfSheets; ++sheetNo) {
                XSSFSheet sheet = this.wb.getSheetAt(sheetNo);
                Header header = sheet.getHeader();
                this.definePlaceholder(new PlaceholderLocation((Workbook)this.wb, (HeaderFooter)header, 1, header.getLeft()), false);
                this.definePlaceholder(new PlaceholderLocation((Workbook)this.wb, (HeaderFooter)header, 2, header.getCenter()), false);
                this.definePlaceholder(new PlaceholderLocation((Workbook)this.wb, (HeaderFooter)header, 3, header.getRight()), false);
                Footer footer = sheet.getFooter();
                this.definePlaceholder(new PlaceholderLocation((Workbook)this.wb, (HeaderFooter)footer, 1, footer.getLeft()), false);
                this.definePlaceholder(new PlaceholderLocation((Workbook)this.wb, (HeaderFooter)footer, 2, footer.getCenter()), false);
                this.definePlaceholder(new PlaceholderLocation((Workbook)this.wb, (HeaderFooter)footer, 3, footer.getRight()), false);
                for (int rowNo = 0; rowNo <= sheet.getLastRowNum(); ++rowNo) {
                    for (int colNo = 0; colNo < 250; ++colNo) {
                        String cellValue;
                        Cell cell;
                        Row row = sheet.getRow(rowNo);
                        if (row == null || (cell = row.getCell(colNo)) == null || cell.getCellType() != CellType.STRING || (cellValue = cell.getStringCellValue()) == null || !cellValue.contains("#!#")) continue;
                        PlaceholderLocation ph = new PlaceholderLocation((Workbook)this.wb, sheetNo, rowNo, colNo, cell.getCellStyle(), cellValue);
                        int count = cell.getSheet().getNumMergedRegions();
                        for (int ii = 0; ii < count; ++ii) {
                            CellRangeAddress mergedRegion = cell.getSheet().getMergedRegion(ii);
                            if (!mergedRegion.isInRange(rowNo, colNo)) continue;
                            ph.setMergedRegion(mergedRegion);
                        }
                        this.definePlaceholder(ph, true);
                    }
                }
                if (!this.verifyPlaceholderLocations(sheetNo, this.placeholdersLOC)) {
                    return false;
                }
                if (this.verifyPlaceholderLocations(sheetNo, this.placeholdersDOC)) continue;
                return false;
            }
            return true;
        }
        catch (FileNotFoundException ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.error.text"), ex);
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.error.text"), ex);
        }
        return false;
    }

    private void replacePlaceholder(String key, PlaceholderLocation placeholder) {
        String newMapping = this.placeholder_mapping.getProperty(key.toLowerCase());
        if (newMapping == null) {
            if (key.toLowerCase().startsWith("b.g-bild")) {
                key = "g.bild" + key.substring("b.g-bild".length());
            }
            if (key.toLowerCase().startsWith("b.bild") || key.toLowerCase().startsWith("g.bild")) {
                try {
                    boolean isObsPH = key.toLowerCase().startsWith("b.bild");
                    String[] split = key.split("-");
                    String numString = split[0].substring("b.bild".length());
                    int num = -1;
                    try {
                        num = Integer.parseInt(numString);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num != -1) {
                        String suffix = "-file";
                        if (key.toLowerCase().endsWith("-nummer")) {
                            suffix = "-number";
                        } else if (key.toLowerCase().endsWith("-info")) {
                            suffix = "-info";
                        } else if (key.toLowerCase().endsWith("-bemerkung")) {
                            suffix = "-comment";
                        }
                        placeholder.replacePlaceholder(key, "obs." + (isObsPH ? "" : "location-") + "image" + num + suffix);
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            placeholder.replacePlaceholder(key, newMapping);
        }
    }

    private void definePlaceholder(PlaceholderLocation placeholder, boolean clearCell) {
        String[] split;
        if (placeholder == null || placeholder.placeholder == null || placeholder.placeholder.length() <= 3) {
            return;
        }
        ArrayList<String> placeholderstrings = placeholder.getPlaceholders();
        for (String key : placeholderstrings) {
            String key2 = null;
            if (key.contains("=")) {
                split = key.split("=");
                key = split[0];
                key2 = split[1];
            }
            this.replacePlaceholder(key, placeholder);
            if (key2 == null) continue;
            this.replacePlaceholder(key2, placeholder);
        }
        ArrayList<String> placeholderTags = placeholder.getPlaceholders();
        for (String placeholderTag : placeholderTags) {
            if (!placeholderTag.contains("=")) continue;
            split = placeholderTag.split("=");
            this.getParameters(placeholder.sheet).put(split[0], split[1]);
        }
        if (placeholder.placeholder.contains("#!#rep")) {
            this.placeholdersREP.add(placeholder);
        }
        if (placeholder.placeholder.contains("#!#obs")) {
            this.placeholdersOBS.add(placeholder);
        } else if (placeholder.placeholder.contains("#!#doc")) {
            this.placeholdersDOC.add(placeholder);
        } else if (placeholder.placeholder.contains("#!#pg")) {
            this.placeholdersPG.add(placeholder);
        } else if (placeholder.placeholder.contains("#!#agg")) {
            this.placeholdersAGG.add(placeholder);
        }
        if (clearCell) {
            placeholder.clearCell((Workbook)this.wb, 0);
        }
    }

    private HashMap<String, String> getParameters(int sheetNo) {
        HashMap<String, String> parameters = this.parametermap.get(sheetNo);
        if (parameters == null) {
            parameters = new HashMap();
            this.parametermap.put(sheetNo, parameters);
        }
        return parameters;
    }

    private boolean verifyPlaceholderLocations(int sheetNo, ArrayList<PlaceholderLocation> placeholders) {
        int placeholderRow = -1;
        for (PlaceholderLocation placeholder : placeholders) {
            if (placeholder.sheet != sheetNo) continue;
            if (placeholderRow < 0) {
                placeholderRow = placeholder.getRow();
                continue;
            }
            if (placeholderRow == placeholder.getRow()) continue;
            Dialogs.getInstance().showErrorDialog("error.report-doc-placeholder-not-in-row");
            return false;
        }
        return true;
    }

    public ArrayList<Long> readData(int sheetNo) {
        CmsFilter filterByName;
        String[] filterSpec;
        String v;
        ThemisFilter filter = new ThemisFilter(ThemisApplication.getInstance(), false, false);
        filter.setFilter(this.rep.filter);
        HashMap<String, String> parameters = this.getParameters(sheetNo);
        this.rep.sortUse = this.rep.getSortSql();
        if (parameters.containsKey("param.sort")) {
            this.rep.sortUse = Placeholder.getSortString((String)parameters.get("param.sort"), (Properties)this.placeholder_mapping, (String)this.rep.getSortSql());
        }
        if (parameters.containsKey("param.filter") && (v = parameters.get("param.filter")) != null && (filterSpec = v.split("->")).length == 2) {
            filter.setFilterByText(filterSpec[0], filterSpec[1], (Object)this);
        }
        if ((filterByName = this.project.getFilterByName(v = parameters.get("filter.name"))) != null) {
            filter.loadFilter(filterByName);
        }
        ArrayList<Long> locationIdsOnSheet = new ArrayList<Long>();
        this.observationIds.clear();
        this.elementIds.clear();
        if (this.getPlaceholdersForSheet(this.placeholdersLOC, sheetNo).isEmpty() && this.getPlaceholdersForSheet(this.placeholdersOBS, sheetNo).isEmpty() && this.getPlaceholdersForSheet(this.placeholdersAGG, sheetNo).isEmpty()) {
            this.records.clear();
            return locationIdsOnSheet;
        }
        switch (this.rep.contentType) {
            case EVENT: {
                if (this.rep.event != null) {
                    filter.getEventId().setItem(this.rep.event.getId(), (Object)this);
                }
                this.records = filter.getFilteredObservations(this.rep.sortUse, null);
                break;
            }
            case SELECTION: {
                this.records = filter.getSelectedObservations();
                break;
            }
            case PERIOD: {
                filter.setEventRange(this.rep.getPeriodFromDate(), this.rep.getPeriodUntilDate(), (Object)this);
                this.records = filter.getFilteredObservations(this.rep.sortUse, null);
                break;
            }
            default: {
                this.records = filter.getFilteredObservations(this.rep.sortUse, null);
            }
        }
        for (DataRecord rec : this.records) {
            if (rec.getBoolean("building").booleanValue()) continue;
            boolean foundObservationId = false;
            long id = rec.getLong("observationid");
            long idloc = rec.getLong("meta_id");
            if (id > 0L && !this.observationIds.contains(id)) {
                this.observationIds.add(id);
                this.elementIds.add(id);
                foundObservationId = true;
            }
            if (locationIdsOnSheet.contains(idloc)) continue;
            locationIdsOnSheet.add(idloc);
            if (foundObservationId || !this.rep.exportLocationsWithoutObservations) continue;
            this.elementIds.add(idloc);
        }
        return locationIdsOnSheet;
    }

    protected void loadPlanSnippets(CmsReport rep, ArrayList<Long> locIds) {
        PlanSnippetGenerator.generate((CmsReport)rep, locIds, (ProgressHandler)this.progress);
    }

    private CmsCompany getContact(long id) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!this.contacts.containsKey(id)) {
            this.contacts.put(id, project.loadElement(id, project.getUser()));
        }
        return (CmsCompany)this.contacts.get(id);
    }

    private CmsIcon getIcon(long id) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!this.iconItems.containsKey(id)) {
            this.iconItems.put(id, project.loadElement(id, project.getUser()));
        }
        return (CmsIcon)this.iconItems.get(id);
    }

    private CmsLocation getLocation(long id) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!this.locations.containsKey(id)) {
            this.locations.put(id, project.loadElement(id, project.getUser()));
        }
        return (CmsLocation)this.locations.get(id);
    }

    private CmsObservation getObservation(long id) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!this.observations.containsKey(id)) {
            this.observations.put(id, project.loadElement(id, project.getUser()));
        }
        return (CmsObservation)this.observations.get(id);
    }

    private void populateReportDetails(ArrayList<PlaceholderLocation> placeholders) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        CmsProject projectElement = project.getProjectElement();
        for (PlaceholderLocation placeholder : placeholders) {
            this.populateReportDetails(placeholder, projectElement);
            placeholder.writeToCell((Workbook)this.wb);
        }
    }

    public void populatePlaceholdersAfterObservationList(ArrayList<PlaceholderLocation> phs, int deltarow) {
        for (PlaceholderLocation placeholder : phs) {
            if (!placeholder.hasPostPopulateTargets()) continue;
            placeholder.postPopulateImages();
        }
    }

    private void populateReportDetails(PlaceholderLocation placeholder, CmsProject projectElement) {
        int signatureWidth = 180;
        placeholder.setContent("#!#REP.project-client#!#", projectElement.getAttributeValue("customer", ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.noCustomer.text")));
        placeholder.setContent("#!#REP.project-title#!#", projectElement.getAttributeValue("projecttitle", ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.noTitle.text")));
        placeholder.setContent("#!#REP.project-number#!#", projectElement.getAttributeValue("projectnumber", ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.noNumber.text")));
        placeholder.setContent("#!#REP.project-description#!#", projectElement.getAttributeValue("info", ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.noDescription.text")));
        placeholder.setContent("#!#REP.project-location#!#", projectElement.getAttributeValue("projectlocation", ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.noLocation.text")));
        placeholder.setContent("#!#REP.project-photo#!#", projectElement.getUploadAttribute("projectimage").getFirstUploadItem(), null, true);
        placeholder.setContent("#!#REP.project-logo#!#", projectElement.getUploadAttribute("projectlogo").getFirstUploadItem(), null, true);
        placeholder.setContent("#!#REP.event-title#!#", this.rep.event == null ? this.rep.textNoEvent : this.rep.event.getAttributeValue("title"));
        if (this.rep.event == null) {
            placeholder.setContent("#!#REP.event-signature#!#", this.rep.textNoEvent);
        } else if (this.rep.event.getUploadAttribute("signature").hasUploads()) {
            placeholder.setContent("#!#REP.event-signature#!#", this.rep.event.getUploadAttribute("signature").getUploadItem(0), null, signatureWidth);
        }
        placeholder.setContent("#!#REP.event-place#!#", this.rep.event == null ? this.rep.textNoEvent : this.rep.event.getAttributeValue("place"));
        placeholder.setContent("#!#REP.event-date#!#", this.rep.event == null ? this.rep.textNoEvent : this.rep.event.getAttributeValue("date"));
        placeholder.setContent("#!#REP.event-time#!#", this.rep.event == null ? this.rep.textNoEvent : this.rep.event.getAttributeValue("time"));
        placeholder.setContent("#!#REP.event-participant#!#", this.rep.event == null ? this.rep.textNoEvent : this.rep.event.getAttributeValue("participants"));
        placeholder.setContent("#!#REP.event-comment#!#", this.rep.event == null ? this.rep.textNoEvent : this.rep.event.getAttributeValue("comment"));
        placeholder.setContent("#!#REP.report-title#!#", this.rep.protTitel.equals("") ? this.rep.textNoContent : this.rep.protTitel);
        placeholder.setContent("#!#REP.report-number#!#", this.rep.protNummer.equals("") ? this.rep.textNoContent : this.rep.protNummer);
        placeholder.setContent("#!#REP.report-author#!#", this.rep.protVerfasser.equals("") ? this.rep.textNoContent : this.rep.protVerfasser);
        placeholder.setContent("#!#REP.report-date#!#", this.rep.protDatum.equals("") ? this.rep.textNoContent : this.rep.protDatum);
        placeholder.setContent("#!#REP.report-version#!#", this.rep.protVersion.equals("") ? this.rep.textNoContent : this.rep.protVersion);
        placeholder.setContent("#!#REP.report-distribution#!#", this.rep.protVerteiler.equals("") ? this.rep.textNoContent : this.rep.protVerteiler);
        placeholder.setContent("#!#REP.report-distribution2#!#", this.rep.protKenntnis.equals("") ? this.rep.textNoContent : this.rep.protKenntnis);
        ThemisSignature sig1 = this.rep.getSignature(0);
        ThemisSignature sig2 = this.rep.getSignature(1);
        placeholder.setContent("#!#REP.report-signature1-name#!#", sig1 == null ? "" : sig1.getName());
        placeholder.setContent("#!#REP.report-signature1-function#!#", sig1 == null ? "" : sig1.getFunction());
        placeholder.setContent("#!#REP.report-signature2-name#!#", sig2 == null ? "" : sig2.getName());
        placeholder.setContent("#!#REP.report-signature2-function#!#", sig2 == null ? "" : sig2.getFunction());
        if (sig1 != null) {
            placeholder.setContent("#!#REP.report-signature1#!#", sig1.getSignatureFile(), signatureWidth);
        }
        if (sig2 != null) {
            placeholder.setContent("#!#REP.report-signature2#!#", sig2.getSignatureFile(), signatureWidth);
        }
        placeholder.setContent("#!#REP.now-date#!#", Util.formatDate((Date)new Date(), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
        placeholder.setContent("#!#REP.now-datetime#!#", Util.formatDate((Date)new Date(), (String)Util.DATETIME_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
    }

    private void populateDocuments(int sheetNo) {
        ArrayList<PlaceholderLocation> placeholdersDOCinSheet = this.getPlaceholdersForSheet(this.placeholdersDOC, sheetNo);
        ThemisProject project = ThemisApplication.getInstance().getProject();
        this.documentAddress = new HashMap();
        if (!placeholdersDOCinSheet.isEmpty()) {
            int placeholderRow = placeholdersDOCinSheet.get(0).getRow();
            XSSFSheet sh = this.wb.getSheetAt(sheetNo);
            int colMin = -1;
            int colMax = -1;
            for (PlaceholderLocation ph : placeholdersDOCinSheet) {
                colMin = colMin < 0 ? ph.col : Math.min(colMin, ph.col);
                colMax = colMax < 0 ? ph.col : Math.max(colMax, ph.col);
            }
            int rowcount = 0;
            int documentCounter = 1;
            Hyperlink link = null;
            Iterator iterator = this.documentIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                for (int col = colMin; col <= colMax; ++col) {
                    PlaceholderLocation.copyStyle((Sheet)sh, col, placeholderRow, placeholderRow + rowcount);
                }
                this.documentAddress.put(id, "'" + sh.getSheetName() + "'!" + CellReference.convertNumToColString((int)colMin) + (placeholderRow + rowcount + 1));
                CmsInfo info = (CmsInfo)project.loadElement(id, project.getUser());
                for (int fileIndex = 0; fileIndex < Math.max(info.getUploadAttribute("files").size(), 1); ++fileIndex) {
                    boolean fileInRow = false;
                    for (PlaceholderLocation placeholder : this.placeholdersDOC) {
                        placeholder.resetContent();
                        if (fileIndex == 0) {
                            placeholder.setContent("#!#DOC.counter#!#", Integer.toString(documentCounter));
                            for (CmsAttribute att : info.getAttributes()) {
                                placeholder.setContent("#!#DOC.document-" + att.getCode() + "#!#", att.getValue().equals("") ? this.rep.textNoContent : att.getValue());
                            }
                        }
                        if (info.getUploadAttribute("files").size() > 0) {
                            String docFilename = info.getUploadAttribute("files").getUploadItem(fileIndex).getName();
                            fileInRow = placeholder.setContent("#!#DOC.file-name#!#", docFilename);
                            if (fileInRow && this.rep.includeDocuments) {
                                link = this.createHelper.createHyperlink(HyperlinkType.FILE);
                                File f = new File(this.exportFile.getParentFile(), "dokumente/" + docFilename);
                                link.setAddress(Util.uriEncode((String)f.getAbsolutePath()));
                                placeholder.setHyperlink(link);
                            }
                        } else {
                            placeholder.setContent("#!#DOC.file-name#!#", this.rep.textNoContent);
                        }
                        if (fileIndex == 0 || fileInRow) {
                            placeholder.writeToCell((Workbook)this.wb, rowcount);
                            continue;
                        }
                        placeholder.clearCell((Workbook)this.wb, rowcount);
                    }
                    int lastRow = sh.getLastRowNum();
                    if (lastRow >= placeholderRow + rowcount + 1) {
                        sh.shiftRows(placeholderRow + rowcount + 1, lastRow, 1);
                    }
                    ++rowcount;
                }
                ++documentCounter;
            }
            this.updateConditionalFormatting((Sheet)sh, rowcount);
        }
    }

    private int populateObservationDetails(int phSheet) {
        boolean bl;
        ArrayList<PlaceholderLocation> placeholdersOBSinSheet;
        ThemisProject project = ThemisApplication.getInstance().getProject();
        PlaceholderRangeImplementation pri = new PlaceholderRangeImplementation();
        ArrayList placeholdersToClear = new ArrayList();
        pri.sh = this.wb.getSheetAt(phSheet);
        String heading1Value = null;
        String heading1Attribute = this.getParameters(phSheet).get("obs.head1-attribute");
        String headingAttributeType = "observation";
        String headingAttributeCode = null;
        if (heading1Attribute != null) {
            String[] attspec;
            String[] split = heading1Attribute.split("\\.");
            String[] stringArray = attspec = split.length == 1 ? null : split[1].split("-");
            if (attspec != null && attspec.length > 1) {
                if (attspec[0].equals("location")) {
                    headingAttributeType = "location";
                }
                headingAttributeCode = attspec[1];
            }
        }
        if ((placeholdersOBSinSheet = this.getPlaceholdersForSheet(this.placeholdersOBS, phSheet)).isEmpty()) {
            return 0;
        }
        RowRange rangeOBSheading1 = new RowRange();
        for (PlaceholderLocation placeholderLocation : placeholdersOBSinSheet) {
            if (!placeholderLocation.hasPlaceholder("#!#obs.head1#!#")) continue;
            rangeOBSheading1.update(placeholderLocation);
        }
        RowRange rangeOBSfooter1 = new RowRange();
        for (PlaceholderLocation placeholderLocation : placeholdersOBSinSheet) {
            if (!placeholderLocation.hasPlaceholder("#!#obs.foot1#!#")) continue;
            rangeOBSfooter1.update(placeholderLocation);
        }
        RowRange rowRange = this.getRowRange(placeholdersOBSinSheet);
        if (rangeOBSheading1.rowFrom >= 0 && rowRange.rowFrom <= rangeOBSheading1.rowTo) {
            rowRange.rowFrom = rangeOBSheading1.rowTo + 1;
        }
        if (rangeOBSfooter1.rowTo >= 0 && rowRange.rowTo >= rangeOBSfooter1.rowFrom) {
            rowRange.rowTo = rangeOBSfooter1.rowFrom - 1;
        }
        if (rangeOBSheading1.rowFrom >= 0 && rangeOBSheading1.rowFrom > rowRange.rowFrom) {
            Dialogs.getInstance().showErrorDialog("error.report-heading-section");
            return 0;
        }
        if (rangeOBSfooter1.rowTo >= 0 && rangeOBSfooter1.rowTo < rowRange.rowFrom) {
            Dialogs.getInstance().showErrorDialog("error.report-footer-section");
            return 0;
        }
        if (rowRange.getLines() <= 0) {
            Dialogs.getInstance().showErrorDialog("error.report-no-content");
            return 0;
        }
        for (PlaceholderLocation ph : placeholdersOBSinSheet) {
            ph.setRowData(rowRange.rowFrom, rowRange.rowTo);
        }
        boolean bl3 = false;
        bl3 = false;
        boolean imageRepeatInRow = false;
        for (PlaceholderLocation phobs : placeholdersOBSinSheet) {
            if (phobs.hasHistory()) {
                bl = true;
            }
            if (!phobs.hasImageRepeatPlaceholder()) continue;
            imageRepeatInRow = true;
        }
        if (this.progress.isCancelled()) {
            return 0;
        }
        Iterator<Object> iterator = this.elementIds.iterator();
        while (iterator.hasNext()) {
            CmsHistory h;
            long docId;
            long id = (Long)iterator.next();
            this.progressCurrent += this.progressStep;
            this.progress.progress(project.getResourceText("progress.inserting.data"), (int)this.progressCurrent);
            if (this.observationIds.contains(id)) {
                pri.currobs = this.getObservation(id);
                pri.locId = pri.currobs.getRelationAttribute("location").getFirstElementId();
                pri.project.getLogger().fine("Processing OBSERVATION id " + id + " with location id " + pri.locId);
                pri.currloc = pri.locId >= 0L ? this.getLocation(pri.locId) : (CmsLocation)pri.project.getDefaultElement("location");
            } else {
                pri.locId = id;
                pri.currloc = this.getLocation(id);
                pri.currobs = (CmsObservation)pri.project.getDefaultElement("observation");
                pri.project.getLogger().fine("Processing LOCATION id " + id);
            }
            Iterator iterator2 = pri.currobs.getRelationAttribute("infos").getElementIds(false).iterator();
            while (iterator2.hasNext()) {
                docId = (Long)iterator2.next();
                if (this.documentIds.contains(docId)) continue;
                this.documentIds.add(docId);
            }
            iterator2 = pri.currloc.getRelationAttribute("infos").getElementIds(false).iterator();
            while (iterator2.hasNext()) {
                docId = (Long)iterator2.next();
                if (this.documentIds.contains(docId)) continue;
                this.documentIds.add(docId);
            }
            long observationtypeid = pri.currobs.getKeyAttribute("type").getId();
            pri.currobservationtype = "";
            switch ((int)observationtypeid) {
                case 1: {
                    pri.currobservationtype = this.rep.textObservationtypeMangel;
                    break;
                }
                case 4: {
                    pri.currobservationtype = this.rep.textObservationtypeAufgabe;
                    break;
                }
                case 2: {
                    pri.currobservationtype = this.rep.textObservationtypeKontrolle;
                    break;
                }
                case 3: {
                    pri.currobservationtype = this.rep.textObservationtypeInfo;
                }
            }
            ArrayList<Object> histories = new ArrayList<Object>();
            if (this.rep.exportWithHistories) {
                List obsHistories = pri.currobs.getHistories();
                if (obsHistories != null) {
                    histories.addAll(obsHistories);
                }
            } else if (this.rep.event != null) {
                h = pri.currobs.getHistory(this.rep.event);
                if (h != null) {
                    histories.add(h);
                }
            } else {
                h = pri.currobs.getLatestHistory();
                if (h != null) {
                    histories.add(h);
                }
            }
            int historyCount = 0;
            if (histories.isEmpty()) {
                histories.add(pri.project.getDefaultElement("history"));
            }
            for (CmsElement cmsElement : histories) {
                pri.currobs.applyHistory((CmsHistory)cmsElement);
                pri.currhist = cmsElement;
                ++pri.observationCounter;
                boolean imageInRow = false;
                boolean firstImage = true;
                boolean imagePlaceholder = false;
                boolean historyPlaceholder = false;
                placeholdersToClear.clear();
                pri.obsImages = new ArrayList<UploadItem>();
                pri.locImages = new ArrayList<UploadItem>();
                if (this.settings.getImageForObservation()) {
                    pri.obsImages = ExportUtil.getImages((CmsReport)this.rep, (CmsLocation)pri.currloc, (CmsObservation)pri.currobs, (CmsHistory)((CmsHistory)cmsElement));
                } else {
                    pri.locImages = ExportUtil.getImages((CmsReport)this.rep, (CmsLocation)pri.currloc, (CmsObservation)pri.currobs, (CmsHistory)((CmsHistory)cmsElement));
                }
                this.ph.clearCurrentUploadItems();
                if (cmsElement.getRelationAttribute("responsible").isEmpty()) {
                    pri.currcontact = null;
                } else {
                    long contactId = cmsElement.getRelationAttribute("responsible").getFirstElementId();
                    pri.currcontact = this.getContact(contactId);
                }
                if (headingAttributeType != null && headingAttributeCode != null && (rangeOBSheading1.isDefined() || rangeOBSfooter1.isDefined())) {
                    String newHeadingValue = null;
                    if ("observation".equalsIgnoreCase(headingAttributeType)) {
                        newHeadingValue = pri.currobs.getAttributeValue(headingAttributeCode);
                    } else if ("location".equalsIgnoreCase(headingAttributeType)) {
                        newHeadingValue = pri.currloc.getAttributeValue(headingAttributeCode);
                    }
                    if (!(newHeadingValue == null || heading1Value != null && newHeadingValue.equals(heading1Value))) {
                        pri.currentRow = rangeOBSheading1.rowFrom + pri.itemCounter * rowRange.getLines() + pri.headingCounter * rangeOBSheading1.getLines() + pri.footerCounter * rangeOBSfooter1.getLines();
                        if (pri.headingCounter > 0) {
                            pri.headingRows += rangeOBSheading1.getLines();
                        }
                        if (rangeOBSfooter1.isDefined() && pri.headingCounter > 0) {
                            pri.usePrevious();
                            this.populateObservationDetailPlaceholder(pri, placeholdersOBSinSheet, rangeOBSfooter1, 3, 0, pri.footerCounter > 0);
                            pri.headingRows += rangeOBSfooter1.getLines();
                            pri.currentRow += rangeOBSfooter1.getLines();
                            ++pri.footerCounter;
                        }
                        if (rangeOBSheading1.isDefined()) {
                            pri.useCurrent();
                            this.populateObservationDetailPlaceholder(pri, placeholdersOBSinSheet, rangeOBSheading1, 1, 0, pri.headingCounter > 0);
                            ++pri.headingCounter;
                        }
                        heading1Value = newHeadingValue;
                    }
                }
                for (int imageIndex = 0; imageIndex < Math.max(pri.obsImages.size(), 1) && (imageIndex <= 0 || imageRepeatInRow); ++imageIndex) {
                    int rowFromTotal = rangeOBSheading1.isDefined() ? rangeOBSheading1.rowFrom : rowRange.rowFrom;
                    int headerRowTotal = rangeOBSheading1.isDefined() ? pri.headingCounter * rangeOBSheading1.getLines() : 0;
                    int footerRowTotal = rangeOBSfooter1.isDefined() ? pri.footerCounter * rangeOBSfooter1.getLines() : 0;
                    int itemRowTotal = pri.itemCounter * rowRange.getLines();
                    pri.currentRow = rowFromTotal + itemRowTotal + headerRowTotal + footerRowTotal;
                    pri.project.getLogger().fine("Calculating current row as " + pri.currentRow + " = " + rowFromTotal + " + " + itemRowTotal + " + " + headerRowTotal + " + " + footerRowTotal);
                    pri.useCurrent();
                    this.populateObservationDetailPlaceholder(pri, placeholdersOBSinSheet, rowRange, 2, imageIndex, historyCount + imageIndex > 0);
                    if (pri.footerCounter == 0 && pri.itemCounter > 0) {
                        pri.footerShift += rowRange.getLines();
                        pri.project.getLogger().fine("Increasing shift for original footer rows to " + pri.footerShift);
                    }
                    imageInRow = false;
                    for (PlaceholderLocation phobs : placeholdersOBSinSheet) {
                        if (!phobs.hasImage()) continue;
                        imageInRow = true;
                        break;
                    }
                    for (PlaceholderLocation ph : placeholdersToClear) {
                        ph.writeToCell((Workbook)this.wb, "", pri.itemCounter);
                    }
                    placeholdersToClear.clear();
                    ++pri.itemCounter;
                    pri.lastLocId = pri.locId;
                    pri.updatePrevious();
                    if (!imageInRow) break;
                    firstImage = false;
                }
                ++historyCount;
                if (bl) continue;
                break;
            }
            if (!this.progress.isCancelled()) continue;
            return 0;
        }
        if (headingAttributeType != null && headingAttributeCode != null) {
            pri.currentRow = rangeOBSheading1.rowFrom + pri.itemCounter * rowRange.getLines() + pri.headingCounter * rangeOBSheading1.getLines() + pri.footerCounter * rangeOBSfooter1.getLines();
            if (pri.headingCounter > 0) {
                pri.headingRows += rangeOBSheading1.getLines();
            }
            if (rangeOBSfooter1.isDefined() && pri.headingCounter > 0) {
                pri.useCurrent();
                this.populateObservationDetailPlaceholder(pri, placeholdersOBSinSheet, rangeOBSfooter1, 3, -1, pri.footerCounter > 0);
                pri.headingRows += rangeOBSfooter1.getLines();
                pri.currentRow += rangeOBSfooter1.getLines();
                ++pri.footerCounter;
            }
        }
        this.updateConditionalFormatting((Sheet)pri.sh, pri.itemCounter * rowRange.getLines());
        for (PlaceholderLocation placeholder : placeholdersOBSinSheet) {
            if (!placeholder.hasPostPopulateTargets()) continue;
            placeholder.postPopulateImages();
        }
        return pri.itemCounter;
    }

    private void populateObservationDetailPlaceholder(PlaceholderRangeImplementation pri, ArrayList<PlaceholderLocation> phs, RowRange range, int section, int imageIndex, boolean shiftRows) {
        boolean newLocation = pri.lastLocId < 0L || pri.locId != pri.lastLocId;
        String sectionDef = "observation";
        switch (section) {
            case 3: {
                sectionDef = "footer";
                break;
            }
            case 1: {
                sectionDef = "header";
            }
        }
        pri.project.getLogger().fine("Adding " + sectionDef + " to row " + pri.currentRow + " (header=" + pri.headingCounter + " item=" + pri.itemCounter + " footer=" + pri.footerCounter + ")");
        if (section == 1 && pri.headingCounter > 0 || section == 2 && pri.itemCounter > 0 || section == 3 && pri.footerCounter > 0) {
            int r2 = pri.sh.getLastRowNum();
            if (pri.currentRow <= r2) {
                pri.project.getLogger().fine("... therefore inserting " + range.getLines() + " rows at " + pri.currentRow + " with last row " + r2);
                pri.sh.shiftRows(pri.currentRow, r2, range.getLines());
            }
            int shiftForFooter = 0;
            if (section == 3) {
                shiftForFooter = pri.footerShift;
            }
            pri.project.getLogger().fine("... therefore copying " + range.getLines() + " rows from row " + (range.rowFrom + shiftForFooter) + " to " + pri.currentRow);
            for (int row = range.rowFrom + shiftForFooter; row <= range.rowTo + shiftForFooter; ++row) {
                PlaceholderLocation.copyRow(this.wb, pri.sh, row, pri.currentRow + (row - range.rowFrom - shiftForFooter));
            }
        }
        long locId = pri.loc == null ? -1L : pri.loc.getId();
        for (PlaceholderLocation placeholderCell : phs) {
            if (!range.inRange(placeholderCell.getRow())) continue;
            placeholderCell.resetContent();
            placeholderCell.ignoreMergedRegions();
            if (placeholderCell.hasPlaceholder("#!#obs.rowheight#!#")) {
                placeholderCell.maintainRowHeight();
            }
            placeholderCell.setHeadingRows(pri.headingRows);
            if (imageIndex <= 0) {
                Object icon;
                this.populateReportDetails(placeholderCell, pri.projectElement);
                for (CmsAttribute att : pri.obs.getAttributes()) {
                    if ("type".equals(att.getCode())) continue;
                    if ("status".equals(att.getCode())) {
                        if (pri.obs.isOfType(4) || pri.obs.isOfType(1)) {
                            placeholderCell.setContent("#!#obs.observation-" + att.getCode() + "#!#", ((BooleanAttribute)att).isSet() ? this.rep.textStatusDone : this.rep.textStatusOpen);
                            continue;
                        }
                        placeholderCell.setContent("#!#obs.observation-" + att.getCode() + "#!#", "");
                        continue;
                    }
                    placeholderCell.setContent("#!#obs.observation-" + att.getCode() + "#!#", att.getValue().equals("") ? this.rep.textNoContent : att.getValue());
                }
                placeholderCell.setContent("#!#obs.counter#!#", Integer.toString(pri.observationCounter));
                placeholderCell.setContent("#!#obs.creator#!#", ThemisApplication.getInstance().getProject().getDatastorage().checkUser(pri.obs.getLongAttribute("meta_iduser").getLong()));
                placeholderCell.setContent("#!#obs.uuid#!#", pri.obs.getUUIDasString());
                placeholderCell.setContent("#!#obs.id#!#", Long.toString(pri.obs.getId()));
                placeholderCell.setContent("#!#obs.observation-type#!#", pri.observationtype);
                if (placeholderCell.hasPlaceholder("#!#obs.histories-dates#!#")) {
                    Iterator hists = pri.obs.getHistories();
                    ArrayList<String> dates = new ArrayList<String>();
                    Iterator iterator = hists.iterator();
                    while (iterator.hasNext()) {
                        CmsElement h = (CmsElement)iterator.next();
                        Date dt = h.getDateAttribute("eventdate").getDate();
                        if (dt == null) continue;
                        dates.add(Util.formatDate((Date)dt, (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
                    }
                    placeholderCell.setContent("#!#obs.histories-dates#!#", Util.toString(dates, (String)", "));
                }
                placeholderCell.setContent("#!#obs.histories-count#!#", Integer.toString(pri.obs.getHistories().size()));
                for (CmsAttribute att : pri.hist.getAttributes()) {
                    if ("done".equals(att.getCode())) {
                        if (pri.obs.isOfType(4) || pri.obs.isOfType(1)) {
                            placeholderCell.setContent("#!#obs.history-" + att.getCode() + "#!#", ((BooleanAttribute)att).isSet() ? this.rep.textStatusDone : this.rep.textStatusOpen);
                            continue;
                        }
                        placeholderCell.setContent("#!#obs.history-" + att.getCode() + "#!#", "");
                        continue;
                    }
                    if ("duedate".equals(att.getCode())) {
                        if (pri.obs.isOfType(3)) {
                            placeholderCell.setContent("#!#obs.history-" + att.getCode() + "#!#", "");
                            continue;
                        }
                        placeholderCell.setContent("#!#obs.history-" + att.getCode() + "#!#", att.getValue().equals("") ? this.rep.textNoContent : att.getValue());
                        continue;
                    }
                    if (att.isOfType(1)) {
                        placeholderCell.setContent("#!#obs.history-" + att.getCode() + "#!#", att.getValue().equals("") ? "Nein" : "Ja");
                        continue;
                    }
                    placeholderCell.setContent("#!#obs.history-" + att.getCode() + "#!#", att.getValue().equals("") ? this.rep.textNoContent : att.getValue());
                }
                if (pri.contact != null && this.settings.getObservationAttribute("responsible").isUsed()) {
                    for (CmsAttribute att : pri.contact.getAttributes()) {
                        placeholderCell.setContent("#!#obs.contact-" + att.getCode() + "#!#", att.getValue().equals("") ? this.rep.textNoContent : att.getValue());
                    }
                }
                if (pri.loc != null) {
                    for (CmsAttribute att : pri.loc.getAttributes()) {
                        if (!newLocation && !placeholderCell.repeatForEachObservation() && !placeholderCell.hasContentChanged()) continue;
                        if (att.getCode().equals("plan")) {
                            placeholderCell.setContent("#!#obs.location-" + att.getCode() + "#!#", att.getValue().equals("") ? ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.noMap.text") : att.getValue());
                            continue;
                        }
                        if (att.getCode().equals("icon")) {
                            if (pri.loc.getRelationAttribute("icon").isEmpty() || (icon = this.getIcon(pri.loc.getRelationAttribute("icon").getFirstElementId())).getUploadAttribute("file").getUploadItems().isEmpty()) continue;
                            placeholderCell.setContent("#!#obs.location-icon#!#", icon.getUploadAttribute("file").getFirstUploadItem(), null);
                            continue;
                        }
                        placeholderCell.setContent("#!#obs.location-" + att.getCode() + "#!#", att.getValue().equals("") ? this.rep.textNoContent : att.getValue());
                    }
                    placeholderCell.setContent("#!#obs.location-fullnumber#!#", pri.loc.getFullNumber());
                    placeholderCell.setContent("#!#obs.location-uuid#!#", pri.loc.getUUID().toString());
                    placeholderCell.setContent("#!#obs.location-creationdate#!#", Util.formatDate((Date)pri.loc.getDateAttribute("meta_created").getDate(), (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone()));
                    placeholderCell.setContent("#!#obs.location-systemcreationdate#!#", Util.formatDate((Date)pri.loc.getDateAttribute("meta_created").getDate(), (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone()));
                    if (newLocation || placeholderCell.repeatForEachObservation()) {
                        if (placeholderCell.hasPlaceholder("#!#obs.location-document-summary#!#")) {
                            StringBuilder sb = new StringBuilder();
                            boolean firstInfo = true;
                            for (CmsElementSummary ele : pri.loc.getRelationAttribute("infos").getElements()) {
                                if (!firstInfo) {
                                    sb.append("\n");
                                }
                                sb.append(ele.getTitle());
                                firstInfo = false;
                            }
                            placeholderCell.setContent("#!#obs.location-document-summary#!#", sb.toString());
                        }
                        int locImageCount = 1;
                        String locationImageNumbers = "";
                        icon = pri.locImages.iterator();
                        while (icon.hasNext()) {
                            UploadItem item = (UploadItem)icon.next();
                            if (item.getUploadDetail() == 2L) continue;
                            boolean phWithImage = false;
                            phWithImage = phWithImage || placeholderCell.setContent("#!#obs.location-image" + locImageCount + "-file#!#", item, pri.project.getDrawings(item.getId()));
                            phWithImage = phWithImage || placeholderCell.setContent("#!#obs.location-image" + locImageCount + "-info#!#", item.getFileInfo());
                            phWithImage = phWithImage || placeholderCell.setContent("#!#obs.location-image" + locImageCount + "-filename#!#", item.getName());
                            boolean bl = phWithImage = phWithImage || placeholderCell.setContent("#!#obs.location-image" + locImageCount + "-comment#!#", item.getFileComment());
                            if (placeholderCell.hasPlaceholder("#!#obs.location-image" + locImageCount + "-number#!#")) {
                                boolean bl2 = phWithImage = phWithImage || placeholderCell.setContent("#!#obs.location-image" + locImageCount + "-number#!#", Integer.toString(this.ph.getImageNumber(item)));
                            }
                            if (phWithImage) {
                                locationImageNumbers = locationImageNumbers + (locImageCount > 1 ? "," : "") + Integer.toString(this.ph.getImageNumber(item));
                            }
                            ++locImageCount;
                        }
                        placeholderCell.setContent("#!#obs.location-image-numbers#!#", locationImageNumbers);
                        placeholderCell.setContent("#!#obs.location-plansnippet-per-location#!#", new File(ThemisApplication.getInstance().getProject().getPlansnippetLocation(), locId + "_" + this.rep.getPlanSnippetSize() + ".jpg"));
                    }
                    placeholderCell.setContent("#!#obs.location-plansnippet#!#", new File(ThemisApplication.getInstance().getProject().getPlansnippetLocation(), locId + "_" + this.rep.getPlanSnippetSize() + ".jpg"));
                    placeholderCell.setContent("#!#obs.location-buildingtitle#!#", pri.loc.getBuildingTitle());
                }
                if (placeholderCell.hasPlaceholder("#!#obs.document-summary#!#")) {
                    StringBuilder sb = new StringBuilder();
                    boolean firstInfo = true;
                    icon = pri.obs.getRelationAttribute("infos").getElements().iterator();
                    while (icon.hasNext()) {
                        CmsElementSummary ele;
                        ele = (CmsElementSummary)icon.next();
                        if (!firstInfo) {
                            sb.append("\n");
                        }
                        sb.append(ele.getTitle());
                        firstInfo = false;
                    }
                    placeholderCell.setContent("#!#obs.document-summary#!#", sb.toString());
                }
            }
            int imagecount = 1;
            String observationImageNumbers = "";
            for (UploadItem item : pri.obsImages) {
                if (item.getUploadDetail() == 2L) continue;
                boolean phWithImage = false;
                phWithImage = phWithImage || placeholderCell.setContent("#!#obs.image" + imagecount + "-file#!#", item, pri.project.getDrawings(pri.obsImages.get(pri.obsImages.indexOf(item)).getId()));
                phWithImage = phWithImage || placeholderCell.setContent("#!#obs.image" + imagecount + "-info#!#", item.getFileInfo());
                phWithImage = phWithImage || placeholderCell.setContent("#!#obs.image" + imagecount + "-filename#!#", item.getName());
                phWithImage = phWithImage || placeholderCell.setContent("#!#obs.image" + imagecount + "-number#!#", imagecount + "");
                boolean bl = phWithImage = phWithImage || placeholderCell.setContent("#!#obs.image" + imagecount + "-comment#!#", item.getFileComment());
                if (placeholderCell.hasPlaceholder("#!#obs.image" + imagecount + "-number#!#")) {
                    boolean bl3 = phWithImage = phWithImage || placeholderCell.setContent("#!#obs.image" + imagecount + "-number#!#", Integer.toString(this.ph.getImageNumber(item)));
                }
                if (phWithImage) {
                    observationImageNumbers = observationImageNumbers + (imagecount > 1 ? "," : "") + Integer.toString(this.ph.getImageNumber(item));
                }
                ++imagecount;
            }
            if (imageIndex == 0) {
                placeholderCell.setContent("#!#obs.image-numbers#!#", observationImageNumbers);
            }
            if (!pri.obsImages.isEmpty() && imageIndex >= 0 && imageIndex < pri.obsImages.size()) {
                UploadItem item = pri.obsImages.get(imageIndex);
                placeholderCell.setContent("#!#obs.image-number#!#", Integer.toString(this.ph.getImageNumber(item)).equals("") ? this.rep.textNoContent : Integer.toString(this.ph.getImageNumber(item)));
                placeholderCell.setContent("#!#obs.image-comment#!#", item.getFileComment().equals("") ? this.rep.textNoContent : item.getFileComment());
                placeholderCell.setContent("#!#obs.image-info#!#", item.getFileInfo().equals("") ? this.rep.textNoContent : item.getFileInfo());
                placeholderCell.setContent("#!#obs.image-filename#!#", item.getName().equals("") ? this.rep.textNoContent : item.getName());
                placeholderCell.setContent("#!#obs.image-file#!#", item, pri.project.getDrawings(item.getId()));
            } else {
                placeholderCell.setContent("#!#obs.image-file#!#", this.rep.textNoImage);
            }
            placeholderCell.setSheetRow(pri.currentRow + placeholderCell.getRow() - range.rowFrom);
            if (placeholderCell.hasPlaceholder("#!#obs.pagebreak#!#")) {
                placeholderCell.writePageBreak(pri.itemCounter);
            }
            for (int ii = 1; ii <= 10; ++ii) {
                if (!placeholderCell.hasPlaceholder("#!#obs.pagebreak-" + ii + "#!#") || (pri.itemCounter + 1) % ii != 0) continue;
                placeholderCell.writePageBreak(pri.itemCounter);
            }
            if (imageIndex <= 0 || placeholderCell.hasImagePlaceholder()) {
                placeholderCell.writeToCell((Workbook)this.wb, pri.itemCounter);
                continue;
            }
            placeholderCell.writeToCell((Workbook)this.wb, "", pri.itemCounter);
        }
    }

    private void xxxxx() {
    }

    private void populateStatistics(int sheetNo) {
        Placeholder plhld = new Placeholder(this.rep);
        ArrayList<PlaceholderLocation> placeholders = this.getPlaceholdersAGG(sheetNo);
        if (!placeholders.isEmpty()) {
            String groupatt = null;
            ArrayList<String> aggAttributes = new ArrayList<String>();
            for (PlaceholderLocation ph : placeholders) {
                ArrayList<String> keys = ph.getPlaceholders();
                for (String key : keys) {
                    if (key.toLowerCase().startsWith("agg.group")) {
                        if (!key.contains("=")) continue;
                        groupatt = key.split("=")[1].toLowerCase();
                        continue;
                    }
                    if (!key.toLowerCase().startsWith("agg.") || aggAttributes.contains(key)) continue;
                    aggAttributes.add(key);
                }
            }
            if (groupatt == null) {
                return;
            }
            int countloc = 0;
            int countobs = 0;
            ArrayList<Long> usedLocationIds = new ArrayList<Long>();
            for (long id : this.observationIds) {
                CmsObservation obs = this.getObservation(id);
                CmsHistory hist = obs.getCurrentHistory();
                long locid = obs.getRelationAttribute("location").getFirstElementId();
                CmsLocation loc = locid >= 0L ? this.getLocation(locid) : null;
                String groupvalue = null;
                groupvalue = plhld.apply("#!#" + groupatt + "#!#", loc, obs, hist, null);
                if (groupvalue == null) {
                    groupvalue = "undefined";
                }
                for (String key : aggAttributes) {
                    this.getAggregationAttribute(key, groupvalue, (CmsElement)loc, countloc);
                }
                usedLocationIds.add(loc.getId());
                ++countloc;
                for (String key : aggAttributes) {
                    this.getAggregationAttribute(key, groupvalue, (CmsElement)obs, countobs);
                }
                ++countobs;
            }
            int placeholderRow = placeholders.get(0).getRow();
            XSSFSheet sh = this.wb.getSheetAt(placeholders.get((int)0).sheet);
            int colMin = -1;
            int colMax = -1;
            for (PlaceholderLocation ph : placeholders) {
                colMin = colMin < 0 ? ph.col : Math.min(colMin, ph.col);
                colMax = colMax < 0 ? ph.col : Math.max(colMax, ph.col);
            }
            int rowcount = 0;
            for (String key : this.aggregation.keySet()) {
                HashMap<String, String> map = this.aggregation.get(key);
                for (int col = colMin; col <= colMax; ++col) {
                    PlaceholderLocation.copyStyle((Sheet)sh, col, placeholderRow, placeholderRow + rowcount);
                }
                for (PlaceholderLocation placeholder : placeholders) {
                    placeholder.resetContent();
                    placeholder.setContent("#!#AGG.counter#!#", Integer.toString(rowcount + 1));
                    for (String aggkey : aggAttributes) {
                        placeholder.setContent("#!#" + aggkey + "#!#", map.get(aggkey));
                    }
                    placeholder.writeToCell((Workbook)this.wb, rowcount);
                }
                int lastRow = sh.getLastRowNum();
                if (placeholderRow + rowcount + 1 <= lastRow) {
                    sh.shiftRows(placeholderRow + rowcount + 1, lastRow, 1);
                }
                ++rowcount;
            }
        }
    }

    private void getAggregationAttribute(String key, String group, CmsElement ele, int count) {
        try {
            String attcode;
            String[] spec = key.split("=");
            String[] agg = spec[0].split("\\.");
            String aggtype = agg[1].toLowerCase();
            String[] attspec = spec[1].split("\\.");
            String[] att = attspec[1].split("-");
            String elementtype = att.length == 1 ? "observation" : att[0];
            String string = attcode = att.length == 1 ? att[0].toLowerCase() : att[1].toLowerCase();
            if (("history".equalsIgnoreCase(elementtype) || "observation".equalsIgnoreCase(elementtype)) && !ele.getElementcode().equals("observation")) {
                return;
            }
            if ("location".equalsIgnoreCase(elementtype) && !ele.getElementcode().equals("location")) {
                return;
            }
            String value = ele.getAttributeValue(attcode);
            boolean isfirst = false;
            HashMap<String, String> m = this.aggregation.get(group);
            if (m == null) {
                m = new HashMap();
                isfirst = true;
            }
            String currentstr = m.get(key);
            if (value != null || aggtype.equals("count")) {
                if (aggtype.equals("sum")) {
                    double v = Double.parseDouble(value);
                    double currentdbl = currentstr == null ? 0.0 : Double.parseDouble(currentstr);
                    m.put(key, Double.toString(Util.round((double)(currentdbl += v), (int)4)));
                } else if (aggtype.equals("avg")) {
                    double v = Double.parseDouble(value);
                    double currentdbl = currentstr == null ? 0.0 : Double.parseDouble(currentstr);
                    currentdbl = (currentdbl * (double)count + v) / (double)(count + 1);
                    m.put(key, Double.toString(currentdbl));
                } else if (aggtype.equals("first")) {
                    if (!m.containsKey(key)) {
                        m.put(key, value);
                    }
                } else if (aggtype.equals("count")) {
                    int currentdbl = currentstr == null ? 0 : Integer.parseInt(currentstr);
                    m.put(key, Integer.toString(++currentdbl));
                }
            }
            this.aggregation.put(group, m);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateConditionalFormatting(Sheet sh, int rowcount) {
        int ii;
        SheetConditionalFormatting sheetCF = sh.getSheetConditionalFormatting();
        int iimax = sheetCF.getNumConditionalFormattings();
        ArrayList cfs = new ArrayList();
        for (ii = 0; ii < iimax; ++ii) {
            int jj;
            ConditionalFormatting cf = sheetCF.getConditionalFormattingAt(ii);
            ConditionalFormattingRule[] rules = new ConditionalFormattingRule[cf.getNumberOfRules()];
            CellRangeAddress[] cellrange = cf.getFormattingRanges();
            for (jj = 0; jj < cellrange.length; ++jj) {
                cellrange[jj].setLastRow(cellrange[jj].getLastRow() + rowcount - 1);
            }
            for (jj = 0; jj < cf.getNumberOfRules(); ++jj) {
                rules[jj] = cf.getRule(jj);
            }
            try {
                for (ConditionalFormattingRule rule : rules) {
                    sheetCF.addConditionalFormatting(cellrange, rule);
                }
                continue;
            }
            catch (IllegalArgumentException ex) {
                if (!"Number of rules must not exceed 3".equals(ex.getMessage())) continue;
                Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("IN DER PROTOKOLL-VORLAGE SIND F\u00dcR MIND. EINE ZELLE MEHR ALS 3 BEDINGTE FORMATIERUNGEN DEFINIERT. DIES IST NICHT M\u00d6GLICH."));
            }
        }
        for (ii = 0; ii < iimax; ++ii) {
            sheetCF.removeConditionalFormatting(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File f) {
        int phCount = 147;
        String fn = Util.getFileNameWithoutExtension((File)f);
        if (!(this.wb instanceof XSSFWorkbook)) {
            f = new File(f.getParentFile(), fn + ".xls");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            this.wb.write((OutputStream)fos);
        }
        catch (FileNotFoundException ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.errorFileOpened.text"));
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.error.text"), ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/report/xls/Bundle").getString("ExportXlsReport.error.text"), ex);
            }
        }
    }

    private ArrayList<PlaceholderLocation> getPlaceholdersPG(int sheet) {
        return this.getPlaceholdersForSheet(this.placeholdersPG, sheet);
    }

    private ArrayList<PlaceholderLocation> getPlaceholdersREP(int sheet) {
        return this.getPlaceholdersForSheet(this.placeholdersREP, sheet);
    }

    private ArrayList<PlaceholderLocation> getPlaceholdersDOC(int sheet) {
        return this.getPlaceholdersForSheet(this.placeholdersDOC, sheet);
    }

    private ArrayList<PlaceholderLocation> getPlaceholdersAGG(int sheet) {
        return this.getPlaceholdersForSheet(this.placeholdersAGG, sheet);
    }

    private ArrayList<PlaceholderLocation> getPlaceholdersForSheet(ArrayList<PlaceholderLocation> placeholdersAll, int sheet) {
        ArrayList<PlaceholderLocation> placeholders = new ArrayList<PlaceholderLocation>();
        for (PlaceholderLocation ph : placeholdersAll) {
            if (ph.sheet != sheet) continue;
            placeholders.add(ph);
        }
        return placeholders;
    }

    private boolean planSnippetsIncludedInSheet(int sheetNo) {
        boolean result = false;
        for (PlaceholderLocation ph : this.getPlaceholdersForSheet(this.placeholdersOBS, sheetNo)) {
            if (!ph.hasPlaceholder("#!#obs.location-plansnippet#!#") && !ph.hasPlaceholder("#!#obs.location-plansnippet-per-location#!#")) continue;
            return true;
        }
        for (PlaceholderLocation ph : this.getPlaceholdersForSheet(this.placeholdersLOC, sheetNo)) {
            if (!ph.hasPlaceholder("#!#loc.plan-snippet#!#")) continue;
            return true;
        }
        for (PlaceholderLocation ph : this.getPlaceholdersForSheet(this.placeholdersPG, sheetNo)) {
            if (!ph.hasPlaceholder("#!#pg.plan-snippet#!#")) continue;
            return true;
        }
        return false;
    }

    private RowRange getRowRange(ArrayList<PlaceholderLocation> phs) {
        RowRange r = new RowRange();
        for (PlaceholderLocation ph : phs) {
            r.update(ph);
        }
        return r;
    }

    protected void addPagebreak() {
    }

    protected float getPageWidth() {
        return 1.0f;
    }

    protected void addTable() {
    }

    protected boolean hasTable() {
        return false;
    }

    protected void createTable(float[] colWidthCm, int noOfHeaderRows) {
    }

    protected void createCell(String c, LayoutCell l, Color cBG) {
    }

    protected void createImageCell(LayoutCell cell, ArrayList<SimpleGeometry> drawings, File imagefile, float colPixels, String text) {
    }

    protected void createMultipleImageCell(LayoutCell l, ArrayList<ReportGenerator.ImageSpecification> imageUploadItems, float imageWidth, float cellWidth) {
    }

    protected void setCellColSpan(int cols) {
    }

    protected void setCellBackground(Color c) {
    }

    protected void addCellToTable() {
    }

    protected void completeTableRow() {
    }

    protected void addParagraph(String txt) {
    }

    class PlaceholderRangeImplementation {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        XSSFSheet sh;
        ArrayList<PlaceholderLocation> phs;
        RowRange range;
        CmsProject projectElement = this.project.getProjectElement();
        CmsObservation obs;
        CmsElement hist;
        CmsLocation loc;
        CmsCompany contact;
        String observationtype;
        CmsObservation prevobs;
        CmsElement prevhist;
        CmsLocation prevloc;
        CmsCompany prevcontact;
        String prevobservationtype;
        CmsObservation currobs;
        CmsElement currhist;
        CmsLocation currloc;
        CmsCompany currcontact;
        String currobservationtype;
        int itemCounter = 0;
        int headingCounter = 0;
        int footerCounter = 0;
        int headingRows = 0;
        int observationCounter = 0;
        int imageCounter = 1;
        long locId;
        long lastLocId = -99L;
        int currentRow = -1;
        boolean newLocation;
        boolean isHeading;
        int footerShift = 0;
        List<UploadItem> locImages;
        List<UploadItem> obsImages;
        int imageIndex;

        PlaceholderRangeImplementation() {
        }

        public void updatePrevious() {
            this.prevobs = this.currobs;
            this.prevhist = this.currhist;
            this.prevloc = this.currloc;
            this.prevcontact = this.currcontact;
            this.prevobservationtype = this.currobservationtype;
        }

        public void usePrevious() {
            this.obs = this.prevobs;
            this.hist = this.prevhist;
            this.loc = this.prevloc;
            this.contact = this.prevcontact;
            this.observationtype = this.prevobservationtype;
        }

        public void useCurrent() {
            this.obs = this.currobs;
            this.hist = this.currhist;
            this.loc = this.currloc;
            this.contact = this.currcontact;
            this.observationtype = this.currobservationtype;
        }
    }

    class RowRange {
        int rowFrom = -1;
        int rowTo = -1;

        RowRange() {
        }

        protected boolean isDefined() {
            return this.rowFrom >= 0;
        }

        protected boolean inRange(int row) {
            return row >= this.rowFrom && row <= this.rowTo;
        }

        protected int getLines() {
            return this.isDefined() ? this.rowTo - this.rowFrom + 1 : 0;
        }

        protected void update(PlaceholderLocation ph) {
            if (this.rowFrom < 0 || this.rowFrom > ph.getRow()) {
                this.rowFrom = ph.getRow();
            }
            if (this.rowTo < 0 || this.rowTo < ph.getRow()) {
                this.rowTo = ph.getRow();
            }
        }

        public String toString() {
            return "Range from " + this.rowFrom + " to " + this.rowTo;
        }
    }
}

