/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.server;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.config.ProjectSettingsPanel;
import at.grid.themis.application.server.ServerCreateCodePanel;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.javafx.ThemisTaskResult;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.server.ThemisCloudProjectInfo;
import at.grid.themis.ontology.server.ThemisCloudServer;
import at.grid.util.ProgressHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerCodePanel
extends ThemisPanel {
    private final ProjectSettingsPanel wizard;
    private JButton btnApplyStandard;
    private JButton btnDeleteServerContent;
    private JButton btnRemove;
    private JButton btnThemisServerCreateCode;
    private JButton btnThemisServerCreateCode1;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JCheckBox chkExportToServer;
    private JCheckBox chkImportFromServer;
    private JLabel fldProjektId;
    private JTextField fldThemisServerCode;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel86;
    private JLabel jLabel87;
    private JLabel jLabel88;
    private JLabel jLabel89;
    private JLabel jLabel90;
    private JLabel jLabel91;
    private JLabel jLabel92;
    private JLabel lblProjektID;
    private JPanel panelServer;
    private JScrollPane panelServerScroll;
    private JPanel panelSettings;

    public ServerCodePanel() {
        this((ProjectSettingsPanel)null);
    }

    public ServerCodePanel(ProjectSettingsPanel wizard) {
        this.initComponents();
        this.wizard = wizard;
    }

    @Override
    public void populate(ProgressHandler ph) {
        if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            this.setVisible(false);
        }
        String serverCode = this.settings.getThemisServerCode();
        this.fldThemisServerCode.setText(serverCode);
        this.fldProjektId.setText(this.project.getProjectElement().getUUIDasString());
        this.showOrHideProjectId();
        boolean hasServer = this.project.hasThemisServer();
        this.chkImportFromServer.setSelected(hasServer && this.settings.getAutoImportFromServer());
        this.chkExportToServer.setSelected(hasServer && this.settings.getAutoExportFullProject());
        this.panelSettings.setVisible(hasServer);
        this.updateStandardButtonEnabled();
    }

    private void showOrHideProjectId() {
        boolean hasServer = this.project.hasThemisServer();
    }

    @Override
    public void apply() {
        boolean hasServer = this.project.hasThemisServer();
        this.settings.setAutoImportFromServer(hasServer && this.chkImportFromServer.isSelected());
        this.settings.setAutoExportFullProject(hasServer && this.chkExportToServer.isSelected());
    }

    private void createProjectConfigurationOnServer() {
        String serverCode = this.fldThemisServerCode.getText().trim();
        if ("".equals(serverCode)) {
            this.project.getLogger().info("Server settings removed");
            this.project.removeThemisServer();
            return;
        }
        this.settings.setThemisServerCode(serverCode);
        ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> {
            try {
                ph.progress("task.server.progress.connecting");
                this.project.getLogger().info("Loading server, Server code: " + serverCode);
                ThemisCloudServer s = this.project.getThemisServer();
                if (s == null) {
                    this.settings.setThemisServerCode("");
                    this.fldThemisServerCode.setText("");
                    this.updateStandardButtonEnabled();
                    return;
                }
                if (!serverCode.equals(s.getServerCode())) {
                    s = ThemisCloudServer.fromCode((String)serverCode);
                    this.project.setThemisServer(s);
                }
                this.project.getLogger().info("Creating server with code " + serverCode);
                ph.progress("task.server.progress.configuring");
                ThemisCloudProjectInfo i = s.uploadProjectInfo(this.project, true);
                if (i.isProjectTitleDiffers()) {
                    this.project.setThemisServer(null);
                    this.fldThemisServerCode.setText("");
                    this.updateStandardButtonEnabled();
                    this.panelSettings.setVisible(false);
                    this.app.getDialog().showErrorDialog("error.server.uuid-already-on-server", new String[]{i.getTitle()});
                } else {
                    this.panelSettings.setVisible(true);
                }
            }
            catch (Exception ex) {
                this.settings.setThemisServerCode("");
                this.fldThemisServerCode.setText("");
                this.updateStandardButtonEnabled();
                this.app.getDialog().showErrorDialog("task.server.progress.setup-error", ex);
            }
        });
    }

    private void updateStandardButtonEnabled() {
        if (this.app.getSettings().getDefaultThemisServerCode().isEmpty()) {
            this.btnApplyStandard.setEnabled(false);
        } else if (!this.fldThemisServerCode.getText().isEmpty()) {
            this.btnApplyStandard.setEnabled(false);
        } else {
            this.btnApplyStandard.setEnabled(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.panelServerScroll = new JScrollPane();
        this.panelServer = new JPanel();
        this.jLabel86 = new JLabel();
        this.jLabel92 = new JLabel();
        this.jLabel87 = new JLabel();
        this.fldThemisServerCode = new JTextField();
        this.btnThemisServerCreateCode1 = new JButton();
        this.btnRemove = new JButton();
        this.btnApplyStandard = new JButton();
        this.lblProjektID = new JLabel();
        this.fldProjektId = new JLabel();
        this.jLabel91 = new JLabel();
        this.btnThemisServerCreateCode = new JButton();
        this.panelSettings = new JPanel();
        this.jLabel89 = new JLabel();
        this.jLabel1 = new JLabel();
        this.chkImportFromServer = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.chkExportToServer = new JCheckBox();
        this.jLabel90 = new JLabel();
        this.jLabel88 = new JLabel();
        this.btnDeleteServerContent = new JButton();
        this.jLabel3 = new JLabel();
        this.setMinimumSize(new Dimension(200, 10));
        this.setLayout(new BorderLayout());
        this.panelServerScroll.setHorizontalScrollBarPolicy(31);
        this.panelServer.setLayout(new GridBagLayout());
        this.jLabel86.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel86, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.jLabel86.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 15, 5);
        this.panelServer.add((Component)this.jLabel86, gridBagConstraints);
        this.jLabel92.setFont(THEMIS.fontLabel);
        this.jLabel92.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel92, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.jLabel92.text"));
        this.jLabel92.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServer.add((Component)this.jLabel92, gridBagConstraints);
        this.jLabel87.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel87, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.jLabel87.text"));
        this.jLabel87.setMaximumSize(null);
        this.jLabel87.setMinimumSize(null);
        this.jLabel87.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServer.add((Component)this.jLabel87, gridBagConstraints);
        this.fldThemisServerCode.setColumns(1);
        this.fldThemisServerCode.setFont(THEMIS.fontTextfield);
        this.fldThemisServerCode.setText(NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.fldThemisServerCode.text"));
        this.fldThemisServerCode.setMinimumSize(new Dimension(150, 30));
        this.fldThemisServerCode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ServerCodePanel.this.fldThemisServerCodeKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServer.add((Component)this.fldThemisServerCode, gridBagConstraints);
        this.btnThemisServerCreateCode1.setFont(THEMIS.fontButton);
        this.btnThemisServerCreateCode1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnThemisServerCreateCode1, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.btnThemisServerCreateCode1.text"));
        this.btnThemisServerCreateCode1.setMaximumSize(null);
        this.btnThemisServerCreateCode1.setMinimumSize(null);
        this.btnThemisServerCreateCode1.setPreferredSize(null);
        this.btnThemisServerCreateCode1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerCodePanel.this.btnThemisServerCreateCode1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServer.add((Component)this.btnThemisServerCreateCode1, gridBagConstraints);
        this.btnRemove.setFont(THEMIS.fontButton);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.btnRemove.text"));
        this.btnRemove.setMaximumSize(null);
        this.btnRemove.setMinimumSize(null);
        this.btnRemove.setPreferredSize(null);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerCodePanel.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServer.add((Component)this.btnRemove, gridBagConstraints);
        this.btnApplyStandard.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnApplyStandard, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.btnApplyStandard.text"));
        this.btnApplyStandard.setToolTipText(NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.btnApplyStandard.toolTipText"));
        this.btnApplyStandard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerCodePanel.this.btnApplyStandardActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServer.add((Component)this.btnApplyStandard, gridBagConstraints);
        this.lblProjektID.setFont(THEMIS.fontLabel);
        this.lblProjektID.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.lblProjektID, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.lblProjektID.text_1"));
        this.lblProjektID.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServer.add((Component)this.lblProjektID, gridBagConstraints);
        this.fldProjektId.setFont(THEMIS.fontLabel);
        this.fldProjektId.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.fldProjektId, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.fldProjektId.text"));
        this.fldProjektId.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServer.add((Component)this.fldProjektId, gridBagConstraints);
        this.jLabel91.setFont(THEMIS.fontLabel);
        this.jLabel91.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel91, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.jLabel91.text"));
        this.jLabel91.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServer.add((Component)this.jLabel91, gridBagConstraints);
        this.btnThemisServerCreateCode.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnThemisServerCreateCode, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.btnThemisServerCreateCode.text"));
        this.btnThemisServerCreateCode.setToolTipText(NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.btnThemisServerCreateCode.toolTipText"));
        this.btnThemisServerCreateCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerCodePanel.this.btnThemisServerCreateCodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelServer.add((Component)this.btnThemisServerCreateCode, gridBagConstraints);
        this.panelSettings.setLayout(new GridBagLayout());
        this.jLabel89.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel89, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.jLabel89.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panelSettings.add((Component)this.jLabel89, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.chkImportFromServer.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkImportFromServer, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.chkImportFromServer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSettings.add((Component)this.chkImportFromServer, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSettings.add((Component)this.jLabel2, gridBagConstraints);
        this.chkExportToServer.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkExportToServer, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.chkExportToServer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSettings.add((Component)this.chkExportToServer, gridBagConstraints);
        this.jLabel90.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel90, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.jLabel90.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panelSettings.add((Component)this.jLabel90, gridBagConstraints);
        this.jLabel88.setFont(THEMIS.fontLabel);
        this.jLabel88.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel88, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.jLabel88.text_1"));
        this.jLabel88.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSettings.add((Component)this.jLabel88, gridBagConstraints);
        this.btnDeleteServerContent.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteServerContent, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.btnDeleteServerContent.text"));
        this.btnDeleteServerContent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerCodePanel.this.btnDeleteServerContentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSettings.add((Component)this.btnDeleteServerContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelServer.add((Component)this.panelSettings, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ServerCodePanel.class, (String)"ServerCodePanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelServer.add((Component)this.jLabel3, gridBagConstraints);
        this.panelServerScroll.setViewportView(this.panelServer);
        this.add((Component)this.panelServerScroll, "Center");
    }

    private void btnThemisServerCreateCodeActionPerformed(ActionEvent evt) {
        ServerCreateCodePanel p = new ServerCreateCodePanel();
        p.showDialog();
        if (p.getCode() != null) {
            this.fldThemisServerCode.setText(p.getCode());
            this.updateStandardButtonEnabled();
        }
    }

    private void btnThemisServerCreateCode1ActionPerformed(ActionEvent evt) {
        this.createProjectConfigurationOnServer();
        this.showOrHideProjectId();
        if (this.wizard != null) {
            this.wizard.updateServerInfo(this);
        } else {
            this.closeDialog();
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        if (this.app.getDialog().showConfirmDialog("dialog.server-delete-code.text")) {
            this.fldThemisServerCode.setText("");
            this.settings.setThemisServerCode(null);
            this.project.setThemisServer(null);
            if (this.wizard != null) {
                this.wizard.updateServerInfo(this);
            }
            this.populate();
        }
    }

    private void btnDeleteServerContentActionPerformed(ActionEvent evt) {
        String ask = ThemisApplication.getInstance().getDialog().showInputDialog("dialog.server.deletecontent", "dialog.server.deletecontent.title");
        if ("l\u00f6schen".equalsIgnoreCase(ask) || "delete".equalsIgnoreCase(ask)) {
            ThemisTaskResult result = new ThemisTaskResult();
            ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> {
                try {
                    ph.progress("task.server.progress.connecting");
                    ThemisCloudServer s = this.project.getThemisServer();
                    if (s == null) {
                        return;
                    }
                    ph.progress("task.server.progress.deleting");
                    s.deleteProject(this.project.getProjectElement().getUUIDasString());
                    this.project.removeThemisServer();
                    this.fldThemisServerCode.setText("");
                    this.settings.setThemisServerCode(null);
                    this.project.setThemisServer(null);
                    if (this.wizard != null) {
                        this.wizard.updateServerInfo(this);
                    }
                    this.populate();
                }
                catch (IOException ex) {
                    result.addMessage("task.server.progress.deletion-error");
                }
            });
            if (result.hasMessages()) {
                Dialogs.getInstance().showErrorDialog(result.getFirstMessage());
            }
        }
    }

    private void btnApplyStandardActionPerformed(ActionEvent evt) {
        String servercode = this.app.getSettings().getDefaultThemisServerCode();
        if (this.fldThemisServerCode.getText().trim().isEmpty() && servercode != null && !servercode.trim().isEmpty()) {
            this.fldThemisServerCode.setText(servercode);
        }
    }

    private void fldThemisServerCodeKeyTyped(KeyEvent evt) {
        this.updateStandardButtonEnabled();
    }

    @Override
    public String getDialogCode() {
        return "servercode";
    }

    @Override
    public Dimension getPanelSize() {
        return new Dimension(600, 230);
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(600, 230);
    }
}

