/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.server;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.barcode.BarcodeGenerator;
import at.grid.themis.application.config.ProjectSettingsPanel;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.javafx.ThemisTaskResult;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.server.ThemisCloudProjectInfo;
import at.grid.themis.ontology.server.ThemisCloudServer;
import at.grid.util.CryptoUtilites;
import at.grid.util.ProgressHandler;
import com.google.zxing.WriterException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.JDOMException;
import org.json.JSONException;
import org.json.JSONObject;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerProjectCodesPanel
extends ThemisPanel {
    private final ArrayList<String> accesscodes = new ArrayList();
    private final ProjectSettingsPanel wizard;
    private JButton btnCopyToClipboard;
    private JButton btnDeleteAccessCode;
    private JButton btnSetServerPermission;
    private JButton btnThemisServerCreateCode;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JTextField fldThemisServerAccessCode;
    private JComboBox<String> fldThemisServerPermission;
    private JTextField fldThemisServerProjectCode;
    private JLabel jLabel2;
    private JLabel jLabel86;
    private JLabel jLabel91;
    private JLabel jLabel93;
    private JLabel jLabel94;
    private JLabel jLabel95;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JLabel lblThemisServerProjectQRcode;
    private JList<String> lstAccessCodes;
    private JPanel panelAcessPermission;
    private JPanel panelServer;
    private JScrollPane panelServerScroll;

    public ServerProjectCodesPanel() {
        this((ProjectSettingsPanel)null);
    }

    public ServerProjectCodesPanel(ProjectSettingsPanel wizard) {
        this.initComponents();
        this.wizard = wizard;
        this.panelAcessPermission.setVisible(false);
    }

    @Override
    public void populate() {
        ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> this.populate(ph));
    }

    @Override
    public void populate(ProgressHandler ph) {
        try {
            if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
                this.setVisible(false);
                return;
            }
            this.enableDialogComponents(true);
            ph.progress("task.server.progress.connecting");
            ThemisCloudServer s = this.project.getThemisServer();
            if (s == null || !s.isServerAvailable()) {
                if (this.wizard != null) {
                    this.enableDialogComponents(false);
                    this.wizard.invalidatePanel(this);
                    this.app.getDialog().showErrorDialog("task.server.progress.connection-error");
                }
                return;
            }
            ph.progress("task.server.progress.read-config");
            ThemisCloudProjectInfo info = s.readProjectInfo(this.project.getProjectElement().getUUIDasString());
            switch (info.getPermission()) {
                case OPEN: {
                    this.fldThemisServerPermission.setSelectedIndex(0);
                    break;
                }
                default: {
                    this.fldThemisServerPermission.setSelectedIndex(1);
                }
            }
            this.accesscodes.addAll(info.getValidAccessCodes());
            this.updateAccessCodes();
        }
        catch (IOException | JDOMException ex) {
            Dialogs.getInstance().showErrorDialog("task.server.progress.connection-error", (Exception)ex);
        }
    }

    private void enableDialogComponents(boolean enabled) {
        this.fldThemisServerAccessCode.setEnabled(enabled);
        this.btnThemisServerCreateCode.setEnabled(enabled);
        this.lstAccessCodes.setEnabled(enabled);
        this.btnDeleteAccessCode.setEnabled(enabled);
        this.btnCopyToClipboard.setEnabled(enabled);
    }

    @Override
    public void apply() {
    }

    public void updateAccessCodes() {
        Collections.sort(this.accesscodes);
        ((DefaultListModel)this.lstAccessCodes.getModel()).removeAllElements();
        this.accesscodes.forEach(s -> ((DefaultListModel)this.lstAccessCodes.getModel()).addElement(s));
    }

    private boolean uploadProjectCode(String accessCode) {
        ThemisTaskResult result = new ThemisTaskResult();
        ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> {
            try {
                ph.progress("task.server.progress.connecting");
                ThemisCloudServer s = this.project.getThemisServer();
                if (s == null || !s.isServerAvailable()) {
                    this.app.getDialog().showErrorDialog("task.server.progress.connection-error");
                    return;
                }
                ph.progress("task.server.progress.read-config");
                ThemisCloudProjectInfo info = s.readProjectInfo(this.project.getProjectElement().getUUIDasString());
                ph.progress("task.server.progress.update-config");
                info.addAccessCode(new ThemisCloudProjectInfo.ServerAccess(accessCode, ""));
                s.updateProjectInfo(info);
                result.setOk(true);
            }
            catch (IOException | IllegalArgumentException | JDOMException ex) {
                Dialogs.getInstance().showErrorDialog("task.server.progress.access-code-error", (Exception)ex);
                result.setOk(false);
            }
        });
        return result.isOk();
    }

    private void createProjectCode() {
        try {
            this.fldThemisServerProjectCode.setText(null);
            this.lblThemisServerProjectQRcode.setIcon(null);
            String accessCode = this.fldThemisServerAccessCode.getText();
            if ("".equals(accessCode)) {
                this.app.getDialog().showErrorDialog("dialog.server.access-code");
                return;
            }
            ThemisCloudServer s = this.project.getThemisServer();
            if (s == null) {
                return;
            }
            JSONObject o = new JSONObject();
            o.put("type", (Object)s.getTypeAsString()).put("url", (Object)s.getUrl()).put("user", (Object)s.getUser()).put("pwd", (Object)s.getPassword()).put("uuid", (Object)this.project.getProjectElement().getUUIDasString()).put("access", (Object)accessCode);
            String projectCode = CryptoUtilites.encryptAes((String)o.toString());
            this.fldThemisServerProjectCode.setText(projectCode);
            BufferedImage bi = BarcodeGenerator.createQRcodeImage(projectCode, 200, 1);
            this.lblThemisServerProjectQRcode.setText("");
            this.lblThemisServerProjectQRcode.setIcon(new ImageIcon(bi));
            if (!this.accesscodes.contains(accessCode)) {
                boolean success = this.uploadProjectCode(accessCode);
                if (!success) {
                    this.lblThemisServerProjectQRcode.setText(null);
                    this.lblThemisServerProjectQRcode.setIcon(null);
                    return;
                }
                this.accesscodes.add(accessCode);
                this.updateAccessCodes();
            }
        }
        catch (WriterException | IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | JSONException ex) {
            Dialogs.getInstance().showErrorDialog("task.server.progress.access-code-error", (Exception)ex);
        }
    }

    private void deleteProjectCode(String access) {
        this.fldThemisServerProjectCode.setText(null);
        this.lblThemisServerProjectQRcode.setIcon(null);
        if (this.accesscodes.contains(access)) {
            ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> {
                try {
                    ph.progress("task.server.progress.connecting");
                    ThemisCloudServer s = this.project.getThemisServer();
                    if (s == null || !s.isServerAvailable()) {
                        this.app.getDialog().showErrorDialog("task.server.progress.connection-error");
                        return;
                    }
                    ph.progress("task.server.progress.update-config");
                    ThemisCloudProjectInfo info = s.readProjectInfo(this.project.getProjectElement().getUUIDasString());
                    info.removeAccessCode(access);
                    s.updateProjectInfo(info);
                    this.accesscodes.remove(access);
                    this.updateAccessCodes();
                }
                catch (IOException | IllegalArgumentException | JDOMException ex) {
                    Dialogs.getInstance().showErrorDialog("task.server.progress.config-update-error", (Exception)ex);
                }
            });
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.panelServerScroll = new JScrollPane();
        this.panelServer = new JPanel();
        this.jLabel86 = new JLabel();
        this.panelAcessPermission = new JPanel();
        this.jLabel93 = new JLabel();
        this.fldThemisServerPermission = new JComboBox();
        this.btnSetServerPermission = new JButton();
        this.jLabel94 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.jPanel6 = new JPanel();
        this.fldThemisServerAccessCode = new JTextField();
        this.btnThemisServerCreateCode = new JButton();
        this.jLabel95 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstAccessCodes = new JList();
        this.btnDeleteAccessCode = new JButton();
        this.jPanel2 = new JPanel();
        this.lblThemisServerProjectQRcode = new JLabel();
        this.jLabel91 = new JLabel();
        this.fldThemisServerProjectCode = new JTextField();
        this.btnCopyToClipboard = new JButton();
        this.jLabel2 = new JLabel();
        this.setMinimumSize(new Dimension(200, 10));
        this.setLayout(new BorderLayout());
        this.panelServerScroll.setHorizontalScrollBarPolicy(31);
        this.panelServer.setLayout(new GridBagLayout());
        this.jLabel86.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel86, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.jLabel86.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 15, 3);
        this.panelServer.add((Component)this.jLabel86, gridBagConstraints);
        this.panelAcessPermission.setLayout(new GridBagLayout());
        this.jLabel93.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel93, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.jLabel93.text"));
        this.jLabel93.setMinimumSize(null);
        this.jLabel93.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.panelAcessPermission.add((Component)this.jLabel93, gridBagConstraints);
        this.fldThemisServerPermission.setFont(THEMIS.fontList);
        this.fldThemisServerPermission.setModel(new DefaultComboBoxModel<String>(new String[]{"Keine Einschr\u00e4nkung", "Ausgew\u00e4hlte Anwender"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAcessPermission.add(this.fldThemisServerPermission, gridBagConstraints);
        this.btnSetServerPermission.setFont(THEMIS.fontButton);
        this.btnSetServerPermission.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetServerPermission, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.btnSetServerPermission.text"));
        this.btnSetServerPermission.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerProjectCodesPanel.this.btnSetServerPermissionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAcessPermission.add((Component)this.btnSetServerPermission, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelServer.add((Component)this.panelAcessPermission, gridBagConstraints);
        this.jLabel94.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel94, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.jLabel94.text"));
        this.jLabel94.setMinimumSize(null);
        this.jLabel94.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServer.add((Component)this.jLabel94, gridBagConstraints);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBackground(new Color(240, 240, 240));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(THEMIS.fontLabelSmall);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(3);
        this.jTextArea1.setText(NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelServer.add((Component)this.jTextArea1, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.fldThemisServerAccessCode.setColumns(1);
        this.fldThemisServerAccessCode.setFont(THEMIS.fontTextfield);
        this.fldThemisServerAccessCode.setText(NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.fldThemisServerAccessCode.text"));
        this.fldThemisServerAccessCode.setMinimumSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.fldThemisServerAccessCode, gridBagConstraints);
        this.btnThemisServerCreateCode.setFont(THEMIS.fontButton);
        this.btnThemisServerCreateCode.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/qr-code24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnThemisServerCreateCode, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.btnThemisServerCreateCode.text"));
        this.btnThemisServerCreateCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerProjectCodesPanel.this.btnThemisServerCreateCodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnThemisServerCreateCode, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelServer.add((Component)this.jPanel6, gridBagConstraints);
        this.jLabel95.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel95, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.jLabel95.text"));
        this.jLabel95.setMinimumSize(null);
        this.jLabel95.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.panelServer.add((Component)this.jLabel95, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(null);
        this.lstAccessCodes.setFont(THEMIS.fontList);
        this.lstAccessCodes.setModel(new DefaultListModel());
        this.lstAccessCodes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ServerProjectCodesPanel.this.lstAccessCodesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstAccessCodes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnDeleteAccessCode.setFont(THEMIS.fontButton);
        this.btnDeleteAccessCode.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteAccessCode, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.btnDeleteAccessCode.text"));
        this.btnDeleteAccessCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerProjectCodesPanel.this.btnDeleteAccessCodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel5.add((Component)this.btnDeleteAccessCode, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblThemisServerProjectQRcode, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.lblThemisServerProjectQRcode.text"));
        this.lblThemisServerProjectQRcode.setToolTipText(NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.lblThemisServerProjectQRcode.toolTipText"));
        this.lblThemisServerProjectQRcode.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblThemisServerProjectQRcode.setMinimumSize(new Dimension(200, 200));
        this.lblThemisServerProjectQRcode.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblThemisServerProjectQRcode, gridBagConstraints);
        this.jLabel91.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.jLabel91, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.jLabel91.text"));
        this.jLabel91.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel91, gridBagConstraints);
        this.fldThemisServerProjectCode.setFont(THEMIS.fontTextfield);
        this.fldThemisServerProjectCode.setText(NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.fldThemisServerProjectCode.text"));
        this.fldThemisServerProjectCode.setEnabled(false);
        this.fldThemisServerProjectCode.setMinimumSize(new Dimension(100, 30));
        this.fldThemisServerProjectCode.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldThemisServerProjectCode, gridBagConstraints);
        this.btnCopyToClipboard.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopyToClipboard, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.btnCopyToClipboard.text"));
        this.btnCopyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerProjectCodesPanel.this.btnCopyToClipboardActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnCopyToClipboard, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ServerProjectCodesPanel.class, (String)"ServerProjectCodesPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panelServer.add((Component)this.jPanel4, gridBagConstraints);
        this.panelServerScroll.setViewportView(this.panelServer);
        this.add((Component)this.panelServerScroll, "Center");
    }

    private void btnCopyToClipboardActionPerformed(ActionEvent evt) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.fldThemisServerProjectCode.getText()), null);
    }

    private void btnThemisServerCreateCodeActionPerformed(ActionEvent evt) {
        this.createProjectCode();
    }

    private void lstAccessCodesValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            String sel = this.lstAccessCodes.getSelectedValue();
            this.fldThemisServerAccessCode.setText(sel);
            if (sel != null) {
                this.createProjectCode();
            }
        }
    }

    private void btnDeleteAccessCodeActionPerformed(ActionEvent evt) {
        String sel = this.lstAccessCodes.getSelectedValue();
        if (sel != null) {
            this.deleteProjectCode(sel);
        }
    }

    private void btnSetServerPermissionActionPerformed(ActionEvent evt) {
        ThemisCloudServer.Permission perm = this.fldThemisServerPermission.getSelectedIndex() == 0 ? ThemisCloudServer.Permission.OPEN : ThemisCloudServer.Permission.USER;
        ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> {
            try {
                ph.progress("task.server.progress.connecting");
                ThemisCloudServer s = this.project.getThemisServer();
                if (s == null || !s.isServerAvailable()) {
                    this.app.getDialog().showErrorDialog("task.server.progress.connection-error");
                    return;
                }
                ThemisCloudProjectInfo info = s.readProjectInfo(this.project.getProjectElement().getUUIDasString());
                ph.progress("task.server.progress.update-config");
                info.setPermission(perm);
                s.updateProjectInfo(info);
            }
            catch (IOException | IllegalArgumentException | JDOMException ex) {
                Dialogs.getInstance().showErrorDialog("task.server.progress.config-update-error", (Exception)ex);
            }
        });
    }

    @Override
    public String getDialogCode() {
        return "servercode";
    }

    @Override
    public Dimension getPanelSize() {
        return new Dimension(100, 900);
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(700, 600);
    }
}

