/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.server;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.config.ProjectSettingsPanel;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.jobmanager.EditJobFxPanel;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.server.ThemisCloudProjectInfo;
import at.grid.themis.ontology.server.ThemisCloudServer;
import at.grid.themis.ontology.server.ThemisJob;
import at.grid.util.ProgressHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.JDOMException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerStatusPanel
extends ThemisPanel {
    private final ProjectSettingsPanel wizard;
    private ThemisCloudProjectInfo info;
    private ThemisJob currentJob;
    private JButton btnClose;
    private JButton btnDeleteJob;
    private JButton btnEditJob;
    private JButton btnGetJobs;
    private JButton btnLoadJob;
    private JTextField fldDuedate;
    private JTextArea fldHistory;
    private JTextField fldResponsible;
    private JTextField fldStatus;
    private JTextField fldTitle;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JList<ThemisJob> lstCurrentJobs;
    private JList<ThemisJob> lstDoneJobs;
    private JPanel panelButtons;
    private JPanel panelDoneJobs;
    private JPanel panelJob;
    private JPanel panelOpenJobs;

    public ServerStatusPanel() {
        this((ProjectSettingsPanel)null);
    }

    public ServerStatusPanel(ProjectSettingsPanel wizard) {
        this.initComponents();
        this.wizard = wizard;
    }

    @Override
    public void populate() {
        ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> this.populate(ph));
    }

    @Override
    public void populate(ProgressHandler ph) {
        try {
            if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
                this.setVisible(false);
                return;
            }
            this.enableDialogComponents(true);
            if (this.wizard == null) {
                this.btnGetJobs.setVisible(false);
                this.panelOpenJobs.setVisible(false);
                this.btnEditJob.setVisible(false);
            } else {
                this.panelButtons.setVisible(false);
            }
            this.loadJobsFromServer(ph);
        }
        catch (IOException | JDOMException ex) {
            Dialogs.getInstance().showErrorDialog("task.server.progress.connection-error", (Exception)ex);
        }
        if (this.wizard == null && this.lstDoneJobs.getModel().getSize() == 0) {
            this.setDontShow();
            this.app.getDialog().showInfoDialog("dialog.server.no-done-jobs");
        }
    }

    private void enableDialogComponents(boolean enabled) {
        this.btnGetJobs.setEnabled(enabled);
        this.lstCurrentJobs.setEnabled(enabled);
        this.lstDoneJobs.setEnabled(enabled);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void apply() {
    }

    public void showImportDialog() {
        this.panelOpenJobs.setVisible(false);
        this.btnLoadJob.setVisible(false);
        ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> {
            try {
                ph.progress("task.server.progress.connecting");
                ThemisCloudServer s = this.project.getThemisServer();
                if (s == null) {
                    return;
                }
                ph.progress("task.server.progress.load-jobs");
                this.addJobsToList((DefaultListModel)this.lstDoneJobs.getModel(), s.getDoneJobs(this.project.getProjectElement().getUUIDasString()), true);
            }
            catch (IOException ex) {
                Dialogs.getInstance().showErrorDialog("task.server.progress.loading-jobs-error", ex);
            }
        });
    }

    public void addJobsToList(DefaultListModel model, ArrayList<ThemisJob> jobs, boolean clear) {
        if (clear) {
            model.clear();
        }
        for (ThemisJob j : jobs) {
            model.addElement(j);
        }
    }

    public void loadJobsFromServer(ProgressHandler ph) throws IOException, JDOMException {
        ph.progress("task.server.progress.connecting");
        ThemisCloudServer s = this.project.getThemisServer();
        if (s == null || !s.isServerAvailable()) {
            if (this.wizard != null) {
                this.enableDialogComponents(false);
                this.wizard.invalidatePanel(this);
                this.app.getDialog().showErrorDialog("task.server.progress.connection-error");
            }
            return;
        }
        ph.progress("task.server.progress.read-config");
        String projectUuid = this.project.getProjectElement().getUUIDasString();
        this.info = s.readProjectInfo(projectUuid);
        ph.progress("task.server.progress.load-done-jobs");
        this.addJobsToList((DefaultListModel)this.lstDoneJobs.getModel(), s.getDoneJobs(projectUuid), true);
        if (this.wizard != null) {
            ph.progress("task.server.progress.load-open-jobs");
            this.addJobsToList((DefaultListModel)this.lstCurrentJobs.getModel(), s.getOpenJobs(projectUuid), true);
            ph.progress("task.server.progress.load-working-jobs");
            this.addJobsToList((DefaultListModel)this.lstCurrentJobs.getModel(), s.getWorkingJobs(projectUuid), false);
        }
    }

    private void showJob(ThemisJob job) {
        this.currentJob = job;
        this.fldTitle.setText(job == null ? "" : job.getTitle());
        this.fldResponsible.setText(job == null ? "" : job.getAccessCode());
        this.fldDuedate.setText(job == null ? "" : job.getDuedateAsString());
        this.fldStatus.setText(job == null ? "" : job.getStatusAsString());
        StringBuilder sb = new StringBuilder();
        if (job != null) {
            for (ThemisJob.JobHistory h : job.getHistories()) {
                sb.append(h.toString()).append("\n");
            }
        }
        this.fldHistory.setText(sb.toString());
        this.btnEditJob.setEnabled(job != null && (job.getStatus() == ThemisJob.Status.open || job.getStatus() == ThemisJob.Status.cancelled));
        this.btnLoadJob.setEnabled(job != null && job.getStatus().isDone());
        this.btnDeleteJob.setEnabled(job != null);
    }

    private void showMultipleJobs(int count) {
        this.showJob(null);
        this.fldTitle.setText(count + " Auftr\u00e4ge");
    }

    private void importDoneJobs() {
        List<ThemisJob> sels = this.lstDoneJobs.getSelectedValuesList();
        ArrayList eventIds = new ArrayList();
        if (this.app.getDialog().showConfirmDialog("Importiere " + sels.size() + " " + (sels.size() > 1 ? "Auftr\u00e4ge" : "Auftrag") + " vom Server?")) {
            ThemisTaskWithDialog.createTaskWithCounterAndCancel("task.server.progress.title", ph -> {
                try {
                    ThemisCloudServer s = this.project.getThemisServer();
                    if (s == null) {
                        return;
                    }
                    ArrayList ids = this.project.importDoneJobs(s, sels, ph);
                    eventIds.addAll(ids);
                    this.addJobsToList((DefaultListModel)this.lstDoneJobs.getModel(), s.getDoneJobs(this.project.getProjectElement().getUUIDasString()), true);
                    this.showJob(null);
                }
                catch (IOException ex) {
                    Dialogs.getInstance().showErrorDialog("task.server.progress.importing-error", ex);
                }
            });
        }
        this.app.getActionProvider().invokeAction(ThemisAction.EVENT_SAVED.from((Object)this, "after import of a job as *.themis"));
        this.app.getActionProvider().invokeAction(ThemisAction.PLAN_SAVED.from((Object)this, "after import of a job as *.themis"));
        this.app.getActionProvider().invokeAction(ThemisAction.EVENT_SET_AS_CURRENT.from((Object)this, "after import of a job as *.themis"));
        this.app.getActionProvider().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.from((Object)this, "after import of a job as *.themis"));
        if (this.wizard == null) {
            if (eventIds.size() == 1 && this.app.getDialog().showConfirmDialog("Soll die importierte Begehung als aktives Ereignis gesetzt werden?")) {
                this.project.getSelectionManager().setCurrentEvent(((Long)eventIds.get(0)).longValue(), true, (Object)this);
            }
            this.closeDialog();
        }
    }

    private void deleteJob() {
        String dlgText;
        if (this.currentJob == null) {
            return;
        }
        String string = dlgText = this.currentJob.getStatus() == ThemisJob.Status.open ? "dialog.server.deletejob-open" : "dialog.server.deletejob-notopen";
        if (this.app.getDialog().showConfirmDialog(dlgText)) {
            ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> {
                try {
                    ph.progress("task.server.progress.connecting");
                    ThemisCloudServer s = this.project.getThemisServer();
                    if (s == null) {
                        return;
                    }
                    ph.progress("task.server.progress.deleting-job");
                    s.deleteJob(this.project.getProjectElement().getUUIDasString(), this.currentJob);
                    ((DefaultListModel)this.lstCurrentJobs.getModel()).removeElement(this.currentJob);
                    ((DefaultListModel)this.lstDoneJobs.getModel()).removeElement(this.currentJob);
                    this.showJob(null);
                }
                catch (IOException ex) {
                    Dialogs.getInstance().showErrorDialog("task.server.progress.deleting-job-error", ex);
                }
            });
        }
    }

    private void initComponents() {
        this.btnGetJobs = new JButton();
        this.panelOpenJobs = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.lstCurrentJobs = new JList();
        this.panelDoneJobs = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstDoneJobs = new JList();
        this.panelJob = new JPanel();
        this.jLabel1 = new JLabel();
        this.fldTitle = new JTextField();
        this.jLabel2 = new JLabel();
        this.fldResponsible = new JTextField();
        this.jLabel3 = new JLabel();
        this.fldDuedate = new JTextField();
        this.jLabel4 = new JLabel();
        this.fldStatus = new JTextField();
        this.jScrollPane3 = new JScrollPane();
        this.fldHistory = new JTextArea();
        this.jPanel3 = new JPanel();
        this.btnLoadJob = new JButton();
        this.btnDeleteJob = new JButton();
        this.btnEditJob = new JButton();
        this.panelButtons = new JPanel();
        this.btnClose = new JButton();
        this.setLayout(new GridBagLayout());
        this.btnGetJobs.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnGetJobs, (String)NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.btnGetJobs.text"));
        this.btnGetJobs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerStatusPanel.this.btnGetJobsActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnGetJobs, gridBagConstraints);
        this.panelOpenJobs.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.panelOpenJobs.border.title"), 0, 0, THEMIS.fontSubheading));
        this.panelOpenJobs.setLayout(new GridBagLayout());
        this.jScrollPane2.setMinimumSize(new Dimension(100, 80));
        this.lstCurrentJobs.setFont(THEMIS.fontList);
        this.lstCurrentJobs.setModel(new DefaultListModel());
        this.lstCurrentJobs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ServerStatusPanel.this.lstCurrentJobsValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.lstCurrentJobs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOpenJobs.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelOpenJobs, gridBagConstraints);
        this.panelDoneJobs.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.panelDoneJobs.border.title"), 0, 0, THEMIS.fontSubheading));
        this.panelDoneJobs.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(100, 80));
        this.lstDoneJobs.setFont(THEMIS.fontList);
        this.lstDoneJobs.setModel(new DefaultListModel());
        this.lstDoneJobs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ServerStatusPanel.this.lstDoneJobsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstDoneJobs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDoneJobs.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelDoneJobs, gridBagConstraints);
        this.panelJob.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelJob.add((Component)this.jLabel1, gridBagConstraints);
        this.fldTitle.setFont(THEMIS.fontTextfield);
        this.fldTitle.setText(NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.fldTitle.text"));
        this.fldTitle.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelJob.add((Component)this.fldTitle, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelJob.add((Component)this.jLabel2, gridBagConstraints);
        this.fldResponsible.setFont(THEMIS.fontTextfield);
        this.fldResponsible.setText(NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.fldResponsible.text"));
        this.fldResponsible.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelJob.add((Component)this.fldResponsible, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelJob.add((Component)this.jLabel3, gridBagConstraints);
        this.fldDuedate.setFont(THEMIS.fontTextfield);
        this.fldDuedate.setText(NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.fldDuedate.text"));
        this.fldDuedate.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelJob.add((Component)this.fldDuedate, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelJob.add((Component)this.jLabel4, gridBagConstraints);
        this.fldStatus.setFont(THEMIS.fontTextfield);
        this.fldStatus.setText(NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.fldStatus.text"));
        this.fldStatus.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelJob.add((Component)this.fldStatus, gridBagConstraints);
        this.jScrollPane3.setEnabled(false);
        this.jScrollPane3.setMinimumSize(new Dimension(180, 100));
        this.jScrollPane3.setPreferredSize(new Dimension(180, 100));
        this.fldHistory.setColumns(20);
        this.fldHistory.setFont(new Font("Monospaced", 0, 12));
        this.fldHistory.setRows(5);
        this.fldHistory.setEnabled(false);
        this.jScrollPane3.setViewportView(this.fldHistory);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelJob.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.btnLoadJob.setFont(THEMIS.fontButton);
        this.btnLoadJob.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLoadJob, (String)NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.btnLoadJob.text"));
        this.btnLoadJob.setEnabled(false);
        this.btnLoadJob.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerStatusPanel.this.btnLoadJobActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.btnLoadJob, gridBagConstraints);
        this.btnDeleteJob.setFont(THEMIS.fontButton);
        this.btnDeleteJob.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteJob, (String)NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.btnDeleteJob.text"));
        this.btnDeleteJob.setEnabled(false);
        this.btnDeleteJob.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerStatusPanel.this.btnDeleteJobActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.btnDeleteJob, gridBagConstraints);
        this.btnEditJob.setFont(THEMIS.fontButton);
        this.btnEditJob.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit-24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEditJob, (String)NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.btnEditJob.text"));
        this.btnEditJob.setEnabled(false);
        this.btnEditJob.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerStatusPanel.this.btnEditJobActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.btnEditJob, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        this.panelJob.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.panelJob, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(ServerStatusPanel.class, (String)"ServerStatusPanel.btnClose.text"));
        this.btnClose.setMargin(new Insets(10, 20, 10, 20));
        this.btnClose.setMinimumSize(new Dimension(100, 35));
        this.btnClose.setPreferredSize(null);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerStatusPanel.this.btnCloseActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.btnClose);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void btnGetJobsActionPerformed(ActionEvent evt) {
        ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> {
            try {
                this.loadJobsFromServer(ph);
            }
            catch (IOException | JDOMException ex) {
                Dialogs.getInstance().showErrorDialog("task.server.progress.loading-jobs-error", (Exception)ex);
            }
        });
    }

    private void lstCurrentJobsValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            ThemisJob sel = this.lstCurrentJobs.getSelectedValue();
            if (sel != null) {
                this.lstDoneJobs.getSelectionModel().clearSelection();
                int count = this.lstDoneJobs.getSelectedValuesList().size();
                if (count > 1) {
                    this.showMultipleJobs(count);
                } else {
                    this.showJob(sel);
                }
            } else {
                this.showJob(null);
            }
        }
    }

    private void lstDoneJobsValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            ThemisJob sel = this.lstDoneJobs.getSelectedValue();
            if (sel != null) {
                this.btnLoadJob.setEnabled(true);
                this.lstCurrentJobs.getSelectionModel().clearSelection();
                int count = this.lstCurrentJobs.getSelectedValuesList().size();
                if (count > 1) {
                    this.showMultipleJobs(count);
                } else {
                    this.showJob(sel);
                }
            } else {
                this.btnLoadJob.setEnabled(false);
                this.btnDeleteJob.setEnabled(false);
                this.btnEditJob.setEnabled(false);
            }
        }
    }

    private void btnLoadJobActionPerformed(ActionEvent evt) {
        this.importDoneJobs();
    }

    private void btnDeleteJobActionPerformed(ActionEvent evt) {
        this.deleteJob();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void btnEditJobActionPerformed(ActionEvent evt) {
        if (this.currentJob == null) {
            return;
        }
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("editjob", 500, 300).setParentFrame(THEMIS.getMainWindow());
        EditJobFxPanel fx = new EditJobFxPanel(this.currentJob, this.info);
        fx.setCloseAction(() -> {
            dlg.close();
            return false;
        });
        dlg.setContent((Node)fx);
        dlg.show();
        ThemisJob newJob = fx.getJob();
        ThemisTaskWithDialog.createTask("task.server.progress.title", ph -> {
            try {
                ph.progress("task.server.progress.connecting");
                ThemisCloudServer s = this.project.getThemisServer();
                if (s == null) {
                    return;
                }
                ph.progress("task.server.progress.updating-job");
                s.updateJobInfo(this.project, newJob);
                this.currentJob.updateJob(newJob);
                this.lstCurrentJobs.repaint();
                this.lstDoneJobs.repaint();
                this.showJob(this.currentJob);
            }
            catch (IOException ex) {
                Dialogs.getInstance().showErrorDialog("task.server.progress.updating-job-error", ex);
            }
        });
    }

    @Override
    public String getDialogCode() {
        return "serverstatus";
    }

    @Override
    public Dimension getPanelSize() {
        return new Dimension(650, 420);
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(650, 400);
    }
}

