/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.server.action;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ribbon.ToggleRibbonAction;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.ThemisTaskResult;
import at.grid.themis.ontology.javafx.jobmanager.CreateJobFxPanel;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.server.ThemisCloudProjectInfo;
import at.grid.themis.ontology.server.ThemisCloudServer;
import at.grid.themis.ontology.server.ThemisJob;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javafx.scene.Node;
import org.jdom.JDOMException;

public final class CreateJobAction
extends ToggleRibbonAction {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();

    public CreateJobAction() {
        super(ResourceBundle.getBundle("at/grid/themis/application/server/action/Bundle"), "CTL_CreateJob", "at/grid/themis/application/media/werkzeug.gif", "TOP");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        if (this.project == null || !this.project.isOpen()) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
            return;
        }
        if (!this.project.hasThemisServer()) {
            Dialogs.getInstance().showWarningDialog("error.no-server-defined");
            return;
        }
        if (this.project.isThemisFileDirectAccess()) {
            Dialogs.getInstance().showWarningDialog("Sie bearbeiten eine *.themis Datei. Die Server-Funktionen sind nicht verf\u00fcgbar.");
            return;
        }
        ThemisCloudServer server = this.project.getThemisServer();
        if (server == null) {
            return;
        }
        ThemisTaskResult result = new ThemisTaskResult();
        ThemisTaskWithDialog.createTaskWithCancel("task.server.progress.title", ph -> {
            try {
                ph.progress("task.server.progress.connecting");
                ThemisCloudProjectInfo info = server.readProjectInfo(this.project.getProjectElement().getUUIDasString());
                result.setObject((Object)new CreateJobFxPanel(info));
                result.setOk(true);
            }
            catch (IOException | IllegalArgumentException | JDOMException ex) {
                Dialogs.getInstance().showErrorDialog("task.server.progress.connection-error", (Exception)ex);
            }
        });
        CreateJobFxPanel fx = (CreateJobFxPanel)result.getObject();
        if (fx == null) {
            return;
        }
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("createjob", 500, 320).setParentFrame(THEMIS.getMainWindow());
        fx.setCloseAction(() -> {
            dlg.close();
            return false;
        });
        dlg.setContent((Node)fx);
        dlg.show();
        ThemisJob job = fx.getJob();
        if (job != null) {
            ThemisTaskWithDialog.createTaskWithCancel("task.server.progress.title", ph -> {
                try {
                    ph.progress("task.server.progress.uploading-job");
                    server.uploadJob(this.project, job);
                }
                catch (IOException | IllegalArgumentException | JDOMException ex) {
                    Dialogs.getInstance().showErrorDialog("task.server.progress.uploading-job-error", (Exception)ex);
                }
            });
        }
    }
}

