/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.server.action;

import at.grid.themis.application.action.ribbon.ToggleRibbonAction;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.server.ThemisCloudServer;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import org.jdom.JDOMException;

public final class ExportToServerAction
extends ToggleRibbonAction {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();

    public ExportToServerAction() {
        super(ResourceBundle.getBundle("at/grid/themis/application/server/action/Bundle"), "CTL_ExportToServerAction", "at/grid/themis/application/media/cloudUpload.gif", "TOP");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        if (this.project == null || !this.project.isOpen()) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
            return;
        }
        if (!this.project.hasThemisServer()) {
            Dialogs.getInstance().showWarningDialog("error.no-server-defined");
            return;
        }
        if (this.project.isThemisFileDirectAccess()) {
            Dialogs.getInstance().showWarningDialog("Sie bearbeiten eine *.themis Datei. Die Server-Funktionen sind nicht verf\u00fcgbar.");
            return;
        }
        ThemisTaskWithDialog.createTaskWithCounterAndCancel("task.server.progress.title", ph -> {
            try {
                ph.switchToDeterminate(7);
                ph.progress("task.server.progress.connecting", 1);
                ThemisCloudServer server = this.project.getThemisServer();
                if (server == null) {
                    return;
                }
                if (ph.isCancelled()) {
                    return;
                }
                if (server.isServerAvailable()) {
                    ph.progress("task.server.progress.uploading-project");
                    server.uploadProject(this.project, ph);
                } else {
                    Dialogs.getInstance().showErrorDialog("task.server.progress.connection-error");
                }
            }
            catch (IOException | JDOMException ex) {
                Dialogs.getInstance().showErrorDialog("task.server.progress.uploading-project-error", (Exception)ex);
            }
        });
    }
}

