/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.server.action;

import at.grid.themis.application.action.ribbon.ToggleRibbonAction;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.server.ServerStatusPanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;

public final class ImportEventsFromServerAction
extends ToggleRibbonAction {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();

    public ImportEventsFromServerAction() {
        super(ResourceBundle.getBundle("at/grid/themis/application/server/action/Bundle"), "CTL_ImportEventsFromServerAction", "at/grid/themis/application/media/cloudDownload.gif", "TOP");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        if (this.project == null || !this.project.isOpen()) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
            return;
        }
        if (!this.project.hasThemisServer()) {
            Dialogs.getInstance().showWarningDialog("error.no-server-defined");
            return;
        }
        if (this.project.isThemisFileDirectAccess()) {
            Dialogs.getInstance().showWarningDialog("Sie bearbeiten eine *.themis Datei. Die Server-Funktionen sind nicht verf\u00fcgbar.");
            return;
        }
        new ServerStatusPanel().showDialog();
    }
}

