/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.simpleeditor;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.license.ThemisLicensePanel;
import at.grid.themis.application.project.ProjectListPanel;
import at.grid.themis.application.tutorial.Assistant;
import at.grid.themis.application.tutorial.AssistantType;
import at.grid.themis.application.ui.ThemisFolderTreeRenderer;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public final class ProjectManagerPanel
extends JPanel
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    DemoPackManager demo = DemoPackManager.getInstance();
    private ListSource listSource;
    private String currentList;
    private final String LIST_LASTUSED = "Zuletzt verwendet";
    private final String LIST_LOCAL = "Lokal zwischengespeichert";
    private ThemisFolder selectedFolder;
    private String selectedList;
    private List<File> lastProjects = new ArrayList<File>();
    ProjectListPanel projectListManager;
    DragScrollHandler projectListDragHandler;
    File rootFolder = null;
    ImageIcon iconFolder = new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/folder.gif"));
    ImageIcon iconThemis = new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/themis.gif"));
    DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
    DefaultMutableTreeNode treeFolderRoot = new DefaultMutableTreeNode();
    DefaultMutableTreeNode treeListRoot = new DefaultMutableTreeNode();
    DefaultMutableTreeNode listLastUsed = new DefaultMutableTreeNode();
    DefaultMutableTreeNode listLocallySaved = new DefaultMutableTreeNode();
    DefaultTreeModel treemodel = new DefaultTreeModel(this.treeRoot);
    ThemisTreeState treestate = new ThemisTreeState();
    private JButton btnAdd;
    private JButton btnCreateProject;
    private JButton btnEdit;
    private JButton btnNoLicense;
    private JButton btnOpenFirstSteps;
    private JButton btnRemove;
    private JButton btnSelectAction;
    private JButton btnSelectRootFolder;
    private JButton btnStartLicenseAssistant;
    private JCheckBox chkIncludSubfolder;
    private JCheckBox chkSelectAll;
    private JButton jButton1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel lblCountSelect;
    private JLabel lblListContent;
    private JLabel lblLogo;
    private JPanel panelBottom;
    private JPanel panelExplorer;
    private JPanel panelHead;
    private JPanel panelProjectList;
    private JScrollPane scrollPane;
    private JSplitPane splitMain;
    private JTree tree;
    private JScrollPane treepane;
    private String DIALOG_CODE = "editorprojectmanager";
    public static final int DIALOG_WIDTH = 420;
    public static final int DIALOG_HEIGHT = 335;
    public static final int DIALOG_WIDTH_MIN = 350;
    public static final int DIALOG_HEIGHT_MIN = 335;

    public ProjectManagerPanel() {
        boolean flgLicense;
        this.initComponents();
        this.projectListDragHandler = new DragScrollHandler(this.panelProjectList);
        this.projectListManager = new ProjectListPanel(this.panelProjectList, this.projectListDragHandler);
        this.populateProjectListFromRecent();
        THEMIS.setCheckboxIcon(this.chkSelectAll);
        THEMIS.setCheckboxIcon(this.chkIncludSubfolder);
        Font treeFont = THEMIS.fontListBig;
        this.tree.setCellRenderer(new ThemisFolderTreeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setFont(treeFont);
        this.tree.setRowHeight(treeFont.getSize() * 2);
        this.tree.setRootVisible(false);
        this.treeRoot.add(this.treeFolderRoot);
        this.treeRoot.add(this.treeListRoot);
        this.rootFolder = this.app.getSettings().getFolderProjectRoot().getValue(true);
        if (this.rootFolder == null || !this.rootFolder.isDirectory()) {
            this.rootFolder = FileSystemView.getFileSystemView().getDefaultDirectory();
        }
        this.setThemisRootFolder(this.rootFolder);
        this.populateTreeCollection(null);
        this.setButtonsEnabled(null);
        this.splitMain.setDividerLocation(300);
        if (this.demo.isNewVersionAvailable()) {
            if (this.app.getDialog().showConfirmDialog("Es stehen neue Vorlagen zum Download zur Verf\u00fcgung. Sollen diese heruntergeladen werden?")) {
                ThemisTaskWithDialog.createTaskWithCounterAndCancel("Vorlagen werden heruntergeladen", ph -> this.demo.downloadTemplates(ph));
            } else {
                this.demo.setIgnoreNewVersion();
            }
        }
        this.btnNoLicense.setVisible(!(flgLicense = this.app.getLicense().hasLicense()));
        this.btnCreateProject.setVisible(flgLicense);
        this.populateProjectList();
        ThemisActionProvider.getInstance().register(this);
        this.revalidate();
    }

    public void onAction(ThemisAction action) {
        if (action.getSource() == this) {
            return;
        }
        switch (action.getAction()) {
            case 1101: {
                ViewHelper.showStartScreen();
            }
        }
    }

    private void storeTreeState() {
        this.treestate.clear();
        int rowCount = this.tree.getRowCount();
        for (int ii = 0; ii < rowCount - 1; ++ii) {
            Object u;
            Object o;
            TreePath nextPath;
            TreePath currPath = this.tree.getPathForRow(ii);
            if (!currPath.isDescendant(nextPath = this.tree.getPathForRow(ii + 1)) || !((o = currPath.getLastPathComponent()) instanceof DefaultMutableTreeNode) || !((u = ((DefaultMutableTreeNode)o).getUserObject()) instanceof ThemisFolder)) continue;
            this.treestate.add((ThemisFolder)u);
        }
    }

    private void restoreTreeState() {
        this.tree.expandPath(new TreePath(this.treeFolderRoot.getPath()));
        this.tree.expandPath(new TreePath(this.treeListRoot.getPath()));
        int rowCount = this.tree.getRowCount();
        for (int ii = 0; ii < rowCount; ++ii) {
            Object u;
            TreePath path = this.tree.getPathForRow(ii);
            Object o = path.getLastPathComponent();
            if (!(o instanceof DefaultMutableTreeNode) || !this.treestate.contains(u = ((DefaultMutableTreeNode)o).getUserObject())) continue;
            this.tree.expandPath(path);
            rowCount = this.tree.getRowCount();
        }
    }

    private void populateProjectList() {
        if (this.listSource == null) {
            this.listSource = ListSource.RECENT;
        }
        switch (this.listSource) {
            case FOLDER: {
                this.populateProjectListFromFolder(this.selectedFolder);
                this.chkIncludSubfolder.setVisible(true);
                break;
            }
            case LIST: {
                this.populateProjectListFromCollection(this.selectedList);
                this.chkIncludSubfolder.setVisible(false);
                break;
            }
            default: {
                this.populateProjectListFromRecent();
                this.chkIncludSubfolder.setVisible(false);
            }
        }
    }

    private void populateProjectListFromRecent() {
        this.listSource = ListSource.RECENT;
        this.chkIncludSubfolder.setVisible(false);
        this.populateProjectList("Zuletzt verwendet", this.app.getRecentProjectList());
    }

    private void populateProjectListFromFolder(ThemisFolder sel) {
        this.listSource = ListSource.FOLDER;
        this.selectedFolder = sel;
        if (sel == null) {
            this.populateProjectList("Kein Ordner ausgew\u00e4hlt", new ArrayList<File>());
            return;
        }
        this.chkIncludSubfolder.setVisible(true);
        boolean includSub = this.chkIncludSubfolder.isSelected();
        ArrayList files = ThemisApplication.getInstance().getProject().getProjects(sel.getProjectFolder(), includSub);
        String fld = sel.getProjectFolder().getAbsolutePath();
        if (fld.length() > 100) {
            fld = fld.substring(0, 15) + "<...>" + fld.substring(fld.length() - 85);
        }
        String description = "Projekte im Ordner '" + fld + "'";
        this.populateProjectList(description, files);
    }

    private void populateProjectListFromCollection(String sel) {
        if (sel == null) {
            return;
        }
        this.listSource = ListSource.LIST;
        this.currentList = sel;
        this.chkIncludSubfolder.setVisible(false);
        ArrayList<File> projects = new ArrayList<File>();
        String description = "";
        switch (sel) {
            case "Zuletzt verwendet": {
                projects.addAll(this.app.getRecentProjectList());
                description = "Zuletzt ge\u00f6ffnete Projekte";
                break;
            }
            case "Lokal zwischengespeichert": {
                description = "Lokal zwischengespeicherte Projekte";
                for (ThemisFolder themis : this.app.getProject().checkLocalProjects()) {
                    if (!themis.isProject() || themis.getProjectFolder().equals(this.app.getProject().getProjectFolder())) continue;
                    projects.add(themis.getProjectFolder());
                }
                break;
            }
            default: {
                description = "Projektliste '" + sel + "'";
                for (ThemisFolder themis : this.app.getSettings().getProjectsForList(sel)) {
                    if (!themis.isProject()) continue;
                    projects.add(themis.getProjectFolder());
                }
            }
        }
        this.populateProjectList(description, projects);
    }

    private void populateProjectList(String description, List<File> projectFolders) {
        this.lblListContent.setText(description);
        this.projectListManager.clear();
        int counter = 0;
        for (File f : projectFolders) {
            ThemisFolder tf = new ThemisFolder(f);
            if (!tf.isProject()) continue;
            this.projectListManager.addProject(tf);
            ++counter;
        }
        this.projectListManager.populateList();
        this.chkSelectAll.setText("Alle ausw\u00e4hlen [" + counter + "]");
        this.chkSelectAll.setVisible(!projectFolders.isEmpty());
        this.scrollPane.add(this.projectListManager);
    }

    private void updateProjectSelection() {
        ArrayList<ThemisFolder> selection = this.projectListManager.getSelection();
        this.lblCountSelect.setText(Integer.toString(selection.size()));
        this.btnSelectAction.setEnabled(selection.size() > 0);
    }

    private void setThemisRootFolder(File f) {
        if (f != null && f.isDirectory()) {
            this.rootFolder = f;
            this.app.getSettings().getFolderProjectRoot().setValue(f);
        }
        this.populateTreeFolder(f, null);
    }

    private void populateTreeFolder(File f, ThemisFolder openTree) {
        this.storeTreeState();
        if (openTree != null) {
            this.treestate.add(openTree);
        }
        this.treeFolderRoot.removeAllChildren();
        if (f != null) {
            ThemisFolder rootfolder = new ThemisFolder(f);
            this.treeFolderRoot.setUserObject(new TreeRootObject(rootfolder));
            this.getFolderContent(f, this.treeFolderRoot, 0);
        }
        this.treemodel.reload();
        this.restoreTreeState();
    }

    private void populateTreeCollection(String selection) {
        this.storeTreeState();
        this.treeListRoot.removeAllChildren();
        this.treeListRoot.setUserObject("Projektlisten");
        this.listLastUsed.setUserObject("Zuletzt verwendet");
        this.treeListRoot.add(this.listLastUsed);
        this.listLocallySaved.setUserObject("Lokal zwischengespeichert");
        this.treeListRoot.add(this.listLocallySaved);
        for (String projectlist : this.app.getSettings().getProjectLists()) {
            DefaultMutableTreeNode n = new DefaultMutableTreeNode();
            n.setUserObject(projectlist);
            this.treeListRoot.add(n);
        }
        this.treemodel.reload();
        this.restoreTreeState();
    }

    private void expandTree(TreePath path) {
        if (path != null) {
            Object sel;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node != null && (sel = node.getUserObject()) != null && sel instanceof ThemisFolder) {
                ThemisFolder f = (ThemisFolder)sel;
                this.getFolderContent(f.getProjectFolder(), node, 0);
            }
            this.treemodel.reload(node);
        }
    }

    private void getFolderContent(File f, DefaultMutableTreeNode node, int level) {
        node.removeAllChildren();
        Object[] files = f.listFiles(pathname -> pathname.isDirectory() && !ThemisProject.isProjectFolder((File)pathname));
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                ThemisFolder themisfolder;
                DefaultMutableTreeNode nextnode = new DefaultMutableTreeNode(themisfolder, !(themisfolder = new ThemisFolder((File)file)).isProject());
                if (level < 1) {
                    this.getFolderContent((File)file, nextnode, level + 1);
                }
                node.add(nextnode);
            }
        }
    }

    public DefaultMutableTreeNode getSelectedNode() {
        DefaultMutableTreeNode node = null;
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            node = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        return node;
    }

    public void addNode(DefaultMutableTreeNode basenode, ThemisFolder newContent) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(newContent, !newContent.isProject());
        if (basenode != null) {
            basenode.add(node);
            this.treemodel.reload();
            this.tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    private void createProject(ThemisFolder folder) {
    }

    private void createFolder(ThemisFolder themis) {
        try {
            String fn = "";
            File f = null;
            fn = this.app.getDialog().showInputDialog("Ordnername", "Neuen Ordner anlegen");
            if (fn == null) {
                return;
            }
            if (themis == null) {
                f = new File(this.rootFolder, fn);
            } else if (!themis.isProject() && themis != null) {
                f = new File(themis.getProjectFolder(), fn);
            } else {
                this.app.getDialog().showErrorDialog("Den Ordner kann nicht erstellt werden.");
                return;
            }
            f.mkdirs();
            this.populateTreeFolder(this.rootFolder, themis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void chooseNewRootFolder() {
        this.chooseNewRootFolder(null);
    }

    private void chooseNewRootFolder(File f) {
        File rootFolder = this.app.getSettings().getFolderProjectRoot().getValue(true);
        if (rootFolder == null) {
            rootFolder = this.app.getSettings().getFolderOpenProject().getValue(true);
        }
        if (f == null) {
            f = new ThemisFileDialog("Stammordner w\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, rootFolder, null, null, null, false).getSelectedFile();
        }
        if (f != null) {
            if (ThemisProject.isProjectFolder((File)f)) {
                f = f.getParentFile();
            }
            this.setThemisRootFolder(f);
        }
    }

    private void renameFolder(ThemisFolder f) {
        String result = this.app.getDialog().showInputDialogFilled("Geben Sie einen neuen namen f\u00fcr den Ordner ein:", "Ordner umbenennen", f.getFolderName());
        if (result != null) {
            File fld = f.getProjectFolder();
            fld.renameTo(new File(fld.getParentFile(), result));
            this.populateTreeFolder(this.rootFolder, null);
        }
    }

    private void showInExplorer(File f) {
        if (f == null || !f.isDirectory()) {
            return;
        }
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deleteFolder(ThemisFolder fld) {
        if (!fld.isEmpty()) {
            this.app.getDialog().showErrorDialog("Der Ornder ist nicht leer und kann nicht gel\u00f6scht werden!");
            return;
        }
        if (this.app.getDialog().showConfirmDialog("Soll der Ordner '" + fld.getFolderName() + "' wirklich gel\u00f6scht werden", "Ordner l\u00f6schen")) {
            fld.getProjectFolder().delete();
            this.populateTreeFolder(this.rootFolder, null);
            this.setButtonsEnabled(null);
        }
    }

    private void createNewProjectCollection() {
        String title = JOptionPane.showInputDialog(THEMIS.getMainWindow(), this.app.getProject().getResourceText("dialog.create-list.msg"), this.app.getProject().getResourceText("dialog.create-list.title"), 1);
        if (title != null && !"".equals(title) && !"-".equals(title)) {
            if (this.app.getSettings().hasProjectList(title)) {
                this.app.getDialog().showInfoDialog("projectlist.already-existing");
            } else {
                this.app.getSettings().addProjectList(title);
                this.populateTreeCollection(title);
            }
        }
    }

    private void deleteProjectCollection(String title) {
        switch (title) {
            case "Zuletzt verwendet": 
            case "Lokal zwischengespeichert": {
                break;
            }
            default: {
                if (!this.app.getDialog().showConfirmDialog("Soll die Projektliste '" + title + "' wirklich gel\u00f6scht werden", "Projektliste l\u00f6schen")) break;
                this.app.getSettings().removeProjectList(title);
                this.populateTreeCollection(null);
                this.setButtonsEnabled(null);
                if (this.listSource != ListSource.LIST || !this.currentList.equals(title)) break;
                this.populateProjectListFromRecent();
            }
        }
    }

    private void renameProjectCollection(String title) {
        String result = this.app.getDialog().showInputDialogFilled("Geben Sie einen neuen Namen f\u00fcr die Liste ein:", "Projektliste umbenennen", title);
        if (result != null) {
            this.app.getSettings().renameProjectList(title, result);
            this.populateTreeCollection(result);
        }
    }

    private void loadProjectCollection() {
        File f = new ThemisFileDialog("Projektliste laden", ThemisFileDialog.DIALOGTYPE.OPEN, null, null, THEMIS.getProjectListFileFilter(), "projectlist", false).getSelectedFile();
        if (f != null) {
            try {
                ArrayList<ThemisFolder> projects = new ArrayList<ThemisFolder>();
                BufferedReader br = new BufferedReader(new FileReader(f));
                String ln = br.readLine();
                while (ln != null) {
                    File projectfolder = new File(ln);
                    if (ThemisProject.isProjectFolder((File)projectfolder)) {
                        projects.add(new ThemisFolder(projectfolder));
                    }
                    ln = br.readLine();
                }
                br.close();
                if (projects.isEmpty()) {
                    this.app.getDialog().showInfoDialog("Keine Projekte in der ausgew\u00e4hlten Datei");
                    return;
                }
                String result = this.app.getDialog().showInputDialogFilled("Geben Sie einen Namen f\u00fcr die Liste ein (" + projects.size() + " Projekte):", "Projektliste laden", Util.getFileNameWithoutExtension((File)f));
                if (result != null) {
                    for (ThemisFolder tf : projects) {
                        this.app.getSettings().addProjectToList(result, tf);
                    }
                    this.populateTreeCollection(result);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void saveProjectCollection(String title) {
        ArrayList projects = this.app.getSettings().getProjectsForList(title);
        if (projects == null || projects.isEmpty()) {
            this.app.getDialog().showInfoDialog("Keine Projekte in der ausgew\u00e4hlten Liste");
            return;
        }
        File f = new ThemisFileDialog("Projektliste speichern", ThemisFileDialog.DIALOGTYPE.SAVE, null, null, THEMIS.getProjectListFileFilter(), "projectlist", false).getSelectedFile();
        if (f != null) {
            try {
                FileWriter fw = new FileWriter(f);
                for (ThemisFolder tf : projects) {
                    fw.write(tf.getProjectFolder().getAbsolutePath());
                    fw.write("\n");
                }
                fw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.btnOpenFirstSteps = new JButton();
        this.btnStartLicenseAssistant = new JButton();
        this.splitMain = new JSplitPane();
        this.panelExplorer = new JPanel();
        this.jPanel2 = new JPanel();
        this.btnSelectRootFolder = new JButton();
        this.jButton1 = new JButton();
        this.treepane = new JScrollPane();
        this.tree = new JTree();
        this.jPanel4 = new JPanel();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.btnAdd = new JButton();
        this.jPanel1 = new JPanel();
        this.panelHead = new JPanel();
        this.chkIncludSubfolder = new JCheckBox();
        this.lblLogo = new JLabel();
        this.jPanel3 = new JPanel();
        this.chkSelectAll = new JCheckBox();
        this.lblListContent = new JLabel();
        this.scrollPane = new JScrollPane();
        this.panelProjectList = new JPanel();
        this.panelBottom = new JPanel();
        this.btnNoLicense = new JButton();
        this.btnCreateProject = new JButton();
        this.jLabel1 = new JLabel();
        this.lblCountSelect = new JLabel();
        this.btnSelectAction = new JButton();
        this.btnOpenFirstSteps.setFont(THEMIS.fontLabelBig);
        this.btnOpenFirstSteps.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_openPDF32.gif")));
        this.btnOpenFirstSteps.setText("Schnelldurchgang \u00f6ffnen");
        this.btnOpenFirstSteps.setBorder(new SoftBevelBorder(0));
        this.btnOpenFirstSteps.setPreferredSize(new Dimension(200, 40));
        this.btnOpenFirstSteps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.btnOpenFirstStepsActionPerformed(evt);
            }
        });
        this.btnStartLicenseAssistant.setFont(THEMIS.fontLabelBig);
        this.btnStartLicenseAssistant.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/key32.gif")));
        this.btnStartLicenseAssistant.setText("Lizenz aktivieren");
        this.btnStartLicenseAssistant.setBorder(new SoftBevelBorder(0));
        this.btnStartLicenseAssistant.setMaximumSize(new Dimension(166, 38));
        this.btnStartLicenseAssistant.setMinimumSize(new Dimension(200, 40));
        this.btnStartLicenseAssistant.setPreferredSize(new Dimension(200, 40));
        this.btnStartLicenseAssistant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.btnStartLicenseAssistantActionPerformed(evt);
            }
        });
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.panelExplorer.setBackground(new Color(255, 255, 255));
        this.panelExplorer.setLayout(new GridBagLayout());
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnSelectRootFolder.setFont(THEMIS.fontButton);
        this.btnSelectRootFolder.setText("Stammordner w\u00e4hlen");
        this.btnSelectRootFolder.setBorder(new SoftBevelBorder(0));
        this.btnSelectRootFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.btnSelectRootFolderActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnSelectRootFolder, gridBagConstraints);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/refresh24.gif")));
        this.jButton1.setToolTipText("Explorer aktualisieren");
        this.jButton1.setMinimumSize(new Dimension(60, 35));
        this.jButton1.setPreferredSize(new Dimension(60, 35));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panelExplorer.add((Component)this.jPanel2, gridBagConstraints);
        this.tree.setFont(THEMIS.fontListBig);
        this.tree.setModel(this.treemodel);
        this.tree.setRowHeight(22);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
                ProjectManagerPanel.this.treeTreeCollapsed(evt);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
                ProjectManagerPanel.this.treeTreeExpanded(evt);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProjectManagerPanel.this.treeMouseClicked(evt);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                ProjectManagerPanel.this.treeValueChanged(evt);
            }
        });
        this.treepane.setViewportView(this.tree);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelExplorer.add((Component)this.treepane, gridBagConstraints);
        this.jPanel4.setBackground(new Color(255, 255, 255));
        this.jPanel4.setLayout(new GridBagLayout());
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        this.btnEdit.setToolTipText("Kontakt bearbeiten");
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.setMaximumSize(null);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnEdit, gridBagConstraints);
        this.btnRemove.setFont(THEMIS.fontButton);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        this.btnRemove.setToolTipText("Kontakt l\u00f6schen");
        this.btnRemove.setBorder(new SoftBevelBorder(0));
        this.btnRemove.setMaximumSize(null);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnRemove, gridBagConstraints);
        this.btnAdd.setFont(THEMIS.fontButton);
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        this.btnAdd.setToolTipText("Neuen Kontakt erstellen");
        this.btnAdd.setBorder(new SoftBevelBorder(0));
        this.btnAdd.setMaximumSize(null);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnAdd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.panelExplorer.add((Component)this.jPanel4, gridBagConstraints);
        this.splitMain.setTopComponent(this.panelExplorer);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setLayout(new GridBagLayout());
        this.panelHead.setBackground(new Color(255, 255, 255));
        this.panelHead.setLayout(new GridBagLayout());
        this.chkIncludSubfolder.setBackground(new Color(255, 255, 255));
        this.chkIncludSubfolder.setFont(THEMIS.fontLabel);
        this.chkIncludSubfolder.setText("mit Unterordner");
        this.chkIncludSubfolder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProjectManagerPanel.this.chkIncludSubfolderItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 17, 0, 0);
        this.panelHead.add((Component)this.chkIncludSubfolder, gridBagConstraints);
        this.lblLogo.setHorizontalAlignment(0);
        this.lblLogo.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/logo_THEMIS_300_rgb.jpg")));
        this.lblLogo.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelHead.add((Component)this.lblLogo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.panelHead, gridBagConstraints);
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setLayout(new GridBagLayout());
        this.chkSelectAll.setBackground(new Color(255, 255, 255));
        this.chkSelectAll.setFont(THEMIS.fontLabel);
        this.chkSelectAll.setText("Alle ausw\u00e4hlen");
        this.chkSelectAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProjectManagerPanel.this.chkSelectAllItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.insets = new Insets(0, 17, 0, 0);
        this.jPanel3.add((Component)this.chkSelectAll, gridBagConstraints);
        this.lblListContent.setFont(THEMIS.fontSubheading);
        this.lblListContent.setText("<Inhalt>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.lblListContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.scrollPane.setBackground(new Color(255, 255, 255));
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setOpaque(false);
        this.panelProjectList.setBackground(new Color(255, 255, 255));
        this.panelProjectList.setAutoscrolls(true);
        this.panelProjectList.setFocusable(false);
        this.panelProjectList.setMinimumSize(null);
        this.panelProjectList.setPreferredSize(null);
        this.scrollPane.setViewportView(this.panelProjectList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.scrollPane, gridBagConstraints);
        this.panelBottom.setBackground(new Color(255, 255, 255));
        this.panelBottom.setLayout(new GridBagLayout());
        this.btnNoLicense.setFont(THEMIS.fontLabelBig);
        this.btnNoLicense.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/key24.gif")));
        this.btnNoLicense.setText("Keine Lizenz - Lizenzmanager");
        this.btnNoLicense.setBorder(new SoftBevelBorder(0));
        this.btnNoLicense.setIconTextGap(10);
        this.btnNoLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.btnNoLicenseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelBottom.add((Component)this.btnNoLicense, gridBagConstraints);
        this.btnCreateProject.setFont(THEMIS.fontLabelBig);
        this.btnCreateProject.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_showProjectInfo32.gif")));
        this.btnCreateProject.setText("Neues Projekt");
        this.btnCreateProject.setBorder(new SoftBevelBorder(0));
        this.btnCreateProject.setIconTextGap(10);
        this.btnCreateProject.setMinimumSize(null);
        this.btnCreateProject.setPreferredSize(null);
        this.btnCreateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.btnCreateProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelBottom.add((Component)this.btnCreateProject, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabel);
        this.jLabel1.setText("Auswahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.panelBottom.add((Component)this.jLabel1, gridBagConstraints);
        this.lblCountSelect.setFont(THEMIS.fontLabelBigBold);
        this.lblCountSelect.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.panelBottom.add((Component)this.lblCountSelect, gridBagConstraints);
        this.btnSelectAction.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        this.btnSelectAction.setText("Funktion ausw\u00e4hlen");
        this.btnSelectAction.setEnabled(false);
        this.btnSelectAction.setHorizontalTextPosition(10);
        this.btnSelectAction.setMinimumSize(new Dimension(200, 40));
        this.btnSelectAction.setPreferredSize(new Dimension(200, 40));
        this.btnSelectAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.btnSelectActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelBottom.add((Component)this.btnSelectAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.panelBottom, gridBagConstraints);
        this.splitMain.setRightComponent(this.jPanel1);
        this.add((Component)this.splitMain, "Center");
    }

    private void btnOpenFirstStepsActionPerformed(ActionEvent evt) {
    }

    private void btnStartLicenseAssistantActionPerformed(ActionEvent evt) {
        Assistant.getInstance().start(AssistantType.LICENSE_ASSISTANT);
        new ThemisLicensePanel().showDialog();
    }

    private void btnSelectRootFolderActionPerformed(ActionEvent evt) {
        this.chooseNewRootFolder();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showInExplorer(this.rootFolder);
    }

    private void treeTreeCollapsed(TreeExpansionEvent evt) {
    }

    private void treeTreeExpanded(TreeExpansionEvent evt) {
        TreePath path = evt.getPath();
        this.expandTree(path);
    }

    private void treeValueChanged(TreeSelectionEvent evt) {
        this.btnAdd.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        TreePath path = evt.getPath();
        if (path == null) {
            return;
        }
        Object sel = path.getLastPathComponent();
        if (sel == null || !(sel instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)sel;
        this.setButtonsEnabled(node);
        if (node.getUserObject() instanceof ThemisFolder) {
            this.populateProjectListFromFolder((ThemisFolder)node.getUserObject());
        } else if (sel == this.treeListRoot) {
            boolean bl = false;
        } else if (sel == this.treeFolderRoot) {
            boolean bl = false;
        } else if (node.getUserObject() instanceof String) {
            this.populateProjectListFromCollection((String)node.getUserObject());
        }
    }

    private void chkSelectAllItemStateChanged(ItemEvent evt) {
        if (this.chkSelectAll.isSelected()) {
            this.projectListManager.selectAll();
        } else {
            this.projectListManager.clearSelection();
        }
    }

    private void btnCreateProjectActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        ThemisFolder folder = this.selectedFolder;
        this.createProject(folder);
    }

    private void chkIncludSubfolderItemStateChanged(ItemEvent evt) {
        if (this.listSource == ListSource.FOLDER) {
            this.populateProjectListFromFolder(this.selectedFolder);
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        DefaultMutableTreeNode sel = this.getSelectedNode();
        if (evt.getButton() == 3) {
            JMenuItem item;
            TreePath selPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            Object clickTargetNode = selPath.getLastPathComponent();
            Object clickTarget = clickTargetNode instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)clickTargetNode).getUserObject() : null;
            ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
            if (clickTarget == null) {
                return;
            }
            if (clickTarget instanceof ThemisFolder) {
                item = THEMIS.createMenuItem("Unterordner anlegen", Color.WHITE, false, null);
                item.addActionListener(e -> this.createFolder((ThemisFolder)clickTarget));
                items.add(item);
                item = THEMIS.createMenuItem("Neues Projekt anlegen", Color.WHITE, false, null);
                item.addActionListener(e -> this.createProject((ThemisFolder)clickTarget));
                items.add(item);
                if (clickTargetNode == this.treeFolderRoot) {
                    item = THEMIS.createMenuItem("Stammordner wechseln", Color.WHITE, false, null);
                    item.addActionListener(e -> this.chooseNewRootFolder());
                    items.add(item);
                } else {
                    item = THEMIS.createMenuItem("Als Stammordner w\u00e4hlen", Color.WHITE, false, null);
                    item.addActionListener(e -> this.chooseNewRootFolder(((ThemisFolder)clickTarget).getProjectFolder()));
                    items.add(item);
                }
                item = THEMIS.createMenuItem("In Explorer zeigen", Color.WHITE, false, null);
                item.addActionListener(e -> this.showInExplorer(((ThemisFolder)clickTarget).getProjectFolder()));
                items.add(item);
            } else if (clickTarget instanceof String) {
                item = THEMIS.createMenuItem("Umbenennen", Color.WHITE, false, null);
                item.addActionListener(e -> this.renameProjectCollection((String)clickTarget));
                items.add(item);
                item = THEMIS.createMenuItem("L\u00f6schen", Color.WHITE, false, null);
                item.addActionListener(e -> this.deleteProjectCollection((String)clickTarget));
                items.add(item);
                item = THEMIS.createMenuItem("Neue Liste anlegen", Color.WHITE, false, null);
                item.addActionListener(e -> this.createNewProjectCollection());
                items.add(item);
                item = THEMIS.createMenuItem("Liste laden", Color.WHITE, false, null);
                item.addActionListener(e -> this.loadProjectCollection());
                items.add(item);
                item = THEMIS.createMenuItem("Liste speichern", Color.WHITE, false, null);
                item.addActionListener(e -> this.saveProjectCollection((String)clickTarget));
                items.add(item);
            }
            JPopupMenu menu = new JPopupMenu("Optionen");
            for (JMenuItem item2 : items) {
                menu.add(item2);
            }
            Point pt = evt.getPoint();
            pt = evt.getLocationOnScreen();
            menu.show(this.treepane, pt.x, pt.y);
        } else {
            boolean bl = false;
        }
    }

    private void btnSelectActionActionPerformed(ActionEvent evt) {
        JMenuItem item;
        ArrayList<ThemisFolder> sels = this.projectListManager.getSelection();
        if (sels == null || sels.size() == 0) {
            return;
        }
        JPopupMenu menu = new JPopupMenu("Optionen");
        JMenu submenu = THEMIS.createMenu("Zur Projektliste hinzuf\u00fcgen", Color.WHITE, false, null);
        for (String projectlist : this.app.getSettings().getProjectLists()) {
            item = THEMIS.createMenuItem(projectlist, Color.WHITE, false, null);
            item.addActionListener(e -> sels.forEach(tf -> this.app.getSettings().addProjectToList(projectlist, tf)));
            submenu.add(item);
        }
        menu.add(submenu);
        if (this.listSource == ListSource.LIST) {
            String projectlist = this.currentList;
            item = THEMIS.createMenuItem("Von Projektliste '" + projectlist + "' entfernen", Color.WHITE, false, null);
            item.addActionListener(e -> sels.forEach(tf -> {
                this.app.getSettings().removeProjectFromList(projectlist, tf);
                this.populateProjectList();
            }));
            menu.add(item);
        }
        item = THEMIS.createMenuItem("Projektvorlage aktualisieren", Color.WHITE, false, null);
        item.addActionListener(e -> {});
        item = THEMIS.createMenuItem("Zusammenfassender Bericht", Color.WHITE, false, null);
        item.addActionListener(e -> {});
        if (sels.size() == 1) {
            menu.add(THEMIS.createSeparator(Color.WHITE));
            item = THEMIS.createMenuItem("Ordner zeigen", Color.WHITE, false, null);
            item.addActionListener(e2 -> {
                File f0 = ((ThemisFolder)sels.get(0)).getProjectFolder();
                if (f0 != null) {
                    File f = f0.getParentFile();
                    try {
                        Desktop.getDesktop().open(f);
                    }
                    catch (IOException ex) {
                        ThemisApplication.getInstance().getDialog().showErrorDialog("Der Ordner '" + f.getAbsolutePath() + "' kann nicht ge\u00f6ffnet werden.");
                    }
                }
            });
            menu.add(item);
        }
        int c = menu.getComponentCount();
        menu.show(this.btnSelectAction, this.btnSelectAction.getWidth(), 0);
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object sel = node.getUserObject();
        if (sel == null || node == this.treeFolderRoot || node == this.treeListRoot || node == this.treeRoot || sel == "Zuletzt verwendet" || sel == "Lokal zwischengespeichert") {
            return;
        }
        if (sel instanceof ThemisFolder) {
            this.renameFolder((ThemisFolder)sel);
        } else if (sel instanceof String) {
            this.renameProjectCollection((String)sel);
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object sel = node.getUserObject();
        if (sel == null || node == this.treeFolderRoot || node == this.treeListRoot || node == this.treeRoot || sel == "Zuletzt verwendet" || sel == "Lokal zwischengespeichert") {
            return;
        }
        if (sel instanceof ThemisFolder) {
            this.deleteFolder((ThemisFolder)sel);
        } else if (sel instanceof String) {
            this.deleteProjectCollection((String)sel);
        }
    }

    private void setButtonsEnabled(DefaultMutableTreeNode node) {
        Object sel;
        Object object = sel = node == null ? null : node.getUserObject();
        if (sel == null || node == this.treeRoot) {
            this.btnAdd.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else if (node == this.treeFolderRoot || node == this.treeListRoot || sel == "Zuletzt verwendet" || sel == "Lokal zwischengespeichert") {
            this.btnAdd.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else if (sel instanceof ThemisFolder) {
            this.btnAdd.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(((ThemisFolder)sel).isEmpty());
        } else if (sel instanceof String) {
            this.btnAdd.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object sel = node.getUserObject();
        if (sel == null) {
            return;
        }
        if (sel instanceof ThemisFolder) {
            this.createFolder((ThemisFolder)sel);
        } else if (sel instanceof String) {
            this.createNewProjectCollection();
        }
    }

    private void btnNoLicenseActionPerformed(ActionEvent evt) {
        new ThemisLicensePanel().showDialog();
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(ThemisApplication.getInstance().getProject().getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, true);
        THEMIS.setAssistantMoveListener(dlg);
        THEMIS.applyWindowSizeAndLocation(this.DIALOG_CODE, dlg, 420, 335);
        dlg.setMinimumSize(new Dimension(350, 335));
        dlg.setVisible(true);
    }

    private void closeDialog() {
        JDialog parent = (JDialog)this.getRootPane().getParent();
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, parent);
        parent.dispose();
    }

    class TreeRootObject {
        String label = null;
        ThemisFolder folder = null;

        public TreeRootObject(String txt) {
            this.label = txt;
        }

        public TreeRootObject(ThemisFolder f) {
            this.folder = f;
        }

        public boolean isFolder() {
            return this.folder != null;
        }

        public String toString() {
            return this.label == null ? this.folder.getFolderName() : this.label;
        }
    }

    class ThemisTreeState {
        HashSet<ThemisFolder> state = new HashSet();

        public boolean contains(Object o) {
            if (o instanceof ThemisFolder) {
                for (ThemisFolder tf : this.state) {
                    if (!tf.equals(o)) continue;
                    return true;
                }
            }
            return false;
        }

        public void add(Object o) {
            if (o instanceof ThemisFolder) {
                this.state.add((ThemisFolder)o);
            }
        }

        public void clear() {
            this.state.clear();
        }
    }

    static enum ListSource {
        FOLDER,
        LIST,
        RECENT;

    }
}

