/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.simpleeditor.plan;

import at.grid.cms.element.CmsElement;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.simpleeditor.plan.PlanActionListener;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import java.awt.event.ActionEvent;

public class PlanActionListenerCreatePhotoDoc
extends PlanActionListener {
    public PlanActionListenerCreatePhotoDoc(SimpleGeometry geo, CmsPlan plan) {
        super(geo, plan);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CmsLocation location = null;
        LocationObservationDialog locationObservationDialog = new LocationObservationDialog();
        location = (CmsLocation)this.project.createElement("location");
        location.setAttributeValue("position", this.geo.toWKT());
        if (this.plan != null) {
            location.getRelationAttribute("plan").set((CmsElement)this.plan);
        }
        location.setAttributeValue("title", this.project.getResourceText("location.foto-doku-title"));
        boolean addFotoToObs = this.settings.getImageForObservation();
        if (addFotoToObs) {
            CmsObservation obs = (CmsObservation)this.project.createElement("observation");
            obs.setLocation(location);
            obs.setNumber(location.getNextObservationNumber());
            obs.setAttributeValue("title", this.project.getResourceText("observation.foto-doku-title"));
            obs.setAttributeValue("description", this.project.getResourceText("observation.foto-doku-title"));
            obs.getKeyAttribute("type").setValue(3L);
            location.updateMD5();
            locationObservationDialog.editObservation((CmsElement)location, obs);
        } else {
            location.updateMD5();
            locationObservationDialog.editLocation((CmsElement)location);
        }
        if (location != null && location.isSaved()) {
            this.project.updateCurrentEvent();
            this.project.getSelectionManager().setSelectedLocation(location.getId(), true, (Object)this);
        }
    }
}

