/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.statistics;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.report.pdf.PdfStatisticsExporter;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.util.NbBundle;

public final class ProjectStatisticsPanel
extends ThemisPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    private List<ThemisFolder> projects = new ArrayList<ThemisFolder>();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/statistics/Bundle");
    private String year = null;
    private ArrayList<String> years = new ArrayList();
    private HashMap<String, Object> statistics = new HashMap();
    private boolean recreateStatistics = false;
    private boolean askForRecreate = true;
    private ThemisFolder projectToReopen = null;
    private boolean trigger = true;
    private File exportFile = null;
    private JButton btnChoosFile;
    private JButton btnClose;
    private JButton btnExportFile;
    private JButton btnRecalcStatistics;
    private JTextField fldExportFile;
    private JComboBox<String> fldYear;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblTitle;
    private JPanel panelProjectinfo;
    private JPanel panelStatisticsContent;
    private JScrollPane panelStatisticsContentScroll;

    public ProjectStatisticsPanel() {
        this.initComponents();
        this.reset();
    }

    public void addCurrentProject() {
        ThemisFolder tf = this.project.getThemisFile();
        if (this.project.isOpen() && tf != null) {
            this.projects.add(tf);
        }
    }

    public void addProject(ThemisFolder tf) {
        if (tf != null) {
            this.projects.add(tf);
        }
    }

    public void addProject(ArrayList<ThemisFolder> tfs) {
        if (tfs != null) {
            this.projects.addAll(tfs);
        }
    }

    public void reset() {
        this.year = null;
        this.years.clear();
        this.statistics.clear();
        this.projects.clear();
        this.askForRecreate = true;
        this.recreateStatistics = false;
        this.projectToReopen = null;
        this.fldYear.removeAllItems();
        this.fldExportFile.setText("");
        this.panelStatisticsContent.removeAll();
    }

    private void populateYearList(ThemisFolder themis) {
        this.trigger = false;
        ArrayList<String> yearsInThemis = new ArrayList<String>();
        for (String key : themis.getStatistics().stringPropertyNames()) {
            if (!key.startsWith("count.events.")) continue;
            yearsInThemis.add(key.substring(13));
        }
        for (String y : yearsInThemis) {
            if (this.years.contains(y)) continue;
            this.years.add(y);
        }
        Collections.sort(this.years);
        String selYear = (String)this.fldYear.getSelectedItem();
        this.fldYear.removeAllItems();
        for (String y : this.years) {
            this.fldYear.addItem(y);
            this.year = y;
        }
        if (selYear == null) {
            selYear = this.year;
        } else {
            this.year = selYear;
        }
        this.fldYear.setSelectedItem(selYear);
        this.trigger = true;
    }

    @Override
    public void populate(ProgressHandler ph) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        this.exportFile = this.app.getSettings().getFileStatisticsPdf();
        if (this.exportFile != null) {
            this.fldExportFile.setText(this.exportFile.getName());
        } else {
            this.fldExportFile.setText("");
        }
        this.panelStatisticsContent.removeAll();
        this.panelStatisticsContent.revalidate();
        if (this.projects == null || this.projects.size() == 0) {
            this.lblTitle.setText(this.project.getResourceText("ProjectOverviewTopComponent.no-project"));
            this.year = null;
            return;
        }
        ProgressRunnable<String> runner = new ProgressRunnable<String>(){

            public String run(ProgressHandle ph) {
                int counter = 0;
                int maxcounter = ProjectStatisticsPanel.this.projects.size();
                ph.switchToDeterminate(maxcounter);
                Notification notify = THEMIS.notify(1, ProjectStatisticsPanel.this.bundle.getString("CTL_ProjectOverviewTopComponent.text"), ProjectStatisticsPanel.this.bundle.getString("ProjectOverviewTopComponent.creatingStats.text"));
                for (ThemisFolder themis : ProjectStatisticsPanel.this.projects) {
                    if (themis == null) continue;
                    themis.loadProperties();
                    if (ProjectStatisticsPanel.this.projects.size() == 1) {
                        ProjectStatisticsPanel.this.lblTitle.setText(themis.getProjectTitle());
                    } else {
                        ProjectStatisticsPanel.this.lblTitle.setText(MessageFormat.format(ProjectStatisticsPanel.this.bundle.getString("ProjectOverviewTopComponent.statsTitle.text"), ProjectStatisticsPanel.this.projects.size()));
                    }
                    if (!"2".equals(themis.getStatistics().getProperty("version"))) {
                        if (ProjectStatisticsPanel.this.project.isOpen() && ProjectStatisticsPanel.this.project.getProjectFolder().equals(themis.getProjectFolder())) {
                            ProjectStatisticsPanel.this.project.getProjectStatistics(true, true);
                            themis.loadProperties();
                        } else {
                            if (ProjectStatisticsPanel.this.askForRecreate) {
                                ProjectStatisticsPanel.this.recreateStatistics = Dialogs.getInstance().showConfirmDialog("Test: Soll die Statistik f\u00fcr das Projekt '" + themis.toString() + "' und weitere Projekte neu erstellt werden? Dies kann bei mehreren Projekten etwas dauern.", "Test: Statistik neu rechnen");
                                ProjectStatisticsPanel.this.askForRecreate = false;
                            }
                            if (ProjectStatisticsPanel.this.recreateStatistics) {
                                if (ProjectStatisticsPanel.this.project.isOpen()) {
                                    ProjectStatisticsPanel.this.projectToReopen = ProjectStatisticsPanel.this.project.getThemisFile();
                                    if (ThemisApplication.getInstance().getProject().close(THEMIS.getCloseProjectFeedback(new Closing().withoutExport().withoutTrigger()), null)) {
                                        return null;
                                    }
                                }
                                ProjectStatisticsPanel.this.project.openProject(themis, false, null);
                                ProjectStatisticsPanel.this.project.close(new Closing().withoutExport().withoutTrigger(), null);
                                themis.loadProperties();
                            }
                        }
                    }
                    ProjectStatisticsPanel.this.populateYearList(themis);
                    if (ProjectStatisticsPanel.this.projects.size() == 1) {
                        ProjectStatisticsPanel.this.addProjectStatisticsString("access.first", themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsString("access.creator", themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsString("access.last", themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsString("access.last-user", themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsString("last.event", themis);
                    }
                    ProjectStatisticsPanel.this.addProjectStatisticsInt("count.events", themis);
                    ProjectStatisticsPanel.this.addProjectStatisticsInt("count.buildings", themis);
                    ProjectStatisticsPanel.this.addProjectStatisticsInt("count.plans", themis);
                    ProjectStatisticsPanel.this.addProjectStatisticsInt("count.locations", themis);
                    ProjectStatisticsPanel.this.addProjectStatisticsInt("count.opentasks", themis);
                    ProjectStatisticsPanel.this.addProjectStatisticsInt("count.observations", themis);
                    ProjectStatisticsPanel.this.addProjectStatisticsInt("count.observations.type1", themis);
                    ProjectStatisticsPanel.this.addProjectStatisticsInt("count.observations.type2", themis);
                    ProjectStatisticsPanel.this.addProjectStatisticsInt("count.observations.type3", themis);
                    ProjectStatisticsPanel.this.addProjectStatisticsInt("count.observations.type4", themis);
                    for (String yy : ProjectStatisticsPanel.this.years) {
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.events." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.checks." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.newobservations." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.newobservations.type1." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.newobservations.type2." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.newobservations.type3." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.newobservations.type4." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.observations." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.observations.type1." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.observations.type2." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.observations.type3." + yy, themis);
                        ProjectStatisticsPanel.this.addProjectStatisticsInt("yearcount.observations.type4." + yy, themis);
                    }
                    ph.progress(ProjectStatisticsPanel.this.bundle.getString("ProjectOverviewTopComponent.creatingStats.text"), ++counter);
                }
                notify.clear();
                return null;
            }
        };
        if (this.statistics.isEmpty()) {
            BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)runner, (String)this.bundle.getString("ProjectOverviewTopComponent.creatingStats.text"), (boolean)true);
        }
        int row = 0;
        if (this.projects.size() == 1) {
            this.addHeading(this.project.getResourceText("statistics.headerAbout"), row++, 2);
            this.addProjectProperty("access.first", row++);
            this.addProjectProperty("access.creator", row++);
            this.addProjectProperty("access.last", row++);
            this.addProjectProperty("access.last-user", row++);
            this.addProjectProperty("last.event", row++);
        }
        this.addHeading(this.project.getResourceText("statistics.headerQuantity"), row++, 2);
        this.addProjectProperty("count.events", row++);
        this.addProjectProperty("count.buildings", row++);
        this.addProjectProperty("count.plans", row++);
        this.addProjectProperty("count.locations", row++);
        this.addProjectProperty("count.opentasks", row++);
        this.addHeading(this.project.getResourceText("statistics.headerYear") + " - " + this.year, row++, 1);
        this.addHeading(this.project.getResourceText("statistics.headerOverview"), row++, 2);
        this.addProjectProperty("yearcount.events." + this.year, row++);
        this.addProjectProperty("yearcount.checks." + this.year, row++);
        this.addHeading(this.project.getResourceText("statistics.headerNewObs"), row++, 2);
        this.addProjectProperty("yearcount.newobservations." + this.year, row++);
        this.addProjectProperty("yearcount.newobservations.type1." + this.year, row++);
        this.addProjectProperty("yearcount.newobservations.type2." + this.year, row++);
        this.addProjectProperty("yearcount.newobservations.type3." + this.year, row++);
        this.addProjectProperty("yearcount.newobservations.type4." + this.year, row++);
        this.addHeading(this.project.getResourceText("statistics.headerTotalObs"), row++, 2);
        this.addProjectProperty("yearcount.observations." + this.year, row++);
        this.addProjectProperty("yearcount.observations.type1." + this.year, row++);
        this.addProjectProperty("yearcount.observations.type2." + this.year, row++);
        this.addProjectProperty("yearcount.observations.type3." + this.year, row++);
        this.addProjectProperty("yearcount.observations.type4." + this.year, row++);
        this.finalizePanel(this.panelStatisticsContent, row);
        this.panelStatisticsContent.revalidate();
        if (this.projectToReopen != null) {
            this.project.openProject(this.projectToReopen, false, null);
        }
        this.askForRecreate = true;
        this.recreateStatistics = false;
    }

    private void addProjectStatisticsString(String key, ThemisFolder themis) {
        try {
            Properties props = themis.getStatistics();
            if (props.containsKey(key)) {
                this.statistics.put(key, props.getProperty(key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addProjectStatisticsInt(String key, ThemisFolder themis) {
        try {
            Properties props = themis.getStatistics();
            Integer current = (Integer)this.statistics.get(key);
            if (current == null) {
                current = 0;
            }
            String propsKey = key;
            if (key.startsWith("yearcount.")) {
                propsKey = key.substring(4);
            }
            if (props.containsKey(propsKey)) {
                current = current + Integer.parseInt(props.getProperty(propsKey));
                this.statistics.put(key, current);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addHeading(String txt, int panelRow, int headingLevel) {
        JPanel p = this.panelStatisticsContent;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = panelRow;
        gridBagConstraints.gridwidth = 2;
        JLabel lbl = new JLabel(txt);
        switch (headingLevel) {
            case 1: {
                lbl.setFont(THEMIS.fontHeading);
                gridBagConstraints.insets = new Insets(20, 5, 15, 5);
                break;
            }
            case 2: {
                lbl.setFont(THEMIS.fontSubheading);
                gridBagConstraints.insets = new Insets(10, 5, 10, 5);
                break;
            }
            default: {
                lbl.setFont(THEMIS.fontLabelBold);
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            }
        }
        p.add((Component)lbl, gridBagConstraints);
    }

    private void addProjectProperty(String key, int panelRow) {
        JPanel p = this.panelStatisticsContent;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = panelRow;
        String labelkey = key;
        if (key.startsWith("yearcount.")) {
            labelkey = key.substring(4, key.length() - 5);
        }
        JLabel lbl = new JLabel(this.project.getResourceText("projectstat." + labelkey));
        lbl.setFont(THEMIS.fontLabel);
        p.add((Component)lbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = panelRow;
        lbl = new JLabel(this.statistics.getOrDefault(key, "-").toString());
        lbl.setFont(THEMIS.fontLabelBold);
        p.add((Component)lbl, gridBagConstraints);
    }

    private void finalizePanel(JPanel p, int panelRow) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = panelRow;
        p.add((Component)new JPanel(), gridBagConstraints);
    }

    private void exportStatisticsToPdf() {
        if (this.exportFile != null) {
            int option;
            CmsReport rep = new CmsReport();
            PdfStatisticsExporter pdf = new PdfStatisticsExporter();
            pdf.setYears(this.years);
            pdf.setStatistics(this.statistics, this.projects);
            pdf.exportToPdf(this.exportFile, rep, this.project.getUser());
            if (this.exportFile.isFile() && this.exportFile.length() > 0L && (option = Dialogs.getInstance().showInfoOptionDialog(this.project.getResourceText("export.success", this.app.getLocale()), this.project.getResourceText("export.info-title", this.app.getLocale()), new String[]{this.project.getResourceText("export.show-after-done", this.app.getLocale()), this.project.getResourceText("core.core.text.ok", this.app.getLocale())})) == 0) {
                try {
                    Desktop.getDesktop().open(this.exportFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.btnClose = new JButton();
        this.jPanel1 = new JPanel();
        this.panelProjectinfo = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.btnRecalcStatistics = new JButton();
        this.fldYear = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.fldExportFile = new JTextField();
        this.btnChoosFile = new JButton();
        this.btnExportFile = new JButton();
        this.panelStatisticsContentScroll = new JScrollPane();
        this.panelStatisticsContent = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblTitle = new JLabel();
        this.setMinimumSize(new Dimension(200, 200));
        this.setPreferredSize(new Dimension(300, 400));
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.btnClose.text"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectStatisticsPanel.this.btnCloseActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.btnClose);
        this.add((Component)this.jPanel3, "South");
        this.jPanel1.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.jLabel4.text"));
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.jLabel3.text"));
        this.btnRecalcStatistics.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRecalcStatistics, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.btnRecalcStatistics.text"));
        this.btnRecalcStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectStatisticsPanel.this.btnRecalcStatisticsActionPerformed(evt);
            }
        });
        this.fldYear.setFont(THEMIS.fontList);
        this.fldYear.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProjectStatisticsPanel.this.fldYearItemStateChanged(evt);
            }
        });
        this.jLabel5.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.jLabel5.text"));
        this.jLabel6.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.jLabel6.text"));
        this.jLabel7.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.jLabel7.text"));
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.jLabel8.text"));
        this.fldExportFile.setText(NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.fldExportFile.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnChoosFile, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.btnChoosFile.text"));
        this.btnChoosFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectStatisticsPanel.this.btnChoosFileActionPerformed(evt);
            }
        });
        this.btnExportFile.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportFile, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.btnExportFile.text"));
        this.btnExportFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectStatisticsPanel.this.btnExportFileActionPerformed(evt);
            }
        });
        GroupLayout panelProjectinfoLayout = new GroupLayout(this.panelProjectinfo);
        this.panelProjectinfo.setLayout(panelProjectinfoLayout);
        panelProjectinfoLayout.setHorizontalGroup(panelProjectinfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProjectinfoLayout.createSequentialGroup().addGroup(panelProjectinfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(panelProjectinfoLayout.createSequentialGroup().addContainerGap().addGroup(panelProjectinfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7).addGroup(panelProjectinfoLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(panelProjectinfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnRecalcStatistics).addGroup(panelProjectinfoLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fldYear, -2, -1, -2)).addComponent(this.jLabel8).addGroup(panelProjectinfoLayout.createSequentialGroup().addComponent(this.fldExportFile, -2, 133, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnChoosFile)).addComponent(this.btnExportFile)))))).addContainerGap()));
        panelProjectinfoLayout.setVerticalGroup(panelProjectinfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProjectinfoLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelProjectinfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.fldYear, -2, 35, -2)).addGap(18, 18, 18).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelProjectinfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fldExportFile, -2, 35, -2).addComponent(this.btnChoosFile, -2, 35, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExportFile, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnRecalcStatistics, -2, 35, -2).addContainerGap(106, Short.MAX_VALUE)));
        this.jPanel1.add((Component)this.panelProjectinfo, "West");
        this.panelStatisticsContent.setLayout(new GridBagLayout());
        this.panelStatisticsContentScroll.setViewportView(this.panelStatisticsContent);
        this.jPanel1.add((Component)this.panelStatisticsContentScroll, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblTitle.setFont(THEMIS.fontHeading);
        this.lblTitle.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(ProjectStatisticsPanel.class, (String)"ProjectStatisticsPanel.lblTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.jPanel2.add((Component)this.lblTitle, gridBagConstraints);
        this.add((Component)this.jPanel2, "North");
    }

    private void btnRecalcStatisticsActionPerformed(ActionEvent evt) {
        this.statistics.clear();
        this.project.getProjectStatistics(true, true);
        this.populate();
    }

    private void fldYearItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.year = (String)this.fldYear.getSelectedItem();
            if (this.trigger) {
                this.populate();
            }
        }
    }

    private void btnChoosFileActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.project.getResourceText("dialog.load.Statistics"), ThemisFileDialog.DIALOGTYPE.SAVE, this.app.getSettings().getFileStatisticsPdf(), null, THEMIS.getPdfFilter(), null, false).getSelectedFile();
        if (f != null) {
            this.fldExportFile.setText(f.getName());
        }
        this.exportFile = THEMIS.getSelectedFile(this.fldExportFile, f, "pdf");
        this.app.getSettings().setFileStatisticsPdf(f);
    }

    private void btnExportFileActionPerformed(ActionEvent evt) {
        this.exportFile = THEMIS.getSelectedFile(this.fldExportFile, this.exportFile, "pdf");
        if (this.exportFile != null) {
            boolean dosave = true;
            if (this.exportFile.isDirectory()) {
                Dialogs.getInstance().showErrorDialog(this.project.getResourceText("MESSAGE_FILE_IS_DIR"));
                dosave = false;
            } else if (this.exportFile.isFile() && this.exportFile.exists()) {
                Object[] options = new String[]{this.project.getResourceText("core.text.yes"), this.project.getResourceText("core.text.no")};
                int option = Dialogs.getInstance().showInfoOptionDialog(this.project.getResourceText("MESSAGE_OVERWRITE_FILE"), this.project.getResourceText("MESSAGE_TITLE_FILE_EXISTS"), options);
                if (option == 1) {
                    dosave = false;
                }
            }
            if (dosave) {
                this.exportStatisticsToPdf();
                this.app.getSettings().setFileStatisticsPdf(this.exportFile);
            }
        } else {
            this.app.getDialog().showErrorDialog("error.no-file-selected");
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    @Override
    public void apply() {
    }

    @Override
    public String getDialogCode() {
        return "projectstatistics";
    }

    @Override
    public Dimension getPanelSize() {
        return new Dimension(800, 700);
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(800, 700);
    }
}

