/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.support;

import at.grid.cms.CmsApplication;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.UpdateManager;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.application.support.Bundle;
import at.grid.themis.application.support.SQLQueryPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.CryptoUtilites;
import at.grid.util.Util;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="SupportTopComponent", persistenceType=0)
public final class SupportTopComponent
extends TopComponent
implements ThemisActionListener {
    private ArrayList<Feature> features = new ArrayList();
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    private int specialFeatureAttemptCounter = 0;
    public HashMap<String, Integer> featureCode = new HashMap();
    private JButton btnCalcServerCode;
    private JButton btnCalcServerCode1;
    private JButton btnDebug;
    private JButton btnFeature;
    private JButton btnFeatureCalc;
    private JButton btnGenerateLicenseText;
    private JButton btnUpload;
    private JButton btnUpload1;
    private JButton btnUpload2;
    private JButton btnUpload4;
    private JTextField fldComputerName;
    private JTextField fldFeatureCode;
    private JTextField fldFeatureCodeCalc;
    private JComboBox<Feature> fldFeatureCodeFeature;
    private JTextField fldHardwareId;
    private JTextField fldKundennrCalc;
    private JTextField fldLicenseKey;
    private JTextField fldRandom;
    private JTextField fldRandomCalc;
    private JTextField fldServerCode;
    private JTextField fldServerPassword;
    private JTextField fldServerPassword1;
    private JTextField fldServerUUID;
    private JTextField fldServerUrl;
    private JTextField fldServerUrl1;
    private JTextField fldUrl;
    private JTextField fldUrlProject;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel lblComputerName;
    private JLabel lblDebugStatus;
    private JLabel lblEmpty;
    private JLabel lblEmpty1;
    private JLabel lblEmpty2;
    private JLabel lblEmpty3;
    private JLabel lblEmpty4;
    private JLabel lblEmpty5;
    private JLabel lblEmpty7;
    private JLabel lblKundenNummer;
    private JList<SupportAction> lstAction;
    private JPanel panelDebug;
    private JPanel panelLicenseGeneration;
    private JPanel panelMain;
    private JPanel panelSendProjectInfo;
    private JPanel panelServerCodeCalc;
    private JPanel panelSonderfunktion;
    private JPanel panelSonderfunktionCalc;
    private JPanel panelUploadDatabase;
    private JPanel panelUploadProject;
    private JScrollPane scrollActionList;

    public SupportTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_SupportTopComponent());
        this.setToolTipText(Bundle.HINT_SupportTopComponent());
        this.putClientProperty("netbeans.winsys.tc.dragging_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.undocking_disabled", Boolean.TRUE);
        this.createActions();
        this.lblKundenNummer.setText(Integer.toString(this.app.getLicense().getClientID()));
        this.lblComputerName.setText(this.app.getLicense().getHostname());
        this.updateDebugState();
        this.features.add(Feature.FEATURE_DEACTIVATE_LICENSE);
        this.features.add(Feature.FEATURE_SQL_DIALOG);
        this.features.add(Feature.FEATURE_RESET_PASSWORD);
        this.features.add(Feature.FEATURE_BUGFIX_QUANTITY);
        this.features.add(Feature.FEATURE_ACTIVATE_EMAIL_SYNC);
        this.features.add(Feature.FEATURE_DATABASE_DUMP);
        this.features.add(Feature.FEATURE_REPAIR_DATABASE);
        this.features.add(Feature.FEATURE_UPDATE_INTERN);
        this.features.add(Feature.FEATURE_PROJECT_VOLLVERSION);
        this.features.add(Feature.FEATURE_PROJECT_BRANDSCHUTZBUCH);
        this.features.add(Feature.FEATURE_REMOVE_DOUBLE_FOTO);
        this.features.add(Feature.FEATURE_EMPTY_TRASH);
        this.features.add(Feature.FEATURE_MAKE_ADMIN);
        this.features.add(Feature.FEATURE_GENERATE_LICENSE);
        this.fldFeatureCodeFeature.removeAllItems();
        for (Feature f : this.features) {
            this.fldFeatureCodeFeature.addItem(f);
        }
        ThemisActionProvider.getInstance().register(this);
    }

    public void onAction(ThemisAction action) {
        if (((Object)((Object)this)).equals(action.getSource())) {
            return;
        }
        switch (action.getAction()) {
            case 1300: {
                this.lblKundenNummer.setText(Integer.toString(this.app.getLicense().getClientID()));
                this.lblComputerName.setText(this.app.getLicense().getHostname());
                this.createActions();
            }
        }
    }

    public Feature getFeature(int code) {
        for (Feature f : this.features) {
            if (f.getCode() != code) continue;
            return f;
        }
        return null;
    }

    private void createActions() {
        DefaultListModel model = (DefaultListModel)this.lstAction.getModel();
        model.removeAllElements();
        model.addElement(new SupportAction("Sonderfunktion", "cardSonderfunktion"));
        if (this.app.getLicense().isInternalLicense()) {
            model.addElement(new SupportAction("Sonderfunktion berechnen", "cardSonderfunktionCalc"));
            model.addElement(new SupportAction("Server Code berechnen", "cardSonderfunktionServerCalc"));
            model.addElement(new SupportAction("Lizenz aktivieren", "cardGenerateLicenseText"));
        }
        model.addElement(new SupportAction("Ausf\u00fchrliches Logging", "cardDebug"));
        model.addElement(new SupportAction("Status-Information schicken", "cardSendProjectInfo"));
        model.addElement(new SupportAction("Projekt hochladen", "cardUploadProject"));
        model.addElement(new SupportAction("Projektdatenbank hochladen", "cardDatenbankSchicken"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void enableFeature() {
        try {
            ThemisLicense license = this.app.getLicense();
            if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
                return;
            }
            int n = Integer.parseInt(this.fldRandom.getText());
            int customer = license.getClientID();
            Calendar cal = Calendar.getInstance(this.app.getLocale());
            cal.setTime(new Date());
            int day = cal.get(5);
            int code = customer + day * n;
            String codeEnteredStr = this.fldFeatureCode.getText();
            int codeEntered = Integer.parseInt(codeEnteredStr);
            int feature = codeEntered - code;
            Feature f = this.getFeature(feature);
            switch (f) {
                case FEATURE_PROJECT_VOLLVERSION: {
                    if (this.project.isOpen()) {
                        this.project.setProjectProperty("license.level", "10");
                        Dialogs.getInstance().showInfoDialog("new ThemisProgressHandler");
                        return;
                    }
                    Dialogs.getInstance().showWarningDialog("error.no-project-open");
                    return;
                }
                case FEATURE_PROJECT_BRANDSCHUTZBUCH: {
                    if (this.project.isOpen()) {
                        this.project.setProjectProperty("license.level", "5");
                        Dialogs.getInstance().showInfoDialog("dialog.project-downgrade-brandschutzbuch");
                        return;
                    }
                    Dialogs.getInstance().showWarningDialog("error.no-project-open");
                    return;
                }
                case FEATURE_REMOVE_DOUBLE_FOTO: {
                    if (this.project.isOpen()) {
                        List recs = this.project.getDatastorage().executeQuery("select * from tdtafileupload where elementtype='history' order by filesize,idfileupload", true).getResult();
                        long previousFilesize = -1L;
                        String previousName = "------------";
                        for (DataRecord rec : recs) {
                            if (previousFilesize > 0L && rec.getLong("filesize") == previousFilesize && rec.getString("name").indexOf(previousName) >= 0) {
                                this.project.getDatastorage().executeUpdate("DELETE FROM tdtaFileUpload WHERE idFileupload=" + rec.getLong("idfileupload"), true);
                                try {
                                    File file = this.project.getUploadFile("history", rec.getString("path"));
                                }
                                catch (IOException e) {
                                    this.project.getLogger().severe("Cannot delete file '" + rec.getString("path"));
                                }
                            }
                            previousFilesize = rec.getLong("filesize");
                            previousName = rec.getString("name");
                        }
                        return;
                    }
                    Dialogs.getInstance().showWarningDialog("error.no-project-open");
                    return;
                }
                case FEATURE_EMPTY_TRASH: {
                    if (this.project.isOpen()) {
                        int countDeleted = this.project.getDatastorage().executeUpdate("DELETE FROM tdtaElement WHERE deleted", true);
                        Dialogs.getInstance().showInfoDialog("dialog.removed-from-trash", countDeleted);
                        return;
                    }
                    Dialogs.getInstance().showWarningDialog("error.no-project-open");
                    return;
                }
                case FEATURE_RESET_PASSWORD: {
                    if (this.project.isOpen()) {
                        this.project.getDatastorage().executeUpdate("ALTER USER themis SET PASSWORD 'oE93ly-2oq'", true);
                        Dialogs.getInstance().showInfoDialog("dialog.password-reset");
                        return;
                    }
                    Dialogs.getInstance().showWarningDialog("error.no-project-open");
                    return;
                }
                case FEATURE_SQL_DIALOG: {
                    if (this.project.isOpen()) {
                        new SQLQueryPanel(this.app.getProject().getDatastorage()).showDialog();
                    } else {
                        Dialogs.getInstance().showWarningDialog("error.no-project-open");
                    }
                    this.createRandomNumber();
                    return;
                }
                case FEATURE_DEACTIVATE_LICENSE: {
                    license.deactivate();
                    this.app.getActionProvider().invokeAction(ThemisAction.LICENSE_CHANGED);
                    this.createRandomNumber();
                    return;
                }
                case FEATURE_ACTIVATE_EMAIL_SYNC: {
                    String current = this.app.getConfiguration("system.email.sync.enabled");
                    this.app.setConfiguration("system.email.sync.enabled", "yes".equals(current) ? "no" : "yes", true);
                    Dialogs.getInstance().showInfoDialog("yes".equals(current) ? "dialog.activate-email-sync" : "dialog.deactivate-email-sync");
                    return;
                }
                case FEATURE_BUGFIX_QUANTITY: {
                    if (this.project.getCurrentEvent() == null) {
                        Dialogs.getInstance().showWarningDialog("core.text.noevent.title");
                        return;
                    }
                    ThemisProgressHandler progress = new ThemisProgressHandler("progress.report-generate");
                    String obscode = null;
                    String obsquantity = null;
                    CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
                    s.setElementtypes("observation");
                    s.addSelectMeta();
                    ArrayList ids = s.search().getResultIds();
                    progress.switchToDeterminate(ids.size());
                    int counter = 0;
                    Iterator iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        progress.progress(counter++);
                        CmsObservation obs = (CmsObservation)this.project.loadElement(id, this.project.getUser());
                        ArrayList dates = obs.getHistory();
                        obscode = null;
                        obsquantity = null;
                        for (Date dt : dates) {
                            obs.revertToHistory(dt);
                            if (obs.hasAttributeValue("code")) {
                                obscode = obs.getAttributeValue("code");
                            }
                            if (!obs.hasAttributeValue("quantity")) continue;
                            obsquantity = obs.getAttributeValue("quantity");
                        }
                        obs.reload();
                        if (obscode != null) {
                            obs.setAttributeValue("code", obscode);
                        }
                        if (obsquantity != null) {
                            obs.setAttributeValue("quantity", obsquantity);
                        }
                        obs.save();
                    }
                    progress.doneWithConfirm("Beobachtungen sind aktualisiert");
                    return;
                }
                case FEATURE_UPDATE_INTERN: {
                    ThemisTaskWithDialog.createTask("Das Update wird heruntergeladen ...", ph -> {
                        try {
                            UpdateManager um = new UpdateManager();
                            um.setManualUpdate(true);
                            um.execute(ph);
                        }
                        catch (Exception ex) {
                            ThemisApplication.getInstance().getProject().getLogger().severe("Error while updating: " + ex.getMessage());
                            ex.printStackTrace();
                            ThemisApplication.getInstance().getDialog().showErrorDialog("Fehler beim THEMIS Update", ex);
                        }
                    });
                    return;
                }
                case FEATURE_DATABASE_DUMP: {
                    return;
                }
                case FEATURE_REPAIR_DATABASE: {
                    return;
                }
                case FEATURE_MAKE_ADMIN: {
                    if (!this.project.isOpen()) {
                        return;
                    }
                    String username = this.project.getUser().getUsername();
                    this.app.getSettings().addPermissionEditTemplates(username);
                    Dialogs.getInstance().showInfoDialog("Aktueller Benutzer ist jetzt Admin f\u00fcr dieses Projekt");
                    return;
                }
                default: {
                    Dialogs.getInstance().showWarningDialog("error.support-wrong-code");
                    ++this.specialFeatureAttemptCounter;
                    if (this.specialFeatureAttemptCounter <= 2) return;
                    this.createRandomNumber();
                    this.specialFeatureAttemptCounter = 0;
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void createRandomNumber() {
        int n = 1000 + (int)(Math.random() * 8998.0);
        this.fldRandom.setText(Integer.toString(n));
    }

    private void uploadProject() {
        String url = this.fldUrlProject.getText().trim();
        if (url.isEmpty()) {
            return;
        }
        if (!this.project.isOpen()) {
            return;
        }
        File fld = this.project.getProjectFolder();
        ThemisFolder projectfile = this.project.getThemisFile();
        this.project.close(new Closing().withoutExport().withoutTrigger(), null);
        File zip = new File(this.app.getApplicationDataTempFolder(), fld.getName() + ".zip");
        try {
            ThemisUtil.exportProjectAsZip((ThemisFolder)projectfile, (File)zip, (boolean)false, null);
            if (!zip.isFile()) {
                Dialogs.getInstance().showErrorDialog("error.project-to-zip");
                return;
            }
            THEMIS.uploadFileToNextcloud(url, zip);
        }
        catch (Exception ignored) {
            Dialogs.getInstance().showErrorDialog("error.project-to-zip");
        }
        try {
            if (zip.isFile() && zip.exists()) {
                zip.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.project.open(fld, null, false);
    }

    private void uploadDatabaseFile() {
        String url = this.fldUrlProject.getText().trim();
        if (url.isEmpty()) {
            return;
        }
        if (!this.project.isOpen()) {
            return;
        }
        File f = this.project.getDatabaseFile();
        File fld = this.project.getProjectFolder();
        this.project.close(new Closing().withoutExport().withoutTrigger(), null);
        try {
            THEMIS.uploadFileToNextcloud(url, f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.project.open(fld, null, false);
    }

    private void sendProjectInfoEmail(final String subject, final boolean systemInfo, final boolean projectInfo, final boolean licenseInfo) {
        BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

            @Override
            public void run() {
                ArrayList<String> propNames;
                StringBuilder sb;
                File f;
                String base = Long.toString(new Date().getTime());
                File fld = new File(SupportTopComponent.this.app.getApplicationDataTempFolder(), base);
                fld.mkdirs();
                ArrayList<File> files = new ArrayList<File>();
                if (systemInfo) {
                    f = new File(fld, "system.properties");
                    sb = new StringBuilder();
                    propNames = new ArrayList<String>();
                    for (String string : System.getProperties().stringPropertyNames()) {
                        propNames.add(string);
                    }
                    Collections.sort(propNames);
                    for (String string : propNames) {
                        sb.append(string).append(" = ").append(System.getProperty(string)).append("\n");
                    }
                    try {
                        Util.stringToFile((String)sb.toString(), (File)f);
                        files.add(f);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (projectInfo) {
                    if (SupportTopComponent.this.project.isOpen()) {
                        f = new File(fld, "projectsettings.xlsx");
                        SupportTopComponent.this.project.getTemplateManger().saveTemplates(f);
                        files.add(f);
                    }
                    SupportTopComponent.this.app.getSettings().saveToFile();
                    files.add(SupportTopComponent.this.app.getSettings().getSettingsFile());
                    Properties stats = SupportTopComponent.this.project.getProjectStatistics();
                    f = new File(fld, "project.properties");
                    sb = new StringBuilder();
                    propNames = new ArrayList();
                    for (String p : stats.stringPropertyNames()) {
                        propNames.add(p);
                    }
                    Collections.sort(propNames);
                    for (String p : propNames) {
                        sb.append(p).append(" = ").append(System.getProperty(p)).append("\n");
                    }
                    try {
                        Util.stringToFile((String)sb.toString(), (File)f);
                        files.add(f);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                if (licenseInfo) {
                    f = new File(fld, "license.txt");
                    try {
                        Util.stringToFile((String)SupportTopComponent.this.app.getLicense().getLicenseDetails().getLicenseStatusDescription(), (File)f);
                        files.add(f);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                THEMIS.prepareEmail("info@themis-software.com", subject, "", true, files);
            }
        }, (String)this.project.getResourceText("progress.prepare-email"));
    }

    private void sendIDElogEmail() {
        THEMIS.sendIDElog();
    }

    private void updateDebugState() {
        if (this.app.isDebugMode()) {
            this.lblDebugStatus.setText("AKTIVIERT");
            this.btnDebug.setText("Detail-Log deaktivieren");
        } else {
            this.lblDebugStatus.setText("deaktiviert");
            this.btnDebug.setText("Detail-Log aktivieren");
        }
    }

    private String generateLicenseText() {
        try {
            int numRead;
            String server = this.app.getLicense().getActivationAddress();
            HttpPost httpPost = new HttpPost(server);
            JSONObject jsonRequest = new JSONObject();
            jsonRequest.put("licenseKey", (Object)this.fldLicenseKey.getText().trim());
            jsonRequest.put("hardwareId", (Object)this.fldHardwareId.getText().trim());
            jsonRequest.put("computerOs", (Object)"Windows");
            jsonRequest.put("computerName", (Object)this.fldComputerName.getText().trim());
            jsonRequest.put("internalString", (Object)"1483631478408");
            jsonRequest.put("lang", (Object)ThemisApplication.getInstance().getLocale().getLanguage());
            String jsonString = jsonRequest.toString();
            String crpyt = CryptoUtilites.encryptAes((String)jsonString);
            httpPost.setEntity((HttpEntity)new StringEntity(crpyt));
            CloseableHttpClient client = HttpClients.createDefault();
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            int bufferSize = 1024;
            char[] buffer = new char[bufferSize];
            StringBuilder out = new StringBuilder();
            InputStreamReader in = new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8);
            while ((numRead = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
                out.append(buffer, 0, numRead);
            }
            String encryptedResponse = out.toString();
            String decryptedResponse = CryptoUtilites.decryptAes((String)encryptedResponse);
            JSONObject rsp = new JSONObject(decryptedResponse);
            String message = "Der Server hat folgende Antwort gesendet:\n\n<b>";
            message = message + rsp.toString(1);
            message = message + "</b>\n\nSoll dies als Lizenzdatei abgespeichert werden?";
            if (this.app.getDialog().showConfirmDialog(message, "Antwort vom Server")) {
                return encryptedResponse;
            }
            return null;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            this.app.getDialog().showErrorDialog("Es ist ein Fehler aufgetreten!", ex);
            return null;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.lblKundenNummer = new JLabel();
        this.jLabel7 = new JLabel();
        this.lblComputerName = new JLabel();
        this.jLabel8 = new JLabel();
        this.scrollActionList = new JScrollPane();
        this.lstAction = new JList();
        this.panelMain = new JPanel();
        this.panelSonderfunktion = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel14 = new JLabel();
        this.fldRandom = new JTextField();
        this.jLabel12 = new JLabel();
        this.fldFeatureCode = new JTextField();
        this.btnFeature = new JButton();
        this.lblEmpty = new JLabel();
        this.panelSonderfunktionCalc = new JPanel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.fldRandomCalc = new JTextField();
        this.jLabel21 = new JLabel();
        this.fldKundennrCalc = new JTextField();
        this.jLabel22 = new JLabel();
        this.fldFeatureCodeFeature = new JComboBox();
        this.btnFeatureCalc = new JButton();
        this.jLabel20 = new JLabel();
        this.fldFeatureCodeCalc = new JTextField();
        this.lblEmpty5 = new JLabel();
        this.panelUploadDatabase = new JPanel();
        this.jLabel10 = new JLabel();
        this.jLabel13 = new JLabel();
        this.fldUrl = new JTextField();
        this.btnUpload = new JButton();
        this.lblEmpty1 = new JLabel();
        this.panelSendProjectInfo = new JPanel();
        this.jLabel11 = new JLabel();
        this.btnUpload1 = new JButton();
        this.btnUpload2 = new JButton();
        this.lblEmpty2 = new JLabel();
        this.panelUploadProject = new JPanel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.fldUrlProject = new JTextField();
        this.btnUpload4 = new JButton();
        this.lblEmpty3 = new JLabel();
        this.panelDebug = new JPanel();
        this.jLabel17 = new JLabel();
        this.lblDebugStatus = new JLabel();
        this.btnDebug = new JButton();
        this.lblEmpty4 = new JLabel();
        this.panelServerCodeCalc = new JPanel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.fldServerUrl = new JTextField();
        this.jLabel28 = new JLabel();
        this.fldServerPassword = new JTextField();
        this.btnCalcServerCode = new JButton();
        this.jLabel30 = new JLabel();
        this.fldServerCode = new JTextField();
        this.btnCalcServerCode1 = new JButton();
        this.jLabel29 = new JLabel();
        this.fldServerUrl1 = new JTextField();
        this.jLabel31 = new JLabel();
        this.fldServerPassword1 = new JTextField();
        this.jLabel32 = new JLabel();
        this.fldServerUUID = new JTextField();
        this.lblEmpty7 = new JLabel();
        this.panelLicenseGeneration = new JPanel();
        this.jLabel33 = new JLabel();
        this.jLabel25 = new JLabel();
        this.fldLicenseKey = new JTextField();
        this.jLabel23 = new JLabel();
        this.fldHardwareId = new JTextField();
        this.jLabel24 = new JLabel();
        this.fldComputerName = new JTextField();
        this.btnGenerateLicenseText = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel1, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel2, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel3, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel4, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel5, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel6, gridBagConstraints);
        this.lblKundenNummer.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblKundenNummer, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.lblKundenNummer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.lblKundenNummer, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel7, gridBagConstraints);
        this.lblComputerName.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblComputerName, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.lblComputerName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.lblComputerName, gridBagConstraints);
        this.jLabel8.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add(this.jLabel8, gridBagConstraints);
        this.scrollActionList.setMinimumSize(new Dimension(100, 100));
        this.lstAction.setFont(THEMIS.fontList);
        this.lstAction.setModel(new DefaultListModel());
        this.lstAction.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SupportTopComponent.this.lstActionValueChanged(evt);
            }
        });
        this.scrollActionList.setViewportView(this.lstAction);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.scrollActionList, gridBagConstraints);
        this.panelMain.setLayout(new CardLayout());
        this.panelSonderfunktion.setLayout(new GridBagLayout());
        this.jLabel9.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktion.add((Component)this.jLabel9, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel14.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktion.add((Component)this.jLabel14, gridBagConstraints);
        this.fldRandom.setEditable(false);
        this.fldRandom.setHorizontalAlignment(0);
        this.fldRandom.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldRandom.text"));
        this.fldRandom.setMinimumSize(new Dimension(100, 25));
        this.fldRandom.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktion.add((Component)this.fldRandom, gridBagConstraints);
        this.jLabel12.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel12.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktion.add((Component)this.jLabel12, gridBagConstraints);
        this.fldFeatureCode.setFont(THEMIS.fontTextfield);
        this.fldFeatureCode.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldFeatureCode.text"));
        this.fldFeatureCode.setMinimumSize(new Dimension(100, 25));
        this.fldFeatureCode.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktion.add((Component)this.fldFeatureCode, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnFeature, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.btnFeature.text"));
        this.btnFeature.setMinimumSize(new Dimension(50, 30));
        this.btnFeature.setPreferredSize(new Dimension(50, 30));
        this.btnFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportTopComponent.this.btnFeatureActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktion.add((Component)this.btnFeature, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.lblEmpty.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelSonderfunktion.add((Component)this.lblEmpty, gridBagConstraints);
        this.panelMain.add((Component)this.panelSonderfunktion, "cardSonderfunktion");
        this.panelSonderfunktionCalc.setLayout(new GridBagLayout());
        this.jLabel18.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel18, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel18.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktionCalc.add((Component)this.jLabel18, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel19, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel19.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktionCalc.add((Component)this.jLabel19, gridBagConstraints);
        this.fldRandomCalc.setHorizontalAlignment(0);
        this.fldRandomCalc.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldRandomCalc.text"));
        this.fldRandomCalc.setMinimumSize(new Dimension(100, 25));
        this.fldRandomCalc.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktionCalc.add((Component)this.fldRandomCalc, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel21, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel21.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktionCalc.add((Component)this.jLabel21, gridBagConstraints);
        this.fldKundennrCalc.setHorizontalAlignment(0);
        this.fldKundennrCalc.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldKundennrCalc.text"));
        this.fldKundennrCalc.setMinimumSize(new Dimension(100, 25));
        this.fldKundennrCalc.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktionCalc.add((Component)this.fldKundennrCalc, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel22, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel22.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktionCalc.add((Component)this.jLabel22, gridBagConstraints);
        this.fldFeatureCodeFeature.setModel(new DefaultComboBoxModel());
        this.fldFeatureCodeFeature.setMinimumSize(new Dimension(200, 30));
        this.fldFeatureCodeFeature.setName("");
        this.fldFeatureCodeFeature.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktionCalc.add(this.fldFeatureCodeFeature, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnFeatureCalc, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.btnFeatureCalc.text"));
        this.btnFeatureCalc.setMinimumSize(new Dimension(50, 30));
        this.btnFeatureCalc.setPreferredSize(new Dimension(50, 30));
        this.btnFeatureCalc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportTopComponent.this.btnFeatureCalcActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktionCalc.add((Component)this.btnFeatureCalc, gridBagConstraints);
        this.jLabel20.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel20, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel20.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktionCalc.add((Component)this.jLabel20, gridBagConstraints);
        this.fldFeatureCodeCalc.setEditable(false);
        this.fldFeatureCodeCalc.setFont(THEMIS.fontTextfield);
        this.fldFeatureCodeCalc.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldFeatureCodeCalc.text"));
        this.fldFeatureCodeCalc.setMinimumSize(new Dimension(100, 25));
        this.fldFeatureCodeCalc.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSonderfunktionCalc.add((Component)this.fldFeatureCodeCalc, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty5, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.lblEmpty5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelSonderfunktionCalc.add((Component)this.lblEmpty5, gridBagConstraints);
        this.panelMain.add((Component)this.panelSonderfunktionCalc, "cardSonderfunktionCalc");
        this.panelUploadDatabase.setLayout(new GridBagLayout());
        this.jLabel10.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUploadDatabase.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel13.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel13.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUploadDatabase.add((Component)this.jLabel13, gridBagConstraints);
        this.fldUrl.setFont(THEMIS.fontTextfield);
        this.fldUrl.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldUrl.text"));
        this.fldUrl.setMinimumSize(new Dimension(100, 25));
        this.fldUrl.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUploadDatabase.add((Component)this.fldUrl, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpload, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.btnUpload.text"));
        this.btnUpload.setMinimumSize(new Dimension(50, 30));
        this.btnUpload.setPreferredSize(new Dimension(50, 30));
        this.btnUpload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportTopComponent.this.btnUploadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUploadDatabase.add((Component)this.btnUpload, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty1, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.lblEmpty1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelUploadDatabase.add((Component)this.lblEmpty1, gridBagConstraints);
        this.panelMain.add((Component)this.panelUploadDatabase, "cardDatenbankSchicken");
        this.panelSendProjectInfo.setLayout(new GridBagLayout());
        this.jLabel11.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel11.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSendProjectInfo.add((Component)this.jLabel11, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpload1, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.btnUpload1.text"));
        this.btnUpload1.setMinimumSize(new Dimension(100, 30));
        this.btnUpload1.setPreferredSize(new Dimension(200, 30));
        this.btnUpload1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportTopComponent.this.btnUpload1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSendProjectInfo.add((Component)this.btnUpload1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpload2, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.btnUpload2.text"));
        this.btnUpload2.setMinimumSize(new Dimension(100, 30));
        this.btnUpload2.setPreferredSize(new Dimension(200, 30));
        this.btnUpload2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportTopComponent.this.btnUpload2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSendProjectInfo.add((Component)this.btnUpload2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty2, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.lblEmpty2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelSendProjectInfo.add((Component)this.lblEmpty2, gridBagConstraints);
        this.panelMain.add((Component)this.panelSendProjectInfo, "cardSendProjectInfo");
        this.panelUploadProject.setLayout(new GridBagLayout());
        this.jLabel15.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel15.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUploadProject.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel16.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel16, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel16.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUploadProject.add((Component)this.jLabel16, gridBagConstraints);
        this.fldUrlProject.setFont(THEMIS.fontTextfield);
        this.fldUrlProject.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldUrlProject.text"));
        this.fldUrlProject.setMinimumSize(new Dimension(100, 25));
        this.fldUrlProject.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUploadProject.add((Component)this.fldUrlProject, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpload4, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.btnUpload4.text"));
        this.btnUpload4.setMinimumSize(new Dimension(50, 30));
        this.btnUpload4.setPreferredSize(new Dimension(50, 30));
        this.btnUpload4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportTopComponent.this.btnUpload4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUploadProject.add((Component)this.btnUpload4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty3, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.lblEmpty3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelUploadProject.add((Component)this.lblEmpty3, gridBagConstraints);
        this.panelMain.add((Component)this.panelUploadProject, "cardUploadProject");
        this.panelDebug.setLayout(new GridBagLayout());
        this.jLabel17.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel17, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel17.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDebug.add((Component)this.jLabel17, gridBagConstraints);
        this.lblDebugStatus.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblDebugStatus, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.lblDebugStatus.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDebug.add((Component)this.lblDebugStatus, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDebug, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.btnDebug.text"));
        this.btnDebug.setMinimumSize(new Dimension(100, 30));
        this.btnDebug.setPreferredSize(new Dimension(200, 30));
        this.btnDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportTopComponent.this.btnDebugActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDebug.add((Component)this.btnDebug, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty4, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.lblEmpty4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelDebug.add((Component)this.lblEmpty4, gridBagConstraints);
        this.panelMain.add((Component)this.panelDebug, "cardDebug");
        this.panelServerCodeCalc.setLayout(new GridBagLayout());
        this.jLabel26.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel26, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel26.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.jLabel26, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel27, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel27.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.jLabel27, gridBagConstraints);
        this.fldServerUrl.setFont(THEMIS.fontLabel);
        this.fldServerUrl.setHorizontalAlignment(2);
        this.fldServerUrl.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldServerUrl.text"));
        this.fldServerUrl.setMinimumSize(new Dimension(100, 25));
        this.fldServerUrl.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.fldServerUrl, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel28, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel28.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.jLabel28, gridBagConstraints);
        this.fldServerPassword.setFont(THEMIS.fontLabel);
        this.fldServerPassword.setHorizontalAlignment(2);
        this.fldServerPassword.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldServerUrl.text"));
        this.fldServerPassword.setMinimumSize(new Dimension(100, 25));
        this.fldServerPassword.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.fldServerPassword, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCalcServerCode, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.btnCalcServerCode.text"));
        this.btnCalcServerCode.setMinimumSize(new Dimension(50, 30));
        this.btnCalcServerCode.setPreferredSize(new Dimension(50, 30));
        this.btnCalcServerCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportTopComponent.this.btnCalcServerCodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.btnCalcServerCode, gridBagConstraints);
        this.jLabel30.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel30, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel30.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.jLabel30, gridBagConstraints);
        this.fldServerCode.setFont(THEMIS.fontTextfield);
        this.fldServerCode.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldServerCode.text"));
        this.fldServerCode.setMinimumSize(new Dimension(100, 25));
        this.fldServerCode.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.fldServerCode, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCalcServerCode1, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.btnCalcServerCode1.text"));
        this.btnCalcServerCode1.setMinimumSize(new Dimension(50, 30));
        this.btnCalcServerCode1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportTopComponent.this.btnCalcServerCode1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.btnCalcServerCode1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel29, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel29.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.jLabel29, gridBagConstraints);
        this.fldServerUrl1.setEditable(false);
        this.fldServerUrl1.setFont(THEMIS.fontLabel);
        this.fldServerUrl1.setHorizontalAlignment(2);
        this.fldServerUrl1.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldServerUrl1.text"));
        this.fldServerUrl1.setEnabled(false);
        this.fldServerUrl1.setMinimumSize(new Dimension(100, 25));
        this.fldServerUrl1.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.fldServerUrl1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel31, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel31.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.jLabel31, gridBagConstraints);
        this.fldServerPassword1.setEditable(false);
        this.fldServerPassword1.setFont(THEMIS.fontLabel);
        this.fldServerPassword1.setHorizontalAlignment(2);
        this.fldServerPassword1.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldServerPassword1.text"));
        this.fldServerPassword1.setMinimumSize(new Dimension(100, 25));
        this.fldServerPassword1.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.fldServerPassword1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel32, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel32.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.jLabel32, gridBagConstraints);
        this.fldServerUUID.setEditable(false);
        this.fldServerUUID.setFont(THEMIS.fontLabel);
        this.fldServerUUID.setHorizontalAlignment(2);
        this.fldServerUUID.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldServerUUID.text"));
        this.fldServerUUID.setEnabled(false);
        this.fldServerUUID.setMinimumSize(new Dimension(100, 25));
        this.fldServerUUID.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelServerCodeCalc.add((Component)this.fldServerUUID, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty7, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.lblEmpty7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelServerCodeCalc.add((Component)this.lblEmpty7, gridBagConstraints);
        this.panelMain.add((Component)this.panelServerCodeCalc, "cardSonderfunktionServerCalc");
        this.panelLicenseGeneration.setLayout(new GridBagLayout());
        this.jLabel33.setFont(THEMIS.fontLabelSmall);
        this.jLabel33.setForeground(new Color(153, 153, 153));
        Mnemonics.setLocalizedText((JLabel)this.jLabel33, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel33.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLicenseGeneration.add((Component)this.jLabel33, gridBagConstraints);
        this.jLabel25.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel25, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel25.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLicenseGeneration.add((Component)this.jLabel25, gridBagConstraints);
        this.fldLicenseKey.setFont(THEMIS.fontTextfield);
        this.fldLicenseKey.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldLicenseKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLicenseGeneration.add((Component)this.fldLicenseKey, gridBagConstraints);
        this.jLabel23.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel23, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel23.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLicenseGeneration.add((Component)this.jLabel23, gridBagConstraints);
        this.fldHardwareId.setFont(THEMIS.fontTextfield);
        this.fldHardwareId.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldHardwareId.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLicenseGeneration.add((Component)this.fldHardwareId, gridBagConstraints);
        this.jLabel24.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel24, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.jLabel24.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLicenseGeneration.add((Component)this.jLabel24, gridBagConstraints);
        this.fldComputerName.setFont(THEMIS.fontTextfield);
        this.fldComputerName.setText(NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.fldComputerName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLicenseGeneration.add((Component)this.fldComputerName, gridBagConstraints);
        this.btnGenerateLicenseText.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnGenerateLicenseText, (String)NbBundle.getMessage(SupportTopComponent.class, (String)"SupportTopComponent.btnGenerateLicenseText.text"));
        this.btnGenerateLicenseText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportTopComponent.this.btnGenerateLicenseTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLicenseGeneration.add((Component)this.btnGenerateLicenseText, gridBagConstraints);
        this.panelMain.add((Component)this.panelLicenseGeneration, "cardGenerateLicenseText");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.panelMain, gridBagConstraints);
    }

    private void btnFeatureActionPerformed(ActionEvent evt) {
        this.enableFeature();
        this.createRandomNumber();
    }

    private void lstActionValueChanged(ListSelectionEvent evt) {
        SupportAction a = this.lstAction.getSelectedValue();
        if (a != null && !evt.getValueIsAdjusting()) {
            a.action();
        }
    }

    private void btnUploadActionPerformed(ActionEvent evt) {
        this.uploadDatabaseFile();
    }

    private void btnUpload1ActionPerformed(ActionEvent evt) {
        this.sendProjectInfoEmail("THEMIS Projektdetails", true, true, true);
    }

    private void btnUpload2ActionPerformed(ActionEvent evt) {
        this.sendIDElogEmail();
    }

    private void btnUpload4ActionPerformed(ActionEvent evt) {
        this.uploadProject();
    }

    private void btnDebugActionPerformed(ActionEvent evt) {
        this.app.setDebug(!this.app.isDebugMode());
        this.updateDebugState();
    }

    private void btnFeatureCalcActionPerformed(ActionEvent evt) {
        Feature f = (Feature)((Object)this.fldFeatureCodeFeature.getSelectedItem());
        int feature = f.getCode();
        int n = Integer.parseInt(this.fldRandomCalc.getText());
        int customer = Integer.parseInt(this.fldKundennrCalc.getText());
        Calendar cal = Calendar.getInstance(this.app.getLocale());
        cal.setTime(new Date());
        int day = cal.get(5);
        int code = customer + day * n;
        int codeEnter = feature + code;
        this.fldFeatureCodeCalc.setText(Integer.toString(codeEnter));
    }

    private void btnCalcServerCodeActionPerformed(ActionEvent evt) {
        String url = this.fldServerUrl.getText();
        String pwd = this.fldServerPassword.getText();
        try {
            JSONObject o = new JSONObject();
            o.put("url", (Object)url).put("pwd", (Object)pwd);
            String code = CryptoUtilites.encryptAes((String)o.toString());
            this.fldServerCode.setText(code);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void btnCalcServerCode1ActionPerformed(ActionEvent evt) {
        String code = this.fldServerCode.getText();
        if (!"".equals(code)) {
            try {
                String server = CryptoUtilites.decryptAes((String)code);
                JSONObject o = new JSONObject(server);
                this.fldServerUrl1.setText(o.getString("url"));
                this.fldServerPassword1.setText(o.getString("pwd"));
                this.fldServerUUID.setText(o.getString("uuid"));
            }
            catch (Exception ex) {
                Dialogs.getInstance().showErrorDialog("Fehler beim entschl\u00fcsseln: " + ex.getMessage());
            }
        }
    }

    private void btnGenerateLicenseTextActionPerformed(ActionEvent evt) {
        File f;
        String licensetext = this.generateLicenseText();
        if (licensetext != null && (f = new ThemisFileDialog("Lizenzdatei", ThemisFileDialog.DIALOGTYPE.SAVE, new File("."), null, new FileNameExtensionFilter("THEMIS Lizenzdatei (*.lic)", "lic"), "lic", false).getSelectedFile()) != null) {
            if (f.isFile()) {
                f.delete();
            }
            try {
                Util.stringToFile((String)licensetext, (File)f);
            }
            catch (IOException ex) {
                Dialogs.getInstance().showErrorDialog("Fehler: " + ex.getLocalizedMessage());
            }
        }
    }

    public void componentOpened() {
        this.createRandomNumber();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    class SupportAction {
        String title;
        String card;

        public SupportAction(String name, String card) {
            this.title = name;
            this.card = card;
        }

        public String toString() {
            return this.title;
        }

        public void action() {
            CardLayout cd = (CardLayout)SupportTopComponent.this.panelMain.getLayout();
            cd.show(SupportTopComponent.this.panelMain, this.card);
            SupportTopComponent.this.panelMain.revalidate();
        }
    }

    public static enum Feature {
        FEATURE_DEACTIVATE_LICENSE("01 Lizenz deaktivieren", 1266),
        FEATURE_SQL_DIALOG("02 SQL Dialog", 1173),
        FEATURE_RESET_PASSWORD("03 Passwort zur\u00fccksetzen", 1032),
        FEATURE_BUGFIX_QUANTITY("04 Bugfix Quantity", 1311),
        FEATURE_ACTIVATE_EMAIL_SYNC("05 E-Mail Sync", 1097),
        FEATURE_DATABASE_DUMP("06 Datenbank Dump", 1066),
        FEATURE_REPAIR_DATABASE("07 Datenbank reparieren", 1722),
        FEATURE_UPDATE_INTERN("08 Update BETA", 1891),
        FEATURE_PROJECT_VOLLVERSION("09 Projekt zu Vollversion hochstufen", 1219),
        FEATURE_PROJECT_BRANDSCHUTZBUCH("10 Projekt zum Brandschutzbuch machen", 1777),
        FEATURE_REMOVE_DOUBLE_FOTO("11 Doppelte Fotos entfernen", 1141),
        FEATURE_EMPTY_TRASH("12 Papierkorb leeren", 1487),
        FEATURE_MAKE_ADMIN("13 Nutzer zum Admin machen", 1316),
        FEATURE_GENERATE_LICENSE("14 Lizenztext erstellen", 1296);

        private final String lbl;
        private final int code;

        private Feature(String l, int c) {
            this.lbl = l;
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return this.lbl;
        }
    }
}

