/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.system;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.filter.ThemisFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StatusBarPanel
extends JPanel
implements ThemisActionListener {
    private static final StatusBarPanel instance = new StatusBarPanel();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/system/Bundle");
    private static final int ACTION_NONE = -1;
    private static final int ACTION_OPEN_PROJECT = 0;
    private static final int ACTION_SEL_EVENT = 1;
    private JLabel lblEvent;
    private JLabel lblFilter;
    private JLabel lblProject;
    private JLabel lblUsername;
    private JLabel lblUsername1;
    private JSeparator sepProject;
    private JSeparator sepProject1;
    private JSeparator sepProject2;

    private StatusBarPanel() {
        this.initComponents();
        this.lblProject.setText(this.bundle.getString("StatusBar.noProject.text"));
        this.lblEvent.setVisible(false);
        ThemisActionProvider.getInstance().register(this);
    }

    public void onAction(ThemisAction action) {
        switch (action.getAction()) {
            case 1: {
                this.setUsername();
                break;
            }
            case 1100: 
            case 1107: {
                ThemisProject p = ThemisApplication.getInstance().getProject();
                this.setEvent();
                this.lblProject.setText(p.isOpen() ? p.getProjectElement().getTitle() : "");
                this.setUsername();
                break;
            }
            case 1101: {
                this.lblEvent.setVisible(false);
                this.lblProject.setText(this.bundle.getString("StatusBar.noProject.text"));
                this.setUsername();
                break;
            }
            case 302: {
                this.setEvent();
                break;
            }
            case 1110: {
                ThemisFilter filter = ThemisApplication.getInstance().getFilter();
                if (filter.isEmpty2()) {
                    this.lblFilter.setText("kein Filter");
                    this.lblFilter.setBackground(Color.LIGHT_GRAY);
                    this.lblFilter.setForeground(Color.DARK_GRAY);
                    this.lblFilter.setOpaque(false);
                    break;
                }
                this.lblFilter.setText("FILTER AKTIV");
                this.lblFilter.setBackground(Color.RED);
                this.lblFilter.setForeground(Color.WHITE);
                this.lblFilter.setOpaque(true);
            }
        }
    }

    JComponent getComponent() {
        return this;
    }

    public void setEvent() {
        CmsEvent event = ThemisApplication.getInstance().getProject().getSelectionManager().getCurrentEvent();
        if (event == null) {
            this.lblEvent.setText(this.bundle.getString("StatusBar.noEvent.text"));
        } else {
            this.lblEvent.setText(event.getTitle());
        }
        this.lblEvent.setVisible(true);
    }

    public void setEventTitle(String eventTitle) {
        this.lblEvent.setText(eventTitle);
    }

    public void setUsername() {
        if (ThemisApplication.getInstance().getProject().isOpen()) {
            String u = ThemisApplication.getInstance().getProject().getUser().getUsername();
            this.lblUsername.setText(u);
        } else {
            this.lblUsername.setText("");
        }
    }

    private void initComponents() {
        this.lblUsername1 = new JLabel();
        this.lblUsername = new JLabel();
        this.sepProject2 = new JSeparator();
        this.lblFilter = new JLabel();
        this.sepProject1 = new JSeparator();
        this.lblEvent = new JLabel();
        this.sepProject = new JSeparator();
        this.lblProject = new JLabel();
        this.setLayout(new GridBagLayout());
        this.lblUsername1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblUsername1, (String)NbBundle.getMessage(StatusBarPanel.class, (String)"StatusBarPanel.lblUsername1.text"));
        this.lblUsername1.setHorizontalTextPosition(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblUsername1, gridBagConstraints);
        this.lblUsername.setFont(new Font("Tahoma", 1, 11));
        this.lblUsername.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblUsername, (String)NbBundle.getMessage(StatusBarPanel.class, (String)"StatusBarPanel.lblUsername.text"));
        this.lblUsername.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblUsername, gridBagConstraints);
        this.sepProject2.setOrientation(1);
        this.sepProject2.setPreferredSize(new Dimension(1, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.sepProject2, gridBagConstraints);
        this.lblFilter.setFont(new Font("Tahoma", 1, 11));
        this.lblFilter.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblFilter, (String)NbBundle.getMessage(StatusBarPanel.class, (String)"StatusBarPanel.lblFilter.text"));
        this.lblFilter.setHorizontalTextPosition(0);
        this.lblFilter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatusBarPanel.this.lblFilterMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblFilter, gridBagConstraints);
        this.sepProject1.setOrientation(1);
        this.sepProject1.setPreferredSize(new Dimension(1, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.sepProject1, gridBagConstraints);
        this.lblEvent.setFont(THEMIS.fontLabel);
        this.lblEvent.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_viewEvent.gif")));
        Mnemonics.setLocalizedText((JLabel)this.lblEvent, (String)NbBundle.getMessage(StatusBarPanel.class, (String)"StatusBarPanel.lblEvent.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblEvent, gridBagConstraints);
        this.sepProject.setOrientation(1);
        this.sepProject.setPreferredSize(new Dimension(1, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.sepProject, gridBagConstraints);
        this.lblProject.setFont(THEMIS.fontLabel);
        this.lblProject.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_showProjectInfo.gif")));
        Mnemonics.setLocalizedText((JLabel)this.lblProject, (String)NbBundle.getMessage(StatusBarPanel.class, (String)"StatusBarPanel.lblProject.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblProject, gridBagConstraints);
    }

    private void lblFilterMouseClicked(MouseEvent evt) {
        ThemisFilter filter = ThemisApplication.getInstance().getFilter();
        if (filter.isEmpty()) {
            filter.reapply();
        } else {
            ThemisApplication.getInstance().getFilter().clearAll(true, (Object)this);
        }
    }

    public static StatusBarPanel getInstance() {
        return instance;
    }
}

