/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.tutorial;

import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.tutorial.AssistantType;
import at.grid.themis.application.tutorial.LicenseStep;
import at.grid.themis.application.tutorial.ReportStep;
import at.grid.themis.application.tutorial.SpeechBubble;
import at.grid.themis.application.tutorial.Step;
import at.grid.themis.application.tutorial.StepInterface;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class Assistant
implements ThemisActionListener {
    public static Assistant INSTANCE = new Assistant();
    private AssistantType assistantType = null;
    private JDialog currentPopup;
    private WindowFocusListener focusListener;
    private Component currentComponent;
    private StepInterface currentStep = Step.CREATE_PROJECT;
    private ActionListener hideAction;
    private ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/tutorial/Bundle");

    public static Assistant getInstance() {
        return INSTANCE;
    }

    private Assistant() {
        ThemisActionProvider.getInstance().register(this);
    }

    public void setNextStep(Component component, StepInterface nextStep) {
        if (this.hideAction != null) {
            this.hideAction.actionPerformed(null);
        }
        this.currentStep = nextStep;
        this.currentComponent = component;
    }

    public void setNextStep(StepInterface nextStep) {
        this.setNextStep(null, nextStep);
    }

    public void show(Component component, final StepInterface nextStep) {
        try {
            if (this.assistantType == null) {
                return;
            }
            if (component == null || nextStep == null) {
                return;
            }
            if (nextStep.getAssistantType() != this.assistantType) {
                return;
            }
            if (this.hideAction != null) {
                this.hideAction.actionPerformed(null);
            }
            this.currentComponent = component;
            this.currentStep = nextStep;
            final Point pt = component.getLocationOnScreen();
            if (nextStep.getAlignment() == 1) {
                pt.x += component.getWidth() / 2;
                pt.y += 10;
            } else if (nextStep.getAlignment() == 3) {
                pt.x += component.getWidth() + 5;
                pt.y += component.getHeight() / 2;
            } else if (nextStep.getAlignment() == 0) {
                pt.x += component.getWidth() / 2;
                pt.y += component.getHeight() / 2;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Assistant.this.currentPopup != null) {
                        Frame tc = WindowManager.getDefault().getMainWindow();
                        if (tc != null) {
                            tc.removeWindowFocusListener(Assistant.this.focusListener);
                        }
                        Assistant.this.currentPopup.dispose();
                    }
                    Assistant.this.currentPopup = Assistant.this.createMessagePopup(pt.x, pt.y, nextStep);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        if (this.hideAction != null) {
            this.hideAction.actionPerformed(null);
        }
        this.assistantType = null;
        this.currentStep = null;
        this.currentComponent = null;
    }

    public void start(AssistantType assistantType) {
        this.reset();
        this.assistantType = assistantType;
        if (null != assistantType) {
            switch (assistantType) {
                case THEMIS_ASSISTANT: {
                    this.currentStep = Step.CREATE_PROJECT;
                    ViewHelper.showStartScreen();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    break;
                }
                case REPORT_ASSISTANT: {
                    this.currentStep = ReportStep.SELECT_TYPE;
                    break;
                }
                case LICENSE_ASSISTANT: {
                    this.currentStep = LicenseStep.ENTER_LICENSE_KEY;
                }
            }
        }
    }

    private JDialog createMessagePopup(int x, int y, StepInterface nextStep) {
        final JDialog dialog = new JDialog();
        dialog.setUndecorated(true);
        dialog.getContentPane().setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        dialog.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        final Frame tc = WindowManager.getDefault().getMainWindow();
        if (tc != null) {
            this.focusListener = new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    if (!dialog.isVisible()) {
                        dialog.setVisible(true);
                    }
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    Window op = e.getOppositeWindow();
                    if (op == dialog) {
                        tc.requestFocus();
                    } else {
                        dialog.setVisible(false);
                    }
                }
            };
            tc.addWindowFocusListener(this.focusListener);
        }
        SpeechBubble panel = new SpeechBubble();
        panel.setBackground(Color.WHITE);
        panel.setTitle(this.bundle.getString(nextStep.getKeyTitle()));
        panel.setMessage(this.bundle.getString(nextStep.getKeyMessage()));
        panel.setCloseAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
                if (tc != null) {
                    tc.removeWindowFocusListener(Assistant.this.focusListener);
                }
                Assistant.this.reset();
            }
        });
        panel.setHideAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
                if (tc != null) {
                    tc.removeWindowFocusListener(Assistant.this.focusListener);
                }
            }
        });
        this.hideAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
                if (tc != null) {
                    tc.removeWindowFocusListener(Assistant.this.focusListener);
                }
                Assistant.this.hideAction = null;
            }
        };
        dialog.add(panel);
        dialog.setDefaultCloseOperation(0);
        dialog.setAlwaysOnTop(true);
        dialog.setLocation(x, y);
        dialog.setFocusable(false);
        dialog.setFocusableWindowState(false);
        dialog.setModal(false);
        dialog.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        dialog.pack();
        dialog.setVisible(true);
        return dialog;
    }

    public void onAction(ThemisAction action) {
    }

    public void showNextStep() {
        if (this.currentComponent != null) {
            this.show(this.currentComponent, this.currentStep);
        }
    }

    public boolean isShowTHEMISAssistant() {
        return this.isShowAssistant(AssistantType.THEMIS_ASSISTANT);
    }

    public boolean isShowAssistant(AssistantType assistantType) {
        return this.assistantType == assistantType;
    }
}

