/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.ui;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.application.welcome.ThemisWelcomeTopComponent;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DirectoryTreePanel
extends JPanel {
    private static final Logger logger = ThemisApplication.getLogger();
    private final FileSystemView fileSystemView;
    private final TreeSelectionListener treeSelectionListener;
    private final MouseAdapter treeMouseListener;
    private final TreeExpansionListener treeExpansionListener;
    private DefaultMutableTreeNode root;
    private DefaultTreeModel treeModel;
    private ThemisWelcomeTopComponent welcome;
    private DefaultTreeCellRenderer renderer;
    private File rootFolder;
    private boolean disableSelectionListener = false;
    private ArrayList<TreePath> treestate = new ArrayList();
    private JButton btnRefresh;
    private JButton btnSelectRootFolder;
    private JPanel jPanel6;
    private JScrollPane scroll;
    private JTree tree;

    public DirectoryTreePanel(File rootFolder, DefaultTreeCellRenderer renderer, ThemisWelcomeTopComponent parent) {
        this.welcome = parent;
        this.renderer = renderer;
        this.rootFolder = rootFolder;
        this.root = new DefaultMutableTreeNode();
        this.root.setUserObject(rootFolder);
        this.treeModel = new DefaultTreeModel(this.root);
        this.initComponents();
        this.tree.setEditable(false);
        this.treeSelectionListener = evt -> {
            if (this.disableSelectionListener) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
            try {
                this.showChildren(node, evt.getPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            File f = (File)node.getUserObject();
            if (this.welcome != null && f != null) {
                ThemisApplication.getInstance().setCurrentFolder(f);
                this.welcome.setIncludeSubfolder(false);
                this.welcome.showSelectedFolder(new ThemisFolder(f));
            }
        };
        this.treeMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TreePath selPath;
                if (evt.getButton() == 3 && (selPath = DirectoryTreePanel.this.tree.getPathForLocation(evt.getX(), evt.getY())) != null) {
                    Object clickTargetNode = selPath.getLastPathComponent();
                    Object clickTarget = ((DefaultMutableTreeNode)clickTargetNode).getUserObject();
                    Point pos = evt.getPoint();
                    DirectoryTreePanel.this.createRightClickMenu(selPath, clickTarget, pos);
                }
            }
        };
        this.treeExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
                DirectoryTreePanel.this.disableSelectionListener = true;
                DirectoryTreePanel.this.tree.setSelectionPath(evt.getPath());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
                if (DirectoryTreePanel.this.welcome != null) {
                    DirectoryTreePanel.this.welcome.showSelectedFolder(new ThemisFolder((File)node.getUserObject()));
                }
                DirectoryTreePanel.this.disableSelectionListener = false;
            }

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
            }
        };
        this.fileSystemView = FileSystemView.getFileSystemView();
        this.initialise(rootFolder);
    }

    private void initialise(File f) {
        this.tree.setRootVisible(true);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.tree.addMouseListener(this.treeMouseListener);
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
        this.tree.setCellRenderer(this.renderer);
        this.tree.setRowHeight(THEMIS.fontListBig.getSize() * 2);
        this.tree.setFont(THEMIS.fontListBig);
        this.showChildren(this.root, new TreePath(this.root));
    }

    public void clearSelection() {
        this.disableSelectionListener = true;
        this.tree.clearSelection();
        this.disableSelectionListener = false;
    }

    private void createRightClickMenu(TreePath path, Object clickTarget, Point evtPos) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        if (clickTarget == null) {
            return;
        }
        if (clickTarget instanceof File) {
            JMenuItem item = THEMIS.createMenuItem("Unterordner anlegen", Color.WHITE, false, null);
            item.addActionListener(e -> {
                if (clickTarget instanceof File) {
                    this.createFolder(path, (File)clickTarget);
                }
            });
            items.add(item);
            item = THEMIS.createMenuItem("Als Stammordner w\u00e4hlen", Color.WHITE, false, null);
            item.addActionListener(e -> {
                if (clickTarget instanceof File) {
                    this.setThemisRootFolder((File)clickTarget);
                }
            });
            items.add(item);
            item = THEMIS.createMenuItem("In Explorer zeigen", Color.WHITE, false, null);
            item.addActionListener(e -> {
                if (clickTarget instanceof File) {
                    this.showInExplorer((File)clickTarget);
                }
            });
            items.add(item);
        }
        JPopupMenu menu = new JPopupMenu("Optionen");
        for (JMenuItem item : items) {
            menu.add(item);
        }
        Point pt0 = SwingUtilities.convertPoint(this.tree, evtPos, this);
        menu.show(this, pt0.x, pt0.y);
    }

    private void showInExplorer(File f) {
        if (f == null || !f.isDirectory()) {
            return;
        }
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createFolder(TreePath currPath, File parentFolder) {
        File newFile = null;
        try {
            String fn = ThemisApplication.getInstance().getDialog().showInputDialog("Ordnername", "Neuen Ordner anlegen");
            if (fn == null || fn.trim().isEmpty()) {
                return;
            }
            if (ThemisProject.isProjectFolder((File)parentFolder)) {
                ThemisApplication.getInstance().getDialog().showErrorDialog("Der Ordner kann nicht erstellt werden.");
                return;
            }
            newFile = parentFolder == null ? new File(this.rootFolder, fn) : new File(parentFolder, fn);
            newFile.mkdirs();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currPath.getLastPathComponent();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(newFile, true);
            parentNode.add(node);
            ArrayList<TreeNode> nodeList = Collections.list(parentNode.children());
            Collections.sort(nodeList, (o1, o2) -> {
                File f1 = (File)o1.getUserObject();
                File f2 = (File)o2.getUserObject();
                return f1.getName().compareToIgnoreCase(f2.getName());
            });
            parentNode.removeAllChildren();
            for (DefaultMutableTreeNode defaultMutableTreeNode : nodeList) {
                parentNode.add(defaultMutableTreeNode);
            }
            this.treeModel.nodeStructureChanged(parentNode);
        }
        catch (Exception ex) {
            logger.severe("Cannot create folder '" + newFile + "' " + ex.getMessage());
            ThemisApplication.getInstance().getDialog().showErrorDialog("Der Ordner kann nicht erstellt werden.", ex);
        }
    }

    private boolean isDirectory(File f) {
        return f != null && f.isDirectory() && !ThemisProject.isProjectFolder((File)f);
    }

    public DefaultMutableTreeNode getSelectedNode() {
        DefaultMutableTreeNode node = null;
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            node = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        return node;
    }

    private void showChildren(DefaultMutableTreeNode node, TreePath path) {
        logger.info("Showing children for " + node.getUserObject());
        if (node.getUserObject() instanceof File) {
            ThemisTaskWithDialog.createTask("Verzeichnis wird geladen", a -> {
                File file = (File)node.getUserObject();
                if (this.isDirectory(file)) {
                    node.removeAllChildren();
                    File[] files = this.fileSystemView.getFiles(file, true);
                    Arrays.sort(files, (o1, o2) -> o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase()));
                    for (File child : files) {
                        if (!this.isDirectory(child)) continue;
                        node.add(new DefaultMutableTreeNode(child));
                    }
                }
                this.tree.expandPath(path);
                this.treeModel.nodeStructureChanged(node);
            });
        }
    }

    private void chooseNewRootFolder() {
        File f = new ThemisFileDialog("Stammordner w\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, this.rootFolder, null, null, null, false).getSelectedFile();
        if (f != null) {
            if (ThemisProject.isProjectFolder((File)f)) {
                ThemisApplication.getInstance().getDialog().showWarningDialog("Achtung der ausgew\u00e4hlte Stammordner ist ein THEMIS Projekt. Es wurde der dar\u00fcberliegende Ordner als Stammordner gesetzt.");
                f = f.getParentFile();
            }
            this.setThemisRootFolder(f);
        }
    }

    private void setThemisRootFolder(File f) {
        if (f != null && f.isDirectory()) {
            this.rootFolder = f;
            ThemisApplication.getInstance().getSettings().getFolderProjectRoot().setValue(f);
            this.root.setUserObject(f);
        }
        this.root.removeAllChildren();
        this.showChildren(this.root, new TreePath(this.root));
        if (this.welcome != null) {
            this.welcome.setIncludeSubfolder(false);
            this.welcome.populateProjectListFromFolder(new ThemisFolder(f));
        }
    }

    private void showChildren2(final DefaultMutableTreeNode node, final TreePath path) {
        logger.info("Showing children for " + node.getUserObject());
        SwingWorker<Void, File> worker = new SwingWorker<Void, File>(){

            @Override
            public Void doInBackground() {
                File file;
                if (node.getUserObject() instanceof File && DirectoryTreePanel.this.isDirectory(file = (File)node.getUserObject())) {
                    File[] files = DirectoryTreePanel.this.fileSystemView.getFiles(file, true);
                    logger.info("Found " + files.length + " files at " + file.getAbsolutePath());
                    node.removeAllChildren();
                    if (node.isLeaf()) {
                        for (File child : files) {
                            if (!DirectoryTreePanel.this.isDirectory(child)) continue;
                            this.publish(child);
                        }
                    }
                }
                return null;
            }

            @Override
            protected void process(List<File> chunks) {
                for (File child : chunks) {
                    DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
                    node.add(childNode);
                }
            }

            @Override
            protected void done() {
                DirectoryTreePanel.this.tree.expandPath(path);
                DirectoryTreePanel.this.treeModel.nodeStructureChanged(node);
            }
        };
        worker.execute();
    }

    private void deleteFolder(ThemisFolder fld) {
        if (!fld.isEmpty()) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("Der Ornder ist nicht leer und kann nicht gel\u00f6scht werden!");
            return;
        }
        if (ThemisApplication.getInstance().getDialog().showConfirmDialog("Soll der Ordner '" + fld.getFolderName() + "' wirklich gel\u00f6scht werden", "Ordner l\u00f6schen")) {
            fld.getProjectFolder().delete();
            this.treeModel.nodeStructureChanged(this.root);
        }
    }

    private TreePath getPath(File f) {
        int rowCount = this.tree.getRowCount();
        for (int ii = 0; ii < rowCount - 1; ++ii) {
            Object u;
            TreePath p = this.tree.getPathForRow(ii);
            Object o = p.getLastPathComponent();
            if (!(o instanceof DefaultMutableTreeNode) || (u = ((DefaultMutableTreeNode)o).getUserObject()) != f) continue;
            return p;
        }
        return null;
    }

    private void storeTreeState() {
        this.treestate.clear();
        int rowCount = this.tree.getRowCount();
        for (int ii = 0; ii < rowCount - 1; ++ii) {
            TreePath nextPath;
            TreePath currPath = this.tree.getPathForRow(ii);
            if (!currPath.isDescendant(nextPath = this.tree.getPathForRow(ii + 1))) continue;
            this.treestate.add(currPath);
        }
    }

    private void restoreTreeState() {
        this.tree.expandPath(new TreePath(this.root.getPath()));
        this.treestate.forEach(p -> this.tree.expandPath((TreePath)p));
    }

    private void initComponents() {
        this.scroll = new JScrollPane();
        this.tree = new JTree();
        this.jPanel6 = new JPanel();
        this.btnSelectRootFolder = new JButton();
        this.btnRefresh = new JButton();
        this.setLayout(new BorderLayout());
        this.tree.setModel(this.treeModel);
        this.scroll.setViewportView(this.tree);
        this.add((Component)this.scroll, "Center");
        this.jPanel6.setBackground(new Color(255, 255, 255));
        this.jPanel6.setLayout(new GridBagLayout());
        this.btnSelectRootFolder.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectRootFolder, (String)NbBundle.getMessage(DirectoryTreePanel.class, (String)"DirectoryTreePanel.btnSelectRootFolder.text"));
        this.btnSelectRootFolder.setToolTipText(NbBundle.getMessage(DirectoryTreePanel.class, (String)"DirectoryTreePanel.btnSelectRootFolder.toolTipText"));
        this.btnSelectRootFolder.setBorder(new SoftBevelBorder(0));
        this.btnSelectRootFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryTreePanel.this.btnSelectRootFolderActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnSelectRootFolder, gridBagConstraints);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/refresh24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRefresh, (String)NbBundle.getMessage(DirectoryTreePanel.class, (String)"DirectoryTreePanel.btnRefresh.text"));
        this.btnRefresh.setToolTipText(NbBundle.getMessage(DirectoryTreePanel.class, (String)"DirectoryTreePanel.btnRefresh.toolTipText"));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryTreePanel.this.btnRefreshActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnRefresh, gridBagConstraints);
        this.add((Component)this.jPanel6, "South");
    }

    private void btnSelectRootFolderActionPerformed(ActionEvent evt) {
        this.chooseNewRootFolder();
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        ThemisProject.clearProjectFolderAnalysis();
        File f = new File(this.rootFolder.getAbsolutePath());
        this.rootFolder = null;
        this.setThemisRootFolder(f);
    }
}

