/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.ui;

import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;

public class IconElementCellRenderer
extends DefaultListCellRenderer {
    ImageIcon emptyIcon = new ImageIcon(new BufferedImage(35, 35, 2));
    boolean withIcon = true;

    public IconElementCellRenderer() {
        this.setHorizontalTextPosition(4);
        this.setHorizontalAlignment(2);
    }

    public IconElementCellRenderer(boolean withIcon) {
        this.withIcon = withIcon;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            if (value instanceof CmsBasicElement) {
                CmsBasicElement item = (CmsBasicElement)value;
                this.setText(item.getTitle());
                String fn = item.getAttribute("file");
                if (this.withIcon) {
                    this.setIconFromFilename(fn);
                }
            } else if (value instanceof CmsElementSummary) {
                CmsElementSummary item = (CmsElementSummary)value;
                this.setText(item.getTitle());
                String fn = item.getIconFile();
                if (this.withIcon) {
                    this.setIconFromFilename(fn);
                }
            } else {
                this.setText("<unbekannt>");
            }
            this.setFont(THEMIS.fontListBig);
            this.setEnabled(true);
            if (isSelected) {
                this.setBackground(THEMIS.COLOR_LIST_SELECTION_BG);
                this.setForeground(THEMIS.COLOR_LIST_SELECTION_FG);
            } else {
                this.setBackground(THEMIS.COLOR_LIST_BG);
                this.setForeground(THEMIS.COLOR_LIST_FG);
            }
            this.setBorder(new EmptyBorder(3, 3, 3, 3));
        }
        return this;
    }

    protected void setIconFromFilename(String fn) {
        block5: {
            if (fn != null) {
                try {
                    File iconFile = ThemisApplication.getInstance().getProject().getUploadFile("icon", fn);
                    if (iconFile.exists() && iconFile.isFile()) {
                        BufferedImage img = ImageHelper.loadImage((File)iconFile);
                        this.setIcon(new ImageIcon(Util.resizeImage((BufferedImage)img, (int)35, (int)35)));
                        break block5;
                    }
                    BufferedImage img = ImageHelper.loadImage((URL)this.getClass().getResource(fn));
                    this.setIcon(new ImageIcon(Util.resizeImage((BufferedImage)img, (int)35, (int)35, (int)2)));
                }
                catch (Exception ex) {
                    this.setIcon(this.emptyIcon);
                }
            } else {
                this.setIcon(this.emptyIcon);
            }
        }
    }
}

