/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.ui;

import at.grid.themis.ontology.interfaces.IconItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class IconItemRenderer
extends DefaultListCellRenderer {
    private Map<String, ImageIcon> iconMap = new HashMap<String, ImageIcon>();
    private static final IconItemRenderer INSTANCE = new IconItemRenderer();
    private static final IconItemRenderer INSTANCE_NOBORDER = new IconItemRenderer(false);
    boolean withBorder = true;

    public static IconItemRenderer getInstance() {
        return INSTANCE;
    }

    public static IconItemRenderer getInstanceNoBorder() {
        return INSTANCE_NOBORDER;
    }

    private IconItemRenderer() {
        this.iconMap.put("key_empty", new ImageIcon(new BufferedImage(16, 16, 2)));
        this.iconMap.put("key_import", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/import.png")));
        this.iconMap.put("key_export", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/export.png")));
        this.iconMap.put("key_export_zip", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_zip_export.gif")));
        this.iconMap.put("key_duplicate", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy.gif")));
        this.iconMap.put("key_delete", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove.gif")));
        this.iconMap.put("key_add", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2.gif")));
        this.iconMap.put("key_add_folder", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_createProject.gif")));
        this.iconMap.put("key_rename", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_editObs.gif")));
        this.iconMap.put("key_time", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_viewEvent.gif")));
        this.iconMap.put("key_date", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/calendar.gif")));
        this.iconMap.put("key_barcode", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/qr-code.gif")));
        this.iconMap.put("key_text", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/text.gif")));
        this.iconMap.put("key_checkbox", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_selectAllObs.gif")));
        this.iconMap.put("key_list", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/view-details.gif")));
        this.iconMap.put("key_person", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/contacts.gif")));
        this.iconMap.put("key_image", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/photo.gif")));
        this.iconMap.put("key_plan", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/locateInPlan.gif")));
        this.iconMap.put("key_gps", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/marker-16.gif")));
        this.iconMap.put("key_number", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/number.png")));
        this.iconMap.put("key_measure", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/measure.png")));
        this.iconMap.put("key_sum", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/sum.png")));
        this.iconMap.put("key_assessment", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/assessment.png")));
        this.iconMap.put("key_file", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/document.png")));
        this.iconMap.put("key_icon", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/icon.png")));
        this.iconMap.put("key_group", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/group.png")));
        this.iconMap.put("key_prefix_suffix", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/prefixsuffix.png")));
        this.iconMap.put("key_lock", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/lock.gif")));
        this.iconMap.put("key_seal", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/signature.gif")));
        this.iconMap.put("key_unlock", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/unlock.gif")));
        this.iconMap.put("key_merge", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/merge.png")));
        this.iconMap.put("key_cal_add", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/calendar_add.png")));
        this.iconMap.put("key_cal_del", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/calendar_remove.png")));
        this.iconMap.put("key_rotate_right", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_rotateCW-16.gif")));
        this.iconMap.put("key_rotate_left", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/rotate-16.gif")));
        this.iconMap.put("key_up", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up_16.gif")));
        this.iconMap.put("key_down", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down_16.gif")));
        this.iconMap.put("key_plan_change", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/layers-16.gif")));
        this.iconMap.put("key_add_list", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add-list-16.gif")));
        this.iconMap.put("key_clear_list", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/wipe.png")));
        this.iconMap.put("key_stats", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/chart.png")));
        this.iconMap.put("key_report", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/exel-16.gif")));
        this.iconMap.put("key_building", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/home-16.gif")));
        this.iconMap.put("key_trash", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/trash.png")));
        this.iconMap.put("key_checklist", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/checklist16.gif")));
        this.iconMap.put("key_status_open", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_filterMangel_1.gif")));
        this.iconMap.put("key_status_done", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm.gif")));
        this.iconMap.put("key_copy", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy.gif")));
        this.iconMap.put("key_checkout", new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/checkout.gif")));
    }

    private IconItemRenderer(boolean withBorder) {
        this.withBorder = withBorder;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel lbl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        lbl.setBorder(this.withBorder && isSelected ? BorderFactory.createLineBorder(Color.GRAY, 3) : BorderFactory.createEmptyBorder(3, 3, 3, 3));
        IconItem act = (IconItem)value;
        if (act != null) {
            int c;
            lbl.setText(act.toString());
            ImageIcon icon = this.iconMap.getOrDefault(act.getIconKey(), null);
            if (icon != null) {
                lbl.setIcon(icon);
            }
            if ((c = act.getForegroundColor()) != -1) {
                lbl.setForeground(new Color(c));
            }
            if ((c = act.getBackgroundColor()) != -1) {
                lbl.setBackground(new Color(c));
            }
        } else {
            lbl.setText("");
        }
        return lbl;
    }
}

