/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.ui;

import at.grid.themis.application.ui.CheckBoxCellRenderer;
import at.grid.themis.application.ui.CheckableItem;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicComboPopup;

public class JComboCheckBox<E extends CheckableItem>
extends JComboBox<E> {
    private boolean shouldntClose;
    private transient ActionListener listener;

    public JComboCheckBox() {
    }

    public JComboCheckBox(E[] m) {
        super(m);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 20);
    }

    @Override
    public void updateUI() {
        this.setRenderer(null);
        this.removeActionListener(this.listener);
        super.updateUI();
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getModifiers() == 16) {
                    JComboCheckBox.this.updateItem(JComboCheckBox.this.getSelectedIndex());
                    JComboCheckBox.this.shouldntClose = true;
                }
            }
        };
        this.setRenderer(new CheckBoxCellRenderer());
        this.addActionListener(this.listener);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "space-key-select");
        this.getActionMap().put("space-key-select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("JComboBox#getSelectedIndex()" + JComboCheckBox.this.getSelectedIndex());
                Accessible a = JComboCheckBox.this.getAccessibleContext().getAccessibleChild(0);
                if (a instanceof BasicComboPopup) {
                    BasicComboPopup pop = (BasicComboPopup)a;
                    int i = pop.getList().getSelectedIndex();
                    System.out.println("JList#getSelectedIndex() " + i);
                    JComboCheckBox.this.updateItem(i);
                }
            }
        });
    }

    private void updateItem(int index) {
        if (this.isPopupVisible()) {
            CheckableItem item = (CheckableItem)this.getItemAt(index);
            item.selected ^= true;
            this.removeItemAt(index);
            this.insertItemAt(item, index);
            this.setSelectedItem(item);
        }
    }

    @Override
    public void setPopupVisible(boolean v) {
        if (this.shouldntClose) {
            this.shouldntClose = false;
            return;
        }
        super.setPopupVisible(v);
    }
}

