/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.ui;

import at.grid.themis.application.api.Dialogs;
import at.grid.util.Util;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class ThemisDropTargetListener
implements DropTargetListener {
    boolean allowMultipleFiles = false;
    boolean allowFolder = false;
    ArrayList<String> fileextensions = new ArrayList();

    public ThemisDropTargetListener(boolean allowMultiple, boolean allowFolder) {
        this.allowMultipleFiles = allowMultiple;
        this.allowFolder = allowFolder;
    }

    public ThemisDropTargetListener(boolean allowMultiple, boolean allowFolder, String ... ext) {
        this.allowMultipleFiles = allowMultiple;
        this.allowFolder = allowFolder;
        for (String e : ext) {
            this.fileextensions.add(e.toLowerCase());
        }
    }

    public abstract void dropFileAction(File var1, DropTargetDropEvent var2);

    public boolean dropFileAction(List<File> files, DropTargetDropEvent event) {
        return false;
    }

    public boolean dropAction(Object transferData, DropTargetDropEvent event) {
        return false;
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        DataFlavor[] flavors;
        event.acceptDrop(1);
        Transferable transferable = event.getTransferable();
        for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
            try {
                Object transferData = transferable.getTransferData(flavor);
                if (this.dropAction(transferData, event) || !flavor.isFlavorJavaFileListType()) continue;
                List files = (List)transferData;
                if (!this.allowMultipleFiles && files.size() > 1) {
                    Dialogs.getInstance().showErrorDialog("error.drop-only-single-file");
                    return;
                }
                if (this.dropFileAction(files, event)) continue;
                for (File f : files) {
                    if (this.fileextensions.isEmpty() || this.fileextensions.contains(Util.getFileExtension((File)f).toLowerCase())) {
                        if (this.allowFolder || f.isFile()) {
                            this.dropFileAction(f, event);
                            continue;
                        }
                        Dialogs.getInstance().showErrorDialog("error.no-file-or-not-allowed");
                        continue;
                    }
                    Dialogs.getInstance().showErrorDialog("error.file-type-not-supported", String.join((CharSequence)",", this.fileextensions));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        event.dropComplete(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }
}

