/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.ui;

import at.grid.themis.application.THEMIS;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import java.awt.Dimension;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class ThemisPanel
extends JPanel {
    public ThemisApplication app = ThemisApplication.getInstance();
    public ThemisProject project = this.app.getProject();
    public ThemisSettings settings = this.app.getSettings();
    private boolean uiUpdating = false;
    private Status status;
    private boolean dontShow = false;

    public boolean isUIupdating() {
        return this.uiUpdating;
    }

    public void setUIupdating(boolean flg) {
        this.uiUpdating = flg;
    }

    public void setStatus(Status s) {
        this.status = s;
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setDontShow() {
        this.dontShow = true;
    }

    public void populate() {
        this.populate((ProgressHandler)new DefaultProgressHandler());
    }

    public abstract void populate(ProgressHandler var1);

    public abstract void apply();

    public abstract Dimension getPanelMinimumSize();

    public String getDialogCode() {
        return this.getClass().getSimpleName();
    }

    public Dimension getPanelSize() {
        return this.getPanelMinimumSize();
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(ThemisApplication.getInstance().getProject().getResourceText("dialog." + this.getDialogCode() + ".title"), this, true, true);
        THEMIS.applyWindowSizeAndLocation(this.getDialogCode(), dlg, this.getPanelSize(), this.getPanelMinimumSize());
        dlg.setMinimumSize(this.getPanelMinimumSize());
        this.populate();
        if (this.dontShow) {
            JDialog parent = (JDialog)this.getRootPane().getParent();
            parent.dispose();
        } else {
            dlg.setVisible(true);
        }
    }

    public void closeDialog() {
        JDialog parent = (JDialog)this.getRootPane().getParent();
        Dimension dlgSize = parent.getSize();
        THEMIS.saveWindowSizeAndLocation(this.getDialogCode(), parent);
        parent.dispose();
    }

    public static enum Status {
        OK,
        CANCEL;

    }
}

