/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.ui.attributes;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.SearchResult;
import at.grid.ontology.swing.CmsElementSwing;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.files.UploadItemFilePanel;
import at.grid.themis.application.ui.attributes.AbstractAttributePanel;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DocumentAttributePanel
extends AbstractAttributePanel {
    private JButton btnAddDocument;
    private JButton btnEditDocument;
    private JButton btnRemoveDocument;
    private JComboBox fldDocumentLibrary;
    private JComboBox fldDocumentLibraryType;
    private JScrollPane jScrollPane12;
    private JList lstDocuments;

    public DocumentAttributePanel(CmsElement element) {
        super(element);
        this.initComponents();
        this.populate();
    }

    @Override
    public void populate() {
        this.fldDocumentLibraryType.setModel(CmsElementSwing.getComboBoxModel(this.project.getKeytable("documenttype"), this.project.getUser().getCurrentLanguage(), true, "-"));
        this.loadDocumentLibrary();
    }

    @Override
    public void apply() {
    }

    @Override
    public void setAllowEdit(boolean flg) {
        this.allowEdit = flg;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    protected void updateComponentVisibility() {
        this.btnAddDocument.setEnabled(this.allowEdit && this.fldDocumentLibrary.getSelectedItem() != null);
        boolean hasDocumentSelected = this.lstDocuments.getSelectedIndex() >= 0;
        this.btnEditDocument.setEnabled(this.allowEdit && hasDocumentSelected);
        this.btnRemoveDocument.setEnabled(this.allowEdit && hasDocumentSelected);
    }

    private void loadDocumentLibrary() {
        if (this.project != null && this.project.isOpen()) {
            RelationAttribute infoAttribute = this.element.getRelationAttribute("infos");
            List infoIds = infoAttribute.getElementIds();
            List infos = infoAttribute.getElements();
            ((DefaultListModel)this.lstDocuments.getModel()).removeAllElements();
            ((DefaultComboBoxModel)this.fldDocumentLibrary.getModel()).removeAllElements();
            for (CmsElementSummary ele : infos) {
                if (ele.isTrash()) continue;
                ((DefaultListModel)this.lstDocuments.getModel()).addElement(ele);
            }
            CmsElement info = this.project.getDefaultElement("info");
            CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("info");
            s.addSelectMeta();
            s.addSelectAttribute(info.getAttribute("hasfiles"));
            s.setSort("el.title");
            if (this.fldDocumentLibraryType != null && this.fldDocumentLibraryType.getSelectedIndex() > 0) {
                long keyId = ((KeytableRecord)this.fldDocumentLibraryType.getSelectedItem()).id;
                s.addWhere("ele.iddocumenttype=" + keyId);
            }
            SearchResult result = s.search();
            ArrayList recs = result.getResultAsElementSummary();
            for (CmsElementSummary rec : recs) {
                if (infoIds.contains(rec.getId())) continue;
                ((DefaultComboBoxModel)this.fldDocumentLibrary.getModel()).addElement(rec);
            }
        }
    }

    private void addDocument(File f) {
        CmsInfo info = (CmsInfo)this.project.createElement("info");
        info.getUploadAttribute("files").addUpload(f);
        String title = Util.getFileNameWithoutExtension((File)f);
        info.setAttributeValue("title", title);
        info.save();
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.INFORMATION_SAVED);
        this.changed = true;
        this.element.getRelationAttribute("infos").add((CmsElement)info);
        ((DefaultListModel)this.lstDocuments.getModel()).addElement(new CmsElementSummary((CmsElement)info));
    }

    private void openSelectedDocument(JList list) {
        try {
            CmsElementSummary selectedItem = (CmsElementSummary)list.getSelectedValue();
            CmsInfo info = (CmsInfo)this.project.loadElement(selectedItem.getId(), this.project.getUser());
            List uploadItems = info.getUploadAttribute("files").getUploadItems();
            if (uploadItems.size() == 1) {
                Desktop dt = Desktop.getDesktop();
                dt.open(new File(((UploadItem)uploadItems.get(0)).getAbsolutePath()));
            } else if (uploadItems.size() > 1) {
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.moreThanOneDoc.text"));
            } else if (uploadItems.isEmpty()) {
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.noDocumentAssigned.text"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.fldDocumentLibraryType = new JComboBox();
        this.fldDocumentLibrary = new JComboBox();
        this.btnAddDocument = new JButton();
        this.jScrollPane12 = new JScrollPane();
        this.lstDocuments = new JList();
        this.btnRemoveDocument = new JButton();
        this.btnEditDocument = new JButton();
        this.setLayout(new GridBagLayout());
        this.fldDocumentLibraryType.setFont(THEMIS.fontList);
        this.fldDocumentLibraryType.setModel(new DefaultComboBoxModel());
        this.fldDocumentLibraryType.setMinimumSize(new Dimension(56, 30));
        this.fldDocumentLibraryType.setPreferredSize(new Dimension(56, 30));
        this.fldDocumentLibraryType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DocumentAttributePanel.this.fldDocumentLibraryTypeItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.fldDocumentLibraryType, gridBagConstraints);
        this.fldDocumentLibrary.setFont(THEMIS.fontList);
        this.fldDocumentLibrary.setModel(new DefaultComboBoxModel());
        this.fldDocumentLibrary.setMinimumSize(new Dimension(56, 30));
        this.fldDocumentLibrary.setPreferredSize(new Dimension(56, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.fldDocumentLibrary, gridBagConstraints);
        this.btnAddDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddDocument, (String)NbBundle.getMessage(DocumentAttributePanel.class, (String)"DocumentAttributePanel.btnAddDocument.text"));
        this.btnAddDocument.setToolTipText(NbBundle.getMessage(DocumentAttributePanel.class, (String)"DocumentAttributePanel.btnAddDocument.toolTipText"));
        this.btnAddDocument.setBorder(new SoftBevelBorder(0));
        this.btnAddDocument.setMinimumSize(new Dimension(30, 30));
        this.btnAddDocument.setPreferredSize(new Dimension(30, 30));
        this.btnAddDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentAttributePanel.this.btnAddDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.btnAddDocument, gridBagConstraints);
        this.jScrollPane12.setMaximumSize(null);
        this.jScrollPane12.setMinimumSize(null);
        this.lstDocuments.setFont(THEMIS.fontList);
        this.lstDocuments.setModel(new DefaultListModel());
        this.lstDocuments.setPreferredSize(null);
        this.lstDocuments.setVisibleRowCount(7);
        this.lstDocuments.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DocumentAttributePanel.this.lstDocumentsMousePressed(evt);
            }
        });
        this.lstDocuments.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DocumentAttributePanel.this.lstDocumentsValueChanged(evt);
            }
        });
        this.jScrollPane12.setViewportView(this.lstDocuments);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane12, gridBagConstraints);
        this.btnRemoveDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveDocument, (String)NbBundle.getMessage(DocumentAttributePanel.class, (String)"DocumentAttributePanel.btnRemoveDocument.text"));
        this.btnRemoveDocument.setToolTipText(NbBundle.getMessage(DocumentAttributePanel.class, (String)"DocumentAttributePanel.btnRemoveDocument.toolTipText"));
        this.btnRemoveDocument.setBorder(new SoftBevelBorder(0));
        this.btnRemoveDocument.setMinimumSize(new Dimension(30, 30));
        this.btnRemoveDocument.setPreferredSize(new Dimension(30, 30));
        this.btnRemoveDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentAttributePanel.this.btnRemoveDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.btnRemoveDocument, gridBagConstraints);
        this.btnEditDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEditDocument, (String)NbBundle.getMessage(DocumentAttributePanel.class, (String)"DocumentAttributePanel.btnEditDocument.text"));
        this.btnEditDocument.setToolTipText(NbBundle.getMessage(DocumentAttributePanel.class, (String)"DocumentAttributePanel.btnEditDocument.toolTipText"));
        this.btnEditDocument.setBorder(new SoftBevelBorder(0));
        this.btnEditDocument.setMinimumSize(new Dimension(30, 30));
        this.btnEditDocument.setPreferredSize(new Dimension(30, 30));
        this.btnEditDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentAttributePanel.this.btnEditDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.btnEditDocument, gridBagConstraints);
    }

    private void fldDocumentLibraryTypeItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 1) {
            return;
        }
        if (this.element != null) {
            this.loadDocumentLibrary();
        }
    }

    private void btnAddDocumentActionPerformed(ActionEvent evt) {
        if (!this.allowEdit) {
            return;
        }
        this.changed = true;
        CmsElementSummary ele = (CmsElementSummary)this.fldDocumentLibrary.getSelectedItem();
        if (this.element != null && ele != null) {
            this.element.getRelationAttribute("infos").add(ele);
            ((DefaultComboBoxModel)this.fldDocumentLibrary.getModel()).removeElement(ele);
            ((DefaultListModel)this.lstDocuments.getModel()).addElement(ele);
        }
    }

    private void lstDocumentsMousePressed(MouseEvent evt) {
        if (this.lstDocuments.getSelectionModel().isSelectionEmpty()) {
            return;
        }
        if (evt.getClickCount() == 2) {
            this.openSelectedDocument(this.lstDocuments);
        }
    }

    private void lstDocumentsValueChanged(ListSelectionEvent evt) {
        this.updateComponentVisibility();
    }

    private void btnRemoveDocumentActionPerformed(ActionEvent evt) {
        if (!this.allowEdit) {
            return;
        }
        this.changed = true;
        CmsElementSummary ele = (CmsElementSummary)this.lstDocuments.getSelectedValue();
        if (this.element != null && ele != null) {
            this.element.getRelationAttribute("infos").delete(ele.getId());
            ((DefaultListModel)this.lstDocuments.getModel()).removeElement(ele);
            ((DefaultComboBoxModel)this.fldDocumentLibrary.getModel()).addElement(ele);
        }
    }

    private void btnEditDocumentActionPerformed(ActionEvent evt) {
        CmsElementSummary sel = (CmsElementSummary)this.lstDocuments.getSelectedValue();
        CmsElement ele = sel.getElement();
        if (ele instanceof CmsInfo) {
            List items = ele.getUploadAttribute("files").getUploadItems();
            if (items.size() == 1) {
                Desktop dt = Desktop.getDesktop();
                try {
                    dt.open(new File(((UploadItem)items.get(0)).getAbsolutePath()));
                }
                catch (IOException iOException) {}
            } else if (items.size() > 1) {
                UploadItemFilePanel p = new UploadItemFilePanel();
                p.populate(ele.getUploadAttribute("files"));
                Dialogs.getInstance().showDialogWithPanel(p, "dialog.select.title");
            }
        }
    }
}

