/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.ui.attributes;

import at.grid.cms.element.CmsElement;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.ontology.swing.ui.PDControlScrollPane;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.ui.attributes.AbstractAttributePanel;
import at.grid.themis.ontology.element.CmsMeasureTemplate;
import at.grid.themis.ontology.element.CmsObservation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MeasureAttributePanel
extends AbstractAttributePanel {
    private JButton btnApplyTemplateMeasure;
    private JButton btnObservationCleareMeasure;
    private JButton btnObservationMeasureCalendar;
    private JTextArea fldObservationMeasure;
    private JComboBox fldTemplateMeasure;
    private JPanel panelMeasureTemaplate;
    private JScrollPane scrollMeasure;

    public MeasureAttributePanel(CmsElement element) {
        super(element);
        this.initComponents();
        this.populate();
    }

    @Override
    public void populate() {
        if (!(this.element instanceof CmsObservation)) {
            return;
        }
        this.fldObservationMeasure.setText(this.element.getAttributeValue("measure"));
        this.fldObservationMeasure.setRows(this.app.getSettings().getDisplayTextareaSize());
        THEMIS.removeUsualTabBehavior(this.fldObservationMeasure);
    }

    @Override
    public void apply() {
        if (!(this.element instanceof CmsObservation)) {
            return;
        }
        this.element.setAttributeValue("measure", this.fldObservationMeasure.getText());
    }

    private void applyMeasureTemplate() {
        CmsMeasureTemplate template;
        if (!this.allowEdit) {
            return;
        }
        if (!(this.element instanceof CmsObservation)) {
            return;
        }
        CmsBasicElement ele = (CmsBasicElement)this.fldTemplateMeasure.getSelectedItem();
        if (!this.project.checkForCurrentEvent(false)) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.chooseEventFirstNotif.text"));
            return;
        }
        if (ele != null && this.element != null && (template = (CmsMeasureTemplate)this.project.loadElement(ele.getId(), this.project.getUser())) != null) {
            String m = this.fldObservationMeasure.getText();
            this.fldObservationMeasure.setText(template.getNewMeasureText(m));
            this.element.setSaved(false);
        }
    }

    private void initComponents() {
        this.panelMeasureTemaplate = new JPanel();
        this.fldTemplateMeasure = new JComboBox();
        this.btnApplyTemplateMeasure = new JButton();
        this.scrollMeasure = new PDControlScrollPane();
        this.fldObservationMeasure = new JTextArea();
        this.btnObservationCleareMeasure = new JButton();
        this.btnObservationMeasureCalendar = new JButton();
        this.setLayout(new GridBagLayout());
        this.panelMeasureTemaplate.setLayout(new GridBagLayout());
        this.fldTemplateMeasure.setFont(THEMIS.fontList);
        this.fldTemplateMeasure.setModel(new DefaultComboBoxModel());
        this.fldTemplateMeasure.setMinimumSize(new Dimension(100, 30));
        this.fldTemplateMeasure.setPreferredSize(new Dimension(100, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.panelMeasureTemaplate.add((Component)this.fldTemplateMeasure, gridBagConstraints);
        this.btnApplyTemplateMeasure.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApplyTemplateMeasure, (String)NbBundle.getMessage(MeasureAttributePanel.class, (String)"MeasureAttributePanel.btnApplyTemplateMeasure.text"));
        this.btnApplyTemplateMeasure.setToolTipText(NbBundle.getMessage(MeasureAttributePanel.class, (String)"MeasureAttributePanel.btnApplyTemplateMeasure.toolTipText"));
        this.btnApplyTemplateMeasure.setBorder(new SoftBevelBorder(0));
        this.btnApplyTemplateMeasure.setPreferredSize(new Dimension(35, 35));
        this.btnApplyTemplateMeasure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasureAttributePanel.this.btnApplyTemplateMeasureActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.panelMeasureTemaplate.add((Component)this.btnApplyTemplateMeasure, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelMeasureTemaplate, gridBagConstraints);
        this.fldObservationMeasure.setColumns(20);
        this.fldObservationMeasure.setFont(THEMIS.fontTextfield);
        this.fldObservationMeasure.setLineWrap(true);
        this.fldObservationMeasure.setRows(5);
        this.fldObservationMeasure.setWrapStyleWord(true);
        this.scrollMeasure.setViewportView(this.fldObservationMeasure);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollMeasure, gridBagConstraints);
        this.btnObservationCleareMeasure.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationCleareMeasure, (String)NbBundle.getMessage(MeasureAttributePanel.class, (String)"MeasureAttributePanel.btnObservationCleareMeasure.text"));
        this.btnObservationCleareMeasure.setToolTipText(NbBundle.getMessage(MeasureAttributePanel.class, (String)"MeasureAttributePanel.btnObservationCleareMeasure.toolTipText"));
        this.btnObservationCleareMeasure.setBorder(new SoftBevelBorder(0));
        this.btnObservationCleareMeasure.setMinimumSize(new Dimension(30, 30));
        this.btnObservationCleareMeasure.setPreferredSize(new Dimension(30, 30));
        this.btnObservationCleareMeasure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasureAttributePanel.this.btnObservationCleareMeasureActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.btnObservationCleareMeasure, gridBagConstraints);
        this.btnObservationMeasureCalendar.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/calendar.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationMeasureCalendar, (String)NbBundle.getMessage(MeasureAttributePanel.class, (String)"MeasureAttributePanel.btnObservationMeasureCalendar.text"));
        this.btnObservationMeasureCalendar.setToolTipText(NbBundle.getMessage(MeasureAttributePanel.class, (String)"MeasureAttributePanel.btnObservationMeasureCalendar.toolTipText"));
        this.btnObservationMeasureCalendar.setBorder(new SoftBevelBorder(0));
        this.btnObservationMeasureCalendar.setMinimumSize(new Dimension(30, 30));
        this.btnObservationMeasureCalendar.setPreferredSize(new Dimension(30, 30));
        this.btnObservationMeasureCalendar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasureAttributePanel.this.btnObservationMeasureCalendarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.btnObservationMeasureCalendar, gridBagConstraints);
    }

    private void btnApplyTemplateMeasureActionPerformed(ActionEvent evt) {
        this.applyMeasureTemplate();
    }

    private void btnObservationCleareMeasureActionPerformed(ActionEvent evt) {
        if (Dialogs.getInstance().showConfirmDialog("dialog.clearText")) {
            this.fldObservationMeasure.setText("");
        }
    }

    private void btnObservationMeasureCalendarActionPerformed(ActionEvent evt) {
        THEMIS.addDateToTextarea(this.fldObservationMeasure);
    }
}

