/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.ui.attributes;

import at.grid.cms.element.CmsElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.ui.attributes.AbstractAttributePanel;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SizeAttributePanel
extends AbstractAttributePanel {
    private JTextField fldLocationDimArea;
    private JTextField fldLocationDimDiameter;
    private JTextField fldLocationDimHeight;
    private JTextField fldLocationDimWidth;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel5;
    private JLabel jLabel9;

    public SizeAttributePanel(CmsElement element) {
        super(element);
        this.initComponents();
        this.populate();
    }

    @Override
    public void populate() {
        if (!(this.element instanceof CmsLocation)) {
            return;
        }
        boolean userAdministrator = false;
        this.fldLocationDimWidth.setText(this.element.getAttributeValue("dimwidth"));
        this.fldLocationDimWidth.setEnabled(!this.settings.getLocationAttribute("size").isWriteprotected() || userAdministrator);
        this.fldLocationDimHeight.setText(this.element.getAttributeValue("dimheight"));
        this.fldLocationDimHeight.setEnabled(!this.settings.getLocationAttribute("size").isWriteprotected() || userAdministrator);
        this.fldLocationDimDiameter.setText(this.element.getAttributeValue("dimdiameter"));
        this.fldLocationDimDiameter.setEnabled(!this.settings.getLocationAttribute("size").isWriteprotected() || userAdministrator);
        this.fldLocationDimArea.setText(this.element.getAttributeValue("dimarea"));
        this.fldLocationDimArea.setEnabled(!this.settings.getLocationAttribute("size").isWriteprotected() || userAdministrator);
    }

    @Override
    public void apply() {
        if (!(this.element instanceof CmsLocation)) {
            return;
        }
        this.element.setAttributeValue("dimwidth", this.fldLocationDimWidth.getText());
        this.element.setAttributeValue("dimheight", this.fldLocationDimHeight.getText());
        this.element.setAttributeValue("dimdiameter", this.fldLocationDimDiameter.getText());
        this.element.setAttributeValue("dimarea", this.fldLocationDimArea.getText());
    }

    private void calculateLocationDimensionArea(boolean useDiam) {
        String bStr = this.fldLocationDimWidth.getText().replaceAll(",", ".");
        String hStr = this.fldLocationDimHeight.getText().replaceAll(",", ".");
        String dStr = this.fldLocationDimDiameter.getText().replaceAll(",", ".");
        double b = 0.0;
        double h = 0.0;
        double d = 0.0;
        double f = 0.0;
        try {
            b = Double.parseDouble(bStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            h = Double.parseDouble(hStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(dStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        f = useDiam ? Math.PI * (d / 2.0) * (d / 2.0) : b * h;
        this.fldLocationDimArea.setText(Double.toString(Util.round((double)f, (int)2)));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.fldLocationDimWidth = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldLocationDimHeight = new JTextField();
        this.jLabel9 = new JLabel();
        this.fldLocationDimDiameter = new JTextField();
        this.jLabel12 = new JLabel();
        this.fldLocationDimArea = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SizeAttributePanel.class, (String)"SizeAttributePanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.fldLocationDimWidth.setFont(THEMIS.fontTextfield);
        this.fldLocationDimWidth.setHorizontalAlignment(0);
        this.fldLocationDimWidth.setText(NbBundle.getMessage(SizeAttributePanel.class, (String)"SizeAttributePanel.fldLocationDimWidth.text"));
        this.fldLocationDimWidth.setPreferredSize(new Dimension(70, 30));
        this.fldLocationDimWidth.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SizeAttributePanel.this.fldLocationDimWidthPropertyChange(evt);
            }
        });
        this.fldLocationDimWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SizeAttributePanel.this.fldLocationDimWidthKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.fldLocationDimWidth, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabel);
        this.jLabel5.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SizeAttributePanel.class, (String)"SizeAttributePanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.fldLocationDimHeight.setFont(THEMIS.fontTextfield);
        this.fldLocationDimHeight.setHorizontalAlignment(0);
        this.fldLocationDimHeight.setText(NbBundle.getMessage(SizeAttributePanel.class, (String)"SizeAttributePanel.fldLocationDimHeight.text"));
        this.fldLocationDimHeight.setPreferredSize(new Dimension(70, 30));
        this.fldLocationDimHeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SizeAttributePanel.this.fldLocationDimHeightKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.fldLocationDimHeight, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        this.jLabel9.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(SizeAttributePanel.class, (String)"SizeAttributePanel.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel9, gridBagConstraints);
        this.fldLocationDimDiameter.setFont(THEMIS.fontTextfield);
        this.fldLocationDimDiameter.setHorizontalAlignment(0);
        this.fldLocationDimDiameter.setText(NbBundle.getMessage(SizeAttributePanel.class, (String)"SizeAttributePanel.fldLocationDimDiameter.text"));
        this.fldLocationDimDiameter.setPreferredSize(new Dimension(70, 30));
        this.fldLocationDimDiameter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SizeAttributePanel.this.fldLocationDimDiameterKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.fldLocationDimDiameter, gridBagConstraints);
        this.jLabel12.setFont(THEMIS.fontLabel);
        this.jLabel12.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(SizeAttributePanel.class, (String)"SizeAttributePanel.jLabel12.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel12, gridBagConstraints);
        this.fldLocationDimArea.setFont(THEMIS.fontTextfield);
        this.fldLocationDimArea.setHorizontalAlignment(0);
        this.fldLocationDimArea.setText(NbBundle.getMessage(SizeAttributePanel.class, (String)"SizeAttributePanel.fldLocationDimArea.text"));
        this.fldLocationDimArea.setPreferredSize(new Dimension(70, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.fldLocationDimArea, gridBagConstraints);
    }

    private void fldLocationDimWidthPropertyChange(PropertyChangeEvent evt) {
    }

    private void fldLocationDimWidthKeyReleased(KeyEvent evt) {
        this.calculateLocationDimensionArea(false);
    }

    private void fldLocationDimHeightKeyReleased(KeyEvent evt) {
        this.calculateLocationDimensionArea(false);
    }

    private void fldLocationDimDiameterKeyReleased(KeyEvent evt) {
        this.calculateLocationDimensionArea(true);
    }
}

