/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.ui.attributes;

import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.PhotoViewerPanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.audio.SimpleAudioRecorder;
import at.grid.themis.application.camera.WebcamFrame2;
import at.grid.themis.application.image.ImageReference;
import at.grid.themis.application.image.ImageRotateLeft;
import at.grid.themis.application.image.ImageRotateRight;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.application.ui.attributes.AbstractAttributePanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class UploadAttributePanel
extends AbstractAttributePanel {
    int imageSize;
    private UploadItem selectedLocationImage;
    HashMap<Long, ArrayList<ImageReference>> imageReferences;
    public static final int RECORDING = 1;
    public static final int PLAYBACK = 2;
    public static final int STOPPED = 3;
    public static final int PAUSED = 4;
    private int audiostate;
    private boolean recordDone;
    private int type;
    private File audiofile;
    private SimpleAudioRecorder recorder;
    private Position curPosition;
    private JButton btnCutImage;
    private JButton btnLocationAddFile;
    private JButton btnLocationCaptureImage;
    private JButton btnLocationEditImage;
    private JButton btnLocationRemoveFile;
    private JButton btnPasteImage;
    private JButton btnRemoveAudio1;
    private JButton btnRotateCCW;
    private JButton btnRotateCW;
    private JLabel jLabel35;
    private JPanel jPanel26;
    private JScrollPane jScrollPane13;
    private JScrollPane jScrollPane5;
    private JLabel lblEmpty1;
    private JLabel lblFileInfo1;
    private JList lstLocationFiles;
    private JPanel panelLocationFilesButtons;
    private JPanel panelLocationImages;
    private JButton playButton1;
    private JButton playExternalLoc;
    private JButton recordButton1;
    private JButton stopButton1;

    public UploadAttributePanel(CmsElement element) {
        super(element);
        this.imageSize = this.app.getSettings().getImageUploadSize();
        this.imageReferences = new HashMap();
        this.type = 1;
        this.audiofile = null;
        this.initComponents();
        this.populate();
    }

    @Override
    public void populate() {
        new DropTarget(this.panelLocationImages, new ThemisDropTargetListener(false, false, new String[]{"jpg"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ArrayList<File> files = new ArrayList<File>();
                files.add(f);
                UploadAttributePanel.this.dropFileImage(files);
            }
        });
        new DropTarget(this.lstLocationFiles, new ThemisDropTargetListener(false, false, new String[]{"wav"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ArrayList<File> files = new ArrayList<File>();
                files.add(f);
                UploadAttributePanel.this.dropFileImage(files);
            }
        });
        DragScrollHandler dragScrollHandlerLocationImages = new DragScrollHandler(this.panelLocationImages, true, false);
        this.updateComponentVisibility();
        this.populateUploads();
    }

    @Override
    public void apply() {
    }

    private void updateComponentVisibility() {
        this.btnLocationAddFile.setEnabled(this.allowEdit && this.project.getSelectionManager().getCurrentEventId() > 0L);
        boolean hasFileSelected = this.lstLocationFiles.getSelectedIndex() >= 0;
        this.btnLocationRemoveFile.setEnabled(this.allowEdit && hasFileSelected);
        this.setAudioFileSelection();
        this.updateAudioComponents();
    }

    @Override
    public boolean isChanged() {
        boolean change = this.changed;
        ArrayList refs = this.imageReferences.getOrDefault(this.element.getId(), new ArrayList());
        for (ImageReference ref : refs) {
            change = change || ref.isChanged();
        }
        return change;
    }

    private void setSelectedLocationImage(UploadItem item, int idxSel) {
        this.selectedLocationImage = item;
        boolean allowImageEdit = this.project.isUploadImageEditable(item);
        this.btnLocationRemoveFile.setEnabled(allowImageEdit && this.allowEdit);
        this.btnRotateCW.setEnabled(allowImageEdit && this.allowEdit);
        this.btnRotateCCW.setEnabled(allowImageEdit && this.allowEdit);
        int idx = 0;
        for (Component c : this.panelLocationImages.getComponents()) {
            if (c instanceof JLabel) {
                if (idx == idxSel) {
                    ((JLabel)c).setBorder(BorderFactory.createLineBorder(Color.red, 2));
                } else {
                    ((JLabel)c).setBorder(null);
                }
            }
            ++idx;
        }
    }

    public void populateUploads() {
        DefaultListModel model = (DefaultListModel)this.lstLocationFiles.getModel();
        model.clear();
        List uploadItems = this.element.getUploadAttribute("files").getUploadItems();
        ArrayList<ImageReference> refs = this.imageReferences.getOrDefault(this.element.getId(), new ArrayList());
        boolean createRefs = !refs.isEmpty();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.gridx = -1;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        gbc0.weightx = 1.0;
        gbc0.insets = new Insets(2, 2, 2, 2);
        this.panelLocationImages.removeAll();
        boolean foundSelection = false;
        int idx = 0;
        for (final UploadItem item : uploadItems) {
            if (item.isImage()) {
                final int imageIndex = idx;
                JLabel lbl = new JLabel();
                if (this.selectedLocationImage != null && item.getId() == this.selectedLocationImage.getId()) {
                    lbl.setBorder(BorderFactory.createLineBorder(Color.red, 2));
                } else {
                    lbl.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                }
                lbl.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        UploadAttributePanel.this.setSelectedLocationImage(item, imageIndex);
                    }
                });
                boolean foundImageReference = false;
                for (ImageReference ref : refs) {
                    if (ref.getUploadItem().getId() != item.getId()) continue;
                    this.updateIcon(lbl, ref.getImageFile().getName(), ref, 0, 100);
                    foundImageReference = true;
                }
                if (!foundImageReference) {
                    ArrayList drawings = ThemisApplication.getInstance().getProject().getDrawings(item.getId());
                    this.updateIcon(lbl, drawings, item.getFile(), 0, 100);
                    if (createRefs) {
                        ImageReference imgref = new ImageReference(this.element, item);
                        imgref.setImageInfo(item.getFileInfo());
                        refs.add(imgref);
                    }
                }
                Icon icon = lbl.getIcon();
                this.panelLocationImages.add((Component)lbl, gbc);
            } else {
                model.addElement(item);
            }
            ++idx;
        }
        this.imageReferences.put(this.element.getId(), refs);
        this.panelLocationImages.add((Component)new JLabel(""), gbc0);
        this.panelLocationImages.revalidate();
        this.panelLocationImages.repaint();
        if (!model.isEmpty()) {
            this.lstLocationFiles.setSelectedIndex(model.size() - 1);
        }
    }

    private void updateIcon(JLabel lbl, ArrayList<SimpleGeometry> drawings, File imagefile, int width, int height) {
        if (lbl == null || imagefile == null) {
            return;
        }
        try {
            lbl.setText("");
            if (imagefile.isFile()) {
                BufferedImage bi = null;
                int counter = 0;
                while (bi == null && counter < 5) {
                    bi = THEMIS.createImage(drawings, imagefile, width);
                    ++counter;
                    if (bi != null) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                BufferedImage bi2 = Util.resizeImage(bi, (int)width, (int)height, (int)2);
                if (bi2 != null) {
                    ImageIcon icon = new ImageIcon(bi2);
                    lbl.setIcon(icon);
                    return;
                }
            }
            lbl.setText(imagefile.getName());
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateIcon(JLabel lbl, String lblText, ImageReference icr, int width, int height) {
        if (lbl == null || icr == null || icr.getImage() == null) {
            lbl.setText("[" + lblText + "]");
            return;
        }
        try {
            BufferedImage bi;
            lbl.setText("");
            if (width <= 0 && height > 0 && icr.getImage().getHeight() > 0) {
                width = icr.getImage().getWidth() * height / icr.getImage().getHeight();
            }
            if ((bi = THEMIS.createImage(icr.getDrawings(), icr.getImage(), width)) != null) {
                ImageIcon icon = new ImageIcon(bi);
                lbl.setIcon(icon);
                return;
            }
            lbl.setText(lblText);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void captureImage() {
        if (this.fotoDisabled) {
            Dialogs.getInstance().showWarningDialog("error.no-image-path-defined");
            return;
        }
        WebcamFrame2 webcamFrame = new WebcamFrame2(THEMIS.getMainWindow());
        SwingUtilities.invokeLater(webcamFrame);
    }

    private void rotateImage(CmsElement ele, UploadItem item, double angle) {
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        if (item == null) {
            return;
        }
        ArrayList<Object> refs = this.imageReferences.getOrDefault(this.element.getId(), new ArrayList());
        if (refs.isEmpty()) {
            refs = this.createImageReferences(ele, ele.getUploadAttribute("files").getImageUploadItems());
        }
        ImageReference img = null;
        for (ImageReference ref : refs) {
            if (ref.getUploadItem().getId() != item.getId()) continue;
            img = ref;
            break;
        }
        if (img != null) {
            switch ((int)angle) {
                case 90: {
                    img.applyImageCorrection(new ImageRotateRight());
                    break;
                }
                case -90: 
                case 270: {
                    img.applyImageCorrection(new ImageRotateLeft());
                    break;
                }
                case 180: {
                    img.applyImageCorrection(new ImageRotateLeft());
                    img.applyImageCorrection(new ImageRotateLeft());
                }
            }
            this.populateUploads();
        }
    }

    private ArrayList<ImageReference> createImageReferences(CmsElement ref, ArrayList<UploadItem> items) {
        ArrayList<ImageReference> references = new ArrayList<ImageReference>();
        for (UploadItem item : items) {
            if (!item.isImage()) continue;
            ImageReference imgref = new ImageReference(ref, item.getFile(), item.getFileComment(), item.getUploadDetail(), item.getFileInfo(), item.getIdelement());
            if (item.getFileInfo() == null || "".equals(item.getFileInfo())) {
                imgref.setImageInfo(item.getFileInfo());
            }
            imgref.setUploadItem(item);
            references.add(imgref);
        }
        this.imageReferences.put(ref.getId(), references);
        return references;
    }

    private boolean dropFileImage(List<File> files) {
        boolean result = true;
        for (File f : files) {
            try {
                File outputfile = this.loadFile(f);
                if (outputfile == null) continue;
                this.changed = true;
                UploadItem item = this.element.getUploadAttribute("files").addUpload(outputfile);
                this.populateUploads();
                if (item == null || !this.app.getSettings().getImageKeepOriginal()) continue;
                Util.copy((File)f, (File)new File(this.project.getImagefileLocation(), item.createFilename()));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                result = false;
            }
        }
        return result;
    }

    private File loadFile(File f) throws IOException {
        boolean success = false;
        if (f != null && (f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".png") || f.getName().toLowerCase().endsWith(".gif") || f.getName().toLowerCase().endsWith(".wav"))) {
            File outputfile = null;
            try {
                outputfile = new File(this.app.getProject().getTempfileLocation(), f.getName());
                if (f.getName().toLowerCase().endsWith(".wav")) {
                    Util.copy((File)f, (File)outputfile);
                    success = outputfile.isFile();
                } else {
                    BufferedImage image = this.imageSize == 0 ? ImageIO.read(f) : Util.resizeImage((BufferedImage)ImageIO.read(f), (int)this.imageSize);
                    success = THEMIS.createImageFile(image, outputfile, this.app.getSettings().getImageUploadQuality());
                }
            }
            catch (IOException ex) {
                this.project.getLogger().fine("Cannot process observation upload: " + ex.getMessage());
            }
            return outputfile;
        }
        Dialogs.getInstance().showErrorDialog("error.cannot-read-fileformat");
        return null;
    }

    private void editImages(CmsElement e) {
        if (e == null) {
            return;
        }
        UploadItem selectedImage = null;
        if (e.getUploadAttribute("files").getImageUploadItems().isEmpty()) {
            return;
        }
        selectedImage = this.selectedLocationImage;
        PhotoViewerPanel panel = new PhotoViewerPanel(false);
        ArrayList<ImageReference> refs = this.imageReferences.getOrDefault(e.getId(), new ArrayList());
        if (refs.isEmpty()) {
            panel.updateImageForElement(e, selectedImage);
        } else {
            panel.setImageReference(e);
            panel.updateImage(refs, false);
        }
        Dialogs.getInstance().showDialog(panel, panel, true, "photoviewerdialog", 800, 600, "dialog.edit-photo.title");
        this.imageReferences.put(e.getId(), panel.getImages());
        this.populateUploads();
    }

    public void saveImageReferences() {
        this.project.getLogger().fine("Saving " + this.imageReferences.size() + " image references");
        for (ArrayList<ImageReference> refs : this.imageReferences.values()) {
            for (ImageReference ref : refs) {
                ref.save();
            }
        }
    }

    public HashMap<Long, ArrayList<ImageReference>> getImageReferences() {
        return this.imageReferences;
    }

    private void setAudioFileSelection() {
        UploadItem item = null;
        item = (UploadItem)this.lstLocationFiles.getSelectedValue();
        this.audiofile = item != null && item.isAudio() ? item.getFile() : null;
    }

    private void updateAudioComponents() {
        if (this.audiostate == 1) {
            this.recordButton1.setEnabled(false);
            this.stopButton1.setEnabled(true);
            this.playButton1.setEnabled(false);
        } else if (this.audiostate == 2) {
            this.recordButton1.setEnabled(false);
            this.stopButton1.setEnabled(true);
            this.playButton1.setEnabled(false);
        } else {
            this.recordButton1.setEnabled(this.allowEdit);
            this.stopButton1.setEnabled(false);
            this.playButton1.setEnabled(this.audiofile != null);
        }
        if (this.type == 2) {
            this.recordButton1.setEnabled(false);
        }
    }

    public void stopAudio() {
        if (this.audiostate == 1) {
            this.recorder.stopRecording();
            this.setAudioState(3);
            while (!this.recorder.getState().equals((Object)Thread.State.TERMINATED)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.audiofile != null && this.audiofile.isFile()) {
                this.element.getUploadAttribute("files").addUpload(this.audiofile);
                this.populateUploads();
            }
        } else if (this.audiostate == 2) {
            this.setAudioState(3);
        }
    }

    private void captureAudio() {
        int count;
        if (!this.allowEdit) {
            return;
        }
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = null;
        try {
            targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            targetDataLine.open(audioFormat);
        }
        catch (LineUnavailableException e) {
            Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.newerObsNotif.text"));
            return;
        }
        AudioFileFormat.Type targetType = AudioFileFormat.Type.WAVE;
        this.audiofile = null;
        for (count = 0; (this.audiofile == null || this.audiofile.exists()) && count < 10; ++count) {
            this.audiofile = new File(this.app.getProject().getTempfileLocation(), Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.app.getProject().getTimeZone()) + ".wav");
        }
        if (count == 10) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.noAudioStreamNotif.text"));
            return;
        }
        this.recorder = new SimpleAudioRecorder(targetDataLine, targetType, this.audiofile);
        this.lblFileInfo1.setText("0");
        this.setAudioState(1);
        this.recorder.start();
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Date dt = new Date();
                long mili0 = dt.getTime();
                while (UploadAttributePanel.this.getAudioState() == 1) {
                    Thread.sleep(100L);
                    dt = new Date();
                    long seconds = (dt.getTime() - mili0) / 100L;
                    UploadAttributePanel.this.lblFileInfo1.setText(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.time.text"), Float.toString((float)seconds / 10.0f)));
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
            }
        };
        worker.execute();
    }

    private void playAudio() {
        if (this.audiofile == null) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.noAudioSelectedNotif.text"));
            return;
        }
        this.audiostate = 2;
        this.updateAudioComponents();
        this.lblFileInfo1.setText("");
        try {
            final AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(this.audiofile);
            final AudioFormat format = audioInputStream.getFormat();
            long frames = audioInputStream.getFrameLength();
            final double durationInSeconds = Util.round((double)(((double)frames + 0.0) / (double)format.getFrameRate()), (int)1);
            SwingWorker<Void, Void> worker2 = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Date dt = new Date();
                    long mili0 = dt.getTime();
                    while (UploadAttributePanel.this.getAudioState() == 2) {
                        Thread.sleep(100L);
                        dt = new Date();
                        long seconds = (dt.getTime() - mili0) / 100L;
                        UploadAttributePanel.this.lblFileInfo1.setText(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.time2.text"), Float.toString((float)seconds / 10.0f), durationInSeconds));
                    }
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                }
            };
            worker2.execute();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void doInBackground() throws Exception {
                    Date dt = new Date();
                    long mili0 = dt.getTime();
                    SourceDataLine auline = null;
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                    try {
                        auline = (SourceDataLine)AudioSystem.getLine(info);
                        auline.open(format);
                    }
                    catch (LineUnavailableException e) {
                        Dialogs.getInstance().showErrorDialog("error.audio-line-not-available", e);
                        UploadAttributePanel.this.setAudioState(3);
                        return null;
                    }
                    catch (Exception e) {
                        Dialogs.getInstance().showErrorDialog("ERROR : " + e.getMessage(), e);
                        return null;
                    }
                    if (auline.isControlSupported(FloatControl.Type.PAN)) {
                        FloatControl pan = (FloatControl)auline.getControl(FloatControl.Type.PAN);
                        if (UploadAttributePanel.this.curPosition == Position.RIGHT) {
                            pan.setValue(1.0f);
                        } else if (UploadAttributePanel.this.curPosition == Position.LEFT) {
                            pan.setValue(-1.0f);
                        }
                    }
                    try {
                        auline.start();
                        int nBytesRead = 0;
                        int buffer_size = 128000;
                        byte[] abData = new byte[buffer_size];
                        while (nBytesRead != -1 && UploadAttributePanel.this.audiostate == 2) {
                            nBytesRead = audioInputStream.read(abData, 0, abData.length);
                            if (nBytesRead >= 0) {
                                auline.write(abData, 0, nBytesRead);
                            }
                            dt = new Date();
                            long seconds = (dt.getTime() - mili0) / 100L;
                            UploadAttributePanel.this.lblFileInfo1.setText(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.time.text"), Float.toString((float)seconds / 10.0f)));
                        }
                        UploadAttributePanel.this.setAudioState(3);
                        UploadAttributePanel.this.lblFileInfo1.setText("");
                    }
                    catch (IOException e) {
                        Dialogs.getInstance().showErrorDialog("error.audio-file-access", e);
                        UploadAttributePanel.this.setAudioState(3);
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        auline.drain();
                        auline.close();
                    }
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                }
            };
            worker.execute();
        }
        catch (UnsupportedAudioFileException e) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.audioNotSupportedNotif.text"), e);
            return;
        }
        catch (IOException e) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.errorReadingFileNotif.text"), e);
            this.setAudioState(3);
            return;
        }
    }

    public void setAudioState(int s) {
        this.audiostate = s;
        this.updateAudioComponents();
    }

    public int getAudioState() {
        return this.audiostate;
    }

    public File getFile() {
        return this.audiofile;
    }

    public SimpleAudioRecorder getRecorder() {
        return this.recorder;
    }

    private void initComponents() {
        this.jScrollPane5 = new JScrollPane();
        this.panelLocationImages = new JPanel();
        this.panelLocationFilesButtons = new JPanel();
        this.btnLocationCaptureImage = new JButton();
        this.btnLocationAddFile = new JButton();
        this.btnLocationRemoveFile = new JButton();
        this.btnLocationEditImage = new JButton();
        this.btnRotateCW = new JButton();
        this.btnRotateCCW = new JButton();
        this.lblEmpty1 = new JLabel();
        this.btnCutImage = new JButton();
        this.btnPasteImage = new JButton();
        this.jLabel35 = new JLabel();
        this.jScrollPane13 = new JScrollPane();
        this.lstLocationFiles = new JList();
        this.jPanel26 = new JPanel();
        this.recordButton1 = new JButton();
        this.playButton1 = new JButton();
        this.stopButton1 = new JButton();
        this.playExternalLoc = new JButton();
        this.btnRemoveAudio1 = new JButton();
        this.lblFileInfo1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jScrollPane5.setHorizontalScrollBarPolicy(32);
        this.jScrollPane5.setVerticalScrollBarPolicy(21);
        this.jScrollPane5.setMinimumSize(new Dimension(100, 115));
        this.jScrollPane5.setPreferredSize(new Dimension(200, 120));
        this.panelLocationImages.setMinimumSize(new Dimension(0, 100));
        this.panelLocationImages.setLayout(new GridBagLayout());
        this.jScrollPane5.setViewportView(this.panelLocationImages);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane5, gridBagConstraints);
        this.panelLocationFilesButtons.setLayout(new GridBagLayout());
        this.btnLocationCaptureImage.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/showPictures_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationCaptureImage, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnLocationCaptureImage.text"));
        this.btnLocationCaptureImage.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnLocationCaptureImage.toolTipText"));
        this.btnLocationCaptureImage.setBorder(new SoftBevelBorder(0));
        this.btnLocationCaptureImage.setPreferredSize(new Dimension(35, 35));
        this.btnLocationCaptureImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.btnLocationCaptureImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnLocationCaptureImage, gridBagConstraints);
        this.btnLocationAddFile.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationAddFile, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnLocationAddFile.text"));
        this.btnLocationAddFile.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnLocationAddFile.toolTipText"));
        this.btnLocationAddFile.setBorder(new SoftBevelBorder(0));
        this.btnLocationAddFile.setPreferredSize(new Dimension(35, 35));
        this.btnLocationAddFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.btnLocationAddFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnLocationAddFile, gridBagConstraints);
        this.btnLocationRemoveFile.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationRemoveFile, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnLocationRemoveFile.text"));
        this.btnLocationRemoveFile.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnLocationRemoveFile.toolTipText"));
        this.btnLocationRemoveFile.setBorder(new SoftBevelBorder(0));
        this.btnLocationRemoveFile.setPreferredSize(new Dimension(35, 35));
        this.btnLocationRemoveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.btnLocationRemoveFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnLocationRemoveFile, gridBagConstraints);
        this.btnLocationEditImage.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationEditImage, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnLocationEditImage.text"));
        this.btnLocationEditImage.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnLocationEditImage.toolTipText"));
        this.btnLocationEditImage.setBorder(new SoftBevelBorder(0));
        this.btnLocationEditImage.setPreferredSize(new Dimension(35, 35));
        this.btnLocationEditImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.btnLocationEditImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnLocationEditImage, gridBagConstraints);
        this.btnRotateCW.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/rotateCW24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRotateCW, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnRotateCW.text"));
        this.btnRotateCW.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnRotateCW.toolTipText"));
        this.btnRotateCW.setBorder(new SoftBevelBorder(0));
        this.btnRotateCW.setMinimumSize(new Dimension(35, 35));
        this.btnRotateCW.setPreferredSize(new Dimension(35, 35));
        this.btnRotateCW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.btnRotateCWActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnRotateCW, gridBagConstraints);
        this.btnRotateCCW.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/rotateCCW24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRotateCCW, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnRotateCCW.text"));
        this.btnRotateCCW.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnRotateCCW.toolTipText"));
        this.btnRotateCCW.setBorder(new SoftBevelBorder(0));
        this.btnRotateCCW.setMinimumSize(new Dimension(35, 35));
        this.btnRotateCCW.setPreferredSize(new Dimension(35, 35));
        this.btnRotateCCW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.btnRotateCCWActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnRotateCCW, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty1, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.lblEmpty1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelLocationFilesButtons.add((Component)this.lblEmpty1, gridBagConstraints);
        this.btnCutImage.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCutImage, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnCutImage.text"));
        this.btnCutImage.setBorder(new SoftBevelBorder(0));
        this.btnCutImage.setPreferredSize(new Dimension(35, 35));
        this.btnCutImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.btnCutImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panelLocationFilesButtons.add((Component)this.btnCutImage, gridBagConstraints);
        this.btnPasteImage.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPasteImage, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnPasteImage.text"));
        this.btnPasteImage.setBorder(new SoftBevelBorder(0));
        this.btnPasteImage.setPreferredSize(new Dimension(35, 35));
        this.btnPasteImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.btnPasteImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panelLocationFilesButtons.add((Component)this.btnPasteImage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.panelLocationFilesButtons, gridBagConstraints);
        this.jLabel35.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel35, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.jLabel35.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel35, gridBagConstraints);
        this.jScrollPane13.setMaximumSize(null);
        this.jScrollPane13.setMinimumSize(new Dimension(100, 60));
        this.jScrollPane13.setPreferredSize(new Dimension(200, 50));
        this.lstLocationFiles.setFont(THEMIS.fontList);
        this.lstLocationFiles.setModel(new DefaultListModel());
        this.lstLocationFiles.setMaximumSize(null);
        this.lstLocationFiles.setMinimumSize(null);
        this.lstLocationFiles.setPreferredSize(null);
        this.lstLocationFiles.setVisibleRowCount(7);
        this.lstLocationFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                UploadAttributePanel.this.lstLocationFilesValueChanged(evt);
            }
        });
        this.jScrollPane13.setViewportView(this.lstLocationFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane13, gridBagConstraints);
        this.jPanel26.setLayout(new GridBagLayout());
        this.recordButton1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/record24.gif")));
        this.recordButton1.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.recordButton1.toolTipText"));
        this.recordButton1.setBorder(new SoftBevelBorder(0));
        this.recordButton1.setPreferredSize(new Dimension(35, 35));
        this.recordButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.recordButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel26.add((Component)this.recordButton1, gridBagConstraints);
        this.playButton1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/play24.gif")));
        this.playButton1.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.playButton1.toolTipText"));
        this.playButton1.setBorder(new SoftBevelBorder(0));
        this.playButton1.setPreferredSize(new Dimension(35, 35));
        this.playButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.playButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel26.add((Component)this.playButton1, gridBagConstraints);
        this.stopButton1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/stop24.gif")));
        this.stopButton1.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.stopButton1.toolTipText"));
        this.stopButton1.setBorder(new SoftBevelBorder(0));
        this.stopButton1.setPreferredSize(new Dimension(35, 35));
        this.stopButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.stopButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel26.add((Component)this.stopButton1, gridBagConstraints);
        this.playExternalLoc.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/open_external24.gif")));
        this.playExternalLoc.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.playExternalLoc.toolTipText"));
        this.playExternalLoc.setBorder(new SoftBevelBorder(0));
        this.playExternalLoc.setPreferredSize(new Dimension(35, 35));
        this.playExternalLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.playExternalLocActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 15, 0, 10);
        this.jPanel26.add((Component)this.playExternalLoc, gridBagConstraints);
        this.btnRemoveAudio1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveAudio1, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnRemoveAudio1.text"));
        this.btnRemoveAudio1.setToolTipText(NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.btnRemoveAudio1.toolTipText"));
        this.btnRemoveAudio1.setBorder(new SoftBevelBorder(0));
        this.btnRemoveAudio1.setMinimumSize(new Dimension(35, 35));
        this.btnRemoveAudio1.setPreferredSize(new Dimension(35, 35));
        this.btnRemoveAudio1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadAttributePanel.this.btnRemoveAudio1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.jPanel26.add((Component)this.btnRemoveAudio1, gridBagConstraints);
        this.lblFileInfo1.setFont(THEMIS.fontInfo);
        Mnemonics.setLocalizedText((JLabel)this.lblFileInfo1, (String)NbBundle.getMessage(UploadAttributePanel.class, (String)"UploadAttributePanel.lblFileInfo1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.jPanel26.add((Component)this.lblFileInfo1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel26, gridBagConstraints);
    }

    private void btnLocationCaptureImageActionPerformed(ActionEvent evt) {
        this.captureImage();
    }

    private void btnLocationAddFileActionPerformed(ActionEvent evt) {
        if (!this.allowEdit) {
            return;
        }
        this.changed = true;
        boolean success = false;
        try {
            File f = new ThemisFileDialog("Bilder hinzuf\u00fcgen", ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getFileFolder(), null, THEMIS.getFileFilter(), null, false).getSelectedFile();
            if (f == null) {
                return;
            }
            File outputfile = null;
            try {
                BufferedImage image = this.imageSize == 0 ? ImageIO.read(f) : Util.resizeImage((BufferedImage)ImageIO.read(f), (int)this.imageSize);
                outputfile = new File(this.app.getProject().getTempfileLocation(), f.getName());
                success = THEMIS.createImageFile(image, outputfile, this.app.getSettings().getImageUploadQuality());
            }
            catch (IOException image) {
                // empty catch block
            }
            if (success) {
                UploadItem item = this.element.getUploadAttribute("files").addUpload(outputfile);
                if (item != null && this.app.getSettings().getImageKeepOriginal()) {
                    Util.copy((File)f, (File)new File(this.project.getImagefileLocation(), item.createFilename()));
                }
                this.populateUploads();
            }
            this.app.setFileFolder(f);
        }
        catch (Exception ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.errWhileAssigningFileNotic.text"), ex);
        }
    }

    private void btnLocationRemoveFileActionPerformed(ActionEvent evt) {
        if (!this.allowEdit) {
            return;
        }
        UploadItem uploadItem = this.selectedLocationImage;
        if (uploadItem == null) {
            return;
        }
        try {
            if (Dialogs.getInstance().showConfirmDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.reallyDeleteFileNotif.text"), uploadItem.getFilename()), ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.deleteFile.text"))) {
                this.element.getUploadAttribute("files").deleteUpload(uploadItem);
                this.changed = true;
                this.populateUploads();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnLocationEditImageActionPerformed(ActionEvent evt) {
        this.editImages(this.element);
    }

    private void btnRotateCWActionPerformed(ActionEvent evt) {
        this.rotateImage(this.element, this.selectedLocationImage, 90.0);
    }

    private void btnRotateCCWActionPerformed(ActionEvent evt) {
        this.rotateImage(this.element, this.selectedLocationImage, -90.0);
    }

    private void btnCutImageActionPerformed(ActionEvent evt) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void lstLocationFilesValueChanged(ListSelectionEvent evt) {
        this.updateComponentVisibility();
        try {
            UploadItem uploadItem;
            if (this.lstLocationFiles.getModel().getSize() > 0 && !(uploadItem = (UploadItem)this.lstLocationFiles.getSelectedValue()).isAudio()) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recordButton1ActionPerformed(ActionEvent evt) {
        if (!this.allowEdit) {
            return;
        }
        this.changed = true;
        this.captureAudio();
    }

    private void playButton1ActionPerformed(ActionEvent evt) {
        this.playAudio();
    }

    private void stopButton1ActionPerformed(ActionEvent evt) {
        this.stopAudio();
    }

    private void playExternalLocActionPerformed(ActionEvent evt) {
        if (this.audiofile == null) {
            Dialogs.getInstance().showErrorDialog(this.project.getResourceText("error.no-audiofile-selected", this.app.getLocale()));
            return;
        }
        if (!this.audiofile.isFile()) {
            Dialogs.getInstance().showErrorDialog(this.project.getResourceText("error.audiofile-not-available", this.app.getLocale()));
            return;
        }
        try {
            Desktop.getDesktop().open(this.audiofile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void btnRemoveAudio1ActionPerformed(ActionEvent evt) {
        if (!this.allowEdit) {
            return;
        }
        UploadItem uploadItem = (UploadItem)this.lstLocationFiles.getSelectedValue();
        if (uploadItem == null) {
            return;
        }
        try {
            if (Dialogs.getInstance().showConfirmDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.reallyDeleteFileNotif.text"), uploadItem.getFilename()), ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.deleteFile.text"))) {
                this.element.getUploadAttribute("files").deleteUpload(uploadItem);
                this.changed = true;
                this.populateUploads();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnPasteImageActionPerformed(ActionEvent evt) {
    }

    static enum Position {
        LEFT,
        RIGHT,
        NORMAL;

    }
}

