/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.update;

import at.grid.util.NumberRange;
import at.grid.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;

public class UpdateInfo {
    private final String version;
    private final int build;
    private final int silentBuild;
    private final int fullInstall;
    private final String jre;
    private final String hint;
    private final String type;
    private final String datetime;
    private final Map<Integer, String> whatsnew;
    private final Map<NumberRange, String> urgent;
    private final String url;

    public UpdateInfo(String version, int build, int silentBuild, int fullInstall, String jre, String hint, String type, String datetime, Map<Integer, String> whatsnew, Map<NumberRange, String> urgent, String url) {
        this.version = version;
        this.build = build;
        this.silentBuild = silentBuild;
        this.fullInstall = fullInstall;
        this.jre = jre;
        this.hint = hint;
        this.type = type;
        this.datetime = datetime;
        this.whatsnew = whatsnew;
        this.urgent = urgent;
        this.url = url;
    }

    public static UpdateInfo fromXml(Document doc, String url) {
        Element root = doc.getRootElement();
        String version = root.getChildText("version");
        int build = Util.parseInt((String)root.getChildText("buildnr"), (int)0);
        int silentBuild = Util.parseInt((String)root.getChildText("silent"), (int)0);
        int fullInstall = Util.parseInt((String)root.getChildText("fullinstall"), (int)0);
        String jre = root.getChildText("jre");
        String hint = root.getChildText("hint");
        String type = root.getChildText("type");
        String datetime = root.getChildText("datetime");
        HashMap<Integer, String> whatsnew = new HashMap<Integer, String>();
        for (Element element : root.getChildren("whatsnew")) {
            int buildNr = Util.parseInt((String)element.getAttributeValue("build", String.valueOf(build)), (int)build);
            String wn = "";
            if (whatsnew.containsKey(buildNr)) {
                wn = (String)whatsnew.get(buildNr) + "\n";
            }
            wn = wn + element.getText();
            whatsnew.put(buildNr, wn);
        }
        HashMap<NumberRange, String> urgent = new HashMap<NumberRange, String>();
        for (Element element : root.getChildren("urgent")) {
            String buildRange = element.getAttributeValue("build", "");
            NumberRange nr = new NumberRange(buildRange);
            urgent.put(nr, element.getText());
        }
        return new UpdateInfo(version, build, silentBuild, fullInstall, jre, hint, type, datetime, whatsnew, urgent, url);
    }

    public String getVersion() {
        return this.version;
    }

    public int getBuild() {
        return this.build;
    }

    public int getSilentBuild() {
        return this.silentBuild;
    }

    public int getFullInstall() {
        return this.fullInstall;
    }

    public String getJre() {
        return this.jre;
    }

    public String getHint() {
        return this.hint;
    }

    public String getType() {
        return this.type;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public Map<Integer, String> getWhatsnew() {
        return this.whatsnew;
    }

    public Map<NumberRange, String> getUrgent() {
        return this.urgent;
    }

    public String getUrl() {
        return this.url;
    }
}

