/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.update;

import at.grid.themis.application.Installer;
import at.grid.themis.application.UpdateManager;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.update.UpdateInfo;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.javafx.ThemisTaskWithFxDialog;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.application.Platform;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.LifecycleManager;

public class UpdateManager2 {
    public static String THEMIS_FILE_NAME = "themis_version.xml";
    public static List<String> UPDATE_URLS = Arrays.asList("https://update.themis-software.at/", "https://update.themis-software.com/", "http://update.themis-software.com/");
    private static UpdateManager2 instance = null;

    public static UpdateManager2 getInstance() {
        if (instance == null) {
            instance = new UpdateManager2();
        }
        return instance;
    }

    private UpdateManager2() {
    }

    public UpdateInfo loadUpdateInfo(ProgressHandler ph) {
        ph.progress("Info zu Updates wird geladen ...");
        ArrayList<UpdateInfo> infos = new ArrayList<UpdateInfo>();
        switch (ThemisApplication.getInstance().getConfiguration("system.update.source.selection")) {
            case "1": {
                infos.add(this.loadFromFile(null));
            }
            case "2": {
                UPDATE_URLS.forEach(url -> infos.add(this.loadFromBetaServer(null, (String)url)));
                break;
            }
            case "3": {
                UPDATE_URLS.forEach(url -> infos.add(this.loadFromAlphaServer(null, (String)url)));
                break;
            }
            default: {
                UPDATE_URLS.forEach(url -> infos.add(this.loadFromServer(null, (String)url, "")));
            }
        }
        UpdateInfo result = null;
        for (UpdateInfo info : infos) {
            if (result != null && result.getBuild() >= info.getBuild()) continue;
            result = info;
        }
        return result;
    }

    public void downloadUpdate(UpdateInfo info, ProgressHandler ph) throws IOException {
        File destFile = this.getDestinationFile(info);
        if (destFile == null) {
            return;
        }
        if (destFile.exists()) {
            destFile.delete();
        }
        switch (ThemisApplication.getInstance().getConfiguration("system.update.source.selection")) {
            case "1": {
                ph.progress("Update wird kopiert ...");
                Util.copy((File)new File(info.getUrl(), destFile.getName()), (File)destFile);
            }
        }
        ph.progress("Update wird heruntergeladen ...");
        URL urlFile = new URL(info.getUrl() + destFile.getName());
        Util.copy((URL)urlFile, (File)destFile, (ProgressHandler)ph);
        ph.progress("Update wird ausgef\u00fchrt ...");
        switch (ThemisApplication.getInstance().getSettings().getUpdateMethod()) {
            case INSTALLER: {
                ph.progress("Update wird gestartet ...", 4);
                Dialogs.getInstance().showInfoDialog("Die Updates wurden heruntergeladen. Der Update-Prozess wird jetzt gestartet, THEMIS wird dazu beendet.");
                Runtime.getRuntime().exec(destFile.getAbsolutePath() + " /prevDir=\"" + new File("").getAbsolutePath() + "\"");
                Installer.ask = false;
                LifecycleManager.getDefault().exit();
                break;
            }
            case MODULE: {
                UpdateManager.unzipFile(destFile);
                File fld0 = new File(destFile.getAbsoluteFile().getParentFile(), Util.getFileNameWithoutExtension((File)destFile));
                if (fld0.listFiles().length > 0) {
                    File fld1 = fld0.listFiles()[0];
                    for (File ff : fld1.listFiles()) {
                        if (!ff.isFile()) continue;
                        ff.renameTo(new File(destFile.getAbsoluteFile().getParentFile(), ff.getName()));
                    }
                }
                destFile.delete();
                fld0.delete();
                Dialogs.getInstance().showInfoDialog("Die Updates wurden heruntergeladen. Der Update-Prozess wird jetzt gestartet, THEMIS wird dazu beendet. Starten Sie THEMIS neu, um das Update einzuspielen.");
                Installer.ask = false;
                LifecycleManager.getDefault().exit();
                break;
            }
            case ZIP: {
                UpdateManager.unzipFile(destFile);
                Dialogs.getInstance().showInfoDialog("Die Updates wurden heruntergeladen und entpackt. Sie k\u00f6nnen die neue Version jetzt verwenden. Sie m\u00fcssen ggf. ihre Verkn\u00fcpfungen auf dem Desktop oder im Startmen\u00fc manuell anpassen. THEMIS wird jetzt beendet.");
                Installer.ask = false;
                LifecycleManager.getDefault().exit();
            }
        }
    }

    private File getDestinationFile(UpdateInfo info) {
        String versionText = info.getVersion() + "-" + info.getBuild();
        File destFolder = null;
        String filename = null;
        switch (ThemisApplication.getInstance().getSettings().getUpdateMethod()) {
            case INSTALLER: {
                destFolder = ThemisApplication.getInstance().getApplicationDataUpdateFolder();
                filename = "THEMIS_v" + versionText + "_64bit_setup.exe";
                break;
            }
            case MODULE: {
                destFolder = new File("themis/update/download");
                filename = "THEMIS_v" + versionText + "_modules.zip";
                break;
            }
            case ZIP: {
                destFolder = new File(".").getAbsoluteFile().getParentFile().getParentFile();
                filename = "THEMIS_v" + versionText + ".zip";
            }
        }
        if (destFolder == null || !destFolder.exists() || !destFolder.isDirectory() || filename == null || filename.trim().isEmpty()) {
            return null;
        }
        return new File(destFolder, filename);
    }

    public void execute() {
        Platform.runLater(() -> ThemisTaskWithFxDialog.createTask((String)"Update", ph -> {
            try {
                this.execute(ph);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }

    private void execute(ProgressHandler ph) throws IOException {
        UpdateInfo info = this.loadUpdateInfo(ph);
        if (info == null) {
            throw new IOException("Unable to fetch update info!");
        }
        this.downloadUpdate(info, ph);
    }

    private UpdateInfo loadFromFile(ProgressHandler ph) {
        try {
            String folder = ThemisApplication.getInstance().getConfiguration("system.update.source");
            if (folder == null || folder.trim().isEmpty()) {
                return null;
            }
            File fld = new File(folder);
            if (!fld.isDirectory()) {
                return null;
            }
            File file = new File(fld, THEMIS_FILE_NAME);
            if (!file.exists()) {
                return null;
            }
            SAXBuilder saxbuilder = new SAXBuilder(false);
            return UpdateInfo.fromXml(saxbuilder.build(file), folder);
        }
        catch (IOException | JDOMException ex) {
            return null;
        }
    }

    private UpdateInfo loadFromBetaServer(ProgressHandler ph, String url) {
        return this.loadFromServer(ph, url, "beta");
    }

    private UpdateInfo loadFromAlphaServer(ProgressHandler ph, String url) {
        return this.loadFromServer(ph, url, "alpha");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UpdateInfo loadFromServer(ProgressHandler ph, String updateUrl, String stadium) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ThemisLicense license = ThemisApplication.getInstance().getLicense();
        String latestVersion = "";
        try {
            latestVersion = Util.urlToString((URL)new URL(updateUrl + "currentversion"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (latestVersion == null || latestVersion.trim().isEmpty()) {
            latestVersion = Float.toString(6.1f);
        }
        try {
            String urlbase = updateUrl + "themis_v" + latestVersion + "/update" + stadium + "/";
            URL url = new URL(urlbase + "themis_version.xml?currentbuild=" + 2146 + "&reference=" + (license == null ? "0" : Integer.valueOf(license.getClientID())));
            ph.progress("Checking version " + latestVersion + " " + stadium.toUpperCase());
            if (!Util.checkUrlConnection((String)(urlbase + "themis_version.xml"))) {
                ThemisApplication.getInstance().getProject().getLogger().warning("Update server at '" + urlbase + "' not available");
                return null;
            }
            try (InputStream in = Util.getInputStream((URL)url);){
                UpdateInfo updateInfo = UpdateInfo.fromXml(new SAXBuilder(false).build(in), urlbase);
                return updateInfo;
            }
        }
        catch (IOException | JDOMException ex) {
            ThemisApplication.getInstance().getProject().getLogger().severe("Exception in UpdateManager: \n" + ex);
            return null;
        }
    }

    public boolean isUpdateSourceLocal() {
        return Util.parseInt((String)ThemisApplication.getInstance().getConfiguration("system.update.source.selection", "0"), (int)0) == 1;
    }

    public boolean isUpdateBetaProgram() {
        return Util.parseInt((String)ThemisApplication.getInstance().getConfiguration("system.update.source.selection", "0"), (int)0) >= 2;
    }

    public boolean isUpdateAlphaProgram() {
        return Util.parseInt((String)ThemisApplication.getInstance().getConfiguration("system.update.source.selection", "0"), (int)0) >= 3;
    }
}

