/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.util;

import at.grid.themis.application.THEMIS;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.action.SimpleAction;
import at.grid.themis.ontology.javafx.JavaFxProgressBar;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.ThemisTask;
import at.grid.util.ProgressHandler;
import javafx.scene.Node;

public abstract class ThemisTaskWithDialog
extends ThemisTask {
    private final JavaFxSwingDialog dlg;
    JavaFxProgressBar progressPane;
    Object returnValue = null;

    public ThemisTaskWithDialog(String title, boolean withCancel, boolean withCounter) {
        this.dlg = new JavaFxSwingDialog(title, 300, 160).setParentFrame(THEMIS.getMainWindow());
        this.progressPane = new JavaFxProgressBar((ThemisTask)this, withCancel, withCounter);
        this.dlg.setResizeable(false);
        this.dlg.setContent((Node)this.progressPane);
        this.dlg.show();
    }

    public static ThemisTaskWithDialog createTask(String title, final SimpleAction a) {
        return new ThemisTaskWithDialog(title, false, false){

            @Override
            public void execute(ProgressHandler ph) {
                a.execute(ph);
            }
        };
    }

    public static ThemisTaskWithDialog createTaskWithCounter(String title, final SimpleAction a) {
        return new ThemisTaskWithDialog(title, false, true){

            @Override
            public void execute(ProgressHandler ph) {
                a.execute(ph);
            }
        };
    }

    public static ThemisTaskWithDialog createTaskWithCancel(String title, final SimpleAction a) {
        return new ThemisTaskWithDialog(title, true, false){

            @Override
            public void execute(ProgressHandler ph) {
                a.execute(ph);
            }
        };
    }

    public static ThemisTaskWithDialog createTaskWithCounterAndCancel(String title, final SimpleAction a) {
        return new ThemisTaskWithDialog(title, true, true){

            @Override
            public void execute(ProgressHandler ph) {
                a.execute(ph);
            }
        };
    }

    public ThemisTaskWithDialog withCancel() {
        this.progressPane.enableCancel();
        return this;
    }

    public ThemisTaskWithDialog withCounter() {
        this.progressPane.enableCounter();
        return this;
    }

    public ThemisTaskWithDialog setProgressPane(JavaFxProgressBar p) {
        this.progressPane = p;
        return this;
    }

    public void disableCancel() {
        this.progressPane.disableCancel();
    }

    public void closeDialog() {
        this.dlg.close();
    }

    public void setReturnValue(Object o) {
        this.returnValue = o;
    }

    protected Object call() throws Exception {
        try {
            this.execute((ProgressHandler)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            ThemisApplication.getInstance().getDialog().showErrorDialog("Undefinierter Fehler", e);
        }
        this.closeDialog();
        return this.returnValue;
    }

    public abstract void execute(ProgressHandler var1);

    public void setDisplayName(String t) {
        if (this.dlg != null) {
            this.dlg.setDialogTitle(t);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThemisTask ");
        if (this.isCancelled()) {
            sb.append("CANCELLED ");
        }
        if (this.progressPane.hasCancel()) {
            sb.append("with cancel ");
        }
        if (this.progressPane.hasCounter()) {
            sb.append("with counter ");
        }
        sb.append(this.getCurrentProgress()).append(" von ").append(this.getWorkunits());
        return sb.toString();
    }
}

