/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.util;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.webdav.NextCloudWebDAV;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WebDavFileList
extends JPanel {
    private String DIALOG_CODE = "webdavfilelist";
    public static final int DIALOG_WIDTH = 500;
    public static final int DIALOG_HEIGHT = 580;
    DIALOG_STATE dialog_state = DIALOG_STATE.CANCEL;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    NextCloudWebDAV webdav = null;
    String user;
    File targetfile = null;
    boolean error = false;
    String pwd = null;
    private JButton btnCancel;
    private JButton btnOk;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JList<String> lstFiles;

    public WebDavFileList(String url, String pwd) {
        this.initComponents();
        this.project.getLogger().info("WebDav using " + (pwd == null || "".equals(pwd) ? "as anonymous" : "with password"));
        this.pwd = pwd;
        this.lstFiles.setCellRenderer(new SimpleTextRenderer());
        if (url.contains("/s/")) {
            this.user = url.substring(url.lastIndexOf("/") + 1);
            this.webdav = NextCloudWebDAV.fromShareUrl((String)url, (String)this.pwd);
        } else {
            this.user = "anonymous";
            this.webdav = new NextCloudWebDAV(url, this.user, this.pwd);
        }
        this.webdav.setLogger(this.project.getLogger());
        this.readFiles(url, pwd);
    }

    public void readFiles(String url, String pwd) {
        try {
            ArrayList filenames = this.webdav.getFilenames("");
            DefaultListModel m = (DefaultListModel)this.lstFiles.getModel();
            m.clear();
            for (String fn : filenames) {
                if (!fn.toLowerCase().endsWith(".themis")) continue;
                m.addElement(fn);
            }
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog("error.server-access", ex.getMessage());
            ex.printStackTrace();
            this.error = true;
        }
    }

    public boolean hasError() {
        return this.error;
    }

    private boolean download() {
        final String fn = this.lstFiles.getSelectedValue();
        if (fn == null) {
            Dialogs.getInstance().showErrorDialog("error.no-file-selected");
            return false;
        }
        this.targetfile = this.project.isOpen() ? new File(this.project.getTempfileLocation(), fn) : new File(this.app.getApplicationDataTempFolder(), fn);
        if (this.targetfile.exists()) {
            this.targetfile.delete();
        }
        BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    WebDavFileList.this.webdav.getFile("", fn, WebDavFileList.this.targetfile);
                }
                catch (IOException ex) {
                    WebDavFileList.this.project.getLogger().severe("WEBDAV IO error: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }, (String)this.project.getResourceText("progress.downloading-themis-file"));
        return this.targetfile.isFile();
    }

    public File getTargetfile() {
        return this.targetfile;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstFiles = new JList();
        this.jPanel1 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WebDavFileList.class, (String)"WebDavFileList.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.lstFiles.setFont(THEMIS.fontList);
        this.lstFiles.setModel(new DefaultListModel());
        this.jScrollPane1.setViewportView(this.lstFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnOk, (String)NbBundle.getMessage(WebDavFileList.class, (String)"WebDavFileList.btnOk.text"));
        this.btnOk.setMinimumSize(new Dimension(140, 30));
        this.btnOk.setPreferredSize(new Dimension(140, 30));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebDavFileList.this.btnOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(WebDavFileList.class, (String)"WebDavFileList.btnCancel.text"));
        this.btnCancel.setMinimumSize(new Dimension(140, 30));
        this.btnCancel.setPreferredSize(new Dimension(140, 30));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebDavFileList.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnCancel, gridBagConstraints);
        this.add((Component)this.jPanel1, new GridBagConstraints());
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.download()) {
            this.closeDialog();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.targetfile = null;
        this.closeDialog();
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(this.project.getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, true);
        THEMIS.setAssistantMoveListener(dlg);
        THEMIS.applyWindowSizeAndLocation(this.DIALOG_CODE, dlg, 500, 580);
        dlg.setVisible(true);
    }

    private void closeDialog() {
        JDialog parent = (JDialog)this.getRootPane().getParent();
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, parent);
        parent.dispose();
    }

    public DIALOG_STATE getDialogState() {
        return this.dialog_state;
    }

    public static enum DIALOG_STATE {
        OK,
        CANCEL;

    }
}

