/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.welcome;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.ThemisLocalProjectsPanel;
import at.grid.themis.application.UpdateManager;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.config.LoadSettingsPanel;
import at.grid.themis.application.license.ThemisLicensePanel;
import at.grid.themis.application.project.ProjectHelper;
import at.grid.themis.application.project.ProjectListDetailHandler;
import at.grid.themis.application.project.ProjectListTablePanel;
import at.grid.themis.application.statistics.ProjectStatisticsPanel;
import at.grid.themis.application.ui.DirectoryTreePanel;
import at.grid.themis.application.ui.FileTreeRenderer;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColors;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisFileImportSummary;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisLock;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.server.ConfigureServerFxPanel;
import at.grid.themis.ontology.license.LicenseUtils;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.ImageHelper;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.JDOMException;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ThemisWelcomeTopComponent", persistenceType=0)
public final class ThemisWelcomeTopComponent
extends TopComponent
implements ThemisActionListener,
ProjectListDetailHandler {
    private static final String LIST_LASTUSED = "Zuletzt verwendet";
    private static final String LIST_LOCAL = "Ausgecheckte Projekte";
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private final Dimension dimImage = new Dimension(120, 80);
    private final ImageIcon defaultProjectImage;
    private final ProjectListTablePanel projectListManager;
    private final DirectoryTreePanel explorer;
    private final DragScrollHandler projectListDragHandler;
    private ListSource listSource;
    private String currentList;
    private ThemisFolder selectedFolder;
    private JButton btnAdd;
    private JButton btnCopyProject;
    private JButton btnCreateProject;
    private JButton btnDeleteProject;
    private JButton btnEdit;
    private JButton btnEditProject;
    private JButton btnLoadThemisFile;
    private JButton btnNoLicense;
    private JButton btnOpenProject;
    private JButton btnRemove;
    private JButton btnSelectAction;
    private JCheckBox chkIncludSubfolder;
    private JLabel empty;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lbl1;
    private JLabel lbl2;
    private JLabel lbl3;
    private JLabel lbl4;
    private JLabel lbl5;
    private JLabel lblCountSelect;
    private JLabel lblDetailCreated;
    private JLabel lblDetailFolder;
    private JLabel lblDetailImage;
    private JLabel lblDetailLastAccess;
    private JLabel lblDetailLastEvent;
    private JLabel lblDetailNextEvent;
    private JLabel lblDetailTitel;
    private JLabel lblListContent;
    private JLabel lblListContent1;
    private JLabel lblLogo;
    private JLabel lblSplash;
    private JLabel lblThemisUpdate;
    private JLabel lblThemisVersion;
    private JList<String> lstProjectLists;
    private JPanel panelDetails;
    private JPanel panelHead;
    private JPanel panelMain;
    private JPanel panelProjectControls;
    private JPanel panelProjectList;
    private JPanel panelThemisInfo;
    private JSplitPane splitLeft;
    private JSplitPane splitMain;

    public ThemisWelcomeTopComponent() {
        this.defaultProjectImage = new ImageIcon(Util.resizeImage((URL)this.getClass().getResource("/at/grid/themis/application/media/projectImage.gif"), (int)this.dimImage.width, (int)this.dimImage.height, (int)2));
        this.initComponents();
        this.setName(ResourceBundle.getBundle("at/grid/themis/application/welcome/Bundle").getString("CTL_ShowWelcomeScreenAction"));
        this.setToolTipText(ResourceBundle.getBundle("at/grid/themis/application/welcome/Bundle").getString("CTL_ShowWelcomeScreenAction"));
        this.putClientProperty("netbeans.winsys.tc.dragging_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.undocking_disabled", Boolean.TRUE);
        this.lblDetailImage.setSize(this.dimImage);
        this.lblThemisVersion.setText("Version " + this.app.getProject().getVersion());
        try {
            if (new UpdateManager().isUpdateAvailable().equalsIgnoreCase("yes")) {
                this.lblThemisUpdate.setText("Ein UPDATE ist verf\u00fcgbar!");
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.projectListDragHandler = new DragScrollHandler(this.panelProjectList);
        this.projectListManager = new ProjectListTablePanel(this);
        THEMIS.setCheckboxIcon(this.chkIncludSubfolder);
        this.populateProjectListCollection();
        File rootFolder = this.app.getSettings().getFolderProjectRoot().getValue(true);
        this.explorer = new DirectoryTreePanel(rootFolder, new FileTreeRenderer(), this);
        this.splitLeft.setTopComponent(this.explorer);
        ThemisDropTargetListener themisFileDropListener = new ThemisDropTargetListener(false, false, new String[]{"themis"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ThemisWelcomeTopComponent.this.openThemisFile(f);
            }
        };
        new DropTarget(this.explorer, themisFileDropListener);
        new DropTarget(this.panelMain, themisFileDropListener);
        new DropTarget(this.panelProjectList, themisFileDropListener);
        this.btnLoadThemisFile.setVisible(LicenseUtils.isClientEquals((LicenseUtils.Client)LicenseUtils.Client.GRID_IT) || LicenseUtils.isClientEquals((LicenseUtils.Client)LicenseUtils.Client.WIENERWOHNEN) || LicenseUtils.isClientEquals((LicenseUtils.Client)LicenseUtils.Client.IPB_BACHMANN));
        this.chkIncludSubfolder.setSelected(false);
        this.updateLicenseDisplay();
        ThemisActionProvider.getInstance().register(this);
        this.revalidate();
        int licenseLevel = ThemisLicense.getLicenseLevel((ThemisApplication)this.app);
        this.populateProjectListFromRecent();
    }

    public void onAction(ThemisAction action) {
        if (action.getSource() == this) {
            return;
        }
        switch (action.getAction()) {
            case 1300: {
                this.updateLicenseDisplay();
                break;
            }
            case 1101: {
                SwingUtilities.invokeLater(() -> ViewHelper.showStartScreen());
            }
        }
    }

    private void populateProjectList() {
        if (this.listSource == null) {
            this.listSource = ListSource.RECENT;
        }
        switch (this.listSource) {
            case FOLDER: {
                this.populateProjectListFromFolder(this.selectedFolder);
                this.chkIncludSubfolder.setEnabled(true);
                break;
            }
            case LIST: {
                this.populateProjectListFromCollection(this.currentList);
                this.chkIncludSubfolder.setEnabled(false);
                break;
            }
            default: {
                this.populateProjectListFromRecent();
                this.chkIncludSubfolder.setEnabled(false);
            }
        }
    }

    private void populateProjectListFromRecent() {
        this.lstProjectLists.setSelectedIndex(0);
    }

    public void showSelectedFolder(ThemisFolder themisFolder) {
        this.lstProjectLists.clearSelection();
        this.populateProjectListFromFolder(themisFolder);
    }

    public void setIncludeSubfolder(boolean flg) {
        this.chkIncludSubfolder.setSelected(flg);
    }

    public void populateProjectListFromFolder(ThemisFolder sel) {
        String fld;
        this.project.getLogger().fine("populating project list: " + (sel == null ? "NULL" : sel.toString()));
        this.listSource = ListSource.FOLDER;
        this.selectedFolder = sel;
        if (sel == null) {
            this.populateProjectList("Kein Ordner ausgew\u00e4hlt", new ArrayList<File>(), new ArrayList<File>());
            return;
        }
        this.chkIncludSubfolder.setEnabled(true);
        boolean includeSub = this.chkIncludSubfolder.isSelected();
        ArrayList files = ThemisApplication.getInstance().getProject().getProjects(sel.getProjectFolder(), includeSub);
        this.project.getLogger().fine("found " + (files == null ? "NULL" : Integer.valueOf(files.size())) + " projects");
        File[] files2 = sel.getProjectFolder().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".themis");
            }
        });
        this.project.getLogger().fine("found " + (files2 == null ? "NULL" : Integer.valueOf(files2.length)) + " *.themis files");
        ArrayList<File> themisFiles = new ArrayList<File>();
        if (files2 != null) {
            for (File f : files2) {
                themisFiles.add(f);
            }
        }
        if ((fld = sel.getProjectFolder().getAbsolutePath()).length() > 100) {
            fld = fld.substring(0, 15) + "<...>" + fld.substring(fld.length() - 85);
        }
        String description = "Projekte im Ordner '" + fld + "'";
        this.populateProjectList(description, files, themisFiles);
    }

    private void populateProjectListFromCollection(String sel) {
        if (sel == null) {
            return;
        }
        this.listSource = ListSource.LIST;
        this.currentList = sel;
        this.chkIncludSubfolder.setEnabled(false);
        ArrayList<File> projects = new ArrayList<File>();
        String description = "";
        switch (sel) {
            case "Zuletzt verwendet": {
                projects.addAll(this.app.getRecentProjectList());
                description = "Zuletzt ge\u00f6ffnete Projekte";
                break;
            }
            case "Ausgecheckte Projekte": {
                description = LIST_LOCAL;
                ArrayList localProjects = this.app.getProject().checkLocalProjects();
                if (localProjects.isEmpty()) break;
                ThemisLocalProjectsPanel panel = new ThemisLocalProjectsPanel();
                panel.showDialog();
                if (!panel.doOpenProject() || panel.getSelectedProject() == null) break;
                ThemisFolder f = panel.getSelectedProject();
                ProjectHelper.openProject(f);
                break;
            }
            default: {
                description = "Projektliste '" + sel + "'";
                for (ThemisFolder themis : this.app.getSettings().getProjectsForList(sel)) {
                    if (!themis.isProject()) continue;
                    projects.add(themis.getProjectFolder());
                }
            }
        }
        this.populateProjectList(description, projects, new ArrayList<File>());
    }

    private void populateProjectList(String description, List<File> projectFolders, List<File> themisFiles) {
        this.lblListContent.setText(description);
        this.projectListManager.clear();
        int counter = 0;
        this.project.getLogger().fine("populating project list manager with " + (projectFolders == null ? "NULL" : Integer.valueOf(projectFolders.size())) + " projects ...");
        for (File f : projectFolders) {
            ThemisFolder tf = new ThemisFolder(f);
            this.projectListManager.addProject(tf);
            ++counter;
        }
        this.project.getLogger().fine("generating list ... ");
        this.projectListManager.populateList();
        this.panelProjectList.removeAll();
        this.project.getLogger().fine("adding list to screen ... ");
        this.panelProjectList.add((Component)this.projectListManager, "Center");
        this.showProjectDetails(this.selectedFolder);
        this.updateProjectSelection(new ArrayList<ThemisFolder>());
    }

    @Override
    public void updateProjectSelection(ArrayList<ThemisFolder> sels) {
        this.lblCountSelect.setText(Integer.toString(sels.size()));
        this.btnSelectAction.setEnabled(sels.size() > 0);
        this.btnCopyProject.setEnabled(sels.size() == 1);
        this.btnDeleteProject.setEnabled(sels.size() > 0);
        this.btnEditProject.setEnabled(sels.size() == 1);
    }

    private void populateProjectListCollection() {
        DefaultListModel listmodel = (DefaultListModel)this.lstProjectLists.getModel();
        listmodel.clear();
        listmodel.addElement(LIST_LASTUSED);
        listmodel.addElement(LIST_LOCAL);
        for (String projectlist : this.app.getSettings().getProjectLists()) {
            listmodel.addElement(projectlist);
        }
    }

    private void getFolderContent(File f, DefaultMutableTreeNode node, int level) {
        this.project.getLogger().fine("retrieving folder content for " + (f == null ? "NULL" : f.toString()));
        node.removeAllChildren();
        Object[] files = f.listFiles(pathname -> pathname.isDirectory() && !ThemisProject.isProjectFolder((File)pathname));
        this.project.getLogger().fine("found " + (files == null ? "NULL" : Integer.valueOf(files.length)) + " folder");
        if (files != null) {
            Arrays.sort(files);
            this.project.getLogger().fine("folders sorted");
            for (Object file : files) {
                this.project.getLogger().fine("adding folder " + file);
                ThemisFolder themisfolder = new ThemisFolder((File)file);
                DefaultMutableTreeNode nextnode = new DefaultMutableTreeNode(themisfolder, !themisfolder.isProject());
                if (level < 1) {
                    this.getFolderContent((File)file, nextnode, level + 1);
                }
                try {
                    node.add(nextnode);
                }
                catch (Exception e) {
                    boolean bl = false;
                }
            }
        }
    }

    @Override
    public void openProject(ThemisFolder tf) {
        this.saveSplitSettings();
        ViewHelper.showOpenProject();
        ProjectHelper.openProject(tf, true, null);
        if (!this.app.getProject().isOpen()) {
            ViewHelper.showStartScreen();
        }
    }

    @Override
    public void showProjectDetails(final ThemisFolder tf) {
        File dataFolder;
        File imgFile;
        ActionListener[] listeners;
        this.project.getLogger().fine("showing details for " + (tf == null ? "NULL" : tf.toString()) + " ...");
        this.lblDetailImage.setIcon(null);
        this.btnOpenProject.setText("\u00d6ffnen");
        this.panelDetails.setBackground(ThemisColors.brightgray);
        this.lblDetailTitel.setText("kein Projekt");
        this.lblDetailFolder.setText("");
        this.lblDetailCreated.setText("");
        this.lblDetailLastAccess.setText("");
        this.lblDetailLastEvent.setText("");
        this.lblDetailNextEvent.setText("");
        this.btnOpenProject.setEnabled(false);
        for (ActionListener l : listeners = this.btnOpenProject.getActionListeners()) {
            this.btnOpenProject.removeActionListener(l);
        }
        if (tf == null) {
            return;
        }
        boolean islocal = tf.isLocal();
        if (!tf.isProject()) {
            return;
        }
        Properties prop = tf.loadProperties();
        String projectTitle = tf.getProjectTitle();
        final boolean projectLocked = tf.getProjectLock().isLocked();
        final boolean lockOnSameComputer = tf.getProjectLock().isUsedOnSameComputerAndUser();
        if (projectLocked) {
            if (lockOnSameComputer) {
                this.panelDetails.setBackground(ThemisColors.lightyellow);
                projectTitle = tf.getDatabaseFile().isFile() ? projectTitle + " [" + this.project.getResourceText("status.project-not-closed") + "]" : projectTitle + " [" + this.project.getResourceText("status.project-checkedout") + "]";
            } else {
                this.btnOpenProject.setText("Info");
                this.panelDetails.setBackground(ThemisColors.lightred);
                projectTitle = projectTitle + " [in Verwendung]";
            }
        }
        String projectImage = tf.getProjectImageName();
        ImageIcon icon = null;
        if (projectImage != null && !projectImage.isEmpty() && (imgFile = new File(dataFolder = new File(tf.getProjectFolder(), "data/project"), projectImage)).exists()) {
            BufferedImage img = null;
            try {
                img = ImageHelper.loadImage((File)imgFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (img != null) {
                icon = new ImageIcon(Util.resizeImage((BufferedImage)img, (int)this.dimImage.width, (int)this.dimImage.height, (int)2));
            }
        }
        if (icon == null) {
            icon = this.defaultProjectImage;
        }
        this.lblDetailImage.setIcon(icon);
        this.lblDetailTitel.setText(projectTitle);
        this.lblDetailFolder.setText(tf.getProjectFolder().getAbsolutePath());
        this.btnOpenProject.setEnabled(true);
        this.btnOpenProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (projectLocked && !lockOnSameComputer) {
                    boolean projectLocked2 = tf.getProjectLock().isLocked();
                    boolean lockOnSameComputer2 = tf.getProjectLock().isUsedOnSameComputerAndUser();
                    if (projectLocked2 && !lockOnSameComputer2) {
                        String lockComputer;
                        ThemisLock projectLock = tf.getProjectLock();
                        String lockUsername = projectLock.getUserName();
                        if (lockUsername == null) {
                            lockUsername = "keine Angabe";
                        }
                        if ((lockComputer = projectLock.getUserComputer()) == null) {
                            lockComputer = "keine Angabe";
                        }
                        ThemisApplication.getInstance().getDialog().showOpenLockedProjectDialog(lockUsername, projectLock.getLockTimeAsString(), lockComputer);
                    }
                } else {
                    ThemisWelcomeTopComponent.this.saveSplitSettings();
                    ViewHelper.showOpenProject();
                    ProjectHelper.openProject(tf, true, null);
                }
            }
        });
        this.lblDetailCreated.setText(prop.getProperty("access.first", "").split(" ")[0] + " / " + prop.getProperty("access.creator", ""));
        this.lblDetailLastAccess.setText(prop.getProperty("access.last", "").split(" ")[0] + " / " + prop.getProperty("access.last-user", ""));
        this.lblDetailLastEvent.setText(prop.getProperty("last.event", ""));
        this.lblDetailNextEvent.setText(prop.getProperty("next.event", ""));
    }

    private void createProject(ThemisFolder sel) {
        ProjectHelper.createProject(sel, null, null);
    }

    private void createNewProjectCollection() {
        String title = JOptionPane.showInputDialog(THEMIS.getMainWindow(), this.app.getProject().getResourceText("dialog.create-list.msg"), this.app.getProject().getResourceText("dialog.create-list.title"), 1);
        if (title != null && !"".equals(title) && !"-".equals(title)) {
            if (this.app.getSettings().hasProjectList(title)) {
                this.app.getDialog().showInfoDialog("projectlist.already-existing");
            } else {
                this.app.getSettings().addProjectList(title);
                this.populateProjectListCollection();
            }
        }
    }

    private void deleteProjectCollection(String title) {
        switch (title) {
            case "Zuletzt verwendet": 
            case "Ausgecheckte Projekte": {
                break;
            }
            default: {
                if (!this.app.getDialog().showConfirmDialog("Soll die Projektliste '" + title + "' wirklich gel\u00f6scht werden", "Projektliste l\u00f6schen")) break;
                this.app.getSettings().removeProjectList(title);
                this.populateProjectListCollection();
                if (this.listSource != ListSource.LIST || !this.currentList.equals(title)) break;
                this.populateProjectListFromRecent();
            }
        }
    }

    private void renameProjectCollection(String title) {
        switch (title) {
            case "Zuletzt verwendet": 
            case "Ausgecheckte Projekte": {
                break;
            }
            default: {
                String result = this.app.getDialog().showInputDialogFilled("Geben Sie einen neuen Namen f\u00fcr die Liste ein:", "Projektliste umbenennen", title);
                if (result == null) break;
                this.app.getSettings().renameProjectList(title, result);
                this.populateProjectListCollection();
            }
        }
    }

    private void loadProjectCollection() {
        File f = new ThemisFileDialog("Projektliste laden", ThemisFileDialog.DIALOGTYPE.OPEN, null, null, THEMIS.getProjectListFileFilter(), "projectlist", false).getSelectedFile();
        if (f != null) {
            try {
                ArrayList<ThemisFolder> projects = new ArrayList<ThemisFolder>();
                BufferedReader br = new BufferedReader(new FileReader(f));
                String ln = br.readLine();
                while (ln != null) {
                    File projectfolder = new File(ln);
                    if (ThemisProject.isProjectFolder((File)projectfolder)) {
                        projects.add(new ThemisFolder(projectfolder));
                    }
                    ln = br.readLine();
                }
                br.close();
                if (projects.isEmpty()) {
                    this.app.getDialog().showInfoDialog("Keine Projekte in der ausgew\u00e4hlten Datei");
                    return;
                }
                String result = this.app.getDialog().showInputDialogFilled("Geben Sie einen Namen f\u00fcr die Liste ein (" + projects.size() + " Projekte):", "Projektliste laden", Util.getFileNameWithoutExtension((File)f));
                if (result != null) {
                    for (ThemisFolder tf : projects) {
                        this.app.getSettings().addProjectToList(result, tf);
                    }
                    this.populateProjectListCollection();
                }
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void saveProjectCollection(String title) {
        ArrayList projects = this.app.getSettings().getProjectsForList(title);
        if (projects == null || projects.isEmpty()) {
            this.app.getDialog().showInfoDialog("Keine Projekte in der ausgew\u00e4hlten Liste");
            return;
        }
        File f = new ThemisFileDialog("Projektliste speichern", ThemisFileDialog.DIALOGTYPE.SAVE, null, null, THEMIS.getProjectListFileFilter(), "projectlist", false).getSelectedFile();
        if (f != null) {
            try {
                FileWriter fw = new FileWriter(f);
                for (ThemisFolder tf : projects) {
                    fw.write(tf.getProjectFolder().getAbsolutePath());
                    fw.write("\n");
                }
                fw.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected void openThemisFile(File f) {
        if (f == null || !f.isFile()) {
            return;
        }
        ProjectHelper.openProject(new ThemisFolder(f), false, null);
    }

    private void initComponents() {
        this.lblSplash = new JLabel();
        this.splitMain = new JSplitPane();
        this.splitLeft = new JSplitPane();
        this.jPanel5 = new JPanel();
        this.lblListContent1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstProjectLists = new JList();
        this.jPanel4 = new JPanel();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.panelMain = new JPanel();
        this.panelHead = new JPanel();
        this.lblListContent = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblCountSelect = new JLabel();
        this.panelProjectList = new JPanel();
        this.panelProjectControls = new JPanel();
        this.btnCreateProject = new JButton();
        this.btnCopyProject = new JButton();
        this.btnDeleteProject = new JButton();
        this.btnEditProject = new JButton();
        this.btnSelectAction = new JButton();
        this.chkIncludSubfolder = new JCheckBox();
        this.empty = new JLabel();
        this.btnLoadThemisFile = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.panelDetails = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblDetailImage = new JLabel();
        this.btnOpenProject = new JButton();
        this.jPanel1 = new JPanel();
        this.lblDetailTitel = new JLabel();
        this.lbl1 = new JLabel();
        this.lblDetailFolder = new JLabel();
        this.lbl2 = new JLabel();
        this.lblDetailCreated = new JLabel();
        this.lbl3 = new JLabel();
        this.lblDetailLastAccess = new JLabel();
        this.lbl4 = new JLabel();
        this.lblDetailLastEvent = new JLabel();
        this.lbl5 = new JLabel();
        this.lblDetailNextEvent = new JLabel();
        this.jLabel2 = new JLabel();
        this.panelThemisInfo = new JPanel();
        this.lblLogo = new JLabel();
        this.lblThemisVersion = new JLabel();
        this.lblThemisUpdate = new JLabel();
        this.btnNoLicense = new JButton();
        this.lblSplash.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/splash_image_welcome.jpg")));
        Mnemonics.setLocalizedText((JLabel)this.lblSplash, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblSplash.text"));
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.splitLeft.setDividerLocation(300);
        this.splitLeft.setOrientation(0);
        this.jPanel5.setBackground(new Color(255, 255, 255));
        this.jPanel5.setLayout(new GridBagLayout());
        this.lblListContent1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblListContent1, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblListContent1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.lblListContent1, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(258, 100));
        this.jScrollPane1.setPreferredSize(new Dimension(258, 100));
        this.lstProjectLists.setFont(THEMIS.fontListBig);
        this.lstProjectLists.setModel(new DefaultListModel());
        this.lstProjectLists.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ThemisWelcomeTopComponent.this.lstProjectListsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstProjectLists);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel5.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel4.setBackground(new Color(255, 255, 255));
        this.jPanel4.setLayout(new GridBagLayout());
        this.btnAdd.setFont(THEMIS.fontButton);
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnAdd.text"));
        this.btnAdd.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnAdd.toolTipText"));
        this.btnAdd.setBorder(new SoftBevelBorder(0));
        this.btnAdd.setMinimumSize(null);
        this.btnAdd.setPreferredSize(null);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisWelcomeTopComponent.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnAdd, gridBagConstraints);
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnEdit.text"));
        this.btnEdit.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnEdit.toolTipText"));
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.setEnabled(false);
        this.btnEdit.setMaximumSize(null);
        this.btnEdit.setMinimumSize(null);
        this.btnEdit.setPreferredSize(null);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisWelcomeTopComponent.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnEdit, gridBagConstraints);
        this.btnRemove.setFont(THEMIS.fontButton);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnRemove.toolTipText"));
        this.btnRemove.setBorder(new SoftBevelBorder(0));
        this.btnRemove.setEnabled(false);
        this.btnRemove.setMaximumSize(null);
        this.btnRemove.setMinimumSize(null);
        this.btnRemove.setPreferredSize(null);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisWelcomeTopComponent.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel5.add((Component)this.jPanel4, gridBagConstraints);
        this.splitLeft.setRightComponent(this.jPanel5);
        this.splitMain.setLeftComponent(this.splitLeft);
        this.panelMain.setBackground(new Color(255, 255, 255));
        this.panelMain.setLayout(new GridBagLayout());
        this.panelHead.setBackground(new Color(255, 255, 255));
        this.panelHead.setOpaque(false);
        this.panelHead.setLayout(new GridBagLayout());
        this.lblListContent.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblListContent, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblListContent.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelHead.add((Component)this.lblListContent, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.panelHead.add((Component)this.jLabel1, gridBagConstraints);
        this.lblCountSelect.setFont(THEMIS.fontLabelBigBold);
        Mnemonics.setLocalizedText((JLabel)this.lblCountSelect, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblCountSelect.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.panelHead.add((Component)this.lblCountSelect, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelMain.add((Component)this.panelHead, gridBagConstraints);
        this.panelProjectList.setBackground(new Color(255, 255, 255));
        this.panelProjectList.setAutoscrolls(true);
        this.panelProjectList.setFocusable(false);
        this.panelProjectList.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelMain.add((Component)this.panelProjectList, gridBagConstraints);
        this.panelProjectControls.setBackground(new Color(255, 255, 255));
        this.panelProjectControls.setLayout(new GridBagLayout());
        this.btnCreateProject.setFont(THEMIS.fontButton);
        this.btnCreateProject.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateProject, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnCreateProject.text"));
        this.btnCreateProject.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnCreateProject.toolTipText"));
        this.btnCreateProject.setHorizontalTextPosition(4);
        this.btnCreateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisWelcomeTopComponent.this.btnCreateProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProjectControls.add((Component)this.btnCreateProject, gridBagConstraints);
        this.btnCopyProject.setFont(THEMIS.fontButton);
        this.btnCopyProject.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopyProject, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnCopyProject.text"));
        this.btnCopyProject.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnCopyProject.toolTipText"));
        this.btnCopyProject.setHorizontalTextPosition(4);
        this.btnCopyProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisWelcomeTopComponent.this.btnCopyProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProjectControls.add((Component)this.btnCopyProject, gridBagConstraints);
        this.btnDeleteProject.setFont(THEMIS.fontButton);
        this.btnDeleteProject.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteProject, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnDeleteProject.text"));
        this.btnDeleteProject.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnDeleteProject.toolTipText"));
        this.btnDeleteProject.setHorizontalTextPosition(4);
        this.btnDeleteProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisWelcomeTopComponent.this.btnDeleteProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProjectControls.add((Component)this.btnDeleteProject, gridBagConstraints);
        this.btnEditProject.setFont(THEMIS.fontButton);
        this.btnEditProject.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEditProject, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnEditProject.text"));
        this.btnEditProject.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnEditProject.toolTipText"));
        this.btnEditProject.setHorizontalTextPosition(4);
        this.btnEditProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisWelcomeTopComponent.this.btnEditProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProjectControls.add((Component)this.btnEditProject, gridBagConstraints);
        this.btnSelectAction.setFont(new Font("Tahoma", 1, 11));
        this.btnSelectAction.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/menu_options24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectAction, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnSelectAction.text"));
        this.btnSelectAction.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnSelectAction.toolTipText"));
        this.btnSelectAction.setDisabledIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/menu_options_disabled24.gif")));
        this.btnSelectAction.setEnabled(false);
        this.btnSelectAction.setHorizontalTextPosition(10);
        this.btnSelectAction.setMinimumSize(null);
        this.btnSelectAction.setPreferredSize(null);
        this.btnSelectAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisWelcomeTopComponent.this.btnSelectActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.panelProjectControls.add((Component)this.btnSelectAction, gridBagConstraints);
        this.chkIncludSubfolder.setBackground(new Color(255, 255, 255));
        this.chkIncludSubfolder.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkIncludSubfolder, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.chkIncludSubfolder.text"));
        this.chkIncludSubfolder.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.chkIncludSubfolder.toolTipText"));
        this.chkIncludSubfolder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemisWelcomeTopComponent.this.chkIncludSubfolderItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProjectControls.add((Component)this.chkIncludSubfolder, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.empty, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.empty.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panelProjectControls.add((Component)this.empty, gridBagConstraints);
        this.btnLoadThemisFile.setFont(THEMIS.fontButton);
        this.btnLoadThemisFile.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/openFile_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLoadThemisFile, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnLoadThemisFile.text"));
        this.btnLoadThemisFile.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnLoadThemisFile.toolTipText"));
        this.btnLoadThemisFile.setHorizontalTextPosition(4);
        this.btnLoadThemisFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisWelcomeTopComponent.this.btnLoadThemisFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelProjectControls.add((Component)this.btnLoadThemisFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelMain.add((Component)this.panelProjectControls, gridBagConstraints);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.jScrollPane2.setMinimumSize(new Dimension(150, 150));
        this.jScrollPane2.setOpaque(false);
        this.jScrollPane2.setPreferredSize(new Dimension(150, 150));
        this.panelDetails.setLayout(new GridBagLayout());
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblDetailImage, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblDetailImage.text"));
        this.lblDetailImage.setMinimumSize(new Dimension(120, 80));
        this.lblDetailImage.setPreferredSize(new Dimension(120, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblDetailImage, gridBagConstraints);
        this.btnOpenProject.setFont(THEMIS.fontButton);
        this.btnOpenProject.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_openProject24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenProject, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnOpenProject.text"));
        this.btnOpenProject.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnOpenProject.toolTipText"));
        this.btnOpenProject.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnOpenProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panelDetails.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblDetailTitel.setFont(THEMIS.fontLabelBigBold);
        Mnemonics.setLocalizedText((JLabel)this.lblDetailTitel, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblDetailTitel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblDetailTitel, gridBagConstraints);
        this.lbl1.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.lbl1, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lbl1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lbl1, gridBagConstraints);
        this.lblDetailFolder.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.lblDetailFolder, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblDetailFolder.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblDetailFolder, gridBagConstraints);
        this.lbl2.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.lbl2, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lbl2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lbl2, gridBagConstraints);
        this.lblDetailCreated.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.lblDetailCreated, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblDetailCreated.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblDetailCreated, gridBagConstraints);
        this.lbl3.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.lbl3, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lbl3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lbl3, gridBagConstraints);
        this.lblDetailLastAccess.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.lblDetailLastAccess, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblDetailLastAccess.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblDetailLastAccess, gridBagConstraints);
        this.lbl4.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.lbl4, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lbl4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lbl4, gridBagConstraints);
        this.lblDetailLastEvent.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.lblDetailLastEvent, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblDetailLastEvent.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblDetailLastEvent, gridBagConstraints);
        this.lbl5.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.lbl5, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lbl5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lbl5, gridBagConstraints);
        this.lblDetailNextEvent.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.lblDetailNextEvent, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblDetailNextEvent.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblDetailNextEvent, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panelDetails.add((Component)this.jPanel1, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.panelDetails);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panelMain.add((Component)this.jScrollPane2, gridBagConstraints);
        this.panelThemisInfo.setBackground(new Color(255, 255, 255));
        this.panelThemisInfo.setMinimumSize(new Dimension(240, 100));
        this.panelThemisInfo.setPreferredSize(new Dimension(240, 100));
        this.panelThemisInfo.setLayout(new GridBagLayout());
        this.lblLogo.setHorizontalAlignment(0);
        this.lblLogo.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/logo_THEMIS_200_rgb.jpg")));
        Mnemonics.setLocalizedText((JLabel)this.lblLogo, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblLogo.text"));
        this.lblLogo.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblLogo.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelThemisInfo.add((Component)this.lblLogo, gridBagConstraints);
        this.lblThemisVersion.setFont(THEMIS.fontLabelBigBold);
        this.lblThemisVersion.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblThemisVersion, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblThemisVersion.text"));
        this.lblThemisVersion.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelThemisInfo.add((Component)this.lblThemisVersion, gridBagConstraints);
        this.lblThemisUpdate.setFont(THEMIS.fontLabelBigBold);
        this.lblThemisUpdate.setForeground(Color.red);
        this.lblThemisUpdate.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblThemisUpdate, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.lblThemisUpdate.text"));
        this.lblThemisUpdate.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelThemisInfo.add((Component)this.lblThemisUpdate, gridBagConstraints);
        this.btnNoLicense.setFont(THEMIS.fontLabelBig);
        this.btnNoLicense.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/key24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNoLicense, (String)NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnNoLicense.text"));
        this.btnNoLicense.setToolTipText(NbBundle.getMessage(ThemisWelcomeTopComponent.class, (String)"ThemisWelcomeTopComponent.btnNoLicense.toolTipText"));
        this.btnNoLicense.setBorder(new SoftBevelBorder(0));
        this.btnNoLicense.setIconTextGap(10);
        this.btnNoLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisWelcomeTopComponent.this.btnNoLicenseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelThemisInfo.add((Component)this.btnNoLicense, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panelMain.add((Component)this.panelThemisInfo, gridBagConstraints);
        this.splitMain.setRightComponent(this.panelMain);
        this.add(this.splitMain, "Center");
    }

    private void chkIncludSubfolderItemStateChanged(ItemEvent evt) {
        if (this.listSource == ListSource.FOLDER) {
            this.populateProjectListFromFolder(this.selectedFolder);
        }
    }

    private void copyProject() {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        ArrayList<ThemisFolder> sels = this.projectListManager.getSelection();
        if (sels == null || sels.size() == 0 || sels.size() > 1) {
            return;
        }
        ProjectHelper.copyProject(sels.get(0));
        this.populateProjectList();
    }

    private void deleteProject() {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        ArrayList<ThemisFolder> sels = this.projectListManager.getSelection();
        if (sels == null || sels.size() == 0) {
            return;
        }
        ArrayList<String> deleted = ProjectHelper.deleteProjects(sels);
        for (ThemisFolder f : sels) {
            if (!deleted.contains(f.getUUID())) continue;
            this.app.updateRecentProjectList(f.getProjectFolder(), true);
        }
        this.populateProjectList();
    }

    private void editProject() {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        ArrayList<ThemisFolder> sels = this.projectListManager.getSelection();
        if (sels == null || sels.size() == 0 || sels.size() > 1) {
            return;
        }
        ThemisLock projectLock = sels.get(0).getProjectLock();
        if (projectLock.isLocked()) {
            Dialogs.getInstance().showErrorDialog("error.project-locked-no-rename", sels.get(0).getFolderName());
            return;
        }
        ProjectHelper.renameProject(sels.get(0));
        this.populateProjectList();
    }

    private void btnSelectActionActionPerformed(ActionEvent evt) {
        String projectlist;
        ArrayList<ThemisFolder> sels = this.projectListManager.getSelection();
        if (sels == null || sels.isEmpty()) {
            return;
        }
        JPopupMenu menu = new JPopupMenu(this.project.getResourceText("menu.welcome.options"));
        JMenuItem item = THEMIS.createMenuItem(this.project.getResourceText("menu.welcome.move"), Color.WHITE, false, null);
        item.addActionListener(e -> {
            if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
                return;
            }
            ProjectHelper.moveProjects(sels);
            this.populateProjectList();
        });
        menu.add(item);
        item = THEMIS.createMenuItem(this.project.getResourceText("menu.welcome.save-as-szip"), Color.WHITE, false, null);
        item.addActionListener(e -> {
            if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
                return;
            }
            if (sels == null || sels.isEmpty()) {
                return;
            }
            File firstSel = ((ThemisFolder)sels.get(0)).getProjectFolder().getParentFile();
            File folder = new ThemisFileDialog("Order ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, firstSel, null, THEMIS.getFolderFilter(), null, false).getSelectedFile();
            if (folder != null) {
                ThemisTaskWithDialog.createTaskWithCounterAndCancel("task.project-save-as-zip.title", ph -> {
                    for (ThemisFolder themis : sels) {
                        String projectfile = themis.getFolderName();
                        File fDest = new File(folder, projectfile + ".zip");
                        int counter = 2;
                        while (fDest.exists()) {
                            fDest = new File(folder, projectfile + counter + ".zip");
                            ++counter;
                        }
                        ThemisUtil.exportProjectAsZip((ThemisFolder)themis, (File)fDest, (boolean)false, (ProgressHandler)ph);
                        if (ph.isCancelled()) {
                            return;
                        }
                        THEMIS.showFileResultDialog(fDest, false);
                    }
                });
            }
        });
        menu.add(item);
        if (LicenseUtils.isClientEquals((LicenseUtils.Client)LicenseUtils.Client.GRID_IT) || LicenseUtils.isClientEquals((LicenseUtils.Client)LicenseUtils.Client.WIENERWOHNEN)) {
            item = THEMIS.createMenuItem(this.project.getResourceText("menu.welcome.clean-up"), Color.WHITE, false, null);
            item.addActionListener(e -> {
                if (sels == null || sels.isEmpty()) {
                    return;
                }
                if (!Dialogs.getInstance().showConfirmDialog("ask.cleanup-projects")) {
                    return;
                }
                File firstSel = ((ThemisFolder)sels.get(0)).getProjectFolder().getParentFile();
                File folder = new ThemisFileDialog("Order ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, firstSel, null, THEMIS.getFolderFilter(), null, false).getSelectedFile();
                if (folder != null) {
                    ThemisTaskWithDialog.createTaskWithCounterAndCancel("task.project-clean-up.title", ph -> {
                        ph.switchToDeterminate(sels.size() * 4);
                        for (ThemisFolder themis : sels) {
                            ph.progress("'" + themis.getFolderName() + "' wird gesichert");
                            ph.increaseProgress(1);
                            String projectfile = themis.getFolderName();
                            File fDest = new File(folder, projectfile + ".zip");
                            ThemisUtil.exportProjectAsZip((ThemisFolder)themis, (File)fDest, (boolean)false, (ProgressHandler)ph);
                            if (ph.isCancelled()) {
                                return;
                            }
                            ThemisLock projectLock = themis.getProjectLock();
                            if (projectLock.isLocked()) continue;
                            ph.progress("'" + themis.getFolderName() + "' wird ge\u00f6ffnet");
                            ph.increaseProgress(1);
                            this.project.getLogger().info("... updating project " + themis.getProjectFolder().getAbsolutePath());
                            this.project.open(themis, null, null, false, ThemisUtil.isOnNetworkDrive((File)themis.getProjectFolder()), false, false, false, null);
                            if (!this.project.isOpen()) continue;
                            ph.progress("'" + themis.getFolderName() + "' Fotos werden reduziert");
                            ph.increaseProgress(1);
                            int pixel = this.app.getSettings().getImageUploadSize();
                            float quality = this.app.getSettings().getImageUploadQuality();
                            ArrayList files = ThemisUtil.getImageFiles((ThemisFolder)this.project.getThemisFile(), (int)pixel);
                            ThemisUtil.updateImage((ArrayList)files, (int)pixel, (float)(100.0f * quality), null);
                            ph.progress("'" + themis.getFolderName() + "' nicht ben\u00f6tigte Dateien werden gel\u00f6scht");
                            ph.increaseProgress(1);
                            ThemisUtil.removeUnusedUploads();
                            this.project.close(new Closing().withoutAsking().withoutExport().withoutTrigger(), null);
                        }
                    });
                }
            });
            menu.add(item);
        }
        if (LicenseUtils.isClientEquals((LicenseUtils.Client)LicenseUtils.Client.GRID_IT) || LicenseUtils.isClientEquals((LicenseUtils.Client)LicenseUtils.Client.WIENERWOHNEN)) {
            item = THEMIS.createMenuItem(this.project.getResourceText("menu.welcome.export-project"), Color.WHITE, false, null);
            item.addActionListener(e -> {
                if (sels == null || sels.isEmpty()) {
                    return;
                }
                File firstSel = ((ThemisFolder)sels.get(0)).getProjectFolder().getParentFile();
                File folder = new ThemisFileDialog("Order ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, firstSel, null, THEMIS.getFolderFilter(), null, false).getSelectedFile();
                if (folder != null) {
                    ThemisTaskWithDialog.createTaskWithCounterAndCancel("task.project-export.title", ph -> {
                        ph.switchToDeterminate(sels.size());
                        for (ThemisFolder themis : sels) {
                            ThemisLock projectLock = themis.getProjectLock();
                            if (projectLock.isLocked()) continue;
                            ph.progress("'" + themis.getFolderName() + "' wird bearbeitet");
                            ph.increaseProgress(1);
                            String projectfile = themis.getFolderName();
                            File fDest = new File(folder, projectfile + ".themis");
                            ThemisUtil.exportProjectAsThemisFile((ThemisFolder)themis, (File)fDest, (boolean)false, (ProgressHandler)ph);
                            if (!ph.isCancelled()) continue;
                            return;
                        }
                    });
                }
            });
            menu.add(item);
        }
        item = THEMIS.createMenuItem(this.project.getResourceText("menu.welcome.update-template"), Color.WHITE, false, null);
        item.addActionListener(e -> {
            if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
                return;
            }
            if (sels == null || sels.isEmpty()) {
                return;
            }
            this.project.getLogger().info("starting updating project template...");
            LoadSettingsPanel p = new LoadSettingsPanel(sels);
            p.showDialog();
        });
        menu.add(item);
        item = THEMIS.createMenuItem(this.project.getResourceText("menu.welcome.configure-server"), Color.WHITE, false, null);
        item.addActionListener(e -> {
            if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
                return;
            }
            sels.sort((o1, o2) -> o1.getFolderName().compareTo(o2.getFolderName()));
            JavaFxSwingDialog dlg = new JavaFxSwingDialog("configure-server-fx", 800, 500);
            ConfigureServerFxPanel panel = new ConfigureServerFxPanel().populate((List)sels);
            JavaFxDialog fx = new JavaFxDialog((Node)panel);
            fx.addCancelButton("Schlie\u00dfen");
            dlg.setContent((Node)fx);
            dlg.show();
        });
        menu.add(item);
        item = THEMIS.createMenuItem("Statistik", Color.WHITE, false, null);
        item.addActionListener(e -> {
            ProjectStatisticsPanel p = new ProjectStatisticsPanel();
            p.addProject(sels);
            p.showDialog();
        });
        menu.add(item);
        menu.add(THEMIS.createSeparator(Color.WHITE));
        item = THEMIS.createMenuItem(this.project.getResourceText("menu.welcome.checkout"), Color.WHITE, false, null);
        item.addActionListener(e -> {
            if (sels == null || sels.isEmpty()) {
                return;
            }
            ArrayList errors = new ArrayList();
            ThemisTaskWithDialog.createTaskWithCounterAndCancel("task.project-checkout.title", ph -> {
                for (ThemisFolder themis : sels) {
                    String result = null;
                    boolean isOnNetwork = themis.isOnNetwork();
                    if (!themis.isOnNetwork()) {
                        errors.add(this.project.getResourceText("error.project-not-on-network", new String[]{themis.getFolderName()}));
                    } else if (themis.getProjectLock().isLocked()) {
                        errors.add(this.project.getResourceText("error.project-locked-no-checkout", new String[]{themis.getFolderName()}));
                    } else {
                        result = ThemisApplication.getInstance().getProject().checkoutProject(themis, ph);
                    }
                    if (ph.isCancelled()) {
                        return;
                    }
                    if (result == null) continue;
                    ThemisApplication.getInstance().getDialog().showErrorDialog(result);
                }
            });
            if (!errors.isEmpty()) {
                if (errors.size() == 1) {
                    Dialogs.getInstance().showErrorDialog((String)errors.get(0));
                } else {
                    Dialogs.getInstance().showErrorDialog("- " + String.join((CharSequence)"<br>- ", errors));
                }
            }
        });
        menu.add(item);
        item = THEMIS.createMenuItem(this.project.getResourceText("menu.welcome.writeback"), Color.WHITE, false, null);
        item.addActionListener(e -> {
            if (sels == null || sels.isEmpty()) {
                return;
            }
            ArrayList errors = new ArrayList();
            ThemisTaskWithDialog.createTaskWithCounterAndCancel("task.project-write-back.title", ph -> {
                for (ThemisFolder themis : sels) {
                    String result = null;
                    if (themis.isLocal()) {
                        boolean success = ThemisApplication.getInstance().getProject().restoreFromLocalToProject(themis);
                        if (success) {
                            themis.deleteProjectLock();
                            ThemisApplication.getInstance().getDialog().showInfoDialog("info.network.project-saved-back");
                        } else {
                            ThemisApplication.getInstance().getDialog().showErrorDialog("error.network.cannot-save-back");
                        }
                    } else {
                        errors.add(this.project.getResourceText("error.project-has-no-local-copy", new String[]{themis.getFolderName()}));
                    }
                    if (ph.isCancelled()) {
                        return;
                    }
                    if (result == null) continue;
                    ThemisApplication.getInstance().getDialog().showErrorDialog(result);
                }
            });
            if (!errors.isEmpty()) {
                if (errors.size() == 1) {
                    Dialogs.getInstance().showErrorDialog((String)errors.get(0));
                } else {
                    Dialogs.getInstance().showErrorDialog("- " + String.join((CharSequence)"<br>- ", errors));
                }
            }
        });
        menu.add(item);
        item = THEMIS.createMenuItem(this.project.getResourceText("menu.welcome.delete-local"), Color.WHITE, false, null);
        item.addActionListener(e -> {
            if (sels == null || sels.isEmpty()) {
                return;
            }
            ArrayList errors = new ArrayList();
            ThemisTaskWithDialog.createTaskWithCounterAndCancel("task.project-delete-local.title", ph -> {
                for (ThemisFolder themis : sels) {
                    String result = null;
                    if (themis.isLocal()) {
                        themis.deleteLocal();
                        themis.deleteProjectLock();
                    } else {
                        errors.add(this.project.getResourceText("error.project-has-no-local-copy", new String[]{themis.getFolderName()}));
                    }
                    if (ph.isCancelled()) {
                        return;
                    }
                    if (result == null) continue;
                    ThemisApplication.getInstance().getDialog().showErrorDialog(result);
                }
            });
            if (!errors.isEmpty()) {
                if (errors.size() == 1) {
                    Dialogs.getInstance().showErrorDialog((String)errors.get(0));
                } else {
                    Dialogs.getInstance().showErrorDialog("- " + String.join((CharSequence)"<br>- ", errors));
                }
            }
        });
        menu.add(item);
        menu.add(THEMIS.createSeparator(Color.WHITE));
        JMenu submenu = THEMIS.createMenu(this.project.getResourceText("menu.welcome.add-to-projectlist"), Color.WHITE, false, null);
        for (String projectlist2 : this.app.getSettings().getProjectLists()) {
            item = THEMIS.createMenuItem(projectlist2, Color.WHITE, false, null);
            item.addActionListener(e -> sels.forEach(tf -> this.app.getSettings().addProjectToList(projectlist2, tf)));
            submenu.add(item);
        }
        menu.add(submenu);
        if (this.listSource == ListSource.LIST && !LIST_LASTUSED.equals(projectlist = this.currentList) && !LIST_LOCAL.equals(projectlist)) {
            item = THEMIS.createMenuItem(this.project.getResourceText("menu.welcome.remove-from-projectlist") + ": '" + projectlist + "'", Color.WHITE, false, null);
            item.addActionListener(e -> {
                sels.forEach(tf -> this.app.getSettings().removeProjectFromList(projectlist, tf));
                this.populateProjectList();
            });
            menu.add(item);
        }
        if (sels.size() == 1) {
            menu.add(THEMIS.createSeparator(Color.WHITE));
            item = THEMIS.createMenuItem("Ordner zeigen", Color.WHITE, false, null);
            item.addActionListener(e2 -> {
                File f0 = ((ThemisFolder)sels.get(0)).getProjectFolder();
                if (f0 != null) {
                    File f = f0.getParentFile();
                    try {
                        Desktop.getDesktop().open(f);
                    }
                    catch (IOException ex) {
                        ThemisApplication.getInstance().getDialog().showErrorDialog("Der Ordner '" + f.getAbsolutePath() + "' kann nicht ge\u00f6ffnet werden.");
                    }
                }
            });
            menu.add(item);
        }
        int c = menu.getComponentCount();
        menu.show(this.btnSelectAction, this.btnSelectAction.getWidth(), 0);
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        String sel = this.lstProjectLists.getSelectedValue();
        if (sel != null) {
            this.renameProjectCollection(sel);
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        String sel = this.lstProjectLists.getSelectedValue();
        if (sel != null) {
            this.deleteProjectCollection(sel);
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        this.createNewProjectCollection();
    }

    private void btnNoLicenseActionPerformed(ActionEvent evt) {
        new ThemisLicensePanel().showDialog();
    }

    private void lstProjectListsValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            String sel = this.lstProjectLists.getSelectedValue();
            if (sel != null) {
                if (this.explorer != null) {
                    this.explorer.clearSelection();
                }
                this.populateProjectListFromCollection(sel);
                switch (sel) {
                    case "Zuletzt verwendet": 
                    case "Ausgecheckte Projekte": {
                        break;
                    }
                    default: {
                        this.btnEdit.setEnabled(true);
                        this.btnRemove.setEnabled(true);
                    }
                }
            }
        }
    }

    private void btnCreateProjectActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        ThemisFolder folder = this.selectedFolder;
        this.createProject(folder);
    }

    private void btnCopyProjectActionPerformed(ActionEvent evt) {
        this.copyProject();
    }

    private void btnDeleteProjectActionPerformed(ActionEvent evt) {
        this.deleteProject();
    }

    private void btnEditProjectActionPerformed(ActionEvent evt) {
        this.editProject();
    }

    private void btnLoadThemisFileActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        File f = new ThemisFileDialog("*.themis Datei ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getCurrentFolder(), null, THEMIS.getThemisFileFilter(), null, false).getSelectedFile();
        if (f == null) {
            return;
        }
        this.app.setCurrentFolder(f.getParentFile());
        ThemisFile tf = new ThemisFile().setAsFullProject();
        ThemisTaskWithDialog.createTask("loading-themis-file", ph -> {
            try {
                ThemisFileImportSummary result = tf.loadFromFile(f, true);
                if (!result.hasError()) {
                    SwingUtilities.invokeLater(() -> {
                        this.saveSplitSettings();
                        ViewHelper.showOpenProject();
                        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PROJECT_OPENED);
                    });
                }
            }
            catch (IOException iOException) {
            }
            catch (JDOMException jDOMException) {
                // empty catch block
            }
        });
    }

    public void componentOpened() {
        this.revalidate();
        this.requestActive();
        this.applySplitSettings();
    }

    public void componentClosed() {
        this.saveSplitSettings();
    }

    public void applySplitSettings() {
        double f1 = this.app.getSettings().getWelcomeScreenSplitMain();
        f1 = Math.max(Math.min(f1, 0.9), 0.1);
        double f2 = this.app.getSettings().getWelcomeScreenSplitLeft();
        f2 = Math.max(Math.min(f2, 0.9), 0.1);
        this.splitMain.setDividerLocation(f1);
        this.splitLeft.setDividerLocation(f2);
        this.splitMain.revalidate();
        this.splitMain.repaint();
        this.splitLeft.revalidate();
        this.splitLeft.repaint();
    }

    public void saveSplitSettings() {
        double v1 = (double)this.splitMain.getDividerLocation() / (double)this.splitMain.getWidth();
        double v2 = (double)this.splitLeft.getDividerLocation() / (double)this.splitLeft.getHeight();
        this.app.getSettings().setWelcomeScreenSplitMain(v1);
        this.app.getSettings().setWelcomeScreenSplitLeft(v2);
    }

    public void componentShowing() {
        this.populateProjectList();
        this.updateLicenseDisplay();
        if (this.app.getProject().isOpen()) {
            ViewHelper.showOpenProject();
        }
    }

    private void updateLicenseDisplay() {
        boolean flgLicense = this.app.getLicense().hasLicense();
        this.btnNoLicense.setVisible(!flgLicense);
        this.btnCreateProject.setVisible(flgLicense);
        this.btnDeleteProject.setVisible(flgLicense);
        this.btnCopyProject.setVisible(flgLicense);
        this.btnEditProject.setVisible(flgLicense);
        this.btnSelectAction.setVisible(flgLicense);
        this.btnLoadThemisFile.setVisible(LicenseUtils.isClientEquals((LicenseUtils.Client)LicenseUtils.Client.GRID_IT) || LicenseUtils.isClientEquals((LicenseUtils.Client)LicenseUtils.Client.WIENERWOHNEN));
    }

    protected void componentActivated() {
        ViewHelper.closeIDELog();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    class TreeRootObject {
        String label = null;
        ThemisFolder folder = null;

        public TreeRootObject(String txt) {
            this.label = txt;
        }

        public TreeRootObject(ThemisFolder f) {
            this.folder = f;
        }

        public boolean isFolder() {
            return this.folder != null;
        }

        public String toString() {
            return this.label == null ? this.folder.getFolderName() : this.label;
        }
    }

    private static enum ListSource {
        FOLDER,
        LIST,
        RECENT;

    }
}

